/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedLocalComponentsResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.GraphValidationException;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;

public class DefaultResolverResults
implements ResolverResults {
    private final ResolvedLocalComponentsResult resolvedLocalComponentsResult;
    private final ResolutionResult resolutionResult;
    private final ResolvedConfiguration resolvedConfiguration;
    private final VisitedArtifactSet visitedArtifacts;
    private final ArtifactResolveState artifactResolveState;
    private final ResolveException failure;

    public DefaultResolverResults(@Nullable ResolvedLocalComponentsResult resolvedLocalComponentsResult, @Nullable ResolutionResult resolutionResult, VisitedArtifactSet visitedArtifacts, @Nullable ResolvedConfiguration resolvedConfiguration, @Nullable ArtifactResolveState artifactResolveState, @Nullable ResolveException failure) {
        this.resolvedLocalComponentsResult = resolvedLocalComponentsResult;
        this.resolutionResult = resolutionResult;
        this.visitedArtifacts = visitedArtifacts;
        this.resolvedConfiguration = resolvedConfiguration;
        this.artifactResolveState = artifactResolveState;
        this.failure = failure;
    }

    @Override
    public boolean hasError() {
        if (this.failure != null) {
            return true;
        }
        return this.resolvedConfiguration != null && this.resolvedConfiguration.hasError();
    }

    @Override
    public ResolvedConfiguration getResolvedConfiguration() {
        if (this.resolvedConfiguration == null) {
            throw new IllegalStateException("Cannot get ResolvedConfiguration before graph resolution.");
        }
        return this.resolvedConfiguration;
    }

    @Override
    public ResolutionResult getResolutionResult() {
        this.maybeRethrowFatalError();
        return this.resolutionResult;
    }

    @Override
    public ResolvedLocalComponentsResult getResolvedLocalComponents() {
        this.maybeRethrowFatalError();
        return this.resolvedLocalComponentsResult;
    }

    @Override
    public ArtifactResolveState getArtifactResolveState() {
        this.maybeRethrowAnyError();
        return this.artifactResolveState;
    }

    @Override
    public VisitedArtifactSet getVisitedArtifacts() {
        this.maybeRethrowFatalError();
        return this.visitedArtifacts;
    }

    public void maybeRethrowFatalError() {
        if (this.failure != null && DefaultResolverResults.isFatalError(this.failure)) {
            throw this.failure;
        }
    }

    private static boolean isFatalError(ResolveException failure) {
        boolean isNonFatal = failure.getCause() instanceof GraphValidationException;
        return !isNonFatal;
    }

    private void maybeRethrowAnyError() {
        if (this.failure != null) {
            throw this.failure;
        }
    }

    @Override
    public Throwable getNonFatalFailure() {
        return this.failure != null && !DefaultResolverResults.isFatalError(this.failure) ? this.failure : null;
    }

    @Override
    public ResolveException getFailure() {
        return this.failure;
    }

    @Override
    public ResolverResults withFailure(ResolveException resolveException) {
        return new DefaultResolverResults(this.resolvedLocalComponentsResult, this.resolutionResult, this.visitedArtifacts, this.resolvedConfiguration, this.artifactResolveState, resolveException);
    }

    @Override
    public ResolverResults updateResolutionResult(Function<ResolutionResult, ResolutionResult> updater) {
        return new DefaultResolverResults(this.resolvedLocalComponentsResult, updater.apply(this.resolutionResult), this.visitedArtifacts, this.resolvedConfiguration, this.artifactResolveState, this.failure);
    }

    public static ResolverResults buildDependenciesResolved(ResolutionResult resolutionResult, ResolvedLocalComponentsResult resolvedLocalComponentsResult, VisitedArtifactSet visitedArtifacts) {
        return new DefaultResolverResults(resolvedLocalComponentsResult, resolutionResult, visitedArtifacts, null, null, null);
    }

    public static ResolverResults graphResolved(ResolutionResult resolutionResult, ResolvedLocalComponentsResult resolvedLocalComponentsResult, VisitedArtifactSet visitedArtifacts, @Nullable ArtifactResolveState artifactResolveState) {
        return new DefaultResolverResults(resolvedLocalComponentsResult, resolutionResult, visitedArtifacts, null, artifactResolveState, null);
    }

    public static ResolverResults artifactsResolved(ResolutionResult resolutionResult, ResolvedLocalComponentsResult localComponentsResult, ResolvedConfiguration resolvedConfiguration, VisitedArtifactSet visitedArtifacts) {
        return new DefaultResolverResults(localComponentsResult, resolutionResult, visitedArtifacts, resolvedConfiguration, null, null);
    }

    public static ResolverResults failed(Exception failure, ResolveException contextualizedFailure) {
        BrokenResolvedConfiguration broken = new BrokenResolvedConfiguration(failure, contextualizedFailure);
        return new DefaultResolverResults(null, null, broken, broken, null, contextualizedFailure);
    }

    public static ResolverResults failed(ResolutionResult resolutionResult, ResolvedLocalComponentsResult localComponentsResult, Exception failure, ResolveException contextualizedFailure) {
        BrokenResolvedConfiguration broken = new BrokenResolvedConfiguration(failure, contextualizedFailure);
        return DefaultResolverResults.artifactsResolved(resolutionResult, localComponentsResult, broken, broken).withFailure(contextualizedFailure);
    }

    private static class BrokenResolvedConfiguration
    implements ResolvedConfiguration,
    VisitedArtifactSet,
    SelectedArtifactSet {
        private final Throwable originalException;
        private final ResolveException contextualizedException;

        public BrokenResolvedConfiguration(Throwable originalException, ResolveException contextualizedException) {
            this.originalException = originalException;
            this.contextualizedException = contextualizedException;
        }

        @Override
        public boolean hasError() {
            return true;
        }

        @Override
        public LenientConfiguration getLenientConfiguration() {
            throw this.contextualizedException;
        }

        @Override
        public void rethrowFailure() throws ResolveException {
            throw this.contextualizedException;
        }

        @Override
        public Set<File> getFiles() throws ResolveException {
            throw this.contextualizedException;
        }

        @Override
        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
            throw this.contextualizedException;
        }

        @Override
        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            throw this.contextualizedException;
        }

        @Override
        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
            throw this.contextualizedException;
        }

        @Override
        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            throw this.contextualizedException;
        }

        @Override
        public SelectedArtifactSet select(Spec<? super Dependency> dependencySpec, AttributeContainerInternal requestedAttributes, Spec<? super ComponentIdentifier> componentSpec, boolean allowNoMatchingVariant, boolean selectFromAllVariants) {
            return this;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            context.visitFailure(this.originalException);
        }

        @Override
        public void visitArtifacts(ArtifactVisitor visitor, boolean continueOnSelectionFailure) {
            visitor.visitFailure(this.originalException);
        }
    }
}

