/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.n3.nanoxml.CDATAReader;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLEntityResolver;
import net.n3.nanoxml.XMLUtil;

public abstract class NonValidator
implements IXMLValidator {
    protected IXMLEntityResolver parameterEntityResolver;
    protected Map<String, Properties> attributeDefaultValues = new HashMap<String, Properties>();
    protected Deque<Properties> currentElements = new ArrayDeque<Properties>();

    public NonValidator() {
        this.parameterEntityResolver = new XMLEntityResolver();
    }

    @Override
    public final void parseDTD(String publicID, StdXMLReader reader, IXMLEntityResolver entityResolver, boolean external) throws Exception {
        if (!external) {
            int cnt = 1;
            char ch = reader.read();
            while (ch != ']' || --cnt != 0) {
                if (ch == '[') {
                    ++cnt;
                }
                ch = reader.read();
            }
        } else {
            char ch;
            int origLevel = reader.getStreamLevel();
            do {
                ch = reader.read();
            } while (reader.getStreamLevel() >= origLevel);
            reader.unread(ch);
            return;
        }
    }

    protected void processElement(StdXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        String str = XMLUtil.read(reader, '%');
        char ch = str.charAt(0);
        if (ch != '!') {
            XMLUtil.skipTag(reader);
            return;
        }
        str = XMLUtil.read(reader, '%');
        ch = str.charAt(0);
        switch (ch) {
            case '-': {
                XMLUtil.skipComment(reader);
                break;
            }
            case '[': {
                this.processConditionalSection(reader);
                break;
            }
            case 'E': {
                this.processEntity(reader, entityResolver);
                break;
            }
            case 'A': {
                this.processAttList(reader);
                break;
            }
            default: {
                XMLUtil.skipTag(reader);
            }
        }
    }

    protected void processConditionalSection(StdXMLReader reader) throws Exception {
        int ch2;
        XMLUtil.skipWhitespace(reader, null);
        String str = XMLUtil.read(reader, '%');
        char ch = str.charAt(0);
        if (ch != 'I') {
            XMLUtil.skipTag(reader);
            return;
        }
        str = XMLUtil.read(reader, '%');
        ch = str.charAt(0);
        switch (ch) {
            case 'G': {
                this.processIgnoreSection(reader);
                return;
            }
            case 'N': {
                break;
            }
            default: {
                XMLUtil.skipTag(reader);
                return;
            }
        }
        if (!XMLUtil.checkLiteral(reader, "CLUDE")) {
            XMLUtil.skipTag(reader);
            return;
        }
        XMLUtil.skipWhitespace(reader, null);
        str = XMLUtil.read(reader, '%');
        ch = str.charAt(0);
        if (ch != '[') {
            XMLUtil.skipTag(reader);
            return;
        }
        CDATAReader subreader = new CDATAReader(reader);
        StringBuilder buf = new StringBuilder(1024);
        while ((ch2 = subreader.read()) >= 0) {
            buf.append((char)ch2);
        }
        ((Reader)subreader).close();
        reader.startNewStream(new StringReader(buf.toString()));
    }

    protected void processIgnoreSection(StdXMLReader reader) throws Exception {
        if (!XMLUtil.checkLiteral(reader, "NORE")) {
            XMLUtil.skipTag(reader);
            return;
        }
        XMLUtil.skipWhitespace(reader, null);
        String str = XMLUtil.read(reader, '%');
        char ch = str.charAt(0);
        if (ch != '[') {
            XMLUtil.skipTag(reader);
            return;
        }
        CDATAReader subreader = new CDATAReader(reader);
        ((Reader)subreader).close();
    }

    protected void processAttList(StdXMLReader reader) throws Exception {
        if (!XMLUtil.checkLiteral(reader, "TTLIST")) {
            XMLUtil.skipTag(reader);
            return;
        }
        XMLUtil.skipWhitespace(reader, null);
        String str = XMLUtil.read(reader, '%');
        char ch = str.charAt(0);
        while (ch == '%') {
            XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
            str = XMLUtil.read(reader, '%');
            ch = str.charAt(0);
        }
        reader.unread(ch);
        String elementName = XMLUtil.scanIdentifier(reader);
        XMLUtil.skipWhitespace(reader, null);
        str = XMLUtil.read(reader, '%');
        ch = str.charAt(0);
        while (ch == '%') {
            XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
            str = XMLUtil.read(reader, '%');
            ch = str.charAt(0);
        }
        Properties props = new Properties();
        while (ch != '>') {
            reader.unread(ch);
            String attName = XMLUtil.scanIdentifier(reader);
            XMLUtil.skipWhitespace(reader, null);
            str = XMLUtil.read(reader, '%');
            ch = str.charAt(0);
            while (ch == '%') {
                XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
                str = XMLUtil.read(reader, '%');
                ch = str.charAt(0);
            }
            if (ch == '(') {
                while (ch != ')') {
                    str = XMLUtil.read(reader, '%');
                    ch = str.charAt(0);
                    while (ch == '%') {
                        XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
                        str = XMLUtil.read(reader, '%');
                        ch = str.charAt(0);
                    }
                }
            } else {
                reader.unread(ch);
                XMLUtil.scanIdentifier(reader);
            }
            XMLUtil.skipWhitespace(reader, null);
            str = XMLUtil.read(reader, '%');
            ch = str.charAt(0);
            while (ch == '%') {
                XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
                str = XMLUtil.read(reader, '%');
                ch = str.charAt(0);
            }
            if (ch == '#') {
                str = XMLUtil.scanIdentifier(reader);
                XMLUtil.skipWhitespace(reader, null);
                if (!str.equals("FIXED")) {
                    XMLUtil.skipWhitespace(reader, null);
                    str = XMLUtil.read(reader, '%');
                    ch = str.charAt(0);
                    while (ch == '%') {
                        XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
                        str = XMLUtil.read(reader, '%');
                        ch = str.charAt(0);
                    }
                    continue;
                }
            } else {
                reader.unread(ch);
            }
            String value = XMLUtil.scanString(reader, '%', this.parameterEntityResolver);
            props.setProperty(attName, value);
            XMLUtil.skipWhitespace(reader, null);
            str = XMLUtil.read(reader, '%');
            ch = str.charAt(0);
            while (ch == '%') {
                XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
                str = XMLUtil.read(reader, '%');
                ch = str.charAt(0);
            }
        }
        if (!props.isEmpty()) {
            this.attributeDefaultValues.put(elementName, props);
        }
    }

    protected void processEntity(StdXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        if (!XMLUtil.checkLiteral(reader, "NTITY")) {
            XMLUtil.skipTag(reader);
            return;
        }
        XMLUtil.skipWhitespace(reader, null);
        char ch = XMLUtil.readChar(reader, '\u0000');
        if (ch == '%') {
            XMLUtil.skipWhitespace(reader, null);
            entityResolver = this.parameterEntityResolver;
        } else {
            reader.unread(ch);
        }
        String key = XMLUtil.scanIdentifier(reader);
        XMLUtil.skipWhitespace(reader, null);
        ch = XMLUtil.readChar(reader, '%');
        String systemID = null;
        String publicID = null;
        switch (ch) {
            case 'P': {
                if (!XMLUtil.checkLiteral(reader, "UBLIC")) {
                    XMLUtil.skipTag(reader);
                    return;
                }
                XMLUtil.skipWhitespace(reader, null);
                publicID = XMLUtil.scanString(reader, '%', this.parameterEntityResolver);
                XMLUtil.skipWhitespace(reader, null);
                systemID = XMLUtil.scanString(reader, '%', this.parameterEntityResolver);
                XMLUtil.skipWhitespace(reader, null);
                XMLUtil.readChar(reader, '%');
                break;
            }
            case 'S': {
                if (!XMLUtil.checkLiteral(reader, "YSTEM")) {
                    XMLUtil.skipTag(reader);
                    return;
                }
                XMLUtil.skipWhitespace(reader, null);
                systemID = XMLUtil.scanString(reader, '%', this.parameterEntityResolver);
                XMLUtil.skipWhitespace(reader, null);
                XMLUtil.readChar(reader, '%');
                break;
            }
            case '\"': 
            case '\'': {
                reader.unread(ch);
                String value = XMLUtil.scanString(reader, '%', this.parameterEntityResolver);
                entityResolver.addInternalEntity(key, value);
                XMLUtil.skipWhitespace(reader, null);
                XMLUtil.readChar(reader, '%');
                break;
            }
            default: {
                XMLUtil.skipTag(reader);
            }
        }
        if (systemID != null) {
            entityResolver.addExternalEntity(key, publicID, systemID);
        }
    }

    @Override
    public void elementStarted(String name, String systemId, int lineNr) {
        Properties attribs = this.attributeDefaultValues.get(name);
        attribs = attribs == null ? new Properties() : (Properties)attribs.clone();
        this.currentElements.push(attribs);
    }

    @Override
    public void elementAttributesProcessed(String name, Properties extraAttributes, String systemId, int lineNr) {
        Properties props = this.currentElements.pop();
        extraAttributes.putAll((Map<?, ?>)props);
    }

    @Override
    public void attributeAdded(String key, String value, String systemId, int lineNr) {
        this.currentElements.peek().remove(key);
    }
}

