/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.frontend.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavadocFixer;
import com.intellij.codeInsight.editorActions.smartEnter.AfterSemicolonEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.BlockBraceFixer;
import com.intellij.codeInsight.editorActions.smartEnter.CatchDeclarationFixer;
import com.intellij.codeInsight.editorActions.smartEnter.CommentBreakerEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.DoWhileConditionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.EnumFieldFixer;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.ForStatementFixer;
import com.intellij.codeInsight.editorActions.smartEnter.IfConditionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.LeaveCodeBlockEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.LiteralFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingArrayConstructorBracketFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingArrayInitializerBraceFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingCatchBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingClassBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingIfBranchesFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingLambdaBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingLoopBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingMethodBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingReturnExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingSwitchBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingSynchronizedBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingThrowExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingTryBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.ParameterListFixer;
import com.intellij.codeInsight.editorActions.smartEnter.ParenthesizedFixer;
import com.intellij.codeInsight.editorActions.smartEnter.PlainEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SwitchExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.TernaryColonFixer;
import com.intellij.codeInsight.editorActions.smartEnter.WhileConditionFixer;
import com.intellij.java.frontend.codeInsight.editorActions.smartEnter.FrontendJavadocFixer;
import com.intellij.java.frontend.codeInsight.editorActions.smartEnter.FrontendMethodCallFixer;
import com.intellij.java.frontend.codeInsight.editorActions.smartEnter.FrontendSemicolonFixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrontendJavaSmartEnterProcessor
extends AbstractBasicJavaSmartEnterProcessor {
    private static final List<Fixer> ourFixers = List.of(new Fixer[]{new LiteralFixer(), new FrontendMethodCallFixer(), new IfConditionFixer(), new ForStatementFixer(), new TernaryColonFixer(), new WhileConditionFixer(), new CatchDeclarationFixer(), new SwitchExpressionFixer(), new DoWhileConditionFixer(), new BlockBraceFixer(), new MissingIfBranchesFixer(), new MissingTryBodyFixer(), new MissingSwitchBodyFixer(), new MissingLambdaBodyFixer(), new MissingCatchBodyFixer(), new MissingSynchronizedBodyFixer(), new MissingLoopBodyFixer(), new ParameterListFixer(), new MissingMethodBodyFixer(), new MissingClassBodyFixer(), new MissingReturnExpressionFixer(), new MissingThrowExpressionFixer(), new ParenthesizedFixer(), new FrontendSemicolonFixer(), new MissingArrayInitializerBraceFixer(), new MissingArrayConstructorBracketFixer(), new EnumFieldFixer()});
    private static final EnterProcessor[] ourEnterProcessors = new EnterProcessor[]{new CommentBreakerEnterProcessor(), new AfterSemicolonEnterProcessor(), new LeaveCodeBlockEnterProcessor(), new PlainEnterProcessor()};
    private static final EnterProcessor[] ourAfterCompletionEnterProcessors = new EnterProcessor[]{new AfterSemicolonEnterProcessor(), new PlainEnterProcessor(){

        public boolean doEnter(@NotNull Editor editor, @NotNull ASTNode astNode, boolean isModified) {
            if (editor == null) {
                1.$$$reportNull$$$0(0);
            }
            if (astNode == null) {
                1.$$$reportNull$$$0(1);
            }
            return PlainEnterProcessor.expandCodeBlock((Editor)editor, (ASTNode)astNode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "astNode";
                    break;
                }
            }
            objectArray[1] = "com/intellij/java/frontend/codeInsight/editorActions/smartEnter/FrontendJavaSmartEnterProcessor$1";
            objectArray[2] = "doEnter";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }};

    public FrontendJavaSmartEnterProcessor() {
        super(ourFixers, ourEnterProcessors, ourAfterCompletionEnterProcessors, (AbstractBasicJavadocFixer)new FrontendJavadocFixer(), (EnterProcessor)new CommentBreakerEnterProcessor());
    }

    protected void log(@NotNull Fixer fixer, @NotNull Project project) {
        if (fixer == null) {
            FrontendJavaSmartEnterProcessor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FrontendJavaSmartEnterProcessor.$$$reportNull$$$0(1);
        }
    }

    protected boolean isImportStatementBase(PsiElement el) {
        ASTNode node = BasicJavaAstTreeUtil.toNode((PsiElement)el);
        return BasicJavaAstTreeUtil.is((ASTNode)node, (IElementType)BasicJavaElementType.BASIC_IMPORT_STATEMENT) || BasicJavaAstTreeUtil.is((ASTNode)node, (IElementType)BasicJavaElementType.BASIC_IMPORT_STATIC_STATEMENT);
    }

    public void reformat(@NotNull Editor editor, @Nullable PsiElement atCaretElement) throws IncorrectOperationException {
        String elementText;
        if (editor == null) {
            FrontendJavaSmartEnterProcessor.$$$reportNull$$$0(2);
        }
        if (atCaretElement == null) {
            return;
        }
        ASTNode atCaret = BasicJavaAstTreeUtil.toNode((PsiElement)atCaretElement);
        if (atCaret == null) {
            return;
        }
        boolean insideBrackets = false;
        int offset = editor.getCaretModel().getCurrentCaret().getOffset();
        Document document = editor.getDocument();
        String text = document.getText();
        if (text.length() > offset && offset - 2 >= 0 && text.startsWith("()", offset - 2)) {
            insideBrackets = true;
        }
        if ((elementText = atCaret.getText()).endsWith("{}") || elementText.endsWith("{\n}") || elementText.startsWith("do {}")) {
            char c;
            if (!BasicJavaAstTreeUtil.is((ASTNode)atCaret, (IElementType)BasicJavaElementType.BASIC_CODE_BLOCK)) {
                ASTNode[] blocks;
                ASTNode block = null;
                if (BasicJavaAstTreeUtil.is((ASTNode)atCaret, (IElementType)BasicJavaElementType.BASIC_DO_WHILE_STATEMENT)) {
                    block = BasicJavaAstTreeUtil.getDoWhileBody((ASTNode)atCaret);
                }
                if (BasicJavaAstTreeUtil.is((ASTNode)atCaret, (IElementType)BasicJavaElementType.BASIC_TRY_STATEMENT) && (blocks = BasicJavaAstTreeUtil.getCatchBlocks((ASTNode)atCaret)) != null && blocks.length != 0) {
                    block = blocks[blocks.length - 1];
                }
                if (block == null) {
                    block = BasicJavaAstTreeUtil.findChildByType((ASTNode)atCaret, (IElementType[])new IElementType[]{BasicJavaElementType.BASIC_CODE_BLOCK, BasicJavaElementType.BASIC_BLOCK_STATEMENT});
                }
                if (block == null) {
                    return;
                }
                atCaret = block;
            }
            elementText = atCaret.getText();
            ASTNode parent = atCaret.getTreeParent();
            boolean move = true;
            if (BasicJavaAstTreeUtil.is((ASTNode)parent, (ParentAwareTokenSet)BasicJavaElementType.EXPRESSION_SET) || this.myFirstErrorOffset != Integer.MAX_VALUE) {
                move = false;
            }
            TextRange range = atCaret.getTextRange();
            int lineNumber = document.getLineNumber(range.getStartOffset());
            StringBuilder indent = new StringBuilder();
            int max = document.getLineEndOffset(lineNumber);
            for (int i = document.getLineStartOffset(lineNumber); i < max && ((c = text.charAt(i)) == ' ' || c == '\t'); ++i) {
                indent.append(c);
            }
            int delta = 2;
            if (elementText.equals("{}")) {
                indent.insert(0, "\n");
                delta = 1;
            }
            document.insertString(range.getStartOffset() + delta, (CharSequence)indent.toString());
            if (move && !this.mySkipEnter && !insideBrackets && this.myFirstErrorOffset == Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(range.getStartOffset() + 1);
            }
            this.commit(editor);
        }
        super.reformat(BasicJavaAstTreeUtil.toPsi((ASTNode)atCaret));
    }

    public void reformatAndMove(@NotNull Editor editor, @Nullable PsiElement atCaret, int caret) throws IncorrectOperationException {
        if (editor == null) {
            FrontendJavaSmartEnterProcessor.$$$reportNull$$$0(3);
        }
        this.reformat(editor, atCaret);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/frontend/codeInsight/editorActions/smartEnter/FrontendJavaSmartEnterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "log";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reformat";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatAndMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

