/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import com.intellij.configurationStore.BaseXmlOutputter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.output.EclipseNamespaceStack;
import org.jdom.output.Format;

public final class EclipseXMLOutputter
extends BaseXmlOutputter
implements Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: XMLOutputter.java,v $ $Revision: 1.112 $ $Date: 2004/09/01 06:08:18 $ $Name: jdom_1_0 $";
    private Format userFormat;
    protected static final Format preserveFormat = Format.getRawFormat();
    protected Format currentFormat;
    private boolean escapeOutput;

    public EclipseXMLOutputter(String lineSeparator) {
        super(lineSeparator);
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
    }

    public void setFormat(Format newFormat) {
        this.currentFormat = this.userFormat = newFormat;
    }

    public Format getFormat() {
        return this.userFormat;
    }

    public void output(Document doc, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doc, writer);
    }

    public void output(DocType doctype, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doctype, writer);
    }

    public void output(Element element, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(element, writer);
    }

    public void outputElementContent(Element element, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.outputElementContent(element, writer);
    }

    public void output(List list, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(list, writer);
    }

    public void output(CDATA cdata, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(cdata, writer);
    }

    public void output(Text text, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(text, writer);
    }

    public void output(EntityRef entity2, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(entity2, writer);
    }

    private Writer makeWriter(OutputStream out) throws UnsupportedEncodingException {
        return EclipseXMLOutputter.makeWriter(out, "UTF-8");
    }

    private static Writer makeWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        if ("UTF-8".equals(enc)) {
            enc = "UTF8";
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), enc));
        return writer;
    }

    public void output(Document doc, Writer out) throws IOException {
        this.printDeclaration(out, doc, "UTF-8");
        List content = doc.getContent();
        int size = content.size();
        for (int i = 0; i < size; ++i) {
            Object obj = content.get(i);
            if (obj instanceof Element) {
                this.printElement(out, doc.getRootElement(), 0, this.createNamespaceStack());
            } else if (obj instanceof DocType) {
                this.printDocType(out, doc.getDocType());
                out.write(this.getLineSeparator());
            }
            this.newline(out);
            this.indent(out, 0);
        }
        out.flush();
    }

    public void output(DocType doctype, Writer out) throws IOException {
        this.printDocType(out, doctype);
        out.flush();
    }

    public void output(Element element, Writer out) throws IOException {
        this.printElement(out, element, 0, this.createNamespaceStack());
        out.flush();
    }

    public void outputElementContent(Element element, Writer out) throws IOException {
        List content = element.getContent();
        this.printContentRange(out, content, 0, content.size(), 0, this.createNamespaceStack());
        out.flush();
    }

    public void output(List list, Writer out) throws IOException {
        this.printContentRange(out, list, 0, list.size(), 0, this.createNamespaceStack());
        out.flush();
    }

    public void output(CDATA cdata, Writer out) throws IOException {
        this.printCDATA(out, cdata);
        out.flush();
    }

    public void output(Text text, Writer out) throws IOException {
        this.printText(out, text);
        out.flush();
    }

    public void output(EntityRef entity2, Writer out) throws IOException {
        this.printEntityRef(out, entity2);
        out.flush();
    }

    public String outputString(Document doc) {
        StringWriter out = new StringWriter();
        try {
            this.output(doc, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(DocType doctype) {
        StringWriter out = new StringWriter();
        try {
            this.output(doctype, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(Element element) {
        StringWriter out = new StringWriter();
        try {
            this.output(element, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(List list) {
        StringWriter out = new StringWriter();
        try {
            this.output(list, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(CDATA cdata) {
        StringWriter out = new StringWriter();
        try {
            this.output(cdata, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(Text text) {
        StringWriter out = new StringWriter();
        try {
            this.output(text, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(EntityRef entity2) {
        StringWriter out = new StringWriter();
        try {
            this.output(entity2, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    protected void printDeclaration(Writer out, Document doc, String encoding) throws IOException {
        out.write("<?xml version=\"1.0\"");
        out.write(" encoding=\"" + encoding + "\"");
        out.write("?>");
        out.write(this.getLineSeparator());
    }

    protected void printEntityRef(Writer out, EntityRef entity2) throws IOException {
        out.write("&");
        out.write(entity2.getName());
        out.write(";");
    }

    protected void printCDATA(Writer out, CDATA cdata) throws IOException {
        String str = cdata.getTextNormalize();
        out.write("<![CDATA[");
        out.write(str);
        out.write("]]>");
    }

    protected void printText(Writer out, Text text) throws IOException {
        String str = text.getTextNormalize();
        out.write(this.escapeElementEntities(str));
    }

    private void printString(Writer out, String str) throws IOException {
        str = Text.normalizeString((String)str);
        str = str.trim();
        out.write(this.escapeElementEntities(str));
    }

    protected void printElement(Writer out, Element element, int level, EclipseNamespaceStack namespaces) throws IOException {
        int size;
        int start;
        List attributes = element.getAttributes();
        List content = element.getContent();
        String space = null;
        if (attributes != null) {
            space = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
        }
        Format previousFormat = this.currentFormat;
        if ("default".equals(space)) {
            this.currentFormat = this.userFormat;
        } else if ("preserve".equals(space)) {
            this.currentFormat = preserveFormat;
        }
        out.write("<");
        this.printQualifiedName(out, element);
        int previouslyDeclaredNamespaces = namespaces.size();
        this.printElementNamespace(out, element, namespaces);
        this.printAdditionalNamespaces(out, element, namespaces);
        if (attributes != null) {
            this.printAttributes(out, attributes, element, namespaces);
        }
        if ((start = this.skipLeadingWhite(content, 0)) >= (size = content.size())) {
            out.write("/>");
        } else {
            out.write(">");
            if (EclipseXMLOutputter.nextNonText(content, start) < size) {
                this.newline(out);
                this.printContentRange(out, content, start, size, level + 1, namespaces);
                this.newline(out);
                this.indent(out, level);
            } else {
                this.printTextRange(out, content, start, size);
            }
            out.write("</");
            this.printQualifiedName(out, element);
            out.write(">");
        }
        while (namespaces.size() > previouslyDeclaredNamespaces) {
            namespaces.pop();
        }
        this.currentFormat = previousFormat;
    }

    private void printContentRange(Writer out, List content, int start, int end, int level, EclipseNamespaceStack namespaces) throws IOException {
        int index = start;
        while (index < end) {
            boolean firstNode = index == start;
            Object next = content.get(index);
            if (next instanceof Text || next instanceof EntityRef) {
                int first = this.skipLeadingWhite(content, index);
                if (first >= (index = EclipseXMLOutputter.nextNonText(content, first))) continue;
                if (!firstNode) {
                    this.newline(out);
                }
                this.indent(out, level);
                this.printTextRange(out, content, first, index);
                continue;
            }
            if (!firstNode) {
                this.newline(out);
            }
            this.indent(out, level);
            if (next instanceof Element) {
                this.printElement(out, (Element)next, level, namespaces);
            }
            ++index;
        }
    }

    private void printTextRange(Writer out, List content, int start, int end) throws IOException {
        int size;
        Object previous = null;
        if ((start = this.skipLeadingWhite(content, start)) < (size = content.size())) {
            end = this.skipTrailingWhite(content, end);
            for (int i = start; i < end; ++i) {
                Object next;
                Object node = content.get(i);
                if (node instanceof Text) {
                    next = ((Text)node).getText();
                } else if (node instanceof EntityRef) {
                    next = "&" + ((EntityRef)node).getValue() + ";";
                } else {
                    throw new IllegalStateException("Should see only CDATA, Text, or EntityRef");
                }
                if (next == null || "".equals(next)) continue;
                if (previous != null && (this.endsWithWhite((String)previous) || this.startsWithWhite((String)next))) {
                    out.write(" ");
                }
                if (node instanceof CDATA) {
                    this.printCDATA(out, (CDATA)node);
                } else if (node instanceof EntityRef) {
                    this.printEntityRef(out, (EntityRef)node);
                } else {
                    this.printString(out, (String)next);
                }
                previous = next;
            }
        }
    }

    private void printNamespace(Writer out, Namespace ns, EclipseNamespaceStack namespaces) throws IOException {
        String prefix = ns.getPrefix();
        String uri = ns.getURI();
        if (uri.equals(namespaces.getURI(prefix))) {
            return;
        }
        out.write(" xmlns");
        if (!prefix.equals("")) {
            out.write(":");
            out.write(prefix);
        }
        out.write("=\"");
        out.write(uri);
        out.write("\"");
        namespaces.push(ns);
    }

    protected void printAttributes(Writer out, List attributes, Element parent, EclipseNamespaceStack namespaces) throws IOException {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (Object attribute : attributes) {
            atts.add(((Attribute)attribute).clone());
        }
        Collections.sort(atts, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        for (int i = 0; i < atts.size(); ++i) {
            Object attribute;
            attribute = (Attribute)atts.get(i);
            Namespace ns = attribute.getNamespace();
            if (ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE) {
                this.printNamespace(out, ns, namespaces);
            }
            out.write(" ");
            this.printQualifiedName(out, (Attribute)attribute);
            out.write("=");
            out.write("\"");
            out.write(this.escapeAttributeEntities(attribute.getValue()));
            out.write("\"");
        }
    }

    private void printElementNamespace(Writer out, Element element, EclipseNamespaceStack namespaces) throws IOException {
        Namespace ns = element.getNamespace();
        if (ns == Namespace.XML_NAMESPACE) {
            return;
        }
        if (ns != Namespace.NO_NAMESPACE || namespaces.getURI("") != null) {
            this.printNamespace(out, ns, namespaces);
        }
    }

    private void printAdditionalNamespaces(Writer out, Element element, EclipseNamespaceStack namespaces) throws IOException {
        List list = element.getAdditionalNamespaces();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Namespace additional = (Namespace)list.get(i);
                this.printNamespace(out, additional, namespaces);
            }
        }
    }

    private void newline(Writer out) throws IOException {
        out.write(this.getLineSeparator());
    }

    private void indent(Writer out, int level) throws IOException {
        for (int i = 0; i < level; ++i) {
            out.write("\t");
        }
    }

    private int skipLeadingWhite(List content, int start) {
        int index;
        if (start < 0) {
            start = 0;
        }
        int size = content.size();
        for (index = start; index < size; ++index) {
            if (this.isAllWhitespace(content.get(index))) continue;
            return index;
        }
        return index;
    }

    private int skipTrailingWhite(List content, int start) {
        int index;
        int size = content.size();
        if (start > size) {
            start = size;
        }
        for (index = start; index >= 0 && this.isAllWhitespace(content.get(index - 1)); --index) {
        }
        return index;
    }

    private static int nextNonText(List content, int start) {
        if (start < 0) {
            start = 0;
        }
        int size = content.size();
        for (int index = start; index < size; ++index) {
            Object node = content.get(index);
            if (node instanceof Text || node instanceof EntityRef) continue;
            return index;
        }
        return size;
    }

    private boolean isAllWhitespace(Object obj) {
        String str = null;
        if (obj instanceof String) {
            str = (String)obj;
        } else if (obj instanceof Text) {
            str = ((Text)obj).getText();
        } else {
            if (obj instanceof EntityRef) {
                return false;
            }
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (EclipseXMLOutputter.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean startsWithWhite(String str) {
        return str != null && str.length() > 0 && EclipseXMLOutputter.isWhitespace(str.charAt(0));
    }

    private boolean endsWithWhite(String str) {
        return str != null && str.length() > 0 && EclipseXMLOutputter.isWhitespace(str.charAt(str.length() - 1));
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    public String escapeAttributeEntities(String str) {
        StringBuffer buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            String entity2 = switch (ch) {
                case '<' -> "&lt;";
                case '>' -> "&gt;";
                case '\"' -> "&quot;";
                case '&' -> "&amp;";
                case '\r' -> "&#xD;";
                case '\t' -> "&#x9;";
                case '\n' -> "&#xA;";
                default -> null;
            };
            if (buffer == null) {
                if (entity2 == null) continue;
                buffer = new StringBuffer(str.length() + 20);
                buffer.append(str, 0, i);
                buffer.append(entity2);
                continue;
            }
            if (entity2 == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity2);
        }
        return buffer == null ? str : buffer.toString();
    }

    public String escapeElementEntities(String str) {
        if (!this.escapeOutput) {
            return str;
        }
        StringBuffer buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            String entity2 = switch (ch) {
                case '<' -> "&lt;";
                case '>' -> "&gt;";
                case '&' -> "&amp;";
                case '\r' -> "&#xD;";
                case '\n' -> this.getLineSeparator();
                default -> null;
            };
            if (buffer == null) {
                if (entity2 == null) continue;
                buffer = new StringBuffer(str.length() + 20);
                buffer.append(str, 0, i);
                buffer.append(entity2);
                continue;
            }
            if (entity2 == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity2);
        }
        return buffer == null ? str : buffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        block5: for (int i = 0; i < this.userFormat.lineSeparator.length(); ++i) {
            char ch = this.userFormat.lineSeparator.charAt(i);
            switch (ch) {
                case '\r': {
                    buffer.append("\\r");
                    continue block5;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block5;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block5;
                }
                default: {
                    buffer.append("[" + ch + "]");
                }
            }
        }
        return "XMLOutputter[omitDeclaration = false, encoding = UTF-8, omitEncoding = false, indent = '\t', expandEmptyElements = " + this.userFormat.expandEmptyElements + ", lineSeparator = '" + buffer.toString() + "', textMode = " + this.userFormat.mode + "]";
    }

    private EclipseNamespaceStack createNamespaceStack() {
        return new EclipseNamespaceStack();
    }

    private void printQualifiedName(Writer out, Element e) throws IOException {
        if (e.getNamespace().getPrefix().length() == 0) {
            out.write(e.getName());
        } else {
            out.write(e.getNamespace().getPrefix());
            out.write(58);
            out.write(e.getName());
        }
    }

    private void printQualifiedName(Writer out, Attribute a) throws IOException {
        String prefix = a.getNamespace().getPrefix();
        if (prefix != null && !prefix.equals("")) {
            out.write(prefix);
            out.write(58);
            out.write(a.getName());
        } else {
            out.write(a.getName());
        }
    }
}

