/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.util;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.konan.util.ArchiveType;
import org.jetbrains.kotlin.konan.util.DependencyExtractor$WhenMappings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/konan/util/DependencyExtractor;", "", "archiveType", "Lorg/jetbrains/kotlin/konan/util/ArchiveType;", "(Lorg/jetbrains/kotlin/konan/util/ArchiveType;)V", "extract", "", "archive", "Ljava/io/File;", "targetDirectory", "extractTarGz", "tarGz", "Companion", "kotlin-native-utils"})
public final class DependencyExtractor {
    private final ArchiveType archiveType;
    private static final long extractionTimeout;
    @NotNull
    private static final TimeUnit extractionTimeoutUntis;
    @NotNull
    public static final Companion Companion;

    private final void extractTarGz(File tarGz, File targetDirectory) {
        ProcessBuilder processBuilder;
        ProcessBuilder $this$apply = processBuilder = new ProcessBuilder(new String[0]);
        boolean bl = false;
        $this$apply.command("tar", "-xzf", tarGz.getCanonicalPath());
        $this$apply.directory(targetDirectory);
        $this$apply.inheritIO();
        Process tarProcess = processBuilder.start();
        boolean finished = tarProcess.waitFor(extractionTimeout, extractionTimeoutUntis);
        if (finished && tarProcess.exitValue() != 0) {
            throw (Throwable)new RuntimeException("Cannot extract archive with dependency: " + tarGz.getCanonicalPath() + ".\n" + "Tar exit code: " + tarProcess.exitValue() + '.');
        }
        if (!finished) {
            tarProcess.destroy();
            throw (Throwable)new RuntimeException("Cannot extract archive with dependency: " + tarGz.getCanonicalPath() + ".\n" + "Tar process hasn't finished in " + extractionTimeoutUntis.toSeconds(extractionTimeout) + " sec.");
        }
    }

    public final void extract(@NotNull File archive, @NotNull File targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        switch (DependencyExtractor$WhenMappings.$EnumSwitchMapping$0[this.archiveType.ordinal()]) {
            case 1: {
                Path path = archive.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"archive.toPath()");
                Path path2 = targetDirectory.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"targetDirectory.toPath()");
                ZipUtilKt.unzipTo$default(path, path2, null, false, 6, null);
                break;
            }
            case 2: {
                this.extractTarGz(archive, targetDirectory);
                break;
            }
        }
    }

    public DependencyExtractor(@NotNull ArchiveType archiveType) {
        Intrinsics.checkNotNullParameter((Object)((Object)archiveType), (String)"archiveType");
        this.archiveType = archiveType;
    }

    static {
        Companion = new Companion(null);
        extractionTimeout = 3600L;
        extractionTimeoutUntis = TimeUnit.SECONDS;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/konan/util/DependencyExtractor$Companion;", "", "()V", "extractionTimeout", "", "getExtractionTimeout", "()J", "extractionTimeoutUntis", "Ljava/util/concurrent/TimeUnit;", "getExtractionTimeoutUntis", "()Ljava/util/concurrent/TimeUnit;", "kotlin-native-utils"})
    public static final class Companion {
        public final long getExtractionTimeout() {
            return extractionTimeout;
        }

        @NotNull
        public final TimeUnit getExtractionTimeoutUntis() {
            return extractionTimeoutUntis;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

