/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.AppendableDataExternalizer;
import org.jetbrains.kotlin.incremental.storage.AppendableLazyStorage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0016\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0018\u0010\u001f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0015\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0012H\u0002J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012H\u0002J\u0015\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/CachingLazyStorage;", "K", "V", "Lorg/jetbrains/kotlin/incremental/storage/AppendableLazyStorage;", "storageFile", "Ljava/io/File;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "(Ljava/io/File;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;)V", "isStorageFileExist", "", "keys", "", "getKeys", "()Ljava/util/Collection;", "storage", "Lcom/intellij/util/io/PersistentHashMap;", "append", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "clean", "close", "contains", "(Ljava/lang/Object;)Z", "createMap", "flush", "memoryCachesOnly", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getStorageIfExists", "getStorageOrCreateNew", "remove", "(Ljava/lang/Object;)V", "set", "kotlin-build-common"})
public final class CachingLazyStorage<K, V>
implements AppendableLazyStorage<K, V> {
    @NotNull
    private final File storageFile;
    @NotNull
    private final KeyDescriptor<K> keyDescriptor;
    @NotNull
    private final DataExternalizer<V> valueExternalizer;
    @Nullable
    private PersistentHashMap<K, V> storage;
    private boolean isStorageFileExist;

    public CachingLazyStorage(@NotNull File storageFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        this.storageFile = storageFile;
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
        this.isStorageFileExist = true;
    }

    private final PersistentHashMap<K, V> getStorageIfExists() {
        if (this.storage != null) {
            return this.storage;
        }
        if (!this.isStorageFileExist) {
            return null;
        }
        if (this.storageFile.exists()) {
            this.storage = this.createMap();
            return this.storage;
        }
        this.isStorageFileExist = false;
        return null;
    }

    private final PersistentHashMap<K, V> getStorageOrCreateNew() {
        if (this.storage == null) {
            this.storage = this.createMap();
        }
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        Intrinsics.checkNotNull(persistentHashMap);
        return persistentHashMap;
    }

    @Override
    @NotNull
    public synchronized Collection<K> getKeys() {
        List list;
        block0: {
            List $this$_get_keys__u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
            if (persistentHashMap == null) break block0;
            persistentHashMap.processKeysWithExistingMapping((Processor)new CommonProcessors.CollectProcessor((Collection)$this$_get_keys__u24lambda_u240));
        }
        return CollectionsKt.build((List)list);
    }

    @Override
    public synchronized boolean contains(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return persistentHashMap != null ? persistentHashMap.containsMapping(key) : false;
    }

    @Override
    @Nullable
    public synchronized V get(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return (V)(persistentHashMap != null ? persistentHashMap.get(key) : null);
    }

    @Override
    public synchronized void set(K key, V value2) {
        this.getStorageOrCreateNew().put(key, value2);
    }

    @Override
    public synchronized void remove(K key) {
        block0: {
            PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
            if (persistentHashMap == null) break block0;
            persistentHashMap.remove(key);
        }
    }

    @Override
    public synchronized void append(K key, V value2) {
        if (!(this.valueExternalizer instanceof AppendableDataExternalizer)) {
            boolean bl = false;
            String string2 = "`valueExternalizer` should implement the `AppendableDataExternalizer` interface to be able to call `append`";
            throw new IllegalStateException(string2.toString());
        }
        this.getStorageOrCreateNew().appendData(key, arg_0 -> CachingLazyStorage.append$lambda$2(this, value2, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clean() {
        try {
            PersistentHashMap<K, V> persistentHashMap = this.storage;
            if (persistentHashMap != null) {
                persistentHashMap.close();
            }
        }
        finally {
            this.storage = null;
            if (!IOUtil.deleteAllFilesStartingWith((File)this.storageFile)) {
                throw new IOException("Could not delete internal storage: " + this.storageFile.getAbsolutePath());
            }
        }
    }

    @Override
    public synchronized void flush(boolean memoryCachesOnly) {
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            return;
        }
        PersistentHashMap<K, V> existingStorage = persistentHashMap;
        if (memoryCachesOnly) {
            if (existingStorage.isDirty()) {
                existingStorage.dropMemoryCaches();
            }
        } else {
            existingStorage.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            PersistentHashMap<K, V> persistentHashMap = this.storage;
            if (persistentHashMap != null) {
                persistentHashMap.close();
            }
        }
        finally {
            this.storage = null;
        }
    }

    private final PersistentHashMap<K, V> createMap() {
        return new PersistentHashMap(this.storageFile, this.keyDescriptor, this.valueExternalizer);
    }

    private static final void append$lambda$2(CachingLazyStorage this$0, Object $value, DataOutput it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.valueExternalizer.save(it, $value);
    }
}

