/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class WrapperProcess
implements Process {
    private final Process process;
    private final boolean windows;
    private final Object workingDirectoryLock = new Object();
    private final Object environmentLock = new Object();
    private Map<String, String> environment;
    private Map<String, String> windowsEnvironment;

    public WrapperProcess(Process process, boolean windows) {
        this.process = process;
        this.windows = windows;
    }

    public String toString() {
        return this.process.toString();
    }

    @Override
    public int getProcessId() throws NativeException {
        return this.process.getProcessId();
    }

    @Override
    public void detach() throws NativeException {
        this.process.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getWorkingDirectory() throws NativeException {
        Object object = this.workingDirectoryLock;
        synchronized (object) {
            return this.process.getWorkingDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWorkingDirectory(File directory) throws NativeException {
        Object object = this.workingDirectoryLock;
        synchronized (object) {
            this.process.setWorkingDirectory(directory);
            System.setProperty("user.dir", directory.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEnvironmentVariable(String name2) throws NativeException {
        Object object = this.environmentLock;
        synchronized (object) {
            String value2 = this.process.getEnvironmentVariable(name2);
            return value2 == null || value2.length() == 0 ? null : value2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnvironmentVariable(String name2, String value2) throws NativeException {
        Object object = this.environmentLock;
        synchronized (object) {
            if (value2 == null || value2.length() == 0) {
                this.process.setEnvironmentVariable(name2, null);
                this.removeEnvInternal(name2);
            } else {
                this.process.setEnvironmentVariable(name2, value2);
                this.setEnvInternal(name2, value2);
            }
        }
    }

    private void removeEnvInternal(String name2) {
        this.getEnv().remove(name2);
        if (this.windows) {
            this.getWindowsEnv().remove(name2);
        }
    }

    private void setEnvInternal(String name2, String value2) {
        this.getEnv().put(name2, value2);
        if (this.windows) {
            this.getWindowsEnv().put(name2, value2);
        }
    }

    private Map<String, String> getEnv() {
        if (this.environment == null) {
            try {
                Map<String, String> theUnmodifiableEnvironment = System.getenv();
                Class<?> cu = theUnmodifiableEnvironment.getClass();
                Field m = cu.getDeclaredField("m");
                m.setAccessible(true);
                this.environment = (Map)m.get(theUnmodifiableEnvironment);
            }
            catch (Exception e) {
                throw new NativeException("Unable to get mutable environment variable map.", e);
            }
        }
        return this.environment;
    }

    private Map<String, String> getWindowsEnv() {
        if (this.windowsEnvironment == null) {
            try {
                Class<?> sc = Class.forName("java.lang.ProcessEnvironment");
                Field caseinsensitive = sc.getDeclaredField("theCaseInsensitiveEnvironment");
                caseinsensitive.setAccessible(true);
                this.windowsEnvironment = (Map)caseinsensitive.get(null);
            }
            catch (Exception e) {
                throw new NativeException("Unable to get mutable Windows environment variable map", e);
            }
        }
        return this.windowsEnvironment;
    }
}

