/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceOnlyRevisionNumber;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4Revision;

public class PerforceVcsRevisionNumber
implements VcsRevisionNumber {
    private final long myRevisionNumber;
    private final long myChangeNumber;
    private final boolean myBranched;
    private final String myDepotPath;

    /*
     * WARNING - void declaration
     */
    public PerforceVcsRevisionNumber(long revisionNumber, long changeNumber, boolean bl, @NotNull String string) {
        void depotPath;
        void branched;
        if (string == null) {
            PerforceVcsRevisionNumber.$$$reportNull$$$0(0);
        }
        this.myRevisionNumber = revisionNumber;
        this.myChangeNumber = changeNumber;
        this.myBranched = branched;
        this.myDepotPath = depotPath;
    }

    public PerforceVcsRevisionNumber(P4Revision p4Revision) {
        this(p4Revision.getRevisionNumber(), p4Revision.getChangeNumber(), p4Revision.isBranched(), p4Revision.getDepotPath());
    }

    @Nullable
    public static PerforceVcsRevisionNumber createFromFStat(FStat fstat) {
        try {
            return new PerforceVcsRevisionNumber(Long.parseLong(fstat.haveRev), Long.parseLong(fstat.headChange), false, fstat.depotFile);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public String asString() {
        String string = String.valueOf(this.myChangeNumber);
        if (string == null) {
            PerforceVcsRevisionNumber.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int compareTo(VcsRevisionNumber o) {
        if (o instanceof PerforceVcsRevisionNumber) {
            return Long.signum(this.myChangeNumber - ((PerforceVcsRevisionNumber)o).myChangeNumber);
        }
        if (o instanceof PerforceOnlyRevisionNumber) {
            return Long.signum(this.myRevisionNumber - ((PerforceOnlyRevisionNumber)o).getNumber());
        }
        return 0;
    }

    @NotNull
    public String getDepotPath() {
        String string = this.myDepotPath;
        if (string == null) {
            PerforceVcsRevisionNumber.$$$reportNull$$$0(2);
        }
        return string;
    }

    public long getRevisionNumber() {
        return this.myRevisionNumber;
    }

    public long getChangeNumber() {
        return this.myChangeNumber;
    }

    public boolean isBranched() {
        return this.myBranched;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerforceVcsRevisionNumber that = (PerforceVcsRevisionNumber)o;
        if (this.myChangeNumber != that.myChangeNumber) {
            return false;
        }
        return this.myRevisionNumber == that.myRevisionNumber && Objects.equals(this.myDepotPath, that.myDepotPath);
    }

    public int hashCode() {
        int result = (int)(this.myRevisionNumber ^ this.myRevisionNumber >>> 32);
        result = 29 * result + (int)(this.myChangeNumber ^ this.myChangeNumber >>> 32);
        if (this.myDepotPath != null) {
            result = 29 * result + this.myDepotPath.hashCode();
        }
        return result;
    }

    public String toString() {
        return Long.toString(this.myChangeNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depotPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceVcsRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceVcsRevisionNumber";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepotPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

