/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.ui;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.HorizontalBarPresentation;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.VerticalBarPresentation;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u0002H\u0016J*\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/MarkdownTableInlayProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/codeInsight/hints/NoSettings;", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "name", "getName", "previewText", "getPreviewText", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "createSettings", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "Collector", "Companion", "intellij.markdown.core"})
public final class MarkdownTableInlayProvider
implements InlayHintsProvider<NoSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String previewText;
    @NotNull
    private static final SettingsKey<NoSettings> settingsKey = new SettingsKey("MarkdownTableInlayProviderSettingsKey");
    @NotNull
    private static final Key<Boolean> DISABLE_TABLE_INLAYS = new Key("MarkdownDisableTableInlaysKey");

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull NoSettings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        FileType fileType2 = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        return MarkdownLanguageUtilsKt.isMarkdownType(fileType2) ? (InlayHintsCollector)new Collector(editor2) : null;
    }

    @NotNull
    public NoSettings createSettings() {
        return new NoSettings();
    }

    @NotNull
    public String getName() {
        String string = MarkdownBundle.message("markdown.table.inlay.kind.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = MarkdownBundle.message("markdown.table.inlay.kind.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public SettingsKey<NoSettings> getKey() {
        return settingsKey;
    }

    @Nullable
    public String getPreviewText() {
        return this.previewText;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull NoSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(){

            @NotNull
            public JPanel createComponent(@NotNull ChangeListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                return new JPanel();
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/MarkdownTableInlayProvider$Collector;", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "collect", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "processTableRows", "", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "calculateStartOffsetForInlay", "", "intellij.markdown.core"})
    private static final class Collector
    extends FactoryInlayHintsCollector {
        public Collector(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            super(editor2);
        }

        public boolean collect(@NotNull PsiElement element2, @NotNull Editor editor2, @NotNull InlayHintsSink sink) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (Intrinsics.areEqual((Object)editor2.getUserData(Companion.getDISABLE_TABLE_INLAYS()), (Object)true)) {
                return true;
            }
            if (!element2.isValid()) {
                return true;
            }
            if (element2 instanceof MarkdownTable && TableModificationUtils.INSTANCE.hasCorrectBorders((MarkdownTable)element2)) {
                this.processTableRows((MarkdownTable)element2, editor2, sink);
                InlayPresentation presentation = HorizontalBarPresentation.Companion.create(this.getFactory(), editor2, (MarkdownTable)element2);
                sink.addBlockElement(UtilsKt.getStartOffset((PsiElement)element2), false, true, -1, presentation);
            }
            return true;
        }

        private final void processTableRows(MarkdownTable table, Editor editor2, InlayHintsSink sink) {
            List<MarkdownTableRow> list2 = table.getRows(true);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getRows(...)");
            List<MarkdownTableRow> regularRows = list2;
            MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow(table);
            if (markdownTableSeparatorRow == null) {
                return;
            }
            MarkdownTableSeparatorRow separatorRow = markdownTableSeparatorRow;
            MarkdownTableSeparatorRow[] markdownTableSeparatorRowArray = new MarkdownTableSeparatorRow[]{separatorRow};
            Sequence rows = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)regularRows), (Sequence)SequencesKt.sequenceOf((Object[])markdownTableSeparatorRowArray));
            for (Object row : rows) {
                InlayPresentation presentation = VerticalBarPresentation.Companion.create(this.getFactory(), editor2, (PsiElement)row);
                int startOffset = this.calculateStartOffsetForInlay((PsiElement)row);
                sink.addInlineElement(startOffset, false, presentation, false);
            }
        }

        private final int calculateStartOffsetForInlay(PsiElement $this$calculateStartOffsetForInlay) {
            int n;
            PsiElement psiElement = $this$calculateStartOffsetForInlay;
            if (psiElement instanceof MarkdownTableSeparatorRow) {
                n = TableUtils.INSTANCE.calculateActualTextRange$intellij_markdown_core((MarkdownTableSeparatorRow)$this$calculateStartOffsetForInlay).getStartOffset();
            } else if (psiElement instanceof MarkdownTableRow) {
                n = UtilsKt.getStartOffset((PsiElement)$this$calculateStartOffsetForInlay);
            } else {
                throw new IllegalStateException("This method should not be called on anything other than MarkdownTableRow or MarkdownTableSeparatorRow".toString());
            }
            return n;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/MarkdownTableInlayProvider$Companion;", "", "()V", "DISABLE_TABLE_INLAYS", "Lcom/intellij/openapi/util/Key;", "", "getDISABLE_TABLE_INLAYS", "()Lcom/intellij/openapi/util/Key;", "settingsKey", "Lcom/intellij/codeInsight/hints/SettingsKey;", "Lcom/intellij/codeInsight/hints/NoSettings;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getDISABLE_TABLE_INLAYS() {
            return DISABLE_TABLE_INLAYS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

