/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class ByteCodeViewerComponent
extends JPanel
implements Disposable {
    private final Editor myEditor;

    public ByteCodeViewerComponent(Project project) {
        super(new BorderLayout());
        EditorFactory factory = EditorFactory.getInstance();
        Document doc = ((EditorFactoryImpl)factory).createDocument((CharSequence)"", true, false);
        doc.setReadOnly(true);
        this.myEditor = factory.createEditor(doc, project);
        EditorHighlighterFactory editorHighlighterFactory = EditorHighlighterFactory.getInstance();
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)StdFileTypes.JAVA, (Project)project, null);
        ((EditorEx)this.myEditor).setHighlighter(editorHighlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme()));
        ((EditorEx)this.myEditor).setCaretVisible(true);
        EditorSettings settings = this.myEditor.getSettings();
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(false);
        this.myEditor.setBorder(null);
        this.add((Component)this.myEditor.getComponent(), "Center");
    }

    public void setText(String bytecode) {
        this.setText(bytecode, 0);
    }

    public void setText(@NonNls String bytecode, PsiElement element, int lineNumber) {
        Document document;
        int offset = -1;
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file != null && (document = FileDocumentManager.getInstance().getDocument(file)) != null) {
            if (lineNumber == -1) {
                lineNumber = document.getLineNumber(element.getTextOffset());
            }
            ++lineNumber;
            LineNumbersMapping mapping = (LineNumbersMapping)file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY);
            if (mapping != null) {
                for (int l = lineNumber; l <= document.getLineCount(); ++l) {
                    int bytecodeLine = mapping.sourceToBytecode(l);
                    if (bytecodeLine == -1) continue;
                    offset = ByteCodeViewerComponent.findLineNumber(bytecode, bytecodeLine);
                    assert (offset != -1) : "there is bytecode line in mapping but it is missing in bytecode";
                    break;
                }
            } else {
                for (int l = lineNumber; l <= document.getLineCount() && (offset = ByteCodeViewerComponent.findLineNumber(bytecode, l)) == -1; ++l) {
                }
            }
        }
        this.setText(bytecode, Math.max(0, offset));
    }

    private static int findLineNumber(@NonNls String bytecode, int l) {
        int idx = bytecode.indexOf("\n    LINENUMBER " + l + " ");
        if (idx != -1) {
            return idx + 1;
        }
        return -1;
    }

    public void setText(String bytecode, int offset) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            Document fragmentDoc = this.myEditor.getDocument();
            fragmentDoc.setReadOnly(false);
            try {
                fragmentDoc.replaceString(0, fragmentDoc.getTextLength(), (CharSequence)bytecode);
            }
            finally {
                fragmentDoc.setReadOnly(true);
            }
            this.myEditor.getCaretModel().moveToOffset(offset);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        });
    }

    public String getText() {
        return this.myEditor.getDocument().getText();
    }

    public JComponent getEditorComponent() {
        return this.myEditor.getContentComponent();
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }
}

