/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.java.archives.internal;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.java.archives.ManifestException;

public class DefaultAttributes
implements Attributes {
    protected Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.attributes.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new ManifestException("The key of a manifest attribute must not be null.");
        }
        if (value == null) {
            throw new ManifestException(String.format("The value of a manifest attribute must not be null (Key=%s).", key));
        }
        try {
            new Attributes.Name(key);
        }
        catch (IllegalArgumentException e) {
            throw new ManifestException(String.format("The Key=%s violates the Manifest spec!", key));
        }
        return this.attributes.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.attributes.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.attributes.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.attributes.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.attributes.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.attributes.equals(o);
    }

    @Override
    public int hashCode() {
        return this.attributes.hashCode();
    }
}

