/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.transform.AbstractTransformExecution;
import org.gradle.api.internal.artifacts.transform.ImmutableTransformExecution;
import org.gradle.api.internal.artifacts.transform.MutableTransformExecution;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformException;
import org.gradle.api.internal.artifacts.transform.TransformExecutionListener;
import org.gradle.api.internal.artifacts.transform.TransformInvocationFactory;
import org.gradle.api.internal.artifacts.transform.TransformStepSubject;
import org.gradle.api.internal.artifacts.transform.TransformWorkspaceServices;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultTransformInvocationFactory
implements TransformInvocationFactory {
    private final ExecutionEngine executionEngine;
    private final FileSystemAccess fileSystemAccess;
    private final TransformExecutionListener transformExecutionListener;
    private final TransformWorkspaceServices immutableWorkspaceProvider;
    private final FileCollectionFactory fileCollectionFactory;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildOperationProgressEventEmitter progressEventEmitter;

    public DefaultTransformInvocationFactory(ExecutionEngine executionEngine, FileSystemAccess fileSystemAccess, TransformExecutionListener transformExecutionListener, TransformWorkspaceServices immutableWorkspaceProvider, FileCollectionFactory fileCollectionFactory, ProjectStateRegistry projectStateRegistry, BuildOperationExecutor buildOperationExecutor, BuildOperationProgressEventEmitter progressEventEmitter) {
        this.executionEngine = executionEngine;
        this.fileSystemAccess = fileSystemAccess;
        this.transformExecutionListener = transformExecutionListener;
        this.immutableWorkspaceProvider = immutableWorkspaceProvider;
        this.fileCollectionFactory = fileCollectionFactory;
        this.projectStateRegistry = projectStateRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
        this.progressEventEmitter = progressEventEmitter;
    }

    @Override
    public Deferrable<Try<ImmutableList<File>>> createInvocation(Transform transform, File inputArtifact, TransformDependencies dependencies, TransformStepSubject subject, InputFingerprinter inputFingerprinter) {
        ProjectInternal producerProject = this.determineProducerProject(subject);
        TransformWorkspaceServices workspaceServices = this.determineWorkspaceServices(producerProject);
        AbstractTransformExecution execution = producerProject == null ? new ImmutableTransformExecution(transform, inputArtifact, dependencies, subject, this.transformExecutionListener, this.buildOperationExecutor, this.progressEventEmitter, this.fileCollectionFactory, inputFingerprinter, this.fileSystemAccess, workspaceServices) : new MutableTransformExecution(transform, inputArtifact, dependencies, subject, producerProject, this.transformExecutionListener, this.buildOperationExecutor, this.progressEventEmitter, this.fileCollectionFactory, inputFingerprinter, workspaceServices);
        return this.executionEngine.createRequest((UnitOfWork)execution).executeDeferred(workspaceServices.getIdentityCache()).map(result -> result.map(successfulResult -> successfulResult.resolveOutputsForInputArtifact(inputArtifact)).mapFailure(failure -> new TransformException(String.format("Execution failed for %s.", execution.getDisplayName()), (Throwable)failure)));
    }

    private TransformWorkspaceServices determineWorkspaceServices(@Nullable ProjectInternal producerProject) {
        if (producerProject == null) {
            return this.immutableWorkspaceProvider;
        }
        return (TransformWorkspaceServices)producerProject.getServices().get(TransformWorkspaceServices.class);
    }

    @Nullable
    private ProjectInternal determineProducerProject(TransformStepSubject subject) {
        ComponentIdentifier componentIdentifier = subject.getInitialComponentIdentifier();
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            return this.projectStateRegistry.stateFor((ProjectComponentIdentifier)componentIdentifier).getMutableModel();
        }
        return null;
    }
}

