/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class VnetProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 0;
    public static final int MSG_LBS = 50;
    public static final int MSG_GPS = 51;

    public VnetProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        int type = BitUtil.to(buf.readUnsignedShortLE(), 15);
        buf.readUnsignedShortLE();
        DateBuilder dateBuilder = new DateBuilder().setDateReverse(BcdUtil.readInteger(buf, 2), BcdUtil.readInteger(buf, 2), BcdUtil.readInteger(buf, 2)).setTime(BcdUtil.readInteger(buf, 2), BcdUtil.readInteger(buf, 2), BcdUtil.readInteger(buf, 2));
        if (type == 0) {
            String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(0, 15);
            this.getDeviceSession(channel, remoteAddress, imei);
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(buf.retainedSlice(0, buf.writerIndex()), channel.remoteAddress()));
            }
        } else if (type == 51) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(dateBuilder.getDate());
            int value = BcdUtil.readInteger(buf, 8);
            int degrees = value / 1000000;
            double lat = (double)degrees + (double)(value % 1000000) * 1.0E-4 / 60.0;
            value = BcdUtil.readInteger(buf, 10);
            degrees = value / 10000000;
            double lon = (double)degrees + (double)(value % 10000000) * 1.0E-5 / 60.0;
            short flags = buf.readUnsignedByte();
            position.setValid(BitUtil.check(flags, 0));
            position.setLatitude(BitUtil.check(flags, 1) ? lat : -lat);
            position.setLongitude(BitUtil.check(flags, 2) ? lon : -lon);
            position.set("sat", buf.readUnsignedByte());
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
            position.set("odometer", buf.readUnsignedIntLE());
            position.setCourse(buf.readUnsignedByte() * 2);
            return position;
        }
        return null;
    }
}

