/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ProtocolMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ClientHelloPreparator
extends ProtocolMessagePreparator<SSL2ClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SSL2ClientHelloMessage message;

    public SSL2ClientHelloPreparator(Chooser chooser, SSL2ClientHelloMessage message) {
        super(chooser, message);
        this.message = message;
    }

    @Override
    protected void prepareProtocolMessageContents() {
        LOGGER.debug("Prepare SSL2ClientHello");
        this.preparePaddingLength(this.message);
        this.prepareType(this.message);
        this.prepareProtocolVersion(this.message);
        this.prepareCipherSuites(this.message);
        byte[] challenge = new byte[16];
        this.chooser.getContext().getRandom().nextBytes(challenge);
        this.prepareChallenge(this.message, challenge);
        this.prepareSessionID(this.message);
        this.prepareSessionIDLength(this.message);
        this.prepareChallengeLength(this.message);
        this.prepareCipherSuiteLength(this.message);
        int length = 7;
        length += ((byte[])this.message.getChallenge().getValue()).length;
        length += ((byte[])this.message.getCipherSuites().getValue()).length;
        length += ((byte[])this.message.getSessionId().getValue()).length;
        this.prepareMessageLength(this.message, length += ((byte[])this.message.getProtocolVersion().getValue()).length);
    }

    private void preparePaddingLength(SSL2ClientHelloMessage message) {
        message.setPaddingLength(0);
        LOGGER.debug("PaddingLength: " + message.getPaddingLength().getValue());
    }

    private void prepareType(SSL2ClientHelloMessage message) {
        message.setType(HandshakeMessageType.CLIENT_HELLO.getValue());
        LOGGER.debug("Type: " + message.getType().getValue());
    }

    private void prepareProtocolVersion(SSL2ClientHelloMessage message) {
        message.setProtocolVersion(this.chooser.getConfig().getHighestProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getProtocolVersion().getValue())));
    }

    private void prepareCipherSuites(SSL2ClientHelloMessage message) {
        ByteArrayOutputStream cipherStream = new ByteArrayOutputStream();
        for (SSL2CipherSuite suite : SSL2CipherSuite.values()) {
            try {
                if (suite == SSL2CipherSuite.SSL_UNKNOWN_CIPHER) continue;
                cipherStream.write(suite.getByteValue());
            }
            catch (IOException ex) {
                throw new PreparationException("Could not prepare SSL2ClientHello. Failed to write Ciphersuites into message", ex);
            }
        }
        message.setCipherSuites(cipherStream.toByteArray());
        LOGGER.debug("CipherSuites: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getCipherSuites().getValue())));
    }

    private void prepareChallenge(SSL2ClientHelloMessage message, byte[] challenge) {
        message.setChallenge(challenge);
        LOGGER.debug("Challenge: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getChallenge().getValue())));
    }

    private void prepareSessionID(SSL2ClientHelloMessage message) {
        message.setSessionID(this.chooser.getClientSessionId());
        LOGGER.debug("SessionID: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getSessionId().getValue())));
    }

    private void prepareSessionIDLength(SSL2ClientHelloMessage message) {
        message.setSessionIDLength(((byte[])message.getSessionId().getValue()).length);
        LOGGER.debug("SessionIDLength: " + message.getSessionIdLength().getValue());
    }

    private void prepareChallengeLength(SSL2ClientHelloMessage message) {
        message.setChallengeLength(((byte[])message.getChallenge().getValue()).length);
        LOGGER.debug("ChallengeLength: " + message.getChallengeLength().getValue());
    }

    private void prepareCipherSuiteLength(SSL2ClientHelloMessage message) {
        message.setCipherSuiteLength(((byte[])message.getCipherSuites().getValue()).length);
        LOGGER.debug("CipherSuiteLength: " + message.getCipherSuiteLength().getValue());
    }

    private void prepareMessageLength(SSL2ClientHelloMessage message, int length) {
        message.setMessageLength(length);
        LOGGER.debug("MessageLength: " + message.getMessageLength().getValue());
    }
}

