# https://raw.githubusercontent.com/adobe-type-tools/agl-aglfn/master/glyphlist.txt

# converted manually to python
# Extended with data from GlyphNameFormatter:
#    https://github.com/LettError/glyphNameFormatter

# -----------------------------------------------------------
# Copyright 2002-2019 Adobe (http://www.adobe.com/).
#
# Redistribution and use in source and binary forms, with or
# without modification, are permitted provided that the
# following conditions are met:
#
# Redistributions of source code must retain the above
# copyright notice, this list of conditions and the following
# disclaimer.
#
# Redistributions in binary form must reproduce the above
# copyright notice, this list of conditions and the following
# disclaimer in the documentation and/or other materials
# provided with the distribution.
#
# Neither the name of Adobe nor the names of its contributors
# may be used to endorse or promote products derived from this
# software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# -----------------------------------------------------------
# Name:          Adobe Glyph List
# Table version: 2.0
# Date:          September 20, 2002
# URL:           https://github.com/adobe-type-tools/agl-aglfn
#
# Format: two semicolon-delimited fields:
#   (1) glyph name--upper/lowercase letters and digits
#   (2) Unicode scalar value--four uppercase hexadecimal digits
#
adobe_glyphs = {
    "/A": "\u0041",
    "/AA": "\uA732",
    "/AE": "\u00C6",
    "/AEacute": "\u01FC",
    "/AEmacron": "\u01E2",
    "/AEsmall": "\uF7E6",
    "/AO": "\uA734",
    "/AU": "\uA736",
    "/AV": "\uA738",
    "/AVhorizontalbar": "\uA73A",
    "/AY": "\uA73C",
    "/Aacute": "\u00C1",
    "/Aacutesmall": "\uF7E1",
    "/Abreve": "\u0102",
    "/Abreveacute": "\u1EAE",
    "/Abrevecyr": "\u04D0",
    "/Abrevecyrillic": "\u04D0",
    "/Abrevedotbelow": "\u1EB6",
    "/Abrevegrave": "\u1EB0",
    "/Abrevehoi": "\u1EB2",
    "/Abrevehookabove": "\u1EB2",
    "/Abrevetilde": "\u1EB4",
    "/Acaron": "\u01CD",
    "/Acircle": "\u24B6",
    "/Acircleblack": "\u1F150",
    "/Acircumflex": "\u00C2",
    "/Acircumflexacute": "\u1EA4",
    "/Acircumflexdotbelow": "\u1EAC",
    "/Acircumflexgrave": "\u1EA6",
    "/Acircumflexhoi": "\u1EA8",
    "/Acircumflexhookabove": "\u1EA8",
    "/Acircumflexsmall": "\uF7E2",
    "/Acircumflextilde": "\u1EAA",
    "/Acute": "\uF6C9",
    "/Acutesmall": "\uF7B4",
    "/Acyr": "\u0410",
    "/Acyrillic": "\u0410",
    "/Adblgrave": "\u0200",
    "/Adieresis": "\u00C4",
    "/Adieresiscyr": "\u04D2",
    "/Adieresiscyrillic": "\u04D2",
    "/Adieresismacron": "\u01DE",
    "/Adieresissmall": "\uF7E4",
    "/Adot": "\u0226",
    "/Adotbelow": "\u1EA0",
    "/Adotmacron": "\u01E0",
    "/Agrave": "\u00C0",
    "/Agravedbl": "\u0200",
    "/Agravesmall": "\uF7E0",
    "/Ahoi": "\u1EA2",
    "/Ahookabove": "\u1EA2",
    "/Aiecyr": "\u04D4",
    "/Aiecyrillic": "\u04D4",
    "/Ainvertedbreve": "\u0202",
    "/Akbar": "\uFDF3",
    "/Alayhe": "\uFDF7",
    "/Allah": "\uFDF2",
    "/Alpha": "\u0391",
    "/Alphaacute": "\u1FBB",
    "/Alphaasper": "\u1F09",
    "/Alphaasperacute": "\u1F0D",
    "/Alphaasperacuteiotasub": "\u1F8D",
    "/Alphaaspergrave": "\u1F0B",
    "/Alphaaspergraveiotasub": "\u1F8B",
    "/Alphaasperiotasub": "\u1F89",
    "/Alphaaspertilde": "\u1F0F",
    "/Alphaaspertildeiotasub": "\u1F8F",
    "/Alphabreve": "\u1FB8",
    "/Alphagrave": "\u1FBA",
    "/Alphaiotasub": "\u1FBC",
    "/Alphalenis": "\u1F08",
    "/Alphalenisacute": "\u1F0C",
    "/Alphalenisacuteiotasub": "\u1F8C",
    "/Alphalenisgrave": "\u1F0A",
    "/Alphalenisgraveiotasub": "\u1F8A",
    "/Alphalenisiotasub": "\u1F88",
    "/Alphalenistilde": "\u1F0E",
    "/Alphalenistildeiotasub": "\u1F8E",
    "/Alphatonos": "\u0386",
    "/Alphawithmacron": "\u1FB9",
    "/Amacron": "\u0100",
    "/Amonospace": "\uFF21",
    "/Aogonek": "\u0104",
    "/Aparens": "\u1F110",
    "/Aring": "\u00C5",
    "/Aringacute": "\u01FA",
    "/Aringbelow": "\u1E00",
    "/Aringsmall": "\uF7E5",
    "/Asmall": "\uF761",
    "/Asquare": "\u1F130",
    "/Asquareblack": "\u1F170",
    "/Astroke": "\u023A",
    "/Atilde": "\u00C3",
    "/Atildesmall": "\uF7E3",
    "/Aturned": "\u2C6F",
    "/Ayahend": "\u06DD",
    "/Aybarmenian": "\u0531",
    "/B": "\u0042",
    "/Bcircle": "\u24B7",
    "/Bcircleblack": "\u1F151",
    "/Bdot": "\u1E02",
    "/Bdotaccent": "\u1E02",
    "/Bdotbelow": "\u1E04",
    "/Becyr": "\u0411",
    "/Becyrillic": "\u0411",
    "/Benarmenian": "\u0532",
    "/Beta": "\u0392",
    "/Bflourish": "\uA796",
    "/Bhook": "\u0181",
    "/BismillahArRahmanArRaheem": "\uFDFD",
    "/Blinebelow": "\u1E06",
    "/Bmonospace": "\uFF22",
    "/Bparens": "\u1F111",
    "/Brevesmall": "\uF6F4",
    "/Bscript": "\u212C",
    "/Bsmall": "\uF762",
    "/Bsquare": "\u1F131",
    "/Bsquareblack": "\u1F171",
    "/Bstroke": "\u0243",
    "/Btopbar": "\u0182",
    "/C": "\u0043",
    "/CDcircle": "\u1F12D",
    "/Caarmenian": "\u053E",
    "/Cacute": "\u0106",
    "/Caron": "\uF6CA",
    "/Caronsmall": "\uF6F5",
    "/Cbar": "\uA792",
    "/Ccaron": "\u010C",
    "/Ccedilla": "\u00C7",
    "/Ccedillaacute": "\u1E08",
    "/Ccedillasmall": "\uF7E7",
    "/Ccircle": "\u24B8",
    "/Ccircleblack": "\u1F152",
    "/Ccircumflex": "\u0108",
    "/Cdblstruck": "\u2102",
    "/Cdot": "\u010A",
    "/Cdotaccent": "\u010A",
    "/Cdotreversed": "\uA73E",
    "/Cedillasmall": "\uF7B8",
    "/Cfraktur": "\u212D",
    "/Chaarmenian": "\u0549",
    "/Cheabkhasiancyrillic": "\u04BC",
    "/Cheabkhcyr": "\u04BC",
    "/Cheabkhtailcyr": "\u04BE",
    "/Checyr": "\u0427",
    "/Checyrillic": "\u0427",
    "/Chedescenderabkhasiancyrillic": "\u04BE",
    "/Chedescendercyrillic": "\u04B6",
    "/Chedieresiscyr": "\u04F4",
    "/Chedieresiscyrillic": "\u04F4",
    "/Cheharmenian": "\u0543",
    "/Chekhakascyr": "\u04CB",
    "/Chekhakassiancyrillic": "\u04CB",
    "/Chetailcyr": "\u04B6",
    "/Chevertcyr": "\u04B8",
    "/Cheverticalstrokecyrillic": "\u04B8",
    "/Chi": "\u03A7",
    "/Chook": "\u0187",
    "/Circumflexsmall": "\uF6F6",
    "/Citaliccircle": "\u1F12B",
    "/Cmonospace": "\uFF23",
    "/Coarmenian": "\u0551",
    "/Con": "\uA76E",
    "/Cparens": "\u1F112",
    "/Csmall": "\uF763",
    "/Csquare": "\u1F132",
    "/Csquareblack": "\u1F172",
    "/Cstretched": "\u0297",
    "/Cstroke": "\u023B",
    "/Cuatrillo": "\uA72C",
    "/Cuatrillocomma": "\uA72E",
    "/D": "\u0044",
    "/DZ": "\u01F1",
    "/DZcaron": "\u01C4",
    "/Daarmenian": "\u0534",
    "/Dafrican": "\u0189",
    "/Dcaron": "\u010E",
    "/Dcedilla": "\u1E10",
    "/Dchecyr": "\u052C",
    "/Dcircle": "\u24B9",
    "/Dcircleblack": "\u1F153",
    "/Dcircumflexbelow": "\u1E12",
    "/Dcroat": "\u0110",
    "/Ddblstruckitalic": "\u2145",
    "/Ddot": "\u1E0A",
    "/Ddotaccent": "\u1E0A",
    "/Ddotbelow": "\u1E0C",
    "/Decyr": "\u0414",
    "/Decyrillic": "\u0414",
    "/Deicoptic": "\u03EE",
    "/Dekomicyr": "\u0500",
    "/Delta": "\u2206",
    "/Deltagreek": "\u0394",
    "/Dhook": "\u018A",
    "/Dieresis": "\uF6CB",
    "/DieresisAcute": "\uF6CC",
    "/DieresisGrave": "\uF6CD",
    "/Dieresissmall": "\uF7A8",
    "/Digamma": "\u03DC",
    "/Digammagreek": "\u03DC",
    "/Digammapamphylian": "\u0376",
    "/Dinsular": "\uA779",
    "/Djecyr": "\u0402",
    "/Djecyrillic": "\u0402",
    "/Djekomicyr": "\u0502",
    "/Dlinebelow": "\u1E0E",
    "/Dmonospace": "\uFF24",
    "/Dotaccentsmall": "\uF6F7",
    "/Dparens": "\u1F113",
    "/Dslash": "\u0110",
    "/Dsmall": "\uF764",
    "/Dsquare": "\u1F133",
    "/Dsquareblack": "\u1F173",
    "/Dtopbar": "\u018B",
    "/Dz": "\u01F2",
    "/Dzcaron": "\u01C5",
    "/Dzeabkhasiancyrillic": "\u04E0",
    "/Dzeabkhcyr": "\u04E0",
    "/Dzecyr": "\u0405",
    "/Dzecyrillic": "\u0405",
    "/Dzhecyr": "\u040F",
    "/Dzhecyrillic": "\u040F",
    "/Dzjekomicyr": "\u0506",
    "/Dzzhecyr": "\u052A",
    "/E": "\u0045",
    "/Eacute": "\u00C9",
    "/Eacutesmall": "\uF7E9",
    "/Ebreve": "\u0114",
    "/Ecaron": "\u011A",
    "/Ecedilla": "\u0228",
    "/Ecedillabreve": "\u1E1C",
    "/Echarmenian": "\u0535",
    "/Ecircle": "\u24BA",
    "/Ecircleblack": "\u1F154",
    "/Ecircumflex": "\u00CA",
    "/Ecircumflexacute": "\u1EBE",
    "/Ecircumflexbelow": "\u1E18",
    "/Ecircumflexdotbelow": "\u1EC6",
    "/Ecircumflexgrave": "\u1EC0",
    "/Ecircumflexhoi": "\u1EC2",
    "/Ecircumflexhookabove": "\u1EC2",
    "/Ecircumflexsmall": "\uF7EA",
    "/Ecircumflextilde": "\u1EC4",
    "/Ecyrillic": "\u0404",
    "/Edblgrave": "\u0204",
    "/Edieresis": "\u00CB",
    "/Edieresissmall": "\uF7EB",
    "/Edot": "\u0116",
    "/Edotaccent": "\u0116",
    "/Edotbelow": "\u1EB8",
    "/Efcyr": "\u0424",
    "/Efcyrillic": "\u0424",
    "/Egrave": "\u00C8",
    "/Egravedbl": "\u0204",
    "/Egravesmall": "\uF7E8",
    "/Egyptain": "\uA724",
    "/Egyptalef": "\uA722",
    "/Eharmenian": "\u0537",
    "/Ehoi": "\u1EBA",
    "/Ehookabove": "\u1EBA",
    "/Eightroman": "\u2167",
    "/Einvertedbreve": "\u0206",
    "/Eiotifiedcyr": "\u0464",
    "/Eiotifiedcyrillic": "\u0464",
    "/Elcyr": "\u041B",
    "/Elcyrillic": "\u041B",
    "/Elevenroman": "\u216A",
    "/Elhookcyr": "\u0512",
    "/Elmiddlehookcyr": "\u0520",
    "/Elsharptailcyr": "\u04C5",
    "/Eltailcyr": "\u052E",
    "/Emacron": "\u0112",
    "/Emacronacute": "\u1E16",
    "/Emacrongrave": "\u1E14",
    "/Emcyr": "\u041C",
    "/Emcyrillic": "\u041C",
    "/Emonospace": "\uFF25",
    "/Emsharptailcyr": "\u04CD",
    "/Encyr": "\u041D",
    "/Encyrillic": "\u041D",
    "/Endescendercyrillic": "\u04A2",
    "/Eng": "\u014A",
    "/Engecyr": "\u04A4",
    "/Enghecyrillic": "\u04A4",
    "/Enhookcyr": "\u04C7",
    "/Enhookcyrillic": "\u04C7",
    "/Enhookleftcyr": "\u0528",
    "/Enmiddlehookcyr": "\u0522",
    "/Ensharptailcyr": "\u04C9",
    "/Entailcyr": "\u04A2",
    "/Eogonek": "\u0118",
    "/Eopen": "\u0190",
    "/Eparens": "\u1F114",
    "/Epsilon": "\u0395",
    "/Epsilonacute": "\u1FC9",
    "/Epsilonasper": "\u1F19",
    "/Epsilonasperacute": "\u1F1D",
    "/Epsilonaspergrave": "\u1F1B",
    "/Epsilongrave": "\u1FC8",
    "/Epsilonlenis": "\u1F18",
    "/Epsilonlenisacute": "\u1F1C",
    "/Epsilonlenisgrave": "\u1F1A",
    "/Epsilontonos": "\u0388",
    "/Ercyr": "\u0420",
    "/Ercyrillic": "\u0420",
    "/Ereversed": "\u018E",
    "/Ereversedcyr": "\u042D",
    "/Ereversedcyrillic": "\u042D",
    "/Ereverseddieresiscyr": "\u04EC",
    "/Ereversedopen": "\uA7AB",
    "/Ertickcyr": "\u048E",
    "/Escript": "\u2130",
    "/Escyr": "\u0421",
    "/Escyrillic": "\u0421",
    "/Esdescendercyrillic": "\u04AA",
    "/Esh": "\u01A9",
    "/Esmall": "\uF765",
    "/Esmallturned": "\u2C7B",
    "/Esquare": "\u1F134",
    "/Esquareblack": "\u1F174",
    "/Estailcyr": "\u04AA",
    "/Estroke": "\u0246",
    "/Et": "\uA76A",
    "/Eta": "\u0397",
    "/Etaacute": "\u1FCB",
    "/Etaasper": "\u1F29",
    "/Etaasperacute": "\u1F2D",
    "/Etaasperacuteiotasub": "\u1F9D",
    "/Etaaspergrave": "\u1F2B",
    "/Etaaspergraveiotasub": "\u1F9B",
    "/Etaasperiotasub": "\u1F99",
    "/Etaaspertilde": "\u1F2F",
    "/Etaaspertildeiotasub": "\u1F9F",
    "/Etagrave": "\u1FCA",
    "/Etaiotasub": "\u1FCC",
    "/Etalenis": "\u1F28",
    "/Etalenisacute": "\u1F2C",
    "/Etalenisacuteiotasub": "\u1F9C",
    "/Etalenisgrave": "\u1F2A",
    "/Etalenisgraveiotasub": "\u1F9A",
    "/Etalenisiotasub": "\u1F98",
    "/Etalenistilde": "\u1F2E",
    "/Etalenistildeiotasub": "\u1F9E",
    "/Etarmenian": "\u0538",
    "/Etatonos": "\u0389",
    "/Eth": "\u00D0",
    "/Ethsmall": "\uF7F0",
    "/Etilde": "\u1EBC",
    "/Etildebelow": "\u1E1A",
    "/Eukrcyr": "\u0404",
    "/Euro": "\u20AC",
    "/Ezh": "\u01B7",
    "/Ezhcaron": "\u01EE",
    "/Ezhreversed": "\u01B8",
    "/F": "\u0046",
    "/Fcircle": "\u24BB",
    "/Fcircleblack": "\u1F155",
    "/Fdot": "\u1E1E",
    "/Fdotaccent": "\u1E1E",
    "/Feharmenian": "\u0556",
    "/Feicoptic": "\u03E4",
    "/Fhook": "\u0191",
    "/Finsular": "\uA77B",
    "/Fitacyr": "\u0472",
    "/Fitacyrillic": "\u0472",
    "/Fiveroman": "\u2164",
    "/Fmonospace": "\uFF26",
    "/Fourroman": "\u2163",
    "/Fparens": "\u1F115",
    "/Fscript": "\u2131",
    "/Fsmall": "\uF766",
    "/Fsquare": "\u1F135",
    "/Fsquareblack": "\u1F175",
    "/Fstroke": "\uA798",
    "/Fturned": "\u2132",
    "/G": "\u0047",
    "/GBsquare": "\u3387",
    "/Gacute": "\u01F4",
    "/Gamma": "\u0393",
    "/Gammaafrican": "\u0194",
    "/Gammadblstruck": "\u213E",
    "/Gangiacoptic": "\u03EA",
    "/Gbreve": "\u011E",
    "/Gcaron": "\u01E6",
    "/Gcedilla": "\u0122",
    "/Gcircle": "\u24BC",
    "/Gcircleblack": "\u1F156",
    "/Gcircumflex": "\u011C",
    "/Gcommaaccent": "\u0122",
    "/Gdot": "\u0120",
    "/Gdotaccent": "\u0120",
    "/Gecyr": "\u0413",
    "/Gecyrillic": "\u0413",
    "/Gehookcyr": "\u0494",
    "/Gehookstrokecyr": "\u04FA",
    "/Germandbls": "\u1E9E",
    "/Gestrokecyr": "\u0492",
    "/Getailcyr": "\u04F6",
    "/Geupcyr": "\u0490",
    "/Ghadarmenian": "\u0542",
    "/Ghemiddlehookcyrillic": "\u0494",
    "/Ghestrokecyrillic": "\u0492",
    "/Gheupturncyrillic": "\u0490",
    "/Ghook": "\u0193",
    "/Ghooksmall": "\u029B",
    "/Gimarmenian": "\u0533",
    "/Ginsular": "\uA77D",
    "/Ginsularturned": "\uA77E",
    "/Gjecyr": "\u0403",
    "/Gjecyrillic": "\u0403",
    "/Glottalstop": "\u0241",
    "/Gmacron": "\u1E20",
    "/Gmonospace": "\uFF27",
    "/Gobliquestroke": "\uA7A0",
    "/Gparens": "\u1F116",
    "/Grave": "\uF6CE",
    "/Gravesmall": "\uF760",
    "/Gsmall": "\uF767",
    "/Gsmallhook": "\u029B",
    "/Gsquare": "\u1F136",
    "/Gsquareblack": "\u1F176",
    "/Gstroke": "\u01E4",
    "/Gturnedsans": "\u2141",
    "/H": "\u0048",
    "/H18533": "\u25CF",
    "/H18543": "\u25AA",
    "/H18551": "\u25AB",
    "/H22073": "\u25A1",
    "/HPsquare": "\u33CB",
    "/HVsquare": "\u1F14A",
    "/Haabkhasiancyrillic": "\u04A8",
    "/Haabkhcyr": "\u04A8",
    "/Hacyr": "\u0425",
    "/Hadescendercyrillic": "\u04B2",
    "/Hahookcyr": "\u04FC",
    "/Hardcyr": "\u042A",
    "/Hardsigncyrillic": "\u042A",
    "/Hastrokecyr": "\u04FE",
    "/Hbar": "\u0126",
    "/Hbrevebelow": "\u1E2A",
    "/Hcaron": "\u021E",
    "/Hcedilla": "\u1E28",
    "/Hcircle": "\u24BD",
    "/Hcircleblack": "\u1F157",
    "/Hcircumflex": "\u0124",
    "/Hdblstruck": "\u210D",
    "/Hdescender": "\u2C67",
    "/Hdieresis": "\u1E26",
    "/Hdot": "\u1E22",
    "/Hdotaccent": "\u1E22",
    "/Hdotbelow": "\u1E24",
    "/Heng": "\uA726",
    "/Heta": "\u0370",
    "/Hfraktur": "\u210C",
    "/Hgfullwidth": "\u32CC",
    "/Hhalf": "\u2C75",
    "/Hhook": "\uA7AA",
    "/Hmonospace": "\uFF28",
    "/Hoarmenian": "\u0540",
    "/HonAA": "\u0611",
    "/HonRA": "\u0612",
    "/HonSAW": "\u0610",
    "/Horicoptic": "\u03E8",
    "/Hparens": "\u1F117",
    "/Hscript": "\u210B",
    "/Hsmall": "\uF768",
    "/Hsquare": "\u1F137",
    "/Hsquareblack": "\u1F177",
    "/Hstrokemod": "\uA7F8",
    "/Hturned": "\uA78D",
    "/Hungarumlaut": "\uF6CF",
    "/Hungarumlautsmall": "\uF6F8",
    "/Hwair": "\u01F6",
    "/Hzsquare": "\u3390",
    "/I": "\u0049",
    "/IAcyrillic": "\u042F",
    "/ICsquareblack": "\u1F18B",
    "/IJ": "\u0132",
    "/IUcyrillic": "\u042E",
    "/Iacute": "\u00CD",
    "/Iacutesmall": "\uF7ED",
    "/Ibreve": "\u012C",
    "/Icaron": "\u01CF",
    "/Icircle": "\u24BE",
    "/Icircleblack": "\u1F158",
    "/Icircumflex": "\u00CE",
    "/Icircumflexsmall": "\uF7EE",
    "/Icyr": "\u0418",
    "/Icyrillic": "\u0406",
    "/Idblgrave": "\u0208",
    "/Idieresis": "\u00CF",
    "/Idieresisacute": "\u1E2E",
    "/Idieresiscyr": "\u04E4",
    "/Idieresiscyrillic": "\u04E4",
    "/Idieresissmall": "\uF7EF",
    "/Idot": "\u0130",
    "/Idotaccent": "\u0130",
    "/Idotbelow": "\u1ECA",
    "/Iebrevecyr": "\u04D6",
    "/Iebrevecyrillic": "\u04D6",
    "/Iecyr": "\u0415",
    "/Iecyrillic": "\u0415",
    "/Iegravecyr": "\u0400",
    "/Ifraktur": "\u2111",
    "/Igrave": "\u00CC",
    "/Igravecyr": "\u040D",
    "/Igravedbl": "\u0208",
    "/Igravesmall": "\uF7EC",
    "/Ihoi": "\u1EC8",
    "/Ihookabove": "\u1EC8",
    "/Iicyrillic": "\u0418",
    "/Iinvertedbreve": "\u020A",
    "/Iishortcyrillic": "\u0419",
    "/Imacron": "\u012A",
    "/Imacroncyr": "\u04E2",
    "/Imacroncyrillic": "\u04E2",
    "/Imonospace": "\uFF29",
    "/Iniarmenian": "\u053B",
    "/Iocyr": "\u0401",
    "/Iocyrillic": "\u0401",
    "/Iogonek": "\u012E",
    "/Iota": "\u0399",
    "/Iotaacute": "\u1FDB",
    "/Iotaafrican": "\u0196",
    "/Iotaasper": "\u1F39",
    "/Iotaasperacute": "\u1F3D",
    "/Iotaaspergrave": "\u1F3B",
    "/Iotaaspertilde": "\u1F3F",
    "/Iotabreve": "\u1FD8",
    "/Iotadieresis": "\u03AA",
    "/Iotagrave": "\u1FDA",
    "/Iotalenis": "\u1F38",
    "/Iotalenisacute": "\u1F3C",
    "/Iotalenisgrave": "\u1F3A",
    "/Iotalenistilde": "\u1F3E",
    "/Iotatonos": "\u038A",
    "/Iotawithmacron": "\u1FD9",
    "/Iparens": "\u1F118",
    "/Is": "\uA76C",
    "/Iscript": "\u2110",
    "/Ishortcyr": "\u0419",
    "/Ishortsharptailcyr": "\u048A",
    "/Ismall": "\uF769",
    "/Isquare": "\u1F138",
    "/Isquareblack": "\u1F178",
    "/Istroke": "\u0197",
    "/Itilde": "\u0128",
    "/Itildebelow": "\u1E2C",
    "/Iukrcyr": "\u0406",
    "/Izhitsacyr": "\u0474",
    "/Izhitsacyrillic": "\u0474",
    "/Izhitsadblgravecyrillic": "\u0476",
    "/Izhitsagravedblcyr": "\u0476",
    "/J": "\u004A",
    "/Jaarmenian": "\u0541",
    "/Jallajalalouhou": "\uFDFB",
    "/Jcircle": "\u24BF",
    "/Jcircleblack": "\u1F159",
    "/Jcircumflex": "\u0134",
    "/Jcrossed-tail": "\uA7B2",
    "/Jecyr": "\u0408",
    "/Jecyrillic": "\u0408",
    "/Jheharmenian": "\u054B",
    "/Jmonospace": "\uFF2A",
    "/Jparens": "\u1F119",
    "/Jsmall": "\uF76A",
    "/Jsquare": "\u1F139",
    "/Jsquareblack": "\u1F179",
    "/Jstroke": "\u0248",
    "/K": "\u004B",
    "/KBsquare": "\u3385",
    "/KKsquare": "\u33CD",
    "/KORONIS": "\u1FBD",
    "/Kaaleutcyr": "\u051E",
    "/Kabashkcyr": "\u04A0",
    "/Kabashkircyrillic": "\u04A0",
    "/Kacute": "\u1E30",
    "/Kacyr": "\u041A",
    "/Kacyrillic": "\u041A",
    "/Kadescendercyrillic": "\u049A",
    "/Kahookcyr": "\u04C3",
    "/Kahookcyrillic": "\u04C3",
    "/Kaisymbol": "\u03CF",
    "/Kappa": "\u039A",
    "/Kastrokecyr": "\u049E",
    "/Kastrokecyrillic": "\u049E",
    "/Katailcyr": "\u049A",
    "/Kaverticalstrokecyr": "\u049C",
    "/Kaverticalstrokecyrillic": "\u049C",
    "/Kcaron": "\u01E8",
    "/Kcedilla": "\u0136",
    "/Kcircle": "\u24C0",
    "/Kcircleblack": "\u1F15A",
    "/Kcommaaccent": "\u0136",
    "/Kdescender": "\u2C69",
    "/Kdiagonalstroke": "\uA742",
    "/Kdotbelow": "\u1E32",
    "/Keharmenian": "\u0554",
    "/Kenarmenian": "\u053F",
    "/Khacyrillic": "\u0425",
    "/Kheicoptic": "\u03E6",
    "/Khook": "\u0198",
    "/Kjecyr": "\u040C",
    "/Kjecyrillic": "\u040C",
    "/Klinebelow": "\u1E34",
    "/Kmonospace": "\uFF2B",
    "/Kobliquestroke": "\uA7A2",
    "/Koppa": "\u03DE",
    "/Koppaarchaic": "\u03D8",
    "/Koppacyr": "\u0480",
    "/Koppacyrillic": "\u0480",
    "/Koppagreek": "\u03DE",
    "/Kparens": "\u1F11A",
    "/Ksicyr": "\u046E",
    "/Ksicyrillic": "\u046E",
    "/Ksmall": "\uF76B",
    "/Ksquare": "\u1F13A",
    "/Ksquareblack": "\u1F17A",
    "/Kstroke": "\uA740",
    "/Kstrokediagonalstroke": "\uA744",
    "/Kturned": "\uA7B0",
    "/L": "\u004C",
    "/LJ": "\u01C7",
    "/LL": "\uF6BF",
    "/LLwelsh": "\u1EFA",
    "/LTDfullwidth": "\u32CF",
    "/Lacute": "\u0139",
    "/Lambda": "\u039B",
    "/Lbar": "\u023D",
    "/Lbelt": "\uA7AD",
    "/Lbroken": "\uA746",
    "/Lcaron": "\u013D",
    "/Lcedilla": "\u013B",
    "/Lcircle": "\u24C1",
    "/Lcircleblack": "\u1F15B",
    "/Lcircumflexbelow": "\u1E3C",
    "/Lcommaaccent": "\u013B",
    "/Ldblbar": "\u2C60",
    "/Ldot": "\u013F",
    "/Ldotaccent": "\u013F",
    "/Ldotbelow": "\u1E36",
    "/Ldotbelowmacron": "\u1E38",
    "/Lhacyr": "\u0514",
    "/Liwnarmenian": "\u053C",
    "/Lj": "\u01C8",
    "/Ljecyr": "\u0409",
    "/Ljecyrillic": "\u0409",
    "/Ljekomicyr": "\u0508",
    "/Llinebelow": "\u1E3A",
    "/Lmacrondot": "\u1E38",
    "/Lmiddletilde": "\u2C62",
    "/Lmonospace": "\uFF2C",
    "/Lparens": "\u1F11B",
    "/Lreversedsans": "\u2143",
    "/Lscript": "\u2112",
    "/Lslash": "\u0141",
    "/Lslashsmall": "\uF6F9",
    "/Lsmall": "\uF76C",
    "/Lsquare": "\u1F13B",
    "/Lsquareblack": "\u1F17B",
    "/Lstroke": "\uA748",
    "/Lturned": "\uA780",
    "/Lturnedsans": "\u2142",
    "/M": "\u004D",
    "/MBsquare": "\u3386",
    "/MVsquare": "\u1F14B",
    "/Macron": "\uF6D0",
    "/Macronsmall": "\uF7AF",
    "/Macute": "\u1E3E",
    "/Mcircle": "\u24C2",
    "/Mcircleblack": "\u1F15C",
    "/Mdot": "\u1E40",
    "/Mdotaccent": "\u1E40",
    "/Mdotbelow": "\u1E42",
    "/Menarmenian": "\u0544",
    "/Mhook": "\u2C6E",
    "/Mmonospace": "\uFF2D",
    "/Mohammad": "\uFDF4",
    "/Mparens": "\u1F11C",
    "/Mscript": "\u2133",
    "/Msmall": "\uF76D",
    "/Msquare": "\u1F13C",
    "/Msquareblack": "\u1F17C",
    "/Mturned": "\u019C",
    "/Mturnedsmall": "\uA7FA",
    "/Mu": "\u039C",
    "/N": "\u004E",
    "/NJ": "\u01CA",
    "/Nacute": "\u0143",
    "/Ncaron": "\u0147",
    "/Ncedilla": "\u0145",
    "/Ncircle": "\u24C3",
    "/Ncircleblack": "\u1F15D",
    "/Ncircumflexbelow": "\u1E4A",
    "/Ncommaaccent": "\u0145",
    "/Ndblstruck": "\u2115",
    "/Ndescender": "\uA790",
    "/Ndot": "\u1E44",
    "/Ndotaccent": "\u1E44",
    "/Ndotbelow": "\u1E46",
    "/Ngrave": "\u01F8",
    "/Nhookleft": "\u019D",
    "/Nineroman": "\u2168",
    "/Nj": "\u01CB",
    "/Njecyr": "\u040A",
    "/Njecyrillic": "\u040A",
    "/Njekomicyr": "\u050A",
    "/Nlinebelow": "\u1E48",
    "/Nlongrightleg": "\u0220",
    "/Nmonospace": "\uFF2E",
    "/Nobliquestroke": "\uA7A4",
    "/Nowarmenian": "\u0546",
    "/Nparens": "\u1F11D",
    "/Nsmall": "\uF76E",
    "/Nsquare": "\u1F13D",
    "/Nsquareblack": "\u1F17D",
    "/Ntilde": "\u00D1",
    "/Ntildesmall": "\uF7F1",
    "/Nu": "\u039D",
    "/O": "\u004F",
    "/OE": "\u0152",
    "/OEsmall": "\uF6FA",
    "/OO": "\uA74E",
    "/Oacute": "\u00D3",
    "/Oacutesmall": "\uF7F3",
    "/Obar": "\u019F",
    "/Obarcyr": "\u04E8",
    "/Obardieresiscyr": "\u04EA",
    "/Obarredcyrillic": "\u04E8",
    "/Obarreddieresiscyrillic": "\u04EA",
    "/Obreve": "\u014E",
    "/Ocaron": "\u01D1",
    "/Ocenteredtilde": "\u019F",
    "/Ocircle": "\u24C4",
    "/Ocircleblack": "\u1F15E",
    "/Ocircumflex": "\u00D4",
    "/Ocircumflexacute": "\u1ED0",
    "/Ocircumflexdotbelow": "\u1ED8",
    "/Ocircumflexgrave": "\u1ED2",
    "/Ocircumflexhoi": "\u1ED4",
    "/Ocircumflexhookabove": "\u1ED4",
    "/Ocircumflexsmall": "\uF7F4",
    "/Ocircumflextilde": "\u1ED6",
    "/Ocyr": "\u041E",
    "/Ocyrillic": "\u041E",
    "/Odblacute": "\u0150",
    "/Odblgrave": "\u020C",
    "/Odieresis": "\u00D6",
    "/Odieresiscyr": "\u04E6",
    "/Odieresiscyrillic": "\u04E6",
    "/Odieresismacron": "\u022A",
    "/Odieresissmall": "\uF7F6",
    "/Odot": "\u022E",
    "/Odotbelow": "\u1ECC",
    "/Odotmacron": "\u0230",
    "/Ogoneksmall": "\uF6FB",
    "/Ograve": "\u00D2",
    "/Ogravedbl": "\u020C",
    "/Ogravesmall": "\uF7F2",
    "/Oharmenian": "\u0555",
    "/Ohm": "\u2126",
    "/Ohoi": "\u1ECE",
    "/Ohookabove": "\u1ECE",
    "/Ohorn": "\u01A0",
    "/Ohornacute": "\u1EDA",
    "/Ohorndotbelow": "\u1EE2",
    "/Ohorngrave": "\u1EDC",
    "/Ohornhoi": "\u1EDE",
    "/Ohornhookabove": "\u1EDE",
    "/Ohorntilde": "\u1EE0",
    "/Ohungarumlaut": "\u0150",
    "/Oi": "\u01A2",
    "/Oinvertedbreve": "\u020E",
    "/Oloop": "\uA74C",
    "/Omacron": "\u014C",
    "/Omacronacute": "\u1E52",
    "/Omacrongrave": "\u1E50",
    "/Omega": "\u2126",
    "/Omegaacute": "\u1FFB",
    "/Omegaasper": "\u1F69",
    "/Omegaasperacute": "\u1F6D",
    "/Omegaasperacuteiotasub": "\u1FAD",
    "/Omegaaspergrave": "\u1F6B",
    "/Omegaaspergraveiotasub": "\u1FAB",
    "/Omegaasperiotasub": "\u1FA9",
    "/Omegaaspertilde": "\u1F6F",
    "/Omegaaspertildeiotasub": "\u1FAF",
    "/Omegacyr": "\u0460",
    "/Omegacyrillic": "\u0460",
    "/Omegagrave": "\u1FFA",
    "/Omegagreek": "\u03A9",
    "/Omegaiotasub": "\u1FFC",
    "/Omegalenis": "\u1F68",
    "/Omegalenisacute": "\u1F6C",
    "/Omegalenisacuteiotasub": "\u1FAC",
    "/Omegalenisgrave": "\u1F6A",
    "/Omegalenisgraveiotasub": "\u1FAA",
    "/Omegalenisiotasub": "\u1FA8",
    "/Omegalenistilde": "\u1F6E",
    "/Omegalenistildeiotasub": "\u1FAE",
    "/Omegaroundcyr": "\u047A",
    "/Omegaroundcyrillic": "\u047A",
    "/Omegatitlocyr": "\u047C",
    "/Omegatitlocyrillic": "\u047C",
    "/Omegatonos": "\u038F",
    "/Omicron": "\u039F",
    "/Omicronacute": "\u1FF9",
    "/Omicronasper": "\u1F49",
    "/Omicronasperacute": "\u1F4D",
    "/Omicronaspergrave": "\u1F4B",
    "/Omicrongrave": "\u1FF8",
    "/Omicronlenis": "\u1F48",
    "/Omicronlenisacute": "\u1F4C",
    "/Omicronlenisgrave": "\u1F4A",
    "/Omicrontonos": "\u038C",
    "/Omonospace": "\uFF2F",
    "/Oneroman": "\u2160",
    "/Oogonek": "\u01EA",
    "/Oogonekmacron": "\u01EC",
    "/Oopen": "\u0186",
    "/Oparens": "\u1F11E",
    "/Oslash": "\u00D8",
    "/Oslashacute": "\u01FE",
    "/Oslashsmall": "\uF7F8",
    "/Osmall": "\uF76F",
    "/Osquare": "\u1F13E",
    "/Osquareblack": "\u1F17E",
    "/Ostroke": "\uA74A",
    "/Ostrokeacute": "\u01FE",
    "/Otcyr": "\u047E",
    "/Otcyrillic": "\u047E",
    "/Otilde": "\u00D5",
    "/Otildeacute": "\u1E4C",
    "/Otildedieresis": "\u1E4E",
    "/Otildemacron": "\u022C",
    "/Otildesmall": "\uF7F5",
    "/Ou": "\u0222",
    "/P": "\u0050",
    "/PAsquareblack": "\u1F18C",
    "/PPVsquare": "\u1F14E",
    "/Pacute": "\u1E54",
    "/Palochkacyr": "\u04C0",
    "/Pcircle": "\u24C5",
    "/Pcircleblack": "\u1F15F",
    "/Pcrosssquareblack": "\u1F18A",
    "/Pdblstruck": "\u2119",
    "/Pdot": "\u1E56",
    "/Pdotaccent": "\u1E56",
    "/Pecyr": "\u041F",
    "/Pecyrillic": "\u041F",
    "/Peharmenian": "\u054A",
    "/Pehookcyr": "\u04A6",
    "/Pemiddlehookcyrillic": "\u04A6",
    "/Petailcyr": "\u0524",
    "/Pflourish": "\uA752",
    "/Phi": "\u03A6",
    "/Phook": "\u01A4",
    "/Pi": "\u03A0",
    "/Pidblstruck": "\u213F",
    "/Piwrarmenian": "\u0553",
    "/Pmonospace": "\uFF30",
    "/Pparens": "\u1F11F",
    "/Psi": "\u03A8",
    "/Psicyr": "\u0470",
    "/Psicyrillic": "\u0470",
    "/Psmall": "\uF770",
    "/Psquare": "\u1F13F",
    "/Psquareblack": "\u1F17F",
    "/Pstroke": "\u2C63",
    "/Pstrokedescender": "\uA750",
    "/Ptail": "\uA754",
    "/Q": "\u0051",
    "/Qacyr": "\u051A",
    "/QalaUsedAsKoranicStopSign": "\uFDF1",
    "/Qcircle": "\u24C6",
    "/Qcircleblack": "\u1F160",
    "/Qdblstruck": "\u211A",
    "/Qdiagonalstroke": "\uA758",
    "/Qmonospace": "\uFF31",
    "/Qparens": "\u1F120",
    "/Qrotated": "\u213A",
    "/Qsmall": "\uF771",
    "/Qsmallhooktail": "\u024A",
    "/Qsquare": "\u1F140",
    "/Qsquareblack": "\u1F180",
    "/Qstrokedescender": "\uA756",
    "/R": "\u0052",
    "/Raarmenian": "\u054C",
    "/Racute": "\u0154",
    "/Rasoul": "\uFDF6",
    "/Rcaron": "\u0158",
    "/Rcedilla": "\u0156",
    "/Rcircle": "\u24C7",
    "/Rcircleblack": "\u1F161",
    "/Rcommaaccent": "\u0156",
    "/Rdblgrave": "\u0210",
    "/Rdblstruck": "\u211D",
    "/Rdot": "\u1E58",
    "/Rdotaccent": "\u1E58",
    "/Rdotbelow": "\u1E5A",
    "/Rdotbelowmacron": "\u1E5C",
    "/Reharmenian": "\u0550",
    "/Reverseddottedsigmalunatesymbol": "\u03FF",
    "/Reversedzecyr": "\u0510",
    "/Rfraktur": "\u211C",
    "/Rgravedbl": "\u0210",
    "/Rhacyr": "\u0516",
    "/Rho": "\u03A1",
    "/Rhoasper": "\u1FEC",
    "/Ringsmall": "\uF6FC",
    "/Rinsular": "\uA782",
    "/Rinvertedbreve": "\u0212",
    "/Rinvertedsmall": "\u0281",
    "/Ritaliccircle": "\u1F12C",
    "/Rlinebelow": "\u1E5E",
    "/Rmacrondot": "\u1E5C",
    "/Rmonospace": "\uFF32",
    "/Robliquestroke": "\uA7A6",
    "/Rparens": "\u1F121",
    "/Rrotunda": "\uA75A",
    "/Rscript": "\u211B",
    "/Rsmall": "\uF772",
    "/Rsmallinverted": "\u0281",
    "/Rsmallinvertedsuperior": "\u02B6",
    "/Rsquare": "\u1F141",
    "/Rsquareblack": "\u1F181",
    "/Rstroke": "\u024C",
    "/Rsupinvertedmod": "\u02B6",
    "/Rtail": "\u2C64",
    "/RubElHizbstart": "\u06DE",
    "/Rumrotunda": "\uA75C",
    "/Rumsmall": "\uA776",
    "/S": "\u0053",
    "/SAsquareblack": "\u1F18D",
    "/SDsquare": "\u1F14C",
    "/SF010000": "\u250C",
    "/SF020000": "\u2514",
    "/SF030000": "\u2510",
    "/SF040000": "\u2518",
    "/SF050000": "\u253C",
    "/SF060000": "\u252C",
    "/SF070000": "\u2534",
    "/SF080000": "\u251C",
    "/SF090000": "\u2524",
    "/SF100000": "\u2500",
    "/SF110000": "\u2502",
    "/SF190000": "\u2561",
    "/SF200000": "\u2562",
    "/SF210000": "\u2556",
    "/SF220000": "\u2555",
    "/SF230000": "\u2563",
    "/SF240000": "\u2551",
    "/SF250000": "\u2557",
    "/SF260000": "\u255D",
    "/SF270000": "\u255C",
    "/SF280000": "\u255B",
    "/SF360000": "\u255E",
    "/SF370000": "\u255F",
    "/SF380000": "\u255A",
    "/SF390000": "\u2554",
    "/SF400000": "\u2569",
    "/SF410000": "\u2566",
    "/SF420000": "\u2560",
    "/SF430000": "\u2550",
    "/SF440000": "\u256C",
    "/SF450000": "\u2567",
    "/SF460000": "\u2568",
    "/SF470000": "\u2564",
    "/SF480000": "\u2565",
    "/SF490000": "\u2559",
    "/SF500000": "\u2558",
    "/SF510000": "\u2552",
    "/SF520000": "\u2553",
    "/SF530000": "\u256B",
    "/SF540000": "\u256A",
    "/SSsquare": "\u1F14D",
    "/Sacute": "\u015A",
    "/Sacutedotaccent": "\u1E64",
    "/Safha": "\u0603",
    "/Sajdah": "\u06E9",
    "/Salam": "\uFDF5",
    "/Salla": "\uFDF9",
    "/SallaUsedAsKoranicStopSign": "\uFDF0",
    "/SallallahouAlayheWasallam": "\uFDFA",
    "/Saltillo": "\uA78B",
    "/Sampi": "\u03E0",
    "/Sampiarchaic": "\u0372",
    "/Sampigreek": "\u03E0",
    "/San": "\u03FA",
    "/Sanah": "\u0601",
    "/Scaron": "\u0160",
    "/Scarondot": "\u1E66",
    "/Scarondotaccent": "\u1E66",
    "/Scaronsmall": "\uF6FD",
    "/Scedilla": "\u015E",
    "/Schwa": "\u018F",
    "/Schwacyr": "\u04D8",
    "/Schwacyrillic": "\u04D8",
    "/Schwadieresiscyr": "\u04DA",
    "/Schwadieresiscyrillic": "\u04DA",
    "/Scircle": "\u24C8",
    "/Scircleblack": "\u1F162",
    "/Scircumflex": "\u015C",
    "/Scommaaccent": "\u0218",
    "/Scriptg": "\uA7AC",
    "/Sdot": "\u1E60",
    "/Sdotaccent": "\u1E60",
    "/Sdotbelow": "\u1E62",
    "/Sdotbelowdotabove": "\u1E68",
    "/Sdotbelowdotaccent": "\u1E68",
    "/Seharmenian": "\u054D",
    "/Semisoftcyr": "\u048C",
    "/Sevenroman": "\u2166",
    "/Shaarmenian": "\u0547",
    "/Shacyr": "\u0428",
    "/Shacyrillic": "\u0428",
    "/Shchacyr": "\u0429",
    "/Shchacyrillic": "\u0429",
    "/Sheicoptic": "\u03E2",
    "/SheneGerishin:hb": "\u059E",
    "/Shhacyr": "\u04BA",
    "/Shhacyrillic": "\u04BA",
    "/Shhatailcyr": "\u0526",
    "/Shimacoptic": "\u03EC",
    "/Sho": "\u03F7",
    "/Sigma": "\u03A3",
    "/Sigmalunatesymbol": "\u03F9",
    "/Sigmalunatesymboldotted": "\u03FE",
    "/Sigmareversedlunatesymbol": "\u03FD",
    "/Sinsular": "\uA784",
    "/Sixroman": "\u2165",
    "/Sjekomicyr": "\u050C",
    "/Smonospace": "\uFF33",
    "/Sobliquestroke": "\uA7A8",
    "/Softcyr": "\u042C",
    "/Softsigncyrillic": "\u042C",
    "/Sparens": "\u1F122",
    "/Sshell": "\u1F12A",
    "/Ssmall": "\uF773",
    "/Ssquare": "\u1F142",
    "/Ssquareblack": "\u1F182",
    "/Sswashtail": "\u2C7E",
    "/Stigma": "\u03DA",
    "/Stigmagreek": "\u03DA",
    "/T": "\u0054",
    "/Tau": "\u03A4",
    "/Tbar": "\u0166",
    "/Tcaron": "\u0164",
    "/Tcedilla": "\u0162",
    "/Tcircle": "\u24C9",
    "/Tcircleblack": "\u1F163",
    "/Tcircumflexbelow": "\u1E70",
    "/Tcommaaccent": "\u0162",
    "/Tdot": "\u1E6A",
    "/Tdotaccent": "\u1E6A",
    "/Tdotbelow": "\u1E6C",
    "/Tecyr": "\u0422",
    "/Tecyrillic": "\u0422",
    "/Tedescendercyrillic": "\u04AC",
    "/Tenroman": "\u2169",
    "/Tetailcyr": "\u04AC",
    "/Tetsecyr": "\u04B4",
    "/Tetsecyrillic": "\u04B4",
    "/Theta": "\u0398",
    "/Thetasymbol": "\u03F4",
    "/Thook": "\u01AC",
    "/Thorn": "\u00DE",
    "/Thornsmall": "\uF7FE",
    "/Thornstroke": "\uA764",
    "/Thornstrokedescender": "\uA766",
    "/Threeroman": "\u2162",
    "/Tildesmall": "\uF6FE",
    "/Tinsular": "\uA786",
    "/Tiwnarmenian": "\u054F",
    "/Tjekomicyr": "\u050E",
    "/Tlinebelow": "\u1E6E",
    "/Tmonospace": "\uFF34",
    "/Toarmenian": "\u0539",
    "/Tonefive": "\u01BC",
    "/Tonesix": "\u0184",
    "/Tonetwo": "\u01A7",
    "/Tparens": "\u1F123",
    "/Tresillo": "\uA72A",
    "/Tretroflexhook": "\u01AE",
    "/Tsecyr": "\u0426",
    "/Tsecyrillic": "\u0426",
    "/Tshecyr": "\u040B",
    "/Tshecyrillic": "\u040B",
    "/Tsmall": "\uF774",
    "/Tsquare": "\u1F143",
    "/Tsquareblack": "\u1F183",
    "/Tturned": "\uA7B1",
    "/Twelveroman": "\u216B",
    "/Twithdiagonalstroke": "\u023E",
    "/Tworoman": "\u2161",
    "/Tz": "\uA728",
    "/U": "\u0055",
    "/Uacute": "\u00DA",
    "/Uacutedblcyr": "\u04F2",
    "/Uacutesmall": "\uF7FA",
    "/Ubar": "\u0244",
    "/Ubreve": "\u016C",
    "/Ucaron": "\u01D3",
    "/Ucircle": "\u24CA",
    "/Ucircleblack": "\u1F164",
    "/Ucircumflex": "\u00DB",
    "/Ucircumflexbelow": "\u1E76",
    "/Ucircumflexsmall": "\uF7FB",
    "/Ucyr": "\u0423",
    "/Ucyrillic": "\u0423",
    "/Udblacute": "\u0170",
    "/Udblgrave": "\u0214",
    "/Udieresis": "\u00DC",
    "/Udieresisacute": "\u01D7",
    "/Udieresisbelow": "\u1E72",
    "/Udieresiscaron": "\u01D9",
    "/Udieresiscyr": "\u04F0",
    "/Udieresiscyrillic": "\u04F0",
    "/Udieresisgrave": "\u01DB",
    "/Udieresismacron": "\u01D5",
    "/Udieresissmall": "\uF7FC",
    "/Udotbelow": "\u1EE4",
    "/Ugrave": "\u00D9",
    "/Ugravedbl": "\u0214",
    "/Ugravesmall": "\uF7F9",
    "/Uhoi": "\u1EE6",
    "/Uhookabove": "\u1EE6",
    "/Uhorn": "\u01AF",
    "/Uhornacute": "\u1EE8",
    "/Uhorndotbelow": "\u1EF0",
    "/Uhorngrave": "\u1EEA",
    "/Uhornhoi": "\u1EEC",
    "/Uhornhookabove": "\u1EEC",
    "/Uhorntilde": "\u1EEE",
    "/Uhungarumlaut": "\u0170",
    "/Uhungarumlautcyrillic": "\u04F2",
    "/Uinvertedbreve": "\u0216",
    "/Ukcyr": "\u0478",
    "/Ukcyrillic": "\u0478",
    "/Umacron": "\u016A",
    "/Umacroncyr": "\u04EE",
    "/Umacroncyrillic": "\u04EE",
    "/Umacrondieresis": "\u1E7A",
    "/Umonospace": "\uFF35",
    "/Uogonek": "\u0172",
    "/Uparens": "\u1F124",
    "/Upsilon": "\u03A5",
    "/Upsilon1": "\u03D2",
    "/Upsilonacute": "\u1FEB",
    "/Upsilonacutehooksymbol": "\u03D3",
    "/Upsilonacutehooksymbolgreek": "\u03D3",
    "/Upsilonadieresishooksymbol": "\u03D4",
    "/Upsilonafrican": "\u01B1",
    "/Upsilonasper": "\u1F59",
    "/Upsilonasperacute": "\u1F5D",
    "/Upsilonaspergrave": "\u1F5B",
    "/Upsilonaspertilde": "\u1F5F",
    "/Upsilonbreve": "\u1FE8",
    "/Upsilondieresis": "\u03AB",
    "/Upsilondieresishooksymbolgreek": "\u03D4",
    "/Upsilongrave": "\u1FEA",
    "/Upsilonhooksymbol": "\u03D2",
    "/Upsilontonos": "\u038E",
    "/Upsilonwithmacron": "\u1FE9",
    "/Uring": "\u016E",
    "/Ushortcyr": "\u040E",
    "/Ushortcyrillic": "\u040E",
    "/Usmall": "\uF775",
    "/Usquare": "\u1F144",
    "/Usquareblack": "\u1F184",
    "/Ustraightcyr": "\u04AE",
    "/Ustraightcyrillic": "\u04AE",
    "/Ustraightstrokecyr": "\u04B0",
    "/Ustraightstrokecyrillic": "\u04B0",
    "/Utilde": "\u0168",
    "/Utildeacute": "\u1E78",
    "/Utildebelow": "\u1E74",
    "/V": "\u0056",
    "/Vcircle": "\u24CB",
    "/Vcircleblack": "\u1F165",
    "/Vdiagonalstroke": "\uA75E",
    "/Vdotbelow": "\u1E7E",
    "/Vecyr": "\u0412",
    "/Vecyrillic": "\u0412",
    "/Vend": "\uA768",
    "/Vewarmenian": "\u054E",
    "/Vhook": "\u01B2",
    "/Visigothicz": "\uA762",
    "/Vmod": "\u2C7D",
    "/Vmonospace": "\uFF36",
    "/Voarmenian": "\u0548",
    "/Volapukae": "\uA79A",
    "/Volapukoe": "\uA79C",
    "/Volapukue": "\uA79E",
    "/Vparens": "\u1F125",
    "/Vsmall": "\uF776",
    "/Vsquare": "\u1F145",
    "/Vsquareblack": "\u1F185",
    "/Vtilde": "\u1E7C",
    "/Vturned": "\u0245",
    "/Vwelsh": "\u1EFC",
    "/Vy": "\uA760",
    "/W": "\u0057",
    "/WZcircle": "\u1F12E",
    "/Wacute": "\u1E82",
    "/Wasallam": "\uFDF8",
    "/Wcircle": "\u24CC",
    "/Wcircleblack": "\u1F166",
    "/Wcircumflex": "\u0174",
    "/Wdieresis": "\u1E84",
    "/Wdot": "\u1E86",
    "/Wdotaccent": "\u1E86",
    "/Wdotbelow": "\u1E88",
    "/Wecyr": "\u051C",
    "/Wgrave": "\u1E80",
    "/Whook": "\u2C72",
    "/Wmonospace": "\uFF37",
    "/Wparens": "\u1F126",
    "/Wsmall": "\uF777",
    "/Wsquare": "\u1F146",
    "/Wsquareblack": "\u1F186",
    "/Wynn": "\u01F7",
    "/X": "\u0058",
    "/Xatailcyr": "\u04B2",
    "/Xcircle": "\u24CD",
    "/Xcircleblack": "\u1F167",
    "/Xdieresis": "\u1E8C",
    "/Xdot": "\u1E8A",
    "/Xdotaccent": "\u1E8A",
    "/Xeharmenian": "\u053D",
    "/Xi": "\u039E",
    "/Xmonospace": "\uFF38",
    "/Xparens": "\u1F127",
    "/Xsmall": "\uF778",
    "/Xsquare": "\u1F147",
    "/Xsquareblack": "\u1F187",
    "/Y": "\u0059",
    "/Yacute": "\u00DD",
    "/Yacutesmall": "\uF7FD",
    "/Yacyr": "\u042F",
    "/Yaecyr": "\u0518",
    "/Yatcyr": "\u0462",
    "/Yatcyrillic": "\u0462",
    "/Ycircle": "\u24CE",
    "/Ycircleblack": "\u1F168",
    "/Ycircumflex": "\u0176",
    "/Ydieresis": "\u0178",
    "/Ydieresissmall": "\uF7FF",
    "/Ydot": "\u1E8E",
    "/Ydotaccent": "\u1E8E",
    "/Ydotbelow": "\u1EF4",
    "/Yericyrillic": "\u042B",
    "/Yerudieresiscyrillic": "\u04F8",
    "/Ygrave": "\u1EF2",
    "/Yhoi": "\u1EF6",
    "/Yhook": "\u01B3",
    "/Yhookabove": "\u1EF6",
    "/Yiarmenian": "\u0545",
    "/Yicyrillic": "\u0407",
    "/Yiwnarmenian": "\u0552",
    "/Ylongcyr": "\u042B",
    "/Ylongdieresiscyr": "\u04F8",
    "/Yloop": "\u1EFE",
    "/Ymacron": "\u0232",
    "/Ymonospace": "\uFF39",
    "/Yogh": "\u021C",
    "/Yot": "\u037F",
    "/Yparens": "\u1F128",
    "/Ysmall": "\uF779",
    "/Ysquare": "\u1F148",
    "/Ysquareblack": "\u1F188",
    "/Ystroke": "\u024E",
    "/Ytilde": "\u1EF8",
    "/Yturnedsans": "\u2144",
    "/Yucyr": "\u042E",
    "/Yukrcyr": "\u0407",
    "/Yusbigcyr": "\u046A",
    "/Yusbigcyrillic": "\u046A",
    "/Yusbigiotifiedcyr": "\u046C",
    "/Yusbigiotifiedcyrillic": "\u046C",
    "/Yuslittlecyr": "\u0466",
    "/Yuslittlecyrillic": "\u0466",
    "/Yuslittleiotifiedcyr": "\u0468",
    "/Yuslittleiotifiedcyrillic": "\u0468",
    "/Z": "\u005A",
    "/Zaarmenian": "\u0536",
    "/Zacute": "\u0179",
    "/Zcaron": "\u017D",
    "/Zcaronsmall": "\uF6FF",
    "/Zcircle": "\u24CF",
    "/Zcircleblack": "\u1F169",
    "/Zcircumflex": "\u1E90",
    "/Zdblstruck": "\u2124",
    "/Zdescender": "\u2C6B",
    "/Zdot": "\u017B",
    "/Zdotaccent": "\u017B",
    "/Zdotbelow": "\u1E92",
    "/Zecyr": "\u0417",
    "/Zecyrillic": "\u0417",
    "/Zedescendercyrillic": "\u0498",
    "/Zedieresiscyr": "\u04DE",
    "/Zedieresiscyrillic": "\u04DE",
    "/Zeta": "\u0396",
    "/Zetailcyr": "\u0498",
    "/Zfraktur": "\u2128",
    "/Zhearmenian": "\u053A",
    "/Zhebrevecyr": "\u04C1",
    "/Zhebrevecyrillic": "\u04C1",
    "/Zhecyr": "\u0416",
    "/Zhecyrillic": "\u0416",
    "/Zhedescendercyrillic": "\u0496",
    "/Zhedieresiscyr": "\u04DC",
    "/Zhedieresiscyrillic": "\u04DC",
    "/Zhetailcyr": "\u0496",
    "/Zhook": "\u0224",
    "/Zjekomicyr": "\u0504",
    "/Zlinebelow": "\u1E94",
    "/Zmonospace": "\uFF3A",
    "/Zparens": "\u1F129",
    "/Zsmall": "\uF77A",
    "/Zsquare": "\u1F149",
    "/Zsquareblack": "\u1F189",
    "/Zstroke": "\u01B5",
    "/Zswashtail": "\u2C7F",
    "/a": "\u0061",
    "/a.inferior": "\u2090",
    "/aHonRAA": "\u0613",
    "/aa": "\uA733",
    "/aabengali": "\u0986",
    "/aacute": "\u00E1",
    "/aadeva": "\u0906",
    "/aagujarati": "\u0A86",
    "/aagurmukhi": "\u0A06",
    "/aamatragurmukhi": "\u0A3E",
    "/aarusquare": "\u3303",
    "/aavowelsignbengali": "\u09BE",
    "/aavowelsigndeva": "\u093E",
    "/aavowelsigngujarati": "\u0ABE",
    "/abbreviationmarkarmenian": "\u055F",
    "/abbreviationsigndeva": "\u0970",
    "/abengali": "\u0985",
    "/abopomofo": "\u311A",
    "/abreve": "\u0103",
    "/abreveacute": "\u1EAF",
    "/abrevecyr": "\u04D1",
    "/abrevecyrillic": "\u04D1",
    "/abrevedotbelow": "\u1EB7",
    "/abrevegrave": "\u1EB1",
    "/abrevehoi": "\u1EB3",
    "/abrevehookabove": "\u1EB3",
    "/abrevetilde": "\u1EB5",
    "/absquareblack": "\u1F18E",
    "/acaron": "\u01CE",
    "/accountof": "\u2100",
    "/accurrent": "\u23E6",
    "/acircle": "\u24D0",
    "/acirclekatakana": "\u32D0",
    "/acircumflex": "\u00E2",
    "/acircumflexacute": "\u1EA5",
    "/acircumflexdotbelow": "\u1EAD",
    "/acircumflexgrave": "\u1EA7",
    "/acircumflexhoi": "\u1EA9",
    "/acircumflexhookabove": "\u1EA9",
    "/acircumflextilde": "\u1EAB",
    "/activatearabicformshaping": "\u206D",
    "/activatesymmetricswapping": "\u206B",
    "/acute": "\u00B4",
    "/acutebelowcmb": "\u0317",
    "/acutecmb": "\u0301",
    "/acutecomb": "\u0301",
    "/acutedblmiddlemod": "\u02F6",
    "/acutedeva": "\u0954",
    "/acutelowmod": "\u02CF",
    "/acutemod": "\u02CA",
    "/acutetonecmb": "\u0341",
    "/acyr": "\u0430",
    "/acyrillic": "\u0430",
    "/adblgrave": "\u0201",
    "/addakgurmukhi": "\u0A71",
    "/addressedsubject": "\u2101",
    "/adegadegpada": "\uA9CB",
    "/adegpada": "\uA9CA",
    "/adeva": "\u0905",
    "/adieresis": "\u00E4",
    "/adieresiscyr": "\u04D3",
    "/adieresiscyrillic": "\u04D3",
    "/adieresismacron": "\u01DF",
    "/adishakti": "\u262C",
    "/admissionTickets": "\u1F39F",
    "/adot": "\u0227",
    "/adotbelow": "\u1EA1",
    "/adotmacron": "\u01E1",
    "/ae": "\u00E6",
    "/aeacute": "\u01FD",
    "/aekorean": "\u3150",
    "/aemacron": "\u01E3",
    "/aerialTramway": "\u1F6A1",
    "/afghani": "\u060B",
    "/afii00208": "\u2015",
    "/afii08941": "\u20A4",
    "/afii10017": "\u0410",
    "/afii10018": "\u0411",
    "/afii10019": "\u0412",
    "/afii10020": "\u0413",
    "/afii10021": "\u0414",
    "/afii10022": "\u0415",
    "/afii10023": "\u0401",
    "/afii10024": "\u0416",
    "/afii10025": "\u0417",
    "/afii10026": "\u0418",
    "/afii10027": "\u0419",
    "/afii10028": "\u041A",
    "/afii10029": "\u041B",
    "/afii10030": "\u041C",
    "/afii10031": "\u041D",
    "/afii10032": "\u041E",
    "/afii10033": "\u041F",
    "/afii10034": "\u0420",
    "/afii10035": "\u0421",
    "/afii10036": "\u0422",
    "/afii10037": "\u0423",
    "/afii10038": "\u0424",
    "/afii10039": "\u0425",
    "/afii10040": "\u0426",
    "/afii10041": "\u0427",
    "/afii10042": "\u0428",
    "/afii10043": "\u0429",
    "/afii10044": "\u042A",
    "/afii10045": "\u042B",
    "/afii10046": "\u042C",
    "/afii10047": "\u042D",
    "/afii10048": "\u042E",
    "/afii10049": "\u042F",
    "/afii10050": "\u0490",
    "/afii10051": "\u0402",
    "/afii10052": "\u0403",
    "/afii10053": "\u0404",
    "/afii10054": "\u0405",
    "/afii10055": "\u0406",
    "/afii10056": "\u0407",
    "/afii10057": "\u0408",
    "/afii10058": "\u0409",
    "/afii10059": "\u040A",
    "/afii10060": "\u040B",
    "/afii10061": "\u040C",
    "/afii10062": "\u040E",
    "/afii10063": "\uF6C4",
    "/afii10064": "\uF6C5",
    "/afii10065": "\u0430",
    "/afii10066": "\u0431",
    "/afii10067": "\u0432",
    "/afii10068": "\u0433",
    "/afii10069": "\u0434",
    "/afii10070": "\u0435",
    "/afii10071": "\u0451",
    "/afii10072": "\u0436",
    "/afii10073": "\u0437",
    "/afii10074": "\u0438",
    "/afii10075": "\u0439",
    "/afii10076": "\u043A",
    "/afii10077": "\u043B",
    "/afii10078": "\u043C",
    "/afii10079": "\u043D",
    "/afii10080": "\u043E",
    "/afii10081": "\u043F",
    "/afii10082": "\u0440",
    "/afii10083": "\u0441",
    "/afii10084": "\u0442",
    "/afii10085": "\u0443",
    "/afii10086": "\u0444",
    "/afii10087": "\u0445",
    "/afii10088": "\u0446",
    "/afii10089": "\u0447",
    "/afii10090": "\u0448",
    "/afii10091": "\u0449",
    "/afii10092": "\u044A",
    "/afii10093": "\u044B",
    "/afii10094": "\u044C",
    "/afii10095": "\u044D",
    "/afii10096": "\u044E",
    "/afii10097": "\u044F",
    "/afii10098": "\u0491",
    "/afii10099": "\u0452",
    "/afii10100": "\u0453",
    "/afii10101": "\u0454",
    "/afii10102": "\u0455",
    "/afii10103": "\u0456",
    "/afii10104": "\u0457",
    "/afii10105": "\u0458",
    "/afii10106": "\u0459",
    "/afii10107": "\u045A",
    "/afii10108": "\u045B",
    "/afii10109": "\u045C",
    "/afii10110": "\u045E",
    "/afii10145": "\u040F",
    "/afii10146": "\u0462",
    "/afii10147": "\u0472",
    "/afii10148": "\u0474",
    "/afii10192": "\uF6C6",
    "/afii10193": "\u045F",
    "/afii10194": "\u0463",
    "/afii10195": "\u0473",
    "/afii10196": "\u0475",
    "/afii10831": "\uF6C7",
    "/afii10832": "\uF6C8",
    "/afii10846": "\u04D9",
    "/afii299": "\u200E",
    "/afii300": "\u200F",
    "/afii301": "\u200D",
    "/afii57381": "\u066A",
    "/afii57388": "\u060C",
    "/afii57392": "\u0660",
    "/afii57393": "\u0661",
    "/afii57394": "\u0662",
    "/afii57395": "\u0663",
    "/afii57396": "\u0664",
    "/afii57397": "\u0665",
    "/afii57398": "\u0666",
    "/afii57399": "\u0667",
    "/afii57400": "\u0668",
    "/afii57401": "\u0669",
    "/afii57403": "\u061B",
    "/afii57407": "\u061F",
    "/afii57409": "\u0621",
    "/afii57410": "\u0622",
    "/afii57411": "\u0623",
    "/afii57412": "\u0624",
    "/afii57413": "\u0625",
    "/afii57414": "\u0626",
    "/afii57415": "\u0627",
    "/afii57416": "\u0628",
    "/afii57417": "\u0629",
    "/afii57418": "\u062A",
    "/afii57419": "\u062B",
    "/afii57420": "\u062C",
    "/afii57421": "\u062D",
    "/afii57422": "\u062E",
    "/afii57423": "\u062F",
    "/afii57424": "\u0630",
    "/afii57425": "\u0631",
    "/afii57426": "\u0632",
    "/afii57427": "\u0633",
    "/afii57428": "\u0634",
    "/afii57429": "\u0635",
    "/afii57430": "\u0636",
    "/afii57431": "\u0637",
    "/afii57432": "\u0638",
    "/afii57433": "\u0639",
    "/afii57434": "\u063A",
    "/afii57440": "\u0640",
    "/afii57441": "\u0641",
    "/afii57442": "\u0642",
    "/afii57443": "\u0643",
    "/afii57444": "\u0644",
    "/afii57445": "\u0645",
    "/afii57446": "\u0646",
    "/afii57448": "\u0648",
    "/afii57449": "\u0649",
    "/afii57450": "\u064A",
    "/afii57451": "\u064B",
    "/afii57452": "\u064C",
    "/afii57453": "\u064D",
    "/afii57454": "\u064E",
    "/afii57455": "\u064F",
    "/afii57456": "\u0650",
    "/afii57457": "\u0651",
    "/afii57458": "\u0652",
    "/afii57470": "\u0647",
    "/afii57505": "\u06A4",
    "/afii57506": "\u067E",
    "/afii57507": "\u0686",
    "/afii57508": "\u0698",
    "/afii57509": "\u06AF",
    "/afii57511": "\u0679",
    "/afii57512": "\u0688",
    "/afii57513": "\u0691",
    "/afii57514": "\u06BA",
    "/afii57519": "\u06D2",
    "/afii57534": "\u06D5",
    "/afii57636": "\u20AA",
    "/afii57645": "\u05BE",
    "/afii57658": "\u05C3",
    "/afii57664": "\u05D0",
    "/afii57665": "\u05D1",
    "/afii57666": "\u05D2",
    "/afii57667": "\u05D3",
    "/afii57668": "\u05D4",
    "/afii57669": "\u05D5",
    "/afii57670": "\u05D6",
    "/afii57671": "\u05D7",
    "/afii57672": "\u05D8",
    "/afii57673": "\u05D9",
    "/afii57674": "\u05DA",
    "/afii57675": "\u05DB",
    "/afii57676": "\u05DC",
    "/afii57677": "\u05DD",
    "/afii57678": "\u05DE",
    "/afii57679": "\u05DF",
    "/afii57680": "\u05E0",
    "/afii57681": "\u05E1",
    "/afii57682": "\u05E2",
    "/afii57683": "\u05E3",
    "/afii57684": "\u05E4",
    "/afii57685": "\u05E5",
    "/afii57686": "\u05E6",
    "/afii57687": "\u05E7",
    "/afii57688": "\u05E8",
    "/afii57689": "\u05E9",
    "/afii57690": "\u05EA",
    "/afii57694": "\uFB2A",
    "/afii57695": "\uFB2B",
    "/afii57700": "\uFB4B",
    "/afii57705": "\uFB1F",
    "/afii57716": "\u05F0",
    "/afii57717": "\u05F1",
    "/afii57718": "\u05F2",
    "/afii57723": "\uFB35",
    "/afii57793": "\u05B4",
    "/afii57794": "\u05B5",
    "/afii57795": "\u05B6",
    "/afii57796": "\u05BB",
    "/afii57797": "\u05B8",
    "/afii57798": "\u05B7",
    "/afii57799": "\u05B0",
    "/afii57800": "\u05B2",
    "/afii57801": "\u05B1",
    "/afii57802": "\u05B3",
    "/afii57803": "\u05C2",
    "/afii57804": "\u05C1",
    "/afii57806": "\u05B9",
    "/afii57807": "\u05BC",
    "/afii57839": "\u05BD",
    "/afii57841": "\u05BF",
    "/afii57842": "\u05C0",
    "/afii57929": "\u02BC",
    "/afii61248": "\u2105",
    "/afii61289": "\u2113",
    "/afii61352": "\u2116",
    "/afii61573": "\u202C",
    "/afii61574": "\u202D",
    "/afii61575": "\u202E",
    "/afii61664": "\u200C",
    "/afii63167": "\u066D",
    "/afii64937": "\u02BD",
    "/agrave": "\u00E0",
    "/agravedbl": "\u0201",
    "/agujarati": "\u0A85",
    "/agurmukhi": "\u0A05",
    "/ahiragana": "\u3042",
    "/ahoi": "\u1EA3",
    "/ahookabove": "\u1EA3",
    "/aibengali": "\u0990",
    "/aibopomofo": "\u311E",
    "/aideva": "\u0910",
    "/aiecyr": "\u04D5",
    "/aiecyrillic": "\u04D5",
    "/aigujarati": "\u0A90",
    "/aigurmukhi": "\u0A10",
    "/aimatragurmukhi": "\u0A48",
    "/ain.fina": "\uFECA",
    "/ain.init": "\uFECB",
    "/ain.init_alefmaksura.fina": "\uFCF7",
    "/ain.init_jeem.fina": "\uFC29",
    "/ain.init_jeem.medi": "\uFCBA",
    "/ain.init_jeem.medi_meem.medi": "\uFDC4",
    "/ain.init_meem.fina": "\uFC2A",
    "/ain.init_meem.medi": "\uFCBB",
    "/ain.init_meem.medi_meem.medi": "\uFD77",
    "/ain.init_yeh.fina": "\uFCF8",
    "/ain.isol": "\uFEC9",
    "/ain.medi": "\uFECC",
    "/ain.medi_alefmaksura.fina": "\uFD13",
    "/ain.medi_jeem.medi_meem.fina": "\uFD75",
    "/ain.medi_meem.medi_alefmaksura.fina": "\uFD78",
    "/ain.medi_meem.medi_meem.fina": "\uFD76",
    "/ain.medi_meem.medi_yeh.fina": "\uFDB6",
    "/ain.medi_yeh.fina": "\uFD14",
    "/ainThreeDotsDownAbove": "\u075E",
    "/ainTwoDotsAbove": "\u075D",
    "/ainTwoDotsVerticallyAbove": "\u075F",
    "/ainarabic": "\u0639",
    "/ainfinalarabic": "\uFECA",
    "/aininitialarabic": "\uFECB",
    "/ainmedialarabic": "\uFECC",
    "/ainthreedotsabove": "\u06A0",
    "/ainvertedbreve": "\u0203",
    "/airplaneArriving": "\u1F6EC",
    "/airplaneDeparture": "\u1F6EB",
    "/aivowelsignbengali": "\u09C8",
    "/aivowelsigndeva": "\u0948",
    "/aivowelsigngujarati": "\u0AC8",
    "/akatakana": "\u30A2",
    "/akatakanahalfwidth": "\uFF71",
    "/akorean": "\u314F",
    "/aktieselskab": "\u214D",
    "/alarmclock": "\u23F0",
    "/alef": "\u05D0",
    "/alef.fina": "\uFE8E",
    "/alef.init_fathatan.fina": "\uFD3D",
    "/alef.isol": "\uFE8D",
    "/alef.medi_fathatan.fina": "\uFD3C",
    "/alef:hb": "\u05D0",
    "/alefDigitThreeAbove": "\u0774",
    "/alefDigitTwoAbove": "\u0773",
    "/alefLamYehabove": "\u0616",
    "/alefabove": "\u0670",
    "/alefarabic": "\u0627",
    "/alefdageshhebrew": "\uFB30",
    "/aleffinalarabic": "\uFE8E",
    "/alefhamza": "\u0623",
    "/alefhamza.fina": "\uFE84",
    "/alefhamza.isol": "\uFE83",
    "/alefhamzaabovearabic": "\u0623",
    "/alefhamzaabovefinalarabic": "\uFE84",
    "/alefhamzabelow": "\u0625",
    "/alefhamzabelow.fina": "\uFE88",
    "/alefhamzabelow.isol": "\uFE87",
    "/alefhamzabelowarabic": "\u0625",
    "/alefhamzabelowfinalarabic": "\uFE88",
    "/alefhebrew": "\u05D0",
    "/alefhighhamza": "\u0675",
    "/aleflamedhebrew": "\uFB4F",
    "/alefmadda": "\u0622",
    "/alefmadda.fina": "\uFE82",
    "/alefmadda.isol": "\uFE81",
    "/alefmaddaabovearabic": "\u0622",
    "/alefmaddaabovefinalarabic": "\uFE82",
    "/alefmaksura": "\u0649",
    "/alefmaksura.fina": "\uFEF0",
    "/alefmaksura.init_superscriptalef.fina": "\uFC5D",
    "/alefmaksura.isol": "\uFEEF",
    "/alefmaksura.medi_superscriptalef.fina": "\uFC90",
    "/alefmaksuraarabic": "\u0649",
    "/alefmaksurafinalarabic": "\uFEF0",
    "/alefmaksurainitialarabic": "\uFEF3",
    "/alefmaksuramedialarabic": "\uFEF4",
    "/alefpatahhebrew": "\uFB2E",
    "/alefqamatshebrew": "\uFB2F",
    "/alefwasla": "\u0671",
    "/alefwasla.fina": "\uFB51",
    "/alefwasla.isol": "\uFB50",
    "/alefwavyhamza": "\u0672",
    "/alefwavyhamzabelow": "\u0673",
    "/alefwide:hb": "\uFB21",
    "/alefwithmapiq:hb": "\uFB30",
    "/alefwithpatah:hb": "\uFB2E",
    "/alefwithqamats:hb": "\uFB2F",
    "/alembic": "\u2697",
    "/aleph": "\u2135",
    "/alienMonster": "\u1F47E",
    "/allaroundprofile": "\u232E",
    "/allequal": "\u224C",
    "/allianceideographiccircled": "\u32AF",
    "/allianceideographicparen": "\u323F",
    "/almostequalorequal": "\u224A",
    "/alpha": "\u03B1",
    "/alphaacute": "\u1F71",
    "/alphaacuteiotasub": "\u1FB4",
    "/alphaasper": "\u1F01",
    "/alphaasperacute": "\u1F05",
    "/alphaasperacuteiotasub": "\u1F85",
    "/alphaaspergrave": "\u1F03",
    "/alphaaspergraveiotasub": "\u1F83",
    "/alphaasperiotasub": "\u1F81",
    "/alphaaspertilde": "\u1F07",
    "/alphaaspertildeiotasub": "\u1F87",
    "/alphabreve": "\u1FB0",
    "/alphafunc": "\u237A",
    "/alphagrave": "\u1F70",
    "/alphagraveiotasub": "\u1FB2",
    "/alphaiotasub": "\u1FB3",
    "/alphalenis": "\u1F00",
    "/alphalenisacute": "\u1F04",
    "/alphalenisacuteiotasub": "\u1F84",
    "/alphalenisgrave": "\u1F02",
    "/alphalenisgraveiotasub": "\u1F82",
    "/alphalenisiotasub": "\u1F80",
    "/alphalenistilde": "\u1F06",
    "/alphalenistildeiotasub": "\u1F86",
    "/alphatilde": "\u1FB6",
    "/alphatildeiotasub": "\u1FB7",
    "/alphatonos": "\u03AC",
    "/alphaturned": "\u0252",
    "/alphaunderlinefunc": "\u2376",
    "/alphawithmacron": "\u1FB1",
    "/alternateonewayleftwaytraffic": "\u26D5",
    "/alternative": "\u2387",
    "/amacron": "\u0101",
    "/ambulance": "\u1F691",
    "/americanFootball": "\u1F3C8",
    "/amfullwidth": "\u33C2",
    "/amonospace": "\uFF41",
    "/amountofcheck": "\u2447",
    "/ampersand": "\u0026",
    "/ampersandSindhi": "\u06FD",
    "/ampersandmonospace": "\uFF06",
    "/ampersandsmall": "\uF726",
    "/ampersandturned": "\u214B",
    "/amphora": "\u1F3FA",
    "/amsquare": "\u33C2",
    "/anbopomofo": "\u3122",
    "/anchor": "\u2693",
    "/ancoradown": "\u2E14",
    "/ancoraup": "\u2E15",
    "/andappada": "\uA9C3",
    "/angbopomofo": "\u3124",
    "/anger": "\u1F4A2",
    "/angkhankhuthai": "\u0E5A",
    "/angle": "\u2220",
    "/anglearcright": "\u22BE",
    "/anglebracketleft": "\u3008",
    "/anglebracketleftvertical": "\uFE3F",
    "/anglebracketright": "\u3009",
    "/anglebracketrightvertical": "\uFE40",
    "/angledottedright": "\u2E16",
    "/angleleft": "\u2329",
    "/anglemarkerdottedsubstitutionright": "\u2E01",
    "/anglemarkersubstitutionright": "\u2E00",
    "/angleright": "\u232A",
    "/anglezigzagarrowdownright": "\u237C",
    "/angryFace": "\u1F620",
    "/angstrom": "\u212B",
    "/anguishedFace": "\u1F627",
    "/ankh": "\u2625",
    "/anoteleia": "\u0387",
    "/anpeasquare": "\u3302",
    "/ant": "\u1F41C",
    "/antennaBars": "\u1F4F6",
    "/anticlockwiseDownwardsAndUpwardsOpenCircleArrows": "\u1F504",
    "/anudattadeva": "\u0952",
    "/anusvarabengali": "\u0982",
    "/anusvaradeva": "\u0902",
    "/anusvaragujarati": "\u0A82",
    "/ao": "\uA735",
    "/aogonek": "\u0105",
    "/aovermfullwidth": "\u33DF",
    "/apaatosquare": "\u3300",
    "/aparen": "\u249C",
    "/aparenthesized": "\u249C",
    "/apostrophearmenian": "\u055A",
    "/apostrophedblmod": "\u02EE",
    "/apostrophemod": "\u02BC",
    "/apple": "\uF8FF",
    "/approaches": "\u2250",
    "/approacheslimit": "\u2250",
    "/approxequal": "\u2248",
    "/approxequalorimage": "\u2252",
    "/approximatelybutnotactuallyequal": "\u2246",
    "/approximatelyequal": "\u2245",
    "/approximatelyequalorimage": "\u2252",
    "/apriltelegraph": "\u32C3",
    "/aquarius": "\u2652",
    "/ar:ae": "\u06D5",
    "/ar:ain": "\u0639",
    "/ar:alef": "\u0627",
    "/ar:comma": "\u060C",
    "/ar:cuberoot": "\u0606",
    "/ar:decimalseparator": "\u066B",
    "/ar:e": "\u06D0",
    "/ar:eight": "\u0668",
    "/ar:feh": "\u0641",
    "/ar:five": "\u0665",
    "/ar:four": "\u0664",
    "/ar:fourthroot": "\u0607",
    "/ar:kaf": "\u0643",
    "/ar:ng": "\u06AD",
    "/ar:nine": "\u0669",
    "/ar:numbersign": "\u0600",
    "/ar:oe": "\u06C6",
    "/ar:one": "\u0661",
    "/ar:peh": "\u067E",
    "/ar:percent": "\u066A",
    "/ar:perthousand": "\u060A",
    "/ar:question": "\u061F",
    "/ar:reh": "\u0631",
    "/ar:semicolon": "\u061B",
    "/ar:seven": "\u0667",
    "/ar:shadda": "\u0651",
    "/ar:six": "\u0666",
    "/ar:sukun": "\u0652",
    "/ar:three": "\u0663",
    "/ar:two": "\u0662",
    "/ar:u": "\u06C7",
    "/ar:ve": "\u06CB",
    "/ar:yu": "\u06C8",
    "/ar:zero": "\u0660",
    "/araeaekorean": "\u318E",
    "/araeakorean": "\u318D",
    "/arc": "\u2312",
    "/archaicmepigraphic": "\uA7FF",
    "/aries": "\u2648",
    "/arighthalfring": "\u1E9A",
    "/aring": "\u00E5",
    "/aringacute": "\u01FB",
    "/aringbelow": "\u1E01",
    "/armn:Ayb": "\u0531",
    "/armn:Ben": "\u0532",
    "/armn:Ca": "\u053E",
    "/armn:Cha": "\u0549",
    "/armn:Cheh": "\u0543",
    "/armn:Co": "\u0551",
    "/armn:DRAMSIGN": "\u058F",
    "/armn:Da": "\u0534",
    "/armn:Ech": "\u0535",
    "/armn:Eh": "\u0537",
    "/armn:Et": "\u0538",
    "/armn:Feh": "\u0556",
    "/armn:Ghad": "\u0542",
    "/armn:Gim": "\u0533",
    "/armn:Ho": "\u0540",
    "/armn:Ini": "\u053B",
    "/armn:Ja": "\u0541",
    "/armn:Jheh": "\u054B",
    "/armn:Keh": "\u0554",
    "/armn:Ken": "\u053F",
    "/armn:Liwn": "\u053C",
    "/armn:Men": "\u0544",
    "/armn:Now": "\u0546",
    "/armn:Oh": "\u0555",
    "/armn:Peh": "\u054A",
    "/armn:Piwr": "\u0553",
    "/armn:Ra": "\u054C",
    "/armn:Reh": "\u0550",
    "/armn:Seh": "\u054D",
    "/armn:Sha": "\u0547",
    "/armn:Tiwn": "\u054F",
    "/armn:To": "\u0539",
    "/armn:Vew": "\u054E",
    "/armn:Vo": "\u0548",
    "/armn:Xeh": "\u053D",
    "/armn:Yi": "\u0545",
    "/armn:Yiwn": "\u0552",
    "/armn:Za": "\u0536",
    "/armn:Zhe": "\u053A",
    "/armn:abbreviationmark": "\u055F",
    "/armn:apostrophe": "\u055A",
    "/armn:ayb": "\u0561",
    "/armn:ben": "\u0562",
    "/armn:ca": "\u056E",
    "/armn:cha": "\u0579",
    "/armn:cheh": "\u0573",
    "/armn:co": "\u0581",
    "/armn:comma": "\u055D",
    "/armn:da": "\u0564",
    "/armn:ech": "\u0565",
    "/armn:ech_yiwn": "\u0587",
    "/armn:eh": "\u0567",
    "/armn:emphasismark": "\u055B",
    "/armn:et": "\u0568",
    "/armn:exclam": "\u055C",
    "/armn:feh": "\u0586",
    "/armn:ghad": "\u0572",
    "/armn:gim": "\u0563",
    "/armn:ho": "\u0570",
    "/armn:hyphen": "\u058A",
    "/armn:ini": "\u056B",
    "/armn:ja": "\u0571",
    "/armn:jheh": "\u057B",
    "/armn:keh": "\u0584",
    "/armn:ken": "\u056F",
    "/armn:leftfacingeternitysign": "\u058E",
    "/armn:liwn": "\u056C",
    "/armn:men": "\u0574",
    "/armn:men_ech": "\uFB14",
    "/armn:men_ini": "\uFB15",
    "/armn:men_now": "\uFB13",
    "/armn:men_xeh": "\uFB17",
    "/armn:now": "\u0576",
    "/armn:oh": "\u0585",
    "/armn:peh": "\u057A",
    "/armn:period": "\u0589",
    "/armn:piwr": "\u0583",
    "/armn:question": "\u055E",
    "/armn:ra": "\u057C",
    "/armn:reh": "\u0580",
    "/armn:rightfacingeternitysign": "\u058D",
    "/armn:ringhalfleft": "\u0559",
    "/armn:seh": "\u057D",
    "/armn:sha": "\u0577",
    "/armn:tiwn": "\u057F",
    "/armn:to": "\u0569",
    "/armn:vew": "\u057E",
    "/armn:vew_now": "\uFB16",
    "/armn:vo": "\u0578",
    "/armn:xeh": "\u056D",
    "/armn:yi": "\u0575",
    "/armn:yiwn": "\u0582",
    "/armn:za": "\u0566",
    "/armn:zhe": "\u056A",
    "/arrowNE": "\u2197",
    "/arrowNW": "\u2196",
    "/arrowSE": "\u2198",
    "/arrowSW": "\u2199",
    "/arrowanticlockwiseopencircle": "\u21BA",
    "/arrowanticlockwisesemicircle": "\u21B6",
    "/arrowboth": "\u2194",
    "/arrowclockwiseopencircle": "\u21BB",
    "/arrowclockwisesemicircle": "\u21B7",
    "/arrowdashdown": "\u21E3",
    "/arrowdashleft": "\u21E0",
    "/arrowdashright": "\u21E2",
    "/arrowdashup": "\u21E1",
    "/arrowdblboth": "\u21D4",
    "/arrowdbldown": "\u21D3",
    "/arrowdblleft": "\u21D0",
    "/arrowdblright": "\u21D2",
    "/arrowdblup": "\u21D1",
    "/arrowdown": "\u2193",
    "/arrowdowndashed": "\u21E3",
    "/arrowdownfrombar": "\u21A7",
    "/arrowdownleft": "\u2199",
    "/arrowdownright": "\u2198",
    "/arrowdowntwoheaded": "\u21A1",
    "/arrowdownwhite": "\u21E9",
    "/arrowdownzigzag": "\u21AF",
    "/arrowheaddown": "\u2304",
    "/arrowheaddownlowmod": "\u02EF",
    "/arrowheaddownmod": "\u02C5",
    "/arrowheadleftlowmod": "\u02F1",
    "/arrowheadleftmod": "\u02C2",
    "/arrowheadrightlowmod": "\u02F2",
    "/arrowheadrightmod": "\u02C3",
    "/arrowheadtwobarsuphorizontal": "\u2324",
    "/arrowheadup": "\u2303",
    "/arrowheaduplowmod": "\u02F0",
    "/arrowheadupmod": "\u02C4",
    "/arrowhorizex": "\uF8E7",
    "/arrowleft": "\u2190",
    "/arrowleftdashed": "\u21E0",
    "/arrowleftdbl": "\u21D0",
    "/arrowleftdblstroke": "\u21CD",
    "/arrowleftdowncorner": "\u21B5",
    "/arrowleftdowntip": "\u21B2",
    "/arrowleftfrombar": "\u21A4",
    "/arrowlefthook": "\u21A9",
    "/arrowleftloop": "\u21AB",
    "/arrowleftlowmod": "\u02FF",
    "/arrowleftoverright": "\u21C6",
    "/arrowleftoverrighttobar": "\u21B9",
    "/arrowleftright": "\u2194",
    "/arrowleftrightstroke": "\u21AE",
    "/arrowleftrightwave": "\u21AD",
    "/arrowleftsquiggle": "\u21DC",
    "/arrowleftstroke": "\u219A",
    "/arrowlefttail": "\u21A2",
    "/arrowlefttobar": "\u21E4",
    "/arrowlefttwoheaded": "\u219E",
    "/arrowleftuptip": "\u21B0",
    "/arrowleftwave": "\u219C",
    "/arrowleftwhite": "\u21E6",
    "/arrowlongNWtobar": "\u21B8",
    "/arrowright": "\u2192",
    "/arrowrightdashed": "\u21E2",
    "/arrowrightdblstroke": "\u21CF",
    "/arrowrightdowncorner": "\u21B4",
    "/arrowrightdowntip": "\u21B3",
    "/arrowrightfrombar": "\u21A6",
    "/arrowrightheavy": "\u279E",
    "/arrowrighthook": "\u21AA",
    "/arrowrightloop": "\u21AC",
    "/arrowrightoverleft": "\u21C4",
    "/arrowrightsmallcircle": "\u21F4",
    "/arrowrightsquiggle": "\u21DD",
    "/arrowrightstroke": "\u219B",
    "/arrowrighttail": "\u21A3",
    "/arrowrighttobar": "\u21E5",
    "/arrowrighttwoheaded": "\u21A0",
    "/arrowrightwave": "\u219D",
    "/arrowrightwhite": "\u21E8",
    "/arrowspaireddown": "\u21CA",
    "/arrowspairedleft": "\u21C7",
    "/arrowspairedright": "\u21C9",
    "/arrowspairedup": "\u21C8",
    "/arrowtableft": "\u21E4",
    "/arrowtabright": "\u21E5",
    "/arrowup": "\u2191",
    "/arrowupdashed": "\u21E1",
    "/arrowupdn": "\u2195",
    "/arrowupdnbse": "\u21A8",
    "/arrowupdown": "\u2195",
    "/arrowupdownbase": "\u21A8",
    "/arrowupdownwithbase": "\u21A8",
    "/arrowupfrombar": "\u21A5",
    "/arrowupleft": "\u2196",
    "/arrowupleftofdown": "\u21C5",
    "/arrowupright": "\u2197",
    "/arrowuprighttip": "\u21B1",
    "/arrowuptwoheaded": "\u219F",
    "/arrowupwhite": "\u21E7",
    "/arrowvertex": "\uF8E6",
    "/articulatedLorry": "\u1F69B",
    "/artistPalette": "\u1F3A8",
    "/aruhuasquare": "\u3301",
    "/asciicircum": "\u005E",
    "/asciicircummonospace": "\uFF3E",
    "/asciitilde": "\u007E",
    "/asciitildemonospace": "\uFF5E",
    "/ascript": "\u0251",
    "/ascriptturned": "\u0252",
    "/asmallhiragana": "\u3041",
    "/asmallkatakana": "\u30A1",
    "/asmallkatakanahalfwidth": "\uFF67",
    "/asper": "\u1FFE",
    "/asperacute": "\u1FDE",
    "/aspergrave": "\u1FDD",
    "/aspertilde": "\u1FDF",
    "/assertion": "\u22A6",
    "/asterisk": "\u002A",
    "/asteriskaltonearabic": "\u066D",
    "/asteriskarabic": "\u066D",
    "/asteriskmath": "\u2217",
    "/asteriskmonospace": "\uFF0A",
    "/asterisksmall": "\uFE61",
    "/asterism": "\u2042",
    "/astonishedFace": "\u1F632",
    "/astroke": "\u2C65",
    "/astronomicaluranus": "\u26E2",
    "/asuperior": "\uF6E9",
    "/asympticallyequal": "\u2243",
    "/asymptoticallyequal": "\u2243",
    "/at": "\u0040",
    "/athleticShoe": "\u1F45F",
    "/atilde": "\u00E3",
    "/atmonospace": "\uFF20",
    "/atnachHafukh:hb": "\u05A2",
    "/atom": "\u269B",
    "/atsmall": "\uFE6B",
    "/attentionideographiccircled": "\u329F",
    "/aturned": "\u0250",
    "/au": "\uA737",
    "/aubengali": "\u0994",
    "/aubergine": "\u1F346",
    "/aubopomofo": "\u3120",
    "/audeva": "\u0914",
    "/aufullwidth": "\u3373",
    "/augujarati": "\u0A94",
    "/augurmukhi": "\u0A14",
    "/augusttelegraph": "\u32C7",
    "/aulengthmarkbengali": "\u09D7",
    "/aumatragurmukhi": "\u0A4C",
    "/austral": "\u20B3",
    "/automatedTellerMachine": "\u1F3E7",
    "/automobile": "\u1F697",
    "/auvowelsignbengali": "\u09CC",
    "/auvowelsigndeva": "\u094C",
    "/auvowelsigngujarati": "\u0ACC",
    "/av": "\uA739",
    "/avagrahadeva": "\u093D",
    "/avhorizontalbar": "\uA73B",
    "/ay": "\uA73D",
    "/aybarmenian": "\u0561",
    "/ayin": "\u05E2",
    "/ayin:hb": "\u05E2",
    "/ayinalt:hb": "\uFB20",
    "/ayinaltonehebrew": "\uFB20",
    "/ayinhebrew": "\u05E2",
    "/azla:hb": "\u059C",
    "/b": "\u0062",
    "/baarerusquare": "\u332D",
    "/babengali": "\u09AC",
    "/babyAngel": "\u1F47C",
    "/babyBottle": "\u1F37C",
    "/babyChick": "\u1F424",
    "/backLeftwardsArrowAbove": "\u1F519",
    "/backOfEnvelope": "\u1F582",
    "/backslash": "\u005C",
    "/backslashbarfunc": "\u2340",
    "/backslashdbl": "\u244A",
    "/backslashmonospace": "\uFF3C",
    "/bactrianCamel": "\u1F42B",
    "/badeva": "\u092C",
    "/badmintonRacquetAndShuttlecock": "\u1F3F8",
    "/bagdelimitersshapeleft": "\u27C5",
    "/bagdelimitersshaperight": "\u27C6",
    "/baggageClaim": "\u1F6C4",
    "/bagujarati": "\u0AAC",
    "/bagurmukhi": "\u0A2C",
    "/bahiragana": "\u3070",
    "/bahtthai": "\u0E3F",
    "/bakatakana": "\u30D0",
    "/balloon": "\u1F388",
    "/ballotBoldScriptX": "\u1F5F6",
    "/ballotBoxBallot": "\u1F5F3",
    "/ballotBoxBoldCheck": "\u1F5F9",
    "/ballotBoxBoldScriptX": "\u1F5F7",
    "/ballotBoxScriptX": "\u1F5F5",
    "/ballotScriptX": "\u1F5F4",
    "/bamurda": "\uA9A8",
    "/banana": "\u1F34C",
    "/bank": "\u1F3E6",
    "/banknoteDollarSign": "\u1F4B5",
    "/banknoteEuroSign": "\u1F4B6",
    "/banknotePoundSign": "\u1F4B7",
    "/banknoteYenSign": "\u1F4B4",
    "/bar": "\u007C",
    "/barChart": "\u1F4CA",
    "/barberPole": "\u1F488",
    "/barfullwidth": "\u3374",
    "/barmonospace": "\uFF5C",
    "/barquillverticalleft": "\u2E20",
    "/barquillverticalright": "\u2E21",
    "/baseball": "\u26BE",
    "/basketballAndHoop": "\u1F3C0",
    "/bath": "\u1F6C0",
    "/bathtub": "\u1F6C1",
    "/battery": "\u1F50B",
    "/bbopomofo": "\u3105",
    "/bcircle": "\u24D1",
    "/bdot": "\u1E03",
    "/bdotaccent": "\u1E03",
    "/bdotbelow": "\u1E05",
    "/beachUmbrella": "\u1F3D6",
    "/beamedAscendingMusicalNotes": "\u1F39C",
    "/beamedDescendingMusicalNotes": "\u1F39D",
    "/beamedeighthnotes": "\u266B",
    "/beamedsixteenthnotes": "\u266C",
    "/beamfunc": "\u2336",
    "/bearFace": "\u1F43B",
    "/beatingHeart": "\u1F493",
    "/because": "\u2235",
    "/becyr": "\u0431",
    "/becyrillic": "\u0431",
    "/bed": "\u1F6CF",
    "/beeh": "\u067B",
    "/beeh.fina": "\uFB53",
    "/beeh.init": "\uFB54",
    "/beeh.isol": "\uFB52",
    "/beeh.medi": "\uFB55",
    "/beerMug": "\u1F37A",
    "/beetasquare": "\u333C",
    "/beh": "\u0628",
    "/beh.fina": "\uFE90",
    "/beh.init": "\uFE91",
    "/beh.init_alefmaksura.fina": "\uFC09",
    "/beh.init_hah.fina": "\uFC06",
    "/beh.init_hah.medi": "\uFC9D",
    "/beh.init_heh.medi": "\uFCA0",
    "/beh.init_jeem.fina": "\uFC05",
    "/beh.init_jeem.medi": "\uFC9C",
    "/beh.init_khah.fina": "\uFC07",
    "/beh.init_khah.medi": "\uFC9E",
    "/beh.init_meem.fina": "\uFC08",
    "/beh.init_meem.medi": "\uFC9F",
    "/beh.init_yeh.fina": "\uFC0A",
    "/beh.isol": "\uFE8F",
    "/beh.medi": "\uFE92",
    "/beh.medi_alefmaksura.fina": "\uFC6E",
    "/beh.medi_hah.medi_yeh.fina": "\uFDC2",
    "/beh.medi_heh.medi": "\uFCE2",
    "/beh.medi_khah.medi_yeh.fina": "\uFD9E",
    "/beh.medi_meem.fina": "\uFC6C",
    "/beh.medi_meem.medi": "\uFCE1",
    "/beh.medi_noon.fina": "\uFC6D",
    "/beh.medi_reh.fina": "\uFC6A",
    "/beh.medi_yeh.fina": "\uFC6F",
    "/beh.medi_zain.fina": "\uFC6B",
    "/behDotBelowThreeDotsAbove": "\u0751",
    "/behInvertedSmallVBelow": "\u0755",
    "/behSmallV": "\u0756",
    "/behThreeDotsHorizontallyBelow": "\u0750",
    "/behThreeDotsUpBelow": "\u0752",
    "/behThreeDotsUpBelowTwoDotsAbove": "\u0753",
    "/behTwoDotsBelowDotAbove": "\u0754",
    "/beharabic": "\u0628",
    "/beheh": "\u0680",
    "/beheh.fina": "\uFB5B",
    "/beheh.init": "\uFB5C",
    "/beheh.isol": "\uFB5A",
    "/beheh.medi": "\uFB5D",
    "/behfinalarabic": "\uFE90",
    "/behinitialarabic": "\uFE91",
    "/behiragana": "\u3079",
    "/behmedialarabic": "\uFE92",
    "/behmeeminitialarabic": "\uFC9F",
    "/behmeemisolatedarabic": "\uFC08",
    "/behnoonfinalarabic": "\uFC6D",
    "/bekatakana": "\u30D9",
    "/bellCancellationStroke": "\u1F515",
    "/bellhopBell": "\u1F6CE",
    "/beltbuckle": "\u2444",
    "/benarmenian": "\u0562",
    "/beng:a": "\u0985",
    "/beng:aa": "\u0986",
    "/beng:aasign": "\u09BE",
    "/beng:abbreviationsign": "\u09FD",
    "/beng:ai": "\u0990",
    "/beng:aisign": "\u09C8",
    "/beng:anji": "\u0980",
    "/beng:anusvara": "\u0982",
    "/beng:au": "\u0994",
    "/beng:aulengthmark": "\u09D7",
    "/beng:ausign": "\u09CC",
    "/beng:avagraha": "\u09BD",
    "/beng:ba": "\u09AC",
    "/beng:bha": "\u09AD",
    "/beng:ca": "\u099A",
    "/beng:candrabindu": "\u0981",
    "/beng:cha": "\u099B",
    "/beng:currencyoneless": "\u09F8",
    "/beng:da": "\u09A6",
    "/beng:dda": "\u09A1",
    "/beng:ddha": "\u09A2",
    "/beng:dha": "\u09A7",
    "/beng:e": "\u098F",
    "/beng:eight": "\u09EE",
    "/beng:esign": "\u09C7",
    "/beng:five": "\u09EB",
    "/beng:four": "\u09EA",
    "/beng:fourcurrencynumerator": "\u09F7",
    "/beng:ga": "\u0997",
    "/beng:gandamark": "\u09FB",
    "/beng:gha": "\u0998",
    "/beng:ha": "\u09B9",
    "/beng:i": "\u0987",
    "/beng:ii": "\u0988",
    "/beng:iisign": "\u09C0",
    "/beng:isign": "\u09BF",
    "/beng:isshar": "\u09FA",
    "/beng:ja": "\u099C",
    "/beng:jha": "\u099D",
    "/beng:ka": "\u0995",
    "/beng:kha": "\u0996",
    "/beng:khandata": "\u09CE",
    "/beng:la": "\u09B2",
    "/beng:llvocal": "\u09E1",
    "/beng:llvocalsign": "\u09E3",
    "/beng:lvocal": "\u098C",
    "/beng:lvocalsign": "\u09E2",
    "/beng:ma": "\u09AE",
    "/beng:na": "\u09A8",
    "/beng:nga": "\u0999",
    "/beng:nine": "\u09EF",
    "/beng:nna": "\u09A3",
    "/beng:nukta": "\u09BC",
    "/beng:nya": "\u099E",
    "/beng:o": "\u0993",
    "/beng:one": "\u09E7",
    "/beng:onecurrencynumerator": "\u09F4",
    "/beng:osign": "\u09CB",
    "/beng:pa": "\u09AA",
    "/beng:pha": "\u09AB",
    "/beng:ra": "\u09B0",
    "/beng:ralowdiagonal": "\u09F1",
    "/beng:ramiddiagonal": "\u09F0",
    "/beng:rha": "\u09DD",
    "/beng:rra": "\u09DC",
    "/beng:rrvocal": "\u09E0",
    "/beng:rrvocalsign": "\u09C4",
    "/beng:rupee": "\u09F3",
    "/beng:rupeemark": "\u09F2",
    "/beng:rvocal": "\u098B",
    "/beng:rvocalsign": "\u09C3",
    "/beng:sa": "\u09B8",
    "/beng:seven": "\u09ED",
    "/beng:sha": "\u09B6",
    "/beng:six": "\u09EC",
    "/beng:sixteencurrencydenominator": "\u09F9",
    "/beng:ssa": "\u09B7",
    "/beng:ta": "\u09A4",
    "/beng:tha": "\u09A5",
    "/beng:three": "\u09E9",
    "/beng:threecurrencynumerator": "\u09F6",
    "/beng:tta": "\u099F",
    "/beng:ttha": "\u09A0",
    "/beng:two": "\u09E8",
    "/beng:twocurrencynumerator": "\u09F5",
    "/beng:u": "\u0989",
    "/beng:usign": "\u09C1",
    "/beng:uu": "\u098A",
    "/beng:uusign": "\u09C2",
    "/beng:vedicanusvara": "\u09FC",
    "/beng:virama": "\u09CD",
    "/beng:visarga": "\u0983",
    "/beng:ya": "\u09AF",
    "/beng:yya": "\u09DF",
    "/beng:zero": "\u09E6",
    "/bentoBox": "\u1F371",
    "/benzenering": "\u232C",
    "/benzeneringcircle": "\u23E3",
    "/bet": "\u05D1",
    "/bet:hb": "\u05D1",
    "/beta": "\u03B2",
    "/betasymbol": "\u03D0",
    "/betasymbolgreek": "\u03D0",
    "/betdagesh": "\uFB31",
    "/betdageshhebrew": "\uFB31",
    "/bethebrew": "\u05D1",
    "/betrafehebrew": "\uFB4C",
    "/between": "\u226C",
    "/betwithdagesh:hb": "\uFB31",
    "/betwithrafe:hb": "\uFB4C",
    "/bflourish": "\uA797",
    "/bhabengali": "\u09AD",
    "/bhadeva": "\u092D",
    "/bhagujarati": "\u0AAD",
    "/bhagurmukhi": "\u0A2D",
    "/bhook": "\u0253",
    "/bicycle": "\u1F6B2",
    "/bicyclist": "\u1F6B4",
    "/bihiragana": "\u3073",
    "/bikatakana": "\u30D3",
    "/bikini": "\u1F459",
    "/bilabialclick": "\u0298",
    "/billiards": "\u1F3B1",
    "/bindigurmukhi": "\u0A02",
    "/biohazard": "\u2623",
    "/bird": "\u1F426",
    "/birthdayCake": "\u1F382",
    "/birusquare": "\u3331",
    "/bishopblack": "\u265D",
    "/bishopwhite": "\u2657",
    "/bitcoin": "\u20BF",
    "/blackDownPointingBackhandIndex": "\u1F5A3",
    "/blackDroplet": "\u1F322",
    "/blackFolder": "\u1F5BF",
    "/blackHardShellFloppyDisk": "\u1F5AA",
    "/blackHeart": "\u1F5A4",
    "/blackLeftPointingBackhandIndex": "\u1F59C",
    "/blackPennant": "\u1F3F2",
    "/blackPushpin": "\u1F588",
    "/blackRightPointingBackhandIndex": "\u1F59D",
    "/blackRosette": "\u1F3F6",
    "/blackSkullAndCrossbones": "\u1F571",
    "/blackSquareButton": "\u1F532",
    "/blackTouchtoneTelephone": "\u1F57F",
    "/blackUpPointingBackhandIndex": "\u1F5A2",
    "/blackcircle": "\u25CF",
    "/blackcircleforrecord": "\u23FA",
    "/blackdiamond": "\u25C6",
    "/blackdownpointingtriangle": "\u25BC",
    "/blackforstopsquare": "\u23F9",
    "/blackleftpointingpointer": "\u25C4",
    "/blackleftpointingtriangle": "\u25C0",
    "/blacklenticularbracketleft": "\u3010",
    "/blacklenticularbracketleftvertical": "\uFE3B",
    "/blacklenticularbracketright": "\u3011",
    "/blacklenticularbracketrightvertical": "\uFE3C",
    "/blacklowerlefttriangle": "\u25E3",
    "/blacklowerrighttriangle": "\u25E2",
    "/blackmediumpointingtriangledown": "\u23F7",
    "/blackmediumpointingtriangleleft": "\u23F4",
    "/blackmediumpointingtriangleright": "\u23F5",
    "/blackmediumpointingtriangleup": "\u23F6",
    "/blackpointingdoubletrianglebarverticalleft": "\u23EE",
    "/blackpointingdoubletrianglebarverticalright": "\u23ED",
    "/blackpointingdoubletriangledown": "\u23EC",
    "/blackpointingdoubletriangleleft": "\u23EA",
    "/blackpointingdoubletriangleright": "\u23E9",
    "/blackpointingdoubletriangleup": "\u23EB",
    "/blackpointingtriangledoublebarverticalright": "\u23EF",
    "/blackrectangle": "\u25AC",
    "/blackrightpointingpointer": "\u25BA",
    "/blackrightpointingtriangle": "\u25B6",
    "/blacksmallsquare": "\u25AA",
    "/blacksmilingface": "\u263B",
    "/blacksquare": "\u25A0",
    "/blackstar": "\u2605",
    "/blackupperlefttriangle": "\u25E4",
    "/blackupperrighttriangle": "\u25E5",
    "/blackuppointingsmalltriangle": "\u25B4",
    "/blackuppointingtriangle": "\u25B2",
    "/blackwardsbulletleft": "\u204C",
    "/blackwardsbulletright": "\u204D",
    "/blank": "\u2423",
    "/blinebelow": "\u1E07",
    "/block": "\u2588",
    "/blossom": "\u1F33C",
    "/blowfish": "\u1F421",
    "/blueBook": "\u1F4D8",
    "/blueHeart": "\u1F499",
    "/bmonospace": "\uFF42",
    "/boar": "\u1F417",
    "/board": "\u2328",
    "/bobaimaithai": "\u0E1A",
    "/bohiragana": "\u307C",
    "/bokatakana": "\u30DC",
    "/bomb": "\u1F4A3",
    "/book": "\u1F56E",
    "/bookmark": "\u1F516",
    "/bookmarkTabs": "\u1F4D1",
    "/books": "\u1F4DA",
    "/bopo:a": "\u311A",
    "/bopo:ai": "\u311E",
    "/bopo:an": "\u3122",
    "/bopo:ang": "\u3124",
    "/bopo:au": "\u3120",
    "/bopo:b": "\u3105",
    "/bopo:c": "\u3118",
    "/bopo:ch": "\u3114",
    "/bopo:d": "\u3109",
    "/bopo:e": "\u311C",
    "/bopo:eh": "\u311D",
    "/bopo:ei": "\u311F",
    "/bopo:en": "\u3123",
    "/bopo:eng": "\u3125",
    "/bopo:er": "\u3126",
    "/bopo:f": "\u3108",
    "/bopo:g": "\u310D",
    "/bopo:gn": "\u312C",
    "/bopo:h": "\u310F",
    "/bopo:i": "\u3127",
    "/bopo:ih": "\u312D",
    "/bopo:iu": "\u3129",
    "/bopo:j": "\u3110",
    "/bopo:k": "\u310E",
    "/bopo:l": "\u310C",
    "/bopo:m": "\u3107",
    "/bopo:n": "\u310B",
    "/bopo:ng": "\u312B",
    "/bopo:o": "\u311B",
    "/bopo:ou": "\u3121",
    "/bopo:owithdotabove": "\u312E",
    "/bopo:p": "\u3106",
    "/bopo:q": "\u3111",
    "/bopo:r": "\u3116",
    "/bopo:s": "\u3119",
    "/bopo:sh": "\u3115",
    "/bopo:t": "\u310A",
    "/bopo:u": "\u3128",
    "/bopo:v": "\u312A",
    "/bopo:x": "\u3112",
    "/bopo:z": "\u3117",
    "/bopo:zh": "\u3113",
    "/borutosquare": "\u333E",
    "/bottlePoppingCork": "\u1F37E",
    "/bouquet": "\u1F490",
    "/bouquetOfFlowers": "\u1F395",
    "/bowAndArrow": "\u1F3F9",
    "/bowlOfHygieia": "\u1F54F",
    "/bowling": "\u1F3B3",
    "/boxlineverticalleft": "\u23B8",
    "/boxlineverticalright": "\u23B9",
    "/boy": "\u1F466",
    "/boys": "\u1F6C9",
    "/bparen": "\u249D",
    "/bparenthesized": "\u249D",
    "/bqfullwidth": "\u33C3",
    "/bqsquare": "\u33C3",
    "/braceex": "\uF8F4",
    "/braceleft": "\u007B",
    "/braceleftbt": "\uF8F3",
    "/braceleftmid": "\uF8F2",
    "/braceleftmonospace": "\uFF5B",
    "/braceleftsmall": "\uFE5B",
    "/bracelefttp": "\uF8F1",
    "/braceleftvertical": "\uFE37",
    "/braceright": "\u007D",
    "/bracerightbt": "\uF8FE",
    "/bracerightmid": "\uF8FD",
    "/bracerightmonospace": "\uFF5D",
    "/bracerightsmall": "\uFE5C",
    "/bracerighttp": "\uF8FC",
    "/bracerightvertical": "\uFE38",
    "/bracketangledblleft": "\u27EA",
    "/bracketangledblright": "\u27EB",
    "/bracketangleleft": "\u27E8",
    "/bracketangleright": "\u27E9",
    "/bracketbottomcurly": "\u23DF",
    "/bracketbottomsquare": "\u23B5",
    "/bracketcornerupleftsquare": "\u23A1",
    "/bracketcorneruprightsquare": "\u23A4",
    "/bracketdottedsubstitutionleft": "\u2E04",
    "/bracketdottedsubstitutionright": "\u2E05",
    "/bracketextensioncurly": "\u23AA",
    "/bracketextensionleftsquare": "\u23A2",
    "/bracketextensionrightsquare": "\u23A5",
    "/brackethalfbottomleft": "\u2E24",
    "/brackethalfbottomright": "\u2E25",
    "/brackethalftopleft": "\u2E22",
    "/brackethalftopright": "\u2E23",
    "/brackethookupleftcurly": "\u23A7",
    "/brackethookuprightcurly": "\u23AB",
    "/bracketleft": "\u005B",
    "/bracketleftbt": "\uF8F0",
    "/bracketleftex": "\uF8EF",
    "/bracketleftmonospace": "\uFF3B",
    "/bracketleftsquarequill": "\u2045",
    "/bracketlefttp": "\uF8EE",
    "/bracketlowercornerleftsquare": "\u23A3",
    "/bracketlowercornerrightsquare": "\u23A6",
    "/bracketlowerhookleftcurly": "\u23A9",
    "/bracketlowerhookrightcurly": "\u23AD",
    "/bracketmiddlepieceleftcurly": "\u23A8",
    "/bracketmiddlepiecerightcurly": "\u23AC",
    "/bracketoverbrackettopbottomsquare": "\u23B6",
    "/bracketparaphraselowleft": "\u2E1C",
    "/bracketparaphraselowright": "\u2E1D",
    "/bracketraisedleft": "\u2E0C",
    "/bracketraisedright": "\u2E0D",
    "/bracketright": "\u005D",
    "/bracketrightbt": "\uF8FB",
    "/bracketrightex": "\uF8FA",
    "/bracketrightmonospace": "\uFF3D",
    "/bracketrightsquarequill": "\u2046",
    "/bracketrighttp": "\uF8F9",
    "/bracketsectionupleftlowerrightcurly": "\u23B0",
    "/bracketsectionuprightlowerleftcurly": "\u23B1",
    "/bracketshellbottom": "\u23E1",
    "/bracketshelltop": "\u23E0",
    "/bracketshellwhiteleft": "\u27EC",
    "/bracketshellwhiteright": "\u27ED",
    "/bracketsubstitutionleft": "\u2E02",
    "/bracketsubstitutionright": "\u2E03",
    "/brackettopcurly": "\u23DE",
    "/brackettopsquare": "\u23B4",
    "/brackettranspositionleft": "\u2E09",
    "/brackettranspositionright": "\u2E0A",
    "/bracketwhitesquareleft": "\u27E6",
    "/bracketwhitesquareright": "\u27E7",
    "/branchbankidentification": "\u2446",
    "/bread": "\u1F35E",
    "/breve": "\u02D8",
    "/brevebelowcmb": "\u032E",
    "/brevecmb": "\u0306",
    "/breveinvertedbelowcmb": "\u032F",
    "/breveinvertedcmb": "\u0311",
    "/breveinverteddoublecmb": "\u0361",
    "/brevemetrical": "\u23D1",
    "/brideVeil": "\u1F470",
    "/bridgeAtNight": "\u1F309",
    "/bridgebelowcmb": "\u032A",
    "/bridgeinvertedbelowcmb": "\u033A",
    "/briefcase": "\u1F4BC",
    "/brll:blank": "\u2800",
    "/brokenHeart": "\u1F494",
    "/brokenbar": "\u00A6",
    "/brokencirclenorthwestarrow": "\u238B",
    "/bstroke": "\u0180",
    "/bsuperior": "\uF6EA",
    "/btopbar": "\u0183",
    "/bug": "\u1F41B",
    "/buhiragana": "\u3076",
    "/buildingConstruction": "\u1F3D7",
    "/bukatakana": "\u30D6",
    "/bullet": "\u2022",
    "/bulletinverse": "\u25D8",
    "/bulletoperator": "\u2219",
    "/bullhorn": "\u1F56B",
    "/bullhornSoundWaves": "\u1F56C",
    "/bullseye": "\u25CE",
    "/burrito": "\u1F32F",
    "/bus": "\u1F68C",
    "/busStop": "\u1F68F",
    "/bussyerusquare": "\u3334",
    "/bustInSilhouette": "\u1F464",
    "/bustsInSilhouette": "\u1F465",
    "/c": "\u0063",
    "/caarmenian": "\u056E",
    "/cabengali": "\u099A",
    "/cactus": "\u1F335",
    "/cacute": "\u0107",
    "/cadauna": "\u2106",
    "/cadeva": "\u091A",
    "/caduceus": "\u2624",
    "/cagujarati": "\u0A9A",
    "/cagurmukhi": "\u0A1A",
    "/cakraconsonant": "\uA9BF",
    "/calendar": "\u1F4C5",
    "/calfullwidth": "\u3388",
    "/callideographicparen": "\u323A",
    "/calsquare": "\u3388",
    "/camera": "\u1F4F7",
    "/cameraFlash": "\u1F4F8",
    "/camping": "\u1F3D5",
    "/camurda": "\uA996",
    "/cancellationX": "\u1F5D9",
    "/cancer": "\u264B",
    "/candle": "\u1F56F",
    "/candrabindubengali": "\u0981",
    "/candrabinducmb": "\u0310",
    "/candrabindudeva": "\u0901",
    "/candrabindugujarati": "\u0A81",
    "/candy": "\u1F36C",
    "/canoe": "\u1F6F6",
    "/capitulum": "\u2E3F",
    "/capricorn": "\u2651",
    "/capslock": "\u21EA",
    "/cardFileBox": "\u1F5C3",
    "/cardIndex": "\u1F4C7",
    "/cardIndexDividers": "\u1F5C2",
    "/careof": "\u2105",
    "/caret": "\u2038",
    "/caretinsertionpoint": "\u2041",
    "/carettildedownfunc": "\u2371",
    "/carettildeupfunc": "\u2372",
    "/caron": "\u02C7",
    "/caronbelowcmb": "\u032C",
    "/caroncmb": "\u030C",
    "/carouselHorse": "\u1F3A0",
    "/carpStreamer": "\u1F38F",
    "/carriagereturn": "\u21B5",
    "/carsliding": "\u26D0",
    "/castle": "\u26EB",
    "/cat": "\u1F408",
    "/catFace": "\u1F431",
    "/catFaceWithTearsOfJoy": "\u1F639",
    "/catFaceWithWrySmile": "\u1F63C",
    "/caution": "\u2621",
    "/cbar": "\uA793",
    "/cbopomofo": "\u3118",
    "/ccaron": "\u010D",
    "/ccedilla": "\u00E7",
    "/ccedillaacute": "\u1E09",
    "/ccfullwidth": "\u33C4",
    "/ccircle": "\u24D2",
    "/ccircumflex": "\u0109",
    "/ccurl": "\u0255",
    "/cdfullwidth": "\u33C5",
    "/cdot": "\u010B",
    "/cdotaccent": "\u010B",
    "/cdotreversed": "\uA73F",
    "/cdsquare": "\u33C5",
    "/cecak": "\uA981",
    "/cecaktelu": "\uA9B3",
    "/cedi": "\u20B5",
    "/cedilla": "\u00B8",
    "/cedillacmb": "\u0327",
    "/ceilingleft": "\u2308",
    "/ceilingright": "\u2309",
    "/celticCross": "\u1F548",
    "/cent": "\u00A2",
    "/centigrade": "\u2103",
    "/centinferior": "\uF6DF",
    "/centmonospace": "\uFFE0",
    "/centoldstyle": "\uF7A2",
    "/centreddotwhitediamond": "\u27D0",
    "/centreideographiccircled": "\u32A5",
    "/centreline": "\u2104",
    "/centrelineverticalsquarewhite": "\u2385",
    "/centsuperior": "\uF6E0",
    "/ceres": "\u26B3",
    "/chaarmenian": "\u0579",
    "/chabengali": "\u099B",
    "/chadeva": "\u091B",
    "/chagujarati": "\u0A9B",
    "/chagurmukhi": "\u0A1B",
    "/chains": "\u26D3",
    "/chair": "\u2441",
    "/chamkocircle": "\u327C",
    "/charactertie": "\u2040",
    "/chartDownwardsTrend": "\u1F4C9",
    "/chartUpwardsTrend": "\u1F4C8",
    "/chartUpwardsTrendAndYenSign": "\u1F4B9",
    "/chbopomofo": "\u3114",
    "/cheabkhasiancyrillic": "\u04BD",
    "/cheabkhcyr": "\u04BD",
    "/cheabkhtailcyr": "\u04BF",
    "/checkbox": "\u2610",
    "/checkboxchecked": "\u2611",
    "/checkboxx": "\u2612",
    "/checkmark": "\u2713",
    "/checyr": "\u0447",
    "/checyrillic": "\u0447",
    "/chedescenderabkhasiancyrillic": "\u04BF",
    "/chedescendercyrillic": "\u04B7",
    "/chedieresiscyr": "\u04F5",
    "/chedieresiscyrillic": "\u04F5",
    "/cheeringMegaphone": "\u1F4E3",
    "/cheharmenian": "\u0573",
    "/chekhakascyr": "\u04CC",
    "/chekhakassiancyrillic": "\u04CC",
    "/chequeredFlag": "\u1F3C1",
    "/cherries": "\u1F352",
    "/cherryBlossom": "\u1F338",
    "/chestnut": "\u1F330",
    "/chetailcyr": "\u04B7",
    "/chevertcyr": "\u04B9",
    "/cheverticalstrokecyrillic": "\u04B9",
    "/chi": "\u03C7",
    "/chicken": "\u1F414",
    "/chieuchacirclekorean": "\u3277",
    "/chieuchaparenkorean": "\u3217",
    "/chieuchcirclekorean": "\u3269",
    "/chieuchkorean": "\u314A",
    "/chieuchparenkorean": "\u3209",
    "/childrenCrossing": "\u1F6B8",
    "/chipmunk": "\u1F43F",
    "/chirho": "\u2627",
    "/chiron": "\u26B7",
    "/chochangthai": "\u0E0A",
    "/chochanthai": "\u0E08",
    "/chochingthai": "\u0E09",
    "/chochoethai": "\u0E0C",
    "/chocolateBar": "\u1F36B",
    "/chook": "\u0188",
    "/christmasTree": "\u1F384",
    "/church": "\u26EA",
    "/cieucacirclekorean": "\u3276",
    "/cieucaparenkorean": "\u3216",
    "/cieuccirclekorean": "\u3268",
    "/cieuckorean": "\u3148",
    "/cieucparenkorean": "\u3208",
    "/cieucuparenkorean": "\u321C",
    "/cinema": "\u1F3A6",
    "/circle": "\u25CB",
    "/circleallbutupperquadrantleftblack": "\u25D5",
    "/circlebackslashfunc": "\u2349",
    "/circleblack": "\u25CF",
    "/circledCrossPommee": "\u1F540",
    "/circledInformationSource": "\u1F6C8",
    "/circledasteriskoperator": "\u229B",
    "/circledbarnotchhorizontal": "\u2389",
    "/circledcrossinglanes": "\u26D2",
    "/circleddash": "\u229D",
    "/circleddivisionslash": "\u2298",
    "/circleddotoperator": "\u2299",
    "/circledequals": "\u229C",
    "/circlediaeresisfunc": "\u2365",
    "/circledminus": "\u2296",
    "/circledot": "\u2299",
    "/circledotrightwhite": "\u2686",
    "/circledotted": "\u25CC",
    "/circledringoperator": "\u229A",
    "/circledtriangledown": "\u238A",
    "/circlehalfleftblack": "\u25D0",
    "/circlehalfrightblack": "\u25D1",
    "/circleinversewhite": "\u25D9",
    "/circlejotfunc": "\u233E",
    "/circlelowerhalfblack": "\u25D2",
    "/circlelowerquadrantleftwhite": "\u25F5",
    "/circlelowerquadrantrightwhite": "\u25F6",
    "/circlemultiply": "\u2297",
    "/circleot": "\u2299",
    "/circleplus": "\u2295",
    "/circlepostalmark": "\u3036",
    "/circlestarfunc": "\u235F",
    "/circlestilefunc": "\u233D",
    "/circlestroketwodotsaboveheavy": "\u26E3",
    "/circletwodotsblackwhite": "\u2689",
    "/circletwodotswhite": "\u2687",
    "/circleunderlinefunc": "\u235C",
    "/circleupperhalfblack": "\u25D3",
    "/circleupperquadrantleftwhite": "\u25F4",
    "/circleupperquadrantrightblack": "\u25D4",
    "/circleupperquadrantrightwhite": "\u25F7",
    "/circleverticalfill": "\u25CD",
    "/circlewhite": "\u25CB",
    "/circlewhitedotrightblack": "\u2688",
    "/circlewithlefthalfblack": "\u25D0",
    "/circlewithrighthalfblack": "\u25D1",
    "/circumflex": "\u02C6",
    "/circumflexbelowcmb": "\u032D",
    "/circumflexcmb": "\u0302",
    "/circumflexlow": "\uA788",
    "/circusTent": "\u1F3AA",
    "/cityscape": "\u1F3D9",
    "/cityscapeAtDusk": "\u1F306",
    "/cjk:ideographiccomma": "\u3001",
    "/cjk:tortoiseshellbracketleft": "\u3014",
    "/cjk:tortoiseshellbracketright": "\u3015",
    "/clamshellMobilePhone": "\u1F581",
    "/clapperBoard": "\u1F3AC",
    "/clappingHandsSign": "\u1F44F",
    "/classicalBuilding": "\u1F3DB",
    "/clear": "\u2327",
    "/clearscreen": "\u239A",
    "/clickalveolar": "\u01C2",
    "/clickbilabial": "\u0298",
    "/clickdental": "\u01C0",
    "/clicklateral": "\u01C1",
    "/clickretroflex": "\u01C3",
    "/clinkingBeerMugs": "\u1F37B",
    "/clipboard": "\u1F4CB",
    "/clockFaceEight-thirty": "\u1F563",
    "/clockFaceEightOclock": "\u1F557",
    "/clockFaceEleven-thirty": "\u1F566",
    "/clockFaceElevenOclock": "\u1F55A",
    "/clockFaceFive-thirty": "\u1F560",
    "/clockFaceFiveOclock": "\u1F554",
    "/clockFaceFour-thirty": "\u1F55F",
    "/clockFaceFourOclock": "\u1F553",
    "/clockFaceNine-thirty": "\u1F564",
    "/clockFaceNineOclock": "\u1F558",
    "/clockFaceOne-thirty": "\u1F55C",
    "/clockFaceOneOclock": "\u1F550",
    "/clockFaceSeven-thirty": "\u1F562",
    "/clockFaceSevenOclock": "\u1F556",
    "/clockFaceSix-thirty": "\u1F561",
    "/clockFaceSixOclock": "\u1F555",
    "/clockFaceTen-thirty": "\u1F565",
    "/clockFaceTenOclock": "\u1F559",
    "/clockFaceThree-thirty": "\u1F55E",
    "/clockFaceThreeOclock": "\u1F552",
    "/clockFaceTwelve-thirty": "\u1F567",
    "/clockFaceTwelveOclock": "\u1F55B",
    "/clockFaceTwo-thirty": "\u1F55D",
    "/clockFaceTwoOclock": "\u1F551",
    "/clockwiseDownwardsAndUpwardsOpenCircleArrows": "\u1F503",
    "/clockwiseRightAndLeftSemicircleArrows": "\u1F5D8",
    "/clockwiseRightwardsAndLeftwardsOpenCircleArrows": "\u1F501",
    "/clockwiseRightwardsAndLeftwardsOpenCircleArrowsCircledOneOverlay": "\u1F502",
    "/closedBook": "\u1F4D5",
    "/closedLockKey": "\u1F510",
    "/closedMailboxLoweredFlag": "\u1F4EA",
    "/closedMailboxRaisedFlag": "\u1F4EB",
    "/closedUmbrella": "\u1F302",
    "/closedentryleft": "\u26DC",
    "/closeup": "\u2050",
    "/cloud": "\u2601",
    "/cloudLightning": "\u1F329",
    "/cloudRain": "\u1F327",
    "/cloudSnow": "\u1F328",
    "/cloudTornado": "\u1F32A",
    "/clsquare": "\u1F191",
    "/club": "\u2663",
    "/clubblack": "\u2663",
    "/clubsuitblack": "\u2663",
    "/clubsuitwhite": "\u2667",
    "/clubwhite": "\u2667",
    "/cm2fullwidth": "\u33A0",
    "/cm3fullwidth": "\u33A4",
    "/cmb:a": "\u0363",
    "/cmb:aaboveflat": "\u1DD3",
    "/cmb:aboveogonek": "\u1DCE",
    "/cmb:acute": "\u0301",
    "/cmb:acutebelow": "\u0317",
    "/cmb:acutegraveacute": "\u1DC9",
    "/cmb:acutemacron": "\u1DC7",
    "/cmb:acutetone": "\u0341",
    "/cmb:adieresis": "\u1DF2",
    "/cmb:ae": "\u1DD4",
    "/cmb:almostequalabove": "\u034C",
    "/cmb:almostequaltobelow": "\u1DFD",
    "/cmb:alpha": "\u1DE7",
    "/cmb:ao": "\u1DD5",
    "/cmb:arrowheadleftbelow": "\u0354",
    "/cmb:arrowheadrightabove": "\u0350",
    "/cmb:arrowheadrightarrowheadupbelow": "\u0356",
    "/cmb:arrowheadrightbelow": "\u0355",
    "/cmb:arrowleftrightbelow": "\u034D",
    "/cmb:arrowrightdoublebelow": "\u0362",
    "/cmb:arrowupbelow": "\u034E",
    "/cmb:asteriskbelow": "\u0359",
    "/cmb:av": "\u1DD6",
    "/cmb:b": "\u1DE8",
    "/cmb:belowbreve": "\u032E",
    "/cmb:beta": "\u1DE9",
    "/cmb:breve": "\u0306",
    "/cmb:brevemacron": "\u1DCB",
    "/cmb:bridgeabove": "\u0346",
    "/cmb:bridgebelow": "\u032A",
    "/cmb:c": "\u0368",
    "/cmb:candrabindu": "\u0310",
    "/cmb:caron": "\u030C",
    "/cmb:caronbelow": "\u032C",
    "/cmb:ccedilla": "\u1DD7",
    "/cmb:cedilla": "\u0327",
    "/cmb:circumflex": "\u0302",
    "/cmb:circumflexbelow": "\u032D",
    "/cmb:commaaccentbelow": "\u0326",
    "/cmb:commaturnedabove": "\u0312",
    "/cmb:d": "\u0369",
    "/cmb:dblarchinvertedbelow": "\u032B",
    "/cmb:dbloverline": "\u033F",
    "/cmb:dblverticallineabove": "\u030E",
    "/cmb:dblverticallinebelow": "\u0348",
    "/cmb:deletionmark": "\u1DFB",
    "/cmb:dialytikatonos": "\u0344",
    "/cmb:dieresis": "\u0308",
    "/cmb:dieresisbelow": "\u0324",
    "/cmb:dotaboveleft": "\u1DF8",
    "/cmb:dotaccent": "\u0307",
    "/cmb:dotbelowcomb": "\u0323",
    "/cmb:dotrightabove": "\u0358",
    "/cmb:dottedacute": "\u1DC1",
    "/cmb:dottedgrave": "\u1DC0",
    "/cmb:doubleabovecircumflex": "\u1DCD",
    "/cmb:doublebelowbreve": "\u035C",
    "/cmb:doublebreve": "\u035D",
    "/cmb:doubleinvertedbelowbreve": "\u1DFC",
    "/cmb:doubleringbelow": "\u035A",
    "/cmb:downtackbelow": "\u031E",
    "/cmb:e": "\u0364",
    "/cmb:equalbelow": "\u0347",
    "/cmb:esh": "\u1DEF",
    "/cmb:eth": "\u1DD9",
    "/cmb:f": "\u1DEB",
    "/cmb:fermata": "\u0352",
    "/cmb:g": "\u1DDA",
    "/cmb:graphemejoiner": "\u034F",
    "/cmb:grave": "\u0300",
    "/cmb:graveacutegrave": "\u1DC8",
    "/cmb:gravebelow": "\u0316",
    "/cmb:gravedouble": "\u030F",
    "/cmb:gravemacron": "\u1DC5",
    "/cmb:gravetone": "\u0340",
    "/cmb:gsmall": "\u1DDB",
    "/cmb:h": "\u036A",
    "/cmb:halfleftringabove": "\u0351",
    "/cmb:halfleftringbelow": "\u031C",
    "/cmb:halfrightringabove": "\u0357",
    "/cmb:halfrightringbelow": "\u0339",
    "/cmb:homotheticabove": "\u034B",
    "/cmb:hookabove": "\u0309",
    "/cmb:horn": "\u031B",
    "/cmb:hungarumlaut": "\u030B",
    "/cmb:i": "\u0365",
    "/cmb:insulard": "\u1DD8",
    "/cmb:invertedbelowbreve": "\u032F",
    "/cmb:invertedbreve": "\u0311",
    "/cmb:invertedbridgebelow": "\u033A",
    "/cmb:inverteddoublebreve": "\u0361",
    "/cmb:iotasub": "\u0345",
    "/cmb:isbelow": "\u1DD0",
    "/cmb:k": "\u1DDC",
    "/cmb:kavykaaboveleft": "\u1DF7",
    "/cmb:kavykaaboveright": "\u1DF6",
    "/cmb:koronis": "\u0343",
    "/cmb:l": "\u1DDD",
    "/cmb:leftangleabove": "\u031A",
    "/cmb:leftanglebelow": "\u0349",
    "/cmb:leftarrowheadabove": "\u1DFE",
    "/cmb:lefttackbelow": "\u0318",
    "/cmb:lineverticalabove": "\u030D",
    "/cmb:lineverticalbelow": "\u0329",
    "/cmb:longs": "\u1DE5",
    "/cmb:lowline": "\u0332",
    "/cmb:lowlinedouble": "\u0333",
    "/cmb:lsmall": "\u1DDE",
    "/cmb:lwithdoublemiddletilde": "\u1DEC",
    "/cmb:m": "\u036B",
    "/cmb:macron": "\u0304",
    "/cmb:macronacute": "\u1DC4",
    "/cmb:macronbelow": "\u0331",
    "/cmb:macronbreve": "\u1DCC",
    "/cmb:macrondouble": "\u035E",
    "/cmb:macrondoublebelow": "\u035F",
    "/cmb:macrongrave": "\u1DC6",
    "/cmb:minusbelow": "\u0320",
    "/cmb:msmall": "\u1DDF",
    "/cmb:n": "\u1DE0",
    "/cmb:nottildeabove": "\u034A",
    "/cmb:nsmall": "\u1DE1",
    "/cmb:o": "\u0366",
    "/cmb:odieresis": "\u1DF3",
    "/cmb:ogonek": "\u0328",
    "/cmb:overlaystrokelong": "\u0336",
    "/cmb:overlaystrokeshort": "\u0335",
    "/cmb:overline": "\u0305",
    "/cmb:owithlightcentralizationstroke": "\u1DED",
    "/cmb:p": "\u1DEE",
    "/cmb:palatalizedhookbelow": "\u0321",
    "/cmb:perispomeni": "\u0342",
    "/cmb:plusbelow": "\u031F",
    "/cmb:r": "\u036C",
    "/cmb:rbelow": "\u1DCA",
    "/cmb:retroflexhookbelow": "\u0322",
    "/cmb:reversedcommaabove": "\u0314",
    "/cmb:rightarrowheadanddownarrowheadbelow": "\u1DFF",
    "/cmb:righttackbelow": "\u0319",
    "/cmb:ringabove": "\u030A",
    "/cmb:ringbelow": "\u0325",
    "/cmb:rrotunda": "\u1DE3",
    "/cmb:rsmall": "\u1DE2",
    "/cmb:s": "\u1DE4",
    "/cmb:schwa": "\u1DEA",
    "/cmb:seagullbelow": "\u033C",
    "/cmb:snakebelow": "\u1DC2",
    "/cmb:soliduslongoverlay": "\u0338",
    "/cmb:solidusshortoverlay": "\u0337",
    "/cmb:squarebelow": "\u033B",
    "/cmb:suspensionmark": "\u1DC3",
    "/cmb:t": "\u036D",
    "/cmb:tilde": "\u0303",
    "/cmb:tildebelow": "\u0330",
    "/cmb:tildedouble": "\u0360",
    "/cmb:tildeoverlay": "\u0334",
    "/cmb:tildevertical": "\u033E",
    "/cmb:turnedabove": "\u0313",
    "/cmb:turnedcommaabove": "\u0315",
    "/cmb:u": "\u0367",
    "/cmb:udieresis": "\u1DF4",
    "/cmb:uptackabove": "\u1DF5",
    "/cmb:uptackbelow": "\u031D",
    "/cmb:urabove": "\u1DD1",
    "/cmb:usabove": "\u1DD2",
    "/cmb:uwithlightcentralizationstroke": "\u1DF0",
    "/cmb:v": "\u036E",
    "/cmb:w": "\u1DF1",
    "/cmb:wideinvertedbridgebelow": "\u1DF9",
    "/cmb:x": "\u036F",
    "/cmb:xabove": "\u033D",
    "/cmb:xbelow": "\u0353",
    "/cmb:z": "\u1DE6",
    "/cmb:zigzagabove": "\u035B",
    "/cmb:zigzagbelow": "\u1DCF",
    "/cmcubedsquare": "\u33A4",
    "/cmfullwidth": "\u339D",
    "/cmonospace": "\uFF43",
    "/cmsquaredsquare": "\u33A0",
    "/cntr:acknowledge": "\u2406",
    "/cntr:backspace": "\u2408",
    "/cntr:bell": "\u2407",
    "/cntr:blank": "\u2422",
    "/cntr:cancel": "\u2418",
    "/cntr:carriagereturn": "\u240D",
    "/cntr:datalinkescape": "\u2410",
    "/cntr:delete": "\u2421",
    "/cntr:deleteformtwo": "\u2425",
    "/cntr:devicecontrolfour": "\u2414",
    "/cntr:devicecontrolone": "\u2411",
    "/cntr:devicecontrolthree": "\u2413",
    "/cntr:devicecontroltwo": "\u2412",
    "/cntr:endofmedium": "\u2419",
    "/cntr:endoftext": "\u2403",
    "/cntr:endoftransmission": "\u2404",
    "/cntr:endoftransmissionblock": "\u2417",
    "/cntr:enquiry": "\u2405",
    "/cntr:escape": "\u241B",
    "/cntr:fileseparator": "\u241C",
    "/cntr:formfeed": "\u240C",
    "/cntr:groupseparator": "\u241D",
    "/cntr:horizontaltab": "\u2409",
    "/cntr:linefeed": "\u240A",
    "/cntr:negativeacknowledge": "\u2415",
    "/cntr:newline": "\u2424",
    "/cntr:null": "\u2400",
    "/cntr:openbox": "\u2423",
    "/cntr:recordseparator": "\u241E",
    "/cntr:shiftin": "\u240F",
    "/cntr:shiftout": "\u240E",
    "/cntr:space": "\u2420",
    "/cntr:startofheading": "\u2401",
    "/cntr:startoftext": "\u2402",
    "/cntr:substitute": "\u241A",
    "/cntr:substituteformtwo": "\u2426",
    "/cntr:synchronousidle": "\u2416",
    "/cntr:unitseparator": "\u241F",
    "/cntr:verticaltab": "\u240B",
    "/coarmenian": "\u0581",
    "/cocktailGlass": "\u1F378",
    "/coffin": "\u26B0",
    "/cofullwidth": "\u33C7",
    "/collision": "\u1F4A5",
    "/colon": "\u003A",
    "/colonequals": "\u2254",
    "/colonmod": "\uA789",
    "/colonmonetary": "\u20A1",
    "/colonmonospace": "\uFF1A",
    "/colonraisedmod": "\u02F8",
    "/colonsign": "\u20A1",
    "/colonsmall": "\uFE55",
    "/colontriangularhalfmod": "\u02D1",
    "/colontriangularmod": "\u02D0",
    "/comet": "\u2604",
    "/comma": "\u002C",
    "/commaabovecmb": "\u0313",
    "/commaaboverightcmb": "\u0315",
    "/commaaccent": "\uF6C3",
    "/commaarabic": "\u060C",
    "/commaarmenian": "\u055D",
    "/commabarfunc": "\u236A",
    "/commainferior": "\uF6E1",
    "/commamonospace": "\uFF0C",
    "/commaraised": "\u2E34",
    "/commareversed": "\u2E41",
    "/commareversedabovecmb": "\u0314",
    "/commareversedmod": "\u02BD",
    "/commasmall": "\uFE50",
    "/commasuperior": "\uF6E2",
    "/commaturnedabovecmb": "\u0312",
    "/commaturnedmod": "\u02BB",
    "/commercialat": "\uFE6B",
    "/commercialminussign": "\u2052",
    "/compass": "\u263C",
    "/complement": "\u2201",
    "/composition": "\u2384",
    "/compression": "\u1F5DC",
    "/con": "\uA76F",
    "/confettiBall": "\u1F38A",
    "/confoundedFace": "\u1F616",
    "/confusedFace": "\u1F615",
    "/congratulationideographiccircled": "\u3297",
    "/congratulationideographicparen": "\u3237",
    "/congruent": "\u2245",
    "/conicaltaper": "\u2332",
    "/conjunction": "\u260C",
    "/consquareupblack": "\u26FE",
    "/constructionSign": "\u1F6A7",
    "/constructionWorker": "\u1F477",
    "/containsasmembersmall": "\u220D",
    "/containsasnormalsubgroorequalup": "\u22B5",
    "/containsasnormalsubgroup": "\u22B3",
    "/containslonghorizontalstroke": "\u22FA",
    "/containsoverbar": "\u22FD",
    "/containsoverbarsmall": "\u22FE",
    "/containssmallverticalbarhorizontalstroke": "\u22FC",
    "/containsverticalbarhorizontalstroke": "\u22FB",
    "/continuousunderline": "\u2381",
    "/contourintegral": "\u222E",
    "/control": "\u2303",
    "/controlACK": "\u0006",
    "/controlBEL": "\u0007",
    "/controlBS": "\u0008",
    "/controlCAN": "\u0018",
    "/controlCR": "\u000D",
    "/controlDC1": "\u0011",
    "/controlDC2": "\u0012",
    "/controlDC3": "\u0013",
    "/controlDC4": "\u0014",
    "/controlDEL": "\u007F",
    "/controlDLE": "\u0010",
    "/controlEM": "\u0019",
    "/controlENQ": "\u0005",
    "/controlEOT": "\u0004",
    "/controlESC": "\u001B",
    "/controlETB": "\u0017",
    "/controlETX": "\u0003",
    "/controlFF": "\u000C",
    "/controlFS": "\u001C",
    "/controlGS": "\u001D",
    "/controlHT": "\u0009",
    "/controlKnobs": "\u1F39B",
    "/controlLF": "\u000A",
    "/controlNAK": "\u0015",
    "/controlRS": "\u001E",
    "/controlSI": "\u000F",
    "/controlSO": "\u000E",
    "/controlSOT": "\u0002",
    "/controlSTX": "\u0001",
    "/controlSUB": "\u001A",
    "/controlSYN": "\u0016",
    "/controlUS": "\u001F",
    "/controlVT": "\u000B",
    "/convavediamondwhite": "\u27E1",
    "/convenienceStore": "\u1F3EA",
    "/cookedRice": "\u1F35A",
    "/cookie": "\u1F36A",
    "/cooking": "\u1F373",
    "/coolsquare": "\u1F192",
    "/coproductarray": "\u2210",
    "/copyideographiccircled": "\u32A2",
    "/copyright": "\u00A9",
    "/copyrightsans": "\uF8E9",
    "/copyrightserif": "\uF6D9",
    "/cornerbottomleft": "\u231E",
    "/cornerbottomright": "\u231F",
    "/cornerbracketleft": "\u300C",
    "/cornerbracketlefthalfwidth": "\uFF62",
    "/cornerbracketleftvertical": "\uFE41",
    "/cornerbracketright": "\u300D",
    "/cornerbracketrighthalfwidth": "\uFF63",
    "/cornerbracketrightvertical": "\uFE42",
    "/cornerdotupleft": "\u27D4",
    "/cornertopleft": "\u231C",
    "/cornertopright": "\u231D",
    "/coroniseditorial": "\u2E0E",
    "/corporationsquare": "\u337F",
    "/correctideographiccircled": "\u32A3",
    "/corresponds": "\u2258",
    "/cosquare": "\u33C7",
    "/couchAndLamp": "\u1F6CB",
    "/counterbore": "\u2334",
    "/countersink": "\u2335",
    "/coupleHeart": "\u1F491",
    "/coverkgfullwidth": "\u33C6",
    "/coverkgsquare": "\u33C6",
    "/cow": "\u1F404",
    "/cowFace": "\u1F42E",
    "/cpalatalhook": "\uA794",
    "/cparen": "\u249E",
    "/cparenthesized": "\u249E",
    "/creditCard": "\u1F4B3",
    "/crescentMoon": "\u1F319",
    "/creversed": "\u2184",
    "/cricketBatAndBall": "\u1F3CF",
    "/crocodile": "\u1F40A",
    "/cropbottomleft": "\u230D",
    "/cropbottomright": "\u230C",
    "/croptopleft": "\u230F",
    "/croptopright": "\u230E",
    "/crossPommee": "\u1F542",
    "/crossPommeeHalf-circleBelow": "\u1F541",
    "/crossedFlags": "\u1F38C",
    "/crossedswords": "\u2694",
    "/crossinglanes": "\u26CC",
    "/crossmod": "\u02DF",
    "/crossofjerusalem": "\u2629",
    "/crossoflorraine": "\u2628",
    "/crossonshieldblack": "\u26E8",
    "/crown": "\u1F451",
    "/crrn:rupee": "\u20A8",
    "/cruzeiro": "\u20A2",
    "/cryingCatFace": "\u1F63F",
    "/cryingFace": "\u1F622",
    "/crystalBall": "\u1F52E",
    "/cstretched": "\u0297",
    "/cstroke": "\u023C",
    "/cuatrillo": "\uA72D",
    "/cuatrillocomma": "\uA72F",
    "/curlyand": "\u22CF",
    "/curlylogicaland": "\u22CF",
    "/curlylogicalor": "\u22CE",
    "/curlyor": "\u22CE",
    "/currency": "\u00A4",
    "/currencyExchange": "\u1F4B1",
    "/curryAndRice": "\u1F35B",
    "/custard": "\u1F36E",
    "/customeraccountnumber": "\u2449",
    "/customs": "\u1F6C3",
    "/cyclone": "\u1F300",
    "/cylindricity": "\u232D",
    "/cyrBreve": "\uF6D1",
    "/cyrFlex": "\uF6D2",
    "/cyrbreve": "\uF6D4",
    "/cyrflex": "\uF6D5",
    "/d": "\u0064",
    "/daarmenian": "\u0564",
    "/daasusquare": "\u3324",
    "/dabengali": "\u09A6",
    "/dad": "\u0636",
    "/dad.fina": "\uFEBE",
    "/dad.init": "\uFEBF",
    "/dad.init_alefmaksura.fina": "\uFD07",
    "/dad.init_hah.fina": "\uFC23",
    "/dad.init_hah.medi": "\uFCB5",
    "/dad.init_jeem.fina": "\uFC22",
    "/dad.init_jeem.medi": "\uFCB4",
    "/dad.init_khah.fina": "\uFC24",
    "/dad.init_khah.medi": "\uFCB6",
    "/dad.init_khah.medi_meem.medi": "\uFD70",
    "/dad.init_meem.fina": "\uFC25",
    "/dad.init_meem.medi": "\uFCB7",
    "/dad.init_reh.fina": "\uFD10",
    "/dad.init_yeh.fina": "\uFD08",
    "/dad.isol": "\uFEBD",
    "/dad.medi": "\uFEC0",
    "/dad.medi_alefmaksura.fina": "\uFD23",
    "/dad.medi_hah.medi_alefmaksura.fina": "\uFD6E",
    "/dad.medi_hah.medi_yeh.fina": "\uFDAB",
    "/dad.medi_khah.medi_meem.fina": "\uFD6F",
    "/dad.medi_reh.fina": "\uFD2C",
    "/dad.medi_yeh.fina": "\uFD24",
    "/dadarabic": "\u0636",
    "/daddotbelow": "\u06FB",
    "/dadeva": "\u0926",
    "/dadfinalarabic": "\uFEBE",
    "/dadinitialarabic": "\uFEBF",
    "/dadmedialarabic": "\uFEC0",
    "/dafullwidth": "\u3372",
    "/dagesh": "\u05BC",
    "/dagesh:hb": "\u05BC",
    "/dageshhebrew": "\u05BC",
    "/dagger": "\u2020",
    "/daggerKnife": "\u1F5E1",
    "/daggerdbl": "\u2021",
    "/daggerwithguardleft": "\u2E36",
    "/daggerwithguardright": "\u2E37",
    "/dagujarati": "\u0AA6",
    "/dagurmukhi": "\u0A26",
    "/dahal": "\u068C",
    "/dahal.fina": "\uFB85",
    "/dahal.isol": "\uFB84",
    "/dahiragana": "\u3060",
    "/dakatakana": "\u30C0",
    "/dal": "\u062F",
    "/dal.fina": "\uFEAA",
    "/dal.isol": "\uFEA9",
    "/dalInvertedSmallVBelow": "\u075A",
    "/dalTwoDotsVerticallyBelowSmallTah": "\u0759",
    "/dalarabic": "\u062F",
    "/daldotbelow": "\u068A",
    "/daldotbelowtahsmall": "\u068B",
    "/daldownthreedotsabove": "\u068F",
    "/dalet": "\u05D3",
    "/dalet:hb": "\u05D3",
    "/daletdagesh": "\uFB33",
    "/daletdageshhebrew": "\uFB33",
    "/dalethatafpatah": "\u05D3",
    "/dalethatafpatahhebrew": "\u05D3",
    "/dalethatafsegol": "\u05D3",
    "/dalethatafsegolhebrew": "\u05D3",
    "/dalethebrew": "\u05D3",
    "/dalethiriq": "\u05D3",
    "/dalethiriqhebrew": "\u05D3",
    "/daletholam": "\u05D3",
    "/daletholamhebrew": "\u05D3",
    "/daletpatah": "\u05D3",
    "/daletpatahhebrew": "\u05D3",
    "/daletqamats": "\u05D3",
    "/daletqamatshebrew": "\u05D3",
    "/daletqubuts": "\u05D3",
    "/daletqubutshebrew": "\u05D3",
    "/daletsegol": "\u05D3",
    "/daletsegolhebrew": "\u05D3",
    "/daletsheva": "\u05D3",
    "/daletshevahebrew": "\u05D3",
    "/dalettsere": "\u05D3",
    "/dalettserehebrew": "\u05D3",
    "/daletwide:hb": "\uFB22",
    "/daletwithdagesh:hb": "\uFB33",
    "/dalfinalarabic": "\uFEAA",
    "/dalfourdotsabove": "\u0690",
    "/dalinvertedV": "\u06EE",
    "/dalring": "\u0689",
    "/damahaprana": "\uA9A3",
    "/damma": "\u064F",
    "/dammaIsol": "\uFE78",
    "/dammaMedi": "\uFE79",
    "/dammaarabic": "\u064F",
    "/dammalowarabic": "\u064F",
    "/dammareversed": "\u065D",
    "/dammasmall": "\u0619",
    "/dammatan": "\u064C",
    "/dammatanIsol": "\uFE72",
    "/dammatanaltonearabic": "\u064C",
    "/dammatanarabic": "\u064C",
    "/dancer": "\u1F483",
    "/danda": "\u0964",
    "/dango": "\u1F361",
    "/darga:hb": "\u05A7",
    "/dargahebrew": "\u05A7",
    "/dargalefthebrew": "\u05A7",
    "/darkShade": "\u2593",
    "/darkSunglasses": "\u1F576",
    "/dashwithupturnleft": "\u2E43",
    "/dasiacmbcyr": "\u0485",
    "/dasiapneumatacyrilliccmb": "\u0485",
    "/dateseparator": "\u060D",
    "/dayeighteentelegraph": "\u33F1",
    "/dayeighttelegraph": "\u33E7",
    "/dayeleventelegraph": "\u33EA",
    "/dayfifteentelegraph": "\u33EE",
    "/dayfivetelegraph": "\u33E4",
    "/dayfourteentelegraph": "\u33ED",
    "/dayfourtelegraph": "\u33E3",
    "/daynineteentelegraph": "\u33F2",
    "/dayninetelegraph": "\u33E8",
    "/dayonetelegraph": "\u33E0",
    "/dayseventeentelegraph": "\u33F0",
    "/dayseventelegraph": "\u33E6",
    "/daysixteentelegraph": "\u33EF",
    "/daysixtelegraph": "\u33E5",
    "/daytentelegraph": "\u33E9",
    "/daythirteentelegraph": "\u33EC",
    "/daythirtyonetelegraph": "\u33FE",
    "/daythirtytelegraph": "\u33FD",
    "/daythreetelegraph": "\u33E2",
    "/daytwelvetelegraph": "\u33EB",
    "/daytwentyeighttelegraph": "\u33FB",
    "/daytwentyfivetelegraph": "\u33F8",
    "/daytwentyfourtelegraph": "\u33F7",
    "/daytwentyninetelegraph": "\u33FC",
    "/daytwentyonetelegraph": "\u33F4",
    "/daytwentyseventelegraph": "\u33FA",
    "/daytwentysixtelegraph": "\u33F9",
    "/daytwentytelegraph": "\u33F3",
    "/daytwentythreetelegraph": "\u33F6",
    "/daytwentytwotelegraph": "\u33F5",
    "/daytwotelegraph": "\u33E1",
    "/dbdigraph": "\u0238",
    "/dbfullwidth": "\u33C8",
    "/dblGrave": "\uF6D3",
    "/dblanglebracketleft": "\u300A",
    "/dblanglebracketleftvertical": "\uFE3D",
    "/dblanglebracketright": "\u300B",
    "/dblanglebracketrightvertical": "\uFE3E",
    "/dblarchinvertedbelowcmb": "\u032B",
    "/dblarrowNE": "\u21D7",
    "/dblarrowNW": "\u21D6",
    "/dblarrowSE": "\u21D8",
    "/dblarrowSW": "\u21D9",
    "/dblarrowdown": "\u21D3",
    "/dblarrowleft": "\u21D4",
    "/dblarrowleftright": "\u21D4",
    "/dblarrowleftrightstroke": "\u21CE",
    "/dblarrowleftstroke": "\u21CD",
    "/dblarrowright": "\u21D2",
    "/dblarrowrightstroke": "\u21CF",
    "/dblarrowup": "\u21D1",
    "/dblarrowupdown": "\u21D5",
    "/dbldanda": "\u0965",
    "/dbldnhorz": "\u2566",
    "/dbldnleft": "\u2557",
    "/dbldnright": "\u2554",
    "/dblgrave": "\uF6D6",
    "/dblgravecmb": "\u030F",
    "/dblhorz": "\u2550",
    "/dblintegral": "\u222C",
    "/dbllowline": "\u2017",
    "/dbllowlinecmb": "\u0333",
    "/dbloverlinecmb": "\u033F",
    "/dblprimemod": "\u02BA",
    "/dblstrokearrowdown": "\u21DF",
    "/dblstrokearrowup": "\u21DE",
    "/dbluphorz": "\u2569",
    "/dblupleft": "\u255D",
    "/dblupright": "\u255A",
    "/dblvert": "\u2551",
    "/dblverthorz": "\u256C",
    "/dblverticalbar": "\u2016",
    "/dblverticallineabovecmb": "\u030E",
    "/dblvertleft": "\u2563",
    "/dblvertright": "\u2560",
    "/dbopomofo": "\u3109",
    "/dbsquare": "\u33C8",
    "/dcaron": "\u010F",
    "/dcedilla": "\u1E11",
    "/dchecyr": "\u052D",
    "/dcircle": "\u24D3",
    "/dcircumflexbelow": "\u1E13",
    "/dcroat": "\u0111",
    "/dcurl": "\u0221",
    "/ddabengali": "\u09A1",
    "/ddadeva": "\u0921",
    "/ddagujarati": "\u0AA1",
    "/ddagurmukhi": "\u0A21",
    "/ddahal": "\u068D",
    "/ddahal.fina": "\uFB83",
    "/ddahal.isol": "\uFB82",
    "/ddal": "\u0688",
    "/ddal.fina": "\uFB89",
    "/ddal.isol": "\uFB88",
    "/ddalarabic": "\u0688",
    "/ddalfinalarabic": "\uFB89",
    "/ddamahaprana": "\uA99E",
    "/ddblstruckitalic": "\u2146",
    "/dddhadeva": "\u095C",
    "/ddhabengali": "\u09A2",
    "/ddhadeva": "\u0922",
    "/ddhagujarati": "\u0AA2",
    "/ddhagurmukhi": "\u0A22",
    "/ddot": "\u1E0B",
    "/ddotaccent": "\u1E0B",
    "/ddotbelow": "\u1E0D",
    "/decembertelegraph": "\u32CB",
    "/deciduousTree": "\u1F333",
    "/decimalexponent": "\u23E8",
    "/decimalseparatorarabic": "\u066B",
    "/decimalseparatorpersian": "\u066B",
    "/decreaseFontSize": "\u1F5DB",
    "/decyr": "\u0434",
    "/decyrillic": "\u0434",
    "/degree": "\u00B0",
    "/degreecelsius": "\u2103",
    "/degreefahrenheit": "\u2109",
    "/dehi:hb": "\u05AD",
    "/dehihebrew": "\u05AD",
    "/dehiragana": "\u3067",
    "/deicoptic": "\u03EF",
    "/dekatakana": "\u30C7",
    "/dekomicyr": "\u0501",
    "/deldiaeresisfunc": "\u2362",
    "/deleteleft": "\u232B",
    "/deleteright": "\u2326",
    "/deliveryTruck": "\u1F69A",
    "/delstilefunc": "\u2352",
    "/delta": "\u03B4",
    "/deltaequal": "\u225C",
    "/deltastilefunc": "\u234B",
    "/deltaturned": "\u018D",
    "/deltaunderlinefunc": "\u2359",
    "/deltildefunc": "\u236B",
    "/denominatorminusonenumeratorbengali": "\u09F8",
    "/dentistrybottomverticalleft": "\u23CC",
    "/dentistrybottomverticalright": "\u23BF",
    "/dentistrycircledownhorizontal": "\u23C1",
    "/dentistrycircleuphorizontal": "\u23C2",
    "/dentistrycirclevertical": "\u23C0",
    "/dentistrydownhorizontal": "\u23C9",
    "/dentistrytopverticalleft": "\u23CB",
    "/dentistrytopverticalright": "\u23BE",
    "/dentistrytriangledownhorizontal": "\u23C4",
    "/dentistrytriangleuphorizontal": "\u23C5",
    "/dentistrytrianglevertical": "\u23C3",
    "/dentistryuphorizontal": "\u23CA",
    "/dentistrywavedownhorizontal": "\u23C7",
    "/dentistrywaveuphorizontal": "\u23C8",
    "/dentistrywavevertical": "\u23C6",
    "/departmentStore": "\u1F3EC",
    "/derelictHouseBuilding": "\u1F3DA",
    "/desert": "\u1F3DC",
    "/desertIsland": "\u1F3DD",
    "/desisquare": "\u3325",
    "/desktopComputer": "\u1F5A5",
    "/desktopWindow": "\u1F5D4",
    "/deva:a": "\u0905",
    "/deva:aa": "\u0906",
    "/deva:aasign": "\u093E",
    "/deva:abbreviation": "\u0970",
    "/deva:acandra": "\u0972",
    "/deva:acute": "\u0954",
    "/deva:ai": "\u0910",
    "/deva:aisign": "\u0948",
    "/deva:anudatta": "\u0952",
    "/deva:anusvara": "\u0902",
    "/deva:ashort": "\u0904",
    "/deva:au": "\u0914",
    "/deva:ausign": "\u094C",
    "/deva:avagraha": "\u093D",
    "/deva:aw": "\u0975",
    "/deva:awsign": "\u094F",
    "/deva:ba": "\u092C",
    "/deva:bba": "\u097F",
    "/deva:bha": "\u092D",
    "/deva:ca": "\u091A",
    "/deva:candrabindu": "\u0901",
    "/deva:candrabinduinverted": "\u0900",
    "/deva:cha": "\u091B",
    "/deva:da": "\u0926",
    "/deva:danda": "\u0964",
    "/deva:dbldanda": "\u0965",
    "/deva:dda": "\u0921",
    "/deva:ddda": "\u097E",
    "/deva:dddha": "\u095C",
    "/deva:ddha": "\u0922",
    "/deva:dha": "\u0927",
    "/deva:dothigh": "\u0971",
    "/deva:e": "\u090F",
    "/deva:ecandra": "\u090D",
    "/deva:eight": "\u096E",
    "/deva:eshort": "\u090E",
    "/deva:esign": "\u0947",
    "/deva:esigncandra": "\u0945",
    "/deva:esignprishthamatra": "\u094E",
    "/deva:esignshort": "\u0946",
    "/deva:fa": "\u095E",
    "/deva:five": "\u096B",
    "/deva:four": "\u096A",
    "/deva:ga": "\u0917",
    "/deva:gga": "\u097B",
    "/deva:gha": "\u0918",
    "/deva:ghha": "\u095A",
    "/deva:glottalstop": "\u097D",
    "/deva:grave": "\u0953",
    "/deva:ha": "\u0939",
    "/deva:i": "\u0907",
    "/deva:ii": "\u0908",
    "/deva:iisign": "\u0940",
    "/deva:isign": "\u093F",
    "/deva:ja": "\u091C",
    "/deva:jha": "\u091D",
    "/deva:jja": "\u097C",
    "/deva:ka": "\u0915",
    "/deva:kha": "\u0916",
    "/deva:khha": "\u0959",
    "/deva:la": "\u0932",
    "/deva:lla": "\u0933",
    "/deva:llla": "\u0934",
    "/deva:llvocal": "\u0961",
    "/deva:llvocalsign": "\u0963",
    "/deva:lvocal": "\u090C",
    "/deva:lvocalsign": "\u0962",
    "/deva:ma": "\u092E",
    "/deva:marwaridda": "\u0978",
    "/deva:na": "\u0928",
    "/deva:nga": "\u0919",
    "/deva:nine": "\u096F",
    "/deva:nna": "\u0923",
    "/deva:nnna": "\u0929",
    "/deva:nukta": "\u093C",
    "/deva:nya": "\u091E",
    "/deva:o": "\u0913",
    "/deva:ocandra": "\u0911",
    "/deva:oe": "\u0973",
    "/deva:oesign": "\u093A",
    "/deva:om": "\u0950",
    "/deva:one": "\u0967",
    "/deva:ooe": "\u0974",
    "/deva:ooesign": "\u093B",
    "/deva:oshort": "\u0912",
    "/deva:osign": "\u094B",
    "/deva:osigncandra": "\u0949",
    "/deva:osignshort": "\u094A",
    "/deva:pa": "\u092A",
    "/deva:pha": "\u092B",
    "/deva:qa": "\u0958",
    "/deva:ra": "\u0930",
    "/deva:rha": "\u095D",
    "/deva:rra": "\u0931",
    "/deva:rrvocal": "\u0960",
    "/deva:rrvocalsign": "\u0944",
    "/deva:rvocal": "\u090B",
    "/deva:rvocalsign": "\u0943",
    "/deva:sa": "\u0938",
    "/deva:seven": "\u096D",
    "/deva:sha": "\u0936",
    "/deva:signelongcandra": "\u0955",
    "/deva:six": "\u096C",
    "/deva:ssa": "\u0937",
    "/deva:ta": "\u0924",
    "/deva:tha": "\u0925",
    "/deva:three": "\u0969",
    "/deva:tta": "\u091F",
    "/deva:ttha": "\u0920",
    "/deva:two": "\u0968",
    "/deva:u": "\u0909",
    "/deva:udatta": "\u0951",
    "/deva:ue": "\u0976",
    "/deva:uesign": "\u0956",
    "/deva:usign": "\u0941",
    "/deva:uu": "\u090A",
    "/deva:uue": "\u0977",
    "/deva:uuesign": "\u0957",
    "/deva:uusign": "\u0942",
    "/deva:va": "\u0935",
    "/deva:virama": "\u094D",
    "/deva:visarga": "\u0903",
    "/deva:ya": "\u092F",
    "/deva:yaheavy": "\u097A",
    "/deva:yya": "\u095F",
    "/deva:za": "\u095B",
    "/deva:zero": "\u0966",
    "/deva:zha": "\u0979",
    "/dezh": "\u02A4",
    "/dfemaledbl": "\u26A2",
    "/dhabengali": "\u09A7",
    "/dhadeva": "\u0927",
    "/dhagujarati": "\u0AA7",
    "/dhagurmukhi": "\u0A27",
    "/dhook": "\u0257",
    "/diaeresisgreaterfunc": "\u2369",
    "/dialytikatonos": "\u0385",
    "/dialytikatonoscmb": "\u0344",
    "/diametersign": "\u2300",
    "/diamond": "\u2666",
    "/diamondShapeADotInside": "\u1F4A0",
    "/diamondinsquarewhite": "\u26CB",
    "/diamondoperator": "\u22C4",
    "/diamondsuitwhite": "\u2662",
    "/diamondunderlinefunc": "\u235A",
    "/diamondwhitewithdiamondsmallblack": "\u25C8",
    "/diefive": "\u2684",
    "/diefour": "\u2683",
    "/dieone": "\u2680",
    "/dieresis": "\u00A8",
    "/dieresisacute": "\uF6D7",
    "/dieresisbelowcmb": "\u0324",
    "/dieresiscmb": "\u0308",
    "/dieresisgrave": "\uF6D8",
    "/dieresistilde": "\u1FC1",
    "/dieresistonos": "\u0385",
    "/dieselLocomotive": "\u1F6F2",
    "/diesix": "\u2685",
    "/diethree": "\u2682",
    "/dietwo": "\u2681",
    "/differencebetween": "\u224F",
    "/digamma": "\u03DD",
    "/digammapamphylian": "\u0377",
    "/digramgreateryang": "\u268C",
    "/digramgreateryin": "\u268F",
    "/digramlesseryang": "\u268E",
    "/digramlesseryin": "\u268D",
    "/dihiragana": "\u3062",
    "/dikatakana": "\u30C2",
    "/dimensionorigin": "\u2331",
    "/dingbatSAns-serifzerocircle": "\u1F10B",
    "/dingbatSAns-serifzerocircleblack": "\u1F10C",
    "/dinsular": "\uA77A",
    "/directHit": "\u1F3AF",
    "/directcurrentformtwo": "\u2393",
    "/dirgamurevowel": "\uA9BB",
    "/disabledcar": "\u26CD",
    "/disappointedButRelievedFace": "\u1F625",
    "/disappointedFace": "\u1F61E",
    "/discontinuousunderline": "\u2382",
    "/dittomark": "\u3003",
    "/divide": "\u00F7",
    "/divides": "\u2223",
    "/divisionslash": "\u2215",
    "/divisiontimes": "\u22C7",
    "/divorce": "\u26AE",
    "/dizzy": "\u1F4AB",
    "/dizzyFace": "\u1F635",
    "/djecyr": "\u0452",
    "/djecyrillic": "\u0452",
    "/djekomicyr": "\u0503",
    "/dkshade": "\u2593",
    "/dlfullwidth": "\u3397",
    "/dlinebelow": "\u1E0F",
    "/dlogicalorsquare": "\u27CF",
    "/dlogicalsquare": "\u27CE",
    "/dlsquare": "\u3397",
    "/dm2fullwidth": "\u3378",
    "/dm3fullwidth": "\u3379",
    "/dmacron": "\u0111",
    "/dmaledbl": "\u26A3",
    "/dmfullwidth": "\u3377",
    "/dmonospace": "\uFF44",
    "/dnblock": "\u2584",
    "/dndblhorzsng": "\u2565",
    "/dndblleftsng": "\u2556",
    "/dndblrightsng": "\u2553",
    "/dngb:airplane": "\u2708",
    "/dngb:arrowfeatheredblackNE": "\u27B6",
    "/dngb:arrowfeatheredblackSE": "\u27B4",
    "/dngb:arrowfeatheredblackheavyNE": "\u27B9",
    "/dngb:arrowfeatheredblackheavySE": "\u27B7",
    "/dngb:arrowheadrightblack": "\u27A4",
    "/dngb:arrowheadrightthreeDbottomlight": "\u27A3",
    "/dngb:arrowheadrightthreeDtoplight": "\u27A2",
    "/dngb:arrowheavyNE": "\u279A",
    "/dngb:arrowheavySE": "\u2798",
    "/dngb:arrowrightbacktiltedshadowedwhite": "\u27AB",
    "/dngb:arrowrightblack": "\u27A1",
    "/dngb:arrowrightcircledwhiteheavy": "\u27B2",
    "/dngb:arrowrightcurvedownblackheavy": "\u27A5",
    "/dngb:arrowrightcurveupblackheavy": "\u27A6",
    "/dngb:arrowrightfeatheredblack": "\u27B5",
    "/dngb:arrowrightfeatheredblackheavy": "\u27B8",
    "/dngb:arrowrightfeatheredwhite": "\u27B3",
    "/dngb:arrowrightfronttiltedshadowedwhite": "\u27AC",
    "/dngb:arrowrightheavy": "\u2799",
    "/dngb:arrowrightleftshadedwhite": "\u27AA",
    "/dngb:arrowrightoutlinedopen": "\u27BE",
    "/dngb:arrowrightpointed": "\u279B",
    "/dngb:arrowrightpointedblackheavy": "\u27A8",
    "/dngb:arrowrightrightshadedwhite": "\u27A9",
    "/dngb:arrowrightroundheavy": "\u279C",
    "/dngb:arrowrightsquatblack": "\u27A7",
    "/dngb:arrowrighttriangle": "\u279D",
    "/dngb:arrowrighttriangledashed": "\u279F",
    "/dngb:arrowrighttriangledashedheavy": "\u27A0",
    "/dngb:arrowrighttriangleheavy": "\u279E",
    "/dngb:arrowrightwedge": "\u27BC",
    "/dngb:arrowrightwedgeheavy": "\u27BD",
    "/dngb:arrowrightwideheavy": "\u2794",
    "/dngb:arrowshadowrightlowerwhiteheavy": "\u27AD",
    "/dngb:arrowshadowrightnotchedlowerwhite": "\u27AF",
    "/dngb:arrowshadowrightnotchedupperwhite": "\u27B1",
    "/dngb:arrowshadowrightupperwhiteheavy": "\u27AE",
    "/dngb:arrowteardropright": "\u27BA",
    "/dngb:arrowteardroprightheavy": "\u27BB",
    "/dngb:asteriskballoon": "\u2749",
    "/dngb:asteriskballoonfour": "\u2723",
    "/dngb:asteriskballoonheavyfour": "\u2724",
    "/dngb:asteriskcentreopen": "\u2732",
    "/dngb:asteriskclubfour": "\u2725",
    "/dngb:asteriskheavy": "\u2731",
    "/dngb:asteriskpointedsixteen": "\u273A",
    "/dngb:asteriskteardrop": "\u273B",
    "/dngb:asteriskteardropcentreopen": "\u273C",
    "/dngb:asteriskteardropfour": "\u2722",
    "/dngb:asteriskteardropheavy": "\u273D",
    "/dngb:asteriskteardroppinwheelheavy": "\u2743",
    "/dngb:asteriskteardroppropellereight": "\u274A",
    "/dngb:asteriskteardroppropellerheavyeight": "\u274B",
    "/dngb:ballotx": "\u2717",
    "/dngb:ballotxheavy": "\u2718",
    "/dngb:bracketleftpointedangleheavyornament": "\u2770",
    "/dngb:bracketleftpointedanglemediumornament": "\u276C",
    "/dngb:bracketrightpointedangleheavyornament": "\u2771",
    "/dngb:bracketrightpointedanglemediumornament": "\u276D",
    "/dngb:bracketshellleftlightornament": "\u2772",
    "/dngb:bracketshellrightlightornament": "\u2773",
    "/dngb:check": "\u2713",
    "/dngb:checkheavy": "\u2714",
    "/dngb:checkwhiteheavy": "\u2705",
    "/dngb:chevronsnowflakeheavy": "\u2746",
    "/dngb:circleshadowedwhite": "\u274D",
    "/dngb:commaheavydoubleornament": "\u275E",
    "/dngb:commaheavydoubleturnedornament": "\u275D",
    "/dngb:commaheavyornament": "\u275C",
    "/dngb:commaheavyturnedornament": "\u275B",
    "/dngb:compasstarpointedblackeight": "\u2737",
    "/dngb:compasstarpointedblackheavyeight": "\u2738",
    "/dngb:cross": "\u274C",
    "/dngb:crosscentreopen": "\u271B",
    "/dngb:crosscentreopenheavy": "\u271C",
    "/dngb:curlybracketleftmediumornament": "\u2774",
    "/dngb:curlybracketrightmediumornament": "\u2775",
    "/dngb:curlyloop": "\u27B0",
    "/dngb:curlyloopdouble": "\u27BF",
    "/dngb:curvedstemparagraphsignornament": "\u2761",
    "/dngb:diamondminusxblackwhite": "\u2756",
    "/dngb:divisionsignheavy": "\u2797",
    "/dngb:eightnegativecircled": "\u277D",
    "/dngb:eightsanscircled": "\u2787",
    "/dngb:eightsansnegativecircled": "\u2791",
    "/dngb:envelope": "\u2709",
    "/dngb:exclamationheavy": "\u2757",
    "/dngb:exclamationheavyornament": "\u2762",
    "/dngb:exclamationwhiteornament": "\u2755",
    "/dngb:fivenegativecircled": "\u277A",
    "/dngb:fivesanscircled": "\u2784",
    "/dngb:fivesansnegativecircled": "\u278E",
    "/dngb:floralheart": "\u2766",
    "/dngb:floralheartbulletrotated": "\u2767",
    "/dngb:floretteblack": "\u273F",
    "/dngb:floretteoutlinedpetalledblackeight": "\u2741",
    "/dngb:florettepetalledblackwhitesix": "\u273E",
    "/dngb:florettewhite": "\u2740",
    "/dngb:fournegativecircled": "\u2779",
    "/dngb:foursanscircled": "\u2783",
    "/dngb:foursansnegativecircled": "\u278D",
    "/dngb:greekcrossheavy": "\u271A",
    "/dngb:greekcrossoutlined": "\u2719",
    "/dngb:heartblackheavy": "\u2764",
    "/dngb:heartbulletrotatedblackheavy": "\u2765",
    "/dngb:heartexclamationheavyornament": "\u2763",
    "/dngb:hvictory": "\u270C",
    "/dngb:hwriting": "\u270D",
    "/dngb:latincross": "\u271D",
    "/dngb:latincrossoutlined": "\u271F",
    "/dngb:latincrossshadowedwhite": "\u271E",
    "/dngb:lowcommaheavydoubleornament": "\u2760",
    "/dngb:lowcommaheavyornament": "\u275F",
    "/dngb:maltesecross": "\u2720",
    "/dngb:minussignheavy": "\u2796",
    "/dngb:multiplicationx": "\u2715",
    "/dngb:multiplicationxheavy": "\u2716",
    "/dngb:nibblack": "\u2712",
    "/dngb:nibwhite": "\u2711",
    "/dngb:ninenegativecircled": "\u277E",
    "/dngb:ninesanscircled": "\u2788",
    "/dngb:ninesansnegativecircled": "\u2792",
    "/dngb:onenegativecircled": "\u2776",
    "/dngb:onesanscircled": "\u2780",
    "/dngb:onesansnegativecircled": "\u278A",
    "/dngb:parenthesisleftflattenedmediumornament": "\u276A",
    "/dngb:parenthesisleftmediumornament": "\u2768",
    "/dngb:parenthesisrightflattenedmediumornament": "\u276B",
    "/dngb:parenthesisrightmediumornament": "\u2769",
    "/dngb:pencil": "\u270F",
    "/dngb:pencillowerright": "\u270E",
    "/dngb:pencilupperright": "\u2710",
    "/dngb:plussignheavy": "\u2795",
    "/dngb:questionblackornament": "\u2753",
    "/dngb:questionwhiteornament": "\u2754",
    "/dngb:quotationleftpointedangleheavyornament": "\u276E",
    "/dngb:quotationrightpointedangleheavyornament": "\u276F",
    "/dngb:raisedfist": "\u270A",
    "/dngb:raisedh": "\u270B",
    "/dngb:safetyscissorsblack": "\u2700",
    "/dngb:scissorsblack": "\u2702",
    "/dngb:scissorslowerblade": "\u2703",
    "/dngb:scissorsupperblade": "\u2701",
    "/dngb:scissorswhite": "\u2704",
    "/dngb:sevennegativecircled": "\u277C",
    "/dngb:sevensanscircled": "\u2786",
    "/dngb:sevensansnegativecircled": "\u2790",
    "/dngb:sixnegativecircled": "\u277B",
    "/dngb:sixsanscircled": "\u2785",
    "/dngb:sixsansnegativecircled": "\u278F",
    "/dngb:snowflake": "\u2744",
    "/dngb:snowflaketight": "\u2745",
    "/dngb:sparkle": "\u2747",
    "/dngb:sparkleheavy": "\u2748",
    "/dngb:sparkles": "\u2728",
    "/dngb:spokedasteriskeight": "\u2733",
    "/dngb:squaredcrossnegative": "\u274E",
    "/dngb:squarelowerrightshadowedwhite": "\u2751",
    "/dngb:squareshadowlowerrightwhite": "\u274F",
    "/dngb:squareshadowupperrightwhite": "\u2750",
    "/dngb:squareupperrightshadowedwhite": "\u2752",
    "/dngb:starcentreblackwhite": "\u272C",
    "/dngb:starcentreopenblack": "\u272B",
    "/dngb:starcentreopenpointedcircledeight": "\u2742",
    "/dngb:starcircledwhite": "\u272A",
    "/dngb:starofdavid": "\u2721",
    "/dngb:staroutlinedblack": "\u272D",
    "/dngb:staroutlinedblackheavy": "\u272E",
    "/dngb:staroutlinedstresswhite": "\u2729",
    "/dngb:starpinwheel": "\u272F",
    "/dngb:starpointedblackeight": "\u2734",
    "/dngb:starpointedblackfour": "\u2726",
    "/dngb:starpointedblacksix": "\u2736",
    "/dngb:starpointedblacktwelve": "\u2739",
    "/dngb:starpointedpinwheeleight": "\u2735",
    "/dngb:starpointedwhitefour": "\u2727",
    "/dngb:starshadowedwhite": "\u2730",
    "/dngb:tapedrive": "\u2707",
    "/dngb:telephonelocationsign": "\u2706",
    "/dngb:tennegativecircled": "\u277F",
    "/dngb:tensanscircled": "\u2789",
    "/dngb:tensansnegativecircled": "\u2793",
    "/dngb:threenegativecircled": "\u2778",
    "/dngb:threesanscircled": "\u2782",
    "/dngb:threesansnegativecircled": "\u278C",
    "/dngb:twonegativecircled": "\u2777",
    "/dngb:twosanscircled": "\u2781",
    "/dngb:twosansnegativecircled": "\u278B",
    "/dngb:verticalbarheavy": "\u275A",
    "/dngb:verticalbarlight": "\u2758",
    "/dngb:verticalbarmedium": "\u2759",
    "/dnheavyhorzlight": "\u2530",
    "/dnheavyleftlight": "\u2512",
    "/dnheavyleftuplight": "\u2527",
    "/dnheavyrightlight": "\u250E",
    "/dnheavyrightuplight": "\u251F",
    "/dnheavyuphorzlight": "\u2541",
    "/dnlighthorzheavy": "\u252F",
    "/dnlightleftheavy": "\u2511",
    "/dnlightleftupheavy": "\u2529",
    "/dnlightrightheavy": "\u250D",
    "/dnlightrightupheavy": "\u2521",
    "/dnlightuphorzheavy": "\u2547",
    "/dnsnghorzdbl": "\u2564",
    "/dnsngleftdbl": "\u2555",
    "/dnsngrightdbl": "\u2552",
    "/doNotLitter": "\u1F6AF",
    "/dochadathai": "\u0E0E",
    "/document": "\u1F5CE",
    "/documentPicture": "\u1F5BB",
    "/documentText": "\u1F5B9",
    "/documentTextAndPicture": "\u1F5BA",
    "/dodekthai": "\u0E14",
    "/doesnotcontainasnormalsubgroorequalup": "\u22ED",
    "/doesnotcontainasnormalsubgroup": "\u22EB",
    "/doesnotdivide": "\u2224",
    "/doesnotforce": "\u22AE",
    "/doesnotprecede": "\u2280",
    "/doesnotprecedeorequal": "\u22E0",
    "/doesnotprove": "\u22AC",
    "/doesnotsucceed": "\u2281",
    "/doesnotsucceedorequal": "\u22E1",
    "/dog": "\u1F415",
    "/dogFace": "\u1F436",
    "/dohiragana": "\u3069",
    "/dokatakana": "\u30C9",
    "/dollar": "\u0024",
    "/dollarinferior": "\uF6E3",
    "/dollarmonospace": "\uFF04",
    "/dollaroldstyle": "\uF724",
    "/dollarsmall": "\uFE69",
    "/dollarsuperior": "\uF6E4",
    "/dolphin": "\u1F42C",
    "/dominohorizontal_00_00": "\u1F031",
    "/dominohorizontal_00_01": "\u1F032",
    "/dominohorizontal_00_02": "\u1F033",
    "/dominohorizontal_00_03": "\u1F034",
    "/dominohorizontal_00_04": "\u1F035",
    "/dominohorizontal_00_05": "\u1F036",
    "/dominohorizontal_00_06": "\u1F037",
    "/dominohorizontal_01_00": "\u1F038",
    "/dominohorizontal_01_01": "\u1F039",
    "/dominohorizontal_01_02": "\u1F03A",
    "/dominohorizontal_01_03": "\u1F03B",
    "/dominohorizontal_01_04": "\u1F03C",
    "/dominohorizontal_01_05": "\u1F03D",
    "/dominohorizontal_01_06": "\u1F03E",
    "/dominohorizontal_02_00": "\u1F03F",
    "/dominohorizontal_02_01": "\u1F040",
    "/dominohorizontal_02_02": "\u1F041",
    "/dominohorizontal_02_03": "\u1F042",
    "/dominohorizontal_02_04": "\u1F043",
    "/dominohorizontal_02_05": "\u1F044",
    "/dominohorizontal_02_06": "\u1F045",
    "/dominohorizontal_03_00": "\u1F046",
    "/dominohorizontal_03_01": "\u1F047",
    "/dominohorizontal_03_02": "\u1F048",
    "/dominohorizontal_03_03": "\u1F049",
    "/dominohorizontal_03_04": "\u1F04A",
    "/dominohorizontal_03_05": "\u1F04B",
    "/dominohorizontal_03_06": "\u1F04C",
    "/dominohorizontal_04_00": "\u1F04D",
    "/dominohorizontal_04_01": "\u1F04E",
    "/dominohorizontal_04_02": "\u1F04F",
    "/dominohorizontal_04_03": "\u1F050",
    "/dominohorizontal_04_04": "\u1F051",
    "/dominohorizontal_04_05": "\u1F052",
    "/dominohorizontal_04_06": "\u1F053",
    "/dominohorizontal_05_00": "\u1F054",
    "/dominohorizontal_05_01": "\u1F055",
    "/dominohorizontal_05_02": "\u1F056",
    "/dominohorizontal_05_03": "\u1F057",
    "/dominohorizontal_05_04": "\u1F058",
    "/dominohorizontal_05_05": "\u1F059",
    "/dominohorizontal_05_06": "\u1F05A",
    "/dominohorizontal_06_00": "\u1F05B",
    "/dominohorizontal_06_01": "\u1F05C",
    "/dominohorizontal_06_02": "\u1F05D",
    "/dominohorizontal_06_03": "\u1F05E",
    "/dominohorizontal_06_04": "\u1F05F",
    "/dominohorizontal_06_05": "\u1F060",
    "/dominohorizontal_06_06": "\u1F061",
    "/dominohorizontalback": "\u1F030",
    "/dominovertical_00_00": "\u1F063",
    "/dominovertical_00_01": "\u1F064",
    "/dominovertical_00_02": "\u1F065",
    "/dominovertical_00_03": "\u1F066",
    "/dominovertical_00_04": "\u1F067",
    "/dominovertical_00_05": "\u1F068",
    "/dominovertical_00_06": "\u1F069",
    "/dominovertical_01_00": "\u1F06A",
    "/dominovertical_01_01": "\u1F06B",
    "/dominovertical_01_02": "\u1F06C",
    "/dominovertical_01_03": "\u1F06D",
    "/dominovertical_01_04": "\u1F06E",
    "/dominovertical_01_05": "\u1F06F",
    "/dominovertical_01_06": "\u1F070",
    "/dominovertical_02_00": "\u1F071",
    "/dominovertical_02_01": "\u1F072",
    "/dominovertical_02_02": "\u1F073",
    "/dominovertical_02_03": "\u1F074",
    "/dominovertical_02_04": "\u1F075",
    "/dominovertical_02_05": "\u1F076",
    "/dominovertical_02_06": "\u1F077",
    "/dominovertical_03_00": "\u1F078",
    "/dominovertical_03_01": "\u1F079",
    "/dominovertical_03_02": "\u1F07A",
    "/dominovertical_03_03": "\u1F07B",
    "/dominovertical_03_04": "\u1F07C",
    "/dominovertical_03_05": "\u1F07D",
    "/dominovertical_03_06": "\u1F07E",
    "/dominovertical_04_00": "\u1F07F",
    "/dominovertical_04_01": "\u1F080",
    "/dominovertical_04_02": "\u1F081",
    "/dominovertical_04_03": "\u1F082",
    "/dominovertical_04_04": "\u1F083",
    "/dominovertical_04_05": "\u1F084",
    "/dominovertical_04_06": "\u1F085",
    "/dominovertical_05_00": "\u1F086",
    "/dominovertical_05_01": "\u1F087",
    "/dominovertical_05_02": "\u1F088",
    "/dominovertical_05_03": "\u1F089",
    "/dominovertical_05_04": "\u1F08A",
    "/dominovertical_05_05": "\u1F08B",
    "/dominovertical_05_06": "\u1F08C",
    "/dominovertical_06_00": "\u1F08D",
    "/dominovertical_06_01": "\u1F08E",
    "/dominovertical_06_02": "\u1F08F",
    "/dominovertical_06_03": "\u1F090",
    "/dominovertical_06_04": "\u1F091",
    "/dominovertical_06_05": "\u1F092",
    "/dominovertical_06_06": "\u1F093",
    "/dominoverticalback": "\u1F062",
    "/dong": "\u20AB",
    "/door": "\u1F6AA",
    "/dorusquare": "\u3326",
    "/dot": "\u27D1",
    "/dotaccent": "\u02D9",
    "/dotaccentcmb": "\u0307",
    "/dotbelowcmb": "\u0323",
    "/dotbelowcomb": "\u0323",
    "/dotkatakana": "\u30FB",
    "/dotlessbeh": "\u066E",
    "/dotlessfeh": "\u06A1",
    "/dotlessi": "\u0131",
    "/dotlessj": "\uF6BE",
    "/dotlessjstroke": "\u025F",
    "/dotlessjstrokehook": "\u0284",
    "/dotlesskhahabove": "\u06E1",
    "/dotlessqaf": "\u066F",
    "/dotlower:hb": "\u05C5",
    "/dotmath": "\u22C5",
    "/dotminus": "\u2238",
    "/dotplus": "\u2214",
    "/dotraised": "\u2E33",
    "/dots1": "\u2801",
    "/dots12": "\u2803",
    "/dots123": "\u2807",
    "/dots1234": "\u280F",
    "/dots12345": "\u281F",
    "/dots123456": "\u283F",
    "/dots1234567": "\u287F",
    "/dots12345678": "\u28FF",
    "/dots1234568": "\u28BF",
    "/dots123457": "\u285F",
    "/dots1234578": "\u28DF",
    "/dots123458": "\u289F",
    "/dots12346": "\u282F",
    "/dots123467": "\u286F",
    "/dots1234678": "\u28EF",
    "/dots123468": "\u28AF",
    "/dots12347": "\u284F",
    "/dots123478": "\u28CF",
    "/dots12348": "\u288F",
    "/dots1235": "\u2817",
    "/dots12356": "\u2837",
    "/dots123567": "\u2877",
    "/dots1235678": "\u28F7",
    "/dots123568": "\u28B7",
    "/dots12357": "\u2857",
    "/dots123578": "\u28D7",
    "/dots12358": "\u2897",
    "/dots1236": "\u2827",
    "/dots12367": "\u2867",
    "/dots123678": "\u28E7",
    "/dots12368": "\u28A7",
    "/dots1237": "\u2847",
    "/dots12378": "\u28C7",
    "/dots1238": "\u2887",
    "/dots124": "\u280B",
    "/dots1245": "\u281B",
    "/dots12456": "\u283B",
    "/dots124567": "\u287B",
    "/dots1245678": "\u28FB",
    "/dots124568": "\u28BB",
    "/dots12457": "\u285B",
    "/dots124578": "\u28DB",
    "/dots12458": "\u289B",
    "/dots1246": "\u282B",
    "/dots12467": "\u286B",
    "/dots124678": "\u28EB",
    "/dots12468": "\u28AB",
    "/dots1247": "\u284B",
    "/dots12478": "\u28CB",
    "/dots1248": "\u288B",
    "/dots125": "\u2813",
    "/dots1256": "\u2833",
    "/dots12567": "\u2873",
    "/dots125678": "\u28F3",
    "/dots12568": "\u28B3",
    "/dots1257": "\u2853",
    "/dots12578": "\u28D3",
    "/dots1258": "\u2893",
    "/dots126": "\u2823",
    "/dots1267": "\u2863",
    "/dots12678": "\u28E3",
    "/dots1268": "\u28A3",
    "/dots127": "\u2843",
    "/dots1278": "\u28C3",
    "/dots128": "\u2883",
    "/dots13": "\u2805",
    "/dots134": "\u280D",
    "/dots1345": "\u281D",
    "/dots13456": "\u283D",
    "/dots134567": "\u287D",
    "/dots1345678": "\u28FD",
    "/dots134568": "\u28BD",
    "/dots13457": "\u285D",
    "/dots134578": "\u28DD",
    "/dots13458": "\u289D",
    "/dots1346": "\u282D",
    "/dots13467": "\u286D",
    "/dots134678": "\u28ED",
    "/dots13468": "\u28AD",
    "/dots1347": "\u284D",
    "/dots13478": "\u28CD",
    "/dots1348": "\u288D",
    "/dots135": "\u2815",
    "/dots1356": "\u2835",
    "/dots13567": "\u2875",
    "/dots135678": "\u28F5",
    "/dots13568": "\u28B5",
    "/dots1357": "\u2855",
    "/dots13578": "\u28D5",
    "/dots1358": "\u2895",
    "/dots136": "\u2825",
    "/dots1367": "\u2865",
    "/dots13678": "\u28E5",
    "/dots1368": "\u28A5",
    "/dots137": "\u2845",
    "/dots1378": "\u28C5",
    "/dots138": "\u2885",
    "/dots14": "\u2809",
    "/dots145": "\u2819",
    "/dots1456": "\u2839",
    "/dots14567": "\u2879",
    "/dots145678": "\u28F9",
    "/dots14568": "\u28B9",
    "/dots1457": "\u2859",
    "/dots14578": "\u28D9",
    "/dots1458": "\u2899",
    "/dots146": "\u2829",
    "/dots1467": "\u2869",
    "/dots14678": "\u28E9",
    "/dots1468": "\u28A9",
    "/dots147": "\u2849",
    "/dots1478": "\u28C9",
    "/dots148": "\u2889",
    "/dots15": "\u2811",
    "/dots156": "\u2831",
    "/dots1567": "\u2871",
    "/dots15678": "\u28F1",
    "/dots1568": "\u28B1",
    "/dots157": "\u2851",
    "/dots1578": "\u28D1",
    "/dots158": "\u2891",
    "/dots16": "\u2821",
    "/dots167": "\u2861",
    "/dots1678": "\u28E1",
    "/dots168": "\u28A1",
    "/dots17": "\u2841",
    "/dots178": "\u28C1",
    "/dots18": "\u2881",
    "/dots2": "\u2802",
    "/dots23": "\u2806",
    "/dots234": "\u280E",
    "/dots2345": "\u281E",
    "/dots23456": "\u283E",
    "/dots234567": "\u287E",
    "/dots2345678": "\u28FE",
    "/dots234568": "\u28BE",
    "/dots23457": "\u285E",
    "/dots234578": "\u28DE",
    "/dots23458": "\u289E",
    "/dots2346": "\u282E",
    "/dots23467": "\u286E",
    "/dots234678": "\u28EE",
    "/dots23468": "\u28AE",
    "/dots2347": "\u284E",
    "/dots23478": "\u28CE",
    "/dots2348": "\u288E",
    "/dots235": "\u2816",
    "/dots2356": "\u2836",
    "/dots23567": "\u2876",
    "/dots235678": "\u28F6",
    "/dots23568": "\u28B6",
    "/dots2357": "\u2856",
    "/dots23578": "\u28D6",
    "/dots2358": "\u2896",
    "/dots236": "\u2826",
    "/dots2367": "\u2866",
    "/dots23678": "\u28E6",
    "/dots2368": "\u28A6",
    "/dots237": "\u2846",
    "/dots2378": "\u28C6",
    "/dots238": "\u2886",
    "/dots24": "\u280A",
    "/dots245": "\u281A",
    "/dots2456": "\u283A",
    "/dots24567": "\u287A",
    "/dots245678": "\u28FA",
    "/dots24568": "\u28BA",
    "/dots2457": "\u285A",
    "/dots24578": "\u28DA",
    "/dots2458": "\u289A",
    "/dots246": "\u282A",
    "/dots2467": "\u286A",
    "/dots24678": "\u28EA",
    "/dots2468": "\u28AA",
    "/dots247": "\u284A",
    "/dots2478": "\u28CA",
    "/dots248": "\u288A",
    "/dots25": "\u2812",
    "/dots256": "\u2832",
    "/dots2567": "\u2872",
    "/dots25678": "\u28F2",
    "/dots2568": "\u28B2",
    "/dots257": "\u2852",
    "/dots2578": "\u28D2",
    "/dots258": "\u2892",
    "/dots26": "\u2822",
    "/dots267": "\u2862",
    "/dots2678": "\u28E2",
    "/dots268": "\u28A2",
    "/dots27": "\u2842",
    "/dots278": "\u28C2",
    "/dots28": "\u2882",
    "/dots3": "\u2804",
    "/dots34": "\u280C",
    "/dots345": "\u281C",
    "/dots3456": "\u283C",
    "/dots34567": "\u287C",
    "/dots345678": "\u28FC",
    "/dots34568": "\u28BC",
    "/dots3457": "\u285C",
    "/dots34578": "\u28DC",
    "/dots3458": "\u289C",
    "/dots346": "\u282C",
    "/dots3467": "\u286C",
    "/dots34678": "\u28EC",
    "/dots3468": "\u28AC",
    "/dots347": "\u284C",
    "/dots3478": "\u28CC",
    "/dots348": "\u288C",
    "/dots35": "\u2814",
    "/dots356": "\u2834",
    "/dots3567": "\u2874",
    "/dots35678": "\u28F4",
    "/dots3568": "\u28B4",
    "/dots357": "\u2854",
    "/dots3578": "\u28D4",
    "/dots358": "\u2894",
    "/dots36": "\u2824",
    "/dots367": "\u2864",
    "/dots3678": "\u28E4",
    "/dots368": "\u28A4",
    "/dots37": "\u2844",
    "/dots378": "\u28C4",
    "/dots38": "\u2884",
    "/dots4": "\u2808",
    "/dots45": "\u2818",
    "/dots456": "\u2838",
    "/dots4567": "\u2878",
    "/dots45678": "\u28F8",
    "/dots4568": "\u28B8",
    "/dots457": "\u2858",
    "/dots4578": "\u28D8",
    "/dots458": "\u2898",
    "/dots46": "\u2828",
    "/dots467": "\u2868",
    "/dots4678": "\u28E8",
    "/dots468": "\u28A8",
    "/dots47": "\u2848",
    "/dots478": "\u28C8",
    "/dots48": "\u2888",
    "/dots5": "\u2810",
    "/dots56": "\u2830",
    "/dots567": "\u2870",
    "/dots5678": "\u28F0",
    "/dots568": "\u28B0",
    "/dots57": "\u2850",
    "/dots578": "\u28D0",
    "/dots58": "\u2890",
    "/dots6": "\u2820",
    "/dots67": "\u2860",
    "/dots678": "\u28E0",
    "/dots68": "\u28A0",
    "/dots7": "\u2840",
    "/dots78": "\u28C0",
    "/dots8": "\u2880",
    "/dotsquarefour": "\u2E2C",
    "/dottedcircle": "\u25CC",
    "/dottedcross": "\u205C",
    "/dotupper:hb": "\u05C4",
    "/doublebarvertical": "\u23F8",
    "/doubleyodpatah": "\uFB1F",
    "/doubleyodpatahhebrew": "\uFB1F",
    "/doughnut": "\u1F369",
    "/doveOfPeace": "\u1F54A",
    "/downtackbelowcmb": "\u031E",
    "/downtackmod": "\u02D5",
    "/downwarrowleftofuparrow": "\u21F5",
    "/dparen": "\u249F",
    "/dparenthesized": "\u249F",
    "/drachma": "\u20AF",
    "/dragon": "\u1F409",
    "/dragonFace": "\u1F432",
    "/draughtskingblack": "\u26C3",
    "/draughtskingwhite": "\u26C1",
    "/draughtsmanblack": "\u26C2",
    "/draughtsmanwhite": "\u26C0",
    "/dress": "\u1F457",
    "/driveslow": "\u26DA",
    "/dromedaryCamel": "\u1F42A",
    "/droplet": "\u1F4A7",
    "/dsquare": "\u1F1A5",
    "/dsuperior": "\uF6EB",
    "/dtail": "\u0256",
    "/dtopbar": "\u018C",
    "/duhiragana": "\u3065",
    "/dukatakana": "\u30C5",
    "/dul": "\u068E",
    "/dul.fina": "\uFB87",
    "/dul.isol": "\uFB86",
    "/dum": "\uA771",
    "/dvd": "\u1F4C0",
    "/dyeh": "\u0684",
    "/dyeh.fina": "\uFB73",
    "/dyeh.init": "\uFB74",
    "/dyeh.isol": "\uFB72",
    "/dyeh.medi": "\uFB75",
    "/dz": "\u01F3",
    "/dzaltone": "\u02A3",
    "/dzcaron": "\u01C6",
    "/dzcurl": "\u02A5",
    "/dzeabkhasiancyrillic": "\u04E1",
    "/dzeabkhcyr": "\u04E1",
    "/dzecyr": "\u0455",
    "/dzecyrillic": "\u0455",
    "/dzed": "\u02A3",
    "/dzedcurl": "\u02A5",
    "/dzhecyr": "\u045F",
    "/dzhecyrillic": "\u045F",
    "/dzjekomicyr": "\u0507",
    "/dzzhecyr": "\u052B",
    "/e": "\u0065",
    "/e-mail": "\u1F4E7",
    "/e.fina": "\uFBE5",
    "/e.inferior": "\u2091",
    "/e.init": "\uFBE6",
    "/e.isol": "\uFBE4",
    "/e.medi": "\uFBE7",
    "/eVfullwidth": "\u32CE",
    "/eacute": "\u00E9",
    "/earOfMaize": "\u1F33D",
    "/earOfRice": "\u1F33E",
    "/earth": "\u2641",
    "/earthGlobeAmericas": "\u1F30E",
    "/earthGlobeAsiaAustralia": "\u1F30F",
    "/earthGlobeEuropeAfrica": "\u1F30D",
    "/earthground": "\u23DA",
    "/earthideographiccircled": "\u328F",
    "/earthideographicparen": "\u322F",
    "/eastsyriaccross": "\u2671",
    "/ebengali": "\u098F",
    "/ebopomofo": "\u311C",
    "/ebreve": "\u0115",
    "/ecandradeva": "\u090D",
    "/ecandragujarati": "\u0A8D",
    "/ecandravowelsigndeva": "\u0945",
    "/ecandravowelsigngujarati": "\u0AC5",
    "/ecaron": "\u011B",
    "/ecedilla": "\u0229",
    "/ecedillabreve": "\u1E1D",
    "/echarmenian": "\u0565",
    "/echyiwnarmenian": "\u0587",
    "/ecircle": "\u24D4",
    "/ecirclekatakana": "\u32D3",
    "/ecircumflex": "\u00EA",
    "/ecircumflexacute": "\u1EBF",
    "/ecircumflexbelow": "\u1E19",
    "/ecircumflexdotbelow": "\u1EC7",
    "/ecircumflexgrave": "\u1EC1",
    "/ecircumflexhoi": "\u1EC3",
    "/ecircumflexhookabove": "\u1EC3",
    "/ecircumflextilde": "\u1EC5",
    "/ecyrillic": "\u0454",
    "/edblgrave": "\u0205",
    "/edblstruckitalic": "\u2147",
    "/edeva": "\u090F",
    "/edieresis": "\u00EB",
    "/edot": "\u0117",
    "/edotaccent": "\u0117",
    "/edotbelow": "\u1EB9",
    "/eegurmukhi": "\u0A0F",
    "/eekaasquare": "\u3308",
    "/eematragurmukhi": "\u0A47",
    "/efcyr": "\u0444",
    "/efcyrillic": "\u0444",
    "/egrave": "\u00E8",
    "/egravedbl": "\u0205",
    "/egujarati": "\u0A8F",
    "/egyptain": "\uA725",
    "/egyptalef": "\uA723",
    "/eharmenian": "\u0567",
    "/ehbopomofo": "\u311D",
    "/ehiragana": "\u3048",
    "/ehoi": "\u1EBB",
    "/ehookabove": "\u1EBB",
    "/eibopomofo": "\u311F",
    "/eight": "\u0038",
    "/eight.inferior": "\u2088",
    "/eight.roman": "\u2167",
    "/eight.romansmall": "\u2177",
    "/eight.superior": "\u2078",
    "/eightarabic": "\u0668",
    "/eightbengali": "\u09EE",
    "/eightcircle": "\u2467",
    "/eightcircledbl": "\u24FC",
    "/eightcircleinversesansserif": "\u2791",
    "/eightcomma": "\u1F109",
    "/eightdeva": "\u096E",
    "/eighteencircle": "\u2471",
    "/eighteencircleblack": "\u24F2",
    "/eighteenparen": "\u2485",
    "/eighteenparenthesized": "\u2485",
    "/eighteenperiod": "\u2499",
    "/eightfar": "\u06F8",
    "/eightgujarati": "\u0AEE",
    "/eightgurmukhi": "\u0A6E",
    "/eighthackarabic": "\u0668",
    "/eighthangzhou": "\u3028",
    "/eighthnote": "\u266A",
    "/eighthnotebeamed": "\u266B",
    "/eightideographiccircled": "\u3287",
    "/eightideographicparen": "\u3227",
    "/eightinferior": "\u2088",
    "/eightksquare": "\u1F19F",
    "/eightmonospace": "\uFF18",
    "/eightoldstyle": "\uF738",
    "/eightparen": "\u247B",
    "/eightparenthesized": "\u247B",
    "/eightperiod": "\u248F",
    "/eightpersian": "\u06F8",
    "/eightroman": "\u2177",
    "/eightsuperior": "\u2078",
    "/eightthai": "\u0E58",
    "/eightycirclesquare": "\u324F",
    "/einvertedbreve": "\u0207",
    "/eiotifiedcyr": "\u0465",
    "/eiotifiedcyrillic": "\u0465",
    "/eject": "\u23CF",
    "/ekatakana": "\u30A8",
    "/ekatakanahalfwidth": "\uFF74",
    "/ekonkargurmukhi": "\u0A74",
    "/ekorean": "\u3154",
    "/elcyr": "\u043B",
    "/elcyrillic": "\u043B",
    "/electricLightBulb": "\u1F4A1",
    "/electricPlug": "\u1F50C",
    "/electricTorch": "\u1F526",
    "/electricalintersection": "\u23E7",
    "/electricarrow": "\u2301",
    "/element": "\u2208",
    "/elementdotabove": "\u22F5",
    "/elementlonghorizontalstroke": "\u22F2",
    "/elementopeningup": "\u27D2",
    "/elementoverbar": "\u22F6",
    "/elementoverbarsmall": "\u22F7",
    "/elementsmall": "\u220A",
    "/elementsmallverticalbarhorizontalstroke": "\u22F4",
    "/elementtwoshorizontalstroke": "\u22F9",
    "/elementunderbar": "\u22F8",
    "/elementverticalbarhorizontalstroke": "\u22F3",
    "/elephant": "\u1F418",
    "/eleven.roman": "\u216A",
    "/eleven.romansmall": "\u217A",
    "/elevencircle": "\u246A",
    "/elevencircleblack": "\u24EB",
    "/elevenparen": "\u247E",
    "/elevenparenthesized": "\u247E",
    "/elevenperiod": "\u2492",
    "/elevenroman": "\u217A",
    "/elhookcyr": "\u0513",
    "/ellipsis": "\u2026",
    "/ellipsisdiagonaldownright": "\u22F1",
    "/ellipsisdiagonalupright": "\u22F0",
    "/ellipsismidhorizontal": "\u22EF",
    "/ellipsisvertical": "\u22EE",
    "/elmiddlehookcyr": "\u0521",
    "/elsharptailcyr": "\u04C6",
    "/eltailcyr": "\u052F",
    "/emacron": "\u0113",
    "/emacronacute": "\u1E17",
    "/emacrongrave": "\u1E15",
    "/emcyr": "\u043C",
    "/emcyrillic": "\u043C",
    "/emdash": "\u2014",
    "/emdashdbl": "\u2E3A",
    "/emdashtpl": "\u2E3B",
    "/emdashvertical": "\uFE31",
    "/emojiModifierFitzpatrickType-1-2": "\u1F3FB",
    "/emojiModifierFitzpatrickType-3": "\u1F3FC",
    "/emojiModifierFitzpatrickType-4": "\u1F3FD",
    "/emojiModifierFitzpatrickType-5": "\u1F3FE",
    "/emojiModifierFitzpatrickType-6": "\u1F3FF",
    "/emonospace": "\uFF45",
    "/emphasis": "\u2383",
    "/emphasismarkarmenian": "\u055B",
    "/emptyDocument": "\u1F5CB",
    "/emptyNote": "\u1F5C5",
    "/emptyNotePad": "\u1F5C7",
    "/emptyNotePage": "\u1F5C6",
    "/emptyPage": "\u1F5CC",
    "/emptyPages": "\u1F5CD",
    "/emptyset": "\u2205",
    "/emquad": "\u2001",
    "/emsharptailcyr": "\u04CE",
    "/emspace": "\u2003",
    "/enbopomofo": "\u3123",
    "/encyr": "\u043D",
    "/encyrillic": "\u043D",
    "/endLeftwardsArrowAbove": "\u1F51A",
    "/endash": "\u2013",
    "/endashvertical": "\uFE32",
    "/endescendercyrillic": "\u04A3",
    "/endpro": "\u220E",
    "/eng": "\u014B",
    "/engbopomofo": "\u3125",
    "/engecyr": "\u04A5",
    "/enghecyrillic": "\u04A5",
    "/enhookcyr": "\u04C8",
    "/enhookcyrillic": "\u04C8",
    "/enhookleftcyr": "\u0529",
    "/enmiddlehookcyr": "\u0523",
    "/enotch": "\u2C78",
    "/enquad": "\u2000",
    "/ensharptailcyr": "\u04CA",
    "/enspace": "\u2002",
    "/entailcyr": "\u04A3",
    "/enter": "\u2386",
    "/enterpriseideographiccircled": "\u32AD",
    "/enterpriseideographicparen": "\u323D",
    "/envelopeDownwardsArrowAbove": "\u1F4E9",
    "/envelopeLightning": "\u1F584",
    "/eogonek": "\u0119",
    "/eokorean": "\u3153",
    "/eopen": "\u025B",
    "/eopenclosed": "\u029A",
    "/eopenreversed": "\u025C",
    "/eopenreversedclosed": "\u025E",
    "/eopenreversedhook": "\u025D",
    "/eparen": "\u24A0",
    "/eparenthesized": "\u24A0",
    "/epsilon": "\u03B5",
    "/epsilonacute": "\u1F73",
    "/epsilonasper": "\u1F11",
    "/epsilonasperacute": "\u1F15",
    "/epsilonaspergrave": "\u1F13",
    "/epsilongrave": "\u1F72",
    "/epsilonlenis": "\u1F10",
    "/epsilonlenisacute": "\u1F14",
    "/epsilonlenisgrave": "\u1F12",
    "/epsilonlunatesymbol": "\u03F5",
    "/epsilonreversedlunatesymbol": "\u03F6",
    "/epsilontonos": "\u03AD",
    "/epsilonunderlinefunc": "\u2377",
    "/equal": "\u003D",
    "/equal.inferior": "\u208C",
    "/equal.superior": "\u207C",
    "/equalandparallel": "\u22D5",
    "/equalbydefinition": "\u225D",
    "/equalmonospace": "\uFF1D",
    "/equalorgreater": "\u22DD",
    "/equalorless": "\u22DC",
    "/equalorprecedes": "\u22DE",
    "/equalorsucceeds": "\u22DF",
    "/equalscolon": "\u2255",
    "/equalsmall": "\uFE66",
    "/equalsuperior": "\u207C",
    "/equiangular": "\u225A",
    "/equivalence": "\u2261",
    "/equivalent": "\u224D",
    "/eranameheiseisquare": "\u337B",
    "/eranamemeizisquare": "\u337E",
    "/eranamesyouwasquare": "\u337C",
    "/eranametaisyousquare": "\u337D",
    "/eraseleft": "\u232B",
    "/eraseright": "\u2326",
    "/erbopomofo": "\u3126",
    "/ercyr": "\u0440",
    "/ercyrillic": "\u0440",
    "/ereversed": "\u0258",
    "/ereversedcyr": "\u044D",
    "/ereversedcyrillic": "\u044D",
    "/ereverseddieresiscyr": "\u04ED",
    "/ergfullwidth": "\u32CD",
    "/ertickcyr": "\u048F",
    "/escript": "\u212F",
    "/escyr": "\u0441",
    "/escyrillic": "\u0441",
    "/esdescendercyrillic": "\u04AB",
    "/esh": "\u0283",
    "/eshcurl": "\u0286",
    "/eshortdeva": "\u090E",
    "/eshortvowelsigndeva": "\u0946",
    "/eshreversedloop": "\u01AA",
    "/eshsquatreversed": "\u0285",
    "/esmallhiragana": "\u3047",
    "/esmallkatakana": "\u30A7",
    "/esmallkatakanahalfwidth": "\uFF6A",
    "/estailcyr": "\u04AB",
    "/estimated": "\u212E",
    "/estimates": "\u2259",
    "/estroke": "\u0247",
    "/esukuudosquare": "\u3307",
    "/esuperior": "\uF6EC",
    "/et": "\uA76B",
    "/eta": "\u03B7",
    "/etaacute": "\u1F75",
    "/etaacuteiotasub": "\u1FC4",
    "/etaasper": "\u1F21",
    "/etaasperacute": "\u1F25",
    "/etaasperacuteiotasub": "\u1F95",
    "/etaaspergrave": "\u1F23",
    "/etaaspergraveiotasub": "\u1F93",
    "/etaasperiotasub": "\u1F91",
    "/etaaspertilde": "\u1F27",
    "/etaaspertildeiotasub": "\u1F97",
    "/etagrave": "\u1F74",
    "/etagraveiotasub": "\u1FC2",
    "/etaiotasub": "\u1FC3",
    "/etalenis": "\u1F20",
    "/etalenisacute": "\u1F24",
    "/etalenisacuteiotasub": "\u1F94",
    "/etalenisgrave": "\u1F22",
    "/etalenisgraveiotasub": "\u1F92",
    "/etalenisiotasub": "\u1F90",
    "/etalenistilde": "\u1F26",
    "/etalenistildeiotasub": "\u1F96",
    "/etarmenian": "\u0568",
    "/etatilde": "\u1FC6",
    "/etatildeiotasub": "\u1FC7",
    "/etatonos": "\u03AE",
    "/eth": "\u00F0",
    "/ethi:aaglottal": "\u12A3",
    "/ethi:aglottal": "\u12A0",
    "/ethi:ba": "\u1260",
    "/ethi:baa": "\u1263",
    "/ethi:be": "\u1265",
    "/ethi:bee": "\u1264",
    "/ethi:bi": "\u1262",
    "/ethi:bo": "\u1266",
    "/ethi:bu": "\u1261",
    "/ethi:bwa": "\u1267",
    "/ethi:ca": "\u1278",
    "/ethi:caa": "\u127B",
    "/ethi:ce": "\u127D",
    "/ethi:cee": "\u127C",
    "/ethi:cha": "\u1328",
    "/ethi:chaa": "\u132B",
    "/ethi:che": "\u132D",
    "/ethi:chee": "\u132C",
    "/ethi:chi": "\u132A",
    "/ethi:cho": "\u132E",
    "/ethi:chu": "\u1329",
    "/ethi:chwa": "\u132F",
    "/ethi:ci": "\u127A",
    "/ethi:co": "\u127E",
    "/ethi:colon": "\u1365",
    "/ethi:comma": "\u1363",
    "/ethi:cu": "\u1279",
    "/ethi:cwa": "\u127F",
    "/ethi:da": "\u12F0",
    "/ethi:daa": "\u12F3",
    "/ethi:dda": "\u12F8",
    "/ethi:ddaa": "\u12FB",
    "/ethi:dde": "\u12FD",
    "/ethi:ddee": "\u12FC",
    "/ethi:ddi": "\u12FA",
    "/ethi:ddo": "\u12FE",
    "/ethi:ddu": "\u12F9",
    "/ethi:ddwa": "\u12FF",
    "/ethi:de": "\u12F5",
    "/ethi:dee": "\u12F4",
    "/ethi:di": "\u12F2",
    "/ethi:do": "\u12F6",
    "/ethi:du": "\u12F1",
    "/ethi:dwa": "\u12F7",
    "/ethi:eeglottal": "\u12A4",
    "/ethi:eglottal": "\u12A5",
    "/ethi:eight": "\u1370",
    "/ethi:eighty": "\u1379",
    "/ethi:fa": "\u1348",
    "/ethi:faa": "\u134B",
    "/ethi:fe": "\u134D",
    "/ethi:fee": "\u134C",
    "/ethi:fi": "\u134A",
    "/ethi:fifty": "\u1376",
    "/ethi:five": "\u136D",
    "/ethi:fo": "\u134E",
    "/ethi:forty": "\u1375",
    "/ethi:four": "\u136C",
    "/ethi:fu": "\u1349",
    "/ethi:fullstop": "\u1362",
    "/ethi:fwa": "\u134F",
    "/ethi:fya": "\u135A",
    "/ethi:ga": "\u1308",
    "/ethi:gaa": "\u130B",
    "/ethi:ge": "\u130D",
    "/ethi:gee": "\u130C",
    "/ethi:geminationandvowellengthmarkcmb": "\u135D",
    "/ethi:geminationmarkcmb": "\u135F",
    "/ethi:gga": "\u1318",
    "/ethi:ggaa": "\u131B",
    "/ethi:gge": "\u131D",
    "/ethi:ggee": "\u131C",
    "/ethi:ggi": "\u131A",
    "/ethi:ggo": "\u131E",
    "/ethi:ggu": "\u1319",
    "/ethi:ggwaa": "\u131F",
    "/ethi:gi": "\u130A",
    "/ethi:go": "\u130E",
    "/ethi:goa": "\u130F",
    "/ethi:gu": "\u1309",
    "/ethi:gwa": "\u1310",
    "/ethi:gwaa": "\u1313",
    "/ethi:gwe": "\u1315",
    "/ethi:gwee": "\u1314",
    "/ethi:gwi": "\u1312",
    "/ethi:ha": "\u1200",
    "/ethi:haa": "\u1203",
    "/ethi:he": "\u1205",
    "/ethi:hee": "\u1204",
    "/ethi:hha": "\u1210",
    "/ethi:hhaa": "\u1213",
    "/ethi:hhe": "\u1215",
    "/ethi:hhee": "\u1214",
    "/ethi:hhi": "\u1212",
    "/ethi:hho": "\u1216",
    "/ethi:hhu": "\u1211",
    "/ethi:hhwa": "\u1217",
    "/ethi:hi": "\u1202",
    "/ethi:ho": "\u1206",
    "/ethi:hoa": "\u1207",
    "/ethi:hu": "\u1201",
    "/ethi:hundred": "\u137B",
    "/ethi:iglottal": "\u12A2",
    "/ethi:ja": "\u1300",
    "/ethi:jaa": "\u1303",
    "/ethi:je": "\u1305",
    "/ethi:jee": "\u1304",
    "/ethi:ji": "\u1302",
    "/ethi:jo": "\u1306",
    "/ethi:ju": "\u1301",
    "/ethi:jwa": "\u1307",
    "/ethi:ka": "\u12A8",
    "/ethi:kaa": "\u12AB",
    "/ethi:ke": "\u12AD",
    "/ethi:kee": "\u12AC",
    "/ethi:ki": "\u12AA",
    "/ethi:ko": "\u12AE",
    "/ethi:koa": "\u12AF",
    "/ethi:ku": "\u12A9",
    "/ethi:kwa": "\u12B0",
    "/ethi:kwaa": "\u12B3",
    "/ethi:kwe": "\u12B5",
    "/ethi:kwee": "\u12B4",
    "/ethi:kwi": "\u12B2",
    "/ethi:kxa": "\u12B8",
    "/ethi:kxaa": "\u12BB",
    "/ethi:kxe": "\u12BD",
    "/ethi:kxee": "\u12BC",
    "/ethi:kxi": "\u12BA",
    "/ethi:kxo": "\u12BE",
    "/ethi:kxu": "\u12B9",
    "/ethi:kxwa": "\u12C0",
    "/ethi:kxwaa": "\u12C3",
    "/ethi:kxwe": "\u12C5",
    "/ethi:kxwee": "\u12C4",
    "/ethi:kxwi": "\u12C2",
    "/ethi:la": "\u1208",
    "/ethi:laa": "\u120B",
    "/ethi:le": "\u120D",
    "/ethi:lee": "\u120C",
    "/ethi:li": "\u120A",
    "/ethi:lo": "\u120E",
    "/ethi:lu": "\u1209",
    "/ethi:lwa": "\u120F",
    "/ethi:ma": "\u1218",
    "/ethi:maa": "\u121B",
    "/ethi:me": "\u121D",
    "/ethi:mee": "\u121C",
    "/ethi:mi": "\u121A",
    "/ethi:mo": "\u121E",
    "/ethi:mu": "\u1219",
    "/ethi:mwa": "\u121F",
    "/ethi:mya": "\u1359",
    "/ethi:na": "\u1290",
    "/ethi:naa": "\u1293",
    "/ethi:ne": "\u1295",
    "/ethi:nee": "\u1294",
    "/ethi:ni": "\u1292",
    "/ethi:nine": "\u1371",
    "/ethi:ninety": "\u137A",
    "/ethi:no": "\u1296",
    "/ethi:nu": "\u1291",
    "/ethi:nwa": "\u1297",
    "/ethi:nya": "\u1298",
    "/ethi:nyaa": "\u129B",
    "/ethi:nye": "\u129D",
    "/ethi:nyee": "\u129C",
    "/ethi:nyi": "\u129A",
    "/ethi:nyo": "\u129E",
    "/ethi:nyu": "\u1299",
    "/ethi:nywa": "\u129F",
    "/ethi:oglottal": "\u12A6",
    "/ethi:one": "\u1369",
    "/ethi:pa": "\u1350",
    "/ethi:paa": "\u1353",
    "/ethi:paragraphseparator": "\u1368",
    "/ethi:pe": "\u1355",
    "/ethi:pee": "\u1354",
    "/ethi:pha": "\u1330",
    "/ethi:phaa": "\u1333",
    "/ethi:pharyngeala": "\u12D0",
    "/ethi:pharyngealaa": "\u12D3",
    "/ethi:pharyngeale": "\u12D5",
    "/ethi:pharyngealee": "\u12D4",
    "/ethi:pharyngeali": "\u12D2",
    "/ethi:pharyngealo": "\u12D6",
    "/ethi:pharyngealu": "\u12D1",
    "/ethi:phe": "\u1335",
    "/ethi:phee": "\u1334",
    "/ethi:phi": "\u1332",
    "/ethi:pho": "\u1336",
    "/ethi:phu": "\u1331",
    "/ethi:phwa": "\u1337",
    "/ethi:pi": "\u1352",
    "/ethi:po": "\u1356",
    "/ethi:prefacecolon": "\u1366",
    "/ethi:pu": "\u1351",
    "/ethi:pwa": "\u1357",
    "/ethi:qa": "\u1240",
    "/ethi:qaa": "\u1243",
    "/ethi:qe": "\u1245",
    "/ethi:qee": "\u1244",
    "/ethi:qha": "\u1250",
    "/ethi:qhaa": "\u1253",
    "/ethi:qhe": "\u1255",
    "/ethi:qhee": "\u1254",
    "/ethi:qhi": "\u1252",
    "/ethi:qho": "\u1256",
    "/ethi:qhu": "\u1251",
    "/ethi:qhwa": "\u1258",
    "/ethi:qhwaa": "\u125B",
    "/ethi:qhwe": "\u125D",
    "/ethi:qhwee": "\u125C",
    "/ethi:qhwi": "\u125A",
    "/ethi:qi": "\u1242",
    "/ethi:qo": "\u1246",
    "/ethi:qoa": "\u1247",
    "/ethi:qu": "\u1241",
    "/ethi:questionmark": "\u1367",
    "/ethi:qwa": "\u1248",
    "/ethi:qwaa": "\u124B",
    "/ethi:qwe": "\u124D",
    "/ethi:qwee": "\u124C",
    "/ethi:qwi": "\u124A",
    "/ethi:ra": "\u1228",
    "/ethi:raa": "\u122B",
    "/ethi:re": "\u122D",
    "/ethi:ree": "\u122C",
    "/ethi:ri": "\u122A",
    "/ethi:ro": "\u122E",
    "/ethi:ru": "\u1229",
    "/ethi:rwa": "\u122F",
    "/ethi:rya": "\u1358",
    "/ethi:sa": "\u1230",
    "/ethi:saa": "\u1233",
    "/ethi:se": "\u1235",
    "/ethi:sectionmark": "\u1360",
    "/ethi:see": "\u1234",
    "/ethi:semicolon": "\u1364",
    "/ethi:seven": "\u136F",
    "/ethi:seventy": "\u1378",
    "/ethi:sha": "\u1238",
    "/ethi:shaa": "\u123B",
    "/ethi:she": "\u123D",
    "/ethi:shee": "\u123C",
    "/ethi:shi": "\u123A",
    "/ethi:sho": "\u123E",
    "/ethi:shu": "\u1239",
    "/ethi:shwa": "\u123F",
    "/ethi:si": "\u1232",
    "/ethi:six": "\u136E",
    "/ethi:sixty": "\u1377",
    "/ethi:so": "\u1236",
    "/ethi:su": "\u1231",
    "/ethi:swa": "\u1237",
    "/ethi:sza": "\u1220",
    "/ethi:szaa": "\u1223",
    "/ethi:sze": "\u1225",
    "/ethi:szee": "\u1224",
    "/ethi:szi": "\u1222",
    "/ethi:szo": "\u1226",
    "/ethi:szu": "\u1221",
    "/ethi:szwa": "\u1227",
    "/ethi:ta": "\u1270",
    "/ethi:taa": "\u1273",
    "/ethi:te": "\u1275",
    "/ethi:tee": "\u1274",
    "/ethi:ten": "\u1372",
    "/ethi:tenthousand": "\u137C",
    "/ethi:tha": "\u1320",
    "/ethi:thaa": "\u1323",
    "/ethi:the": "\u1325",
    "/ethi:thee": "\u1324",
    "/ethi:thi": "\u1322",
    "/ethi:thirty": "\u1374",
    "/ethi:tho": "\u1326",
    "/ethi:three": "\u136B",
    "/ethi:thu": "\u1321",
    "/ethi:thwa": "\u1327",
    "/ethi:ti": "\u1272",
    "/ethi:to": "\u1276",
    "/ethi:tsa": "\u1338",
    "/ethi:tsaa": "\u133B",
    "/ethi:tse": "\u133D",
    "/ethi:tsee": "\u133C",
    "/ethi:tsi": "\u133A",
    "/ethi:tso": "\u133E",
    "/ethi:tsu": "\u1339",
    "/ethi:tswa": "\u133F",
    "/ethi:tu": "\u1271",
    "/ethi:twa": "\u1277",
    "/ethi:twenty": "\u1373",
    "/ethi:two": "\u136A",
    "/ethi:tza": "\u1340",
    "/ethi:tzaa": "\u1343",
    "/ethi:tze": "\u1345",
    "/ethi:tzee": "\u1344",
    "/ethi:tzi": "\u1342",
    "/ethi:tzo": "\u1346",
    "/ethi:tzoa": "\u1347",
    "/ethi:tzu": "\u1341",
    "/ethi:uglottal": "\u12A1",
    "/ethi:va": "\u1268",
    "/ethi:vaa": "\u126B",
    "/ethi:ve": "\u126D",
    "/ethi:vee": "\u126C",
    "/ethi:vi": "\u126A",
    "/ethi:vo": "\u126E",
    "/ethi:vowellengthmarkcmb": "\u135E",
    "/ethi:vu": "\u1269",
    "/ethi:vwa": "\u126F",
    "/ethi:wa": "\u12C8",
    "/ethi:waa": "\u12CB",
    "/ethi:waglottal": "\u12A7",
    "/ethi:we": "\u12CD",
    "/ethi:wee": "\u12CC",
    "/ethi:wi": "\u12CA",
    "/ethi:wo": "\u12CE",
    "/ethi:woa": "\u12CF",
    "/ethi:wordspace": "\u1361",
    "/ethi:wu": "\u12C9",
    "/ethi:xa": "\u1280",
    "/ethi:xaa": "\u1283",
    "/ethi:xe": "\u1285",
    "/ethi:xee": "\u1284",
    "/ethi:xi": "\u1282",
    "/ethi:xo": "\u1286",
    "/ethi:xoa": "\u1287",
    "/ethi:xu": "\u1281",
    "/ethi:xwa": "\u1288",
    "/ethi:xwaa": "\u128B",
    "/ethi:xwe": "\u128D",
    "/ethi:xwee": "\u128C",
    "/ethi:xwi": "\u128A",
    "/ethi:ya": "\u12E8",
    "/ethi:yaa": "\u12EB",
    "/ethi:ye": "\u12ED",
    "/ethi:yee": "\u12EC",
    "/ethi:yi": "\u12EA",
    "/ethi:yo": "\u12EE",
    "/ethi:yoa": "\u12EF",
    "/ethi:yu": "\u12E9",
    "/ethi:za": "\u12D8",
    "/ethi:zaa": "\u12DB",
    "/ethi:ze": "\u12DD",
    "/ethi:zee": "\u12DC",
    "/ethi:zha": "\u12E0",
    "/ethi:zhaa": "\u12E3",
    "/ethi:zhe": "\u12E5",
    "/ethi:zhee": "\u12E4",
    "/ethi:zhi": "\u12E2",
    "/ethi:zho": "\u12E6",
    "/ethi:zhu": "\u12E1",
    "/ethi:zhwa": "\u12E7",
    "/ethi:zi": "\u12DA",
    "/ethi:zo": "\u12DE",
    "/ethi:zu": "\u12D9",
    "/ethi:zwa": "\u12DF",
    "/etilde": "\u1EBD",
    "/etildebelow": "\u1E1B",
    "/etnahta:hb": "\u0591",
    "/etnahtafoukhhebrew": "\u0591",
    "/etnahtafoukhlefthebrew": "\u0591",
    "/etnahtahebrew": "\u0591",
    "/etnahtalefthebrew": "\u0591",
    "/eturned": "\u01DD",
    "/eukorean": "\u3161",
    "/eukrcyr": "\u0454",
    "/euler": "\u2107",
    "/euro": "\u20AC",
    "/euroarchaic": "\u20A0",
    "/europeanCastle": "\u1F3F0",
    "/europeanPostOffice": "\u1F3E4",
    "/evergreenTree": "\u1F332",
    "/evowelsignbengali": "\u09C7",
    "/evowelsigndeva": "\u0947",
    "/evowelsigngujarati": "\u0AC7",
    "/excellentideographiccircled": "\u329D",
    "/excess": "\u2239",
    "/exclam": "\u0021",
    "/exclamarmenian": "\u055C",
    "/exclamationquestion": "\u2049",
    "/exclamdbl": "\u203C",
    "/exclamdown": "\u00A1",
    "/exclamdownsmall": "\uF7A1",
    "/exclammonospace": "\uFF01",
    "/exclamsmall": "\uF721",
    "/existential": "\u2203",
    "/expressionlessFace": "\u1F611",
    "/extraterrestrialAlien": "\u1F47D",
    "/eye": "\u1F441",
    "/eyeglasses": "\u1F453",
    "/eyes": "\u1F440",
    "/ezh": "\u0292",
    "/ezhcaron": "\u01EF",
    "/ezhcurl": "\u0293",
    "/ezhreversed": "\u01B9",
    "/ezhtail": "\u01BA",
    "/f": "\u0066",
    "/f_f": "\uFB00",
    "/f_f_i": "\uFB03",
    "/f_f_l": "\uFB04",
    "/faceMassage": "\u1F486",
    "/faceSavouringDeliciousFood": "\u1F60B",
    "/faceScreamingInFear": "\u1F631",
    "/faceThrowingAKiss": "\u1F618",
    "/faceWithColdSweat": "\u1F613",
    "/faceWithLookOfTriumph": "\u1F624",
    "/faceWithMedicalMask": "\u1F637",
    "/faceWithNoGoodGesture": "\u1F645",
    "/faceWithOkGesture": "\u1F646",
    "/faceWithOpenMouth": "\u1F62E",
    "/faceWithOpenMouthAndColdSweat": "\u1F630",
    "/faceWithRollingEyes": "\u1F644",
    "/faceWithStuckOutTongue": "\u1F61B",
    "/faceWithStuckOutTongueAndTightlyClosedEyes": "\u1F61D",
    "/faceWithStuckOutTongueAndWinkingEye": "\u1F61C",
    "/faceWithTearsOfJoy": "\u1F602",
    "/faceWithoutMouth": "\u1F636",
    "/facsimile": "\u213B",
    "/factory": "\u1F3ED",
    "/fadeva": "\u095E",
    "/fagurmukhi": "\u0A5E",
    "/fahrenheit": "\u2109",
    "/fallenLeaf": "\u1F342",
    "/fallingdiagonal": "\u27CD",
    "/fallingdiagonalincircleinsquareblackwhite": "\u26DE",
    "/family": "\u1F46A",
    "/farsi": "\u262B",
    "/farsiYehDigitFourBelow": "\u0777",
    "/farsiYehDigitThreeAbove": "\u0776",
    "/farsiYehDigitTwoAbove": "\u0775",
    "/fatha": "\u064E",
    "/fathaIsol": "\uFE76",
    "/fathaMedi": "\uFE77",
    "/fathaarabic": "\u064E",
    "/fathalowarabic": "\u064E",
    "/fathasmall": "\u0618",
    "/fathatan": "\u064B",
    "/fathatanIsol": "\uFE70",
    "/fathatanarabic": "\u064B",
    "/fathatwodotsdots": "\u065E",
    "/fatherChristmas": "\u1F385",
    "/faxIcon": "\u1F5B7",
    "/faxMachine": "\u1F4E0",
    "/fbopomofo": "\u3108",
    "/fcircle": "\u24D5",
    "/fdot": "\u1E1F",
    "/fdotaccent": "\u1E1F",
    "/fearfulFace": "\u1F628",
    "/februarytelegraph": "\u32C1",
    "/feh.fina": "\uFED2",
    "/feh.init": "\uFED3",
    "/feh.init_alefmaksura.fina": "\uFC31",
    "/feh.init_hah.fina": "\uFC2E",
    "/feh.init_hah.medi": "\uFCBF",
    "/feh.init_jeem.fina": "\uFC2D",
    "/feh.init_jeem.medi": "\uFCBE",
    "/feh.init_khah.fina": "\uFC2F",
    "/feh.init_khah.medi": "\uFCC0",
    "/feh.init_khah.medi_meem.medi": "\uFD7D",
    "/feh.init_meem.fina": "\uFC30",
    "/feh.init_meem.medi": "\uFCC1",
    "/feh.init_yeh.fina": "\uFC32",
    "/feh.isol": "\uFED1",
    "/feh.medi": "\uFED4",
    "/feh.medi_alefmaksura.fina": "\uFC7C",
    "/feh.medi_khah.medi_meem.fina": "\uFD7C",
    "/feh.medi_meem.medi_yeh.fina": "\uFDC1",
    "/feh.medi_yeh.fina": "\uFC7D",
    "/fehThreeDotsUpBelow": "\u0761",
    "/fehTwoDotsBelow": "\u0760",
    "/feharabic": "\u0641",
    "/feharmenian": "\u0586",
    "/fehdotbelow": "\u06A3",
    "/fehdotbelowright": "\u06A2",
    "/fehfinalarabic": "\uFED2",
    "/fehinitialarabic": "\uFED3",
    "/fehmedialarabic": "\uFED4",
    "/fehthreedotsbelow": "\u06A5",
    "/feicoptic": "\u03E5",
    "/female": "\u2640",
    "/femaleideographiccircled": "\u329B",
    "/feng": "\u02A9",
    "/ferrisWheel": "\u1F3A1",
    "/ferry": "\u26F4",
    "/festivalideographicparen": "\u3240",
    "/ff": "\uFB00",
    "/ffi": "\uFB03",
    "/ffl": "\uFB04",
    "/fhook": "\u0192",
    "/fi": "\uFB01",  # ligature "fi"
    "/fieldHockeyStickAndBall": "\u1F3D1",
    "/fifteencircle": "\u246E",
    "/fifteencircleblack": "\u24EF",
    "/fifteenparen": "\u2482",
    "/fifteenparenthesized": "\u2482",
    "/fifteenperiod": "\u2496",
    "/fifty.roman": "\u216C",
    "/fifty.romansmall": "\u217C",
    "/fiftycircle": "\u32BF",
    "/fiftycirclesquare": "\u324C",
    "/fiftyearlyform.roman": "\u2186",
    "/fiftythousand.roman": "\u2187",
    "/figuredash": "\u2012",
    "/figurespace": "\u2007",
    "/fileCabinet": "\u1F5C4",
    "/fileFolder": "\u1F4C1",
    "/filledbox": "\u25A0",
    "/filledrect": "\u25AC",
    "/filledstopabove": "\u06EC",
    "/filmFrames": "\u1F39E",
    "/filmProjector": "\u1F4FD",
    "/finalkaf": "\u05DA",
    "/finalkaf:hb": "\u05DA",
    "/finalkafdagesh": "\uFB3A",
    "/finalkafdageshhebrew": "\uFB3A",
    "/finalkafhebrew": "\u05DA",
    "/finalkafqamats": "\u05DA",
    "/finalkafqamatshebrew": "\u05DA",
    "/finalkafsheva": "\u05DA",
    "/finalkafshevahebrew": "\u05DA",
    "/finalkafwithdagesh:hb": "\uFB3A",
    "/finalmem": "\u05DD",
    "/finalmem:hb": "\u05DD",
    "/finalmemhebrew": "\u05DD",
    "/finalmemwide:hb": "\uFB26",
    "/finalnun": "\u05DF",
    "/finalnun:hb": "\u05DF",
    "/finalnunhebrew": "\u05DF",
    "/finalpe": "\u05E3",
    "/finalpe:hb": "\u05E3",
    "/finalpehebrew": "\u05E3",
    "/finalpewithdagesh:hb": "\uFB43",
    "/finalsigma": "\u03C2",
    "/finaltsadi": "\u05E5",
    "/finaltsadi:hb": "\u05E5",
    "/finaltsadihebrew": "\u05E5",
    "/financialideographiccircled": "\u3296",
    "/financialideographicparen": "\u3236",
    "/finsular": "\uA77C",
    "/fire": "\u1F525",
    "/fireEngine": "\u1F692",
    "/fireideographiccircled": "\u328B",
    "/fireideographicparen": "\u322B",
    "/fireworkSparkler": "\u1F387",
    "/fireworks": "\u1F386",
    "/firstQuarterMoon": "\u1F313",
    "/firstQuarterMoonFace": "\u1F31B",
    "/firstquartermoon": "\u263D",
    "/firststrongisolate": "\u2068",
    "/firsttonechinese": "\u02C9",
    "/fish": "\u1F41F",
    "/fishCakeSwirlDesign": "\u1F365",
    "/fisheye": "\u25C9",
    "/fishingPoleAndFish": "\u1F3A3",
    "/fistedHandSign": "\u1F44A",
    "/fitacyr": "\u0473",
    "/fitacyrillic": "\u0473",
    "/five": "\u0035",
    "/five.inferior": "\u2085",
    "/five.roman": "\u2164",
    "/five.romansmall": "\u2174",
    "/five.superior": "\u2075",
    "/fivearabic": "\u0665",
    "/fivebengali": "\u09EB",
    "/fivecircle": "\u2464",
    "/fivecircledbl": "\u24F9",
    "/fivecircleinversesansserif": "\u278E",
    "/fivecomma": "\u1F106",
    "/fivedeva": "\u096B",
    "/fivedot": "\u2E2D",
    "/fivedotpunctuation": "\u2059",
    "/fiveeighths": "\u215D",
    "/fivefar": "\u06F5",
    "/fivegujarati": "\u0AEB",
    "/fivegurmukhi": "\u0A6B",
    "/fivehackarabic": "\u0665",
    "/fivehangzhou": "\u3025",
    "/fivehundred.roman": "\u216E",
    "/fivehundred.romansmall": "\u217E",
    "/fiveideographiccircled": "\u3284",
    "/fiveideographicparen": "\u3224",
    "/fiveinferior": "\u2085",
    "/fivemonospace": "\uFF15",
    "/fiveoldstyle": "\uF735",
    "/fiveparen": "\u2478",
    "/fiveparenthesized": "\u2478",
    "/fiveperiod": "\u248C",
    "/fivepersian": "\u06F5",
    "/fivepointedstar": "\u066D",
    "/fivepointonesquare": "\u1F1A0",
    "/fiveroman": "\u2174",
    "/fivesixths": "\u215A",
    "/fivesuperior": "\u2075",
    "/fivethai": "\u0E55",
    "/fivethousand.roman": "\u2181",
    "/fl": "\uFB02",
    "/flagblack": "\u2691",
    "/flaghorizontalmiddlestripeblackwhite": "\u26FF",
    "/flaginhole": "\u26F3",
    "/flagwhite": "\u2690",
    "/flatness": "\u23E5",
    "/fleurdelis": "\u269C",
    "/flexedBiceps": "\u1F4AA",
    "/floorleft": "\u230A",
    "/floorright": "\u230B",
    "/floppyDisk": "\u1F4BE",
    "/floralheartbulletreversedrotated": "\u2619",
    "/florin": "\u0192",
    "/flower": "\u2698",
    "/flowerPlayingCards": "\u1F3B4",
    "/flowerpunctuationmark": "\u2055",
    "/flushedFace": "\u1F633",
    "/flyingEnvelope": "\u1F585",
    "/flyingSaucer": "\u1F6F8",
    "/fmfullwidth": "\u3399",
    "/fmonospace": "\uFF46",
    "/fmsquare": "\u3399",
    "/fofanthai": "\u0E1F",
    "/fofathai": "\u0E1D",
    "/fog": "\u1F32B",
    "/foggy": "\u1F301",
    "/folder": "\u1F5C0",
    "/fongmanthai": "\u0E4F",
    "/footnote": "\u0602",
    "/footprints": "\u1F463",
    "/footsquare": "\u23CD",
    "/forall": "\u2200",
    "/forces": "\u22A9",
    "/fork": "\u2442",
    "/forkKnife": "\u1F374",
    "/forkKnifePlate": "\u1F37D",
    "/forsamaritan": "\u214F",
    "/fortycircle": "\u32B5",
    "/fortycirclesquare": "\u324B",
    "/fortyeightcircle": "\u32BD",
    "/fortyfivecircle": "\u32BA",
    "/fortyfourcircle": "\u32B9",
    "/fortyninecircle": "\u32BE",
    "/fortyonecircle": "\u32B6",
    "/fortysevencircle": "\u32BC",
    "/fortysixcircle": "\u32BB",
    "/fortythreecircle": "\u32B8",
    "/fortytwocircle": "\u32B7",
    "/fountain": "\u26F2",
    "/four": "\u0034",
    "/four.inferior": "\u2084",
    "/four.roman": "\u2163",
    "/four.romansmall": "\u2173",
    "/four.superior": "\u2074",
    "/fourLeafClover": "\u1F340",
    "/fourarabic": "\u0664",
    "/fourbengali": "\u09EA",
    "/fourcircle": "\u2463",
    "/fourcircledbl": "\u24F8",
    "/fourcircleinversesansserif": "\u278D",
    "/fourcomma": "\u1F105",
    "/fourdeva": "\u096A",
    "/fourdotmark": "\u205B",
    "/fourdotpunctuation": "\u2058",
    "/fourfar": "\u06F4",
    "/fourfifths": "\u2158",
    "/fourgujarati": "\u0AEA",
    "/fourgurmukhi": "\u0A6A",
    "/fourhackarabic": "\u0664",
    "/fourhangzhou": "\u3024",
    "/fourideographiccircled": "\u3283",
    "/fourideographicparen": "\u3223",
    "/fourinferior": "\u2084",
    "/fourksquare": "\u1F19E",
    "/fourmonospace": "\uFF14",
    "/fournumeratorbengali": "\u09F7",
    "/fouroldstyle": "\uF734",
    "/fourparen": "\u2477",
    "/fourparenthesized": "\u2477",
    "/fourperemspace": "\u2005",
    "/fourperiod": "\u248B",
    "/fourpersian": "\u06F4",
    "/fourroman": "\u2173",
    "/foursuperior": "\u2074",
    "/fourteencircle": "\u246D",
    "/fourteencircleblack": "\u24EE",
    "/fourteenparen": "\u2481",
    "/fourteenparenthesized": "\u2481",
    "/fourteenperiod": "\u2495",
    "/fourthai": "\u0E54",
    "/fourthtonechinese": "\u02CB",
    "/fparen": "\u24A1",
    "/fparenthesized": "\u24A1",
    "/fraction": "\u2044",
    "/frameAnX": "\u1F5BE",
    "/framePicture": "\u1F5BC",
    "/frameTiles": "\u1F5BD",
    "/franc": "\u20A3",
    "/freesquare": "\u1F193",
    "/frenchFries": "\u1F35F",
    "/freversedepigraphic": "\uA7FB",
    "/friedShrimp": "\u1F364",
    "/frogFace": "\u1F438",
    "/front-facingBabyChick": "\u1F425",
    "/frown": "\u2322",
    "/frowningFaceWithOpenMouth": "\u1F626",
    "/frowningfacewhite": "\u2639",
    "/fstroke": "\uA799",
    "/fturned": "\u214E",
    "/fuelpump": "\u26FD",
    "/fullBlock": "\u2588",
    "/fullMoon": "\u1F315",
    "/fullMoonFace": "\u1F31D",
    "/functionapplication": "\u2061",
    "/funeralurn": "\u26B1",
    "/fuse": "\u23DB",
    "/fwd:A": "\uFF21",
    "/fwd:B": "\uFF22",
    "/fwd:C": "\uFF23",
    "/fwd:D": "\uFF24",
    "/fwd:E": "\uFF25",
    "/fwd:F": "\uFF26",
    "/fwd:G": "\uFF27",
    "/fwd:H": "\uFF28",
    "/fwd:I": "\uFF29",
    "/fwd:J": "\uFF2A",
    "/fwd:K": "\uFF2B",
    "/fwd:L": "\uFF2C",
    "/fwd:M": "\uFF2D",
    "/fwd:N": "\uFF2E",
    "/fwd:O": "\uFF2F",
    "/fwd:P": "\uFF30",
    "/fwd:Q": "\uFF31",
    "/fwd:R": "\uFF32",
    "/fwd:S": "\uFF33",
    "/fwd:T": "\uFF34",
    "/fwd:U": "\uFF35",
    "/fwd:V": "\uFF36",
    "/fwd:W": "\uFF37",
    "/fwd:X": "\uFF38",
    "/fwd:Y": "\uFF39",
    "/fwd:Z": "\uFF3A",
    "/fwd:a": "\uFF41",
    "/fwd:ampersand": "\uFF06",
    "/fwd:asciicircum": "\uFF3E",
    "/fwd:asciitilde": "\uFF5E",
    "/fwd:asterisk": "\uFF0A",
    "/fwd:at": "\uFF20",
    "/fwd:b": "\uFF42",
    "/fwd:backslash": "\uFF3C",
    "/fwd:bar": "\uFF5C",
    "/fwd:braceleft": "\uFF5B",
    "/fwd:braceright": "\uFF5D",
    "/fwd:bracketleft": "\uFF3B",
    "/fwd:bracketright": "\uFF3D",
    "/fwd:brokenbar": "\uFFE4",
    "/fwd:c": "\uFF43",
    "/fwd:centsign": "\uFFE0",
    "/fwd:colon": "\uFF1A",
    "/fwd:comma": "\uFF0C",
    "/fwd:d": "\uFF44",
    "/fwd:dollar": "\uFF04",
    "/fwd:e": "\uFF45",
    "/fwd:eight": "\uFF18",
    "/fwd:equal": "\uFF1D",
    "/fwd:exclam": "\uFF01",
    "/fwd:f": "\uFF46",
    "/fwd:five": "\uFF15",
    "/fwd:four": "\uFF14",
    "/fwd:g": "\uFF47",
    "/fwd:grave": "\uFF40",
    "/fwd:greater": "\uFF1E",
    "/fwd:h": "\uFF48",
    "/fwd:hyphen": "\uFF0D",
    "/fwd:i": "\uFF49",
    "/fwd:j": "\uFF4A",
    "/fwd:k": "\uFF4B",
    "/fwd:l": "\uFF4C",
    "/fwd:leftwhiteparenthesis": "\uFF5F",
    "/fwd:less": "\uFF1C",
    "/fwd:m": "\uFF4D",
    "/fwd:macron": "\uFFE3",
    "/fwd:n": "\uFF4E",
    "/fwd:nine": "\uFF19",
    "/fwd:notsign": "\uFFE2",
    "/fwd:numbersign": "\uFF03",
    "/fwd:o": "\uFF4F",
    "/fwd:one": "\uFF11",
    "/fwd:p": "\uFF50",
    "/fwd:parenthesisleft": "\uFF08",
    "/fwd:parenthesisright": "\uFF09",
    "/fwd:percent": "\uFF05",
    "/fwd:period": "\uFF0E",
    "/fwd:plus": "\uFF0B",
    "/fwd:poundsign": "\uFFE1",
    "/fwd:q": "\uFF51",
    "/fwd:question": "\uFF1F",
    "/fwd:quotedbl": "\uFF02",
    "/fwd:quotesingle": "\uFF07",
    "/fwd:r": "\uFF52",
    "/fwd:rightwhiteparenthesis": "\uFF60",
    "/fwd:s": "\uFF53",
    "/fwd:semicolon": "\uFF1B",
    "/fwd:seven": "\uFF17",
    "/fwd:six": "\uFF16",
    "/fwd:slash": "\uFF0F",
    "/fwd:t": "\uFF54",
    "/fwd:three": "\uFF13",
    "/fwd:two": "\uFF12",
    "/fwd:u": "\uFF55",
    "/fwd:underscore": "\uFF3F",
    "/fwd:v": "\uFF56",
    "/fwd:w": "\uFF57",
    "/fwd:wonsign": "\uFFE6",
    "/fwd:x": "\uFF58",
    "/fwd:y": "\uFF59",
    "/fwd:yensign": "\uFFE5",
    "/fwd:z": "\uFF5A",
    "/fwd:zero": "\uFF10",
    "/g": "\u0067",
    "/gabengali": "\u0997",
    "/gacute": "\u01F5",
    "/gadeva": "\u0917",
    "/gaf": "\u06AF",
    "/gaf.fina": "\uFB93",
    "/gaf.init": "\uFB94",
    "/gaf.isol": "\uFB92",
    "/gaf.medi": "\uFB95",
    "/gafarabic": "\u06AF",
    "/gaffinalarabic": "\uFB93",
    "/gafinitialarabic": "\uFB94",
    "/gafmedialarabic": "\uFB95",
    "/gafring": "\u06B0",
    "/gafthreedotsabove": "\u06B4",
    "/gaftwodotsbelow": "\u06B2",
    "/gagujarati": "\u0A97",
    "/gagurmukhi": "\u0A17",
    "/gahiragana": "\u304C",
    "/gakatakana": "\u30AC",
    "/galsquare": "\u33FF",
    "/gameDie": "\u1F3B2",
    "/gamma": "\u03B3",
    "/gammadblstruck": "\u213D",
    "/gammalatinsmall": "\u0263",
    "/gammasuperior": "\u02E0",
    "/gammasupmod": "\u02E0",
    "/gamurda": "\uA993",
    "/gangiacoptic": "\u03EB",
    "/ganmasquare": "\u330F",
    "/garonsquare": "\u330E",
    "/gbfullwidth": "\u3387",
    "/gbopomofo": "\u310D",
    "/gbreve": "\u011F",
    "/gcaron": "\u01E7",
    "/gcedilla": "\u0123",
    "/gcircle": "\u24D6",
    "/gcircumflex": "\u011D",
    "/gcommaaccent": "\u0123",
    "/gdot": "\u0121",
    "/gdotaccent": "\u0121",
    "/gear": "\u2699",
    "/gearhles": "\u26EE",
    "/gearouthub": "\u26ED",
    "/gecyr": "\u0433",
    "/gecyrillic": "\u0433",
    "/gehiragana": "\u3052",
    "/gehookcyr": "\u0495",
    "/gehookstrokecyr": "\u04FB",
    "/gekatakana": "\u30B2",
    "/gemStone": "\u1F48E",
    "/gemini": "\u264A",
    "/geometricallyequal": "\u2251",
    "/geometricallyequivalent": "\u224E",
    "/geometricproportion": "\u223A",
    "/geresh:hb": "\u05F3",
    "/gereshMuqdam:hb": "\u059D",
    "/gereshaccenthebrew": "\u059C",
    "/gereshhebrew": "\u05F3",
    "/gereshmuqdamhebrew": "\u059D",
    "/germandbls": "\u00DF",
    "/germanpenny": "\u20B0",
    "/gershayim:hb": "\u05F4",
    "/gershayimaccenthebrew": "\u059E",
    "/gershayimhebrew": "\u05F4",
    "/gestrokecyr": "\u0493",
    "/getailcyr": "\u04F7",
    "/getamark": "\u3013",
    "/geupcyr": "\u0491",
    "/ghabengali": "\u0998",
    "/ghadarmenian": "\u0572",
    "/ghadeva": "\u0918",
    "/ghagujarati": "\u0A98",
    "/ghagurmukhi": "\u0A18",
    "/ghain": "\u063A",
    "/ghain.fina": "\uFECE",
    "/ghain.init": "\uFECF",
    "/ghain.init_alefmaksura.fina": "\uFCF9",
    "/ghain.init_jeem.fina": "\uFC2B",
    "/ghain.init_jeem.medi": "\uFCBC",
    "/ghain.init_meem.fina": "\uFC2C",
    "/ghain.init_meem.medi": "\uFCBD",
    "/ghain.init_yeh.fina": "\uFCFA",
    "/ghain.isol": "\uFECD",
    "/ghain.medi": "\uFED0",
    "/ghain.medi_alefmaksura.fina": "\uFD15",
    "/ghain.medi_meem.medi_alefmaksura.fina": "\uFD7B",
    "/ghain.medi_meem.medi_meem.fina": "\uFD79",
    "/ghain.medi_meem.medi_yeh.fina": "\uFD7A",
    "/ghain.medi_yeh.fina": "\uFD16",
    "/ghainarabic": "\u063A",
    "/ghaindotbelow": "\u06FC",
    "/ghainfinalarabic": "\uFECE",
    "/ghaininitialarabic": "\uFECF",
    "/ghainmedialarabic": "\uFED0",
    "/ghemiddlehookcyrillic": "\u0495",
    "/ghestrokecyrillic": "\u0493",
    "/gheupturncyrillic": "\u0491",
    "/ghhadeva": "\u095A",
    "/ghhagurmukhi": "\u0A5A",
    "/ghook": "\u0260",
    "/ghost": "\u1F47B",
    "/ghzfullwidth": "\u3393",
    "/ghzsquare": "\u3393",
    "/gigasquare": "\u3310",
    "/gihiragana": "\u304E",
    "/gikatakana": "\u30AE",
    "/gimarmenian": "\u0563",
    "/gimel": "\u05D2",
    "/gimel:hb": "\u05D2",
    "/gimeldagesh": "\uFB32",
    "/gimeldageshhebrew": "\uFB32",
    "/gimelhebrew": "\u05D2",
    "/gimelwithdagesh:hb": "\uFB32",
    "/giniisquare": "\u3311",
    "/ginsularturned": "\uA77F",
    "/girl": "\u1F467",
    "/girls": "\u1F6CA",
    "/girudaasquare": "\u3313",
    "/gjecyr": "\u0453",
    "/gjecyrillic": "\u0453",
    "/globeMeridians": "\u1F310",
    "/glottalinvertedstroke": "\u01BE",
    "/glottalstop": "\u0294",
    "/glottalstopinverted": "\u0296",
    "/glottalstopmod": "\u02C0",
    "/glottalstopreversed": "\u0295",
    "/glottalstopreversedmod": "\u02C1",
    "/glottalstopreversedsuperior": "\u02E4",
    "/glottalstopstroke": "\u02A1",
    "/glottalstopstrokereversed": "\u02A2",
    "/glottalstopsupreversedmod": "\u02E4",
    "/glowingStar": "\u1F31F",
    "/gmacron": "\u1E21",
    "/gmonospace": "\uFF47",
    "/gmtr:diamondblack": "\u25C6",
    "/gmtr:diamondwhite": "\u25C7",
    "/gnrl:hyphen": "\u2010",
    "/goat": "\u1F410",
    "/gobliquestroke": "\uA7A1",
    "/gohiragana": "\u3054",
    "/gokatakana": "\u30B4",
    "/golfer": "\u1F3CC",
    "/gpafullwidth": "\u33AC",
    "/gparen": "\u24A2",
    "/gparenthesized": "\u24A2",
    "/gpasquare": "\u33AC",
    "/gr:acute": "\u1FFD",
    "/gr:grave": "\u1FEF",
    "/gr:question": "\u037E",
    "/gr:tilde": "\u1FC0",
    "/gradient": "\u2207",
    "/graduationCap": "\u1F393",
    "/grapes": "\u1F347",
    "/grave": "\u0060",
    "/gravebelowcmb": "\u0316",
    "/gravecmb": "\u0300",
    "/gravecomb": "\u0300",
    "/gravedblmiddlemod": "\u02F5",
    "/gravedeva": "\u0953",
    "/gravelowmod": "\u02CE",
    "/gravemiddlemod": "\u02F4",
    "/gravemod": "\u02CB",
    "/gravemonospace": "\uFF40",
    "/gravetonecmb": "\u0340",
    "/greater": "\u003E",
    "/greaterbutnotequal": "\u2269",
    "/greaterbutnotequivalent": "\u22E7",
    "/greaterdot": "\u22D7",
    "/greaterequal": "\u2265",
    "/greaterequalorless": "\u22DB",
    "/greatermonospace": "\uFF1E",
    "/greaterorequivalent": "\u2273",
    "/greaterorless": "\u2277",
    "/greateroverequal": "\u2267",
    "/greatersmall": "\uFE65",
    "/greenApple": "\u1F34F",
    "/greenBook": "\u1F4D7",
    "/greenHeart": "\u1F49A",
    "/grimacingFace": "\u1F62C",
    "/grinningCatFaceWithSmilingEyes": "\u1F638",
    "/grinningFace": "\u1F600",
    "/grinningFaceWithSmilingEyes": "\u1F601",
    "/growingHeart": "\u1F497",
    "/gscript": "\u0261",
    "/gstroke": "\u01E5",
    "/guarani": "\u20B2",
    "/guardsman": "\u1F482",
    "/gueh": "\u06B3",
    "/gueh.fina": "\uFB97",
    "/gueh.init": "\uFB98",
    "/gueh.isol": "\uFB96",
    "/gueh.medi": "\uFB99",
    "/guhiragana": "\u3050",
    "/guillemetleft": "\u00AB",
    "/guillemetright": "\u00BB",
    "/guillemotleft": "\u00AB",
    "/guillemotright": "\u00BB",
    "/guilsinglleft": "\u2039",
    "/guilsinglright": "\u203A",
    "/guitar": "\u1F3B8",
    "/gujr:a": "\u0A85",
    "/gujr:aa": "\u0A86",
    "/gujr:aasign": "\u0ABE",
    "/gujr:abbreviation": "\u0AF0",
    "/gujr:ai": "\u0A90",
    "/gujr:aisign": "\u0AC8",
    "/gujr:anusvara": "\u0A82",
    "/gujr:au": "\u0A94",
    "/gujr:ausign": "\u0ACC",
    "/gujr:avagraha": "\u0ABD",
    "/gujr:ba": "\u0AAC",
    "/gujr:bha": "\u0AAD",
    "/gujr:binducandra": "\u0A81",
    "/gujr:ca": "\u0A9A",
    "/gujr:cha": "\u0A9B",
    "/gujr:circlenuktaabove": "\u0AFE",
    "/gujr:da": "\u0AA6",
    "/gujr:dda": "\u0AA1",
    "/gujr:ddha": "\u0AA2",
    "/gujr:dha": "\u0AA7",
    "/gujr:e": "\u0A8F",
    "/gujr:ecandra": "\u0A8D",
    "/gujr:eight": "\u0AEE",
    "/gujr:esign": "\u0AC7",
    "/gujr:esigncandra": "\u0AC5",
    "/gujr:five": "\u0AEB",
    "/gujr:four": "\u0AEA",
    "/gujr:ga": "\u0A97",
    "/gujr:gha": "\u0A98",
    "/gujr:ha": "\u0AB9",
    "/gujr:i": "\u0A87",
    "/gujr:ii": "\u0A88",
    "/gujr:iisign": "\u0AC0",
    "/gujr:isign": "\u0ABF",
    "/gujr:ja": "\u0A9C",
    "/gujr:jha": "\u0A9D",
    "/gujr:ka": "\u0A95",
    "/gujr:kha": "\u0A96",
    "/gujr:la": "\u0AB2",
    "/gujr:lla": "\u0AB3",
    "/gujr:llvocal": "\u0AE1",
    "/gujr:llvocalsign": "\u0AE3",
    "/gujr:lvocal": "\u0A8C",
    "/gujr:lvocalsign": "\u0AE2",
    "/gujr:ma": "\u0AAE",
    "/gujr:maddah": "\u0AFC",
    "/gujr:na": "\u0AA8",
    "/gujr:nga": "\u0A99",
    "/gujr:nine": "\u0AEF",
    "/gujr:nna": "\u0AA3",
    "/gujr:nukta": "\u0ABC",
    "/gujr:nya": "\u0A9E",
    "/gujr:o": "\u0A93",
    "/gujr:ocandra": "\u0A91",
    "/gujr:om": "\u0AD0",
    "/gujr:one": "\u0AE7",
    "/gujr:osign": "\u0ACB",
    "/gujr:osigncandra": "\u0AC9",
    "/gujr:pa": "\u0AAA",
    "/gujr:pha": "\u0AAB",
    "/gujr:ra": "\u0AB0",
    "/gujr:rrvocal": "\u0AE0",
    "/gujr:rrvocalsign": "\u0AC4",
    "/gujr:rupee": "\u0AF1",
    "/gujr:rvocal": "\u0A8B",
    "/gujr:rvocalsign": "\u0AC3",
    "/gujr:sa": "\u0AB8",
    "/gujr:seven": "\u0AED",
    "/gujr:sha": "\u0AB6",
    "/gujr:shadda": "\u0AFB",
    "/gujr:six": "\u0AEC",
    "/gujr:ssa": "\u0AB7",
    "/gujr:sukun": "\u0AFA",
    "/gujr:ta": "\u0AA4",
    "/gujr:tha": "\u0AA5",
    "/gujr:three": "\u0AE9",
    "/gujr:three-dotnuktaabove": "\u0AFD",
    "/gujr:tta": "\u0A9F",
    "/gujr:ttha": "\u0AA0",
    "/gujr:two": "\u0AE8",
    "/gujr:two-circlenuktaabove": "\u0AFF",
    "/gujr:u": "\u0A89",
    "/gujr:usign": "\u0AC1",
    "/gujr:uu": "\u0A8A",
    "/gujr:uusign": "\u0AC2",
    "/gujr:va": "\u0AB5",
    "/gujr:virama": "\u0ACD",
    "/gujr:visarga": "\u0A83",
    "/gujr:ya": "\u0AAF",
    "/gujr:zero": "\u0AE6",
    "/gujr:zha": "\u0AF9",
    "/gukatakana": "\u30B0",
    "/guramusquare": "\u3318",
    "/guramutonsquare": "\u3319",
    "/guru:a": "\u0A05",
    "/guru:aa": "\u0A06",
    "/guru:aasign": "\u0A3E",
    "/guru:adakbindisign": "\u0A01",
    "/guru:addak": "\u0A71",
    "/guru:ai": "\u0A10",
    "/guru:aisign": "\u0A48",
    "/guru:au": "\u0A14",
    "/guru:ausign": "\u0A4C",
    "/guru:ba": "\u0A2C",
    "/guru:bha": "\u0A2D",
    "/guru:bindisign": "\u0A02",
    "/guru:ca": "\u0A1A",
    "/guru:cha": "\u0A1B",
    "/guru:da": "\u0A26",
    "/guru:dda": "\u0A21",
    "/guru:ddha": "\u0A22",
    "/guru:dha": "\u0A27",
    "/guru:ee": "\u0A0F",
    "/guru:eesign": "\u0A47",
    "/guru:eight": "\u0A6E",
    "/guru:ekonkar": "\u0A74",
    "/guru:fa": "\u0A5E",
    "/guru:five": "\u0A6B",
    "/guru:four": "\u0A6A",
    "/guru:ga": "\u0A17",
    "/guru:gha": "\u0A18",
    "/guru:ghha": "\u0A5A",
    "/guru:ha": "\u0A39",
    "/guru:i": "\u0A07",
    "/guru:ii": "\u0A08",
    "/guru:iisign": "\u0A40",
    "/guru:iri": "\u0A72",
    "/guru:isign": "\u0A3F",
    "/guru:ja": "\u0A1C",
    "/guru:jha": "\u0A1D",
    "/guru:ka": "\u0A15",
    "/guru:kha": "\u0A16",
    "/guru:khha": "\u0A59",
    "/guru:la": "\u0A32",
    "/guru:lla": "\u0A33",
    "/guru:ma": "\u0A2E",
    "/guru:na": "\u0A28",
    "/guru:nga": "\u0A19",
    "/guru:nine": "\u0A6F",
    "/guru:nna": "\u0A23",
    "/guru:nukta": "\u0A3C",
    "/guru:nya": "\u0A1E",
    "/guru:one": "\u0A67",
    "/guru:oo": "\u0A13",
    "/guru:oosign": "\u0A4B",
    "/guru:pa": "\u0A2A",
    "/guru:pha": "\u0A2B",
    "/guru:ra": "\u0A30",
    "/guru:rra": "\u0A5C",
    "/guru:sa": "\u0A38",
    "/guru:seven": "\u0A6D",
    "/guru:sha": "\u0A36",
    "/guru:six": "\u0A6C",
    "/guru:ta": "\u0A24",
    "/guru:tha": "\u0A25",
    "/guru:three": "\u0A69",
    "/guru:tippi": "\u0A70",
    "/guru:tta": "\u0A1F",
    "/guru:ttha": "\u0A20",
    "/guru:two": "\u0A68",
    "/guru:u": "\u0A09",
    "/guru:udaatsign": "\u0A51",
    "/guru:ura": "\u0A73",
    "/guru:usign": "\u0A41",
    "/guru:uu": "\u0A0A",
    "/guru:uusign": "\u0A42",
    "/guru:va": "\u0A35",
    "/guru:virama": "\u0A4D",
    "/guru:visarga": "\u0A03",
    "/guru:ya": "\u0A2F",
    "/guru:yakashsign": "\u0A75",
    "/guru:za": "\u0A5B",
    "/guru:zero": "\u0A66",
    "/gyfullwidth": "\u33C9",
    "/gysquare": "\u33C9",
    "/h": "\u0068",
    "/h.inferior": "\u2095",
    "/haabkhasiancyrillic": "\u04A9",
    "/haabkhcyr": "\u04A9",
    "/haaltonearabic": "\u06C1",
    "/habengali": "\u09B9",
    "/hacirclekatakana": "\u32E9",
    "/hacyr": "\u0445",
    "/hadescendercyrillic": "\u04B3",
    "/hadeva": "\u0939",
    "/hafullwidth": "\u33CA",
    "/hagujarati": "\u0AB9",
    "/hagurmukhi": "\u0A39",
    "/hah": "\u062D",
    "/hah.fina": "\uFEA2",
    "/hah.init": "\uFEA3",
    "/hah.init_alefmaksura.fina": "\uFCFF",
    "/hah.init_jeem.fina": "\uFC17",
    "/hah.init_jeem.medi": "\uFCA9",
    "/hah.init_meem.fina": "\uFC18",
    "/hah.init_meem.medi": "\uFCAA",
    "/hah.init_yeh.fina": "\uFD00",
    "/hah.isol": "\uFEA1",
    "/hah.medi": "\uFEA4",
    "/hah.medi_alefmaksura.fina": "\uFD1B",
    "/hah.medi_jeem.medi_yeh.fina": "\uFDBF",
    "/hah.medi_meem.medi_alefmaksura.fina": "\uFD5B",
    "/hah.medi_meem.medi_yeh.fina": "\uFD5A",
    "/hah.medi_yeh.fina": "\uFD1C",
    "/hahDigitFourBelow": "\u077C",
    "/hahSmallTahAbove": "\u0772",
    "/hahSmallTahBelow": "\u076E",
    "/hahSmallTahTwoDots": "\u076F",
    "/hahThreeDotsUpBelow": "\u0758",
    "/hahTwoDotsAbove": "\u0757",
    "/haharabic": "\u062D",
    "/hahfinalarabic": "\uFEA2",
    "/hahhamza": "\u0681",
    "/hahinitialarabic": "\uFEA3",
    "/hahiragana": "\u306F",
    "/hahmedialarabic": "\uFEA4",
    "/hahookcyr": "\u04FD",
    "/hahthreedotsabove": "\u0685",
    "/hahtwodotsvertical": "\u0682",
    "/haircut": "\u1F487",
    "/hairspace": "\u200A",
    "/haitusquare": "\u332A",
    "/hakatakana": "\u30CF",
    "/hakatakanahalfwidth": "\uFF8A",
    "/halantgurmukhi": "\u0A4D",
    "/halfcircleleftblack": "\u25D6",
    "/halfcirclerightblack": "\u25D7",
    "/hamburger": "\u1F354",
    "/hammer": "\u1F528",
    "/hammerAndWrench": "\u1F6E0",
    "/hammerpick": "\u2692",
    "/hammersickle": "\u262D",
    "/hamsterFace": "\u1F439",
    "/hamza": "\u0621",
    "/hamzaIsol": "\uFE80",
    "/hamzaabove": "\u0654",
    "/hamzaarabic": "\u0621",
    "/hamzabelow": "\u0655",
    "/hamzadammaarabic": "\u0621",
    "/hamzadammatanarabic": "\u0621",
    "/hamzafathaarabic": "\u0621",
    "/hamzafathatanarabic": "\u0621",
    "/hamzalowarabic": "\u0621",
    "/hamzalowkasraarabic": "\u0621",
    "/hamzalowkasratanarabic": "\u0621",
    "/hamzasukunarabic": "\u0621",
    "/handbag": "\u1F45C",
    "/handtailfishhookturned": "\u02AF",
    "/hangulchieuchaparen": "\u3217",
    "/hangulchieuchparen": "\u3209",
    "/hangulcieucaparen": "\u3216",
    "/hangulcieucparen": "\u3208",
    "/hangulcieucuparen": "\u321C",
    "/hanguldottonemarkdbl": "\u302F",
    "/hangulfiller": "\u3164",
    "/hangulhieuhaparen": "\u321B",
    "/hangulhieuhparen": "\u320D",
    "/hangulieungaparen": "\u3215",
    "/hangulieungparen": "\u3207",
    "/hangulkhieukhaparen": "\u3218",
    "/hangulkhieukhparen": "\u320A",
    "/hangulkiyeokaparen": "\u320E",
    "/hangulkiyeokparen": "\u3200",
    "/hangulmieumaparen": "\u3212",
    "/hangulmieumparen": "\u3204",
    "/hangulnieunaparen": "\u320F",
    "/hangulnieunparen": "\u3201",
    "/hangulphieuphaparen": "\u321A",
    "/hangulphieuphparen": "\u320C",
    "/hangulpieupaparen": "\u3213",
    "/hangulpieupparen": "\u3205",
    "/hangulrieulaparen": "\u3211",
    "/hangulrieulparen": "\u3203",
    "/hangulsingledottonemark": "\u302E",
    "/hangulsiosaparen": "\u3214",
    "/hangulsiosparen": "\u3206",
    "/hangulthieuthaparen": "\u3219",
    "/hangulthieuthparen": "\u320B",
    "/hangultikeutaparen": "\u3210",
    "/hangultikeutparen": "\u3202",
    "/happyPersonRaisingOneHand": "\u1F64B",
    "/hardDisk": "\u1F5B4",
    "/hardcyr": "\u044A",
    "/hardsigncyrillic": "\u044A",
    "/harpoondownbarbleft": "\u21C3",
    "/harpoondownbarbright": "\u21C2",
    "/harpoonleftbarbdown": "\u21BD",
    "/harpoonleftbarbup": "\u21BC",
    "/harpoonrightbarbdown": "\u21C1",
    "/harpoonrightbarbup": "\u21C0",
    "/harpoonupbarbleft": "\u21BF",
    "/harpoonupbarbright": "\u21BE",
    "/hasquare": "\u33CA",
    "/hastrokecyr": "\u04FF",
    "/hatafPatah:hb": "\u05B2",
    "/hatafQamats:hb": "\u05B3",
    "/hatafSegol:hb": "\u05B1",
    "/hatafpatah": "\u05B2",
    "/hatafpatah16": "\u05B2",
    "/hatafpatah23": "\u05B2",
    "/hatafpatah2f": "\u05B2",
    "/hatafpatahhebrew": "\u05B2",
    "/hatafpatahnarrowhebrew": "\u05B2",
    "/hatafpatahquarterhebrew": "\u05B2",
    "/hatafpatahwidehebrew": "\u05B2",
    "/hatafqamats": "\u05B3",
    "/hatafqamats1b": "\u05B3",
    "/hatafqamats28": "\u05B3",
    "/hatafqamats34": "\u05B3",
    "/hatafqamatshebrew": "\u05B3",
    "/hatafqamatsnarrowhebrew": "\u05B3",
    "/hatafqamatsquarterhebrew": "\u05B3",
    "/hatafqamatswidehebrew": "\u05B3",
    "/hatafsegol": "\u05B1",
    "/hatafsegol17": "\u05B1",
    "/hatafsegol24": "\u05B1",
    "/hatafsegol30": "\u05B1",
    "/hatafsegolhebrew": "\u05B1",
    "/hatafsegolnarrowhebrew": "\u05B1",
    "/hatafsegolquarterhebrew": "\u05B1",
    "/hatafsegolwidehebrew": "\u05B1",
    "/hatchingChick": "\u1F423",
    "/haveideographiccircled": "\u3292",
    "/haveideographicparen": "\u3232",
    "/hbar": "\u0127",
    "/hbopomofo": "\u310F",
    "/hbrevebelow": "\u1E2B",
    "/hcaron": "\u021F",
    "/hcedilla": "\u1E29",
    "/hcircle": "\u24D7",
    "/hcircumflex": "\u0125",
    "/hcsquare": "\u1F1A6",
    "/hdescender": "\u2C68",
    "/hdieresis": "\u1E27",
    "/hdot": "\u1E23",
    "/hdotaccent": "\u1E23",
    "/hdotbelow": "\u1E25",
    "/hdrsquare": "\u1F1A7",
    "/he": "\u05D4",
    "/he:hb": "\u05D4",
    "/headphone": "\u1F3A7",
    "/headstonegraveyard": "\u26FC",
    "/hearNoEvilMonkey": "\u1F649",
    "/heart": "\u2665",
    "/heartArrow": "\u1F498",
    "/heartDecoration": "\u1F49F",
    "/heartRibbon": "\u1F49D",
    "/heartTipOnTheLeft": "\u1F394",
    "/heartblack": "\u2665",
    "/heartsuitblack": "\u2665",
    "/heartsuitwhite": "\u2661",
    "/heartwhite": "\u2661",
    "/heavyDollarSign": "\u1F4B2",
    "/heavyLatinCross": "\u1F547",
    "/heavydbldashhorz": "\u254D",
    "/heavydbldashvert": "\u254F",
    "/heavydn": "\u257B",
    "/heavydnhorz": "\u2533",
    "/heavydnleft": "\u2513",
    "/heavydnright": "\u250F",
    "/heavyhorz": "\u2501",
    "/heavyleft": "\u2578",
    "/heavyleftlightright": "\u257E",
    "/heavyquaddashhorz": "\u2509",
    "/heavyquaddashvert": "\u250B",
    "/heavyright": "\u257A",
    "/heavytrpldashhorz": "\u2505",
    "/heavytrpldashvert": "\u2507",
    "/heavyup": "\u2579",
    "/heavyuphorz": "\u253B",
    "/heavyupleft": "\u251B",
    "/heavyuplightdn": "\u257F",
    "/heavyupright": "\u2517",
    "/heavyvert": "\u2503",
    "/heavyverthorz": "\u254B",
    "/heavyvertleft": "\u252B",
    "/heavyvertright": "\u2523",
    "/hecirclekatakana": "\u32EC",
    "/hedagesh": "\uFB34",
    "/hedageshhebrew": "\uFB34",
    "/hedinterlacedpentagramleft": "\u26E6",
    "/hedinterlacedpentagramright": "\u26E5",
    "/heh": "\u0647",
    "/heh.fina": "\uFEEA",
    "/heh.init": "\uFEEB",
    "/heh.init_alefmaksura.fina": "\uFC53",
    "/heh.init_jeem.fina": "\uFC51",
    "/heh.init_jeem.medi": "\uFCD7",
    "/heh.init_meem.fina": "\uFC52",
    "/heh.init_meem.medi": "\uFCD8",
    "/heh.init_meem.medi_jeem.medi": "\uFD93",
    "/heh.init_meem.medi_meem.medi": "\uFD94",
    "/heh.init_superscriptalef.medi": "\uFCD9",
    "/heh.init_yeh.fina": "\uFC54",
    "/heh.isol": "\uFEE9",
    "/heh.medi": "\uFEEC",
    "/hehaltonearabic": "\u06C1",
    "/heharabic": "\u0647",
    "/hehdoachashmee": "\u06BE",
    "/hehdoachashmee.fina": "\uFBAB",
    "/hehdoachashmee.init": "\uFBAC",
    "/hehdoachashmee.isol": "\uFBAA",
    "/hehdoachashmee.medi": "\uFBAD",
    "/hehebrew": "\u05D4",
    "/hehfinalaltonearabic": "\uFBA7",
    "/hehfinalalttwoarabic": "\uFEEA",
    "/hehfinalarabic": "\uFEEA",
    "/hehgoal": "\u06C1",
    "/hehgoal.fina": "\uFBA7",
    "/hehgoal.init": "\uFBA8",
    "/hehgoal.isol": "\uFBA6",
    "/hehgoal.medi": "\uFBA9",
    "/hehgoalhamza": "\u06C2",
    "/hehhamzaabovefinalarabic": "\uFBA5",
    "/hehhamzaaboveisolatedarabic": "\uFBA4",
    "/hehinitialaltonearabic": "\uFBA8",
    "/hehinitialarabic": "\uFEEB",
    "/hehinvertedV": "\u06FF",
    "/hehiragana": "\u3078",
    "/hehmedialaltonearabic": "\uFBA9",
    "/hehmedialarabic": "\uFEEC",
    "/hehyeh": "\u06C0",
    "/hehyeh.fina": "\uFBA5",
    "/hehyeh.isol": "\uFBA4",
    "/heiseierasquare": "\u337B",
    "/hekatakana": "\u30D8",
    "/hekatakanahalfwidth": "\uFF8D",
    "/hekutaarusquare": "\u3336",
    "/helicopter": "\u1F681",
    "/helm": "\u2388",
    "/helmetcrosswhite": "\u26D1",
    "/heng": "\uA727",
    "/henghook": "\u0267",
    "/herb": "\u1F33F",
    "/hermitianconjugatematrix": "\u22B9",
    "/herutusquare": "\u3339",
    "/het": "\u05D7",
    "/het:hb": "\u05D7",
    "/heta": "\u0371",
    "/hethebrew": "\u05D7",
    "/hewide:hb": "\uFB23",
    "/hewithmapiq:hb": "\uFB34",
    "/hfishhookturned": "\u02AE",
    "/hhalf": "\u2C76",
    "/hhook": "\u0266",
    "/hhooksuperior": "\u02B1",
    "/hhooksupmod": "\u02B1",
    "/hi-ressquare": "\u1F1A8",
    "/hibiscus": "\u1F33A",
    "/hicirclekatakana": "\u32EA",
    "/hieuhacirclekorean": "\u327B",
    "/hieuhaparenkorean": "\u321B",
    "/hieuhcirclekorean": "\u326D",
    "/hieuhkorean": "\u314E",
    "/hieuhparenkorean": "\u320D",
    "/high-heeledShoe": "\u1F460",
    "/highBrightness": "\u1F506",
    "/highSpeedTrain": "\u1F684",
    "/highSpeedTrainWithBulletNose": "\u1F685",
    "/highhamza": "\u0674",
    "/highideographiccircled": "\u32A4",
    "/highvoltage": "\u26A1",
    "/hihiragana": "\u3072",
    "/hikatakana": "\u30D2",
    "/hikatakanahalfwidth": "\uFF8B",
    "/hira:a": "\u3042",
    "/hira:asmall": "\u3041",
    "/hira:ba": "\u3070",
    "/hira:be": "\u3079",
    "/hira:bi": "\u3073",
    "/hira:bo": "\u307C",
    "/hira:bu": "\u3076",
    "/hira:da": "\u3060",
    "/hira:de": "\u3067",
    "/hira:di": "\u3062",
    "/hira:digraphyori": "\u309F",
    "/hira:do": "\u3069",
    "/hira:du": "\u3065",
    "/hira:e": "\u3048",
    "/hira:esmall": "\u3047",
    "/hira:ga": "\u304C",
    "/hira:ge": "\u3052",
    "/hira:gi": "\u304E",
    "/hira:go": "\u3054",
    "/hira:gu": "\u3050",
    "/hira:ha": "\u306F",
    "/hira:he": "\u3078",
    "/hira:hi": "\u3072",
    "/hira:ho": "\u307B",
    "/hira:hu": "\u3075",
    "/hira:i": "\u3044",
    "/hira:ismall": "\u3043",
    "/hira:iterationhiragana": "\u309D",
    "/hira:ka": "\u304B",
    "/hira:kasmall": "\u3095",
    "/hira:ke": "\u3051",
    "/hira:kesmall": "\u3096",
    "/hira:ki": "\u304D",
    "/hira:ko": "\u3053",
    "/hira:ku": "\u304F",
    "/hira:ma": "\u307E",
    "/hira:me": "\u3081",
    "/hira:mi": "\u307F",
    "/hira:mo": "\u3082",
    "/hira:mu": "\u3080",
    "/hira:n": "\u3093",
    "/hira:na": "\u306A",
    "/hira:ne": "\u306D",
    "/hira:ni": "\u306B",
    "/hira:no": "\u306E",
    "/hira:nu": "\u306C",
    "/hira:o": "\u304A",
    "/hira:osmall": "\u3049",
    "/hira:pa": "\u3071",
    "/hira:pe": "\u307A",
    "/hira:pi": "\u3074",
    "/hira:po": "\u307D",
    "/hira:pu": "\u3077",
    "/hira:ra": "\u3089",
    "/hira:re": "\u308C",
    "/hira:ri": "\u308A",
    "/hira:ro": "\u308D",
    "/hira:ru": "\u308B",
    "/hira:sa": "\u3055",
    "/hira:se": "\u305B",
    "/hira:semivoicedmarkkana": "\u309C",
    "/hira:semivoicedmarkkanacmb": "\u309A",
    "/hira:si": "\u3057",
    "/hira:so": "\u305D",
    "/hira:su": "\u3059",
    "/hira:ta": "\u305F",
    "/hira:te": "\u3066",
    "/hira:ti": "\u3061",
    "/hira:to": "\u3068",
    "/hira:tu": "\u3064",
    "/hira:tusmall": "\u3063",
    "/hira:u": "\u3046",
    "/hira:usmall": "\u3045",
    "/hira:voicediterationhiragana": "\u309E",
    "/hira:voicedmarkkana": "\u309B",
    "/hira:voicedmarkkanacmb": "\u3099",
    "/hira:vu": "\u3094",
    "/hira:wa": "\u308F",
    "/hira:wasmall": "\u308E",
    "/hira:we": "\u3091",
    "/hira:wi": "\u3090",
    "/hira:wo": "\u3092",
    "/hira:ya": "\u3084",
    "/hira:yasmall": "\u3083",
    "/hira:yo": "\u3088",
    "/hira:yosmall": "\u3087",
    "/hira:yu": "\u3086",
    "/hira:yusmall": "\u3085",
    "/hira:za": "\u3056",
    "/hira:ze": "\u305C",
    "/hira:zi": "\u3058",
    "/hira:zo": "\u305E",
    "/hira:zu": "\u305A",
    "/hiriq": "\u05B4",
    "/hiriq14": "\u05B4",
    "/hiriq21": "\u05B4",
    "/hiriq2d": "\u05B4",
    "/hiriq:hb": "\u05B4",
    "/hiriqhebrew": "\u05B4",
    "/hiriqnarrowhebrew": "\u05B4",
    "/hiriqquarterhebrew": "\u05B4",
    "/hiriqwidehebrew": "\u05B4",
    "/historicsite": "\u26EC",
    "/hlinebelow": "\u1E96",
    "/hmonospace": "\uFF48",
    "/hoarmenian": "\u0570",
    "/hocho": "\u1F52A",
    "/hocirclekatakana": "\u32ED",
    "/hohipthai": "\u0E2B",
    "/hohiragana": "\u307B",
    "/hokatakana": "\u30DB",
    "/hokatakanahalfwidth": "\uFF8E",
    "/holam": "\u05B9",
    "/holam19": "\u05B9",
    "/holam26": "\u05B9",
    "/holam32": "\u05B9",
    "/holam:hb": "\u05B9",
    "/holamHaser:hb": "\u05BA",
    "/holamhebrew": "\u05B9",
    "/holamnarrowhebrew": "\u05B9",
    "/holamquarterhebrew": "\u05B9",
    "/holamwidehebrew": "\u05B9",
    "/hole": "\u1F573",
    "/homotic": "\u223B",
    "/honeyPot": "\u1F36F",
    "/honeybee": "\u1F41D",
    "/honokhukthai": "\u0E2E",
    "/honsquare": "\u333F",
    "/hook": "\u2440",
    "/hookabovecomb": "\u0309",
    "/hookcmb": "\u0309",
    "/hookpalatalizedbelowcmb": "\u0321",
    "/hookretroflexbelowcmb": "\u0322",
    "/hoonsquare": "\u3342",
    "/hoorusquare": "\u3341",
    "/horicoptic": "\u03E9",
    "/horizontalTrafficLight": "\u1F6A5",
    "/horizontalbar": "\u2015",
    "/horizontalbarwhitearrowonpedestalup": "\u21EC",
    "/horizontalmalestroke": "\u26A9",
    "/horncmb": "\u031B",
    "/horse": "\u1F40E",
    "/horseFace": "\u1F434",
    "/horseRacing": "\u1F3C7",
    "/hospital": "\u1F3E5",
    "/hotDog": "\u1F32D",
    "/hotPepper": "\u1F336",
    "/hotbeverage": "\u2615",
    "/hotel": "\u1F3E8",
    "/hotsprings": "\u2668",
    "/hourglass": "\u231B",
    "/hourglassflowings": "\u23F3",
    "/house": "\u2302",
    "/houseBuilding": "\u1F3E0",
    "/houseBuildings": "\u1F3D8",
    "/houseGarden": "\u1F3E1",
    "/hpafullwidth": "\u3371",
    "/hpalatalhook": "\uA795",
    "/hparen": "\u24A3",
    "/hparenthesized": "\u24A3",
    "/hpfullwidth": "\u33CB",
    "/hryvnia": "\u20B4",
    "/hsuperior": "\u02B0",
    "/hsupmod": "\u02B0",
    "/hturned": "\u0265",
    "/htypeopencircuit": "\u238F",
    "/huaraddosquare": "\u3332",
    "/hucirclekatakana": "\u32EB",
    "/huhiragana": "\u3075",
    "/huiitosquare": "\u3333",
    "/hukatakana": "\u30D5",
    "/hukatakanahalfwidth": "\uFF8C",
    "/hundredPoints": "\u1F4AF",
    "/hundredthousandscmbcyr": "\u0488",
    "/hungarumlaut": "\u02DD",
    "/hungarumlautcmb": "\u030B",
    "/huransquare": "\u3335",
    "/hushedFace": "\u1F62F",
    "/hv": "\u0195",
    "/hwd:a": "\uFFC2",
    "/hwd:ae": "\uFFC3",
    "/hwd:blacksquare": "\uFFED",
    "/hwd:chieuch": "\uFFBA",
    "/hwd:cieuc": "\uFFB8",
    "/hwd:downwardsarrow": "\uFFEC",
    "/hwd:e": "\uFFC7",
    "/hwd:eo": "\uFFC6",
    "/hwd:eu": "\uFFDA",
    "/hwd:formslightvertical": "\uFFE8",
    "/hwd:hangulfiller": "\uFFA0",
    "/hwd:hieuh": "\uFFBE",
    "/hwd:i": "\uFFDC",
    "/hwd:ideographiccomma": "\uFF64",
    "/hwd:ideographicfullstop": "\uFF61",
    "/hwd:ieung": "\uFFB7",
    "/hwd:kata:a": "\uFF71",
    "/hwd:kata:asmall": "\uFF67",
    "/hwd:kata:e": "\uFF74",
    "/hwd:kata:esmall": "\uFF6A",
    "/hwd:kata:ha": "\uFF8A",
    "/hwd:kata:he": "\uFF8D",
    "/hwd:kata:hi": "\uFF8B",
    "/hwd:kata:ho": "\uFF8E",
    "/hwd:kata:hu": "\uFF8C",
    "/hwd:kata:i": "\uFF72",
    "/hwd:kata:ismall": "\uFF68",
    "/hwd:kata:ka": "\uFF76",
    "/hwd:kata:ke": "\uFF79",
    "/hwd:kata:ki": "\uFF77",
    "/hwd:kata:ko": "\uFF7A",
    "/hwd:kata:ku": "\uFF78",
    "/hwd:kata:ma": "\uFF8F",
    "/hwd:kata:me": "\uFF92",
    "/hwd:kata:mi": "\uFF90",
    "/hwd:kata:middledot": "\uFF65",
    "/hwd:kata:mo": "\uFF93",
    "/hwd:kata:mu": "\uFF91",
    "/hwd:kata:n": "\uFF9D",
    "/hwd:kata:na": "\uFF85",
    "/hwd:kata:ne": "\uFF88",
    "/hwd:kata:ni": "\uFF86",
    "/hwd:kata:no": "\uFF89",
    "/hwd:kata:nu": "\uFF87",
    "/hwd:kata:o": "\uFF75",
    "/hwd:kata:osmall": "\uFF6B",
    "/hwd:kata:prolongedkana": "\uFF70",
    "/hwd:kata:ra": "\uFF97",
    "/hwd:kata:re": "\uFF9A",
    "/hwd:kata:ri": "\uFF98",
    "/hwd:kata:ro": "\uFF9B",
    "/hwd:kata:ru": "\uFF99",
    "/hwd:kata:sa": "\uFF7B",
    "/hwd:kata:se": "\uFF7E",
    "/hwd:kata:semi-voiced": "\uFF9F",
    "/hwd:kata:si": "\uFF7C",
    "/hwd:kata:so": "\uFF7F",
    "/hwd:kata:su": "\uFF7D",
    "/hwd:kata:ta": "\uFF80",
    "/hwd:kata:te": "\uFF83",
    "/hwd:kata:ti": "\uFF81",
    "/hwd:kata:to": "\uFF84",
    "/hwd:kata:tu": "\uFF82",
    "/hwd:kata:tusmall": "\uFF6F",
    "/hwd:kata:u": "\uFF73",
    "/hwd:kata:usmall": "\uFF69",
    "/hwd:kata:voiced": "\uFF9E",
    "/hwd:kata:wa": "\uFF9C",
    "/hwd:kata:wo": "\uFF66",
    "/hwd:kata:ya": "\uFF94",
    "/hwd:kata:yasmall": "\uFF6C",
    "/hwd:kata:yo": "\uFF96",
    "/hwd:kata:yosmall": "\uFF6E",
    "/hwd:kata:yu": "\uFF95",
    "/hwd:kata:yusmall": "\uFF6D",
    "/hwd:khieukh": "\uFFBB",
    "/hwd:kiyeok": "\uFFA1",
    "/hwd:kiyeoksios": "\uFFA3",
    "/hwd:leftcornerbracket": "\uFF62",
    "/hwd:leftwardsarrow": "\uFFE9",
    "/hwd:mieum": "\uFFB1",
    "/hwd:nieun": "\uFFA4",
    "/hwd:nieuncieuc": "\uFFA5",
    "/hwd:nieunhieuh": "\uFFA6",
    "/hwd:o": "\uFFCC",
    "/hwd:oe": "\uFFCF",
    "/hwd:phieuph": "\uFFBD",
    "/hwd:pieup": "\uFFB2",
    "/hwd:pieupsios": "\uFFB4",
    "/hwd:rieul": "\uFFA9",
    "/hwd:rieulhieuh": "\uFFB0",
    "/hwd:rieulkiyeok": "\uFFAA",
    "/hwd:rieulmieum": "\uFFAB",
    "/hwd:rieulphieuph": "\uFFAF",
    "/hwd:rieulpieup": "\uFFAC",
    "/hwd:rieulsios": "\uFFAD",
    "/hwd:rieulthieuth": "\uFFAE",
    "/hwd:rightcornerbracket": "\uFF63",
    "/hwd:rightwardsarrow": "\uFFEB",
    "/hwd:sios": "\uFFB5",
    "/hwd:ssangcieuc": "\uFFB9",
    "/hwd:ssangkiyeok": "\uFFA2",
    "/hwd:ssangpieup": "\uFFB3",
    "/hwd:ssangsios": "\uFFB6",
    "/hwd:ssangtikeut": "\uFFA8",
    "/hwd:thieuth": "\uFFBC",
    "/hwd:tikeut": "\uFFA7",
    "/hwd:u": "\uFFD3",
    "/hwd:upwardsarrow": "\uFFEA",
    "/hwd:wa": "\uFFCD",
    "/hwd:wae": "\uFFCE",
    "/hwd:we": "\uFFD5",
    "/hwd:weo": "\uFFD4",
    "/hwd:whitecircle": "\uFFEE",
    "/hwd:wi": "\uFFD6",
    "/hwd:ya": "\uFFC4",
    "/hwd:yae": "\uFFC5",
    "/hwd:ye": "\uFFCB",
    "/hwd:yeo": "\uFFCA",
    "/hwd:yi": "\uFFDB",
    "/hwd:yo": "\uFFD2",
    "/hwd:yu": "\uFFD7",
    "/hyphen": "\u002D",
    "/hyphenationpoint": "\u2027",
    "/hyphenbullet": "\u2043",
    "/hyphendbl": "\u2E40",
    "/hyphendbloblique": "\u2E17",
    "/hyphendieresis": "\u2E1A",
    "/hypheninferior": "\uF6E5",
    "/hyphenminus": "\u002D",
    "/hyphenmonospace": "\uFF0D",
    "/hyphensmall": "\uFE63",
    "/hyphensoft": "\u00AD",
    "/hyphensuperior": "\uF6E6",
    "/hyphentwo": "\u2010",
    "/hypodiastole": "\u2E12",
    "/hysteresis": "\u238E",
    "/hzfullwidth": "\u3390",
    "/i": "\u0069",
    "/i.superior": "\u2071",
    "/iacute": "\u00ED",
    "/iacyrillic": "\u044F",
    "/iaepigraphic": "\uA7FE",
    "/ibengali": "\u0987",
    "/ibopomofo": "\u3127",
    "/ibreve": "\u012D",
    "/icaron": "\u01D0",
    "/iceCream": "\u1F368",
    "/iceHockeyStickAndPuck": "\u1F3D2",
    "/iceskate": "\u26F8",
    "/icircle": "\u24D8",
    "/icirclekatakana": "\u32D1",
    "/icircumflex": "\u00EE",
    "/icyr": "\u0438",
    "/icyrillic": "\u0456",
    "/idblgrave": "\u0209",
    "/idblstruckitalic": "\u2148",
    "/ideographearthcircle": "\u328F",
    "/ideographfirecircle": "\u328B",
    "/ideographicallianceparen": "\u323F",
    "/ideographiccallparen": "\u323A",
    "/ideographiccentrecircle": "\u32A5",
    "/ideographicclose": "\u3006",
    "/ideographiccomma": "\u3001",
    "/ideographiccommaleft": "\uFF64",
    "/ideographiccongratulationparen": "\u3237",
    "/ideographiccorrectcircle": "\u32A3",
    "/ideographicdepartingtonemark": "\u302C",
    "/ideographicearthparen": "\u322F",
    "/ideographicenteringtonemark": "\u302D",
    "/ideographicenterpriseparen": "\u323D",
    "/ideographicexcellentcircle": "\u329D",
    "/ideographicfestivalparen": "\u3240",
    "/ideographicfinancialcircle": "\u3296",
    "/ideographicfinancialparen": "\u3236",
    "/ideographicfireparen": "\u322B",
    "/ideographichalffillspace": "\u303F",
    "/ideographichaveparen": "\u3232",
    "/ideographichighcircle": "\u32A4",
    "/ideographiciterationmark": "\u3005",
    "/ideographiclaborcircle": "\u3298",
    "/ideographiclaborparen": "\u3238",
    "/ideographicleftcircle": "\u32A7",
    "/ideographicleveltonemark": "\u302A",
    "/ideographiclowcircle": "\u32A6",
    "/ideographicmedicinecircle": "\u32A9",
    "/ideographicmetalparen": "\u322E",
    "/ideographicmoonparen": "\u322A",
    "/ideographicnameparen": "\u3234",
    "/ideographicperiod": "\u3002",
    "/ideographicprintcircle": "\u329E",
    "/ideographicreachparen": "\u3243",
    "/ideographicrepresentparen": "\u3239",
    "/ideographicresourceparen": "\u323E",
    "/ideographicrightcircle": "\u32A8",
    "/ideographicrisingtonemark": "\u302B",
    "/ideographicsecretcircle": "\u3299",
    "/ideographicselfparen": "\u3242",
    "/ideographicsocietyparen": "\u3233",
    "/ideographicspace": "\u3000",
    "/ideographicspecialparen": "\u3235",
    "/ideographicstockparen": "\u3231",
    "/ideographicstudyparen": "\u323B",
    "/ideographicsunparen": "\u3230",
    "/ideographicsuperviseparen": "\u323C",
    "/ideographictelegraphlinefeedseparatorsymbol": "\u3037",
    "/ideographictelegraphsymbolforhoureight": "\u3360",
    "/ideographictelegraphsymbolforhoureighteen": "\u336A",
    "/ideographictelegraphsymbolforhoureleven": "\u3363",
    "/ideographictelegraphsymbolforhourfifteen": "\u3367",
    "/ideographictelegraphsymbolforhourfive": "\u335D",
    "/ideographictelegraphsymbolforhourfour": "\u335C",
    "/ideographictelegraphsymbolforhourfourteen": "\u3366",
    "/ideographictelegraphsymbolforhournine": "\u3361",
    "/ideographictelegraphsymbolforhournineteen": "\u336B",
    "/ideographictelegraphsymbolforhourone": "\u3359",
    "/ideographictelegraphsymbolforhourseven": "\u335F",
    "/ideographictelegraphsymbolforhourseventeen": "\u3369",
    "/ideographictelegraphsymbolforhoursix": "\u335E",
    "/ideographictelegraphsymbolforhoursixteen": "\u3368",
    "/ideographictelegraphsymbolforhourten": "\u3362",
    "/ideographictelegraphsymbolforhourthirteen": "\u3365",
    "/ideographictelegraphsymbolforhourthree": "\u335B",
    "/ideographictelegraphsymbolforhourtwelve": "\u3364",
    "/ideographictelegraphsymbolforhourtwenty": "\u336C",
    "/ideographictelegraphsymbolforhourtwentyfour": "\u3370",
    "/ideographictelegraphsymbolforhourtwentyone": "\u336D",
    "/ideographictelegraphsymbolforhourtwentythree": "\u336F",
    "/ideographictelegraphsymbolforhourtwentytwo": "\u336E",
    "/ideographictelegraphsymbolforhourtwo": "\u335A",
    "/ideographictelegraphsymbolforhourzero": "\u3358",
    "/ideographicvariationindicator": "\u303E",
    "/ideographicwaterparen": "\u322C",
    "/ideographicwoodparen": "\u322D",
    "/ideographiczero": "\u3007",
    "/ideographmetalcircle": "\u328E",
    "/ideographmooncircle": "\u328A",
    "/ideographnamecircle": "\u3294",
    "/ideographsuncircle": "\u3290",
    "/ideographwatercircle": "\u328C",
    "/ideographwoodcircle": "\u328D",
    "/ideva": "\u0907",
    "/idieresis": "\u00EF",
    "/idieresisacute": "\u1E2F",
    "/idieresiscyr": "\u04E5",
    "/idieresiscyrillic": "\u04E5",
    "/idotbelow": "\u1ECB",
    "/idsquare": "\u1F194",
    "/iebrevecyr": "\u04D7",
    "/iebrevecyrillic": "\u04D7",
    "/iecyr": "\u0435",
    "/iecyrillic": "\u0435",
    "/iegravecyr": "\u0450",
    "/iepigraphicsideways": "\uA7F7",
    "/ieungacirclekorean": "\u3275",
    "/ieungaparenkorean": "\u3215",
    "/ieungcirclekorean": "\u3267",
    "/ieungkorean": "\u3147",
    "/ieungparenkorean": "\u3207",
    "/ieungucirclekorean": "\u327E",
    "/igrave": "\u00EC",
    "/igravecyr": "\u045D",
    "/igravedbl": "\u0209",
    "/igujarati": "\u0A87",
    "/igurmukhi": "\u0A07",
    "/ihiragana": "\u3044",
    "/ihoi": "\u1EC9",
    "/ihookabove": "\u1EC9",
    "/iibengali": "\u0988",
    "/iicyrillic": "\u0438",
    "/iideva": "\u0908",
    "/iigujarati": "\u0A88",
    "/iigurmukhi": "\u0A08",
    "/iimatragurmukhi": "\u0A40",
    "/iinvertedbreve": "\u020B",
    "/iishortcyrillic": "\u0439",
    "/iivowelsignbengali": "\u09C0",
    "/iivowelsigndeva": "\u0940",
    "/iivowelsigngujarati": "\u0AC0",
    "/ij": "\u0133",
    "/ikatakana": "\u30A4",
    "/ikatakanahalfwidth": "\uFF72",
    "/ikawi": "\uA985",
    "/ikorean": "\u3163",
    "/ilde": "\u02DC",
    "/iluy:hb": "\u05AC",
    "/iluyhebrew": "\u05AC",
    "/imacron": "\u012B",
    "/imacroncyr": "\u04E3",
    "/imacroncyrillic": "\u04E3",
    "/image": "\u22B7",
    "/imageorapproximatelyequal": "\u2253",
    "/imatragurmukhi": "\u0A3F",
    "/imonospace": "\uFF49",
    "/imp": "\u1F47F",
    "/inboxTray": "\u1F4E5",
    "/incomingEnvelope": "\u1F4E8",
    "/increaseFontSize": "\u1F5DA",
    "/increment": "\u2206",
    "/indianrupee": "\u20B9",
    "/infinity": "\u221E",
    "/information": "\u2139",
    "/infullwidth": "\u33CC",
    "/inhibitarabicformshaping": "\u206C",
    "/inhibitsymmetricswapping": "\u206A",
    "/iniarmenian": "\u056B",
    "/iningusquare": "\u3304",
    "/inmationDeskPerson": "\u1F481",
    "/inputLatinCapitalLetters": "\u1F520",
    "/inputLatinLetters": "\u1F524",
    "/inputLatinSmallLetters": "\u1F521",
    "/inputNumbers": "\u1F522",
    "/inputS": "\u1F523",
    "/insertion": "\u2380",
    "/integral": "\u222B",
    "/integralbottom": "\u2321",
    "/integralbt": "\u2321",
    "/integralclockwise": "\u2231",
    "/integralcontour": "\u222E",
    "/integralcontouranticlockwise": "\u2233",
    "/integralcontourclockwise": "\u2232",
    "/integraldbl": "\u222C",
    "/integralex": "\uF8F5",
    "/integralextension": "\u23AE",
    "/integralsurface": "\u222F",
    "/integraltop": "\u2320",
    "/integraltp": "\u2320",
    "/integraltpl": "\u222D",
    "/integralvolume": "\u2230",
    "/intercalate": "\u22BA",
    "/interlinearanchor": "\uFFF9",
    "/interlinearseparator": "\uFFFA",
    "/interlinearterminator": "\uFFFB",
    "/interlockedfemalemale": "\u26A4",
    "/interrobang": "\u203D",
    "/interrobanginverted": "\u2E18",
    "/intersection": "\u2229",
    "/intersectionarray": "\u22C2",
    "/intersectiondbl": "\u22D2",
    "/intisquare": "\u3305",
    "/invbullet": "\u25D8",
    "/invcircle": "\u25D9",
    "/inverteddamma": "\u0657",
    "/invertedfork": "\u2443",
    "/invertedpentagram": "\u26E7",
    "/invertedundertie": "\u2054",
    "/invisibleplus": "\u2064",
    "/invisibleseparator": "\u2063",
    "/invisibletimes": "\u2062",
    "/invsmileface": "\u263B",
    "/iocyr": "\u0451",
    "/iocyrillic": "\u0451",
    "/iogonek": "\u012F",
    "/iota": "\u03B9",
    "/iotaacute": "\u1F77",
    "/iotaadscript": "\u1FBE",
    "/iotaasper": "\u1F31",
    "/iotaasperacute": "\u1F35",
    "/iotaaspergrave": "\u1F33",
    "/iotaaspertilde": "\u1F37",
    "/iotabreve": "\u1FD0",
    "/iotadieresis": "\u03CA",
    "/iotadieresisacute": "\u1FD3",
    "/iotadieresisgrave": "\u1FD2",
    "/iotadieresistilde": "\u1FD7",
    "/iotadieresistonos": "\u0390",
    "/iotafunc": "\u2373",
    "/iotagrave": "\u1F76",
    "/iotalatin": "\u0269",
    "/iotalenis": "\u1F30",
    "/iotalenisacute": "\u1F34",
    "/iotalenisgrave": "\u1F32",
    "/iotalenistilde": "\u1F36",
    "/iotasub": "\u037A",
    "/iotatilde": "\u1FD6",
    "/iotatonos": "\u03AF",
    "/iotaturned": "\u2129",
    "/iotaunderlinefunc": "\u2378",
    "/iotawithmacron": "\u1FD1",
    "/ipa:Ismall": "\u026A",
    "/ipa:alpha": "\u0251",
    "/ipa:ereversed": "\u0258",
    "/ipa:esh": "\u0283",
    "/ipa:gamma": "\u0263",
    "/ipa:glottalstop": "\u0294",
    "/ipa:gscript": "\u0261",
    "/ipa:iota": "\u0269",
    "/ipa:phi": "\u0278",
    "/ipa:rtail": "\u027D",
    "/ipa:schwa": "\u0259",
    "/ipa:upsilon": "\u028A",
    "/iparen": "\u24A4",
    "/iparenthesized": "\u24A4",
    "/irigurmukhi": "\u0A72",
    "/is": "\uA76D",
    "/isen-isenpada": "\uA9DF",
    "/ishortcyr": "\u0439",
    "/ishortsharptailcyr": "\u048B",
    "/ismallhiragana": "\u3043",
    "/ismallkatakana": "\u30A3",
    "/ismallkatakanahalfwidth": "\uFF68",
    "/issharbengali": "\u09FA",
    "/istroke": "\u0268",
    "/isuperior": "\uF6ED",
    "/itemideographiccircled": "\u32A0",
    "/iterationhiragana": "\u309D",
    "/iterationkatakana": "\u30FD",
    "/itilde": "\u0129",
    "/itildebelow": "\u1E2D",
    "/iubopomofo": "\u3129",
    "/iucyrillic": "\u044E",
    "/iufullwidth": "\u337A",
    "/iukrcyr": "\u0456",
    "/ivowelsignbengali": "\u09BF",
    "/ivowelsigndeva": "\u093F",
    "/ivowelsigngujarati": "\u0ABF",
    "/izakayaLantern": "\u1F3EE",
    "/izhitsacyr": "\u0475",
    "/izhitsacyrillic": "\u0475",
    "/izhitsadblgravecyrillic": "\u0477",
    "/izhitsagravedblcyr": "\u0477",
    "/j": "\u006A",
    "/j.inferior": "\u2C7C",
    "/jaarmenian": "\u0571",
    "/jabengali": "\u099C",
    "/jackOLantern": "\u1F383",
    "/jadeva": "\u091C",
    "/jagujarati": "\u0A9C",
    "/jagurmukhi": "\u0A1C",
    "/jamahaprana": "\uA999",
    "/januarytelegraph": "\u32C0",
    "/japaneseBeginner": "\u1F530",
    "/japaneseCastle": "\u1F3EF",
    "/japaneseDolls": "\u1F38E",
    "/japaneseGoblin": "\u1F47A",
    "/japaneseOgre": "\u1F479",
    "/japanesePostOffice": "\u1F3E3",
    "/japanesebank": "\u26FB",
    "/java:a": "\uA984",
    "/java:ai": "\uA98D",
    "/java:ba": "\uA9A7",
    "/java:ca": "\uA995",
    "/java:da": "\uA9A2",
    "/java:dda": "\uA99D",
    "/java:e": "\uA98C",
    "/java:eight": "\uA9D8",
    "/java:five": "\uA9D5",
    "/java:four": "\uA9D4",
    "/java:ga": "\uA992",
    "/java:ha": "\uA9B2",
    "/java:i": "\uA986",
    "/java:ii": "\uA987",
    "/java:ja": "\uA997",
    "/java:ka": "\uA98F",
    "/java:la": "\uA9AD",
    "/java:ma": "\uA9A9",
    "/java:na": "\uA9A4",
    "/java:nga": "\uA994",
    "/java:nine": "\uA9D9",
    "/java:nya": "\uA99A",
    "/java:o": "\uA98E",
    "/java:one": "\uA9D1",
    "/java:pa": "\uA9A5",
    "/java:ra": "\uA9AB",
    "/java:sa": "\uA9B1",
    "/java:seven": "\uA9D7",
    "/java:six": "\uA9D6",
    "/java:ta": "\uA9A0",
    "/java:three": "\uA9D3",
    "/java:tta": "\uA99B",
    "/java:two": "\uA9D2",
    "/java:u": "\uA988",
    "/java:wa": "\uA9AE",
    "/java:ya": "\uA9AA",
    "/java:zero": "\uA9D0",
    "/jbopomofo": "\u3110",
    "/jcaron": "\u01F0",
    "/jcircle": "\u24D9",
    "/jcircumflex": "\u0135",
    "/jcrossedtail": "\u029D",
    "/jdblstruckitalic": "\u2149",
    "/jdotlessstroke": "\u025F",
    "/jeans": "\u1F456",
    "/jecyr": "\u0458",
    "/jecyrillic": "\u0458",
    "/jeem": "\u062C",
    "/jeem.fina": "\uFE9E",
    "/jeem.init": "\uFE9F",
    "/jeem.init_alefmaksura.fina": "\uFD01",
    "/jeem.init_hah.fina": "\uFC15",
    "/jeem.init_hah.medi": "\uFCA7",
    "/jeem.init_meem.fina": "\uFC16",
    "/jeem.init_meem.medi": "\uFCA8",
    "/jeem.init_meem.medi_hah.medi": "\uFD59",
    "/jeem.init_yeh.fina": "\uFD02",
    "/jeem.isol": "\uFE9D",
    "/jeem.medi": "\uFEA0",
    "/jeem.medi_alefmaksura.fina": "\uFD1D",
    "/jeem.medi_hah.medi_alefmaksura.fina": "\uFDA6",
    "/jeem.medi_hah.medi_yeh.fina": "\uFDBE",
    "/jeem.medi_meem.medi_alefmaksura.fina": "\uFDA7",
    "/jeem.medi_meem.medi_hah.fina": "\uFD58",
    "/jeem.medi_meem.medi_yeh.fina": "\uFDA5",
    "/jeem.medi_yeh.fina": "\uFD1E",
    "/jeemabove": "\u06DA",
    "/jeemarabic": "\u062C",
    "/jeemfinalarabic": "\uFE9E",
    "/jeeminitialarabic": "\uFE9F",
    "/jeemmedialarabic": "\uFEA0",
    "/jeh": "\u0698",
    "/jeh.fina": "\uFB8B",
    "/jeh.isol": "\uFB8A",
    "/jeharabic": "\u0698",
    "/jehfinalarabic": "\uFB8B",
    "/jhabengali": "\u099D",
    "/jhadeva": "\u091D",
    "/jhagujarati": "\u0A9D",
    "/jhagurmukhi": "\u0A1D",
    "/jheharmenian": "\u057B",
    "/jis": "\u3004",
    "/jiterup": "\u2643",
    "/jmonospace": "\uFF4A",
    "/jotdiaeresisfunc": "\u2364",
    "/jotunderlinefunc": "\u235B",
    "/joystick": "\u1F579",
    "/jparen": "\u24A5",
    "/jparenthesized": "\u24A5",
    "/jstroke": "\u0249",
    "/jsuperior": "\u02B2",
    "/jsupmod": "\u02B2",
    "/jueuicircle": "\u327D",
    "/julytelegraph": "\u32C6",
    "/junetelegraph": "\u32C5",
    "/juno": "\u26B5",
    "/k": "\u006B",
    "/k.inferior": "\u2096",
    "/kaaba": "\u1F54B",
    "/kaaleutcyr": "\u051F",
    "/kabashkcyr": "\u04A1",
    "/kabashkircyrillic": "\u04A1",
    "/kabengali": "\u0995",
    "/kacirclekatakana": "\u32D5",
    "/kacute": "\u1E31",
    "/kacyr": "\u043A",
    "/kacyrillic": "\u043A",
    "/kadescendercyrillic": "\u049B",
    "/kadeva": "\u0915",
    "/kaf": "\u05DB",
    "/kaf.fina": "\uFEDA",
    "/kaf.init": "\uFEDB",
    "/kaf.init_alef.fina": "\uFC37",
    "/kaf.init_alefmaksura.fina": "\uFC3D",
    "/kaf.init_hah.fina": "\uFC39",
    "/kaf.init_hah.medi": "\uFCC5",
    "/kaf.init_jeem.fina": "\uFC38",
    "/kaf.init_jeem.medi": "\uFCC4",
    "/kaf.init_khah.fina": "\uFC3A",
    "/kaf.init_khah.medi": "\uFCC6",
    "/kaf.init_lam.fina": "\uFC3B",
    "/kaf.init_lam.medi": "\uFCC7",
    "/kaf.init_meem.fina": "\uFC3C",
    "/kaf.init_meem.medi": "\uFCC8",
    "/kaf.init_meem.medi_meem.medi": "\uFDC3",
    "/kaf.init_yeh.fina": "\uFC3E",
    "/kaf.isol": "\uFED9",
    "/kaf.medi": "\uFEDC",
    "/kaf.medi_alef.fina": "\uFC80",
    "/kaf.medi_alefmaksura.fina": "\uFC83",
    "/kaf.medi_lam.fina": "\uFC81",
    "/kaf.medi_lam.medi": "\uFCEB",
    "/kaf.medi_meem.fina": "\uFC82",
    "/kaf.medi_meem.medi": "\uFCEC",
    "/kaf.medi_meem.medi_meem.fina": "\uFDBB",
    "/kaf.medi_meem.medi_yeh.fina": "\uFDB7",
    "/kaf.medi_yeh.fina": "\uFC84",
    "/kaf:hb": "\u05DB",
    "/kafTwoDotsAbove": "\u077F",
    "/kafarabic": "\u0643",
    "/kafdagesh": "\uFB3B",
    "/kafdageshhebrew": "\uFB3B",
    "/kafdotabove": "\u06AC",
    "/kaffinalarabic": "\uFEDA",
    "/kafhebrew": "\u05DB",
    "/kafinitialarabic": "\uFEDB",
    "/kafmedialarabic": "\uFEDC",
    "/kafrafehebrew": "\uFB4D",
    "/kafring": "\u06AB",
    "/kafswash": "\u06AA",
    "/kafthreedotsbelow": "\u06AE",
    "/kafullwidth": "\u3384",
    "/kafwide:hb": "\uFB24",
    "/kafwithdagesh:hb": "\uFB3B",
    "/kafwithrafe:hb": "\uFB4D",
    "/kagujarati": "\u0A95",
    "/kagurmukhi": "\u0A15",
    "/kahiragana": "\u304B",
    "/kahookcyr": "\u04C4",
    "/kahookcyrillic": "\u04C4",
    "/kairisquare": "\u330B",
    "/kaisymbol": "\u03D7",
    "/kakatakana": "\u30AB",
    "/kakatakanahalfwidth": "\uFF76",
    "/kamurda": "\uA991",
    "/kappa": "\u03BA",
    "/kappa.math": "\u03F0",
    "/kappasymbolgreek": "\u03F0",
    "/kapyeounmieumkorean": "\u3171",
    "/kapyeounphieuphkorean": "\u3184",
    "/kapyeounpieupkorean": "\u3178",
    "/kapyeounssangpieupkorean": "\u3179",
    "/karattosquare": "\u330C",
    "/karoriisquare": "\u330D",
    "/kasasak": "\uA990",
    "/kashida": "\u0640",
    "/kashidaFina": "\uFE73",
    "/kashidaautoarabic": "\u0640",
    "/kashidaautonosidebearingarabic": "\u0640",
    "/kashmiriyeh": "\u0620",
    "/kasmallkatakana": "\u30F5",
    "/kasquare": "\u3384",
    "/kasra": "\u0650",
    "/kasraIsol": "\uFE7A",
    "/kasraMedi": "\uFE7B",
    "/kasraarabic": "\u0650",
    "/kasrasmall": "\u061A",
    "/kasratan": "\u064D",
    "/kasratanIsol": "\uFE74",
    "/kasratanarabic": "\u064D",
    "/kastrokecyr": "\u049F",
    "/kastrokecyrillic": "\u049F",
    "/kata:a": "\u30A2",
    "/kata:asmall": "\u30A1",
    "/kata:ba": "\u30D0",
    "/kata:be": "\u30D9",
    "/kata:bi": "\u30D3",
    "/kata:bo": "\u30DC",
    "/kata:bu": "\u30D6",
    "/kata:da": "\u30C0",
    "/kata:de": "\u30C7",
    "/kata:di": "\u30C2",
    "/kata:digraphkoto": "\u30FF",
    "/kata:do": "\u30C9",
    "/kata:doublehyphenkana": "\u30A0",
    "/kata:du": "\u30C5",
    "/kata:e": "\u30A8",
    "/kata:esmall": "\u30A7",
    "/kata:ga": "\u30AC",
    "/kata:ge": "\u30B2",
    "/kata:gi": "\u30AE",
    "/kata:go": "\u30B4",
    "/kata:gu": "\u30B0",
    "/kata:ha": "\u30CF",
    "/kata:he": "\u30D8",
    "/kata:hi": "\u30D2",
    "/kata:ho": "\u30DB",
    "/kata:hu": "\u30D5",
    "/kata:i": "\u30A4",
    "/kata:ismall": "\u30A3",
    "/kata:iteration": "\u30FD",
    "/kata:ka": "\u30AB",
    "/kata:kasmall": "\u30F5",
    "/kata:ke": "\u30B1",
    "/kata:kesmall": "\u30F6",
    "/kata:ki": "\u30AD",
    "/kata:ko": "\u30B3",
    "/kata:ku": "\u30AF",
    "/kata:ma": "\u30DE",
    "/kata:me": "\u30E1",
    "/kata:mi": "\u30DF",
    "/kata:middledot": "\u30FB",
    "/kata:mo": "\u30E2",
    "/kata:mu": "\u30E0",
    "/kata:n": "\u30F3",
    "/kata:na": "\u30CA",
    "/kata:ne": "\u30CD",
    "/kata:ni": "\u30CB",
    "/kata:no": "\u30CE",
    "/kata:nu": "\u30CC",
    "/kata:o": "\u30AA",
    "/kata:osmall": "\u30A9",
    "/kata:pa": "\u30D1",
    "/kata:pe": "\u30DA",
    "/kata:pi": "\u30D4",
    "/kata:po": "\u30DD",
    "/kata:prolongedkana": "\u30FC",
    "/kata:pu": "\u30D7",
    "/kata:ra": "\u30E9",
    "/kata:re": "\u30EC",
    "/kata:ri": "\u30EA",
    "/kata:ro": "\u30ED",
    "/kata:ru": "\u30EB",
    "/kata:sa": "\u30B5",
    "/kata:se": "\u30BB",
    "/kata:si": "\u30B7",
    "/kata:so": "\u30BD",
    "/kata:su": "\u30B9",
    "/kata:ta": "\u30BF",
    "/kata:te": "\u30C6",
    "/kata:ti": "\u30C1",
    "/kata:to": "\u30C8",
    "/kata:tu": "\u30C4",
    "/kata:tusmall": "\u30C3",
    "/kata:u": "\u30A6",
    "/kata:usmall": "\u30A5",
    "/kata:va": "\u30F7",
    "/kata:ve": "\u30F9",
    "/kata:vi": "\u30F8",
    "/kata:vo": "\u30FA",
    "/kata:voicediteration": "\u30FE",
    "/kata:vu": "\u30F4",
    "/kata:wa": "\u30EF",
    "/kata:wasmall": "\u30EE",
    "/kata:we": "\u30F1",
    "/kata:wi": "\u30F0",
    "/kata:wo": "\u30F2",
    "/kata:ya": "\u30E4",
    "/kata:yasmall": "\u30E3",
    "/kata:yo": "\u30E8",
    "/kata:yosmall": "\u30E7",
    "/kata:yu": "\u30E6",
    "/kata:yusmall": "\u30E5",
    "/kata:za": "\u30B6",
    "/kata:ze": "\u30BC",
    "/kata:zi": "\u30B8",
    "/kata:zo": "\u30BE",
    "/kata:zu": "\u30BA",
    "/katahiraprolongmarkhalfwidth": "\uFF70",
    "/katailcyr": "\u049B",
    "/kaverticalstrokecyr": "\u049D",
    "/kaverticalstrokecyrillic": "\u049D",
    "/kavykainvertedlow": "\u2E45",
    "/kavykalow": "\u2E47",
    "/kavykawithdotlow": "\u2E48",
    "/kavykawithkavykaaboveinvertedlow": "\u2E46",
    "/kbfullwidth": "\u3385",
    "/kbopomofo": "\u310E",
    "/kcalfullwidth": "\u3389",
    "/kcalsquare": "\u3389",
    "/kcaron": "\u01E9",
    "/kcedilla": "\u0137",
    "/kcircle": "\u24DA",
    "/kcommaaccent": "\u0137",
    "/kdescender": "\u2C6A",
    "/kdiagonalstroke": "\uA743",
    "/kdotbelow": "\u1E33",
    "/kecirclekatakana": "\u32D8",
    "/keesusquare": "\u331C",
    "/keharmenian": "\u0584",
    "/keheh": "\u06A9",
    "/keheh.fina": "\uFB8F",
    "/keheh.init": "\uFB90",
    "/keheh.isol": "\uFB8E",
    "/keheh.medi": "\uFB91",
    "/kehehDotAbove": "\u0762",
    "/kehehThreeDotsAbove": "\u0763",
    "/kehehThreeDotsUpBelow": "\u0764",
    "/kehehthreedotsbelow": "\u063C",
    "/kehehtwodotsabove": "\u063B",
    "/kehiragana": "\u3051",
    "/kekatakana": "\u30B1",
    "/kekatakanahalfwidth": "\uFF79",
    "/kelvin": "\u212A",
    "/kenarmenian": "\u056F",
    "/keretconsonant": "\uA9BD",
    "/kesmallkatakana": "\u30F6",
    "/key": "\u1F511",
    "/keyboardAndMouse": "\u1F5A6",
    "/keycapTen": "\u1F51F",
    "/kgfullwidth": "\u338F",
    "/kgreenlandic": "\u0138",
    "/khabengali": "\u0996",
    "/khacyrillic": "\u0445",
    "/khadeva": "\u0916",
    "/khagujarati": "\u0A96",
    "/khagurmukhi": "\u0A16",
    "/khah": "\u062E",
    "/khah.fina": "\uFEA6",
    "/khah.init": "\uFEA7",
    "/khah.init_alefmaksura.fina": "\uFD03",
    "/khah.init_hah.fina": "\uFC1A",
    "/khah.init_jeem.fina": "\uFC19",
    "/khah.init_jeem.medi": "\uFCAB",
    "/khah.init_meem.fina": "\uFC1B",
    "/khah.init_meem.medi": "\uFCAC",
    "/khah.init_yeh.fina": "\uFD04",
    "/khah.isol": "\uFEA5",
    "/khah.medi": "\uFEA8",
    "/khah.medi_alefmaksura.fina": "\uFD1F",
    "/khah.medi_yeh.fina": "\uFD20",
    "/khaharabic": "\u062E",
    "/khahfinalarabic": "\uFEA6",
    "/khahinitialarabic": "\uFEA7",
    "/khahmedialarabic": "\uFEA8",
    "/kheicoptic": "\u03E7",
    "/khhadeva": "\u0959",
    "/khhagurmukhi": "\u0A59",
    "/khieukhacirclekorean": "\u3278",
    "/khieukhaparenkorean": "\u3218",
    "/khieukhcirclekorean": "\u326A",
    "/khieukhkorean": "\u314B",
    "/khieukhparenkorean": "\u320A",
    "/khokhaithai": "\u0E02",
    "/khokhonthai": "\u0E05",
    "/khokhuatthai": "\u0E03",
    "/khokhwaithai": "\u0E04",
    "/khomutthai": "\u0E5B",
    "/khook": "\u0199",
    "/khorakhangthai": "\u0E06",
    "/khzfullwidth": "\u3391",
    "/khzsquare": "\u3391",
    "/kicirclekatakana": "\u32D6",
    "/kihiragana": "\u304D",
    "/kikatakana": "\u30AD",
    "/kikatakanahalfwidth": "\uFF77",
    "/kimono": "\u1F458",
    "/kindergartenideographiccircled": "\u3245",
    "/kingblack": "\u265A",
    "/kingwhite": "\u2654",
    "/kip": "\u20AD",
    "/kiroguramusquare": "\u3315",
    "/kiromeetorusquare": "\u3316",
    "/kirosquare": "\u3314",
    "/kirowattosquare": "\u3317",
    "/kiss": "\u1F48F",
    "/kissMark": "\u1F48B",
    "/kissingCatFaceWithClosedEyes": "\u1F63D",
    "/kissingFace": "\u1F617",
    "/kissingFaceWithClosedEyes": "\u1F61A",
    "/kissingFaceWithSmilingEyes": "\u1F619",
    "/kiyeokacirclekorean": "\u326E",
    "/kiyeokaparenkorean": "\u320E",
    "/kiyeokcirclekorean": "\u3260",
    "/kiyeokkorean": "\u3131",
    "/kiyeokparenkorean": "\u3200",
    "/kiyeoksioskorean": "\u3133",
    "/kjecyr": "\u045C",
    "/kjecyrillic": "\u045C",
    "/kkfullwidth": "\u33CD",
    "/klfullwidth": "\u3398",
    "/klinebelow": "\u1E35",
    "/klsquare": "\u3398",
    "/km2fullwidth": "\u33A2",
    "/km3fullwidth": "\u33A6",
    "/kmcapitalfullwidth": "\u33CE",
    "/kmcubedsquare": "\u33A6",
    "/kmfullwidth": "\u339E",
    "/kmonospace": "\uFF4B",
    "/kmsquaredsquare": "\u33A2",
    "/knda:a": "\u0C85",
    "/knda:aa": "\u0C86",
    "/knda:aasign": "\u0CBE",
    "/knda:ai": "\u0C90",
    "/knda:ailength": "\u0CD6",
    "/knda:aisign": "\u0CC8",
    "/knda:anusvara": "\u0C82",
    "/knda:au": "\u0C94",
    "/knda:ausign": "\u0CCC",
    "/knda:avagraha": "\u0CBD",
    "/knda:ba": "\u0CAC",
    "/knda:bha": "\u0CAD",
    "/knda:ca": "\u0C9A",
    "/knda:cha": "\u0C9B",
    "/knda:da": "\u0CA6",
    "/knda:dda": "\u0CA1",
    "/knda:ddha": "\u0CA2",
    "/knda:dha": "\u0CA7",
    "/knda:e": "\u0C8E",
    "/knda:ee": "\u0C8F",
    "/knda:eesign": "\u0CC7",
    "/knda:eight": "\u0CEE",
    "/knda:esign": "\u0CC6",
    "/knda:fa": "\u0CDE",
    "/knda:five": "\u0CEB",
    "/knda:four": "\u0CEA",
    "/knda:ga": "\u0C97",
    "/knda:gha": "\u0C98",
    "/knda:ha": "\u0CB9",
    "/knda:i": "\u0C87",
    "/knda:ii": "\u0C88",
    "/knda:iisign": "\u0CC0",
    "/knda:isign": "\u0CBF",
    "/knda:ja": "\u0C9C",
    "/knda:jha": "\u0C9D",
    "/knda:jihvamuliya": "\u0CF1",
    "/knda:ka": "\u0C95",
    "/knda:kha": "\u0C96",
    "/knda:la": "\u0CB2",
    "/knda:length": "\u0CD5",
    "/knda:lla": "\u0CB3",
    "/knda:llvocal": "\u0CE1",
    "/knda:llvocalsign": "\u0CE3",
    "/knda:lvocal": "\u0C8C",
    "/knda:lvocalsign": "\u0CE2",
    "/knda:ma": "\u0CAE",
    "/knda:na": "\u0CA8",
    "/knda:nga": "\u0C99",
    "/knda:nine": "\u0CEF",
    "/knda:nna": "\u0CA3",
    "/knda:nukta": "\u0CBC",
    "/knda:nya": "\u0C9E",
    "/knda:o": "\u0C92",
    "/knda:one": "\u0CE7",
    "/knda:oo": "\u0C93",
    "/knda:oosign": "\u0CCB",
    "/knda:osign": "\u0CCA",
    "/knda:pa": "\u0CAA",
    "/knda:pha": "\u0CAB",
    "/knda:ra": "\u0CB0",
    "/knda:rra": "\u0CB1",
    "/knda:rrvocal": "\u0CE0",
    "/knda:rrvocalsign": "\u0CC4",
    "/knda:rvocal": "\u0C8B",
    "/knda:rvocalsign": "\u0CC3",
    "/knda:sa": "\u0CB8",
    "/knda:seven": "\u0CED",
    "/knda:sha": "\u0CB6",
    "/knda:signcandrabindu": "\u0C81",
    "/knda:signspacingcandrabindu": "\u0C80",
    "/knda:six": "\u0CEC",
    "/knda:ssa": "\u0CB7",
    "/knda:ta": "\u0CA4",
    "/knda:tha": "\u0CA5",
    "/knda:three": "\u0CE9",
    "/knda:tta": "\u0C9F",
    "/knda:ttha": "\u0CA0",
    "/knda:two": "\u0CE8",
    "/knda:u": "\u0C89",
    "/knda:upadhmaniya": "\u0CF2",
    "/knda:usign": "\u0CC1",
    "/knda:uu": "\u0C8A",
    "/knda:uusign": "\u0CC2",
    "/knda:va": "\u0CB5",
    "/knda:virama": "\u0CCD",
    "/knda:visarga": "\u0C83",
    "/knda:ya": "\u0CAF",
    "/knda:zero": "\u0CE6",
    "/knightblack": "\u265E",
    "/knightwhite": "\u2658",
    "/ko:a": "\u314F",
    "/ko:ae": "\u3150",
    "/ko:aejungseong": "\u1162",
    "/ko:aeujungseong": "\u11A3",
    "/ko:ajungseong": "\u1161",
    "/ko:aojungseong": "\u1176",
    "/ko:araea": "\u318D",
    "/ko:araeae": "\u318E",
    "/ko:araeaeojungseong": "\u119F",
    "/ko:araeaijungseong": "\u11A1",
    "/ko:araeajungseong": "\u119E",
    "/ko:araeaujungseong": "\u11A0",
    "/ko:aujungseong": "\u1177",
    "/ko:ceongchieumchieuchchoseong": "\u1155",
    "/ko:ceongchieumcieucchoseong": "\u1150",
    "/ko:ceongchieumsioschoseong": "\u113E",
    "/ko:ceongchieumssangcieucchoseong": "\u1151",
    "/ko:ceongchieumssangsioschoseong": "\u113F",
    "/ko:chieuch": "\u314A",
    "/ko:chieuchchoseong": "\u110E",
    "/ko:chieuchhieuhchoseong": "\u1153",
    "/ko:chieuchjongseong": "\u11BE",
    "/ko:chieuchkhieukhchoseong": "\u1152",
    "/ko:chitueumchieuchchoseong": "\u1154",
    "/ko:chitueumcieucchoseong": "\u114E",
    "/ko:chitueumsioschoseong": "\u113C",
    "/ko:chitueumssangcieucchoseong": "\u114F",
    "/ko:chitueumssangsioschoseong": "\u113D",
    "/ko:cieuc": "\u3148",
    "/ko:cieucchoseong": "\u110C",
    "/ko:cieucieungchoseong": "\u114D",
    "/ko:cieucjongseong": "\u11BD",
    "/ko:e": "\u3154",
    "/ko:ejungseong": "\u1166",
    "/ko:eo": "\u3153",
    "/ko:eo_eujungseong": "\u117C",
    "/ko:eojungseong": "\u1165",
    "/ko:eoojungseong": "\u117A",
    "/ko:eoujungseong": "\u117B",
    "/ko:eu": "\u3161",
    "/ko:eueujungseong": "\u1196",
    "/ko:eujungseong": "\u1173",
    "/ko:euujungseong": "\u1195",
    "/ko:filler": "\u3164",
    "/ko:fillerchoseong": "\u115F",
    "/ko:fillerjungseong": "\u1160",
    "/ko:hieuh": "\u314E",
    "/ko:hieuhchoseong": "\u1112",
    "/ko:hieuhjongseong": "\u11C2",
    "/ko:hieuhmieumjongseong": "\u11F7",
    "/ko:hieuhnieunjongseong": "\u11F5",
    "/ko:hieuhpieupjongseong": "\u11F8",
    "/ko:hieuhrieuljongseong": "\u11F6",
    "/ko:i": "\u3163",
    "/ko:iajungseong": "\u1198",
    "/ko:iaraeajungseong": "\u119D",
    "/ko:ieujungseong": "\u119C",
    "/ko:ieung": "\u3147",
    "/ko:ieungchieuchchoseong": "\u1149",
    "/ko:ieungchoseong": "\u110B",
    "/ko:ieungcieucchoseong": "\u1148",
    "/ko:ieungjongseong": "\u11BC",
    "/ko:ieungkhieukhjongseong": "\u11EF",
    "/ko:ieungkiyeokchoseong": "\u1141",
    "/ko:ieungkiyeokjongseong": "\u11EC",
    "/ko:ieungmieumchoseong": "\u1143",
    "/ko:ieungpansioschoseong": "\u1146",
    "/ko:ieungphieuphchoseong": "\u114B",
    "/ko:ieungpieupchoseong": "\u1144",
    "/ko:ieungsioschoseong": "\u1145",
    "/ko:ieungssangkiyeokjongseong": "\u11ED",
    "/ko:ieungthieuthchoseong": "\u114A",
    "/ko:ieungtikeutchoseong": "\u1142",
    "/ko:ijungseong": "\u1175",
    "/ko:iojungseong": "\u119A",
    "/ko:iujungseong": "\u119B",
    "/ko:iyajungseong": "\u1199",
    "/ko:kapyeounmieum": "\u3171",
    "/ko:kapyeounmieumchoseong": "\u111D",
    "/ko:kapyeounmieumjongseong": "\u11E2",
    "/ko:kapyeounphieuph": "\u3184",
    "/ko:kapyeounphieuphchoseong": "\u1157",
    "/ko:kapyeounphieuphjongseong": "\u11F4",
    "/ko:kapyeounpieup": "\u3178",
    "/ko:kapyeounpieupchoseong": "\u112B",
    "/ko:kapyeounpieupjongseong": "\u11E6",
    "/ko:kapyeounrieulchoseong": "\u111B",
    "/ko:kapyeounssangpieup": "\u3179",
    "/ko:kapyeounssangpieupchoseong": "\u112C",
    "/ko:khieukh": "\u314B",
    "/ko:khieukhchoseong": "\u110F",
    "/ko:khieukhjongseong": "\u11BF",
    "/ko:kiyeok": "\u3131",
    "/ko:kiyeokchieuchjongseong": "\u11FC",
    "/ko:kiyeokchoseong": "\u1100",
    "/ko:kiyeokhieuhjongseong": "\u11FE",
    "/ko:kiyeokjongseong": "\u11A8",
    "/ko:kiyeokkhieukhjongseong": "\u11FD",
    "/ko:kiyeoknieunjongseong": "\u11FA",
    "/ko:kiyeokpieupjongseong": "\u11FB",
    "/ko:kiyeokrieuljongseong": "\u11C3",
    "/ko:kiyeoksios": "\u3133",
    "/ko:kiyeoksiosjongseong": "\u11AA",
    "/ko:kiyeoksioskiyeokjongseong": "\u11C4",
    "/ko:kiyeoktikeutchoseong": "\u115A",
    "/ko:mieum": "\u3141",
    "/ko:mieumchieuchjongseong": "\u11E0",
    "/ko:mieumchoseong": "\u1106",
    "/ko:mieumhieuhjongseong": "\u11E1",
    "/ko:mieumjongseong": "\u11B7",
    "/ko:mieumkiyeokjongseong": "\u11DA",
    "/ko:mieumpansios": "\u3170",
    "/ko:mieumpansiosjongseong": "\u11DF",
    "/ko:mieumpieup": "\u316E",
    "/ko:mieumpieupchoseong": "\u111C",
    "/ko:mieumpieupjongseong": "\u11DC",
    "/ko:mieumrieuljongseong": "\u11DB",
    "/ko:mieumsios": "\u316F",
    "/ko:mieumsiosjongseong": "\u11DD",
    "/ko:mieumssangsiosjongseong": "\u11DE",
    "/ko:nieun": "\u3134",
    "/ko:nieunchoseong": "\u1102",
    "/ko:nieuncieuc": "\u3135",
    "/ko:nieuncieucchoseong": "\u115C",
    "/ko:nieuncieucjongseong": "\u11AC",
    "/ko:nieunhieuh": "\u3136",
    "/ko:nieunhieuhchoseong": "\u115D",
    "/ko:nieunhieuhjongseong": "\u11AD",
    "/ko:nieunjongseong": "\u11AB",
    "/ko:nieunkiyeokchoseong": "\u1113",
    "/ko:nieunkiyeokjongseong": "\u11C5",
    "/ko:nieunpansios": "\u3168",
    "/ko:nieunpansiosjongseong": "\u11C8",
    "/ko:nieunpieupchoseong": "\u1116",
    "/ko:nieunsios": "\u3167",
    "/ko:nieunsioschoseong": "\u115B",
    "/ko:nieunsiosjongseong": "\u11C7",
    "/ko:nieunthieuthjongseong": "\u11C9",
    "/ko:nieuntikeut": "\u3166",
    "/ko:nieuntikeutchoseong": "\u1115",
    "/ko:nieuntikeutjongseong": "\u11C6",
    "/ko:o": "\u3157",
    "/ko:o_ejungseong": "\u1180",
    "/ko:o_eojungseong": "\u117F",
    "/ko:oe": "\u315A",
    "/ko:oejungseong": "\u116C",
    "/ko:ojungseong": "\u1169",
    "/ko:oojungseong": "\u1182",
    "/ko:oujungseong": "\u1183",
    "/ko:oyaejungseong": "\u11A7",
    "/ko:oyajungseong": "\u11A6",
    "/ko:oyejungseong": "\u1181",
    "/ko:pansios": "\u317F",
    "/ko:pansioschoseong": "\u1140",
    "/ko:pansiosjongseong": "\u11EB",
    "/ko:phieuph": "\u314D",
    "/ko:phieuphchoseong": "\u1111",
    "/ko:phieuphjongseong": "\u11C1",
    "/ko:phieuphpieupchoseong": "\u1156",
    "/ko:phieuphpieupjongseong": "\u11F3",
    "/ko:pieup": "\u3142",
    "/ko:pieupchieuchchoseong": "\u1128",
    "/ko:pieupchoseong": "\u1107",
    "/ko:pieupcieuc": "\u3176",
    "/ko:pieupcieucchoseong": "\u1127",
    "/ko:pieuphieuhjongseong": "\u11E5",
    "/ko:pieupjongseong": "\u11B8",
    "/ko:pieupkiyeok": "\u3172",
    "/ko:pieupkiyeokchoseong": "\u111E",
    "/ko:pieupnieunchoseong": "\u111F",
    "/ko:pieupphieuphchoseong": "\u112A",
    "/ko:pieupphieuphjongseong": "\u11E4",
    "/ko:pieuprieuljongseong": "\u11E3",
    "/ko:pieupsios": "\u3144",
    "/ko:pieupsioschoseong": "\u1121",
    "/ko:pieupsioscieucchoseong": "\u1126",
    "/ko:pieupsiosjongseong": "\u11B9",
    "/ko:pieupsioskiyeok": "\u3174",
    "/ko:pieupsioskiyeokchoseong": "\u1122",
    "/ko:pieupsiospieupchoseong": "\u1124",
    "/ko:pieupsiostikeut": "\u3175",
    "/ko:pieupsiostikeutchoseong": "\u1123",
    "/ko:pieupssangsioschoseong": "\u1125",
    "/ko:pieupthieuth": "\u3177",
    "/ko:pieupthieuthchoseong": "\u1129",
    "/ko:pieuptikeut": "\u3173",
    "/ko:pieuptikeutchoseong": "\u1120",
    "/ko:rieul": "\u3139",
    "/ko:rieulchoseong": "\u1105",
    "/ko:rieulhieuh": "\u3140",
    "/ko:rieulhieuhchoseong": "\u111A",
    "/ko:rieulhieuhjongseong": "\u11B6",
    "/ko:rieuljongseong": "\u11AF",
    "/ko:rieulkapyeounpieupjongseong": "\u11D5",
    "/ko:rieulkhieukhjongseong": "\u11D8",
    "/ko:rieulkiyeok": "\u313A",
    "/ko:rieulkiyeokjongseong": "\u11B0",
    "/ko:rieulkiyeoksios": "\u3169",
    "/ko:rieulkiyeoksiosjongseong": "\u11CC",
    "/ko:rieulmieum": "\u313B",
    "/ko:rieulmieumjongseong": "\u11B1",
    "/ko:rieulmieumkiyeokjongseong": "\u11D1",
    "/ko:rieulmieumsiosjongseong": "\u11D2",
    "/ko:rieulnieunchoseong": "\u1118",
    "/ko:rieulnieunjongseong": "\u11CD",
    "/ko:rieulpansios": "\u316C",
    "/ko:rieulpansiosjongseong": "\u11D7",
    "/ko:rieulphieuph": "\u313F",
    "/ko:rieulphieuphjongseong": "\u11B5",
    "/ko:rieulpieup": "\u313C",
    "/ko:rieulpieuphieuhjongseong": "\u11D4",
    "/ko:rieulpieupjongseong": "\u11B2",
    "/ko:rieulpieupsios": "\u316B",
    "/ko:rieulpieupsiosjongseong": "\u11D3",
    "/ko:rieulsios": "\u313D",
    "/ko:rieulsiosjongseong": "\u11B3",
    "/ko:rieulssangsiosjongseong": "\u11D6",
    "/ko:rieulthieuth": "\u313E",
    "/ko:rieulthieuthjongseong": "\u11B4",
    "/ko:rieultikeut": "\u316A",
    "/ko:rieultikeuthieuhjongseong": "\u11CF",
    "/ko:rieultikeutjongseong": "\u11CE",
    "/ko:rieulyeorinhieuh": "\u316D",
    "/ko:rieulyeorinhieuhjongseong": "\u11D9",
    "/ko:sios": "\u3145",
    "/ko:sioschieuchchoseong": "\u1137",
    "/ko:sioschoseong": "\u1109",
    "/ko:sioscieuc": "\u317E",
    "/ko:sioscieucchoseong": "\u1136",
    "/ko:sioshieuhchoseong": "\u113B",
    "/ko:siosieungchoseong": "\u1135",
    "/ko:siosjongseong": "\u11BA",
    "/ko:sioskhieukhchoseong": "\u1138",
    "/ko:sioskiyeok": "\u317A",
    "/ko:sioskiyeokchoseong": "\u112D",
    "/ko:sioskiyeokjongseong": "\u11E7",
    "/ko:siosmieumchoseong": "\u1131",
    "/ko:siosnieun": "\u317B",
    "/ko:siosnieunchoseong": "\u112E",
    "/ko:siosphieuphchoseong": "\u113A",
    "/ko:siospieup": "\u317D",
    "/ko:siospieupchoseong": "\u1132",
    "/ko:siospieupjongseong": "\u11EA",
    "/ko:siospieupkiyeokchoseong": "\u1133",
    "/ko:siosrieulchoseong": "\u1130",
    "/ko:siosrieuljongseong": "\u11E9",
    "/ko:siosssangsioschoseong": "\u1134",
    "/ko:siosthieuthchoseong": "\u1139",
    "/ko:siostikeut": "\u317C",
    "/ko:siostikeutchoseong": "\u112F",
    "/ko:siostikeutjongseong": "\u11E8",
    "/ko:ssangaraeajungseong": "\u11A2",
    "/ko:ssangcieuc": "\u3149",
    "/ko:ssangcieucchoseong": "\u110D",
    "/ko:ssanghieuh": "\u3185",
    "/ko:ssanghieuhchoseong": "\u1158",
    "/ko:ssangieung": "\u3180",
    "/ko:ssangieungchoseong": "\u1147",
    "/ko:ssangieungjongseong": "\u11EE",
    "/ko:ssangkiyeok": "\u3132",
    "/ko:ssangkiyeokchoseong": "\u1101",
    "/ko:ssangkiyeokjongseong": "\u11A9",
    "/ko:ssangnieun": "\u3165",
    "/ko:ssangnieunchoseong": "\u1114",
    "/ko:ssangnieunjongseong": "\u11FF",
    "/ko:ssangpieup": "\u3143",
    "/ko:ssangpieupchoseong": "\u1108",
    "/ko:ssangrieulchoseong": "\u1119",
    "/ko:ssangrieuljongseong": "\u11D0",
    "/ko:ssangsios": "\u3146",
    "/ko:ssangsioschoseong": "\u110A",
    "/ko:ssangsiosjongseong": "\u11BB",
    "/ko:ssangtikeut": "\u3138",
    "/ko:ssangtikeutchoseong": "\u1104",
    "/ko:thieuth": "\u314C",
    "/ko:thieuthchoseong": "\u1110",
    "/ko:thieuthjongseong": "\u11C0",
    "/ko:tikeut": "\u3137",
    "/ko:tikeutchoseong": "\u1103",
    "/ko:tikeutjongseong": "\u11AE",
    "/ko:tikeutkiyeokchoseong": "\u1117",
    "/ko:tikeutkiyeokjongseong": "\u11CA",
    "/ko:tikeutrieulchoseong": "\u115E",
    "/ko:tikeutrieuljongseong": "\u11CB",
    "/ko:u": "\u315C",
    "/ko:uaejungseong": "\u118A",
    "/ko:uajungseong": "\u1189",
    "/ko:ueo_eujungseong": "\u118B",
    "/ko:ujungseong": "\u116E",
    "/ko:uujungseong": "\u118D",
    "/ko:uyejungseong": "\u118C",
    "/ko:wa": "\u3158",
    "/ko:wae": "\u3159",
    "/ko:waejungseong": "\u116B",
    "/ko:wajungseong": "\u116A",
    "/ko:we": "\u315E",
    "/ko:wejungseong": "\u1170",
    "/ko:weo": "\u315D",
    "/ko:weojungseong": "\u116F",
    "/ko:wi": "\u315F",
    "/ko:wijungseong": "\u1171",
    "/ko:ya": "\u3151",
    "/ko:yae": "\u3152",
    "/ko:yaejungseong": "\u1164",
    "/ko:yajungseong": "\u1163",
    "/ko:yaojungseong": "\u1178",
    "/ko:yaujungseong": "\u11A4",
    "/ko:yayojungseong": "\u1179",
    "/ko:ye": "\u3156",
    "/ko:yejungseong": "\u1168",
    "/ko:yeo": "\u3155",
    "/ko:yeojungseong": "\u1167",
    "/ko:yeoojungseong": "\u117D",
    "/ko:yeorinhieuh": "\u3186",
    "/ko:yeorinhieuhchoseong": "\u1159",
    "/ko:yeorinhieuhjongseong": "\u11F9",
    "/ko:yeoujungseong": "\u117E",
    "/ko:yeoyajungseong": "\u11A5",
    "/ko:yesieung": "\u3181",
    "/ko:yesieungchoseong": "\u114C",
    "/ko:yesieungjongseong": "\u11F0",
    "/ko:yesieungpansios": "\u3183",
    "/ko:yesieungpansiosjongseong": "\u11F2",
    "/ko:yesieungsios": "\u3182",
    "/ko:yesieungsiosjongseong": "\u11F1",
    "/ko:yi": "\u3162",
    "/ko:yijungseong": "\u1174",
    "/ko:yiujungseong": "\u1197",
    "/ko:yo": "\u315B",
    "/ko:yoi": "\u3189",
    "/ko:yoijungseong": "\u1188",
    "/ko:yojungseong": "\u116D",
    "/ko:yoojungseong": "\u1187",
    "/ko:yoya": "\u3187",
    "/ko:yoyae": "\u3188",
    "/ko:yoyaejungseong": "\u1185",
    "/ko:yoyajungseong": "\u1184",
    "/ko:yoyeojungseong": "\u1186",
    "/ko:yu": "\u3160",
    "/ko:yuajungseong": "\u118E",
    "/ko:yuejungseong": "\u1190",
    "/ko:yueojungseong": "\u118F",
    "/ko:yui": "\u318C",
    "/ko:yuijungseong": "\u1194",
    "/ko:yujungseong": "\u1172",
    "/ko:yuujungseong": "\u1193",
    "/ko:yuye": "\u318B",
    "/ko:yuyejungseong": "\u1192",
    "/ko:yuyeo": "\u318A",
    "/ko:yuyeojungseong": "\u1191",
    "/koala": "\u1F428",
    "/kobliquestroke": "\uA7A3",
    "/kocirclekatakana": "\u32D9",
    "/kohiragana": "\u3053",
    "/kohmfullwidth": "\u33C0",
    "/kohmsquare": "\u33C0",
    "/kokaithai": "\u0E01",
    "/kokatakana": "\u30B3",
    "/kokatakanahalfwidth": "\uFF7A",
    "/kooposquare": "\u331E",
    "/koppa": "\u03DF",
    "/koppaarchaic": "\u03D9",
    "/koppacyr": "\u0481",
    "/koppacyrillic": "\u0481",
    "/koreanstandardsymbol": "\u327F",
    "/koroniscmb": "\u0343",
    "/korunasquare": "\u331D",
    "/kotoideographiccircled": "\u3247",
    "/kpafullwidth": "\u33AA",
    "/kparen": "\u24A6",
    "/kparenthesized": "\u24A6",
    "/kpasquare": "\u33AA",
    "/kra": "\u0138",
    "/ksicyr": "\u046F",
    "/ksicyrillic": "\u046F",
    "/kstroke": "\uA741",
    "/kstrokediagonalstroke": "\uA745",
    "/ktfullwidth": "\u33CF",
    "/ktsquare": "\u33CF",
    "/kturned": "\u029E",
    "/kucirclekatakana": "\u32D7",
    "/kuhiragana": "\u304F",
    "/kukatakana": "\u30AF",
    "/kukatakanahalfwidth": "\uFF78",
    "/kuroonesquare": "\u331B",
    "/kuruzeirosquare": "\u331A",
    "/kvfullwidth": "\u33B8",
    "/kvsquare": "\u33B8",
    "/kwfullwidth": "\u33BE",
    "/kwsquare": "\u33BE",
    "/kyuriisquare": "\u3312",
    "/l": "\u006C",
    "/l.inferior": "\u2097",
    "/label": "\u1F3F7",
    "/labengali": "\u09B2",
    "/laborideographiccircled": "\u3298",
    "/laborideographicparen": "\u3238",
    "/lacute": "\u013A",
    "/ladeva": "\u0932",
    "/ladyBeetle": "\u1F41E",
    "/lagujarati": "\u0AB2",
    "/lagurmukhi": "\u0A32",
    "/lakkhangyaothai": "\u0E45",
    "/lam": "\u0644",
    "/lam.fina": "\uFEDE",
    "/lam.init": "\uFEDF",
    "/lam.init_alef.fina": "\uFEFB",
    "/lam.init_alef.medi_hamzaabove.fina": "\uFEF7",
    "/lam.init_alef.medi_hamzabelow.fina": "\uFEF9",
    "/lam.init_alef.medi_maddaabove.fina": "\uFEF5",
    "/lam.init_alefmaksura.fina": "\uFC43",
    "/lam.init_hah.fina": "\uFC40",
    "/lam.init_hah.medi": "\uFCCA",
    "/lam.init_hah.medi_meem.medi": "\uFDB5",
    "/lam.init_heh.medi": "\uFCCD",
    "/lam.init_jeem.fina": "\uFC3F",
    "/lam.init_jeem.medi": "\uFCC9",
    "/lam.init_jeem.medi_jeem.medi": "\uFD83",
    "/lam.init_jeem.medi_meem.medi": "\uFDBA",
    "/lam.init_khah.fina": "\uFC41",
    "/lam.init_khah.medi": "\uFCCB",
    "/lam.init_khah.medi_meem.medi": "\uFD86",
    "/lam.init_meem.fina": "\uFC42",
    "/lam.init_meem.medi": "\uFCCC",
    "/lam.init_meem.medi_hah.medi": "\uFD88",
    "/lam.init_yeh.fina": "\uFC44",
    "/lam.isol": "\uFEDD",
    "/lam.medi": "\uFEE0",
    "/lam.medi_alef.fina": "\uFEFC",
    "/lam.medi_alef.medi_hamzaabove.fina": "\uFEF8",
    "/lam.medi_alef.medi_hamzabelow.fina": "\uFEFA",
    "/lam.medi_alef.medi_maddaabove.fina": "\uFEF6",
    "/lam.medi_alefmaksura.fina": "\uFC86",
    "/lam.medi_hah.medi_alefmaksura.fina": "\uFD82",
    "/lam.medi_hah.medi_meem.fina": "\uFD80",
    "/lam.medi_hah.medi_yeh.fina": "\uFD81",
    "/lam.medi_jeem.medi_jeem.fina": "\uFD84",
    "/lam.medi_jeem.medi_meem.fina": "\uFDBC",
    "/lam.medi_jeem.medi_yeh.fina": "\uFDAC",
    "/lam.medi_khah.medi_meem.fina": "\uFD85",
    "/lam.medi_meem.fina": "\uFC85",
    "/lam.medi_meem.medi": "\uFCED",
    "/lam.medi_meem.medi_hah.fina": "\uFD87",
    "/lam.medi_meem.medi_yeh.fina": "\uFDAD",
    "/lam.medi_yeh.fina": "\uFC87",
    "/lamBar": "\u076A",
    "/lamVabove": "\u06B5",
    "/lamalefabove": "\u06D9",
    "/lamaleffinalarabic": "\uFEFC",
    "/lamalefhamzaabovefinalarabic": "\uFEF8",
    "/lamalefhamzaaboveisolatedarabic": "\uFEF7",
    "/lamalefhamzabelowfinalarabic": "\uFEFA",
    "/lamalefhamzabelowisolatedarabic": "\uFEF9",
    "/lamalefisolatedarabic": "\uFEFB",
    "/lamalefmaddaabovefinalarabic": "\uFEF6",
    "/lamalefmaddaaboveisolatedarabic": "\uFEF5",
    "/lamarabic": "\u0644",
    "/lambda": "\u03BB",
    "/lambdastroke": "\u019B",
    "/lamdotabove": "\u06B6",
    "/lamed": "\u05DC",
    "/lamed:hb": "\u05DC",
    "/lameddagesh": "\uFB3C",
    "/lameddageshhebrew": "\uFB3C",
    "/lamedhebrew": "\u05DC",
    "/lamedholam": "\u05DC",
    "/lamedholamdagesh": "\u05DC",
    "/lamedholamdageshhebrew": "\u05DC",
    "/lamedholamhebrew": "\u05DC",
    "/lamedwide:hb": "\uFB25",
    "/lamedwithdagesh:hb": "\uFB3C",
    "/lamfinalarabic": "\uFEDE",
    "/lamhahinitialarabic": "\uFCCA",
    "/laminitialarabic": "\uFEDF",
    "/lamjeeminitialarabic": "\uFCC9",
    "/lamkhahinitialarabic": "\uFCCB",
    "/lamlamhehisolatedarabic": "\uFDF2",
    "/lammedialarabic": "\uFEE0",
    "/lammeemhahinitialarabic": "\uFD88",
    "/lammeeminitialarabic": "\uFCCC",
    "/lammeemjeeminitialarabic": "\uFEDF",
    "/lammeemkhahinitialarabic": "\uFEDF",
    "/lamthreedotsabove": "\u06B7",
    "/lamthreedotsbelow": "\u06B8",
    "/lanemergeleftblack": "\u26D8",
    "/lanemergeleftwhite": "\u26D9",
    "/largeBlueCircle": "\u1F535",
    "/largeBlueDiamond": "\u1F537",
    "/largeOrangeDiamond": "\u1F536",
    "/largeRedCircle": "\u1F534",
    "/largecircle": "\u25EF",
    "/largetackdown": "\u27D9",
    "/largetackup": "\u27D8",
    "/lari": "\u20BE",
    "/lastQuarterMoon": "\u1F317",
    "/lastQuarterMoonFace": "\u1F31C",
    "/lastquartermoon": "\u263E",
    "/layar": "\uA982",
    "/lazysinverted": "\u223E",
    "/lbar": "\u019A",
    "/lbbar": "\u2114",
    "/lbelt": "\u026C",
    "/lbeltretroflex": "\uA78E",
    "/lbopomofo": "\u310C",
    "/lbroken": "\uA747",
    "/lcaron": "\u013E",
    "/lcedilla": "\u013C",
    "/lcircle": "\u24DB",
    "/lcircumflexbelow": "\u1E3D",
    "/lcommaaccent": "\u013C",
    "/lcurl": "\u0234",
    "/ldblbar": "\u2C61",
    "/ldot": "\u0140",
    "/ldotaccent": "\u0140",
    "/ldotbelow": "\u1E37",
    "/ldotbelowmacron": "\u1E39",
    "/leafFlutteringInWind": "\u1F343",
    "/ledger": "\u1F4D2",
    "/left-pointingMagnifyingGlass": "\u1F50D",
    "/leftAngerBubble": "\u1F5EE",
    "/leftFiveEighthsBlock": "\u258B",
    "/leftHalfBlock": "\u258C",
    "/leftHandTelephoneReceiver": "\u1F57B",
    "/leftLuggage": "\u1F6C5",
    "/leftOneEighthBlock": "\u258F",
    "/leftOneQuarterBlock": "\u258E",
    "/leftSevenEighthsBlock": "\u2589",
    "/leftSpeechBubble": "\u1F5E8",
    "/leftThoughtBubble": "\u1F5EC",
    "/leftThreeEighthsBlock": "\u258D",
    "/leftThreeQuartersBlock": "\u258A",
    "/leftWritingHand": "\u1F58E",
    "/leftangleabovecmb": "\u031A",
    "/leftarrowoverrightarrow": "\u21C6",
    "/leftdnheavyrightuplight": "\u2545",
    "/leftharpoonoverrightharpoon": "\u21CB",
    "/leftheavyrightdnlight": "\u252D",
    "/leftheavyrightuplight": "\u2535",
    "/leftheavyrightvertlight": "\u253D",
    "/leftideographiccircled": "\u32A7",
    "/leftlightrightdnheavy": "\u2532",
    "/leftlightrightupheavy": "\u253A",
    "/leftlightrightvertheavy": "\u254A",
    "/lefttackbelowcmb": "\u0318",
    "/lefttorightembed": "\u202A",
    "/lefttorightisolate": "\u2066",
    "/lefttorightmark": "\u200E",
    "/lefttorightoverride": "\u202D",
    "/leftupheavyrightdnlight": "\u2543",
    "/lemon": "\u1F34B",
    "/lenis": "\u1FBF",
    "/lenisacute": "\u1FCE",
    "/lenisgrave": "\u1FCD",
    "/lenistilde": "\u1FCF",
    "/leo": "\u264C",
    "/leopard": "\u1F406",
    "/less": "\u003C",
    "/lessbutnotequal": "\u2268",
    "/lessbutnotequivalent": "\u22E6",
    "/lessdot": "\u22D6",
    "/lessequal": "\u2264",
    "/lessequalorgreater": "\u22DA",
    "/lessmonospace": "\uFF1C",
    "/lessorequivalent": "\u2272",
    "/lessorgreater": "\u2276",
    "/lessoverequal": "\u2266",
    "/lesssmall": "\uFE64",
    "/levelSlider": "\u1F39A",
    "/lezh": "\u026E",
    "/lfblock": "\u258C",
    "/lhacyr": "\u0515",
    "/lhookretroflex": "\u026D",
    "/libra": "\u264E",
    "/ligaturealeflamed:hb": "\uFB4F",
    "/ligatureoemod": "\uA7F9",
    "/lightCheckMark": "\u1F5F8",
    "/lightRail": "\u1F688",
    "/lightShade": "\u2591",
    "/lightarcdnleft": "\u256E",
    "/lightarcdnright": "\u256D",
    "/lightarcupleft": "\u256F",
    "/lightarcupright": "\u2570",
    "/lightdbldashhorz": "\u254C",
    "/lightdbldashvert": "\u254E",
    "/lightdiagcross": "\u2573",
    "/lightdiagupleftdnright": "\u2572",
    "/lightdiaguprightdnleft": "\u2571",
    "/lightdn": "\u2577",
    "/lightdnhorz": "\u252C",
    "/lightdnleft": "\u2510",
    "/lightdnright": "\u250C",
    "/lighthorz": "\u2500",
    "/lightleft": "\u2574",
    "/lightleftheavyright": "\u257C",
    "/lightning": "\u2607",
    "/lightningMood": "\u1F5F2",
    "/lightningMoodBubble": "\u1F5F1",
    "/lightquaddashhorz": "\u2508",
    "/lightquaddashvert": "\u250A",
    "/lightright": "\u2576",
    "/lighttrpldashhorz": "\u2504",
    "/lighttrpldashvert": "\u2506",
    "/lightup": "\u2575",
    "/lightupheavydn": "\u257D",
    "/lightuphorz": "\u2534",
    "/lightupleft": "\u2518",
    "/lightupright": "\u2514",
    "/lightvert": "\u2502",
    "/lightverthorz": "\u253C",
    "/lightvertleft": "\u2524",
    "/lightvertright": "\u251C",
    "/lineextensionhorizontal": "\u23AF",
    "/lineextensionvertical": "\u23D0",
    "/linemiddledotvertical": "\u237F",
    "/lineseparator": "\u2028",
    "/lingsapada": "\uA9C8",
    "/link": "\u1F517",
    "/linkedPaperclips": "\u1F587",
    "/lips": "\u1F5E2",
    "/lipstick": "\u1F484",
    "/lira": "\u20A4",
    "/litre": "\u2113",
    "/livretournois": "\u20B6",
    "/liwnarmenian": "\u056C",
    "/lj": "\u01C9",
    "/ljecyr": "\u0459",
    "/ljecyrillic": "\u0459",
    "/ljekomicyr": "\u0509",
    "/ll": "\uF6C0",
    "/lladeva": "\u0933",
    "/llagujarati": "\u0AB3",
    "/llinebelow": "\u1E3B",
    "/llladeva": "\u0934",
    "/llvocalicbengali": "\u09E1",
    "/llvocalicdeva": "\u0961",
    "/llvocalicvowelsignbengali": "\u09E3",
    "/llvocalicvowelsigndeva": "\u0963",
    "/llwelsh": "\u1EFB",
    "/lmacrondot": "\u1E39",
    "/lmfullwidth": "\u33D0",
    "/lmiddletilde": "\u026B",
    "/lmonospace": "\uFF4C",
    "/lmsquare": "\u33D0",
    "/lnfullwidth": "\u33D1",
    "/lochulathai": "\u0E2C",
    "/lock": "\u1F512",
    "/lockInkPen": "\u1F50F",
    "/logfullwidth": "\u33D2",
    "/logicaland": "\u2227",
    "/logicalandarray": "\u22C0",
    "/logicalnot": "\u00AC",
    "/logicalnotreversed": "\u2310",
    "/logicalor": "\u2228",
    "/logicalorarray": "\u22C1",
    "/lolingthai": "\u0E25",
    "/lollipop": "\u1F36D",
    "/longdivision": "\u27CC",
    "/longovershortmetrical": "\u23D2",
    "/longovertwoshortsmetrical": "\u23D4",
    "/longs": "\u017F",
    "/longs_t": "\uFB05",
    "/longsdot": "\u1E9B",
    "/longswithdiagonalstroke": "\u1E9C",
    "/longswithhighstroke": "\u1E9D",
    "/longtackleft": "\u27DE",
    "/longtackright": "\u27DD",
    "/losslesssquare": "\u1F1A9",
    "/loudlyCryingFace": "\u1F62D",
    "/loveHotel": "\u1F3E9",
    "/loveLetter": "\u1F48C",
    "/lowBrightness": "\u1F505",
    "/lowasterisk": "\u204E",
    "/lowerFiveEighthsBlock": "\u2585",
    "/lowerHalfBlock": "\u2584",
    "/lowerLeftBallpointPen": "\u1F58A",
    "/lowerLeftCrayon": "\u1F58D",
    "/lowerLeftFountainPen": "\u1F58B",
    "/lowerLeftPaintbrush": "\u1F58C",
    "/lowerLeftPencil": "\u1F589",
    "/lowerOneEighthBlock": "\u2581",
    "/lowerOneQuarterBlock": "\u2582",
    "/lowerRightShadowedWhiteCircle": "\u1F53E",
    "/lowerSevenEighthsBlock": "\u2587",
    "/lowerThreeEighthsBlock": "\u2583",
    "/lowerThreeQuartersBlock": "\u2586",
    "/lowercornerdotright": "\u27D3",
    "/lowerhalfcircle": "\u25E1",
    "/lowerhalfcircleinversewhite": "\u25DB",
    "/lowerquadrantcirculararcleft": "\u25DF",
    "/lowerquadrantcirculararcright": "\u25DE",
    "/lowertriangleleft": "\u25FA",
    "/lowertriangleleftblack": "\u25E3",
    "/lowertriangleright": "\u25FF",
    "/lowertrianglerightblack": "\u25E2",
    "/lowideographiccircled": "\u32A6",
    "/lowlinecenterline": "\uFE4E",
    "/lowlinecmb": "\u0332",
    "/lowlinedashed": "\uFE4D",
    "/lownumeralsign": "\u0375",
    "/lowquotedblprime": "\u301F",
    "/lozenge": "\u25CA",
    "/lozengedividedbyrulehorizontal": "\u27E0",
    "/lozengesquare": "\u2311",
    "/lparen": "\u24A7",
    "/lparenthesized": "\u24A7",
    "/lretroflex": "\u026D",
    "/ls": "\u02AA",
    "/lslash": "\u0142",
    "/lsquare": "\u2113",
    "/lstroke": "\uA749",
    "/lsuperior": "\uF6EE",
    "/lsupmod": "\u02E1",
    "/lt:Alpha": "\u2C6D",
    "/lt:Alphaturned": "\u2C70",
    "/lt:Beta": "\uA7B4",
    "/lt:Chi": "\uA7B3",
    "/lt:Gamma": "\u0194",
    "/lt:Iota": "\u0196",
    "/lt:Omega": "\uA7B6",
    "/lt:Upsilon": "\u01B1",
    "/lt:beta": "\uA7B5",
    "/lt:delta": "\u1E9F",
    "/lt:omega": "\uA7B7",
    "/ltshade": "\u2591",
    "/lttr:bet": "\u2136",
    "/lttr:dalet": "\u2138",
    "/lttr:gimel": "\u2137",
    "/lttr:gscript": "\u210A",
    "/lturned": "\uA781",
    "/ltypeopencircuit": "\u2390",
    "/luhurpada": "\uA9C5",
    "/lum": "\uA772",
    "/lungsipada": "\uA9C9",
    "/luthai": "\u0E26",
    "/lvocalicbengali": "\u098C",
    "/lvocalicdeva": "\u090C",
    "/lvocalicvowelsignbengali": "\u09E2",
    "/lvocalicvowelsigndeva": "\u0962",
    "/lxfullwidth": "\u33D3",
    "/lxsquare": "\u33D3",
    "/lzed": "\u02AB",
    "/m": "\u006D",
    "/m.inferior": "\u2098",
    "/m2fullwidth": "\u33A1",
    "/m3fullwidth": "\u33A5",
    "/mabengali": "\u09AE",
    "/macirclekatakana": "\u32EE",
    "/macron": "\u00AF",
    "/macronbelowcmb": "\u0331",
    "/macroncmb": "\u0304",
    "/macronlowmod": "\u02CD",
    "/macronmod": "\u02C9",
    "/macronmonospace": "\uFFE3",
    "/macute": "\u1E3F",
    "/madda": "\u0653",
    "/maddaabove": "\u06E4",
    "/madeva": "\u092E",
    "/madyapada": "\uA9C4",
    "/mafullwidth": "\u3383",
    "/magujarati": "\u0AAE",
    "/magurmukhi": "\u0A2E",
    "/mahapakhhebrew": "\u05A4",
    "/mahapakhlefthebrew": "\u05A4",
    "/mahhasquare": "\u3345",
    "/mahiragana": "\u307E",
    "/mahpach:hb": "\u05A4",
    "/maichattawalowleftthai": "\uF895",
    "/maichattawalowrightthai": "\uF894",
    "/maichattawathai": "\u0E4B",
    "/maichattawaupperleftthai": "\uF893",
    "/maieklowleftthai": "\uF88C",
    "/maieklowrightthai": "\uF88B",
    "/maiekthai": "\u0E48",
    "/maiekupperleftthai": "\uF88A",
    "/maihanakatleftthai": "\uF884",
    "/maihanakatthai": "\u0E31",
    "/maikurosquare": "\u3343",
    "/mairusquare": "\u3344",
    "/maitaikhuleftthai": "\uF889",
    "/maitaikhuthai": "\u0E47",
    "/maitholowleftthai": "\uF88F",
    "/maitholowrightthai": "\uF88E",
    "/maithothai": "\u0E49",
    "/maithoupperleftthai": "\uF88D",
    "/maitrilowleftthai": "\uF892",
    "/maitrilowrightthai": "\uF891",
    "/maitrithai": "\u0E4A",
    "/maitriupperleftthai": "\uF890",
    "/maiyamokthai": "\u0E46",
    "/makatakana": "\u30DE",
    "/makatakanahalfwidth": "\uFF8F",
    "/male": "\u2642",
    "/malefemale": "\u26A5",
    "/maleideographiccircled": "\u329A",
    "/malestroke": "\u26A6",
    "/malestrokemalefemale": "\u26A7",
    "/man": "\u1F468",
    "/manAndWomanHoldingHands": "\u1F46B",
    "/manDancing": "\u1F57A",
    "/manGuaPiMao": "\u1F472",
    "/manInBusinessSuitLevitating": "\u1F574",
    "/manTurban": "\u1F473",
    "/manat": "\u20BC",
    "/mansShoe": "\u1F45E",
    "/mansyonsquare": "\u3347",
    "/mantelpieceClock": "\u1F570",
    "/mapleLeaf": "\u1F341",
    "/maplighthouse": "\u26EF",
    "/maqaf:hb": "\u05BE",
    "/maqafhebrew": "\u05BE",
    "/marchtelegraph": "\u32C2",
    "/mark": "\u061C",
    "/markerdottedraisedinterpolation": "\u2E07",
    "/markerdottedtransposition": "\u2E08",
    "/markerraisedinterpolation": "\u2E06",
    "/marknoonghunna": "\u0658",
    "/marksChapter": "\u1F545",
    "/marriage": "\u26AD",
    "/mars": "\u2642",
    "/marukusquare": "\u3346",
    "/masoraCircle:hb": "\u05AF",
    "/masoracirclehebrew": "\u05AF",
    "/masquare": "\u3383",
    "/masumark": "\u303C",
    "/math:bowtie": "\u22C8",
    "/math:cuberoot": "\u221B",
    "/math:fourthroot": "\u221C",
    "/maximize": "\u1F5D6",
    "/maytelegraph": "\u32C4",
    "/mbfullwidth": "\u3386",
    "/mbopomofo": "\u3107",
    "/mbsmallfullwidth": "\u33D4",
    "/mbsquare": "\u33D4",
    "/mcircle": "\u24DC",
    "/mcubedsquare": "\u33A5",
    "/mdot": "\u1E41",
    "/mdotaccent": "\u1E41",
    "/mdotbelow": "\u1E43",
    "/measuredangle": "\u2221",
    "/measuredby": "\u225E",
    "/meatOnBone": "\u1F356",
    "/mecirclekatakana": "\u32F1",
    "/medicineideographiccircled": "\u32A9",
    "/mediumShade": "\u2592",
    "/mediumcircleblack": "\u26AB",
    "/mediumcirclewhite": "\u26AA",
    "/mediummathematicalspace": "\u205F",
    "/mediumsmallcirclewhite": "\u26AC",
    "/meem": "\u0645",
    "/meem.fina": "\uFEE2",
    "/meem.init": "\uFEE3",
    "/meem.init_alefmaksura.fina": "\uFC49",
    "/meem.init_hah.fina": "\uFC46",
    "/meem.init_hah.medi": "\uFCCF",
    "/meem.init_hah.medi_jeem.medi": "\uFD89",
    "/meem.init_hah.medi_meem.medi": "\uFD8A",
    "/meem.init_jeem.fina": "\uFC45",
    "/meem.init_jeem.medi": "\uFCCE",
    "/meem.init_jeem.medi_hah.medi": "\uFD8C",
    "/meem.init_jeem.medi_khah.medi": "\uFD92",
    "/meem.init_jeem.medi_meem.medi": "\uFD8D",
    "/meem.init_khah.fina": "\uFC47",
    "/meem.init_khah.medi": "\uFCD0",
    "/meem.init_khah.medi_jeem.medi": "\uFD8E",
    "/meem.init_khah.medi_meem.medi": "\uFD8F",
    "/meem.init_meem.fina": "\uFC48",
    "/meem.init_meem.medi": "\uFCD1",
    "/meem.init_yeh.fina": "\uFC4A",
    "/meem.isol": "\uFEE1",
    "/meem.medi": "\uFEE4",
    "/meem.medi_alef.fina": "\uFC88",
    "/meem.medi_hah.medi_yeh.fina": "\uFD8B",
    "/meem.medi_jeem.medi_yeh.fina": "\uFDC0",
    "/meem.medi_khah.medi_yeh.fina": "\uFDB9",
    "/meem.medi_meem.fina": "\uFC89",
    "/meem.medi_meem.medi_yeh.fina": "\uFDB1",
    "/meemDotAbove": "\u0765",
    "/meemDotBelow": "\u0766",
    "/meemabove": "\u06E2",
    "/meemabove.init": "\u06D8",
    "/meemarabic": "\u0645",
    "/meembelow": "\u06ED",
    "/meemfinalarabic": "\uFEE2",
    "/meeminitialarabic": "\uFEE3",
    "/meemmedialarabic": "\uFEE4",
    "/meemmeeminitialarabic": "\uFCD1",
    "/meemmeemisolatedarabic": "\uFC48",
    "/meetorusquare": "\u334D",
    "/megasquare": "\u334B",
    "/megatonsquare": "\u334C",
    "/mehiragana": "\u3081",
    "/meizierasquare": "\u337E",
    "/mekatakana": "\u30E1",
    "/mekatakanahalfwidth": "\uFF92",
    "/melon": "\u1F348",
    "/mem": "\u05DE",
    "/mem:hb": "\u05DE",
    "/memdagesh": "\uFB3E",
    "/memdageshhebrew": "\uFB3E",
    "/memhebrew": "\u05DE",
    "/memo": "\u1F4DD",
    "/memwithdagesh:hb": "\uFB3E",
    "/menarmenian": "\u0574",
    "/menorahNineBranches": "\u1F54E",
    "/menpostSindhi": "\u06FE",
    "/mens": "\u1F6B9",
    "/mepigraphicinverted": "\uA7FD",
    "/mercha:hb": "\u05A5",
    "/merchaKefulah:hb": "\u05A6",
    "/mercury": "\u263F",
    "/merkhahebrew": "\u05A5",
    "/merkhakefulahebrew": "\u05A6",
    "/merkhakefulalefthebrew": "\u05A6",
    "/merkhalefthebrew": "\u05A5",
    "/metalideographiccircled": "\u328E",
    "/metalideographicparen": "\u322E",
    "/meteg:hb": "\u05BD",
    "/metro": "\u1F687",
    "/mgfullwidth": "\u338E",
    "/mhook": "\u0271",
    "/mhzfullwidth": "\u3392",
    "/mhzsquare": "\u3392",
    "/micirclekatakana": "\u32EF",
    "/microphone": "\u1F3A4",
    "/microscope": "\u1F52C",
    "/middledotkatakanahalfwidth": "\uFF65",
    "/middot": "\u00B7",
    "/mieumacirclekorean": "\u3272",
    "/mieumaparenkorean": "\u3212",
    "/mieumcirclekorean": "\u3264",
    "/mieumkorean": "\u3141",
    "/mieumpansioskorean": "\u3170",
    "/mieumparenkorean": "\u3204",
    "/mieumpieupkorean": "\u316E",
    "/mieumsioskorean": "\u316F",
    "/mihiragana": "\u307F",
    "/mikatakana": "\u30DF",
    "/mikatakanahalfwidth": "\uFF90",
    "/mikuronsquare": "\u3348",
    "/milfullwidth": "\u33D5",
    "/militaryMedal": "\u1F396",
    "/milkyWay": "\u1F30C",
    "/mill": "\u20A5",
    "/millionscmbcyr": "\u0489",
    "/millisecond": "\u2034",
    "/millisecondreversed": "\u2037",
    "/minibus": "\u1F690",
    "/minidisc": "\u1F4BD",
    "/minimize": "\u1F5D5",
    "/minus": "\u2212",
    "/minus.inferior": "\u208B",
    "/minus.superior": "\u207B",
    "/minusbelowcmb": "\u0320",
    "/minuscircle": "\u2296",
    "/minusmod": "\u02D7",
    "/minusplus": "\u2213",
    "/minussignmod": "\u02D7",
    "/minustilde": "\u2242",
    "/minute": "\u2032",
    "/minutereversed": "\u2035",
    "/miribaarusquare": "\u334A",
    "/mirisquare": "\u3349",
    "/misc:baby": "\u1F476",
    "/misc:bell": "\u1F514",
    "/misc:dash": "\u1F4A8",
    "/misc:decimalseparator": "\u2396",
    "/misc:diamondblack": "\u2666",
    "/misc:diamondwhite": "\u2662",
    "/misc:ear": "\u1F442",
    "/misc:om": "\u1F549",
    "/misc:ring": "\u1F48D",
    "/misra": "\u060F",
    "/mlfullwidth": "\u3396",
    "/mlonglegturned": "\u0270",
    "/mlsquare": "\u3396",
    "/mlym:a": "\u0D05",
    "/mlym:aa": "\u0D06",
    "/mlym:aasign": "\u0D3E",
    "/mlym:ai": "\u0D10",
    "/mlym:aisign": "\u0D48",
    "/mlym:anusvarasign": "\u0D02",
    "/mlym:archaicii": "\u0D5F",
    "/mlym:au": "\u0D14",
    "/mlym:aulength": "\u0D57",
    "/mlym:ausign": "\u0D4C",
    "/mlym:avagrahasign": "\u0D3D",
    "/mlym:ba": "\u0D2C",
    "/mlym:bha": "\u0D2D",
    "/mlym:ca": "\u0D1A",
    "/mlym:candrabindusign": "\u0D01",
    "/mlym:cha": "\u0D1B",
    "/mlym:circularviramasign": "\u0D3C",
    "/mlym:combininganusvaraabovesign": "\u0D00",
    "/mlym:da": "\u0D26",
    "/mlym:date": "\u0D79",
    "/mlym:dda": "\u0D21",
    "/mlym:ddha": "\u0D22",
    "/mlym:dha": "\u0D27",
    "/mlym:dotreph": "\u0D4E",
    "/mlym:e": "\u0D0E",
    "/mlym:ee": "\u0D0F",
    "/mlym:eesign": "\u0D47",
    "/mlym:eight": "\u0D6E",
    "/mlym:esign": "\u0D46",
    "/mlym:five": "\u0D6B",
    "/mlym:four": "\u0D6A",
    "/mlym:ga": "\u0D17",
    "/mlym:gha": "\u0D18",
    "/mlym:ha": "\u0D39",
    "/mlym:i": "\u0D07",
    "/mlym:ii": "\u0D08",
    "/mlym:iisign": "\u0D40",
    "/mlym:isign": "\u0D3F",
    "/mlym:ja": "\u0D1C",
    "/mlym:jha": "\u0D1D",
    "/mlym:ka": "\u0D15",
    "/mlym:kchillu": "\u0D7F",
    "/mlym:kha": "\u0D16",
    "/mlym:la": "\u0D32",
    "/mlym:lchillu": "\u0D7D",
    "/mlym:lla": "\u0D33",
    "/mlym:llchillu": "\u0D7E",
    "/mlym:llla": "\u0D34",
    "/mlym:lllchillu": "\u0D56",
    "/mlym:llvocal": "\u0D61",
    "/mlym:llvocalsign": "\u0D63",
    "/mlym:lvocal": "\u0D0C",
    "/mlym:lvocalsign": "\u0D62",
    "/mlym:ma": "\u0D2E",
    "/mlym:mchillu": "\u0D54",
    "/mlym:na": "\u0D28",
    "/mlym:nchillu": "\u0D7B",
    "/mlym:nga": "\u0D19",
    "/mlym:nine": "\u0D6F",
    "/mlym:nna": "\u0D23",
    "/mlym:nnchillu": "\u0D7A",
    "/mlym:nnna": "\u0D29",
    "/mlym:nya": "\u0D1E",
    "/mlym:o": "\u0D12",
    "/mlym:one": "\u0D67",
    "/mlym:oneeighth": "\u0D77",
    "/mlym:onefifth": "\u0D5E",
    "/mlym:onefortieth": "\u0D59",
    "/mlym:onehalf": "\u0D74",
    "/mlym:onehundred": "\u0D71",
    "/mlym:oneone-hundred-and-sixtieth": "\u0D58",
    "/mlym:onequarter": "\u0D73",
    "/mlym:onesixteenth": "\u0D76",
    "/mlym:onetenth": "\u0D5C",
    "/mlym:onethousand": "\u0D72",
    "/mlym:onetwentieth": "\u0D5B",
    "/mlym:oo": "\u0D13",
    "/mlym:oosign": "\u0D4B",
    "/mlym:osign": "\u0D4A",
    "/mlym:pa": "\u0D2A",
    "/mlym:parasign": "\u0D4F",
    "/mlym:pha": "\u0D2B",
    "/mlym:ra": "\u0D30",
    "/mlym:rra": "\u0D31",
    "/mlym:rrchillu": "\u0D7C",
    "/mlym:rrvocal": "\u0D60",
    "/mlym:rrvocalsign": "\u0D44",
    "/mlym:rvocal": "\u0D0B",
    "/mlym:rvocalsign": "\u0D43",
    "/mlym:sa": "\u0D38",
    "/mlym:seven": "\u0D6D",
    "/mlym:sha": "\u0D36",
    "/mlym:six": "\u0D6C",
    "/mlym:ssa": "\u0D37",
    "/mlym:ta": "\u0D24",
    "/mlym:ten": "\u0D70",
    "/mlym:tha": "\u0D25",
    "/mlym:three": "\u0D69",
    "/mlym:threeeightieths": "\u0D5A",
    "/mlym:threequarters": "\u0D75",
    "/mlym:threesixteenths": "\u0D78",
    "/mlym:threetwentieths": "\u0D5D",
    "/mlym:tta": "\u0D1F",
    "/mlym:ttha": "\u0D20",
    "/mlym:ttta": "\u0D3A",
    "/mlym:two": "\u0D68",
    "/mlym:u": "\u0D09",
    "/mlym:usign": "\u0D41",
    "/mlym:uu": "\u0D0A",
    "/mlym:uusign": "\u0D42",
    "/mlym:va": "\u0D35",
    "/mlym:verticalbarviramasign": "\u0D3B",
    "/mlym:viramasign": "\u0D4D",
    "/mlym:visargasign": "\u0D03",
    "/mlym:ya": "\u0D2F",
    "/mlym:ychillu": "\u0D55",
    "/mlym:zero": "\u0D66",
    "/mm2fullwidth": "\u339F",
    "/mm3fullwidth": "\u33A3",
    "/mmcubedsquare": "\u33A3",
    "/mmfullwidth": "\u339C",
    "/mmonospace": "\uFF4D",
    "/mmsquaredsquare": "\u339F",
    "/mobilePhone": "\u1F4F1",
    "/mobilePhoneOff": "\u1F4F4",
    "/mobilePhoneRightwardsArrowAtLeft": "\u1F4F2",
    "/mocirclekatakana": "\u32F2",
    "/models": "\u22A7",
    "/mohiragana": "\u3082",
    "/mohmfullwidth": "\u33C1",
    "/mohmsquare": "\u33C1",
    "/mokatakana": "\u30E2",
    "/mokatakanahalfwidth": "\uFF93",
    "/molfullwidth": "\u33D6",
    "/molsquare": "\u33D6",
    "/momathai": "\u0E21",
    "/moneyBag": "\u1F4B0",
    "/moneyWings": "\u1F4B8",
    "/mong:a": "\u1820",
    "/mong:aaligali": "\u1887",
    "/mong:ahaligali": "\u1897",
    "/mong:ang": "\u1829",
    "/mong:angsibe": "\u1862",
    "/mong:angtodo": "\u184A",
    "/mong:anusvaraonealigali": "\u1880",
    "/mong:ba": "\u182A",
    "/mong:baludaaligali": "\u1885",
    "/mong:baludaaligalithree": "\u1886",
    "/mong:batodo": "\u184B",
    "/mong:bhamanchualigali": "\u18A8",
    "/mong:birga": "\u1800",
    "/mong:caaligali": "\u188B",
    "/mong:camanchualigali": "\u189C",
    "/mong:cha": "\u1834",
    "/mong:chasibe": "\u1871",
    "/mong:chatodo": "\u1852",
    "/mong:chi": "\u1842",
    "/mong:colon": "\u1804",
    "/mong:comma": "\u1802",
    "/mong:commamanchu": "\u1808",
    "/mong:cyamanchualigali": "\u18A3",
    "/mong:da": "\u1833",
    "/mong:daaligali": "\u1891",
    "/mong:dagalgaaligali": "\u18A9",
    "/mong:damarualigali": "\u1882",
    "/mong:dasibe": "\u1869",
    "/mong:datodo": "\u1851",
    "/mong:ddaaligali": "\u188E",
    "/mong:ddhamanchualigali": "\u189F",
    "/mong:dhamanchualigali": "\u18A1",
    "/mong:dzatodo": "\u185C",
    "/mong:e": "\u1821",
    "/mong:ee": "\u1827",
    "/mong:eight": "\u1818",
    "/mong:ellipsis": "\u1801",
    "/mong:esibe": "\u185D",
    "/mong:etodo": "\u1844",
    "/mong:fa": "\u1839",
    "/mong:famanchu": "\u1876",
    "/mong:fasibe": "\u186B",
    "/mong:five": "\u1815",
    "/mong:four": "\u1814",
    "/mong:fourdots": "\u1805",
    "/mong:freevariationselectorone": "\u180B",
    "/mong:freevariationselectorthree": "\u180D",
    "/mong:freevariationselectortwo": "\u180C",
    "/mong:ga": "\u182D",
    "/mong:gaasibe": "\u186C",
    "/mong:gaatodo": "\u1858",
    "/mong:gasibe": "\u1864",
    "/mong:gatodo": "\u184E",
    "/mong:ghamanchualigali": "\u189A",
    "/mong:haa": "\u183E",
    "/mong:haasibe": "\u186D",
    "/mong:haatodo": "\u1859",
    "/mong:hasibe": "\u1865",
    "/mong:i": "\u1822",
    "/mong:ialigali": "\u1888",
    "/mong:imanchu": "\u1873",
    "/mong:isibe": "\u185E",
    "/mong:itodo": "\u1845",
    "/mong:iysibe": "\u185F",
    "/mong:ja": "\u1835",
    "/mong:jasibe": "\u186A",
    "/mong:jatodo": "\u1853",
    "/mong:jhamanchualigali": "\u189D",
    "/mong:jiatodo": "\u185A",
    "/mong:ka": "\u183A",
    "/mong:kaaligali": "\u1889",
    "/mong:kamanchu": "\u1874",
    "/mong:kasibe": "\u1863",
    "/mong:katodo": "\u1857",
    "/mong:kha": "\u183B",
    "/mong:la": "\u182F",
    "/mong:lha": "\u1840",
    "/mong:lhamanchualigali": "\u18AA",
    "/mong:longvowelsigntodo": "\u1843",
    "/mong:ma": "\u182E",
    "/mong:matodo": "\u184F",
    "/mong:na": "\u1828",
    "/mong:ngaaligali": "\u188A",
    "/mong:ngamanchualigali": "\u189B",
    "/mong:niatodo": "\u185B",
    "/mong:nine": "\u1819",
    "/mong:nirugu": "\u180A",
    "/mong:nnaaligali": "\u188F",
    "/mong:o": "\u1823",
    "/mong:oe": "\u1825",
    "/mong:oetodo": "\u1848",
    "/mong:one": "\u1811",
    "/mong:otodo": "\u1846",
    "/mong:pa": "\u182B",
    "/mong:paaligali": "\u1892",
    "/mong:pasibe": "\u1866",
    "/mong:patodo": "\u184C",
    "/mong:period": "\u1803",
    "/mong:periodmanchu": "\u1809",
    "/mong:phaaligali": "\u1893",
    "/mong:qa": "\u182C",
    "/mong:qatodo": "\u184D",
    "/mong:ra": "\u1837",
    "/mong:raasibe": "\u1870",
    "/mong:ramanchu": "\u1875",
    "/mong:sa": "\u1830",
    "/mong:seven": "\u1817",
    "/mong:sha": "\u1831",
    "/mong:shasibe": "\u1867",
    "/mong:six": "\u1816",
    "/mong:softhyphentodo": "\u1806",
    "/mong:ssaaligali": "\u1894",
    "/mong:ssamanchualigali": "\u18A2",
    "/mong:syllableboundarymarkersibe": "\u1807",
    "/mong:ta": "\u1832",
    "/mong:taaligali": "\u1890",
    "/mong:tamanchualigali": "\u18A0",
    "/mong:tasibe": "\u1868",
    "/mong:tatodo": "\u1850",
    "/mong:tatodoaligali": "\u1898",
    "/mong:three": "\u1813",
    "/mong:tsa": "\u183C",
    "/mong:tsasibe": "\u186E",
    "/mong:tsatodo": "\u1854",
    "/mong:ttaaligali": "\u188C",
    "/mong:ttamanchualigali": "\u189E",
    "/mong:tthaaligali": "\u188D",
    "/mong:two": "\u1812",
    "/mong:u": "\u1824",
    "/mong:ualigalihalf": "\u18A6",
    "/mong:ubadamaaligali": "\u1883",
    "/mong:ubadamaaligaliinverted": "\u1884",
    "/mong:ue": "\u1826",
    "/mong:uesibe": "\u1860",
    "/mong:uetodo": "\u1849",
    "/mong:usibe": "\u1861",
    "/mong:utodo": "\u1847",
    "/mong:visargaonealigali": "\u1881",
    "/mong:vowelseparator": "\u180E",
    "/mong:wa": "\u1838",
    "/mong:watodo": "\u1856",
    "/mong:ya": "\u1836",
    "/mong:yaaligalihalf": "\u18A7",
    "/mong:yatodo": "\u1855",
    "/mong:za": "\u183D",
    "/mong:zaaligali": "\u1896",
    "/mong:zamanchualigali": "\u18A5",
    "/mong:zasibe": "\u186F",
    "/mong:zero": "\u1810",
    "/mong:zhaaligali": "\u1895",
    "/mong:zhamanchu": "\u1877",
    "/mong:zhamanchualigali": "\u18A4",
    "/mong:zhasibe": "\u1872",
    "/mong:zhatodoaligali": "\u1899",
    "/mong:zhi": "\u1841",
    "/mong:zra": "\u183F",
    "/monkey": "\u1F412",
    "/monkeyFace": "\u1F435",
    "/monogramyang": "\u268A",
    "/monogramyin": "\u268B",
    "/monorail": "\u1F69D",
    "/monostable": "\u238D",
    "/moodBubble": "\u1F5F0",
    "/moonViewingCeremony": "\u1F391",
    "/moonideographiccircled": "\u328A",
    "/moonideographicparen": "\u322A",
    "/moonlilithblack": "\u26B8",
    "/mosque": "\u1F54C",
    "/motorBoat": "\u1F6E5",
    "/motorScooter": "\u1F6F5",
    "/motorway": "\u1F6E3",
    "/mountFuji": "\u1F5FB",
    "/mountain": "\u26F0",
    "/mountainBicyclist": "\u1F6B5",
    "/mountainCableway": "\u1F6A0",
    "/mountainRailway": "\u1F69E",
    "/mouse": "\u1F401",
    "/mouseFace": "\u1F42D",
    "/mouth": "\u1F444",
    "/movers2fullwidth": "\u33A8",
    "/moversfullwidth": "\u33A7",
    "/moverssquare": "\u33A7",
    "/moverssquaredsquare": "\u33A8",
    "/movieCamera": "\u1F3A5",
    "/moyai": "\u1F5FF",
    "/mpafullwidth": "\u33AB",
    "/mparen": "\u24A8",
    "/mparenthesized": "\u24A8",
    "/mpasquare": "\u33AB",
    "/msfullwidth": "\u33B3",
    "/mssquare": "\u33B3",
    "/msuperior": "\uF6EF",
    "/mturned": "\u026F",
    "/mu": "\u00B5",
    "/mu.math": "\u00B5",
    "/mu1": "\u00B5",
    "/muafullwidth": "\u3382",
    "/muasquare": "\u3382",
    "/muchgreater": "\u226B",
    "/muchless": "\u226A",
    "/mucirclekatakana": "\u32F0",
    "/muffullwidth": "\u338C",
    "/mufsquare": "\u338C",
    "/mugfullwidth": "\u338D",
    "/mugreek": "\u03BC",
    "/mugsquare": "\u338D",
    "/muhiragana": "\u3080",
    "/mukatakana": "\u30E0",
    "/mukatakanahalfwidth": "\uFF91",
    "/mulfullwidth": "\u3395",
    "/mulsquare": "\u3395",
    "/multimap": "\u22B8",
    "/multimapleft": "\u27DC",
    "/multipleMusicalNotes": "\u1F3B6",
    "/multiply": "\u00D7",
    "/multiset": "\u228C",
    "/multisetmultiplication": "\u228D",
    "/multisetunion": "\u228E",
    "/mum": "\uA773",
    "/mumfullwidth": "\u339B",
    "/mumsquare": "\u339B",
    "/munach:hb": "\u05A3",
    "/munahhebrew": "\u05A3",
    "/munahlefthebrew": "\u05A3",
    "/musfullwidth": "\u33B2",
    "/mushroom": "\u1F344",
    "/musicalKeyboard": "\u1F3B9",
    "/musicalKeyboardJacks": "\u1F398",
    "/musicalNote": "\u1F3B5",
    "/musicalScore": "\u1F3BC",
    "/musicalnote": "\u266A",
    "/musicalnotedbl": "\u266B",
    "/musicflat": "\u266D",
    "/musicflatsign": "\u266D",
    "/musicnatural": "\u266E",
    "/musicsharp": "\u266F",
    "/musicsharpsign": "\u266F",
    "/mussquare": "\u33B2",
    "/muvfullwidth": "\u33B6",
    "/muvsquare": "\u33B6",
    "/muwfullwidth": "\u33BC",
    "/muwsquare": "\u33BC",
    "/mvfullwidth": "\u33B7",
    "/mvmegafullwidth": "\u33B9",
    "/mvmegasquare": "\u33B9",
    "/mvsquare": "\u33B7",
    "/mwfullwidth": "\u33BD",
    "/mwmegafullwidth": "\u33BF",
    "/mwmegasquare": "\u33BF",
    "/mwsquare": "\u33BD",
    "/n": "\u006E",
    "/n.inferior": "\u2099",
    "/n.superior": "\u207F",
    "/nabengali": "\u09A8",
    "/nabla": "\u2207",
    "/nacirclekatakana": "\u32E4",
    "/nacute": "\u0144",
    "/nadeva": "\u0928",
    "/nafullwidth": "\u3381",
    "/nagujarati": "\u0AA8",
    "/nagurmukhi": "\u0A28",
    "/nahiragana": "\u306A",
    "/nailPolish": "\u1F485",
    "/naira": "\u20A6",
    "/nakatakana": "\u30CA",
    "/nakatakanahalfwidth": "\uFF85",
    "/nameBadge": "\u1F4DB",
    "/nameideographiccircled": "\u3294",
    "/nameideographicparen": "\u3234",
    "/namurda": "\uA99F",
    "/nand": "\u22BC",
    "/nanosquare": "\u3328",
    "/napostrophe": "\u0149",
    "/narrownobreakspace": "\u202F",
    "/nasquare": "\u3381",
    "/nationalPark": "\u1F3DE",
    "/nationaldigitshapes": "\u206E",
    "/nbopomofo": "\u310B",
    "/nbspace": "\u00A0",
    "/ncaron": "\u0148",
    "/ncedilla": "\u0146",
    "/ncircle": "\u24DD",
    "/ncircumflexbelow": "\u1E4B",
    "/ncommaaccent": "\u0146",
    "/ncurl": "\u0235",
    "/ndescender": "\uA791",
    "/ndot": "\u1E45",
    "/ndotaccent": "\u1E45",
    "/ndotbelow": "\u1E47",
    "/necirclekatakana": "\u32E7",
    "/necktie": "\u1F454",
    "/negatedturnstiledblverticalbarright": "\u22AF",
    "/nehiragana": "\u306D",
    "/neirapproximatelynoractuallyequal": "\u2247",
    "/neirasersetnorequalup": "\u2289",
    "/neirasubsetnorequal": "\u2288",
    "/neirgreaternorequal": "\u2271",
    "/neirgreaternorequivalent": "\u2275",
    "/neirgreaternorless": "\u2279",
    "/neirlessnorequal": "\u2270",
    "/neirlessnorequivalent": "\u2274",
    "/neirlessnorgreater": "\u2278",
    "/nekatakana": "\u30CD",
    "/nekatakanahalfwidth": "\uFF88",
    "/neptune": "\u2646",
    "/neuter": "\u26B2",
    "/neutralFace": "\u1F610",
    "/newMoon": "\u1F311",
    "/newMoonFace": "\u1F31A",
    "/newsheqel": "\u20AA",
    "/newsheqelsign": "\u20AA",
    "/newspaper": "\u1F4F0",
    "/newsquare": "\u1F195",
    "/nextpage": "\u2398",
    "/nffullwidth": "\u338B",
    "/nfsquare": "\u338B",
    "/ng.fina": "\uFBD4",
    "/ng.init": "\uFBD5",
    "/ng.isol": "\uFBD3",
    "/ng.medi": "\uFBD6",
    "/ngabengali": "\u0999",
    "/ngadeva": "\u0919",
    "/ngagujarati": "\u0A99",
    "/ngagurmukhi": "\u0A19",
    "/ngalelet": "\uA98A",
    "/ngaleletraswadi": "\uA98B",
    "/ngoeh": "\u06B1",
    "/ngoeh.fina": "\uFB9B",
    "/ngoeh.init": "\uFB9C",
    "/ngoeh.isol": "\uFB9A",
    "/ngoeh.medi": "\uFB9D",
    "/ngonguthai": "\u0E07",
    "/ngrave": "\u01F9",
    "/ngsquare": "\u1F196",
    "/nhiragana": "\u3093",
    "/nhookleft": "\u0272",
    "/nhookretroflex": "\u0273",
    "/nicirclekatakana": "\u32E5",
    "/nieunacirclekorean": "\u326F",
    "/nieunaparenkorean": "\u320F",
    "/nieuncieuckorean": "\u3135",
    "/nieuncirclekorean": "\u3261",
    "/nieunhieuhkorean": "\u3136",
    "/nieunkorean": "\u3134",
    "/nieunpansioskorean": "\u3168",
    "/nieunparenkorean": "\u3201",
    "/nieunsioskorean": "\u3167",
    "/nieuntikeutkorean": "\u3166",
    "/nightStars": "\u1F303",
    "/nightideographiccircled": "\u32B0",
    "/nihiragana": "\u306B",
    "/nikatakana": "\u30CB",
    "/nikatakanahalfwidth": "\uFF86",
    "/nikhahitleftthai": "\uF899",
    "/nikhahitthai": "\u0E4D",
    "/nine": "\u0039",
    "/nine.inferior": "\u2089",
    "/nine.roman": "\u2168",
    "/nine.romansmall": "\u2178",
    "/nine.superior": "\u2079",
    "/ninearabic": "\u0669",
    "/ninebengali": "\u09EF",
    "/ninecircle": "\u2468",
    "/ninecircledbl": "\u24FD",
    "/ninecircleinversesansserif": "\u2792",
    "/ninecomma": "\u1F10A",
    "/ninedeva": "\u096F",
    "/ninefar": "\u06F9",
    "/ninegujarati": "\u0AEF",
    "/ninegurmukhi": "\u0A6F",
    "/ninehackarabic": "\u0669",
    "/ninehangzhou": "\u3029",
    "/nineideographiccircled": "\u3288",
    "/nineideographicparen": "\u3228",
    "/nineinferior": "\u2089",
    "/ninemonospace": "\uFF19",
    "/nineoldstyle": "\uF739",
    "/nineparen": "\u247C",
    "/nineparenthesized": "\u247C",
    "/nineperiod": "\u2490",
    "/ninepersian": "\u06F9",
    "/nineroman": "\u2178",
    "/ninesuperior": "\u2079",
    "/nineteencircle": "\u2472",
    "/nineteencircleblack": "\u24F3",
    "/nineteenparen": "\u2486",
    "/nineteenparenthesized": "\u2486",
    "/nineteenperiod": "\u249A",
    "/ninethai": "\u0E59",
    "/nj": "\u01CC",
    "/njecyr": "\u045A",
    "/njecyrillic": "\u045A",
    "/njekomicyr": "\u050B",
    "/nkatakana": "\u30F3",
    "/nkatakanahalfwidth": "\uFF9D",
    "/nlegrightlong": "\u019E",
    "/nlinebelow": "\u1E49",
    "/nlongrightleg": "\u019E",
    "/nmbr:oneeighth": "\u215B",
    "/nmbr:onefifth": "\u2155",
    "/nmbr:onetenth": "\u2152",
    "/nmfullwidth": "\u339A",
    "/nmonospace": "\uFF4E",
    "/nmsquare": "\u339A",
    "/nnabengali": "\u09A3",
    "/nnadeva": "\u0923",
    "/nnagujarati": "\u0AA3",
    "/nnagurmukhi": "\u0A23",
    "/nnnadeva": "\u0929",
    "/noBicycles": "\u1F6B3",
    "/noEntrySign": "\u1F6AB",
    "/noMobilePhones": "\u1F4F5",
    "/noOneUnderEighteen": "\u1F51E",
    "/noPedestrians": "\u1F6B7",
    "/noPiracy": "\u1F572",
    "/noSmoking": "\u1F6AD",
    "/nobliquestroke": "\uA7A5",
    "/nocirclekatakana": "\u32E8",
    "/nodeascending": "\u260A",
    "/nodedescending": "\u260B",
    "/noentry": "\u26D4",
    "/nohiragana": "\u306E",
    "/nokatakana": "\u30CE",
    "/nokatakanahalfwidth": "\uFF89",
    "/nominaldigitshapes": "\u206F",
    "/nonPotableWater": "\u1F6B1",
    "/nonbreakinghyphen": "\u2011",
    "/nonbreakingspace": "\u00A0",
    "/nonenthai": "\u0E13",
    "/nonuthai": "\u0E19",
    "/noon": "\u0646",
    "/noon.fina": "\uFEE6",
    "/noon.init": "\uFEE7",
    "/noon.init_alefmaksura.fina": "\uFC4F",
    "/noon.init_hah.fina": "\uFC4C",
    "/noon.init_hah.medi": "\uFCD3",
    "/noon.init_hah.medi_meem.medi": "\uFD95",
    "/noon.init_heh.medi": "\uFCD6",
    "/noon.init_jeem.fina": "\uFC4B",
    "/noon.init_jeem.medi": "\uFCD2",
    "/noon.init_jeem.medi_hah.medi": "\uFDB8",
    "/noon.init_jeem.medi_meem.medi": "\uFD98",
    "/noon.init_khah.fina": "\uFC4D",
    "/noon.init_khah.medi": "\uFCD4",
    "/noon.init_meem.fina": "\uFC4E",
    "/noon.init_meem.medi": "\uFCD5",
    "/noon.init_yeh.fina": "\uFC50",
    "/noon.isol": "\uFEE5",
    "/noon.medi": "\uFEE8",
    "/noon.medi_alefmaksura.fina": "\uFC8E",
    "/noon.medi_hah.medi_alefmaksura.fina": "\uFD96",
    "/noon.medi_hah.medi_yeh.fina": "\uFDB3",
    "/noon.medi_heh.medi": "\uFCEF",
    "/noon.medi_jeem.medi_alefmaksura.fina": "\uFD99",
    "/noon.medi_jeem.medi_hah.fina": "\uFDBD",
    "/noon.medi_jeem.medi_meem.fina": "\uFD97",
    "/noon.medi_jeem.medi_yeh.fina": "\uFDC7",
    "/noon.medi_meem.fina": "\uFC8C",
    "/noon.medi_meem.medi": "\uFCEE",
    "/noon.medi_meem.medi_alefmaksura.fina": "\uFD9B",
    "/noon.medi_meem.medi_yeh.fina": "\uFD9A",
    "/noon.medi_noon.fina": "\uFC8D",
    "/noon.medi_reh.fina": "\uFC8A",
    "/noon.medi_yeh.fina": "\uFC8F",
    "/noon.medi_zain.fina": "\uFC8B",
    "/noonSmallTah": "\u0768",
    "/noonSmallV": "\u0769",
    "/noonTwoDotsBelow": "\u0767",
    "/noonabove": "\u06E8",
    "/noonarabic": "\u0646",
    "/noondotbelow": "\u06B9",
    "/noonfinalarabic": "\uFEE6",
    "/noonghunna": "\u06BA",
    "/noonghunna.fina": "\uFB9F",
    "/noonghunna.isol": "\uFB9E",
    "/noonghunnaarabic": "\u06BA",
    "/noonghunnafinalarabic": "\uFB9F",
    "/noonhehinitialarabic": "\uFEE7",
    "/nooninitialarabic": "\uFEE7",
    "/noonjeeminitialarabic": "\uFCD2",
    "/noonjeemisolatedarabic": "\uFC4B",
    "/noonmedialarabic": "\uFEE8",
    "/noonmeeminitialarabic": "\uFCD5",
    "/noonmeemisolatedarabic": "\uFC4E",
    "/noonnoonfinalarabic": "\uFC8D",
    "/noonring": "\u06BC",
    "/noonthreedotsabove": "\u06BD",
    "/nor": "\u22BD",
    "/nordicmark": "\u20BB",
    "/normalfacrsemidirectproductleft": "\u22C9",
    "/normalfacrsemidirectproductright": "\u22CA",
    "/normalsubgroorequalup": "\u22B4",
    "/normalsubgroup": "\u22B2",
    "/northeastPointingAirplane": "\u1F6EA",
    "/nose": "\u1F443",
    "/notalmostequal": "\u2249",
    "/notasersetup": "\u2285",
    "/notasympticallyequal": "\u2244",
    "/notcheckmark": "\u237B",
    "/notchedLeftSemicircleThreeDots": "\u1F543",
    "/notchedRightSemicircleThreeDots": "\u1F544",
    "/notcontains": "\u220C",
    "/note": "\u1F5C8",
    "/notePad": "\u1F5CA",
    "/notePage": "\u1F5C9",
    "/notebook": "\u1F4D3",
    "/notebookDecorativeCover": "\u1F4D4",
    "/notelement": "\u2209",
    "/notelementof": "\u2209",
    "/notequal": "\u2260",
    "/notequivalent": "\u226D",
    "/notexistential": "\u2204",
    "/notgreater": "\u226F",
    "/notgreaternorequal": "\u2271",
    "/notgreaternorless": "\u2279",
    "/notidentical": "\u2262",
    "/notless": "\u226E",
    "/notlessnorequal": "\u2270",
    "/notnormalsubgroorequalup": "\u22EC",
    "/notnormalsubgroup": "\u22EA",
    "/notparallel": "\u2226",
    "/notprecedes": "\u2280",
    "/notsignturned": "\u2319",
    "/notsquareimageorequal": "\u22E2",
    "/notsquareoriginalorequal": "\u22E3",
    "/notsubset": "\u2284",
    "/notsucceeds": "\u2281",
    "/notsuperset": "\u2285",
    "/nottilde": "\u2241",
    "/nottosquare": "\u3329",
    "/nottrue": "\u22AD",
    "/novembertelegraph": "\u32CA",
    "/nowarmenian": "\u0576",
    "/nparen": "\u24A9",
    "/nparenthesized": "\u24A9",
    "/nretroflex": "\u0273",
    "/nsfullwidth": "\u33B1",
    "/nssquare": "\u33B1",
    "/nsuperior": "\u207F",
    "/ntilde": "\u00F1",
    "/nu": "\u03BD",
    "/nucirclekatakana": "\u32E6",
    "/nuhiragana": "\u306C",
    "/nukatakana": "\u30CC",
    "/nukatakanahalfwidth": "\uFF87",
    "/nuktabengali": "\u09BC",
    "/nuktadeva": "\u093C",
    "/nuktagujarati": "\u0ABC",
    "/nuktagurmukhi": "\u0A3C",
    "/num": "\uA774",
    "/numbermarkabove": "\u0605",
    "/numbersign": "\u0023",
    "/numbersignmonospace": "\uFF03",
    "/numbersignsmall": "\uFE5F",
    "/numeralsign": "\u0374",
    "/numeralsigngreek": "\u0374",
    "/numeralsignlowergreek": "\u0375",
    "/numero": "\u2116",
    "/nun": "\u05E0",
    "/nun:hb": "\u05E0",
    "/nunHafukha:hb": "\u05C6",
    "/nundagesh": "\uFB40",
    "/nundageshhebrew": "\uFB40",
    "/nunhebrew": "\u05E0",
    "/nunwithdagesh:hb": "\uFB40",
    "/nutAndBolt": "\u1F529",
    "/nvfullwidth": "\u33B5",
    "/nvsquare": "\u33B5",
    "/nwfullwidth": "\u33BB",
    "/nwsquare": "\u33BB",
    "/nyabengali": "\u099E",
    "/nyadeva": "\u091E",
    "/nyagujarati": "\u0A9E",
    "/nyagurmukhi": "\u0A1E",
    "/nyamurda": "\uA998",
    "/nyeh": "\u0683",
    "/nyeh.fina": "\uFB77",
    "/nyeh.init": "\uFB78",
    "/nyeh.isol": "\uFB76",
    "/nyeh.medi": "\uFB79",
    "/o": "\u006F",
    "/o.inferior": "\u2092",
    "/oacute": "\u00F3",
    "/oangthai": "\u0E2D",
    "/obarcyr": "\u04E9",
    "/obardieresiscyr": "\u04EB",
    "/obarred": "\u0275",
    "/obarredcyrillic": "\u04E9",
    "/obarreddieresiscyrillic": "\u04EB",
    "/obelosdotted": "\u2E13",
    "/obengali": "\u0993",
    "/obopomofo": "\u311B",
    "/obreve": "\u014F",
    "/observereye": "\u23FF",
    "/ocandradeva": "\u0911",
    "/ocandragujarati": "\u0A91",
    "/ocandravowelsigndeva": "\u0949",
    "/ocandravowelsigngujarati": "\u0AC9",
    "/ocaron": "\u01D2",
    "/ocircle": "\u24DE",
    "/ocirclekatakana": "\u32D4",
    "/ocircumflex": "\u00F4",
    "/ocircumflexacute": "\u1ED1",
    "/ocircumflexdotbelow": "\u1ED9",
    "/ocircumflexgrave": "\u1ED3",
    "/ocircumflexhoi": "\u1ED5",
    "/ocircumflexhookabove": "\u1ED5",
    "/ocircumflextilde": "\u1ED7",
    "/ocr:bowtie": "\u2445",
    "/ocr:dash": "\u2448",
    "/octagonalSign": "\u1F6D1",
    "/octobertelegraph": "\u32C9",
    "/octopus": "\u1F419",
    "/ocyr": "\u043E",
    "/ocyrillic": "\u043E",
    "/odblacute": "\u0151",
    "/odblgrave": "\u020D",
    "/oden": "\u1F362",
    "/odeva": "\u0913",
    "/odieresis": "\u00F6",
    "/odieresiscyr": "\u04E7",
    "/odieresiscyrillic": "\u04E7",
    "/odieresismacron": "\u022B",
    "/odot": "\u022F",
    "/odotbelow": "\u1ECD",
    "/odotmacron": "\u0231",
    "/oe": "\u0153",
    "/oe.fina": "\uFBDA",
    "/oe.isol": "\uFBD9",
    "/oekirghiz": "\u06C5",
    "/oekirghiz.fina": "\uFBE1",
    "/oekirghiz.isol": "\uFBE0",
    "/oekorean": "\u315A",
    "/officeBuilding": "\u1F3E2",
    "/ogonek": "\u02DB",
    "/ogonekcmb": "\u0328",
    "/ograve": "\u00F2",
    "/ogravedbl": "\u020D",
    "/ogujarati": "\u0A93",
    "/oharmenian": "\u0585",
    "/ohiragana": "\u304A",
    "/ohm": "\u2126",
    "/ohminverted": "\u2127",
    "/ohoi": "\u1ECF",
    "/ohookabove": "\u1ECF",
    "/ohorn": "\u01A1",
    "/ohornacute": "\u1EDB",
    "/ohorndotbelow": "\u1EE3",
    "/ohorngrave": "\u1EDD",
    "/ohornhoi": "\u1EDF",
    "/ohornhookabove": "\u1EDF",
    "/ohorntilde": "\u1EE1",
    "/ohungarumlaut": "\u0151",
    "/ohuparen": "\u321E",
    "/oi": "\u01A3",
    "/oilDrum": "\u1F6E2",
    "/oinvertedbreve": "\u020F",
    "/ojeonparen": "\u321D",
    "/okHandSign": "\u1F44C",
    "/okatakana": "\u30AA",
    "/okatakanahalfwidth": "\uFF75",
    "/okorean": "\u3157",
    "/oksquare": "\u1F197",
    "/oldKey": "\u1F5DD",
    "/oldPersonalComputer": "\u1F5B3",
    "/olderMan": "\u1F474",
    "/olderWoman": "\u1F475",
    "/ole:hb": "\u05AB",
    "/olehebrew": "\u05AB",
    "/oloop": "\uA74D",
    "/olowringinside": "\u2C7A",
    "/omacron": "\u014D",
    "/omacronacute": "\u1E53",
    "/omacrongrave": "\u1E51",
    "/omdeva": "\u0950",
    "/omega": "\u03C9",
    "/omega1": "\u03D6",
    "/omegaacute": "\u1F7D",
    "/omegaacuteiotasub": "\u1FF4",
    "/omegaasper": "\u1F61",
    "/omegaasperacute": "\u1F65",
    "/omegaasperacuteiotasub": "\u1FA5",
    "/omegaaspergrave": "\u1F63",
    "/omegaaspergraveiotasub": "\u1FA3",
    "/omegaasperiotasub": "\u1FA1",
    "/omegaaspertilde": "\u1F67",
    "/omegaaspertildeiotasub": "\u1FA7",
    "/omegaclosed": "\u0277",
    "/omegacyr": "\u0461",
    "/omegacyrillic": "\u0461",
    "/omegafunc": "\u2375",
    "/omegagrave": "\u1F7C",
    "/omegagraveiotasub": "\u1FF2",
    "/omegaiotasub": "\u1FF3",
    "/omegalatinclosed": "\u0277",
    "/omegalenis": "\u1F60",
    "/omegalenisacute": "\u1F64",
    "/omegalenisacuteiotasub": "\u1FA4",
    "/omegalenisgrave": "\u1F62",
    "/omegalenisgraveiotasub": "\u1FA2",
    "/omegalenisiotasub": "\u1FA0",
    "/omegalenistilde": "\u1F66",
    "/omegalenistildeiotasub": "\u1FA6",
    "/omegaroundcyr": "\u047B",
    "/omegaroundcyrillic": "\u047B",
    "/omegatilde": "\u1FF6",
    "/omegatildeiotasub": "\u1FF7",
    "/omegatitlocyr": "\u047D",
    "/omegatitlocyrillic": "\u047D",
    "/omegatonos": "\u03CE",
    "/omegaunderlinefunc": "\u2379",
    "/omgujarati": "\u0AD0",
    "/omicron": "\u03BF",
    "/omicronacute": "\u1F79",
    "/omicronasper": "\u1F41",
    "/omicronasperacute": "\u1F45",
    "/omicronaspergrave": "\u1F43",
    "/omicrongrave": "\u1F78",
    "/omicronlenis": "\u1F40",
    "/omicronlenisacute": "\u1F44",
    "/omicronlenisgrave": "\u1F42",
    "/omicrontonos": "\u03CC",
    "/omonospace": "\uFF4F",
    "/onExclamationMarkLeftRightArrowAbove": "\u1F51B",
    "/oncomingAutomobile": "\u1F698",
    "/oncomingBus": "\u1F68D",
    "/oncomingFireEngine": "\u1F6F1",
    "/oncomingPoliceCar": "\u1F694",
    "/oncomingTaxi": "\u1F696",
    "/one": "\u0031",
    "/one.inferior": "\u2081",
    "/one.roman": "\u2160",
    "/one.romansmall": "\u2170",
    "/oneButtonMouse": "\u1F5AF",
    "/onearabic": "\u0661",
    "/onebengali": "\u09E7",
    "/onecircle": "\u2460",
    "/onecircledbl": "\u24F5",
    "/onecircleinversesansserif": "\u278A",
    "/onecomma": "\u1F102",
    "/onedeva": "\u0967",
    "/onedotenleader": "\u2024",
    "/onedotovertwodots": "\u2E2B",
    "/oneeighth": "\u215B",
    "/onefar": "\u06F1",
    "/onefitted": "\uF6DC",
    "/onefraction": "\u215F",
    "/onegujarati": "\u0AE7",
    "/onegurmukhi": "\u0A67",
    "/onehackarabic": "\u0661",
    "/onehalf": "\u00BD",
    "/onehangzhou": "\u3021",
    "/onehundred.roman": "\u216D",
    "/onehundred.romansmall": "\u217D",
    "/onehundredthousand.roman": "\u2188",
    "/onehundredtwentypsquare": "\u1F1A4",
    "/oneideographiccircled": "\u3280",
    "/oneideographicparen": "\u3220",
    "/oneinferior": "\u2081",
    "/onemonospace": "\uFF11",
    "/oneninth": "\u2151",
    "/onenumeratorbengali": "\u09F4",
    "/oneoldstyle": "\uF731",
    "/oneparen": "\u2474",
    "/oneparenthesized": "\u2474",
    "/oneperiod": "\u2488",
    "/onepersian": "\u06F1",
    "/onequarter": "\u00BC",
    "/oneroman": "\u2170",
    "/oneseventh": "\u2150",
    "/onesixth": "\u2159",
    "/onesuperior": "\u00B9",
    "/onethai": "\u0E51",
    "/onethird": "\u2153",
    "/onethousand.roman": "\u216F",
    "/onethousand.romansmall": "\u217F",
    "/onethousandcd.roman": "\u2180",
    "/onsusquare": "\u3309",
    "/oo": "\uA74F",
    "/oogonek": "\u01EB",
    "/oogonekmacron": "\u01ED",
    "/oogurmukhi": "\u0A13",
    "/oomatragurmukhi": "\u0A4B",
    "/oomusquare": "\u330A",
    "/oopen": "\u0254",
    "/oparen": "\u24AA",
    "/oparenthesized": "\u24AA",
    "/openBook": "\u1F4D6",
    "/openFileFolder": "\u1F4C2",
    "/openFolder": "\u1F5C1",
    "/openHandsSign": "\u1F450",
    "/openLock": "\u1F513",
    "/openMailboxLoweredFlag": "\u1F4ED",
    "/openMailboxRaisedFlag": "\u1F4EC",
    "/openbullet": "\u25E6",
    "/openheadarrowleft": "\u21FD",
    "/openheadarrowleftright": "\u21FF",
    "/openheadarrowright": "\u21FE",
    "/opensubset": "\u27C3",
    "/opensuperset": "\u27C4",
    "/ophiuchus": "\u26CE",
    "/opposition": "\u260D",
    "/opticalDisc": "\u1F4BF",
    "/opticalDiscIcon": "\u1F5B8",
    "/option": "\u2325",
    "/orangeBook": "\u1F4D9",
    "/ordfeminine": "\u00AA",
    "/ordmasculine": "\u00BA",
    "/ordotinside": "\u27C7",
    "/original": "\u22B6",
    "/ornateleftparenthesis": "\uFD3E",
    "/ornaterightparenthesis": "\uFD3F",
    "/orthodoxcross": "\u2626",
    "/orthogonal": "\u221F",
    "/orya:a": "\u0B05",
    "/orya:aa": "\u0B06",
    "/orya:aasign": "\u0B3E",
    "/orya:ai": "\u0B10",
    "/orya:ailengthmark": "\u0B56",
    "/orya:aisign": "\u0B48",
    "/orya:anusvara": "\u0B02",
    "/orya:au": "\u0B14",
    "/orya:aulengthmark": "\u0B57",
    "/orya:ausign": "\u0B4C",
    "/orya:avagraha": "\u0B3D",
    "/orya:ba": "\u0B2C",
    "/orya:bha": "\u0B2D",
    "/orya:ca": "\u0B1A",
    "/orya:candrabindu": "\u0B01",
    "/orya:cha": "\u0B1B",
    "/orya:da": "\u0B26",
    "/orya:dda": "\u0B21",
    "/orya:ddha": "\u0B22",
    "/orya:dha": "\u0B27",
    "/orya:e": "\u0B0F",
    "/orya:eight": "\u0B6E",
    "/orya:esign": "\u0B47",
    "/orya:five": "\u0B6B",
    "/orya:four": "\u0B6A",
    "/orya:fractiononeeighth": "\u0B76",
    "/orya:fractiononehalf": "\u0B73",
    "/orya:fractiononequarter": "\u0B72",
    "/orya:fractiononesixteenth": "\u0B75",
    "/orya:fractionthreequarters": "\u0B74",
    "/orya:fractionthreesixteenths": "\u0B77",
    "/orya:ga": "\u0B17",
    "/orya:gha": "\u0B18",
    "/orya:ha": "\u0B39",
    "/orya:i": "\u0B07",
    "/orya:ii": "\u0B08",
    "/orya:iisign": "\u0B40",
    "/orya:isign": "\u0B3F",
    "/orya:isshar": "\u0B70",
    "/orya:ja": "\u0B1C",
    "/orya:jha": "\u0B1D",
    "/orya:ka": "\u0B15",
    "/orya:kha": "\u0B16",
    "/orya:la": "\u0B32",
    "/orya:lla": "\u0B33",
    "/orya:llvocal": "\u0B61",
    "/orya:llvocalsign": "\u0B63",
    "/orya:lvocal": "\u0B0C",
    "/orya:lvocalsign": "\u0B62",
    "/orya:ma": "\u0B2E",
    "/orya:na": "\u0B28",
    "/orya:nga": "\u0B19",
    "/orya:nine": "\u0B6F",
    "/orya:nna": "\u0B23",
    "/orya:nukta": "\u0B3C",
    "/orya:nya": "\u0B1E",
    "/orya:o": "\u0B13",
    "/orya:one": "\u0B67",
    "/orya:osign": "\u0B4B",
    "/orya:pa": "\u0B2A",
    "/orya:pha": "\u0B2B",
    "/orya:ra": "\u0B30",
    "/orya:rha": "\u0B5D",
    "/orya:rra": "\u0B5C",
    "/orya:rrvocal": "\u0B60",
    "/orya:rrvocalsign": "\u0B44",
    "/orya:rvocal": "\u0B0B",
    "/orya:rvocalsign": "\u0B43",
    "/orya:sa": "\u0B38",
    "/orya:seven": "\u0B6D",
    "/orya:sha": "\u0B36",
    "/orya:six": "\u0B6C",
    "/orya:ssa": "\u0B37",
    "/orya:ta": "\u0B24",
    "/orya:tha": "\u0B25",
    "/orya:three": "\u0B69",
    "/orya:tta": "\u0B1F",
    "/orya:ttha": "\u0B20",
    "/orya:two": "\u0B68",
    "/orya:u": "\u0B09",
    "/orya:usign": "\u0B41",
    "/orya:uu": "\u0B0A",
    "/orya:uusign": "\u0B42",
    "/orya:va": "\u0B35",
    "/orya:virama": "\u0B4D",
    "/orya:visarga": "\u0B03",
    "/orya:wa": "\u0B71",
    "/orya:ya": "\u0B2F",
    "/orya:yya": "\u0B5F",
    "/orya:zero": "\u0B66",
    "/oscript": "\u2134",
    "/oshortdeva": "\u0912",
    "/oshortvowelsigndeva": "\u094A",
    "/oslash": "\u00F8",
    "/oslashacute": "\u01FF",
    "/osmallhiragana": "\u3049",
    "/osmallkatakana": "\u30A9",
    "/osmallkatakanahalfwidth": "\uFF6B",
    "/ostroke": "\uA74B",
    "/ostrokeacute": "\u01FF",
    "/osuperior": "\uF6F0",
    "/otcyr": "\u047F",
    "/otcyrillic": "\u047F",
    "/otilde": "\u00F5",
    "/otildeacute": "\u1E4D",
    "/otildedieresis": "\u1E4F",
    "/otildemacron": "\u022D",
    "/ou": "\u0223",
    "/oubopomofo": "\u3121",
    "/ounce": "\u2125",
    "/outboxTray": "\u1F4E4",
    "/outerjoinfull": "\u27D7",
    "/outerjoinleft": "\u27D5",
    "/outerjoinright": "\u27D6",
    "/outputpassiveup": "\u2392",
    "/overlap": "\u1F5D7",
    "/overline": "\u203E",
    "/overlinecenterline": "\uFE4A",
    "/overlinecmb": "\u0305",
    "/overlinedashed": "\uFE49",
    "/overlinedblwavy": "\uFE4C",
    "/overlinewavy": "\uFE4B",
    "/overscore": "\u00AF",
    "/ovfullwidth": "\u3375",
    "/ovowelsignbengali": "\u09CB",
    "/ovowelsigndeva": "\u094B",
    "/ovowelsigngujarati": "\u0ACB",
    "/ox": "\u1F402",
    "/p": "\u0070",
    "/p.inferior": "\u209A",
    "/paampsfullwidth": "\u3380",
    "/paampssquare": "\u3380",
    "/paasentosquare": "\u332B",
    "/paatusquare": "\u332C",
    "/pabengali": "\u09AA",
    "/pacerek": "\uA989",
    "/package": "\u1F4E6",
    "/pacute": "\u1E55",
    "/padeva": "\u092A",
    "/pafullwidth": "\u33A9",
    "/page": "\u1F5CF",
    "/pageCircledText": "\u1F5DF",
    "/pageCurl": "\u1F4C3",
    "/pageFacingUp": "\u1F4C4",
    "/pagedown": "\u21DF",
    "/pager": "\u1F4DF",
    "/pages": "\u1F5D0",
    "/pageup": "\u21DE",
    "/pagoda": "\u1F6D4",
    "/pagujarati": "\u0AAA",
    "/pagurmukhi": "\u0A2A",
    "/pahiragana": "\u3071",
    "/paiyannoithai": "\u0E2F",
    "/pakatakana": "\u30D1",
    "/palatalizationcyrilliccmb": "\u0484",
    "/palatcmbcyr": "\u0484",
    "/pallas": "\u26B4",
    "/palmTree": "\u1F334",
    "/palmbranch": "\u2E19",
    "/palochkacyr": "\u04CF",
    "/palochkacyrillic": "\u04C0",
    "/pamurda": "\uA9A6",
    "/pandaFace": "\u1F43C",
    "/pangkatpada": "\uA9C7",
    "/pangkon": "\uA9C0",
    "/pangrangkep": "\uA9CF",
    "/pansioskorean": "\u317F",
    "/panyangga": "\uA980",
    "/paperclip": "\u1F4CE",
    "/paragraph": "\u00B6",
    "/paragraphos": "\u2E0F",
    "/paragraphosforked": "\u2E10",
    "/paragraphosforkedreversed": "\u2E11",
    "/paragraphseparator": "\u2029",
    "/parallel": "\u2225",
    "/parallelogramblack": "\u25B0",
    "/parallelogramwhite": "\u25B1",
    "/parenbottom": "\u23DD",
    "/parendblleft": "\u2E28",
    "/parendblright": "\u2E29",
    "/parenextensionleft": "\u239C",
    "/parenextensionright": "\u239F",
    "/parenflatleft": "\u27EE",
    "/parenflatright": "\u27EF",
    "/parenhookupleft": "\u239B",
    "/parenhookupright": "\u239E",
    "/parenleft": "\u0028",
    "/parenleft.inferior": "\u208D",
    "/parenleft.superior": "\u207D",
    "/parenleftaltonearabic": "\uFD3E",
    "/parenleftbt": "\uF8ED",
    "/parenleftex": "\uF8EC",
    "/parenleftinferior": "\u208D",
    "/parenleftmonospace": "\uFF08",
    "/parenleftsmall": "\uFE59",
    "/parenleftsuperior": "\u207D",
    "/parenlefttp": "\uF8EB",
    "/parenleftvertical": "\uFE35",
    "/parenlowerhookleft": "\u239D",
    "/parenlowerhookright": "\u23A0",
    "/parenright": "\u0029",
    "/parenright.inferior": "\u208E",
    "/parenright.superior": "\u207E",
    "/parenrightaltonearabic": "\uFD3F",
    "/parenrightbt": "\uF8F8",
    "/parenrightex": "\uF8F7",
    "/parenrightinferior": "\u208E",
    "/parenrightmonospace": "\uFF09",
    "/parenrightsmall": "\uFE5A",
    "/parenrightsuperior": "\u207E",
    "/parenrighttp": "\uF8F6",
    "/parenrightvertical": "\uFE36",
    "/parentop": "\u23DC",
    "/partalternationmark": "\u303D",
    "/partialdiff": "\u2202",
    "/partnership": "\u3250",
    "/partyPopper": "\u1F389",
    "/paseq:hb": "\u05C0",
    "/paseqhebrew": "\u05C0",
    "/pashta:hb": "\u0599",
    "/pashtahebrew": "\u0599",
    "/pasquare": "\u33A9",
    "/passengerShip": "\u1F6F3",
    "/passivedown": "\u2391",
    "/passportControl": "\u1F6C2",
    "/patah": "\u05B7",
    "/patah11": "\u05B7",
    "/patah1d": "\u05B7",
    "/patah2a": "\u05B7",
    "/patah:hb": "\u05B7",
    "/patahhebrew": "\u05B7",
    "/patahnarrowhebrew": "\u05B7",
    "/patahquarterhebrew": "\u05B7",
    "/patahwidehebrew": "\u05B7",
    "/pawPrints": "\u1F43E",
    "/pawnblack": "\u265F",
    "/pawnwhite": "\u2659",
    "/pazer:hb": "\u05A1",
    "/pazerhebrew": "\u05A1",
    "/pbopomofo": "\u3106",
    "/pcfullwidth": "\u3376",
    "/pcircle": "\u24DF",
    "/pdot": "\u1E57",
    "/pdotaccent": "\u1E57",
    "/pe": "\u05E4",
    "/pe:hb": "\u05E4",
    "/peace": "\u262E",
    "/peach": "\u1F351",
    "/pear": "\u1F350",
    "/pecyr": "\u043F",
    "/pecyrillic": "\u043F",
    "/pedagesh": "\uFB44",
    "/pedageshhebrew": "\uFB44",
    "/pedestrian": "\u1F6B6",
    "/peezisquare": "\u333B",
    "/pefinaldageshhebrew": "\uFB43",
    "/peh.fina": "\uFB57",
    "/peh.init": "\uFB58",
    "/peh.isol": "\uFB56",
    "/peh.medi": "\uFB59",
    "/peharabic": "\u067E",
    "/peharmenian": "\u057A",
    "/pehebrew": "\u05E4",
    "/peheh": "\u06A6",
    "/peheh.fina": "\uFB6F",
    "/peheh.init": "\uFB70",
    "/peheh.isol": "\uFB6E",
    "/peheh.medi": "\uFB71",
    "/pehfinalarabic": "\uFB57",
    "/pehinitialarabic": "\uFB58",
    "/pehiragana": "\u307A",
    "/pehmedialarabic": "\uFB59",
    "/pehookcyr": "\u04A7",
    "/pekatakana": "\u30DA",
    "/pemiddlehookcyrillic": "\u04A7",
    "/penOverStampedEnvelope": "\u1F586",
    "/pengkalconsonant": "\uA9BE",
    "/penguin": "\u1F427",
    "/penihisquare": "\u3338",
    "/pensiveFace": "\u1F614",
    "/pensusquare": "\u333A",
    "/pentagram": "\u26E4",
    "/pentasememetrical": "\u23D9",
    "/pepetvowel": "\uA9BC",
    "/per": "\u214C",
    "/perafehebrew": "\uFB4E",
    "/percent": "\u0025",
    "/percentarabic": "\u066A",
    "/percentmonospace": "\uFF05",
    "/percentsmall": "\uFE6A",
    "/percussivebidental": "\u02AD",
    "/percussivebilabial": "\u02AC",
    "/performingArts": "\u1F3AD",
    "/period": "\u002E",
    "/periodarmenian": "\u0589",
    "/periodcentered": "\u00B7",
    "/periodhalfwidth": "\uFF61",
    "/periodinferior": "\uF6E7",
    "/periodmonospace": "\uFF0E",
    "/periodsmall": "\uFE52",
    "/periodsuperior": "\uF6E8",
    "/periodurdu": "\u06D4",
    "/perispomenigreekcmb": "\u0342",
    "/permanentpaper": "\u267E",
    "/permille": "\u0609",
    "/perpendicular": "\u22A5",
    "/perseveringFace": "\u1F623",
    "/personBlondHair": "\u1F471",
    "/personBowingDeeply": "\u1F647",
    "/personFrowning": "\u1F64D",
    "/personRaisingBothHandsInCelebration": "\u1F64C",
    "/personWithFoldedHands": "\u1F64F",
    "/personWithPoutingFace": "\u1F64E",
    "/personalComputer": "\u1F4BB",
    "/personball": "\u26F9",
    "/perspective": "\u2306",
    "/pertenthousandsign": "\u2031",
    "/perthousand": "\u2030",
    "/peseta": "\u20A7",
    "/peso": "\u20B1",
    "/pesosquare": "\u3337",
    "/petailcyr": "\u0525",
    "/pewithdagesh:hb": "\uFB44",
    "/pewithrafe:hb": "\uFB4E",
    "/pffullwidth": "\u338A",
    "/pflourish": "\uA753",
    "/pfsquare": "\u338A",
    "/phabengali": "\u09AB",
    "/phadeva": "\u092B",
    "/phagujarati": "\u0AAB",
    "/phagurmukhi": "\u0A2B",
    "/pharyngealvoicedfricative": "\u0295",
    "/phfullwidth": "\u33D7",
    "/phi": "\u03C6",
    "/phi.math": "\u03D5",
    "/phi1": "\u03D5",
    "/phieuphacirclekorean": "\u327A",
    "/phieuphaparenkorean": "\u321A",
    "/phieuphcirclekorean": "\u326C",
    "/phieuphkorean": "\u314D",
    "/phieuphparenkorean": "\u320C",
    "/philatin": "\u0278",
    "/phinthuthai": "\u0E3A",
    "/phisymbolgreek": "\u03D5",
    "/phitailless": "\u2C77",
    "/phon:AEsmall": "\u1D01",
    "/phon:Aemod": "\u1D2D",
    "/phon:Amod": "\u1D2C",
    "/phon:Asmall": "\u1D00",
    "/phon:Bbarmod": "\u1D2F",
    "/phon:Bbarsmall": "\u1D03",
    "/phon:Bmod": "\u1D2E",
    "/phon:Csmall": "\u1D04",
    "/phon:Dmod": "\u1D30",
    "/phon:Dsmall": "\u1D05",
    "/phon:ENcyrmod": "\u1D78",
    "/phon:Elsmallcyr": "\u1D2B",
    "/phon:Emod": "\u1D31",
    "/phon:Ereversedmod": "\u1D32",
    "/phon:Esmall": "\u1D07",
    "/phon:Ethsmall": "\u1D06",
    "/phon:Ezhsmall": "\u1D23",
    "/phon:Gmod": "\u1D33",
    "/phon:Hmod": "\u1D34",
    "/phon:Imod": "\u1D35",
    "/phon:Ismallmod": "\u1DA6",
    "/phon:Ismallstroke": "\u1D7B",
    "/phon:Istrokesmallmod": "\u1DA7",
    "/phon:Jmod": "\u1D36",
    "/phon:Jsmall": "\u1D0A",
    "/phon:Kmod": "\u1D37",
    "/phon:Ksmall": "\u1D0B",
    "/phon:Lmod": "\u1D38",
    "/phon:Lsmallmod": "\u1DAB",
    "/phon:Lsmallstroke": "\u1D0C",
    "/phon:Mmod": "\u1D39",
    "/phon:Msmall": "\u1D0D",
    "/phon:Nmod": "\u1D3A",
    "/phon:Nreversedmod": "\u1D3B",
    "/phon:Nsmallmod": "\u1DB0",
    "/phon:Nsmallreversed": "\u1D0E",
    "/phon:OUsmall": "\u1D15",
    "/phon:Omod": "\u1D3C",
    "/phon:Oopensmall": "\u1D10",
    "/phon:Osmall": "\u1D0F",
    "/phon:Oumod": "\u1D3D",
    "/phon:Pmod": "\u1D3E",
    "/phon:Psmall": "\u1D18",
    "/phon:Rmod": "\u1D3F",
    "/phon:Rsmallreversed": "\u1D19",
    "/phon:Rsmallturned": "\u1D1A",
    "/phon:Tmod": "\u1D40",
    "/phon:Tsmall": "\u1D1B",
    "/phon:Umod": "\u1D41",
    "/phon:Usmall": "\u1D1C",
    "/phon:Usmallmod": "\u1DB8",
    "/phon:Usmallstroke": "\u1D7E",
    "/phon:Vsmall": "\u1D20",
    "/phon:Wmod": "\u1D42",
    "/phon:Wsmall": "\u1D21",
    "/phon:Zsmall": "\u1D22",
    "/phon:aeturned": "\u1D02",
    "/phon:aeturnedmod": "\u1D46",
    "/phon:ain": "\u1D25",
    "/phon:ainmod": "\u1D5C",
    "/phon:alphamod": "\u1D45",
    "/phon:alpharetroflexhook": "\u1D90",
    "/phon:alphaturnedmod": "\u1D9B",
    "/phon:amod": "\u1D43",
    "/phon:aretroflexhook": "\u1D8F",
    "/phon:aturnedmod": "\u1D44",
    "/phon:betamod": "\u1D5D",
    "/phon:bmiddletilde": "\u1D6C",
    "/phon:bmod": "\u1D47",
    "/phon:bpalatalhook": "\u1D80",
    "/phon:ccurlmod": "\u1D9D",
    "/phon:chimod": "\u1D61",
    "/phon:cmod": "\u1D9C",
    "/phon:deltamod": "\u1D5F",
    "/phon:dhooktail": "\u1D91",
    "/phon:dmiddletilde": "\u1D6D",
    "/phon:dmod": "\u1D48",
    "/phon:dotlessjstrokemod": "\u1DA1",
    "/phon:dpalatalhook": "\u1D81",
    "/phon:emod": "\u1D49",
    "/phon:engmod": "\u1D51",
    "/phon:eopenmod": "\u1D4B",
    "/phon:eopenretroflexhook": "\u1D93",
    "/phon:eopenreversedmod": "\u1D9F",
    "/phon:eopenreversedretroflexhook": "\u1D94",
    "/phon:eopenturned": "\u1D08",
    "/phon:eopenturnedmod": "\u1D4C",
    "/phon:eretroflexhook": "\u1D92",
    "/phon:eshmod": "\u1DB4",
    "/phon:eshpalatalhook": "\u1D8B",
    "/phon:eshretroflexhook": "\u1D98",
    "/phon:ethmod": "\u1D9E",
    "/phon:ezhmod": "\u1DBE",
    "/phon:ezhretroflexhook": "\u1D9A",
    "/phon:fmiddletilde": "\u1D6E",
    "/phon:fmod": "\u1DA0",
    "/phon:fpalatalhook": "\u1D82",
    "/phon:ginsular": "\u1D79",
    "/phon:gmod": "\u1D4D",
    "/phon:gpalatalhook": "\u1D83",
    "/phon:gr:Gammasmall": "\u1D26",
    "/phon:gr:Lambdasmall": "\u1D27",
    "/phon:gr:Pismall": "\u1D28",
    "/phon:gr:Psismall": "\u1D2A",
    "/phon:gr:RsmallHO": "\u1D29",
    "/phon:gr:betasubscript": "\u1D66",
    "/phon:gr:chisubscript": "\u1D6A",
    "/phon:gr:gammamod": "\u1D5E",
    "/phon:gr:gammasubscript": "\u1D67",
    "/phon:gr:phimod": "\u1D60",
    "/phon:gr:phisubscript": "\u1D69",
    "/phon:gr:rhosubscript": "\u1D68",
    "/phon:gscriptmod": "\u1DA2",
    "/phon:gturned": "\u1D77",
    "/phon:hturnedmod": "\u1DA3",
    "/phon:iotamod": "\u1DA5",
    "/phon:iotastroke": "\u1D7C",
    "/phon:iretroflexhook": "\u1D96",
    "/phon:istrokemod": "\u1DA4",
    "/phon:isubscript": "\u1D62",
    "/phon:iturned": "\u1D09",
    "/phon:iturnedmod": "\u1D4E",
    "/phon:jcrossedtailmod": "\u1DA8",
    "/phon:kmod": "\u1D4F",
    "/phon:kpalatalhook": "\u1D84",
    "/phon:lpalatalhook": "\u1D85",
    "/phon:lpalatalhookmod": "\u1DAA",
    "/phon:lretroflexhookmod": "\u1DA9",
    "/phon:mhookmod": "\u1DAC",
    "/phon:mlonglegturnedmod": "\u1DAD",
    "/phon:mmiddletilde": "\u1D6F",
    "/phon:mmod": "\u1D50",
    "/phon:mpalatalhook": "\u1D86",
    "/phon:mturnedmod": "\u1D5A",
    "/phon:mturnedsideways": "\u1D1F",
    "/phon:nlefthookmod": "\u1DAE",
    "/phon:nmiddletilde": "\u1D70",
    "/phon:npalatalhook": "\u1D87",
    "/phon:nretroflexhookmod": "\u1DAF",
    "/phon:obarmod": "\u1DB1",
    "/phon:obottomhalf": "\u1D17",
    "/phon:obottomhalfmod": "\u1D55",
    "/phon:oeturned": "\u1D14",
    "/phon:omod": "\u1D52",
    "/phon:oopenmod": "\u1D53",
    "/phon:oopenretroflexhook": "\u1D97",
    "/phon:oopensideways": "\u1D12",
    "/phon:osideways": "\u1D11",
    "/phon:ostrokesideways": "\u1D13",
    "/phon:otophalf": "\u1D16",
    "/phon:otophalfmod": "\u1D54",
    "/phon:phimod": "\u1DB2",
    "/phon:pmiddletilde": "\u1D71",
    "/phon:pmod": "\u1D56",
    "/phon:ppalatalhook": "\u1D88",
    "/phon:pstroke": "\u1D7D",
    "/phon:rfishmiddletilde": "\u1D73",
    "/phon:rmiddletilde": "\u1D72",
    "/phon:rpalatalhook": "\u1D89",
    "/phon:rsubscript": "\u1D63",
    "/phon:schwamod": "\u1D4A",
    "/phon:schwaretroflexhook": "\u1D95",
    "/phon:shookmod": "\u1DB3",
    "/phon:smiddletilde": "\u1D74",
    "/phon:spalatalhook": "\u1D8A",
    "/phon:spirantvoicedlaryngeal": "\u1D24",
    "/phon:thetamod": "\u1DBF",
    "/phon:thstrike": "\u1D7A",
    "/phon:tmiddletilde": "\u1D75",
    "/phon:tmod": "\u1D57",
    "/phon:tpalatalhookmod": "\u1DB5",
    "/phon:ubarmod": "\u1DB6",
    "/phon:ue": "\u1D6B",
    "/phon:umod": "\u1D58",
    "/phon:upsilonmod": "\u1DB7",
    "/phon:upsilonstroke": "\u1D7F",
    "/phon:uretroflexhook": "\u1D99",
    "/phon:usideways": "\u1D1D",
    "/phon:usidewaysdieresised": "\u1D1E",
    "/phon:usidewaysmod": "\u1D59",
    "/phon:usubscript": "\u1D64",
    "/phon:vhookmod": "\u1DB9",
    "/phon:vmod": "\u1D5B",
    "/phon:vpalatalhook": "\u1D8C",
    "/phon:vsubscript": "\u1D65",
    "/phon:vturnedmod": "\u1DBA",
    "/phon:xpalatalhook": "\u1D8D",
    "/phon:zcurlmod": "\u1DBD",
    "/phon:zmiddletilde": "\u1D76",
    "/phon:zmod": "\u1DBB",
    "/phon:zpalatalhook": "\u1D8E",
    "/phon:zretroflexhookmod": "\u1DBC",
    "/phook": "\u01A5",
    "/phophanthai": "\u0E1E",
    "/phophungthai": "\u0E1C",
    "/phosamphaothai": "\u0E20",
    "/pi": "\u03C0",
    "/pi.math": "\u03D6",
    "/piasutorusquare": "\u332E",
    "/pick": "\u26CF",
    "/pidblstruck": "\u213C",
    "/pieupacirclekorean": "\u3273",
    "/pieupaparenkorean": "\u3213",
    "/pieupcieuckorean": "\u3176",
    "/pieupcirclekorean": "\u3265",
    "/pieupkiyeokkorean": "\u3172",
    "/pieupkorean": "\u3142",
    "/pieupparenkorean": "\u3205",
    "/pieupsioskiyeokkorean": "\u3174",
    "/pieupsioskorean": "\u3144",
    "/pieupsiostikeutkorean": "\u3175",
    "/pieupthieuthkorean": "\u3177",
    "/pieuptikeutkorean": "\u3173",
    "/pig": "\u1F416",
    "/pigFace": "\u1F437",
    "/pigNose": "\u1F43D",
    "/pihiragana": "\u3074",
    "/pikatakana": "\u30D4",
    "/pikosquare": "\u3330",
    "/pikurusquare": "\u332F",
    "/pilcrowsignreversed": "\u204B",
    "/pileOfPoo": "\u1F4A9",
    "/pill": "\u1F48A",
    "/pineDecoration": "\u1F38D",
    "/pineapple": "\u1F34D",
    "/pisces": "\u2653",
    "/piselehpada": "\uA9CC",
    "/pistol": "\u1F52B",
    "/pisymbolgreek": "\u03D6",
    "/pitchfork": "\u22D4",
    "/piwrarmenian": "\u0583",
    "/placeOfWorship": "\u1F6D0",
    "/placeofinterestsign": "\u2318",
    "/planck": "\u210E",
    "/plancktwopi": "\u210F",
    "/plus": "\u002B",
    "/plus.inferior": "\u208A",
    "/plus.superior": "\u207A",
    "/plusbelowcmb": "\u031F",
    "/pluscircle": "\u2295",
    "/plusminus": "\u00B1",
    "/plusmod": "\u02D6",
    "/plusmonospace": "\uFF0B",
    "/plussignalt:hb": "\uFB29",
    "/plussignmod": "\u02D6",
    "/plussmall": "\uFE62",
    "/plussuperior": "\u207A",
    "/pluto": "\u2647",
    "/pmfullwidth": "\u33D8",
    "/pmonospace": "\uFF50",
    "/pmsquare": "\u33D8",
    "/pocketCalculator": "\u1F5A9",
    "/poeticverse": "\u060E",
    "/pohiragana": "\u307D",
    "/pointerleftblack": "\u25C4",
    "/pointerleftwhite": "\u25C5",
    "/pointerrightblack": "\u25BA",
    "/pointerrightwhite": "\u25BB",
    "/pointingindexdownwhite": "\u261F",
    "/pointingindexleftblack": "\u261A",
    "/pointingindexleftwhite": "\u261C",
    "/pointingindexrightblack": "\u261B",
    "/pointingindexrightwhite": "\u261E",
    "/pointingindexupwhite": "\u261D",
    "/pointingtriangledownheavywhite": "\u26DB",
    "/pointosquare": "\u333D",
    "/pointring": "\u2E30",
    "/pokatakana": "\u30DD",
    "/pokrytiecmbcyr": "\u0487",
    "/policeCar": "\u1F693",
    "/policeCarsRevolvingLight": "\u1F6A8",
    "/policeOfficer": "\u1F46E",
    "/pondosquare": "\u3340",
    "/poodle": "\u1F429",
    "/popcorn": "\u1F37F",
    "/popdirectionalformatting": "\u202C",
    "/popdirectionalisolate": "\u2069",
    "/poplathai": "\u0E1B",
    "/portableStereo": "\u1F4FE",
    "/positionindicator": "\u2316",
    "/postalHorn": "\u1F4EF",
    "/postalmark": "\u3012",
    "/postalmarkface": "\u3020",
    "/postbox": "\u1F4EE",
    "/potOfFood": "\u1F372",
    "/potableWater": "\u1F6B0",
    "/pouch": "\u1F45D",
    "/poultryLeg": "\u1F357",
    "/poutingCatFace": "\u1F63E",
    "/poutingFace": "\u1F621",
    "/power": "\u23FB",
    "/poweron": "\u23FD",
    "/poweronoff": "\u23FC",
    "/powersleep": "\u23FE",
    "/pparen": "\u24AB",
    "/pparenthesized": "\u24AB",
    "/ppmfullwidth": "\u33D9",
    "/prayerBeads": "\u1F4FF",
    "/precedes": "\u227A",
    "/precedesbutnotequivalent": "\u22E8",
    "/precedesorequal": "\u227C",
    "/precedesorequivalent": "\u227E",
    "/precedesunderrelation": "\u22B0",
    "/prescription": "\u211E",
    "/preversedepigraphic": "\uA7FC",
    "/previouspage": "\u2397",
    "/prfullwidth": "\u33DA",
    "/primedblmod": "\u02BA",
    "/primemod": "\u02B9",
    "/primereversed": "\u2035",
    "/princess": "\u1F478",
    "/printer": "\u1F5A8",
    "/printerIcon": "\u1F5B6",
    "/printideographiccircled": "\u329E",
    "/printscreen": "\u2399",
    "/product": "\u220F",
    "/prohibitedSign": "\u1F6C7",
    "/projective": "\u2305",
    "/prolongedkana": "\u30FC",
    "/propellor": "\u2318",
    "/propersubset": "\u2282",
    "/propersuperset": "\u2283",
    "/propertyline": "\u214A",
    "/proportion": "\u2237",
    "/proportional": "\u221D",
    "/psfullwidth": "\u33B0",
    "/psi": "\u03C8",
    "/psicyr": "\u0471",
    "/psicyrillic": "\u0471",
    "/psilicmbcyr": "\u0486",
    "/psilipneumatacyrilliccmb": "\u0486",
    "/pssquare": "\u33B0",
    "/pstrokedescender": "\uA751",
    "/ptail": "\uA755",
    "/publicAddressLoudspeaker": "\u1F4E2",
    "/puhiragana": "\u3077",
    "/pukatakana": "\u30D7",
    "/punctuationspace": "\u2008",
    "/purpleHeart": "\u1F49C",
    "/purse": "\u1F45B",
    "/pushpin": "\u1F4CC",
    "/putLitterInItsPlace": "\u1F6AE",
    "/pvfullwidth": "\u33B4",
    "/pvsquare": "\u33B4",
    "/pwfullwidth": "\u33BA",
    "/pwsquare": "\u33BA",
    "/q": "\u0071",
    "/qacyr": "\u051B",
    "/qadeva": "\u0958",
    "/qadma:hb": "\u05A8",
    "/qadmahebrew": "\u05A8",
    "/qaf": "\u0642",
    "/qaf.fina": "\uFED6",
    "/qaf.init": "\uFED7",
    "/qaf.init_alefmaksura.fina": "\uFC35",
    "/qaf.init_hah.fina": "\uFC33",
    "/qaf.init_hah.medi": "\uFCC2",
    "/qaf.init_meem.fina": "\uFC34",
    "/qaf.init_meem.medi": "\uFCC3",
    "/qaf.init_meem.medi_hah.medi": "\uFDB4",
    "/qaf.init_yeh.fina": "\uFC36",
    "/qaf.isol": "\uFED5",
    "/qaf.medi": "\uFED8",
    "/qaf.medi_alefmaksura.fina": "\uFC7E",
    "/qaf.medi_meem.medi_hah.fina": "\uFD7E",
    "/qaf.medi_meem.medi_meem.fina": "\uFD7F",
    "/qaf.medi_meem.medi_yeh.fina": "\uFDB2",
    "/qaf.medi_yeh.fina": "\uFC7F",
    "/qaf_lam_alefmaksuraabove": "\u06D7",
    "/qafarabic": "\u0642",
    "/qafdotabove": "\u06A7",
    "/qaffinalarabic": "\uFED6",
    "/qafinitialarabic": "\uFED7",
    "/qafmedialarabic": "\uFED8",
    "/qafthreedotsabove": "\u06A8",
    "/qamats": "\u05B8",
    "/qamats10": "\u05B8",
    "/qamats1a": "\u05B8",
    "/qamats1c": "\u05B8",
    "/qamats27": "\u05B8",
    "/qamats29": "\u05B8",
    "/qamats33": "\u05B8",
    "/qamats:hb": "\u05B8",
    "/qamatsQatan:hb": "\u05C7",
    "/qamatsde": "\u05B8",
    "/qamatshebrew": "\u05B8",
    "/qamatsnarrowhebrew": "\u05B8",
    "/qamatsqatanhebrew": "\u05B8",
    "/qamatsqatannarrowhebrew": "\u05B8",
    "/qamatsqatanquarterhebrew": "\u05B8",
    "/qamatsqatanwidehebrew": "\u05B8",
    "/qamatsquarterhebrew": "\u05B8",
    "/qamatswidehebrew": "\u05B8",
    "/qarneFarah:hb": "\u059F",
    "/qarneyparahebrew": "\u059F",
    "/qbopomofo": "\u3111",
    "/qcircle": "\u24E0",
    "/qdiagonalstroke": "\uA759",
    "/qhook": "\u02A0",
    "/qhooktail": "\u024B",
    "/qmonospace": "\uFF51",
    "/qof": "\u05E7",
    "/qof:hb": "\u05E7",
    "/qofdagesh": "\uFB47",
    "/qofdageshhebrew": "\uFB47",
    "/qofhatafpatah": "\u05E7",
    "/qofhatafpatahhebrew": "\u05E7",
    "/qofhatafsegol": "\u05E7",
    "/qofhatafsegolhebrew": "\u05E7",
    "/qofhebrew": "\u05E7",
    "/qofhiriq": "\u05E7",
    "/qofhiriqhebrew": "\u05E7",
    "/qofholam": "\u05E7",
    "/qofholamhebrew": "\u05E7",
    "/qofpatah": "\u05E7",
    "/qofpatahhebrew": "\u05E7",
    "/qofqamats": "\u05E7",
    "/qofqamatshebrew": "\u05E7",
    "/qofqubuts": "\u05E7",
    "/qofqubutshebrew": "\u05E7",
    "/qofsegol": "\u05E7",
    "/qofsegolhebrew": "\u05E7",
    "/qofsheva": "\u05E7",
    "/qofshevahebrew": "\u05E7",
    "/qoftsere": "\u05E7",
    "/qoftserehebrew": "\u05E7",
    "/qofwithdagesh:hb": "\uFB47",
    "/qparen": "\u24AC",
    "/qparenthesized": "\u24AC",
    "/qpdigraph": "\u0239",
    "/qstrokedescender": "\uA757",
    "/quadarrowdownfunc": "\u2357",
    "/quadarrowleftfunc": "\u2347",
    "/quadarrowrightfunc": "\u2348",
    "/quadarrowupfunc": "\u2350",
    "/quadbackslashfunc": "\u2342",
    "/quadcaretdownfunc": "\u234C",
    "/quadcaretupfunc": "\u2353",
    "/quadcirclefunc": "\u233C",
    "/quadcolonfunc": "\u2360",
    "/quaddelfunc": "\u2354",
    "/quaddeltafunc": "\u234D",
    "/quaddiamondfunc": "\u233A",
    "/quaddividefunc": "\u2339",
    "/quadequalfunc": "\u2338",
    "/quadfunc": "\u2395",
    "/quadgreaterfunc": "\u2344",
    "/quadjotfunc": "\u233B",
    "/quadlessfunc": "\u2343",
    "/quadnotequalfunc": "\u236F",
    "/quadquestionfunc": "\u2370",
    "/quadrantLowerLeft": "\u2596",
    "/quadrantLowerRight": "\u2597",
    "/quadrantUpperLeft": "\u2598",
    "/quadrantUpperLeftAndLowerLeftAndLowerRight": "\u2599",
    "/quadrantUpperLeftAndLowerRight": "\u259A",
    "/quadrantUpperLeftAndUpperRightAndLowerLeft": "\u259B",
    "/quadrantUpperLeftAndUpperRightAndLowerRight": "\u259C",
    "/quadrantUpperRight": "\u259D",
    "/quadrantUpperRightAndLowerLeft": "\u259E",
    "/quadrantUpperRightAndLowerLeftAndLowerRight": "\u259F",
    "/quadrupleminute": "\u2057",
    "/quadslashfunc": "\u2341",
    "/quarternote": "\u2669",
    "/qubuts": "\u05BB",
    "/qubuts18": "\u05BB",
    "/qubuts25": "\u05BB",
    "/qubuts31": "\u05BB",
    "/qubuts:hb": "\u05BB",
    "/qubutshebrew": "\u05BB",
    "/qubutsnarrowhebrew": "\u05BB",
    "/qubutsquarterhebrew": "\u05BB",
    "/qubutswidehebrew": "\u05BB",
    "/queenblack": "\u265B",
    "/queenwhite": "\u2655",
    "/question": "\u003F",
    "/questionarabic": "\u061F",
    "/questionarmenian": "\u055E",
    "/questiondbl": "\u2047",
    "/questiondown": "\u00BF",
    "/questiondownsmall": "\uF7BF",
    "/questionedequal": "\u225F",
    "/questionexclamationmark": "\u2048",
    "/questiongreek": "\u037E",
    "/questionideographiccircled": "\u3244",
    "/questionmonospace": "\uFF1F",
    "/questionreversed": "\u2E2E",
    "/questionsmall": "\uF73F",
    "/quincunx": "\u26BB",
    "/quotedbl": "\u0022",
    "/quotedblbase": "\u201E",
    "/quotedblleft": "\u201C",
    "/quotedbllowreversed": "\u2E42",
    "/quotedblmonospace": "\uFF02",
    "/quotedblprime": "\u301E",
    "/quotedblprimereversed": "\u301D",
    "/quotedblreversed": "\u201F",
    "/quotedblright": "\u201D",
    "/quoteleft": "\u2018",
    "/quoteleftreversed": "\u201B",
    "/quotequadfunc": "\u235E",
    "/quotereversed": "\u201B",
    "/quoteright": "\u2019",
    "/quoterightn": "\u0149",
    "/quotesinglbase": "\u201A",
    "/quotesingle": "\u0027",
    "/quotesinglemonospace": "\uFF07",
    "/quoteunderlinefunc": "\u2358",
    "/r": "\u0072",
    "/raagung": "\uA9AC",
    "/raarmenian": "\u057C",
    "/rabbit": "\u1F407",
    "/rabbitFace": "\u1F430",
    "/rabengali": "\u09B0",
    "/racingCar": "\u1F3CE",
    "/racingMotorcycle": "\u1F3CD",
    "/racirclekatakana": "\u32F6",
    "/racute": "\u0155",
    "/radeva": "\u0930",
    "/radfullwidth": "\u33AD",
    "/radical": "\u221A",
    "/radicalbottom": "\u23B7",
    "/radicalex": "\uF8E5",
    "/radio": "\u1F4FB",
    "/radioButton": "\u1F518",
    "/radioactive": "\u2622",
    "/radovers2fullwidth": "\u33AF",
    "/radoversfullwidth": "\u33AE",
    "/radoverssquare": "\u33AE",
    "/radoverssquaredsquare": "\u33AF",
    "/radsquare": "\u33AD",
    "/rafe": "\u05BF",
    "/rafe:hb": "\u05BF",
    "/rafehebrew": "\u05BF",
    "/ragujarati": "\u0AB0",
    "/ragurmukhi": "\u0A30",
    "/rahiragana": "\u3089",
    "/railwayCar": "\u1F683",
    "/railwayTrack": "\u1F6E4",
    "/rain": "\u26C6",
    "/rainbow": "\u1F308",
    "/raisedHandFingersSplayed": "\u1F590",
    "/raisedHandPartBetweenMiddleAndRingFingers": "\u1F596",
    "/raisedmcsign": "\u1F16A",
    "/raisedmdsign": "\u1F16B",
    "/rakatakana": "\u30E9",
    "/rakatakanahalfwidth": "\uFF97",
    "/ralowerdiagonalbengali": "\u09F1",
    "/ram": "\u1F40F",
    "/ramiddlediagonalbengali": "\u09F0",
    "/ramshorn": "\u0264",
    "/rat": "\u1F400",
    "/ratio": "\u2236",
    "/ray": "\u0608",
    "/rbopomofo": "\u3116",
    "/rcaron": "\u0159",
    "/rcedilla": "\u0157",
    "/rcircle": "\u24E1",
    "/rcommaaccent": "\u0157",
    "/rdblgrave": "\u0211",
    "/rdot": "\u1E59",
    "/rdotaccent": "\u1E59",
    "/rdotbelow": "\u1E5B",
    "/rdotbelowmacron": "\u1E5D",
    "/reachideographicparen": "\u3243",
    "/recirclekatakana": "\u32F9",
    "/recreationalVehicle": "\u1F699",
    "/rectangleblack": "\u25AC",
    "/rectangleverticalblack": "\u25AE",
    "/rectangleverticalwhite": "\u25AF",
    "/rectanglewhite": "\u25AD",
    "/recycledpaper": "\u267C",
    "/recyclefiveplastics": "\u2677",
    "/recyclefourplastics": "\u2676",
    "/recyclegeneric": "\u267A",
    "/recycleoneplastics": "\u2673",
    "/recyclepartiallypaper": "\u267D",
    "/recyclesevenplastics": "\u2679",
    "/recyclesixplastics": "\u2678",
    "/recyclethreeplastics": "\u2675",
    "/recycletwoplastics": "\u2674",
    "/recycleuniversal": "\u2672",
    "/recycleuniversalblack": "\u267B",
    "/redApple": "\u1F34E",
    "/redTriangleDOwn": "\u1F53B",
    "/redTriangleUp": "\u1F53A",
    "/referencemark": "\u203B",
    "/reflexsubset": "\u2286",
    "/reflexsuperset": "\u2287",
    "/regionalindicatorsymbollettera": "\u1F1E6",
    "/regionalindicatorsymbolletterb": "\u1F1E7",
    "/regionalindicatorsymbolletterc": "\u1F1E8",
    "/regionalindicatorsymbolletterd": "\u1F1E9",
    "/regionalindicatorsymbollettere": "\u1F1EA",
    "/regionalindicatorsymbolletterf": "\u1F1EB",
    "/regionalindicatorsymbolletterg": "\u1F1EC",
    "/regionalindicatorsymbolletterh": "\u1F1ED",
    "/regionalindicatorsymbolletteri": "\u1F1EE",
    "/regionalindicatorsymbolletterj": "\u1F1EF",
    "/regionalindicatorsymbolletterk": "\u1F1F0",
    "/regionalindicatorsymbolletterl": "\u1F1F1",
    "/regionalindicatorsymbolletterm": "\u1F1F2",
    "/regionalindicatorsymbollettern": "\u1F1F3",
    "/regionalindicatorsymbollettero": "\u1F1F4",
    "/regionalindicatorsymbolletterp": "\u1F1F5",
    "/regionalindicatorsymbolletterq": "\u1F1F6",
    "/regionalindicatorsymbolletterr": "\u1F1F7",
    "/regionalindicatorsymbolletters": "\u1F1F8",
    "/regionalindicatorsymbollettert": "\u1F1F9",
    "/regionalindicatorsymbolletteru": "\u1F1FA",
    "/regionalindicatorsymbolletterv": "\u1F1FB",
    "/regionalindicatorsymbolletterw": "\u1F1FC",
    "/regionalindicatorsymbolletterx": "\u1F1FD",
    "/regionalindicatorsymbollettery": "\u1F1FE",
    "/regionalindicatorsymbolletterz": "\u1F1FF",
    "/registered": "\u00AE",
    "/registersans": "\uF8E8",
    "/registerserif": "\uF6DA",
    "/reh.fina": "\uFEAE",
    "/reh.init_superscriptalef.fina": "\uFC5C",
    "/reh.isol": "\uFEAD",
    "/rehHamzaAbove": "\u076C",
    "/rehSmallTahTwoDots": "\u0771",
    "/rehStroke": "\u075B",
    "/rehTwoDotsVerticallyAbove": "\u076B",
    "/rehVabove": "\u0692",
    "/rehVbelow": "\u0695",
    "/reharabic": "\u0631",
    "/reharmenian": "\u0580",
    "/rehdotbelow": "\u0694",
    "/rehdotbelowdotabove": "\u0696",
    "/rehfinalarabic": "\uFEAE",
    "/rehfourdotsabove": "\u0699",
    "/rehinvertedV": "\u06EF",
    "/rehiragana": "\u308C",
    "/rehring": "\u0693",
    "/rehtwodotsabove": "\u0697",
    "/rehyehaleflamarabic": "\u0631",
    "/rekatakana": "\u30EC",
    "/rekatakanahalfwidth": "\uFF9A",
    "/relievedFace": "\u1F60C",
    "/religionideographiccircled": "\u32AA",
    "/reminderRibbon": "\u1F397",
    "/remusquare": "\u3355",
    "/rentogensquare": "\u3356",
    "/replacementchar": "\uFFFD",
    "/replacementcharobj": "\uFFFC",
    "/representideographicparen": "\u3239",
    "/rerengganleft": "\uA9C1",
    "/rerengganright": "\uA9C2",
    "/resh": "\u05E8",
    "/resh:hb": "\u05E8",
    "/reshdageshhebrew": "\uFB48",
    "/reshhatafpatah": "\u05E8",
    "/reshhatafpatahhebrew": "\u05E8",
    "/reshhatafsegol": "\u05E8",
    "/reshhatafsegolhebrew": "\u05E8",
    "/reshhebrew": "\u05E8",
    "/reshhiriq": "\u05E8",
    "/reshhiriqhebrew": "\u05E8",
    "/reshholam": "\u05E8",
    "/reshholamhebrew": "\u05E8",
    "/reshpatah": "\u05E8",
    "/reshpatahhebrew": "\u05E8",
    "/reshqamats": "\u05E8",
    "/reshqamatshebrew": "\u05E8",
    "/reshqubuts": "\u05E8",
    "/reshqubutshebrew": "\u05E8",
    "/reshsegol": "\u05E8",
    "/reshsegolhebrew": "\u05E8",
    "/reshsheva": "\u05E8",
    "/reshshevahebrew": "\u05E8",
    "/reshtsere": "\u05E8",
    "/reshtserehebrew": "\u05E8",
    "/reshwide:hb": "\uFB27",
    "/reshwithdagesh:hb": "\uFB48",
    "/resourceideographiccircled": "\u32AE",
    "/resourceideographicparen": "\u323E",
    "/response": "\u211F",
    "/restideographiccircled": "\u32A1",
    "/restideographicparen": "\u3241",
    "/restrictedentryoneleft": "\u26E0",
    "/restrictedentrytwoleft": "\u26E1",
    "/restroom": "\u1F6BB",
    "/return": "\u23CE",
    "/reversedHandMiddleFingerExtended": "\u1F595",
    "/reversedRaisedHandFingersSplayed": "\u1F591",
    "/reversedThumbsDownSign": "\u1F593",
    "/reversedThumbsUpSign": "\u1F592",
    "/reversedVictoryHand": "\u1F594",
    "/reversedonehundred.roman": "\u2183",
    "/reversedtilde": "\u223D",
    "/reversedzecyr": "\u0511",
    "/revia:hb": "\u0597",
    "/reviahebrew": "\u0597",
    "/reviamugrashhebrew": "\u0597",
    "/revlogicalnot": "\u2310",
    "/revolvingHearts": "\u1F49E",
    "/rfishhook": "\u027E",
    "/rfishhookreversed": "\u027F",
    "/rgravedbl": "\u0211",
    "/rhabengali": "\u09DD",
    "/rhacyr": "\u0517",
    "/rhadeva": "\u095D",
    "/rho": "\u03C1",
    "/rhoasper": "\u1FE5",
    "/rhofunc": "\u2374",
    "/rholenis": "\u1FE4",
    "/rhook": "\u027D",
    "/rhookturned": "\u027B",
    "/rhookturnedsuperior": "\u02B5",
    "/rhookturnedsupmod": "\u02B5",
    "/rhostrokesymbol": "\u03FC",
    "/rhosymbol": "\u03F1",
    "/rhosymbolgreek": "\u03F1",
    "/rhotichookmod": "\u02DE",
    "/rial": "\uFDFC",
    "/ribbon": "\u1F380",
    "/riceBall": "\u1F359",
    "/riceCracker": "\u1F358",
    "/ricirclekatakana": "\u32F7",
    "/rieulacirclekorean": "\u3271",
    "/rieulaparenkorean": "\u3211",
    "/rieulcirclekorean": "\u3263",
    "/rieulhieuhkorean": "\u3140",
    "/rieulkiyeokkorean": "\u313A",
    "/rieulkiyeoksioskorean": "\u3169",
    "/rieulkorean": "\u3139",
    "/rieulmieumkorean": "\u313B",
    "/rieulpansioskorean": "\u316C",
    "/rieulparenkorean": "\u3203",
    "/rieulphieuphkorean": "\u313F",
    "/rieulpieupkorean": "\u313C",
    "/rieulpieupsioskorean": "\u316B",
    "/rieulsioskorean": "\u313D",
    "/rieulthieuthkorean": "\u313E",
    "/rieultikeutkorean": "\u316A",
    "/rieulyeorinhieuhkorean": "\u316D",
    "/right-pointingMagnifyingGlass": "\u1F50E",
    "/rightAngerBubble": "\u1F5EF",
    "/rightHalfBlock": "\u2590",
    "/rightHandTelephoneReceiver": "\u1F57D",
    "/rightOneEighthBlock": "\u2595",
    "/rightSpeaker": "\u1F568",
    "/rightSpeakerOneSoundWave": "\u1F569",
    "/rightSpeakerThreeSoundWaves": "\u1F56A",
    "/rightSpeechBubble": "\u1F5E9",
    "/rightThoughtBubble": "\u1F5ED",
    "/rightangle": "\u221F",
    "/rightarrowoverleftarrow": "\u21C4",
    "/rightdnheavyleftuplight": "\u2546",
    "/rightharpoonoverleftharpoon": "\u21CC",
    "/rightheavyleftdnlight": "\u252E",
    "/rightheavyleftuplight": "\u2536",
    "/rightheavyleftvertlight": "\u253E",
    "/rightideographiccircled": "\u32A8",
    "/rightlightleftdnheavy": "\u2531",
    "/rightlightleftupheavy": "\u2539",
    "/rightlightleftvertheavy": "\u2549",
    "/righttackbelowcmb": "\u0319",
    "/righttoleftembed": "\u202B",
    "/righttoleftisolate": "\u2067",
    "/righttoleftmark": "\u200F",
    "/righttoleftoverride": "\u202E",
    "/righttriangle": "\u22BF",
    "/rightupheavyleftdnlight": "\u2544",
    "/rihiragana": "\u308A",
    "/rikatakana": "\u30EA",
    "/rikatakanahalfwidth": "\uFF98",
    "/ring": "\u02DA",
    "/ringbelowcmb": "\u0325",
    "/ringcmb": "\u030A",
    "/ringequal": "\u2257",
    "/ringhalfleft": "\u02BF",
    "/ringhalfleftarmenian": "\u0559",
    "/ringhalfleftbelowcmb": "\u031C",
    "/ringhalfleftcentered": "\u02D3",
    "/ringhalfleftcentredmod": "\u02D3",
    "/ringhalfleftmod": "\u02BF",
    "/ringhalfright": "\u02BE",
    "/ringhalfrightbelowcmb": "\u0339",
    "/ringhalfrightcentered": "\u02D2",
    "/ringhalfrightcentredmod": "\u02D2",
    "/ringhalfrightmod": "\u02BE",
    "/ringinequal": "\u2256",
    "/ringingBell": "\u1F56D",
    "/ringlowmod": "\u02F3",
    "/ringoperator": "\u2218",
    "/rinsular": "\uA783",
    "/rinvertedbreve": "\u0213",
    "/rirasquare": "\u3352",
    "/risingdiagonal": "\u27CB",
    "/rittorusquare": "\u3351",
    "/rlinebelow": "\u1E5F",
    "/rlongleg": "\u027C",
    "/rlonglegturned": "\u027A",
    "/rmacrondot": "\u1E5D",
    "/rmonospace": "\uFF52",
    "/rnoon": "\u06BB",
    "/rnoon.fina": "\uFBA1",
    "/rnoon.init": "\uFBA2",
    "/rnoon.isol": "\uFBA0",
    "/rnoon.medi": "\uFBA3",
    "/roastedSweetPotato": "\u1F360",
    "/robliquestroke": "\uA7A7",
    "/rocirclekatakana": "\u32FA",
    "/rocket": "\u1F680",
    "/rohiragana": "\u308D",
    "/rokatakana": "\u30ED",
    "/rokatakanahalfwidth": "\uFF9B",
    "/rolled-upNewspaper": "\u1F5DE",
    "/rollerCoaster": "\u1F3A2",
    "/rookblack": "\u265C",
    "/rookwhite": "\u2656",
    "/rooster": "\u1F413",
    "/roruathai": "\u0E23",
    "/rose": "\u1F339",
    "/rosette": "\u1F3F5",
    "/roundPushpin": "\u1F4CD",
    "/roundedzeroabove": "\u06DF",
    "/rowboat": "\u1F6A3",
    "/rparen": "\u24AD",
    "/rparenthesized": "\u24AD",
    "/rrabengali": "\u09DC",
    "/rradeva": "\u0931",
    "/rragurmukhi": "\u0A5C",
    "/rreh": "\u0691",
    "/rreh.fina": "\uFB8D",
    "/rreh.isol": "\uFB8C",
    "/rreharabic": "\u0691",
    "/rrehfinalarabic": "\uFB8D",
    "/rrotunda": "\uA75B",
    "/rrvocalicbengali": "\u09E0",
    "/rrvocalicdeva": "\u0960",
    "/rrvocalicgujarati": "\u0AE0",
    "/rrvocalicvowelsignbengali": "\u09C4",
    "/rrvocalicvowelsigndeva": "\u0944",
    "/rrvocalicvowelsigngujarati": "\u0AC4",
    "/rstroke": "\u024D",
    "/rsuperior": "\uF6F1",
    "/rsupmod": "\u02B3",
    "/rtailturned": "\u2C79",
    "/rtblock": "\u2590",
    "/rturned": "\u0279",
    "/rturnedsuperior": "\u02B4",
    "/rturnedsupmod": "\u02B4",
    "/ruble": "\u20BD",
    "/rucirclekatakana": "\u32F8",
    "/rugbyFootball": "\u1F3C9",
    "/ruhiragana": "\u308B",
    "/rukatakana": "\u30EB",
    "/rukatakanahalfwidth": "\uFF99",
    "/rum": "\uA775",
    "/rumrotunda": "\uA75D",
    "/runner": "\u1F3C3",
    "/runningShirtSash": "\u1F3BD",
    "/rupeemarkbengali": "\u09F2",
    "/rupeesignbengali": "\u09F3",
    "/rupiah": "\uF6DD",
    "/rupiisquare": "\u3353",
    "/ruthai": "\u0E24",
    "/ruuburusquare": "\u3354",
    "/rvocalicbengali": "\u098B",
    "/rvocalicdeva": "\u090B",
    "/rvocalicgujarati": "\u0A8B",
    "/rvocalicvowelsignbengali": "\u09C3",
    "/rvocalicvowelsigndeva": "\u0943",
    "/rvocalicvowelsigngujarati": "\u0AC3",
    "/s": "\u0073",
    "/s.inferior": "\u209B",
    "/s_t": "\uFB06",
    "/sabengali": "\u09B8",
    "/sacirclekatakana": "\u32DA",
    "/sacute": "\u015B",
    "/sacutedotaccent": "\u1E65",
    "/sad": "\u0635",
    "/sad.fina": "\uFEBA",
    "/sad.init": "\uFEBB",
    "/sad.init_alefmaksura.fina": "\uFD05",
    "/sad.init_hah.fina": "\uFC20",
    "/sad.init_hah.medi": "\uFCB1",
    "/sad.init_hah.medi_hah.medi": "\uFD65",
    "/sad.init_khah.medi": "\uFCB2",
    "/sad.init_meem.fina": "\uFC21",
    "/sad.init_meem.medi": "\uFCB3",
    "/sad.init_meem.medi_meem.medi": "\uFDC5",
    "/sad.init_reh.fina": "\uFD0F",
    "/sad.init_yeh.fina": "\uFD06",
    "/sad.isol": "\uFEB9",
    "/sad.medi": "\uFEBC",
    "/sad.medi_alefmaksura.fina": "\uFD21",
    "/sad.medi_hah.medi_hah.fina": "\uFD64",
    "/sad.medi_hah.medi_yeh.fina": "\uFDA9",
    "/sad.medi_meem.medi_meem.fina": "\uFD66",
    "/sad.medi_reh.fina": "\uFD2B",
    "/sad.medi_yeh.fina": "\uFD22",
    "/sad_lam_alefmaksuraabove": "\u06D6",
    "/sadarabic": "\u0635",
    "/sadeva": "\u0938",
    "/sadfinalarabic": "\uFEBA",
    "/sadinitialarabic": "\uFEBB",
    "/sadmedialarabic": "\uFEBC",
    "/sadthreedotsabove": "\u069E",
    "/sadtwodotsbelow": "\u069D",
    "/sagittarius": "\u2650",
    "/sagujarati": "\u0AB8",
    "/sagurmukhi": "\u0A38",
    "/sahiragana": "\u3055",
    "/saikurusquare": "\u331F",
    "/sailboat": "\u26F5",
    "/sakatakana": "\u30B5",
    "/sakatakanahalfwidth": "\uFF7B",
    "/sakeBottleAndCup": "\u1F376",
    "/sallallahoualayhewasallamarabic": "\uFDFA",
    "/saltillo": "\uA78C",
    "/saltire": "\u2613",
    "/samahaprana": "\uA9B0",
    "/samekh": "\u05E1",
    "/samekh:hb": "\u05E1",
    "/samekhdagesh": "\uFB41",
    "/samekhdageshhebrew": "\uFB41",
    "/samekhhebrew": "\u05E1",
    "/samekhwithdagesh:hb": "\uFB41",
    "/sampi": "\u03E1",
    "/sampiarchaic": "\u0373",
    "/samurda": "\uA9AF",
    "/samvat": "\u0604",
    "/san": "\u03FB",
    "/santiimusquare": "\u3320",
    "/saraaathai": "\u0E32",
    "/saraaethai": "\u0E41",
    "/saraaimaimalaithai": "\u0E44",
    "/saraaimaimuanthai": "\u0E43",
    "/saraamthai": "\u0E33",
    "/saraathai": "\u0E30",
    "/saraethai": "\u0E40",
    "/saraiileftthai": "\uF886",
    "/saraiithai": "\u0E35",
    "/saraileftthai": "\uF885",
    "/saraithai": "\u0E34",
    "/saraothai": "\u0E42",
    "/saraueeleftthai": "\uF888",
    "/saraueethai": "\u0E37",
    "/saraueleftthai": "\uF887",
    "/sarauethai": "\u0E36",
    "/sarauthai": "\u0E38",
    "/sarauuthai": "\u0E39",
    "/satellite": "\u1F6F0",
    "/satelliteAntenna": "\u1F4E1",
    "/saturn": "\u2644",
    "/saxophone": "\u1F3B7",
    "/sbopomofo": "\u3119",
    "/scales": "\u2696",
    "/scanninehorizontal": "\u23BD",
    "/scanonehorizontal": "\u23BA",
    "/scansevenhorizontal": "\u23BC",
    "/scanthreehorizontal": "\u23BB",
    "/scaron": "\u0161",
    "/scarondot": "\u1E67",
    "/scarondotaccent": "\u1E67",
    "/scedilla": "\u015F",
    "/school": "\u1F3EB",
    "/schoolSatchel": "\u1F392",
    "/schoolideographiccircled": "\u3246",
    "/schwa": "\u0259",
    "/schwa.inferior": "\u2094",
    "/schwacyr": "\u04D9",
    "/schwacyrillic": "\u04D9",
    "/schwadieresiscyr": "\u04DB",
    "/schwadieresiscyrillic": "\u04DB",
    "/schwahook": "\u025A",
    "/scircle": "\u24E2",
    "/scircumflex": "\u015D",
    "/scommaaccent": "\u0219",
    "/scooter": "\u1F6F4",
    "/scorpius": "\u264F",
    "/screen": "\u1F5B5",
    "/scroll": "\u1F4DC",
    "/scruple": "\u2108",
    "/sdot": "\u1E61",
    "/sdotaccent": "\u1E61",
    "/sdotbelow": "\u1E63",
    "/sdotbelowdotabove": "\u1E69",
    "/sdotbelowdotaccent": "\u1E69",
    "/seagullbelowcmb": "\u033C",
    "/seat": "\u1F4BA",
    "/secirclekatakana": "\u32DD",
    "/second": "\u2033",
    "/secondreversed": "\u2036",
    "/secondscreensquare": "\u1F19C",
    "/secondtonechinese": "\u02CA",
    "/secretideographiccircled": "\u3299",
    "/section": "\u00A7",
    "/sectionsignhalftop": "\u2E39",
    "/sector": "\u2314",
    "/seeNoEvilMonkey": "\u1F648",
    "/seedling": "\u1F331",
    "/seen": "\u0633",
    "/seen.fina": "\uFEB2",
    "/seen.init": "\uFEB3",
    "/seen.init_alefmaksura.fina": "\uFCFB",
    "/seen.init_hah.fina": "\uFC1D",
    "/seen.init_hah.medi": "\uFCAE",
    "/seen.init_hah.medi_jeem.medi": "\uFD5C",
    "/seen.init_heh.medi": "\uFD31",
    "/seen.init_jeem.fina": "\uFC1C",
    "/seen.init_jeem.medi": "\uFCAD",
    "/seen.init_jeem.medi_hah.medi": "\uFD5D",
    "/seen.init_khah.fina": "\uFC1E",
    "/seen.init_khah.medi": "\uFCAF",
    "/seen.init_meem.fina": "\uFC1F",
    "/seen.init_meem.medi": "\uFCB0",
    "/seen.init_meem.medi_hah.medi": "\uFD60",
    "/seen.init_meem.medi_jeem.medi": "\uFD61",
    "/seen.init_meem.medi_meem.medi": "\uFD63",
    "/seen.init_reh.fina": "\uFD0E",
    "/seen.init_yeh.fina": "\uFCFC",
    "/seen.isol": "\uFEB1",
    "/seen.medi": "\uFEB4",
    "/seen.medi_alefmaksura.fina": "\uFD17",
    "/seen.medi_hah.medi": "\uFD35",
    "/seen.medi_heh.medi": "\uFCE8",
    "/seen.medi_jeem.medi": "\uFD34",
    "/seen.medi_jeem.medi_alefmaksura.fina": "\uFD5E",
    "/seen.medi_khah.medi": "\uFD36",
    "/seen.medi_khah.medi_alefmaksura.fina": "\uFDA8",
    "/seen.medi_khah.medi_yeh.fina": "\uFDC6",
    "/seen.medi_meem.medi": "\uFCE7",
    "/seen.medi_meem.medi_hah.fina": "\uFD5F",
    "/seen.medi_meem.medi_meem.fina": "\uFD62",
    "/seen.medi_reh.fina": "\uFD2A",
    "/seen.medi_yeh.fina": "\uFD18",
    "/seenDigitFourAbove": "\u077D",
    "/seenFourDotsAbove": "\u075C",
    "/seenInvertedV": "\u077E",
    "/seenSmallTahTwoDots": "\u0770",
    "/seenTwoDotsVerticallyAbove": "\u076D",
    "/seenabove": "\u06DC",
    "/seenarabic": "\u0633",
    "/seendotbelowdotabove": "\u069A",
    "/seenfinalarabic": "\uFEB2",
    "/seeninitialarabic": "\uFEB3",
    "/seenlow": "\u06E3",
    "/seenmedialarabic": "\uFEB4",
    "/seenthreedotsbelow": "\u069B",
    "/seenthreedotsbelowthreedotsabove": "\u069C",
    "/segment": "\u2313",
    "/segol": "\u05B6",
    "/segol13": "\u05B6",
    "/segol1f": "\u05B6",
    "/segol2c": "\u05B6",
    "/segol:hb": "\u05B6",
    "/segolhebrew": "\u05B6",
    "/segolnarrowhebrew": "\u05B6",
    "/segolquarterhebrew": "\u05B6",
    "/segolta:hb": "\u0592",
    "/segoltahebrew": "\u0592",
    "/segolwidehebrew": "\u05B6",
    "/seharmenian": "\u057D",
    "/sehiragana": "\u305B",
    "/sekatakana": "\u30BB",
    "/sekatakanahalfwidth": "\uFF7E",
    "/selfideographicparen": "\u3242",
    "/semicolon": "\u003B",
    "/semicolonarabic": "\u061B",
    "/semicolonmonospace": "\uFF1B",
    "/semicolonreversed": "\u204F",
    "/semicolonsmall": "\uFE54",
    "/semicolonunderlinefunc": "\u236E",
    "/semidirectproductleft": "\u22CB",
    "/semidirectproductright": "\u22CC",
    "/semisextile": "\u26BA",
    "/semisoftcyr": "\u048D",
    "/semivoicedmarkkana": "\u309C",
    "/semivoicedmarkkanahalfwidth": "\uFF9F",
    "/sentisquare": "\u3322",
    "/sentosquare": "\u3323",
    "/septembertelegraph": "\u32C8",
    "/sersetdblup": "\u22D1",
    "/sersetnotequalup": "\u228B",
    "/servicemark": "\u2120",
    "/sesamedot": "\uFE45",
    "/sesquiquadrate": "\u26BC",
    "/setminus": "\u2216",
    "/seven": "\u0037",
    "/seven.inferior": "\u2087",
    "/seven.roman": "\u2166",
    "/seven.romansmall": "\u2176",
    "/seven.superior": "\u2077",
    "/sevenarabic": "\u0667",
    "/sevenbengali": "\u09ED",
    "/sevencircle": "\u2466",
    "/sevencircledbl": "\u24FB",
    "/sevencircleinversesansserif": "\u2790",
    "/sevencomma": "\u1F108",
    "/sevendeva": "\u096D",
    "/seveneighths": "\u215E",
    "/sevenfar": "\u06F7",
    "/sevengujarati": "\u0AED",
    "/sevengurmukhi": "\u0A6D",
    "/sevenhackarabic": "\u0667",
    "/sevenhangzhou": "\u3027",
    "/sevenideographiccircled": "\u3286",
    "/sevenideographicparen": "\u3226",
    "/seveninferior": "\u2087",
    "/sevenmonospace": "\uFF17",
    "/sevenoldstyle": "\uF737",
    "/sevenparen": "\u247A",
    "/sevenparenthesized": "\u247A",
    "/sevenperiod": "\u248E",
    "/sevenpersian": "\u06F7",
    "/sevenpointonesquare": "\u1F1A1",
    "/sevenroman": "\u2176",
    "/sevensuperior": "\u2077",
    "/seventeencircle": "\u2470",
    "/seventeencircleblack": "\u24F1",
    "/seventeenparen": "\u2484",
    "/seventeenparenthesized": "\u2484",
    "/seventeenperiod": "\u2498",
    "/seventhai": "\u0E57",
    "/seventycirclesquare": "\u324E",
    "/sextile": "\u26B9",
    "/sfthyphen": "\u00AD",
    "/shaarmenian": "\u0577",
    "/shabengali": "\u09B6",
    "/shacyr": "\u0448",
    "/shacyrillic": "\u0448",
    "/shaddaAlefIsol": "\uFC63",
    "/shaddaDammaIsol": "\uFC61",
    "/shaddaDammaMedi": "\uFCF3",
    "/shaddaDammatanIsol": "\uFC5E",
    "/shaddaFathaIsol": "\uFC60",
    "/shaddaFathaMedi": "\uFCF2",
    "/shaddaIsol": "\uFE7C",
    "/shaddaKasraIsol": "\uFC62",
    "/shaddaKasraMedi": "\uFCF4",
    "/shaddaKasratanIsol": "\uFC5F",
    "/shaddaMedi": "\uFE7D",
    "/shaddaarabic": "\u0651",
    "/shaddadammaarabic": "\uFC61",
    "/shaddadammatanarabic": "\uFC5E",
    "/shaddafathaarabic": "\uFC60",
    "/shaddafathatanarabic": "\u0651",
    "/shaddakasraarabic": "\uFC62",
    "/shaddakasratanarabic": "\uFC5F",
    "/shade": "\u2592",
    "/shadedark": "\u2593",
    "/shadelight": "\u2591",
    "/shademedium": "\u2592",
    "/shadeva": "\u0936",
    "/shagujarati": "\u0AB6",
    "/shagurmukhi": "\u0A36",
    "/shalshelet:hb": "\u0593",
    "/shalshelethebrew": "\u0593",
    "/shamrock": "\u2618",
    "/shavedIce": "\u1F367",
    "/shbopomofo": "\u3115",
    "/shchacyr": "\u0449",
    "/shchacyrillic": "\u0449",
    "/sheen": "\u0634",
    "/sheen.fina": "\uFEB6",
    "/sheen.init": "\uFEB7",
    "/sheen.init_alefmaksura.fina": "\uFCFD",
    "/sheen.init_hah.fina": "\uFD0A",
    "/sheen.init_hah.medi": "\uFD2E",
    "/sheen.init_hah.medi_meem.medi": "\uFD68",
    "/sheen.init_heh.medi": "\uFD32",
    "/sheen.init_jeem.fina": "\uFD09",
    "/sheen.init_jeem.medi": "\uFD2D",
    "/sheen.init_khah.fina": "\uFD0B",
    "/sheen.init_khah.medi": "\uFD2F",
    "/sheen.init_meem.fina": "\uFD0C",
    "/sheen.init_meem.medi": "\uFD30",
    "/sheen.init_meem.medi_khah.medi": "\uFD6B",
    "/sheen.init_meem.medi_meem.medi": "\uFD6D",
    "/sheen.init_reh.fina": "\uFD0D",
    "/sheen.init_yeh.fina": "\uFCFE",
    "/sheen.isol": "\uFEB5",
    "/sheen.medi": "\uFEB8",
    "/sheen.medi_alefmaksura.fina": "\uFD19",
    "/sheen.medi_hah.fina": "\uFD26",
    "/sheen.medi_hah.medi": "\uFD38",
    "/sheen.medi_hah.medi_meem.fina": "\uFD67",
    "/sheen.medi_hah.medi_yeh.fina": "\uFDAA",
    "/sheen.medi_heh.medi": "\uFCEA",
    "/sheen.medi_jeem.fina": "\uFD25",
    "/sheen.medi_jeem.medi": "\uFD37",
    "/sheen.medi_jeem.medi_yeh.fina": "\uFD69",
    "/sheen.medi_khah.fina": "\uFD27",
    "/sheen.medi_khah.medi": "\uFD39",
    "/sheen.medi_meem.fina": "\uFD28",
    "/sheen.medi_meem.medi": "\uFCE9",
    "/sheen.medi_meem.medi_khah.fina": "\uFD6A",
    "/sheen.medi_meem.medi_meem.fina": "\uFD6C",
    "/sheen.medi_reh.fina": "\uFD29",
    "/sheen.medi_yeh.fina": "\uFD1A",
    "/sheenarabic": "\u0634",
    "/sheendotbelow": "\u06FA",
    "/sheenfinalarabic": "\uFEB6",
    "/sheeninitialarabic": "\uFEB7",
    "/sheenmedialarabic": "\uFEB8",
    "/sheep": "\u1F411",
    "/sheicoptic": "\u03E3",
    "/shelfmod": "\u02FD",
    "/shelfopenmod": "\u02FE",
    "/sheqel": "\u20AA",
    "/sheqelhebrew": "\u20AA",
    "/sheva": "\u05B0",
    "/sheva115": "\u05B0",
    "/sheva15": "\u05B0",
    "/sheva22": "\u05B0",
    "/sheva2e": "\u05B0",
    "/sheva:hb": "\u05B0",
    "/shevahebrew": "\u05B0",
    "/shevanarrowhebrew": "\u05B0",
    "/shevaquarterhebrew": "\u05B0",
    "/shevawidehebrew": "\u05B0",
    "/shhacyr": "\u04BB",
    "/shhacyrillic": "\u04BB",
    "/shhatailcyr": "\u0527",
    "/shield": "\u1F6E1",
    "/shimacoptic": "\u03ED",
    "/shin": "\u05E9",
    "/shin:hb": "\u05E9",
    "/shinDot:hb": "\u05C1",
    "/shindagesh": "\uFB49",
    "/shindageshhebrew": "\uFB49",
    "/shindageshshindot": "\uFB2C",
    "/shindageshshindothebrew": "\uFB2C",
    "/shindageshsindot": "\uFB2D",
    "/shindageshsindothebrew": "\uFB2D",
    "/shindothebrew": "\u05C1",
    "/shinhebrew": "\u05E9",
    "/shinshindot": "\uFB2A",
    "/shinshindothebrew": "\uFB2A",
    "/shinsindot": "\uFB2B",
    "/shinsindothebrew": "\uFB2B",
    "/shintoshrine": "\u26E9",
    "/shinwithdagesh:hb": "\uFB49",
    "/shinwithdageshandshinDot:hb": "\uFB2C",
    "/shinwithdageshandsinDot:hb": "\uFB2D",
    "/shinwithshinDot:hb": "\uFB2A",
    "/shinwithsinDot:hb": "\uFB2B",
    "/ship": "\u1F6A2",
    "/sho": "\u03F8",
    "/shoejotupfunc": "\u235D",
    "/shoestiledownfunc": "\u2366",
    "/shoestileleftfunc": "\u2367",
    "/shogipieceblack": "\u2617",
    "/shogipiecewhite": "\u2616",
    "/shook": "\u0282",
    "/shootingStar": "\u1F320",
    "/shoppingBags": "\u1F6CD",
    "/shoppingTrolley": "\u1F6D2",
    "/shortcake": "\u1F370",
    "/shortequalsmod": "\uA78A",
    "/shortoverlongmetrical": "\u23D3",
    "/shoulderedopenbox": "\u237D",
    "/shower": "\u1F6BF",
    "/shvsquare": "\u1F1AA",
    "/sicirclekatakana": "\u32DB",
    "/sidewaysBlackDownPointingIndex": "\u1F5A1",
    "/sidewaysBlackLeftPointingIndex": "\u1F59A",
    "/sidewaysBlackRightPointingIndex": "\u1F59B",
    "/sidewaysBlackUpPointingIndex": "\u1F5A0",
    "/sidewaysWhiteDownPointingIndex": "\u1F59F",
    "/sidewaysWhiteLeftPointingIndex": "\u1F598",
    "/sidewaysWhiteRightPointingIndex": "\u1F599",
    "/sidewaysWhiteUpPointingIndex": "\u1F59E",
    "/sigma": "\u03C3",
    "/sigma1": "\u03C2",
    "/sigmafinal": "\u03C2",
    "/sigmalunatedottedreversedsymbol": "\u037D",
    "/sigmalunatedottedsymbol": "\u037C",
    "/sigmalunatereversedsymbol": "\u037B",
    "/sigmalunatesymbol": "\u03F2",
    "/sigmalunatesymbolgreek": "\u03F2",
    "/sihiragana": "\u3057",
    "/sikatakana": "\u30B7",
    "/sikatakanahalfwidth": "\uFF7C",
    "/silhouetteOfJapan": "\u1F5FE",
    "/siluqhebrew": "\u05BD",
    "/siluqlefthebrew": "\u05BD",
    "/similar": "\u223C",
    "/sinDot:hb": "\u05C2",
    "/sindothebrew": "\u05C2",
    "/sinewave": "\u223F",
    "/sinh:a": "\u0D85",
    "/sinh:aa": "\u0D86",
    "/sinh:aae": "\u0D88",
    "/sinh:aaesign": "\u0DD1",
    "/sinh:aasign": "\u0DCF",
    "/sinh:ae": "\u0D87",
    "/sinh:aesign": "\u0DD0",
    "/sinh:ai": "\u0D93",
    "/sinh:aisign": "\u0DDB",
    "/sinh:anusvara": "\u0D82",
    "/sinh:au": "\u0D96",
    "/sinh:ausign": "\u0DDE",
    "/sinh:ba": "\u0DB6",
    "/sinh:bha": "\u0DB7",
    "/sinh:ca": "\u0DA0",
    "/sinh:cha": "\u0DA1",
    "/sinh:da": "\u0DAF",
    "/sinh:dda": "\u0DA9",
    "/sinh:ddha": "\u0DAA",
    "/sinh:dha": "\u0DB0",
    "/sinh:e": "\u0D91",
    "/sinh:ee": "\u0D92",
    "/sinh:eesign": "\u0DDA",
    "/sinh:esign": "\u0DD9",
    "/sinh:fa": "\u0DC6",
    "/sinh:ga": "\u0D9C",
    "/sinh:gha": "\u0D9D",
    "/sinh:ha": "\u0DC4",
    "/sinh:i": "\u0D89",
    "/sinh:ii": "\u0D8A",
    "/sinh:iisign": "\u0DD3",
    "/sinh:isign": "\u0DD2",
    "/sinh:ja": "\u0DA2",
    "/sinh:jha": "\u0DA3",
    "/sinh:jnya": "\u0DA5",
    "/sinh:ka": "\u0D9A",
    "/sinh:kha": "\u0D9B",
    "/sinh:kunddaliya": "\u0DF4",
    "/sinh:la": "\u0DBD",
    "/sinh:litheight": "\u0DEE",
    "/sinh:lithfive": "\u0DEB",
    "/sinh:lithfour": "\u0DEA",
    "/sinh:lithnine": "\u0DEF",
    "/sinh:lithone": "\u0DE7",
    "/sinh:lithseven": "\u0DED",
    "/sinh:lithsix": "\u0DEC",
    "/sinh:liththree": "\u0DE9",
    "/sinh:lithtwo": "\u0DE8",
    "/sinh:lithzero": "\u0DE6",
    "/sinh:lla": "\u0DC5",
    "/sinh:llvocal": "\u0D90",
    "/sinh:llvocalsign": "\u0DF3",
    "/sinh:lvocal": "\u0D8F",
    "/sinh:lvocalsign": "\u0DDF",
    "/sinh:ma": "\u0DB8",
    "/sinh:mba": "\u0DB9",
    "/sinh:na": "\u0DB1",
    "/sinh:nda": "\u0DB3",
    "/sinh:nga": "\u0D9E",
    "/sinh:nna": "\u0DAB",
    "/sinh:nndda": "\u0DAC",
    "/sinh:nnga": "\u0D9F",
    "/sinh:nya": "\u0DA4",
    "/sinh:nyja": "\u0DA6",
    "/sinh:o": "\u0D94",
    "/sinh:oo": "\u0D95",
    "/sinh:oosign": "\u0DDD",
    "/sinh:osign": "\u0DDC",
    "/sinh:pa": "\u0DB4",
    "/sinh:pha": "\u0DB5",
    "/sinh:ra": "\u0DBB",
    "/sinh:rrvocal": "\u0D8E",
    "/sinh:rrvocalsign": "\u0DF2",
    "/sinh:rvocal": "\u0D8D",
    "/sinh:rvocalsign": "\u0DD8",
    "/sinh:sa": "\u0DC3",
    "/sinh:sha": "\u0DC1",
    "/sinh:ssa": "\u0DC2",
    "/sinh:ta": "\u0DAD",
    "/sinh:tha": "\u0DAE",
    "/sinh:tta": "\u0DA7",
    "/sinh:ttha": "\u0DA8",
    "/sinh:u": "\u0D8B",
    "/sinh:usign": "\u0DD4",
    "/sinh:uu": "\u0D8C",
    "/sinh:uusign": "\u0DD6",
    "/sinh:va": "\u0DC0",
    "/sinh:virama": "\u0DCA",
    "/sinh:visarga": "\u0D83",
    "/sinh:ya": "\u0DBA",
    "/sinologicaldot": "\uA78F",
    "/sinsular": "\uA785",
    "/siosacirclekorean": "\u3274",
    "/siosaparenkorean": "\u3214",
    "/sioscieuckorean": "\u317E",
    "/sioscirclekorean": "\u3266",
    "/sioskiyeokkorean": "\u317A",
    "/sioskorean": "\u3145",
    "/siosnieunkorean": "\u317B",
    "/siosparenkorean": "\u3206",
    "/siospieupkorean": "\u317D",
    "/siostikeutkorean": "\u317C",
    "/siringusquare": "\u3321",
    "/six": "\u0036",
    "/six.inferior": "\u2086",
    "/six.roman": "\u2165",
    "/six.romansmall": "\u2175",
    "/six.superior": "\u2076",
    "/sixPointedStarMiddleDot": "\u1F52F",
    "/sixarabic": "\u0666",
    "/sixbengali": "\u09EC",
    "/sixcircle": "\u2465",
    "/sixcircledbl": "\u24FA",
    "/sixcircleinversesansserif": "\u278F",
    "/sixcomma": "\u1F107",
    "/sixdeva": "\u096C",
    "/sixdotsvertical": "\u2E3D",
    "/sixfar": "\u06F6",
    "/sixgujarati": "\u0AEC",
    "/sixgurmukhi": "\u0A6C",
    "/sixhackarabic": "\u0666",
    "/sixhangzhou": "\u3026",
    "/sixideographiccircled": "\u3285",
    "/sixideographicparen": "\u3225",
    "/sixinferior": "\u2086",
    "/sixlateform.roman": "\u2185",
    "/sixmonospace": "\uFF16",
    "/sixoldstyle": "\uF736",
    "/sixparen": "\u2479",
    "/sixparenthesized": "\u2479",
    "/sixperemspace": "\u2006",
    "/sixperiod": "\u248D",
    "/sixpersian": "\u06F6",
    "/sixroman": "\u2175",
    "/sixsuperior": "\u2076",
    "/sixteencircle": "\u246F",
    "/sixteencircleblack": "\u24F0",
    "/sixteencurrencydenominatorbengali": "\u09F9",
    "/sixteenparen": "\u2483",
    "/sixteenparenthesized": "\u2483",
    "/sixteenperiod": "\u2497",
    "/sixthai": "\u0E56",
    "/sixtycirclesquare": "\u324D",
    "/sixtypsquare": "\u1F1A3",
    "/sjekomicyr": "\u050D",
    "/skiAndSkiBoot": "\u1F3BF",
    "/skier": "\u26F7",
    "/skull": "\u1F480",
    "/skullcrossbones": "\u2620",
    "/slash": "\u002F",
    "/slashbarfunc": "\u233F",
    "/slashmonospace": "\uFF0F",
    "/sled": "\u1F6F7",
    "/sleeping": "\u1F4A4",
    "/sleepingAccommodation": "\u1F6CC",
    "/sleepingFace": "\u1F634",
    "/sleepyFace": "\u1F62A",
    "/sleuthOrSpy": "\u1F575",
    "/sliceOfPizza": "\u1F355",
    "/slightlyFrowningFace": "\u1F641",
    "/slightlySmilingFace": "\u1F642",
    "/slong": "\u017F",
    "/slongdotaccent": "\u1E9B",
    "/slope": "\u2333",
    "/slotMachine": "\u1F3B0",
    "/smallAirplane": "\u1F6E9",
    "/smallBlueDiamond": "\u1F539",
    "/smallOrangeDiamond": "\u1F538",
    "/smallRedTriangleDOwn": "\u1F53D",
    "/smallRedTriangleUp": "\u1F53C",
    "/smile": "\u2323",
    "/smileface": "\u263A",
    "/smilingCatFaceWithHeartShapedEyes": "\u1F63B",
    "/smilingCatFaceWithOpenMouth": "\u1F63A",
    "/smilingFaceWithHalo": "\u1F607",
    "/smilingFaceWithHeartShapedEyes": "\u1F60D",
    "/smilingFaceWithHorns": "\u1F608",
    "/smilingFaceWithOpenMouth": "\u1F603",
    "/smilingFaceWithOpenMouthAndColdSweat": "\u1F605",
    "/smilingFaceWithOpenMouthAndSmilingEyes": "\u1F604",
    "/smilingFaceWithOpenMouthAndTightlyClosedEyes": "\u1F606",
    "/smilingFaceWithSmilingEyes": "\u1F60A",
    "/smilingFaceWithSunglasses": "\u1F60E",
    "/smilingfaceblack": "\u263B",
    "/smilingfacewhite": "\u263A",
    "/smirkingFace": "\u1F60F",
    "/smll:ampersand": "\uFE60",
    "/smll:asterisk": "\uFE61",
    "/smll:backslash": "\uFE68",
    "/smll:braceleft": "\uFE5B",
    "/smll:braceright": "\uFE5C",
    "/smll:colon": "\uFE55",
    "/smll:comma": "\uFE50",
    "/smll:dollar": "\uFE69",
    "/smll:emdash": "\uFE58",
    "/smll:equal": "\uFE66",
    "/smll:exclam": "\uFE57",
    "/smll:greater": "\uFE65",
    "/smll:hyphen": "\uFE63",
    "/smll:ideographiccomma": "\uFE51",
    "/smll:less": "\uFE64",
    "/smll:numbersign": "\uFE5F",
    "/smll:parenthesisleft": "\uFE59",
    "/smll:parenthesisright": "\uFE5A",
    "/smll:percent": "\uFE6A",
    "/smll:period": "\uFE52",
    "/smll:plus": "\uFE62",
    "/smll:question": "\uFE56",
    "/smll:semicolon": "\uFE54",
    "/smll:tortoiseshellbracketleft": "\uFE5D",
    "/smll:tortoiseshellbracketright": "\uFE5E",
    "/smoking": "\u1F6AC",
    "/smonospace": "\uFF53",
    "/snail": "\u1F40C",
    "/snake": "\u1F40D",
    "/snowboarder": "\u1F3C2",
    "/snowcappedMountain": "\u1F3D4",
    "/snowman": "\u2603",
    "/snowmanblack": "\u26C7",
    "/snowmanoutsnow": "\u26C4",
    "/sobliquestroke": "\uA7A9",
    "/soccerball": "\u26BD",
    "/societyideographiccircled": "\u3293",
    "/societyideographicparen": "\u3233",
    "/socirclekatakana": "\u32DE",
    "/sofPasuq:hb": "\u05C3",
    "/sofpasuqhebrew": "\u05C3",
    "/softIceCream": "\u1F366",
    "/softShellFloppyDisk": "\u1F5AC",
    "/softcyr": "\u044C",
    "/softhyphen": "\u00AD",
    "/softsigncyrillic": "\u044C",
    "/softwarefunction": "\u2394",
    "/sohiragana": "\u305D",
    "/sokatakana": "\u30BD",
    "/sokatakanahalfwidth": "\uFF7F",
    "/soliduslongoverlaycmb": "\u0338",
    "/solidusshortoverlaycmb": "\u0337",
    "/solidussubsetreversepreceding": "\u27C8",
    "/solidussupersetpreceding": "\u27C9",
    "/soonRightwardsArrowAbove": "\u1F51C",
    "/sorusithai": "\u0E29",
    "/sosalathai": "\u0E28",
    "/sosothai": "\u0E0B",
    "/sossquare": "\u1F198",
    "/sosuathai": "\u0E2A",
    "/soundcopyright": "\u2117",
    "/space": "\u0020",
    "/spacehackarabic": "\u0020",
    "/spade": "\u2660",
    "/spadeblack": "\u2660",
    "/spadesuitblack": "\u2660",
    "/spadesuitwhite": "\u2664",
    "/spadewhite": "\u2664",
    "/spaghetti": "\u1F35D",
    "/sparen": "\u24AE",
    "/sparenthesized": "\u24AE",
    "/sparklingHeart": "\u1F496",
    "/speakNoEvilMonkey": "\u1F64A",
    "/speaker": "\u1F508",
    "/speakerCancellationStroke": "\u1F507",
    "/speakerOneSoundWave": "\u1F509",
    "/speakerThreeSoundWaves": "\u1F50A",
    "/speakingHeadInSilhouette": "\u1F5E3",
    "/specialideographiccircled": "\u3295",
    "/specialideographicparen": "\u3235",
    "/speechBalloon": "\u1F4AC",
    "/speedboat": "\u1F6A4",
    "/spesmilo": "\u20B7",
    "/sphericalangle": "\u2222",
    "/spider": "\u1F577",
    "/spiderWeb": "\u1F578",
    "/spiralCalendarPad": "\u1F5D3",
    "/spiralNotePad": "\u1F5D2",
    "/spiralShell": "\u1F41A",
    "/splashingSweat": "\u1F4A6",
    "/sportsMedal": "\u1F3C5",
    "/spoutingWhale": "\u1F433",
    "/sppl:tildevertical": "\u2E2F",
    "/squarebelowcmb": "\u033B",
    "/squareblack": "\u25A0",
    "/squarebracketleftvertical": "\uFE47",
    "/squarebracketrightvertical": "\uFE48",
    "/squarecap": "\u2293",
    "/squarecc": "\u33C4",
    "/squarecm": "\u339D",
    "/squarecup": "\u2294",
    "/squareddotoperator": "\u22A1",
    "/squarediagonalcrosshatchfill": "\u25A9",
    "/squaredj": "\u1F190",
    "/squaredkey": "\u26BF",
    "/squaredminus": "\u229F",
    "/squaredplus": "\u229E",
    "/squaredsaltire": "\u26DD",
    "/squaredtimes": "\u22A0",
    "/squarefourcorners": "\u26F6",
    "/squarehalfleftblack": "\u25E7",
    "/squarehalfrightblack": "\u25E8",
    "/squarehorizontalfill": "\u25A4",
    "/squareimage": "\u228F",
    "/squareimageorequal": "\u2291",
    "/squareimageornotequal": "\u22E4",
    "/squarekg": "\u338F",
    "/squarekm": "\u339E",
    "/squarekmcapital": "\u33CE",
    "/squareln": "\u33D1",
    "/squarelog": "\u33D2",
    "/squarelowerdiagonalhalfrightblack": "\u25EA",
    "/squaremediumblack": "\u25FC",
    "/squaremediumwhite": "\u25FB",
    "/squaremg": "\u338E",
    "/squaremil": "\u33D5",
    "/squaremm": "\u339C",
    "/squaremsquared": "\u33A1",
    "/squareoriginal": "\u2290",
    "/squareoriginalorequal": "\u2292",
    "/squareoriginalornotequal": "\u22E5",
    "/squareorthogonalcrosshatchfill": "\u25A6",
    "/squareraised": "\u2E0B",
    "/squaresmallblack": "\u25AA",
    "/squaresmallmediumblack": "\u25FE",
    "/squaresmallmediumwhite": "\u25FD",
    "/squaresmallwhite": "\u25AB",
    "/squareupperdiagonalhalfleftblack": "\u25E9",
    "/squareupperlefttolowerrightfill": "\u25A7",
    "/squareupperrighttolowerleftfill": "\u25A8",
    "/squareverticalfill": "\u25A5",
    "/squarewhite": "\u25A1",
    "/squarewhitebisectinglinevertical": "\u25EB",
    "/squarewhitelowerquadrantleft": "\u25F1",
    "/squarewhitelowerquadrantright": "\u25F2",
    "/squarewhiteround": "\u25A2",
    "/squarewhiteupperquadrantleft": "\u25F0",
    "/squarewhiteupperquadrantright": "\u25F3",
    "/squarewhitewithsmallblack": "\u25A3",
    "/squarewhitewithsquaresmallblack": "\u25A3",
    "/squishquadfunc": "\u2337",
    "/srfullwidth": "\u33DB",
    "/srsquare": "\u33DB",
    "/ssabengali": "\u09B7",
    "/ssadeva": "\u0937",
    "/ssagujarati": "\u0AB7",
    "/ssangcieuckorean": "\u3149",
    "/ssanghieuhkorean": "\u3185",
    "/ssangieungkorean": "\u3180",
    "/ssangkiyeokkorean": "\u3132",
    "/ssangnieunkorean": "\u3165",
    "/ssangpieupkorean": "\u3143",
    "/ssangsioskorean": "\u3146",
    "/ssangtikeutkorean": "\u3138",
    "/ssuperior": "\uF6F2",
    "/ssupmod": "\u02E2",
    "/sswashtail": "\u023F",
    "/stackedcommadbl": "\u2E49",
    "/stadium": "\u1F3DF",
    "/staffofaesculapius": "\u2695",
    "/staffofhermes": "\u269A",
    "/stampedEnvelope": "\u1F583",
    "/star": "\u22C6",
    "/starblack": "\u2605",
    "/starcrescent": "\u262A",
    "/stardiaeresisfunc": "\u2363",
    "/starequals": "\u225B",
    "/staroperator": "\u22C6",
    "/staroutlinedwhite": "\u269D",
    "/starwhite": "\u2606",
    "/station": "\u1F689",
    "/statueOfLiberty": "\u1F5FD",
    "/steamLocomotive": "\u1F682",
    "/steamingBowl": "\u1F35C",
    "/stenographicfullstop": "\u2E3C",
    "/sterling": "\u00A3",
    "/sterlingmonospace": "\uFFE1",
    "/stigma": "\u03DB",
    "/stiletildefunc": "\u236D",
    "/stockChart": "\u1F5E0",
    "/stockideographiccircled": "\u3291",
    "/stockideographicparen": "\u3231",
    "/stopabove": "\u06EB",
    "/stopbelow": "\u06EA",
    "/straightRuler": "\u1F4CF",
    "/straightness": "\u23E4",
    "/strawberry": "\u1F353",
    "/stresslowtonemod": "\uA721",
    "/stresstonemod": "\uA720",
    "/strictlyequivalent": "\u2263",
    "/strokelongoverlaycmb": "\u0336",
    "/strokeshortoverlaycmb": "\u0335",
    "/studioMicrophone": "\u1F399",
    "/studyideographiccircled": "\u32AB",
    "/studyideographicparen": "\u323B",
    "/stupa": "\u1F6D3",
    "/subscriptalef": "\u0656",
    "/subset": "\u2282",
    "/subsetdbl": "\u22D0",
    "/subsetnotequal": "\u228A",
    "/subsetorequal": "\u2286",
    "/succeeds": "\u227B",
    "/succeedsbutnotequivalent": "\u22E9",
    "/succeedsorequal": "\u227D",
    "/succeedsorequivalent": "\u227F",
    "/succeedsunderrelation": "\u22B1",
    "/suchthat": "\u220B",
    "/sucirclekatakana": "\u32DC",
    "/suhiragana": "\u3059",
    "/suitableideographiccircled": "\u329C",
    "/sukatakana": "\u30B9",
    "/sukatakanahalfwidth": "\uFF7D",
    "/sukumendutvowel": "\uA9B9",
    "/sukunIsol": "\uFE7E",
    "/sukunMedi": "\uFE7F",
    "/sukunarabic": "\u0652",
    "/sukuvowel": "\uA9B8",
    "/summation": "\u2211",
    "/summationbottom": "\u23B3",
    "/summationdblstruck": "\u2140",
    "/summationtop": "\u23B2",
    "/sun": "\u263C",
    "/sunFace": "\u1F31E",
    "/sunbehindcloud": "\u26C5",
    "/sunflower": "\u1F33B",
    "/sunideographiccircled": "\u3290",
    "/sunideographicparen": "\u3230",
    "/sunraysblack": "\u2600",
    "/sunrayswhite": "\u263C",
    "/sunrise": "\u1F305",
    "/sunriseOverMountains": "\u1F304",
    "/sunsetOverBuildings": "\u1F307",
    "/superset": "\u2283",
    "/supersetnotequal": "\u228B",
    "/supersetorequal": "\u2287",
    "/superviseideographiccircled": "\u32AC",
    "/superviseideographicparen": "\u323C",
    "/surfer": "\u1F3C4",
    "/sushi": "\u1F363",
    "/suspensionRailway": "\u1F69F",
    "/suspensiondbl": "\u2E44",
    "/svfullwidth": "\u33DC",
    "/svsquare": "\u33DC",
    "/swatchtop": "\u23F1",
    "/swimmer": "\u1F3CA",
    "/swungdash": "\u2053",
    "/symbolabovethreedotsabove": "\uFBB6",
    "/symbolbelowthreedotsabove": "\uFBB7",
    "/symboldotabove": "\uFBB2",
    "/symboldotbelow": "\uFBB3",
    "/symboldoubleverticalbarbelow": "\uFBBC",
    "/symbolfourdotsabove": "\uFBBA",
    "/symbolfourdotsbelow": "\uFBBB",
    "/symbolpointingabovedownthreedotsabove": "\uFBB8",
    "/symbolpointingbelowdownthreedotsabove": "\uFBB9",
    "/symbolring": "\uFBBF",
    "/symboltahabovesmall": "\uFBC0",
    "/symboltahbelowsmall": "\uFBC1",
    "/symboltwodotsabove": "\uFBB4",
    "/symboltwodotsbelow": "\uFBB5",
    "/symboltwodotsverticallyabove": "\uFBBD",
    "/symboltwodotsverticallybelow": "\uFBBE",
    "/symmetry": "\u232F",
    "/synagogue": "\u1F54D",
    "/syouwaerasquare": "\u337C",
    "/syringe": "\u1F489",
    "/t": "\u0074",
    "/t-shirt": "\u1F455",
    "/t.inferior": "\u209C",
    "/tabengali": "\u09A4",
    "/tableTennisPaddleAndBall": "\u1F3D3",
    "/tacirclekatakana": "\u32DF",
    "/tackcircleaboveup": "\u27DF",
    "/tackdiaeresisupfunc": "\u2361",
    "/tackdown": "\u22A4",
    "/tackdownmod": "\u02D5",
    "/tackjotdownfunc": "\u234E",
    "/tackjotupfunc": "\u2355",
    "/tackleft": "\u22A3",
    "/tackleftright": "\u27DB",
    "/tackoverbarupfunc": "\u2351",
    "/tackright": "\u22A2",
    "/tackunderlinedownfunc": "\u234A",
    "/tackup": "\u22A5",
    "/tackupmod": "\u02D4",
    "/taco": "\u1F32E",
    "/tadeva": "\u0924",
    "/tagujarati": "\u0AA4",
    "/tagurmukhi": "\u0A24",
    "/tah": "\u0637",
    "/tah.fina": "\uFEC2",
    "/tah.init": "\uFEC3",
    "/tah.init_alefmaksura.fina": "\uFCF5",
    "/tah.init_hah.fina": "\uFC26",
    "/tah.init_hah.medi": "\uFCB8",
    "/tah.init_meem.fina": "\uFC27",
    "/tah.init_meem.medi": "\uFD33",
    "/tah.init_meem.medi_hah.medi": "\uFD72",
    "/tah.init_meem.medi_meem.medi": "\uFD73",
    "/tah.init_yeh.fina": "\uFCF6",
    "/tah.isol": "\uFEC1",
    "/tah.medi": "\uFEC4",
    "/tah.medi_alefmaksura.fina": "\uFD11",
    "/tah.medi_meem.medi": "\uFD3A",
    "/tah.medi_meem.medi_hah.fina": "\uFD71",
    "/tah.medi_meem.medi_yeh.fina": "\uFD74",
    "/tah.medi_yeh.fina": "\uFD12",
    "/tahabove": "\u0615",
    "/taharabic": "\u0637",
    "/tahfinalarabic": "\uFEC2",
    "/tahinitialarabic": "\uFEC3",
    "/tahiragana": "\u305F",
    "/tahmedialarabic": "\uFEC4",
    "/tahthreedotsabove": "\u069F",
    "/taisyouerasquare": "\u337D",
    "/takatakana": "\u30BF",
    "/takatakanahalfwidth": "\uFF80",
    "/takhallus": "\u0614",
    "/talingvowel": "\uA9BA",
    "/taml:a": "\u0B85",
    "/taml:aa": "\u0B86",
    "/taml:aasign": "\u0BBE",
    "/taml:ai": "\u0B90",
    "/taml:aisign": "\u0BC8",
    "/taml:anusvarasign": "\u0B82",
    "/taml:asabovesign": "\u0BF8",
    "/taml:au": "\u0B94",
    "/taml:aulengthmark": "\u0BD7",
    "/taml:ausign": "\u0BCC",
    "/taml:ca": "\u0B9A",
    "/taml:creditsign": "\u0BF7",
    "/taml:daysign": "\u0BF3",
    "/taml:debitsign": "\u0BF6",
    "/taml:e": "\u0B8E",
    "/taml:ee": "\u0B8F",
    "/taml:eesign": "\u0BC7",
    "/taml:eight": "\u0BEE",
    "/taml:esign": "\u0BC6",
    "/taml:five": "\u0BEB",
    "/taml:four": "\u0BEA",
    "/taml:ha": "\u0BB9",
    "/taml:i": "\u0B87",
    "/taml:ii": "\u0B88",
    "/taml:iisign": "\u0BC0",
    "/taml:isign": "\u0BBF",
    "/taml:ja": "\u0B9C",
    "/taml:ka": "\u0B95",
    "/taml:la": "\u0BB2",
    "/taml:lla": "\u0BB3",
    "/taml:llla": "\u0BB4",
    "/taml:ma": "\u0BAE",
    "/taml:monthsign": "\u0BF4",
    "/taml:na": "\u0BA8",
    "/taml:nga": "\u0B99",
    "/taml:nine": "\u0BEF",
    "/taml:nna": "\u0BA3",
    "/taml:nnna": "\u0BA9",
    "/taml:nya": "\u0B9E",
    "/taml:o": "\u0B92",
    "/taml:om": "\u0BD0",
    "/taml:one": "\u0BE7",
    "/taml:onehundred": "\u0BF1",
    "/taml:onethousand": "\u0BF2",
    "/taml:oo": "\u0B93",
    "/taml:oosign": "\u0BCB",
    "/taml:osign": "\u0BCA",
    "/taml:pa": "\u0BAA",
    "/taml:ra": "\u0BB0",
    "/taml:rra": "\u0BB1",
    "/taml:rupeesign": "\u0BF9",
    "/taml:sa": "\u0BB8",
    "/taml:seven": "\u0BED",
    "/taml:sha": "\u0BB6",
    "/taml:sign": "\u0BFA",
    "/taml:six": "\u0BEC",
    "/taml:ssa": "\u0BB7",
    "/taml:ta": "\u0BA4",
    "/taml:ten": "\u0BF0",
    "/taml:three": "\u0BE9",
    "/taml:tta": "\u0B9F",
    "/taml:two": "\u0BE8",
    "/taml:u": "\u0B89",
    "/taml:usign": "\u0BC1",
    "/taml:uu": "\u0B8A",
    "/taml:uusign": "\u0BC2",
    "/taml:va": "\u0BB5",
    "/taml:viramasign": "\u0BCD",
    "/taml:visargasign": "\u0B83",
    "/taml:ya": "\u0BAF",
    "/taml:yearsign": "\u0BF5",
    "/taml:zero": "\u0BE6",
    "/tamurda": "\uA9A1",
    "/tanabataTree": "\u1F38B",
    "/tangerine": "\u1F34A",
    "/tapeCartridge": "\u1F5AD",
    "/tarungvowel": "\uA9B4",
    "/tatweelFathatanAbove": "\uFE71",
    "/tatweelarabic": "\u0640",
    "/tau": "\u03C4",
    "/taurus": "\u2649",
    "/tav": "\u05EA",
    "/tav:hb": "\u05EA",
    "/tavdages": "\uFB4A",
    "/tavdagesh": "\uFB4A",
    "/tavdageshhebrew": "\uFB4A",
    "/tavhebrew": "\u05EA",
    "/tavwide:hb": "\uFB28",
    "/tavwithdagesh:hb": "\uFB4A",
    "/taxi": "\u1F695",
    "/tbar": "\u0167",
    "/tbopomofo": "\u310A",
    "/tcaron": "\u0165",
    "/tccurl": "\u02A8",
    "/tcedilla": "\u0163",
    "/tcheh": "\u0686",
    "/tcheh.fina": "\uFB7B",
    "/tcheh.init": "\uFB7C",
    "/tcheh.isol": "\uFB7A",
    "/tcheh.medi": "\uFB7D",
    "/tcheharabic": "\u0686",
    "/tchehdotabove": "\u06BF",
    "/tcheheh": "\u0687",
    "/tcheheh.fina": "\uFB7F",
    "/tcheheh.init": "\uFB80",
    "/tcheheh.isol": "\uFB7E",
    "/tcheheh.medi": "\uFB81",
    "/tchehfinalarabic": "\uFB7B",
    "/tchehinitialarabic": "\uFB7C",
    "/tchehmedialarabic": "\uFB7D",
    "/tchehmeeminitialarabic": "\uFB7C",
    "/tcircle": "\u24E3",
    "/tcircumflexbelow": "\u1E71",
    "/tcommaaccent": "\u0163",
    "/tcurl": "\u0236",
    "/tdieresis": "\u1E97",
    "/tdot": "\u1E6B",
    "/tdotaccent": "\u1E6B",
    "/tdotbelow": "\u1E6D",
    "/teacupOutHandle": "\u1F375",
    "/tear-offCalendar": "\u1F4C6",
    "/tecirclekatakana": "\u32E2",
    "/tecyr": "\u0442",
    "/tecyrillic": "\u0442",
    "/tedescendercyrillic": "\u04AD",
    "/teh": "\u062A",
    "/teh.fina": "\uFE96",
    "/teh.init": "\uFE97",
    "/teh.init_alefmaksura.fina": "\uFC0F",
    "/teh.init_hah.fina": "\uFC0C",
    "/teh.init_hah.medi": "\uFCA2",
    "/teh.init_hah.medi_jeem.medi": "\uFD52",
    "/teh.init_hah.medi_meem.medi": "\uFD53",
    "/teh.init_heh.medi": "\uFCA5",
    "/teh.init_jeem.fina": "\uFC0B",
    "/teh.init_jeem.medi": "\uFCA1",
    "/teh.init_jeem.medi_meem.medi": "\uFD50",
    "/teh.init_khah.fina": "\uFC0D",
    "/teh.init_khah.medi": "\uFCA3",
    "/teh.init_khah.medi_meem.medi": "\uFD54",
    "/teh.init_meem.fina": "\uFC0E",
    "/teh.init_meem.medi": "\uFCA4",
    "/teh.init_meem.medi_hah.medi": "\uFD56",
    "/teh.init_meem.medi_jeem.medi": "\uFD55",
    "/teh.init_meem.medi_khah.medi": "\uFD57",
    "/teh.init_yeh.fina": "\uFC10",
    "/teh.isol": "\uFE95",
    "/teh.medi": "\uFE98",
    "/teh.medi_alefmaksura.fina": "\uFC74",
    "/teh.medi_hah.medi_jeem.fina": "\uFD51",
    "/teh.medi_heh.medi": "\uFCE4",
    "/teh.medi_jeem.medi_alefmaksura.fina": "\uFDA0",
    "/teh.medi_jeem.medi_yeh.fina": "\uFD9F",
    "/teh.medi_khah.medi_alefmaksura.fina": "\uFDA2",
    "/teh.medi_khah.medi_yeh.fina": "\uFDA1",
    "/teh.medi_meem.fina": "\uFC72",
    "/teh.medi_meem.medi": "\uFCE3",
    "/teh.medi_meem.medi_alefmaksura.fina": "\uFDA4",
    "/teh.medi_meem.medi_yeh.fina": "\uFDA3",
    "/teh.medi_noon.fina": "\uFC73",
    "/teh.medi_reh.fina": "\uFC70",
    "/teh.medi_yeh.fina": "\uFC75",
    "/teh.medi_zain.fina": "\uFC71",
    "/teharabic": "\u062A",
    "/tehdownthreedotsabove": "\u067D",
    "/teheh": "\u067F",
    "/teheh.fina": "\uFB63",
    "/teheh.init": "\uFB64",
    "/teheh.isol": "\uFB62",
    "/teheh.medi": "\uFB65",
    "/tehfinalarabic": "\uFE96",
    "/tehhahinitialarabic": "\uFCA2",
    "/tehhahisolatedarabic": "\uFC0C",
    "/tehinitialarabic": "\uFE97",
    "/tehiragana": "\u3066",
    "/tehjeeminitialarabic": "\uFCA1",
    "/tehjeemisolatedarabic": "\uFC0B",
    "/tehmarbuta": "\u0629",
    "/tehmarbuta.fina": "\uFE94",
    "/tehmarbuta.isol": "\uFE93",
    "/tehmarbutaarabic": "\u0629",
    "/tehmarbutafinalarabic": "\uFE94",
    "/tehmarbutagoal": "\u06C3",
    "/tehmedialarabic": "\uFE98",
    "/tehmeeminitialarabic": "\uFCA4",
    "/tehmeemisolatedarabic": "\uFC0E",
    "/tehnoonfinalarabic": "\uFC73",
    "/tehring": "\u067C",
    "/tekatakana": "\u30C6",
    "/tekatakanahalfwidth": "\uFF83",
    "/telephone": "\u2121",
    "/telephoneOnTopOfModem": "\u1F580",
    "/telephoneReceiver": "\u1F4DE",
    "/telephoneReceiverPage": "\u1F57C",
    "/telephoneblack": "\u260E",
    "/telephonerecorder": "\u2315",
    "/telephonewhite": "\u260F",
    "/telescope": "\u1F52D",
    "/television": "\u1F4FA",
    "/telishaGedolah:hb": "\u05A0",
    "/telishaQetannah:hb": "\u05A9",
    "/telishagedolahebrew": "\u05A0",
    "/telishaqetanahebrew": "\u05A9",
    "/telu:a": "\u0C05",
    "/telu:aa": "\u0C06",
    "/telu:aasign": "\u0C3E",
    "/telu:ai": "\u0C10",
    "/telu:ailengthmark": "\u0C56",
    "/telu:aisign": "\u0C48",
    "/telu:anusvarasign": "\u0C02",
    "/telu:au": "\u0C14",
    "/telu:ausign": "\u0C4C",
    "/telu:avagrahasign": "\u0C3D",
    "/telu:ba": "\u0C2C",
    "/telu:bha": "\u0C2D",
    "/telu:bindusigncandra": "\u0C01",
    "/telu:ca": "\u0C1A",
    "/telu:cha": "\u0C1B",
    "/telu:combiningbinduabovesigncandra": "\u0C00",
    "/telu:da": "\u0C26",
    "/telu:dda": "\u0C21",
    "/telu:ddha": "\u0C22",
    "/telu:dha": "\u0C27",
    "/telu:dza": "\u0C59",
    "/telu:e": "\u0C0E",
    "/telu:ee": "\u0C0F",
    "/telu:eesign": "\u0C47",
    "/telu:eight": "\u0C6E",
    "/telu:esign": "\u0C46",
    "/telu:five": "\u0C6B",
    "/telu:four": "\u0C6A",
    "/telu:fractiononeforevenpowersoffour": "\u0C7C",
    "/telu:fractiononeforoddpowersoffour": "\u0C79",
    "/telu:fractionthreeforevenpowersoffour": "\u0C7E",
    "/telu:fractionthreeforoddpowersoffour": "\u0C7B",
    "/telu:fractiontwoforevenpowersoffour": "\u0C7D",
    "/telu:fractiontwoforoddpowersoffour": "\u0C7A",
    "/telu:fractionzeroforoddpowersoffour": "\u0C78",
    "/telu:ga": "\u0C17",
    "/telu:gha": "\u0C18",
    "/telu:ha": "\u0C39",
    "/telu:i": "\u0C07",
    "/telu:ii": "\u0C08",
    "/telu:iisign": "\u0C40",
    "/telu:isign": "\u0C3F",
    "/telu:ja": "\u0C1C",
    "/telu:jha": "\u0C1D",
    "/telu:ka": "\u0C15",
    "/telu:kha": "\u0C16",
    "/telu:la": "\u0C32",
    "/telu:lengthmark": "\u0C55",
    "/telu:lla": "\u0C33",
    "/telu:llla": "\u0C34",
    "/telu:llsignvocal": "\u0C63",
    "/telu:llvocal": "\u0C61",
    "/telu:lsignvocal": "\u0C62",
    "/telu:lvocal": "\u0C0C",
    "/telu:ma": "\u0C2E",
    "/telu:na": "\u0C28",
    "/telu:nga": "\u0C19",
    "/telu:nine": "\u0C6F",
    "/telu:nna": "\u0C23",
    "/telu:nya": "\u0C1E",
    "/telu:o": "\u0C12",
    "/telu:one": "\u0C67",
    "/telu:oo": "\u0C13",
    "/telu:oosign": "\u0C4B",
    "/telu:osign": "\u0C4A",
    "/telu:pa": "\u0C2A",
    "/telu:pha": "\u0C2B",
    "/telu:ra": "\u0C30",
    "/telu:rra": "\u0C31",
    "/telu:rrra": "\u0C5A",
    "/telu:rrsignvocal": "\u0C44",
    "/telu:rrvocal": "\u0C60",
    "/telu:rsignvocal": "\u0C43",
    "/telu:rvocal": "\u0C0B",
    "/telu:sa": "\u0C38",
    "/telu:seven": "\u0C6D",
    "/telu:sha": "\u0C36",
    "/telu:six": "\u0C6C",
    "/telu:ssa": "\u0C37",
    "/telu:ta": "\u0C24",
    "/telu:tha": "\u0C25",
    "/telu:three": "\u0C69",
    "/telu:tsa": "\u0C58",
    "/telu:tta": "\u0C1F",
    "/telu:ttha": "\u0C20",
    "/telu:tuumusign": "\u0C7F",
    "/telu:two": "\u0C68",
    "/telu:u": "\u0C09",
    "/telu:usign": "\u0C41",
    "/telu:uu": "\u0C0A",
    "/telu:uusign": "\u0C42",
    "/telu:va": "\u0C35",
    "/telu:viramasign": "\u0C4D",
    "/telu:visargasign": "\u0C03",
    "/telu:ya": "\u0C2F",
    "/telu:zero": "\u0C66",
    "/ten.roman": "\u2169",
    "/ten.romansmall": "\u2179",
    "/tencircle": "\u2469",
    "/tencircledbl": "\u24FE",
    "/tencirclesquare": "\u3248",
    "/tenge": "\u20B8",
    "/tenhangzhou": "\u3038",
    "/tenideographiccircled": "\u3289",
    "/tenideographicparen": "\u3229",
    "/tennisRacquetAndBall": "\u1F3BE",
    "/tenparen": "\u247D",
    "/tenparenthesized": "\u247D",
    "/tenperiod": "\u2491",
    "/tenroman": "\u2179",
    "/tent": "\u26FA",
    "/tenthousand.roman": "\u2182",
    "/tesh": "\u02A7",
    "/tet": "\u05D8",
    "/tet:hb": "\u05D8",
    "/tetailcyr": "\u04AD",
    "/tetdagesh": "\uFB38",
    "/tetdageshhebrew": "\uFB38",
    "/tethebrew": "\u05D8",
    "/tetrasememetrical": "\u23D8",
    "/tetsecyr": "\u04B5",
    "/tetsecyrillic": "\u04B5",
    "/tetwithdagesh:hb": "\uFB38",
    "/tevir:hb": "\u059B",
    "/tevirhebrew": "\u059B",
    "/tevirlefthebrew": "\u059B",
    "/thabengali": "\u09A5",
    "/thadeva": "\u0925",
    "/thagujarati": "\u0AA5",
    "/thagurmukhi": "\u0A25",
    "/thai:angkhankhu": "\u0E5A",
    "/thai:baht": "\u0E3F",
    "/thai:bobaimai": "\u0E1A",
    "/thai:chochan": "\u0E08",
    "/thai:chochang": "\u0E0A",
    "/thai:choching": "\u0E09",
    "/thai:chochoe": "\u0E0C",
    "/thai:dochada": "\u0E0E",
    "/thai:dodek": "\u0E14",
    "/thai:eight": "\u0E58",
    "/thai:five": "\u0E55",
    "/thai:fofa": "\u0E1D",
    "/thai:fofan": "\u0E1F",
    "/thai:fongman": "\u0E4F",
    "/thai:four": "\u0E54",
    "/thai:hohip": "\u0E2B",
    "/thai:honokhuk": "\u0E2E",
    "/thai:khokhai": "\u0E02",
    "/thai:khokhon": "\u0E05",
    "/thai:khokhuat": "\u0E03",
    "/thai:khokhwai": "\u0E04",
    "/thai:khomut": "\u0E5B",
    "/thai:khorakhang": "\u0E06",
    "/thai:kokai": "\u0E01",
    "/thai:lakkhangyao": "\u0E45",
    "/thai:lochula": "\u0E2C",
    "/thai:loling": "\u0E25",
    "/thai:lu": "\u0E26",
    "/thai:maichattawa": "\u0E4B",
    "/thai:maiek": "\u0E48",
    "/thai:maihan-akat": "\u0E31",
    "/thai:maitaikhu": "\u0E47",
    "/thai:maitho": "\u0E49",
    "/thai:maitri": "\u0E4A",
    "/thai:maiyamok": "\u0E46",
    "/thai:moma": "\u0E21",
    "/thai:ngongu": "\u0E07",
    "/thai:nikhahit": "\u0E4D",
    "/thai:nine": "\u0E59",
    "/thai:nonen": "\u0E13",
    "/thai:nonu": "\u0E19",
    "/thai:oang": "\u0E2D",
    "/thai:one": "\u0E51",
    "/thai:paiyannoi": "\u0E2F",
    "/thai:phinthu": "\u0E3A",
    "/thai:phophan": "\u0E1E",
    "/thai:phophung": "\u0E1C",
    "/thai:phosamphao": "\u0E20",
    "/thai:popla": "\u0E1B",
    "/thai:rorua": "\u0E23",
    "/thai:ru": "\u0E24",
    "/thai:saraa": "\u0E30",
    "/thai:saraaa": "\u0E32",
    "/thai:saraae": "\u0E41",
    "/thai:saraaimaimalai": "\u0E44",
    "/thai:saraaimaimuan": "\u0E43",
    "/thai:saraam": "\u0E33",
    "/thai:sarae": "\u0E40",
    "/thai:sarai": "\u0E34",
    "/thai:saraii": "\u0E35",
    "/thai:sarao": "\u0E42",
    "/thai:sarau": "\u0E38",
    "/thai:saraue": "\u0E36",
    "/thai:sarauee": "\u0E37",
    "/thai:sarauu": "\u0E39",
    "/thai:seven": "\u0E57",
    "/thai:six": "\u0E56",
    "/thai:sorusi": "\u0E29",
    "/thai:sosala": "\u0E28",
    "/thai:soso": "\u0E0B",
    "/thai:sosua": "\u0E2A",
    "/thai:thanthakhat": "\u0E4C",
    "/thai:thonangmontho": "\u0E11",
    "/thai:thophuthao": "\u0E12",
    "/thai:thothahan": "\u0E17",
    "/thai:thothan": "\u0E10",
    "/thai:thothong": "\u0E18",
    "/thai:thothung": "\u0E16",
    "/thai:three": "\u0E53",
    "/thai:topatak": "\u0E0F",
    "/thai:totao": "\u0E15",
    "/thai:two": "\u0E52",
    "/thai:wowaen": "\u0E27",
    "/thai:yamakkan": "\u0E4E",
    "/thai:yoyak": "\u0E22",
    "/thai:yoying": "\u0E0D",
    "/thai:zero": "\u0E50",
    "/thal": "\u0630",
    "/thal.fina": "\uFEAC",
    "/thal.init_superscriptalef.fina": "\uFC5B",
    "/thal.isol": "\uFEAB",
    "/thalarabic": "\u0630",
    "/thalfinalarabic": "\uFEAC",
    "/thanthakhatlowleftthai": "\uF898",
    "/thanthakhatlowrightthai": "\uF897",
    "/thanthakhatthai": "\u0E4C",
    "/thanthakhatupperleftthai": "\uF896",
    "/theh": "\u062B",
    "/theh.fina": "\uFE9A",
    "/theh.init": "\uFE9B",
    "/theh.init_alefmaksura.fina": "\uFC13",
    "/theh.init_jeem.fina": "\uFC11",
    "/theh.init_meem.fina": "\uFC12",
    "/theh.init_meem.medi": "\uFCA6",
    "/theh.init_yeh.fina": "\uFC14",
    "/theh.isol": "\uFE99",
    "/theh.medi": "\uFE9C",
    "/theh.medi_alefmaksura.fina": "\uFC7A",
    "/theh.medi_heh.medi": "\uFCE6",
    "/theh.medi_meem.fina": "\uFC78",
    "/theh.medi_meem.medi": "\uFCE5",
    "/theh.medi_noon.fina": "\uFC79",
    "/theh.medi_reh.fina": "\uFC76",
    "/theh.medi_yeh.fina": "\uFC7B",
    "/theh.medi_zain.fina": "\uFC77",
    "/theharabic": "\u062B",
    "/thehfinalarabic": "\uFE9A",
    "/thehinitialarabic": "\uFE9B",
    "/thehmedialarabic": "\uFE9C",
    "/thereexists": "\u2203",
    "/therefore": "\u2234",
    "/thermometer": "\u1F321",
    "/theta": "\u03B8",
    "/theta.math": "\u03D1",
    "/theta1": "\u03D1",
    "/thetasymbolgreek": "\u03D1",
    "/thieuthacirclekorean": "\u3279",
    "/thieuthaparenkorean": "\u3219",
    "/thieuthcirclekorean": "\u326B",
    "/thieuthkorean": "\u314C",
    "/thieuthparenkorean": "\u320B",
    "/thinspace": "\u2009",
    "/thirteencircle": "\u246C",
    "/thirteencircleblack": "\u24ED",
    "/thirteenparen": "\u2480",
    "/thirteenparenthesized": "\u2480",
    "/thirteenperiod": "\u2494",
    "/thirtycircle": "\u325A",
    "/thirtycirclesquare": "\u324A",
    "/thirtyeightcircle": "\u32B3",
    "/thirtyfivecircle": "\u325F",
    "/thirtyfourcircle": "\u325E",
    "/thirtyhangzhou": "\u303A",
    "/thirtyninecircle": "\u32B4",
    "/thirtyonecircle": "\u325B",
    "/thirtysevencircle": "\u32B2",
    "/thirtysixcircle": "\u32B1",
    "/thirtythreecircle": "\u325D",
    "/thirtytwocircle": "\u325C",
    "/thonangmonthothai": "\u0E11",
    "/thook": "\u01AD",
    "/thophuthaothai": "\u0E12",
    "/thorn": "\u00FE",
    "/thornstroke": "\uA765",
    "/thornstrokedescender": "\uA767",
    "/thothahanthai": "\u0E17",
    "/thothanthai": "\u0E10",
    "/thothongthai": "\u0E18",
    "/thothungthai": "\u0E16",
    "/thoughtBalloon": "\u1F4AD",
    "/thousandcyrillic": "\u0482",
    "/thousandscyr": "\u0482",
    "/thousandsseparator": "\u066C",
    "/thousandsseparatorarabic": "\u066C",
    "/thousandsseparatorpersian": "\u066C",
    "/three": "\u0033",
    "/three.inferior": "\u2083",
    "/three.roman": "\u2162",
    "/three.romansmall": "\u2172",
    "/threeButtonMouse": "\u1F5B1",
    "/threeNetworkedComputers": "\u1F5A7",
    "/threeRaysAbove": "\u1F5E4",
    "/threeRaysBelow": "\u1F5E5",
    "/threeRaysLeft": "\u1F5E6",
    "/threeRaysRight": "\u1F5E7",
    "/threeSpeechBubbles": "\u1F5EB",
    "/threearabic": "\u0663",
    "/threebengali": "\u09E9",
    "/threecircle": "\u2462",
    "/threecircledbl": "\u24F7",
    "/threecircleinversesansserif": "\u278C",
    "/threecomma": "\u1F104",
    "/threedeva": "\u0969",
    "/threedimensionalangle": "\u27C0",
    "/threedotpunctuation": "\u2056",
    "/threedotsaboveabove": "\u06DB",
    "/threedsquare": "\u1F19B",
    "/threeeighths": "\u215C",
    "/threefar": "\u06F3",
    "/threefifths": "\u2157",
    "/threegujarati": "\u0AE9",
    "/threegurmukhi": "\u0A69",
    "/threehackarabic": "\u0663",
    "/threehangzhou": "\u3023",
    "/threeideographiccircled": "\u3282",
    "/threeideographicparen": "\u3222",
    "/threeinferior": "\u2083",
    "/threelinesconvergingleft": "\u269F",
    "/threelinesconvergingright": "\u269E",
    "/threemonospace": "\uFF13",
    "/threenumeratorbengali": "\u09F6",
    "/threeoldstyle": "\uF733",
    "/threeparen": "\u2476",
    "/threeparenthesized": "\u2476",
    "/threeperemspace": "\u2004",
    "/threeperiod": "\u248A",
    "/threepersian": "\u06F3",
    "/threequarters": "\u00BE",
    "/threequartersemdash": "\uF6DE",
    "/threerightarrows": "\u21F6",
    "/threeroman": "\u2172",
    "/threesuperior": "\u00B3",
    "/threethai": "\u0E53",
    "/thumbsDownSign": "\u1F44E",
    "/thumbsUpSign": "\u1F44D",
    "/thundercloudrain": "\u26C8",
    "/thunderstorm": "\u2608",
    "/thzfullwidth": "\u3394",
    "/thzsquare": "\u3394",
    "/tibt:AA": "\u0F60",
    "/tibt:a": "\u0F68",
    "/tibt:aavowelsign": "\u0F71",
    "/tibt:angkhanggyasmark": "\u0F3D",
    "/tibt:angkhanggyonmark": "\u0F3C",
    "/tibt:astrologicalkhyudpasign": "\u0F18",
    "/tibt:astrologicalsdongtshugssign": "\u0F19",
    "/tibt:astrologicalsgragcancharrtagssign": "\u0F17",
    "/tibt:asubjoined": "\u0FB8",
    "/tibt:ba": "\u0F56",
    "/tibt:basubjoined": "\u0FA6",
    "/tibt:bha": "\u0F57",
    "/tibt:bhasubjoined": "\u0FA7",
    "/tibt:bkashogyigmgomark": "\u0F0A",
    "/tibt:brdarnyingyigmgomdunmainitialmark": "\u0FD3",
    "/tibt:brdarnyingyigmgosgabmaclosingmark": "\u0FD4",
    "/tibt:bsdusrtagsmark": "\u0F34",
    "/tibt:bskashoggimgorgyanmark": "\u0FD0",
    "/tibt:bskuryigmgomark": "\u0F09",
    "/tibt:ca": "\u0F45",
    "/tibt:cangteucantillationsign": "\u0FC2",
    "/tibt:caretdzudrtagsbzhimigcanmark": "\u0F36",
    "/tibt:caretdzudrtagsmelongcanmark": "\u0F13",
    "/tibt:caretyigmgophurshadmamark": "\u0F06",
    "/tibt:casubjoined": "\u0F95",
    "/tibt:cha": "\u0F46",
    "/tibt:chadrtagslogotypesign": "\u0F15",
    "/tibt:chasubjoined": "\u0F96",
    "/tibt:chemgomark": "\u0F38",
    "/tibt:da": "\u0F51",
    "/tibt:dasubjoined": "\u0FA1",
    "/tibt:dda": "\u0F4C",
    "/tibt:ddasubjoined": "\u0F9C",
    "/tibt:ddha": "\u0F4D",
    "/tibt:ddhasubjoined": "\u0F9D",
    "/tibt:delimitertshegbstarmark": "\u0F0C",
    "/tibt:dha": "\u0F52",
    "/tibt:dhasubjoined": "\u0FA2",
    "/tibt:drilbusymbol": "\u0FC4",
    "/tibt:dza": "\u0F5B",
    "/tibt:dzasubjoined": "\u0FAB",
    "/tibt:dzha": "\u0F5C",
    "/tibt:dzhasubjoined": "\u0FAC",
    "/tibt:eevowelsign": "\u0F7B",
    "/tibt:eight": "\u0F28",
    "/tibt:evowelsign": "\u0F7A",
    "/tibt:five": "\u0F25",
    "/tibt:four": "\u0F24",
    "/tibt:ga": "\u0F42",
    "/tibt:gasubjoined": "\u0F92",
    "/tibt:gha": "\u0F43",
    "/tibt:ghasubjoined": "\u0F93",
    "/tibt:grucanrgyingssign": "\u0F8A",
    "/tibt:grumedrgyingssign": "\u0F8B",
    "/tibt:gtertshegmark": "\u0F14",
    "/tibt:gteryigmgotruncatedamark": "\u0F01",
    "/tibt:gteryigmgoumgtertshegmamark": "\u0F03",
    "/tibt:gteryigmgoumrnambcadmamark": "\u0F02",
    "/tibt:gugrtagsgyasmark": "\u0F3B",
    "/tibt:gugrtagsgyonmark": "\u0F3A",
    "/tibt:ha": "\u0F67",
    "/tibt:halantamark": "\u0F84",
    "/tibt:halfeight": "\u0F31",
    "/tibt:halffive": "\u0F2E",
    "/tibt:halffour": "\u0F2D",
    "/tibt:halfnine": "\u0F32",
    "/tibt:halfone": "\u0F2A",
    "/tibt:halfseven": "\u0F30",
    "/tibt:halfsix": "\u0F2F",
    "/tibt:halfthree": "\u0F2C",
    "/tibt:halftwo": "\u0F2B",
    "/tibt:halfzero": "\u0F33",
    "/tibt:hasubjoined": "\u0FB7",
    "/tibt:heavybeatcantillationsign": "\u0FC0",
    "/tibt:iivowelsign": "\u0F73",
    "/tibt:intersyllabictshegmark": "\u0F0B",
    "/tibt:invertedmchucansign": "\u0F8C",
    "/tibt:invertedmchucansubjoinedsign": "\u0F8F",
    "/tibt:ivowelsign": "\u0F72",
    "/tibt:ja": "\u0F47",
    "/tibt:jasubjoined": "\u0F97",
    "/tibt:ka": "\u0F40",
    "/tibt:kasubjoined": "\u0F90",
    "/tibt:kha": "\u0F41",
    "/tibt:khasubjoined": "\u0F91",
    "/tibt:kka": "\u0F6B",
    "/tibt:kssa": "\u0F69",
    "/tibt:kssasubjoined": "\u0FB9",
    "/tibt:kurukha": "\u0FBE",
    "/tibt:kurukhabzhimigcan": "\u0FBF",
    "/tibt:la": "\u0F63",
    "/tibt:lasubjoined": "\u0FB3",
    "/tibt:lcetsacansign": "\u0F88",
    "/tibt:lcetsacansubjoinedsign": "\u0F8D",
    "/tibt:lcirtagssign": "\u0F86",
    "/tibt:leadingmchanrtagsmark": "\u0FD9",
    "/tibt:lhagrtagslogotypesign": "\u0F16",
    "/tibt:lightbeatcantillationsign": "\u0FC1",
    "/tibt:llvocalicvowelsign": "\u0F79",
    "/tibt:lvocalicvowelsign": "\u0F78",
    "/tibt:ma": "\u0F58",
    "/tibt:martshessign": "\u0F3F",
    "/tibt:masubjoined": "\u0FA8",
    "/tibt:mchucansign": "\u0F89",
    "/tibt:mchucansubjoinedsign": "\u0F8E",
    "/tibt:mnyamyiggimgorgyanmark": "\u0FD1",
    "/tibt:na": "\u0F53",
    "/tibt:nasubjoined": "\u0FA3",
    "/tibt:nga": "\u0F44",
    "/tibt:ngasbzungnyizlamark": "\u0F35",
    "/tibt:ngasbzungsgorrtagsmark": "\u0F37",
    "/tibt:ngasubjoined": "\u0F94",
    "/tibt:nine": "\u0F29",
    "/tibt:nna": "\u0F4E",
    "/tibt:nnasubjoined": "\u0F9E",
    "/tibt:norbubzhikhyilsymbol": "\u0FCC",
    "/tibt:norbugsumkhyilsymbol": "\u0FCB",
    "/tibt:norbunyiskhyilsymbol": "\u0FCA",
    "/tibt:norbusymbol": "\u0FC9",
    "/tibt:nya": "\u0F49",
    "/tibt:nyasubjoined": "\u0F99",
    "/tibt:nyisshadmark": "\u0F0E",
    "/tibt:nyistshegmark": "\u0FD2",
    "/tibt:nyistshegshadmark": "\u0F10",
    "/tibt:nyizlanaadasign": "\u0F82",
    "/tibt:omsyllable": "\u0F00",
    "/tibt:one": "\u0F21",
    "/tibt:oovowelsign": "\u0F7D",
    "/tibt:ovowelsign": "\u0F7C",
    "/tibt:pa": "\u0F54",
    "/tibt:padmagdansymbol": "\u0FC6",
    "/tibt:palutamark": "\u0F85",
    "/tibt:pasubjoined": "\u0FA4",
    "/tibt:pha": "\u0F55",
    "/tibt:phasubjoined": "\u0FA5",
    "/tibt:phurpasymbol": "\u0FC8",
    "/tibt:ra": "\u0F62",
    "/tibt:rafixed": "\u0F6A",
    "/tibt:rasubjoined": "\u0FB2",
    "/tibt:rasubjoinedfixed": "\u0FBC",
    "/tibt:rdeldkargcigsign": "\u0F1A",
    "/tibt:rdeldkargnyissign": "\u0F1B",
    "/tibt:rdeldkargsumsign": "\u0F1C",
    "/tibt:rdeldkarrdelnagsign": "\u0F1F",
    "/tibt:rdelnaggcigsign": "\u0F1D",
    "/tibt:rdelnaggnyissign": "\u0F1E",
    "/tibt:rdelnaggsumsign": "\u0FCF",
    "/tibt:rdelnagrdeldkarsign": "\u0FCE",
    "/tibt:rdorjergyagramsymbol": "\u0FC7",
    "/tibt:rdorjesymbol": "\u0FC5",
    "/tibt:reversediivowelsign": "\u0F81",
    "/tibt:reversedivowelsign": "\u0F80",
    "/tibt:rgyagramshadmark": "\u0F12",
    "/tibt:rinchenspungsshadmark": "\u0F11",
    "/tibt:rjessungarosign": "\u0F7E",
    "/tibt:rnambcadsign": "\u0F7F",
    "/tibt:rra": "\u0F6C",
    "/tibt:rrvocalicvowelsign": "\u0F77",
    "/tibt:rvocalicvowelsign": "\u0F76",
    "/tibt:sa": "\u0F66",
    "/tibt:sasubjoined": "\u0FB6",
    "/tibt:sbrulshadmark": "\u0F08",
    "/tibt:sbubchalcantillationsign": "\u0FC3",
    "/tibt:seven": "\u0F27",
    "/tibt:sha": "\u0F64",
    "/tibt:shadmark": "\u0F0D",
    "/tibt:shasubjoined": "\u0FB4",
    "/tibt:six": "\u0F26",
    "/tibt:snaldansign": "\u0F83",
    "/tibt:ssa": "\u0F65",
    "/tibt:ssasubjoined": "\u0FB5",
    "/tibt:subjoinedAA": "\u0FB0",
    "/tibt:svastileft": "\u0FD6",
    "/tibt:svastileftdot": "\u0FD8",
    "/tibt:svastiright": "\u0FD5",
    "/tibt:svastirightdot": "\u0FD7",
    "/tibt:ta": "\u0F4F",
    "/tibt:tasubjoined": "\u0F9F",
    "/tibt:tha": "\u0F50",
    "/tibt:thasubjoined": "\u0FA0",
    "/tibt:three": "\u0F23",
    "/tibt:trailingmchanrtagsmark": "\u0FDA",
    "/tibt:tsa": "\u0F59",
    "/tibt:tsaphrumark": "\u0F39",
    "/tibt:tsasubjoined": "\u0FA9",
    "/tibt:tsha": "\u0F5A",
    "/tibt:tshasubjoined": "\u0FAA",
    "/tibt:tshegshadmark": "\u0F0F",
    "/tibt:tta": "\u0F4A",
    "/tibt:ttasubjoined": "\u0F9A",
    "/tibt:ttha": "\u0F4B",
    "/tibt:tthasubjoined": "\u0F9B",
    "/tibt:two": "\u0F22",
    "/tibt:uuvowelsign": "\u0F75",
    "/tibt:uvowelsign": "\u0F74",
    "/tibt:wa": "\u0F5D",
    "/tibt:wasubjoined": "\u0FAD",
    "/tibt:wasubjoinedfixed": "\u0FBA",
    "/tibt:ya": "\u0F61",
    "/tibt:yangrtagssign": "\u0F87",
    "/tibt:yartshessign": "\u0F3E",
    "/tibt:yasubjoined": "\u0FB1",
    "/tibt:yasubjoinedfixed": "\u0FBB",
    "/tibt:yigmgomdunmainitialmark": "\u0F04",
    "/tibt:yigmgosgabmaclosingmark": "\u0F05",
    "/tibt:yigmgotshegshadmamark": "\u0F07",
    "/tibt:za": "\u0F5F",
    "/tibt:zasubjoined": "\u0FAF",
    "/tibt:zero": "\u0F20",
    "/tibt:zha": "\u0F5E",
    "/tibt:zhasubjoined": "\u0FAE",
    "/ticirclekatakana": "\u32E0",
    "/tickconvavediamondleftwhite": "\u27E2",
    "/tickconvavediamondrightwhite": "\u27E3",
    "/ticket": "\u1F3AB",
    "/tickleftwhitesquare": "\u27E4",
    "/tickrightwhitesquare": "\u27E5",
    "/tifcha:hb": "\u0596",
    "/tiger": "\u1F405",
    "/tigerFace": "\u1F42F",
    "/tihiragana": "\u3061",
    "/tikatakana": "\u30C1",
    "/tikatakanahalfwidth": "\uFF81",
    "/tikeutacirclekorean": "\u3270",
    "/tikeutaparenkorean": "\u3210",
    "/tikeutcirclekorean": "\u3262",
    "/tikeutkorean": "\u3137",
    "/tikeutparenkorean": "\u3202",
    "/tilde": "\u02DC",
    "/tildebelowcmb": "\u0330",
    "/tildecmb": "\u0303",
    "/tildecomb": "\u0303",
    "/tildediaeresisfunc": "\u2368",
    "/tildedotaccent": "\u2E1E",
    "/tildedotbelow": "\u2E1F",
    "/tildedoublecmb": "\u0360",
    "/tildeequalsreversed": "\u22CD",
    "/tildelowmod": "\u02F7",
    "/tildeoperator": "\u223C",
    "/tildeoverlaycmb": "\u0334",
    "/tildereversed": "\u223D",
    "/tildering": "\u2E1B",
    "/tildetpl": "\u224B",
    "/tildeverticalcmb": "\u033E",
    "/timerclock": "\u23F2",
    "/timescircle": "\u2297",
    "/tinsular": "\uA787",
    "/tipehahebrew": "\u0596",
    "/tipehalefthebrew": "\u0596",
    "/tippigurmukhi": "\u0A70",
    "/tiredFace": "\u1F62B",
    "/tironiansignet": "\u204A",
    "/tirtatumetespada": "\uA9DE",
    "/titlocmbcyr": "\u0483",
    "/titlocyrilliccmb": "\u0483",
    "/tiwnarmenian": "\u057F",
    "/tjekomicyr": "\u050F",
    "/tlinebelow": "\u1E6F",
    "/tmonospace": "\uFF54",
    "/toarmenian": "\u0569",
    "/tocirclekatakana": "\u32E3",
    "/tocornerarrowNW": "\u21F1",
    "/tocornerarrowSE": "\u21F2",
    "/tohiragana": "\u3068",
    "/toilet": "\u1F6BD",
    "/tokatakana": "\u30C8",
    "/tokatakanahalfwidth": "\uFF84",
    "/tokyoTower": "\u1F5FC",
    "/tolongvowel": "\uA9B5",
    "/tomato": "\u1F345",
    "/tonebarextrahighmod": "\u02E5",
    "/tonebarextralowmod": "\u02E9",
    "/tonebarhighmod": "\u02E6",
    "/tonebarlowmod": "\u02E8",
    "/tonebarmidmod": "\u02E7",
    "/tonefive": "\u01BD",
    "/tonehighbeginmod": "\u02F9",
    "/tonehighendmod": "\u02FA",
    "/tonelowbeginmod": "\u02FB",
    "/tonelowendmod": "\u02FC",
    "/tonesix": "\u0185",
    "/tonetwo": "\u01A8",
    "/tongue": "\u1F445",
    "/tonos": "\u0384",
    "/tonsquare": "\u3327",
    "/topHat": "\u1F3A9",
    "/topUpwardsArrowAbove": "\u1F51D",
    "/topatakthai": "\u0E0F",
    "/tortoiseshellbracketleft": "\u3014",
    "/tortoiseshellbracketleftsmall": "\uFE5D",
    "/tortoiseshellbracketleftvertical": "\uFE39",
    "/tortoiseshellbracketright": "\u3015",
    "/tortoiseshellbracketrightsmall": "\uFE5E",
    "/tortoiseshellbracketrightvertical": "\uFE3A",
    "/totalrunout": "\u2330",
    "/totaothai": "\u0E15",
    "/tpalatalhook": "\u01AB",
    "/tparen": "\u24AF",
    "/tparenthesized": "\u24AF",
    "/trackball": "\u1F5B2",
    "/tractor": "\u1F69C",
    "/trademark": "\u2122",
    "/trademarksans": "\uF8EA",
    "/trademarkserif": "\uF6DB",
    "/train": "\u1F686",
    "/tram": "\u1F68A",
    "/tramCar": "\u1F68B",
    "/trapeziumwhite": "\u23E2",
    "/tresillo": "\uA72B",
    "/tretroflex": "\u0288",
    "/tretroflexhook": "\u0288",
    "/triagdn": "\u25BC",
    "/triaglf": "\u25C4",
    "/triagrt": "\u25BA",
    "/triagup": "\u25B2",
    "/triangleWithRoundedCorners": "\u1F6C6",
    "/triangledotupwhite": "\u25EC",
    "/triangledownblack": "\u25BC",
    "/triangledownsmallblack": "\u25BE",
    "/triangledownsmallwhite": "\u25BF",
    "/triangledownwhite": "\u25BD",
    "/trianglehalfupleftblack": "\u25ED",
    "/trianglehalfuprightblack": "\u25EE",
    "/triangleleftblack": "\u25C0",
    "/triangleleftsmallblack": "\u25C2",
    "/triangleleftsmallwhite": "\u25C3",
    "/triangleleftwhite": "\u25C1",
    "/triangleright": "\u22BF",
    "/trianglerightblack": "\u25B6",
    "/trianglerightsmallblack": "\u25B8",
    "/trianglerightsmallwhite": "\u25B9",
    "/trianglerightwhite": "\u25B7",
    "/triangleupblack": "\u25B2",
    "/triangleupsmallblack": "\u25B4",
    "/triangleupsmallwhite": "\u25B5",
    "/triangleupwhite": "\u25B3",
    "/triangularFlagOnPost": "\u1F6A9",
    "/triangularRuler": "\u1F4D0",
    "/triangularbullet": "\u2023",
    "/tricolon": "\u205D",
    "/tricontainingtriwhiteanglesmall": "\u27C1",
    "/tridentEmblem": "\u1F531",
    "/trigramearth": "\u2637",
    "/trigramfire": "\u2632",
    "/trigramheaven": "\u2630",
    "/trigramlake": "\u2631",
    "/trigrammountain": "\u2636",
    "/trigramthunder": "\u2633",
    "/trigramwater": "\u2635",
    "/trigramwind": "\u2634",
    "/triplearrowleft": "\u21DA",
    "/triplearrowright": "\u21DB",
    "/tripledot": "\u061E",
    "/trisememetrical": "\u23D7",
    "/trns:baby": "\u1F6BC",
    "/trolleybus": "\u1F68E",
    "/trophy": "\u1F3C6",
    "/tropicalDrink": "\u1F379",
    "/tropicalFish": "\u1F420",
    "/truckblack": "\u26DF",
    "/true": "\u22A8",
    "/trumpet": "\u1F3BA",
    "/ts": "\u02A6",
    "/tsadi": "\u05E6",
    "/tsadi:hb": "\u05E6",
    "/tsadidagesh": "\uFB46",
    "/tsadidageshhebrew": "\uFB46",
    "/tsadihebrew": "\u05E6",
    "/tsadiwithdagesh:hb": "\uFB46",
    "/tsecyr": "\u0446",
    "/tsecyrillic": "\u0446",
    "/tsere": "\u05B5",
    "/tsere12": "\u05B5",
    "/tsere1e": "\u05B5",
    "/tsere2b": "\u05B5",
    "/tsere:hb": "\u05B5",
    "/tserehebrew": "\u05B5",
    "/tserenarrowhebrew": "\u05B5",
    "/tserequarterhebrew": "\u05B5",
    "/tserewidehebrew": "\u05B5",
    "/tshecyr": "\u045B",
    "/tshecyrillic": "\u045B",
    "/tsinnorit:hb": "\u05AE",
    "/tstroke": "\u2C66",
    "/tsuperior": "\uF6F3",
    "/ttabengali": "\u099F",
    "/ttadeva": "\u091F",
    "/ttagujarati": "\u0A9F",
    "/ttagurmukhi": "\u0A1F",
    "/ttamahaprana": "\uA99C",
    "/tteh": "\u0679",
    "/tteh.fina": "\uFB67",
    "/tteh.init": "\uFB68",
    "/tteh.isol": "\uFB66",
    "/tteh.medi": "\uFB69",
    "/tteharabic": "\u0679",
    "/tteheh": "\u067A",
    "/tteheh.fina": "\uFB5F",
    "/tteheh.init": "\uFB60",
    "/tteheh.isol": "\uFB5E",
    "/tteheh.medi": "\uFB61",
    "/ttehfinalarabic": "\uFB67",
    "/ttehinitialarabic": "\uFB68",
    "/ttehmedialarabic": "\uFB69",
    "/tthabengali": "\u09A0",
    "/tthadeva": "\u0920",
    "/tthagujarati": "\u0AA0",
    "/tthagurmukhi": "\u0A20",
    "/tturned": "\u0287",
    "/tucirclekatakana": "\u32E1",
    "/tugrik": "\u20AE",
    "/tuhiragana": "\u3064",
    "/tukatakana": "\u30C4",
    "/tukatakanahalfwidth": "\uFF82",
    "/tulip": "\u1F337",
    "/tum": "\uA777",
    "/turkishlira": "\u20BA",
    "/turnedOkHandSign": "\u1F58F",
    "/turnedcomma": "\u2E32",
    "/turneddagger": "\u2E38",
    "/turneddigitthree": "\u218B",
    "/turneddigittwo": "\u218A",
    "/turnedpiselehpada": "\uA9CD",
    "/turnedsemicolon": "\u2E35",
    "/turnedshogipieceblack": "\u26CA",
    "/turnedshogipiecewhite": "\u26C9",
    "/turnstiledblverticalbarright": "\u22AB",
    "/turnstileleftrightdbl": "\u27DA",
    "/turnstiletplverticalbarright": "\u22AA",
    "/turtle": "\u1F422",
    "/tusmallhiragana": "\u3063",
    "/tusmallkatakana": "\u30C3",
    "/tusmallkatakanahalfwidth": "\uFF6F",
    "/twelve.roman": "\u216B",
    "/twelve.romansmall": "\u217B",
    "/twelvecircle": "\u246B",
    "/twelvecircleblack": "\u24EC",
    "/twelveparen": "\u247F",
    "/twelveparenthesized": "\u247F",
    "/twelveperiod": "\u2493",
    "/twelveroman": "\u217B",
    "/twenty-twopointtwosquare": "\u1F1A2",
    "/twentycircle": "\u2473",
    "/twentycircleblack": "\u24F4",
    "/twentycirclesquare": "\u3249",
    "/twentyeightcircle": "\u3258",
    "/twentyfivecircle": "\u3255",
    "/twentyfourcircle": "\u3254",
    "/twentyhangzhou": "\u5344",
    "/twentyninecircle": "\u3259",
    "/twentyonecircle": "\u3251",
    "/twentyparen": "\u2487",
    "/twentyparenthesized": "\u2487",
    "/twentyperiod": "\u249B",
    "/twentysevencircle": "\u3257",
    "/twentysixcircle": "\u3256",
    "/twentythreecircle": "\u3253",
    "/twentytwocircle": "\u3252",
    "/twistedRightwardsArrows": "\u1F500",
    "/two": "\u0032",
    "/two.inferior": "\u2082",
    "/two.roman": "\u2161",
    "/two.romansmall": "\u2171",
    "/twoButtonMouse": "\u1F5B0",
    "/twoHearts": "\u1F495",
    "/twoMenHoldingHands": "\u1F46C",
    "/twoSpeechBubbles": "\u1F5EA",
    "/twoWomenHoldingHands": "\u1F46D",
    "/twoarabic": "\u0662",
    "/twoasterisksalignedvertically": "\u2051",
    "/twobengali": "\u09E8",
    "/twocircle": "\u2461",
    "/twocircledbl": "\u24F6",
    "/twocircleinversesansserif": "\u278B",
    "/twocomma": "\u1F103",
    "/twodeva": "\u0968",
    "/twodotenleader": "\u2025",
    "/twodotleader": "\u2025",
    "/twodotleadervertical": "\uFE30",
    "/twodotpunctuation": "\u205A",
    "/twodotsoveronedot": "\u2E2A",
    "/twofar": "\u06F2",
    "/twofifths": "\u2156",
    "/twogujarati": "\u0AE8",
    "/twogurmukhi": "\u0A68",
    "/twohackarabic": "\u0662",
    "/twohangzhou": "\u3022",
    "/twoideographiccircled": "\u3281",
    "/twoideographicparen": "\u3221",
    "/twoinferior": "\u2082",
    "/twoksquare": "\u1F19D",
    "/twomonospace": "\uFF12",
    "/twonumeratorbengali": "\u09F5",
    "/twooldstyle": "\uF732",
    "/twoparen": "\u2475",
    "/twoparenthesized": "\u2475",
    "/twoperiod": "\u2489",
    "/twopersian": "\u06F2",
    "/tworoman": "\u2171",
    "/twoshortsjoinedmetrical": "\u23D6",
    "/twoshortsoverlongmetrical": "\u23D5",
    "/twostroke": "\u01BB",
    "/twosuperior": "\u00B2",
    "/twothai": "\u0E52",
    "/twothirds": "\u2154",
    "/twowayleftwaytrafficblack": "\u26D6",
    "/twowayleftwaytrafficwhite": "\u26D7",
    "/tz": "\uA729",
    "/u": "\u0075",
    "/u.fina": "\uFBD8",
    "/u.isol": "\uFBD7",
    "/uacute": "\u00FA",
    "/uacutedblcyr": "\u04F3",
    "/ubar": "\u0289",
    "/ubengali": "\u0989",
    "/ubopomofo": "\u3128",
    "/ubracketleft": "\u2E26",
    "/ubracketright": "\u2E27",
    "/ubreve": "\u016D",
    "/ucaron": "\u01D4",
    "/ucircle": "\u24E4",
    "/ucirclekatakana": "\u32D2",
    "/ucircumflex": "\u00FB",
    "/ucircumflexbelow": "\u1E77",
    "/ucyr": "\u0443",
    "/ucyrillic": "\u0443",
    "/udattadeva": "\u0951",
    "/udblacute": "\u0171",
    "/udblgrave": "\u0215",
    "/udeva": "\u0909",
    "/udieresis": "\u00FC",
    "/udieresisacute": "\u01D8",
    "/udieresisbelow": "\u1E73",
    "/udieresiscaron": "\u01DA",
    "/udieresiscyr": "\u04F1",
    "/udieresiscyrillic": "\u04F1",
    "/udieresisgrave": "\u01DC",
    "/udieresismacron": "\u01D6",
    "/udotbelow": "\u1EE5",
    "/ugrave": "\u00F9",
    "/ugravedbl": "\u0215",
    "/ugujarati": "\u0A89",
    "/ugurmukhi": "\u0A09",
    "/uhamza": "\u0677",
    "/uhamza.isol": "\uFBDD",
    "/uhdsquare": "\u1F1AB",
    "/uhiragana": "\u3046",
    "/uhoi": "\u1EE7",
    "/uhookabove": "\u1EE7",
    "/uhorn": "\u01B0",
    "/uhornacute": "\u1EE9",
    "/uhorndotbelow": "\u1EF1",
    "/uhorngrave": "\u1EEB",
    "/uhornhoi": "\u1EED",
    "/uhornhookabove": "\u1EED",
    "/uhorntilde": "\u1EEF",
    "/uhungarumlaut": "\u0171",
    "/uhungarumlautcyrillic": "\u04F3",
    "/uighurkazakhkirghizalefmaksura.init": "\uFBE8",
    "/uighurkazakhkirghizalefmaksura.medi": "\uFBE9",
    "/uighurkirghizyeh.init_hamzaabove.medi_alefmaksura.fina": "\uFBF9",
    "/uighurkirghizyeh.init_hamzaabove.medi_alefmaksura.medi": "\uFBFB",
    "/uighurkirghizyeh.medi_hamzaabove.medi_alefmaksura.fina": "\uFBFA",
    "/uinvertedbreve": "\u0217",
    "/ukatakana": "\u30A6",
    "/ukatakanahalfwidth": "\uFF73",
    "/ukcyr": "\u0479",
    "/ukcyrillic": "\u0479",
    "/ukorean": "\u315C",
    "/um": "\uA778",
    "/umacron": "\u016B",
    "/umacroncyr": "\u04EF",
    "/umacroncyrillic": "\u04EF",
    "/umacrondieresis": "\u1E7B",
    "/umatragurmukhi": "\u0A41",
    "/umbrella": "\u2602",
    "/umbrellaonground": "\u26F1",
    "/umbrellaraindrops": "\u2614",
    "/umonospace": "\uFF55",
    "/unamusedFace": "\u1F612",
    "/unaspiratedmod": "\u02ED",
    "/underscore": "\u005F",
    "/underscorecenterline": "\uFE4E",
    "/underscoredashed": "\uFE4D",
    "/underscoredbl": "\u2017",
    "/underscoremonospace": "\uFF3F",
    "/underscorevertical": "\uFE33",
    "/underscorewavy": "\uFE4F",
    "/underscorewavyvertical": "\uFE34",
    "/undertie": "\u203F",
    "/undo": "\u238C",
    "/union": "\u222A",
    "/unionarray": "\u22C3",
    "/uniondbl": "\u22D3",
    "/universal": "\u2200",
    "/unmarriedpartnership": "\u26AF",
    "/uogonek": "\u0173",
    "/uonsquare": "\u3306",
    "/upPointingAirplane": "\u1F6E7",
    "/upPointingMilitaryAirplane": "\u1F6E6",
    "/upPointingSmallAirplane": "\u1F6E8",
    "/uparen": "\u24B0",
    "/uparenthesized": "\u24B0",
    "/uparrowleftofdownarrow": "\u21C5",
    "/upblock": "\u2580",
    "/updblhorzsng": "\u2568",
    "/updblleftsng": "\u255C",
    "/updblrightsng": "\u2559",
    "/upheavydnhorzlight": "\u2540",
    "/upheavyhorzlight": "\u2538",
    "/upheavyleftdnlight": "\u2526",
    "/upheavyleftlight": "\u251A",
    "/upheavyrightdnlight": "\u251E",
    "/upheavyrightlight": "\u2516",
    "/uplightdnhorzheavy": "\u2548",
    "/uplighthorzheavy": "\u2537",
    "/uplightleftdnheavy": "\u252A",
    "/uplightleftheavy": "\u2519",
    "/uplightrightdnheavy": "\u2522",
    "/uplightrightheavy": "\u2515",
    "/upperHalfBlock": "\u2580",
    "/upperOneEighthBlock": "\u2594",
    "/upperRightShadowedWhiteCircle": "\u1F53F",
    "/upperdothebrew": "\u05C4",
    "/upperhalfcircle": "\u25E0",
    "/upperhalfcircleinversewhite": "\u25DA",
    "/upperquadrantcirculararcleft": "\u25DC",
    "/upperquadrantcirculararcright": "\u25DD",
    "/uppertriangleleft": "\u25F8",
    "/uppertriangleleftblack": "\u25E4",
    "/uppertriangleright": "\u25F9",
    "/uppertrianglerightblack": "\u25E5",
    "/upsideDownFace": "\u1F643",
    "/upsilon": "\u03C5",
    "/upsilonacute": "\u1F7B",
    "/upsilonasper": "\u1F51",
    "/upsilonasperacute": "\u1F55",
    "/upsilonaspergrave": "\u1F53",
    "/upsilonaspertilde": "\u1F57",
    "/upsilonbreve": "\u1FE0",
    "/upsilondieresis": "\u03CB",
    "/upsilondieresisacute": "\u1FE3",
    "/upsilondieresisgrave": "\u1FE2",
    "/upsilondieresistilde": "\u1FE7",
    "/upsilondieresistonos": "\u03B0",
    "/upsilongrave": "\u1F7A",
    "/upsilonlatin": "\u028A",
    "/upsilonlenis": "\u1F50",
    "/upsilonlenisacute": "\u1F54",
    "/upsilonlenisgrave": "\u1F52",
    "/upsilonlenistilde": "\u1F56",
    "/upsilontilde": "\u1FE6",
    "/upsilontonos": "\u03CD",
    "/upsilonwithmacron": "\u1FE1",
    "/upsnghorzdbl": "\u2567",
    "/upsngleftdbl": "\u255B",
    "/upsngrightdbl": "\u2558",
    "/uptackbelowcmb": "\u031D",
    "/uptackmod": "\u02D4",
    "/upwithexclamationmarksquare": "\u1F199",
    "/uragurmukhi": "\u0A73",
    "/uranus": "\u2645",
    "/uring": "\u016F",
    "/ushortcyr": "\u045E",
    "/ushortcyrillic": "\u045E",
    "/usmallhiragana": "\u3045",
    "/usmallkatakana": "\u30A5",
    "/usmallkatakanahalfwidth": "\uFF69",
    "/usmod": "\uA770",
    "/ustraightcyr": "\u04AF",
    "/ustraightcyrillic": "\u04AF",
    "/ustraightstrokecyr": "\u04B1",
    "/ustraightstrokecyrillic": "\u04B1",
    "/utilde": "\u0169",
    "/utildeacute": "\u1E79",
    "/utildebelow": "\u1E75",
    "/uubengali": "\u098A",
    "/uudeva": "\u090A",
    "/uugujarati": "\u0A8A",
    "/uugurmukhi": "\u0A0A",
    "/uumatragurmukhi": "\u0A42",
    "/uuvowelsignbengali": "\u09C2",
    "/uuvowelsigndeva": "\u0942",
    "/uuvowelsigngujarati": "\u0AC2",
    "/uvowelsignbengali": "\u09C1",
    "/uvowelsigndeva": "\u0941",
    "/uvowelsigngujarati": "\u0AC1",
    "/v": "\u0076",
    "/vadeva": "\u0935",
    "/vagujarati": "\u0AB5",
    "/vagurmukhi": "\u0A35",
    "/vakatakana": "\u30F7",
    "/vanedownfunc": "\u2356",
    "/vaneleftfunc": "\u2345",
    "/vanerightfunc": "\u2346",
    "/vaneupfunc": "\u234F",
    "/varikajudeospanish:hb": "\uFB1E",
    "/vav": "\u05D5",
    "/vav:hb": "\u05D5",
    "/vav_vav:hb": "\u05F0",
    "/vav_yod:hb": "\u05F1",
    "/vavdagesh": "\uFB35",
    "/vavdagesh65": "\uFB35",
    "/vavdageshhebrew": "\uFB35",
    "/vavhebrew": "\u05D5",
    "/vavholam": "\uFB4B",
    "/vavholamhebrew": "\uFB4B",
    "/vavvavhebrew": "\u05F0",
    "/vavwithdagesh:hb": "\uFB35",
    "/vavwithholam:hb": "\uFB4B",
    "/vavyodhebrew": "\u05F1",
    "/vcircle": "\u24E5",
    "/vcurl": "\u2C74",
    "/vdiagonalstroke": "\uA75F",
    "/vdotbelow": "\u1E7F",
    "/ve.fina": "\uFBDF",
    "/ve.isol": "\uFBDE",
    "/ve:abovetonecandra": "\u1CF4",
    "/ve:anusvaraantargomukhasign": "\u1CE9",
    "/ve:anusvarabahirgomukhasign": "\u1CEA",
    "/ve:anusvarasignlong": "\u1CEF",
    "/ve:anusvaraubhayatomukhasign": "\u1CF1",
    "/ve:anusvaravamagomukhasign": "\u1CEB",
    "/ve:anusvaravamagomukhawithtailsign": "\u1CEC",
    "/ve:ardhavisargasign": "\u1CF2",
    "/ve:atharvaindependentsvaritatone": "\u1CE1",
    "/ve:atikramasign": "\u1CF7",
    "/ve:belowtonecandra": "\u1CD8",
    "/ve:dotbelowtone": "\u1CDD",
    "/ve:hexiformanusvarasignlong": "\u1CEE",
    "/ve:jihvamuliyasign": "\u1CF5",
    "/ve:karshanatone": "\u1CD0",
    "/ve:kathakaanudattatone": "\u1CDC",
    "/ve:nihshvasasign": "\u1CD3",
    "/ve:prenkhatone": "\u1CD2",
    "/ve:rigkashmiriindependentsvaritatone": "\u1CE0",
    "/ve:ringabovetone": "\u1CF8",
    "/ve:ringabovetonedbl": "\u1CF9",
    "/ve:rotatedardhavisargasign": "\u1CF3",
    "/ve:rthanganusvarasignlong": "\u1CF0",
    "/ve:sharatone": "\u1CD1",
    "/ve:svaritatonedbl": "\u1CDA",
    "/ve:svaritatonetpl": "\u1CDB",
    "/ve:threedotsbelowtone": "\u1CDF",
    "/ve:tiryaksign": "\u1CED",
    "/ve:twodotsbelowtone": "\u1CDE",
    "/ve:upadhmaniyasign": "\u1CF6",
    "/ve:visargaanudattasign": "\u1CE5",
    "/ve:visargaanudattasignreversed": "\u1CE6",
    "/ve:visargaanudattawithtailsign": "\u1CE8",
    "/ve:visargasvaritasign": "\u1CE2",
    "/ve:visargaudattasign": "\u1CE3",
    "/ve:visargaudattasignreversed": "\u1CE4",
    "/ve:visargaudattawithtailsign": "\u1CE7",
    "/ve:yajuraggravatedindependentsvaritatone": "\u1CD5",
    "/ve:yajurindependentsvaritatone": "\u1CD6",
    "/ve:yajurkathakaindependentsvaritaschroedertone": "\u1CD9",
    "/ve:yajurkathakaindependentsvaritatone": "\u1CD7",
    "/ve:yajurmidlinesvaritasign": "\u1CD4",
    "/vecyr": "\u0432",
    "/vecyrillic": "\u0432",
    "/veh": "\u06A4",
    "/veh.fina": "\uFB6B",
    "/veh.init": "\uFB6C",
    "/veh.isol": "\uFB6A",
    "/veh.medi": "\uFB6D",
    "/veharabic": "\u06A4",
    "/vehfinalarabic": "\uFB6B",
    "/vehinitialarabic": "\uFB6C",
    "/vehmedialarabic": "\uFB6D",
    "/vekatakana": "\u30F9",
    "/vend": "\uA769",
    "/venus": "\u2640",
    "/versicle": "\u2123",
    "/vert:bracketwhiteleft": "\uFE17",
    "/vert:brakcetwhiteright": "\uFE18",
    "/vert:colon": "\uFE13",
    "/vert:comma": "\uFE10",
    "/vert:ellipsishor": "\uFE19",
    "/vert:exclam": "\uFE15",
    "/vert:ideographiccomma": "\uFE11",
    "/vert:ideographicfullstop": "\uFE12",
    "/vert:question": "\uFE16",
    "/vert:semicolon": "\uFE14",
    "/vertdblhorzsng": "\u256B",
    "/vertdblleftsng": "\u2562",
    "/vertdblrightsng": "\u255F",
    "/vertheavyhorzlight": "\u2542",
    "/vertheavyleftlight": "\u2528",
    "/vertheavyrightlight": "\u2520",
    "/verticalTrafficLight": "\u1F6A6",
    "/verticalbar": "\u007C",
    "/verticalbardbl": "\u2016",
    "/verticalbarhorizontalstroke": "\u27CA",
    "/verticalbarwhitearrowonpedestalup": "\u21ED",
    "/verticalfourdots": "\u205E",
    "/verticalideographiciterationmark": "\u303B",
    "/verticalkanarepeatmark": "\u3031",
    "/verticalkanarepeatmarklowerhalf": "\u3035",
    "/verticalkanarepeatmarkupperhalf": "\u3033",
    "/verticalkanarepeatwithvoicedsoundmark": "\u3032",
    "/verticalkanarepeatwithvoicedsoundmarkupperhalf": "\u3034",
    "/verticallineabovecmb": "\u030D",
    "/verticallinebelowcmb": "\u0329",
    "/verticallinelowmod": "\u02CC",
    "/verticallinemod": "\u02C8",
    "/verticalmalestroke": "\u26A8",
    "/verticalsdbltrokearrowleft": "\u21FA",
    "/verticalsdbltrokearrowleftright": "\u21FC",
    "/verticalsdbltrokearrowright": "\u21FB",
    "/verticalstrokearrowleft": "\u21F7",
    "/verticalstrokearrowleftright": "\u21F9",
    "/verticalstrokearrowright": "\u21F8",
    "/vertlighthorzheavy": "\u253F",
    "/vertlightleftheavy": "\u2525",
    "/vertlightrightheavy": "\u251D",
    "/vertsnghorzdbl": "\u256A",
    "/vertsngleftdbl": "\u2561",
    "/vertsngrightdbl": "\u255E",
    "/verymuchgreater": "\u22D9",
    "/verymuchless": "\u22D8",
    "/vesta": "\u26B6",
    "/vewarmenian": "\u057E",
    "/vhook": "\u028B",
    "/vibrationMode": "\u1F4F3",
    "/videoCamera": "\u1F4F9",
    "/videoGame": "\u1F3AE",
    "/videocassette": "\u1F4FC",
    "/viewdatasquare": "\u2317",
    "/vikatakana": "\u30F8",
    "/violin": "\u1F3BB",
    "/viramabengali": "\u09CD",
    "/viramadeva": "\u094D",
    "/viramagujarati": "\u0ACD",
    "/virgo": "\u264D",
    "/visargabengali": "\u0983",
    "/visargadeva": "\u0903",
    "/visargagujarati": "\u0A83",
    "/visigothicz": "\uA763",
    "/vmonospace": "\uFF56",
    "/voarmenian": "\u0578",
    "/vodsquare": "\u1F1AC",
    "/voicediterationhiragana": "\u309E",
    "/voicediterationkatakana": "\u30FE",
    "/voicedmarkkana": "\u309B",
    "/voicedmarkkanahalfwidth": "\uFF9E",
    "/voicingmod": "\u02EC",
    "/vokatakana": "\u30FA",
    "/volapukae": "\uA79B",
    "/volapukoe": "\uA79D",
    "/volapukue": "\uA79F",
    "/volcano": "\u1F30B",
    "/volleyball": "\u1F3D0",
    "/vovermfullwidth": "\u33DE",
    "/vowelVabove": "\u065A",
    "/voweldotbelow": "\u065C",
    "/vowelinvertedVabove": "\u065B",
    "/vparen": "\u24B1",
    "/vparenthesized": "\u24B1",
    "/vrighthook": "\u2C71",
    "/vssquare": "\u1F19A",
    "/vtilde": "\u1E7D",
    "/vturned": "\u028C",
    "/vuhiragana": "\u3094",
    "/vukatakana": "\u30F4",
    "/vwelsh": "\u1EFD",
    "/vy": "\uA761",
    "/w": "\u0077",
    "/wacirclekatakana": "\u32FB",
    "/wacute": "\u1E83",
    "/waekorean": "\u3159",
    "/wahiragana": "\u308F",
    "/wakatakana": "\u30EF",
    "/wakatakanahalfwidth": "\uFF9C",
    "/wakorean": "\u3158",
    "/waningCrescentMoon": "\u1F318",
    "/waningGibbousMoon": "\u1F316",
    "/warning": "\u26A0",
    "/wasmallhiragana": "\u308E",
    "/wasmallkatakana": "\u30EE",
    "/wastebasket": "\u1F5D1",
    "/watch": "\u231A",
    "/waterBuffalo": "\u1F403",
    "/waterCloset": "\u1F6BE",
    "/waterWave": "\u1F30A",
    "/waterideographiccircled": "\u328C",
    "/waterideographicparen": "\u322C",
    "/watermelon": "\u1F349",
    "/wattosquare": "\u3357",
    "/wavedash": "\u301C",
    "/wavingBlackFlag": "\u1F3F4",
    "/wavingHandSign": "\u1F44B",
    "/wavingWhiteFlag": "\u1F3F3",
    "/wavydash": "\u3030",
    "/wavyhamzabelow": "\u065F",
    "/wavyline": "\u2307",
    "/wavyunderscorevertical": "\uFE34",
    "/waw": "\u0648",
    "/waw.fina": "\uFEEE",
    "/waw.isol": "\uFEED",
    "/wawDigitThreeAbove": "\u0779",
    "/wawDigitTwoAbove": "\u0778",
    "/wawarabic": "\u0648",
    "/wawdotabove": "\u06CF",
    "/wawfinalarabic": "\uFEEE",
    "/wawhamza": "\u0624",
    "/wawhamza.fina": "\uFE86",
    "/wawhamza.isol": "\uFE85",
    "/wawhamzaabovearabic": "\u0624",
    "/wawhamzaabovefinalarabic": "\uFE86",
    "/wawhighhamza": "\u0676",
    "/wawring": "\u06C4",
    "/wawsmall": "\u06E5",
    "/wawtwodotsabove": "\u06CA",
    "/waxingCrescentMoon": "\u1F312",
    "/waxingGibbousMoon": "\u1F314",
    "/wbfullwidth": "\u33DD",
    "/wbsquare": "\u33DD",
    "/wcircle": "\u24E6",
    "/wcircumflex": "\u0175",
    "/wcsquare": "\u1F14F",
    "/wcsquareblack": "\u1F18F",
    "/wdieresis": "\u1E85",
    "/wdot": "\u1E87",
    "/wdotaccent": "\u1E87",
    "/wdotbelow": "\u1E89",
    "/wearyCatFace": "\u1F640",
    "/wearyFace": "\u1F629",
    "/wecirclekatakana": "\u32FD",
    "/wecyr": "\u051D",
    "/wedding": "\u1F492",
    "/wehiragana": "\u3091",
    "/weierstrass": "\u2118",
    "/weightLifter": "\u1F3CB",
    "/wekatakana": "\u30F1",
    "/wekorean": "\u315E",
    "/weokorean": "\u315D",
    "/westsyriaccross": "\u2670",
    "/wgrave": "\u1E81",
    "/whale": "\u1F40B",
    "/wheelchair": "\u267F",
    "/wheelofdharma": "\u2638",
    "/whiteDownPointingBackhandIndex": "\u1F447",
    "/whiteDownPointingLeftHandIndex": "\u1F597",
    "/whiteFlower": "\u1F4AE",
    "/whiteHardShellFloppyDisk": "\u1F5AB",
    "/whiteLatinCross": "\u1F546",
    "/whiteLeftPointingBackhandIndex": "\u1F448",
    "/whitePennant": "\u1F3F1",
    "/whiteRightPointingBackhandIndex": "\u1F449",
    "/whiteSquareButton": "\u1F533",
    "/whiteSun": "\u1F323",
    "/whiteSunBehindCloud": "\u1F325",
    "/whiteSunBehindCloudRain": "\u1F326",
    "/whiteSunSmallCloud": "\u1F324",
    "/whiteTouchtoneTelephone": "\u1F57E",
    "/whiteUpPointingBackhandIndex": "\u1F446",
    "/whitearrowdown": "\u21E9",
    "/whitearrowfromwallright": "\u21F0",
    "/whitearrowleft": "\u21E6",
    "/whitearrowonpedestalup": "\u21EB",
    "/whitearrowright": "\u21E8",
    "/whitearrowup": "\u21E7",
    "/whitearrowupdown": "\u21F3",
    "/whitearrowupfrombar": "\u21EA",
    "/whitebullet": "\u25E6",
    "/whitecircle": "\u25CB",
    "/whitecircleinverse": "\u25D9",
    "/whitecornerbracketleft": "\u300E",
    "/whitecornerbracketleftvertical": "\uFE43",
    "/whitecornerbracketright": "\u300F",
    "/whitecornerbracketrightvertical": "\uFE44",
    "/whitedblarrowonpedestalup": "\u21EF",
    "/whitedblarrowup": "\u21EE",
    "/whitediamond": "\u25C7",
    "/whitediamondcontainingblacksmalldiamond": "\u25C8",
    "/whitedownpointingsmalltriangle": "\u25BF",
    "/whitedownpointingtriangle": "\u25BD",
    "/whiteleftpointingsmalltriangle": "\u25C3",
    "/whiteleftpointingtriangle": "\u25C1",
    "/whitelenticularbracketleft": "\u3016",
    "/whitelenticularbracketright": "\u3017",
    "/whiterightpointingsmalltriangle": "\u25B9",
    "/whiterightpointingtriangle": "\u25B7",
    "/whitesesamedot": "\uFE46",
    "/whitesmallsquare": "\u25AB",
    "/whitesmilingface": "\u263A",
    "/whitesquare": "\u25A1",
    "/whitesquarebracketleft": "\u301A",
    "/whitesquarebracketright": "\u301B",
    "/whitestar": "\u2606",
    "/whitetelephone": "\u260F",
    "/whitetortoiseshellbracketleft": "\u3018",
    "/whitetortoiseshellbracketright": "\u3019",
    "/whiteuppointingsmalltriangle": "\u25B5",
    "/whiteuppointingtriangle": "\u25B3",
    "/whook": "\u2C73",
    "/wicirclekatakana": "\u32FC",
    "/wigglylinevertical": "\u2E3E",
    "/wignyan": "\uA983",
    "/wihiragana": "\u3090",
    "/wikatakana": "\u30F0",
    "/wikorean": "\u315F",
    "/windBlowingFace": "\u1F32C",
    "/windChime": "\u1F390",
    "/windupada": "\uA9C6",
    "/wineGlass": "\u1F377",
    "/winkingFace": "\u1F609",
    "/wiredKeyboard": "\u1F5AE",
    "/wmonospace": "\uFF57",
    "/wocirclekatakana": "\u32FE",
    "/wohiragana": "\u3092",
    "/wokatakana": "\u30F2",
    "/wokatakanahalfwidth": "\uFF66",
    "/wolfFace": "\u1F43A",
    "/woman": "\u1F469",
    "/womanBunnyEars": "\u1F46F",
    "/womansBoots": "\u1F462",
    "/womansClothes": "\u1F45A",
    "/womansHat": "\u1F452",
    "/womansSandal": "\u1F461",
    "/womens": "\u1F6BA",
    "/won": "\u20A9",
    "/wonmonospace": "\uFFE6",
    "/woodideographiccircled": "\u328D",
    "/woodideographicparen": "\u322D",
    "/wordjoiner": "\u2060",
    "/wordseparatormiddledot": "\u2E31",
    "/worldMap": "\u1F5FA",
    "/worriedFace": "\u1F61F",
    "/wowaenthai": "\u0E27",
    "/wparen": "\u24B2",
    "/wparenthesized": "\u24B2",
    "/wrappedPresent": "\u1F381",
    "/wreathproduct": "\u2240",
    "/wrench": "\u1F527",
    "/wring": "\u1E98",
    "/wsuperior": "\u02B7",
    "/wsupmod": "\u02B7",
    "/wturned": "\u028D",
    "/wulumelikvowel": "\uA9B7",
    "/wuluvowel": "\uA9B6",
    "/wynn": "\u01BF",
    "/x": "\u0078",
    "/x.inferior": "\u2093",
    "/xabovecmb": "\u033D",
    "/xatailcyr": "\u04B3",
    "/xbopomofo": "\u3112",
    "/xcircle": "\u24E7",
    "/xdieresis": "\u1E8D",
    "/xdot": "\u1E8B",
    "/xdotaccent": "\u1E8B",
    "/xeharmenian": "\u056D",
    "/xi": "\u03BE",
    "/xmonospace": "\uFF58",
    "/xor": "\u22BB",
    "/xparen": "\u24B3",
    "/xparenthesized": "\u24B3",
    "/xsuperior": "\u02E3",
    "/xsupmod": "\u02E3",
    "/y": "\u0079",
    "/yaadosquare": "\u334E",
    "/yaarusquare": "\u334F",
    "/yabengali": "\u09AF",
    "/yacirclekatakana": "\u32F3",
    "/yacute": "\u00FD",
    "/yacyr": "\u044F",
    "/yadeva": "\u092F",
    "/yaecyr": "\u0519",
    "/yaekorean": "\u3152",
    "/yagujarati": "\u0AAF",
    "/yagurmukhi": "\u0A2F",
    "/yahiragana": "\u3084",
    "/yakatakana": "\u30E4",
    "/yakatakanahalfwidth": "\uFF94",
    "/yakorean": "\u3151",
    "/yamakkanthai": "\u0E4E",
    "/yangtonemod": "\u02EB",
    "/yasmallhiragana": "\u3083",
    "/yasmallkatakana": "\u30E3",
    "/yasmallkatakanahalfwidth": "\uFF6C",
    "/yatcyr": "\u0463",
    "/yatcyrillic": "\u0463",
    "/ycircle": "\u24E8",
    "/ycircumflex": "\u0177",
    "/ydieresis": "\u00FF",
    "/ydot": "\u1E8F",
    "/ydotaccent": "\u1E8F",
    "/ydotbelow": "\u1EF5",
    "/yeh": "\u064A",
    "/yeh.fina": "\uFEF2",
    "/yeh.init": "\uFEF3",
    "/yeh.init_alefmaksura.fina": "\uFC59",
    "/yeh.init_hah.fina": "\uFC56",
    "/yeh.init_hah.medi": "\uFCDB",
    "/yeh.init_hamzaabove.medi_ae.fina": "\uFBEC",
    "/yeh.init_hamzaabove.medi_alef.fina": "\uFBEA",
    "/yeh.init_hamzaabove.medi_alefmaksura.fina": "\uFC03",
    "/yeh.init_hamzaabove.medi_e.fina": "\uFBF6",
    "/yeh.init_hamzaabove.medi_e.medi": "\uFBF8",
    "/yeh.init_hamzaabove.medi_hah.fina": "\uFC01",
    "/yeh.init_hamzaabove.medi_hah.medi": "\uFC98",
    "/yeh.init_hamzaabove.medi_heh.medi": "\uFC9B",
    "/yeh.init_hamzaabove.medi_jeem.fina": "\uFC00",
    "/yeh.init_hamzaabove.medi_jeem.medi": "\uFC97",
    "/yeh.init_hamzaabove.medi_khah.medi": "\uFC99",
    "/yeh.init_hamzaabove.medi_meem.fina": "\uFC02",
    "/yeh.init_hamzaabove.medi_meem.medi": "\uFC9A",
    "/yeh.init_hamzaabove.medi_oe.fina": "\uFBF2",
    "/yeh.init_hamzaabove.medi_u.fina": "\uFBF0",
    "/yeh.init_hamzaabove.medi_waw.fina": "\uFBEE",
    "/yeh.init_hamzaabove.medi_yeh.fina": "\uFC04",
    "/yeh.init_hamzaabove.medi_yu.fina": "\uFBF4",
    "/yeh.init_heh.medi": "\uFCDE",
    "/yeh.init_jeem.fina": "\uFC55",
    "/yeh.init_jeem.medi": "\uFCDA",
    "/yeh.init_khah.fina": "\uFC57",
    "/yeh.init_khah.medi": "\uFCDC",
    "/yeh.init_meem.fina": "\uFC58",
    "/yeh.init_meem.medi": "\uFCDD",
    "/yeh.init_meem.medi_meem.medi": "\uFD9D",
    "/yeh.init_yeh.fina": "\uFC5A",
    "/yeh.isol": "\uFEF1",
    "/yeh.medi": "\uFEF4",
    "/yeh.medi_alefmaksura.fina": "\uFC95",
    "/yeh.medi_hah.medi_yeh.fina": "\uFDAE",
    "/yeh.medi_hamzaabove.medi_ae.fina": "\uFBED",
    "/yeh.medi_hamzaabove.medi_alef.fina": "\uFBEB",
    "/yeh.medi_hamzaabove.medi_alefmaksura.fina": "\uFC68",
    "/yeh.medi_hamzaabove.medi_e.fina": "\uFBF7",
    "/yeh.medi_hamzaabove.medi_heh.medi": "\uFCE0",
    "/yeh.medi_hamzaabove.medi_meem.fina": "\uFC66",
    "/yeh.medi_hamzaabove.medi_meem.medi": "\uFCDF",
    "/yeh.medi_hamzaabove.medi_noon.fina": "\uFC67",
    "/yeh.medi_hamzaabove.medi_oe.fina": "\uFBF3",
    "/yeh.medi_hamzaabove.medi_reh.fina": "\uFC64",
    "/yeh.medi_hamzaabove.medi_u.fina": "\uFBF1",
    "/yeh.medi_hamzaabove.medi_waw.fina": "\uFBEF",
    "/yeh.medi_hamzaabove.medi_yeh.fina": "\uFC69",
    "/yeh.medi_hamzaabove.medi_yu.fina": "\uFBF5",
    "/yeh.medi_hamzaabove.medi_zain.fina": "\uFC65",
    "/yeh.medi_heh.medi": "\uFCF1",
    "/yeh.medi_jeem.medi_yeh.fina": "\uFDAF",
    "/yeh.medi_meem.fina": "\uFC93",
    "/yeh.medi_meem.medi": "\uFCF0",
    "/yeh.medi_meem.medi_meem.fina": "\uFD9C",
    "/yeh.medi_meem.medi_yeh.fina": "\uFDB0",
    "/yeh.medi_noon.fina": "\uFC94",
    "/yeh.medi_reh.fina": "\uFC91",
    "/yeh.medi_yeh.fina": "\uFC96",
    "/yeh.medi_zain.fina": "\uFC92",
    "/yehBarreeDigitThreeAbove": "\u077B",
    "/yehBarreeDigitTwoAbove": "\u077A",
    "/yehVabove": "\u06CE",
    "/yehabove": "\u06E7",
    "/yeharabic": "\u064A",
    "/yehbarree": "\u06D2",
    "/yehbarree.fina": "\uFBAF",
    "/yehbarree.isol": "\uFBAE",
    "/yehbarreearabic": "\u06D2",
    "/yehbarreefinalarabic": "\uFBAF",
    "/yehbarreehamza": "\u06D3",
    "/yehbarreehamza.fina": "\uFBB1",
    "/yehbarreehamza.isol": "\uFBB0",
    "/yehfarsi": "\u06CC",
    "/yehfarsi.fina": "\uFBFD",
    "/yehfarsi.init": "\uFBFE",
    "/yehfarsi.isol": "\uFBFC",
    "/yehfarsi.medi": "\uFBFF",
    "/yehfarsiinvertedV": "\u063D",
    "/yehfarsithreedotsabove": "\u063F",
    "/yehfarsitwodotsabove": "\u063E",
    "/yehfinalarabic": "\uFEF2",
    "/yehhamza": "\u0626",
    "/yehhamza.fina": "\uFE8A",
    "/yehhamza.init": "\uFE8B",
    "/yehhamza.isol": "\uFE89",
    "/yehhamza.medi": "\uFE8C",
    "/yehhamzaabovearabic": "\u0626",
    "/yehhamzaabovefinalarabic": "\uFE8A",
    "/yehhamzaaboveinitialarabic": "\uFE8B",
    "/yehhamzaabovemedialarabic": "\uFE8C",
    "/yehhighhamza": "\u0678",
    "/yehinitialarabic": "\uFEF3",
    "/yehmedialarabic": "\uFEF4",
    "/yehmeeminitialarabic": "\uFCDD",
    "/yehmeemisolatedarabic": "\uFC58",
    "/yehnoonfinalarabic": "\uFC94",
    "/yehsmall": "\u06E6",
    "/yehtail": "\u06CD",
    "/yehthreedotsbelow": "\u06D1",
    "/yehthreedotsbelowarabic": "\u06D1",
    "/yekorean": "\u3156",
    "/yellowHeart": "\u1F49B",
    "/yen": "\u00A5",
    "/yenmonospace": "\uFFE5",
    "/yeokorean": "\u3155",
    "/yeorinhieuhkorean": "\u3186",
    "/yerachBenYomo:hb": "\u05AA",
    "/yerahbenyomohebrew": "\u05AA",
    "/yerahbenyomolefthebrew": "\u05AA",
    "/yericyrillic": "\u044B",
    "/yerudieresiscyrillic": "\u04F9",
    "/yesieungkorean": "\u3181",
    "/yesieungpansioskorean": "\u3183",
    "/yesieungsioskorean": "\u3182",
    "/yetiv:hb": "\u059A",
    "/yetivhebrew": "\u059A",
    "/ygrave": "\u1EF3",
    "/yhoi": "\u1EF7",
    "/yhook": "\u01B4",
    "/yhookabove": "\u1EF7",
    "/yiarmenian": "\u0575",
    "/yicyrillic": "\u0457",
    "/yikorean": "\u3162",
    "/yintonemod": "\u02EA",
    "/yinyang": "\u262F",
    "/yiwnarmenian": "\u0582",
    "/ylongcyr": "\u044B",
    "/ylongdieresiscyr": "\u04F9",
    "/yloop": "\u1EFF",
    "/ymacron": "\u0233",
    "/ymonospace": "\uFF59",
    "/yocirclekatakana": "\u32F5",
    "/yod": "\u05D9",
    "/yod:hb": "\u05D9",
    "/yod_yod:hb": "\u05F2",
    "/yod_yod_patah:hb": "\uFB1F",
    "/yoddagesh": "\uFB39",
    "/yoddageshhebrew": "\uFB39",
    "/yodhebrew": "\u05D9",
    "/yodwithdagesh:hb": "\uFB39",
    "/yodwithhiriq:hb": "\uFB1D",
    "/yodyodhebrew": "\u05F2",
    "/yodyodpatahhebrew": "\uFB1F",
    "/yogh": "\u021D",
    "/yohiragana": "\u3088",
    "/yoikorean": "\u3189",
    "/yokatakana": "\u30E8",
    "/yokatakanahalfwidth": "\uFF96",
    "/yokorean": "\u315B",
    "/yosmallhiragana": "\u3087",
    "/yosmallkatakana": "\u30E7",
    "/yosmallkatakanahalfwidth": "\uFF6E",
    "/yot": "\u03F3",
    "/yotgreek": "\u03F3",
    "/yoyaekorean": "\u3188",
    "/yoyakorean": "\u3187",
    "/yoyakthai": "\u0E22",
    "/yoyingthai": "\u0E0D",
    "/yparen": "\u24B4",
    "/yparenthesized": "\u24B4",
    "/ypogegrammeni": "\u037A",
    "/ypogegrammenigreekcmb": "\u0345",
    "/yr": "\u01A6",
    "/yring": "\u1E99",
    "/ystroke": "\u024F",
    "/ysuperior": "\u02B8",
    "/ysupmod": "\u02B8",
    "/ytilde": "\u1EF9",
    "/yturned": "\u028E",
    "/yu.fina": "\uFBDC",
    "/yu.isol": "\uFBDB",
    "/yuansquare": "\u3350",
    "/yucirclekatakana": "\u32F4",
    "/yucyr": "\u044E",
    "/yuhiragana": "\u3086",
    "/yuikorean": "\u318C",
    "/yukatakana": "\u30E6",
    "/yukatakanahalfwidth": "\uFF95",
    "/yukirghiz": "\u06C9",
    "/yukirghiz.fina": "\uFBE3",
    "/yukirghiz.isol": "\uFBE2",
    "/yukorean": "\u3160",
    "/yukrcyr": "\u0457",
    "/yusbigcyr": "\u046B",
    "/yusbigcyrillic": "\u046B",
    "/yusbigiotifiedcyr": "\u046D",
    "/yusbigiotifiedcyrillic": "\u046D",
    "/yuslittlecyr": "\u0467",
    "/yuslittlecyrillic": "\u0467",
    "/yuslittleiotifiedcyr": "\u0469",
    "/yuslittleiotifiedcyrillic": "\u0469",
    "/yusmallhiragana": "\u3085",
    "/yusmallkatakana": "\u30E5",
    "/yusmallkatakanahalfwidth": "\uFF6D",
    "/yuyekorean": "\u318B",
    "/yuyeokorean": "\u318A",
    "/yyabengali": "\u09DF",
    "/yyadeva": "\u095F",
    "/z": "\u007A",
    "/zaarmenian": "\u0566",
    "/zacute": "\u017A",
    "/zadeva": "\u095B",
    "/zagurmukhi": "\u0A5B",
    "/zah": "\u0638",
    "/zah.fina": "\uFEC6",
    "/zah.init": "\uFEC7",
    "/zah.init_meem.fina": "\uFC28",
    "/zah.init_meem.medi": "\uFCB9",
    "/zah.isol": "\uFEC5",
    "/zah.medi": "\uFEC8",
    "/zah.medi_meem.medi": "\uFD3B",
    "/zaharabic": "\u0638",
    "/zahfinalarabic": "\uFEC6",
    "/zahinitialarabic": "\uFEC7",
    "/zahiragana": "\u3056",
    "/zahmedialarabic": "\uFEC8",
    "/zain": "\u0632",
    "/zain.fina": "\uFEB0",
    "/zain.isol": "\uFEAF",
    "/zainabove": "\u0617",
    "/zainarabic": "\u0632",
    "/zainfinalarabic": "\uFEB0",
    "/zakatakana": "\u30B6",
    "/zaqefGadol:hb": "\u0595",
    "/zaqefQatan:hb": "\u0594",
    "/zaqefgadolhebrew": "\u0595",
    "/zaqefqatanhebrew": "\u0594",
    "/zarqa:hb": "\u0598",
    "/zarqahebrew": "\u0598",
    "/zayin": "\u05D6",
    "/zayin:hb": "\u05D6",
    "/zayindagesh": "\uFB36",
    "/zayindageshhebrew": "\uFB36",
    "/zayinhebrew": "\u05D6",
    "/zayinwithdagesh:hb": "\uFB36",
    "/zbopomofo": "\u3117",
    "/zcaron": "\u017E",
    "/zcircle": "\u24E9",
    "/zcircumflex": "\u1E91",
    "/zcurl": "\u0291",
    "/zdescender": "\u2C6C",
    "/zdot": "\u017C",
    "/zdotaccent": "\u017C",
    "/zdotbelow": "\u1E93",
    "/zecyr": "\u0437",
    "/zecyrillic": "\u0437",
    "/zedescendercyrillic": "\u0499",
    "/zedieresiscyr": "\u04DF",
    "/zedieresiscyrillic": "\u04DF",
    "/zehiragana": "\u305C",
    "/zekatakana": "\u30BC",
    "/zero": "\u0030",
    "/zero.inferior": "\u2080",
    "/zero.superior": "\u2070",
    "/zeroarabic": "\u0660",
    "/zerobengali": "\u09E6",
    "/zerocircle": "\u24EA",
    "/zerocircleblack": "\u24FF",
    "/zerocomma": "\u1F101",
    "/zerodeva": "\u0966",
    "/zerofar": "\u06F0",
    "/zerofullstop": "\u1F100",
    "/zerogujarati": "\u0AE6",
    "/zerogurmukhi": "\u0A66",
    "/zerohackarabic": "\u0660",
    "/zeroinferior": "\u2080",
    "/zeromonospace": "\uFF10",
    "/zerooldstyle": "\uF730",
    "/zeropersian": "\u06F0",
    "/zerosquareabove": "\u06E0",
    "/zerosuperior": "\u2070",
    "/zerothai": "\u0E50",
    "/zerothirds": "\u2189",
    "/zerowidthjoiner": "\uFEFF",
    "/zerowidthnobreakspace": "\uFEFF",
    "/zerowidthnonjoiner": "\u200C",
    "/zerowidthspace": "\u200B",
    "/zeta": "\u03B6",
    "/zetailcyr": "\u0499",
    "/zhbopomofo": "\u3113",
    "/zhearmenian": "\u056A",
    "/zhebrevecyr": "\u04C2",
    "/zhebrevecyrillic": "\u04C2",
    "/zhecyr": "\u0436",
    "/zhecyrillic": "\u0436",
    "/zhedescendercyrillic": "\u0497",
    "/zhedieresiscyr": "\u04DD",
    "/zhedieresiscyrillic": "\u04DD",
    "/zhetailcyr": "\u0497",
    "/zhook": "\u0225",
    "/zihiragana": "\u3058",
    "/zikatakana": "\u30B8",
    "/zildefunc": "\u236C",
    "/zinorhebrew": "\u05AE",
    "/zjekomicyr": "\u0505",
    "/zlinebelow": "\u1E95",
    "/zmonospace": "\uFF5A",
    "/znotationbagmembership": "\u22FF",
    "/zohiragana": "\u305E",
    "/zokatakana": "\u30BE",
    "/zparen": "\u24B5",
    "/zparenthesized": "\u24B5",
    "/zretroflex": "\u0290",
    "/zretroflexhook": "\u0290",
    "/zstroke": "\u01B6",
    "/zswashtail": "\u0240",
    "/zuhiragana": "\u305A",
    "/zukatakana": "\u30BA",
    "/zwarakay": "\u0659",
    # manually added from
    # https://github.com/serviceprototypinglab/latex-pdfa/blob/master/glyphtounicode-cmr.tex
    "/angbracketleftBig": "\u28E8",
    "/angbracketleftBigg": "\u27E8",
    "/angbracketleftbig": "\u27E8",
    "/angbracketleftbigg": "\u27E8",
    "/angbracketrightBig": "\u27E9",
    "/angbracketrightBigg": "\u27E9",
    "/angbracketrightbig": "\u27E9",
    "/angbracketrightbigg": "\u27E9",
    "/arrowbt": "\u2193",
    "/arrowdblbt": "\u21D3",
    "/arrowdbltp": "\u21D1",
    "/arrowhookleft": "\u21AA",
    "/arrowhookright": "\u21A9",
    "/arrowtp": "\u2191",
    # diff : "/arrowvertex": "\u23D0",
    "/arrowvertexdbl": "\uED12",
    "/backslashBig": "\u005C",
    "/backslashBigg": "\u005C",
    "/backslashbig": "\u005C",
    "/backslashbigg": "\u005C",
    # diff : "/braceex": "\u23AA",
    "/bracehtipdownleft": "\uED17",
    "/bracehtipdownright": "\uED18",
    "/bracehtipupleft": "\uED19",
    "/bracehtipupright": "\uED1A",
    "/braceleftBig": "\u007B",
    "/braceleftBigg": "\u007B",
    "/braceleftbig": "\u007B",
    "/braceleftbigg": "\u007B",
    # diff : "/braceleftbt": "\u23A9",
    # diff : "/braceleftmid": "\u23A8",
    # diff : "/bracelefttp": "\u23A7",
    "/bracerightBig": "\u007D",
    "/bracerightBigg": "\u007D",
    "/bracerightbig": "\u007D",
    "/bracerightbigg": "\u007D",
    # diff : "/bracerightbt": "\u23AD",
    # diff : "/bracerightmid": "\u23AC",
    # diff : "/bracerighttp": "\u23AB",
    "/bracketleftBig": "\u005B",
    "/bracketleftBigg": "\u005B",
    "/bracketleftbig": "\u005B",
    "/bracketleftbigg": "\u005B",
    # diff : "/bracketleftbt": "\u23A3",
    # diff : "/bracketleftex": "\u23A2",
    # diff : "/bracketlefttp": "\u23A1",
    "/bracketrightBig": "\u005D",
    "/bracketrightBigg": "\u005D",
    "/bracketrightbig": "\u005D",
    "/bracketrightbigg": "\u005D",
    # diff : "/bracketrightbt": "\u23A6",
    # diff : "/bracketrightex": "\u23A5",
    # diff : "/bracketrighttp": "\u23A4",
    "/ceilingleftBig": "\u2308",
    "/ceilingleftBigg": "\u2308",
    "/ceilingleftbig": "\u2308",
    "/ceilingleftbigg": "\u2308",
    "/ceilingrightBig": "\u2309",
    "/ceilingrightBigg": "\u2309",
    "/ceilingrightbig": "\u2309",
    "/ceilingrightbigg": "\u2309",
    "/circledotdisplay": "\u2A00",
    "/circledottext": "\u2A00",
    "/circlemultiplydisplay": "\u2A02",
    "/circlemultiplytext": "\u2A02",
    "/circleplusdisplay": "\u2A01",
    "/circleplustext": "\u2A01",
    "/contintegraldisplay": "\u222E",
    "/contintegraltext": "\u222E",
    "/coproductdisplay": "\u2210",
    "/coproducttext": "\u2210",
    "/floorleftBig": "\u230A",
    "/floorleftBigg": "\u230A",
    "/floorleftbig": "\u230A",
    "/floorleftbigg": "\u230A",
    "/floorrightBig": "\u230B",
    "/floorrightBigg": "\u230B",
    "/floorrightbig": "\u230B",
    "/floorrightbigg": "\u230B",
    "/hatwide": "\u02C6",
    "/hatwider": "\u02C6",
    "/hatwidest": "\u02C6",
    "/integraldisplay": "\u222B",
    "/integraltext": "\u222B",
    "/intersectiondisplay": "\u22C2",
    "/intersectiontext": "\u22C2",
    "/logicalanddisplay": "\u22C0",
    "/logicalandtext": "\u22C0",
    "/logicalordisplay": "\u22C1",
    "/logicalortext": "\u22C1",
    "/mapsto": "\u21A6",
    "/parenleftBig": "\u0028",
    "/parenleftBigg": "\u0028",
    "/parenleftbig": "\u0028",
    "/parenleftbigg": "\u0028",
    # diff : "/parenleftbt": "\u239D",
    # diff : "/parenleftex": "\u239C",
    # diff : "/parenlefttp": "\u239B",
    "/parenrightBig": "\u0029",
    "/parenrightBigg": "\u0029",
    "/parenrightbig": "\u0029",
    "/parenrightbigg": "\u0029",
    # diff : "/parenrightbt": "\u23A0",
    # diff : "/parenrightex": "\u239F",
    # diff : "/parenrighttp": "\u239E",
    "/productdisplay": "\u220F",
    "/producttext": "\u220F",
    "/radicalBig": "\u221A",
    "/radicalBigg": "\u221A",
    "/radicalbig": "\u221A",
    "/radicalbigg": "\u221A",
    "/radicalbt": "\u221A",
    "/radicaltp": "\uED6A",
    "/radicalvertex": "\uED6B",
    "/slashBig": "\u002F",
    "/slashBigg": "\u002F",
    "/slashbig": "\u002F",
    "/slashbigg": "\u002F",
    "/summationdisplay": "\u2211",
    "/summationtext": "\u2211",
    "/tie": "\u2040",
    "/tildewide": "\u02DC",
    "/tildewider": "\u02DC",
    "/tildewidest": "\u02DC",
    "/uniondisplay": "\u22C3",
    "/unionmultidisplay": "\u2A04",
    "/unionmultitext": "\u2A04",
    "/unionsqdisplay": "\u2A06",
    "/unionsqtext": "\u2A06",
    "/uniontext": "\u22C3",
    "/vextenddouble": "\uED79",
    "/vextendsingle": "\u23D0",
    "/a1": "\u25C1",
    "/a2": "\u22B4",
    "/a3": "\u25B7",
    "/a4": "\u22B5",
    "/a40": "\u02C2",
    "/a41": "\u02C3",
    "/a42": "\u2303",
    "/a43": "\u2304",
    "/a48": "\u2127",
    "/a49": "\u22C8",
    "/a50": "\u25A1",
    "/a51": "\u25C7",
    "/a58": "\u2053",
    "/a59": "\u219D",
    "/a60": "\u228F",
    "/a61": "\u2290",
    "/d0": "\u2199",
    "/d1": "\u2199",
    "/d2": "\u2199",
    "/d3": "\u2199",
    "/d4": "\u2199",
    "/d5": "\u2199",
    "/d6": "\u2199",
    "/d7": "\u2193",
    "/d8": "\u2193",
    "/d9": "\u2193",
    "/d10": "\u2193",
    "/d11": "\u2193",
    "/d12": "\u2193",
    "/d13": "\u2193",
    "/d14": "\u2193",
    "/d15": "\u2193",
    "/d16": "\u2193",
    "/d17": "\u2193",
    "/d18": "\u2193",
    "/d19": "\u2193",
    "/d20": "\u2193",
    "/d21": "\u2193",
    "/d22": "\u2193",
    "/d23": "\u2193",
    "/d24": "\u2198",
    "/d25": "\u2198",
    "/d26": "\u2198",
    "/d27": "\u2198",
    "/d28": "\u2198",
    "/d29": "\u2198",
    "/d30": "\u2198",
    "/d31": "\u2198",
    "/d32": "\u2198",
    "/d33": "\u2198",
    "/d34": "\u2198",
    "/d35": "\u2198",
    "/d36": "\u2198",
    "/d37": "\u2198",
    "/d38": "\u2198",
    "/d39": "\u2192",
    "/d40": "\u2192",
    "/d41": "\u2192",
    "/d42": "\u2192",
    "/d43": "\u2192",
    "/d44": "\u2192",
    "/d45": "\u2192",
    "/d46": "\u2192",
    "/d47": "\u2192",
    "/d48": "\u2192",
    "/d49": "\u2192",
    "/d50": "\u2192",
    "/d51": "\u2192",
    "/d52": "\u2192",
    "/d53": "\u2192",
    "/d54": "\u2192",
    "/d55": "\u2192",
    "/d56": "\u2197",
    "/d57": "\u2197",
    "/d58": "\u2197",
    "/d59": "\u2197",
    "/d60": "\u2197",
    "/d61": "\u2197",
    "/d62": "\u2197",
    "/d63": "\u2197",
    "/d64": "\u2197",
    "/d65": "\u2197",
    "/d66": "\u2197",
    "/d67": "\u2197",
    "/d68": "\u2197",
    "/d69": "\u2197",
    "/d70": "\u2197",
    "/d71": "\u2191",
    "/d72": "\u2191",
    "/d73": "\u2191",
    "/d74": "\u2191",
    "/d75": "\u2191",
    "/d76": "\u2191",
    "/d77": "\u2191",
    "/d78": "\u2191",
    "/d79": "\u2191",
    "/d80": "\u2191",
    "/d81": "\u2191",
    "/d82": "\u2191",
    "/d83": "\u2191",
    "/d84": "\u2191",
    "/d85": "\u2191",
    "/d86": "\u2191",
    "/d87": "\u2191",
    "/d88": "\u2196",
    "/d89": "\u2196",
    "/d90": "\u2196",
    "/d91": "\u2196",
    "/d92": "\u2196",
    "/d93": "\u2196",
    "/d94": "\u2196",
    "/d95": "\u2196",
    "/d96": "\u2196",
    "/d97": "\u2196",
    "/d98": "\u2196",
    "/d99": "\u2196",
    "/d100": "\u2196",
    "/d101": "\u2196",
    "/d102": "\u2196",
    "/d103": "\u2190",
    "/d104": "\u2190",
    "/d105": "\u2190",
    "/d106": "\u2190",
    "/d107": "\u2190",
    "/d108": "\u2190",
    "/d109": "\u2190",
    "/d110": "\u2190",
    "/d111": "\u2190",
    "/d112": "\u2190",
    "/d113": "\u2190",
    "/d114": "\u2190",
    "/d115": "\u2190",
    "/d116": "\u2190",
    "/d117": "\u2190",
    "/d118": "\u2190",
    "/d119": "\u2190",
    "/d120": "\u2199",
    "/d121": "\u2199",
    "/d122": "\u2199",
    "/d123": "\u2199",
    "/d124": "\u2199",
    "/d125": "\u2199",
    "/d126": "\u2199",
    "/d127": "\u2199",
    # manually added from
    # https://github.com/kohler/lcdf-typetools/blob/master/texglyphlist.txt
    "/Ifractur": "\u2111",
    "/FFsmall": "\uF766",
    "/FFIsmall": "\uF766",
    "/FFLsmall": "\uF766",
    "/FIsmall": "\uF766",
    "/FLsmall": "\uF766",
    # diff : "/Germandbls": "\u0053",
    "/Germandblssmall": "\uF773",
    "/Ng": "\u014A",
    "/Rfractur": "\u211C",
    "/SS": "\u0053",
    "/SSsmall": "\uF773",
    "/altselector": "\uD802",
    "/angbracketleft": "\u27E8",
    "/angbracketright": "\u27E9",
    "/arrowbothv": "\u2195",
    "/arrowdblbothv": "\u21D5",
    "/arrowleftbothalf": "\u21BD",
    "/arrowlefttophalf": "\u21BC",
    "/arrownortheast": "\u2197",
    "/arrownorthwest": "\u2196",
    "/arrowrightbothalf": "\u21C1",
    "/arrowrighttophalf": "\u21C0",
    "/arrowsoutheast": "\u2198",
    "/arrowsouthwest": "\u2199",
    "/ascendercompwordmark": "\uD80A",
    "/asteriskcentered": "\u2217",
    "/bardbl": "\u2225",
    "/capitalcompwordmark": "\uD809",
    "/circlecopyrt": "\u20DD",
    "/circledivide": "\u2298",
    "/circleminus": "\u2296",
    "/coproduct": "\u2A3F",
    "/ct": "\u0063",
    "/cwm": "\u200C",
    "/dblbracketleft": "\u27E6",
    "/dblbracketright": "\u27E7",
    # diff : "/diamond": "\u2662",
    "/diamondmath": "\u22C4",
    # diff : "/dotlessj": "\u0237",
    "/emptyslot": "\uD801",
    "/epsilon1": "\u03F5",
    "/epsiloninv": "\u03F6",
    "/equivasymptotic": "\u224D",
    "/flat": "\u266D",
    "/follows": "\u227B",
    "/followsequal": "\u2AB0",
    "/followsorcurly": "\u227D",
    "/greatermuch": "\u226B",
    # diff : "/heart": "\u2661",
    "/interrobangdown": "\u2E18",
    "/intersectionsq": "\u2293",
    "/latticetop": "\u22A4",
    "/lessmuch": "\u226A",
    "/longdbls": "\u017F",
    "/longsh": "\u017F",
    "/longsi": "\u017F",
    "/longsl": "\u017F",
    "/longst": "\uFB05",
    "/lscript": "\u2113",
    "/natural": "\u266E",
    "/negationslash": "\u0338",
    "/ng": "\u014B",
    "/owner": "\u220B",
    "/pertenthousand": "\u2031",
    # diff : "/phi": "\u03D5",
    # diff : "/phi1": "\u03C6",
    "/pi1": "\u03D6",
    "/precedesequal": "\u2AAF",
    "/precedesorcurly": "\u227C",
    "/prime": "\u2032",
    "/rho1": "\u03F1",
    "/ringfitted": "\uD80D",
    "/sharp": "\u266F",
    "/similarequal": "\u2243",
    "/slurabove": "\u2322",
    "/slurbelow": "\u2323",
    "/st": "\uFB06",
    "/subsetsqequal": "\u2291",
    "/supersetsqequal": "\u2292",
    "/triangle": "\u25B3",
    "/triangleinv": "\u25BD",
    "/triangleleft": "\u25C1",
    # diff : "/triangleright": "\u25B7",
    "/turnstileleft": "\u22A2",
    "/turnstileright": "\u22A3",
    "/twelveudash": "\uD80C",
    "/unionmulti": "\u228E",
    "/unionsq": "\u2294",
    "/vector": "\u20D7",
    "/visualspace": "\u2423",
    "/Dbar": "\u0110",
    "/compwordmark": "\u200C",
    "/dbar": "\u0111",
    "/rangedash": "\u2013",
    "/hyphenchar": "\u002D",
    "/punctdash": "\u2014",
    "/visiblespace": "\u2423",
    "/Yen": "\u00A5",
    "/anticlockwise": "\u27F2",
    "/arrowparrleftright": "\u21C6",
    "/arrowparrrightleft": "\u21C4",
    "/arrowtailleft": "\u21A2",
    "/arrowtailright": "\u21A3",
    "/arrowtripleleft": "\u21DA",
    "/arrowtripleright": "\u21DB",
    "/check": "\u2713",
    "/circleR": "\u00AE",
    "/circleS": "\u24C8",
    "/circleasterisk": "\u229B",
    "/circleequal": "\u229C",
    "/circlering": "\u229A",
    "/clockwise": "\u27F3",
    "/curlyleft": "\u21AB",
    "/curlyright": "\u21AC",
    "/dblarrowdwn": "\u21CA",
    "/dblarrowheadleft": "\u219E",
    "/dblarrowheadright": "\u21A0",
    # diff : "/dblarrowup": "\u21C8",
    "/defines": "\u225C",
    "/diamondsolid": "\u2666",
    "/difference": "\u224F",
    "/downfall": "\u22CE",
    "/equaldotleftright": "\u2252",
    "/equaldotrightleft": "\u2253",
    "/equalorfollows": "\u22DF",
    # diff : "/equalorgreater": "\u2A96",
    # diff : "/equalorless": "\u2A95",
    "/equalsdots": "\u2251",
    "/followsorequal": "\u227F",
    "/forcesbar": "\u22AA",
    # diff : "/fork": "\u22D4",
    "/geomequivalent": "\u224E",
    "/greaterdbleqlless": "\u2A8C",
    "/greaterdblequal": "\u2267",
    "/greaterlessequal": "\u22DB",
    "/greaterorapproxeql": "\u2A86",
    "/greaterorequalslant": "\u2A7E",
    "/greaterorsimilar": "\u2273",
    "/harpoondownleft": "\u21C3",
    "/harpoondownright": "\u21C2",
    "/harpoonleftright": "\u21CC",
    "/harpoonrightleft": "\u21CB",
    "/harpoonupleft": "\u21BF",
    "/harpoonupright": "\u21BE",
    "/intercal": "\u22BA",
    "/lessdbleqlgreater": "\u2A8B",
    "/lessdblequal": "\u2266",
    "/lessequalgreater": "\u22DA",
    "/lessorapproxeql": "\u2A85",
    "/lessorequalslant": "\u2A7D",
    "/lessorsimilar": "\u2272",
    "/maltesecross": "\u2720",
    "/multiopenleft": "\u22CB",
    "/multiopenright": "\u22CC",
    "/orunderscore": "\u22BB",
    "/perpcorrespond": "\u2A5E",
    # diff : "/precedesorequal": "\u227E",
    "/primereverse": "\u2035",
    "/revasymptequal": "\u22CD",
    "/revsimilar": "\u223D",
    "/rightanglene": "\u231D",
    "/rightanglenw": "\u231C",
    "/rightanglese": "\u231F",
    "/rightanglesw": "\u231E",
    "/satisfies": "\u22A8",
    "/shiftleft": "\u21B0",
    "/shiftright": "\u21B1",
    "/square": "\u25A1",
    "/squaredot": "\u22A1",
    "/squareminus": "\u229F",
    "/squaremultiply": "\u22A0",
    "/squareplus": "\u229E",
    "/squaresolid": "\u25A0",
    "/squiggleleftright": "\u21AD",
    "/squiggleright": "\u21DD",
    "/subsetdblequal": "\u2AC5",
    "/supersetdbl": "\u22D1",
    "/supersetdblequal": "\u2AC6",
    "/triangledownsld": "\u25BC",
    "/triangleleftequal": "\u22B4",
    "/triangleleftsld": "\u25C0",
    "/trianglerightequal": "\u22B5",
    "/trianglerightsld": "\u25B6",
    "/trianglesolid": "\u25B2",
    "/uprise": "\u22CF",
    # diff : "/Digamma": "\u1D7C",
    "/Finv": "\u2132",
    "/Gmir": "\u2141",
    "/Omegainv": "\u2127",
    "/approxorequal": "\u224A",
    "/archleftdown": "\u21B6",
    "/archrightdown": "\u21B7",
    "/beth": "\u2136",
    "/daleth": "\u2138",
    "/dividemultiply": "\u22C7",
    "/downslope": "\u29F9",
    "/equalorsimilar": "\u2242",
    "/follownotdbleqv": "\u2ABA",
    "/follownotslnteql": "\u2AB6",
    "/followornoteqvlnt": "\u22E9",
    "/greaternotdblequal": "\u2A8A",
    "/greaternotequal": "\u2A88",
    "/greaterornotdbleql": "\u2269",
    "/greaterornotequal": "\u2269",
    "/integerdivide": "\u2216",
    "/lessnotdblequal": "\u2A89",
    "/lessnotequal": "\u2A87",
    "/lessornotdbleql": "\u2268",
    "/lessornotequal": "\u2268",
    "/multicloseleft": "\u22C9",
    "/multicloseright": "\u22CA",
    "/notapproxequal": "\u2247",
    "/notarrowboth": "\u21AE",
    "/notarrowleft": "\u219A",
    "/notarrowright": "\u219B",
    "/notbar": "\u2224",
    "/notdblarrowboth": "\u21CE",
    "/notdblarrowleft": "\u21CD",
    "/notdblarrowright": "\u21CF",
    "/notfollows": "\u2281",
    "/notfollowsoreql": "\u2AB0",
    "/notforces": "\u22AE",
    "/notforcesextra": "\u22AF",
    "/notgreaterdblequal": "\u2267",
    "/notgreaterequal": "\u2271",
    "/notgreaterorslnteql": "\u2A7E",
    "/notlessdblequal": "\u2266",
    "/notlessequal": "\u2270",
    "/notlessorslnteql": "\u2A7D",
    "/notprecedesoreql": "\u2AAF",
    "/notsatisfies": "\u22AD",
    "/notsimilar": "\u2241",
    "/notsubseteql": "\u2288",
    "/notsubsetordbleql": "\u2AC5",
    "/notsubsetoreql": "\u228A",
    "/notsuperseteql": "\u2289",
    "/notsupersetordbleql": "\u2AC6",
    "/notsupersetoreql": "\u228B",
    "/nottriangeqlleft": "\u22EC",
    "/nottriangeqlright": "\u22ED",
    "/nottriangleleft": "\u22EA",
    "/nottriangleright": "\u22EB",
    "/notturnstile": "\u22AC",
    "/planckover2pi": "\u210F",
    "/planckover2pi1": "\u210F",
    "/precedenotdbleqv": "\u2AB9",
    "/precedenotslnteql": "\u2AB5",
    "/precedeornoteqvlnt": "\u22E8",
    "/subsetnoteql": "\u228A",
    "/subsetornotdbleql": "\u2ACB",
    "/supersetnoteql": "\u228B",
    "/supersetornotdbleql": "\u2ACC",
    "/upslope": "\u29F8",
}


def _complete() -> None:
    global adobe_glyphs
    for i in range(256):
        adobe_glyphs[f"/a{i}"] = chr(i)
    adobe_glyphs["/.notdef"] = "□"


_complete()
