# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _gdal
else:
    import _gdal

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)




have_warned = 0
def deprecation_warn(module, sub_package=None, new_module=None):
    global have_warned

    if have_warned == 1:
        return

    have_warned = 1
    if sub_package is None or sub_package == 'utils':
        sub_package = 'osgeo_utils'
    if new_module is None:
        new_module = module
    new_module = '{}.{}'.format(sub_package, new_module)

    from warnings import warn
    warn('{}.py was placed in a namespace, it is now available as {}' .format(module, new_module),
       DeprecationWarning)


from osgeo.gdalconst import *
from osgeo import gdalconst


import sys
byteorders = {"little": "<",
              "big": ">"}
array_modes = { gdalconst.GDT_Int16:    ("%si2" % byteorders[sys.byteorder]),
                gdalconst.GDT_UInt16:   ("%su2" % byteorders[sys.byteorder]),
                gdalconst.GDT_Int32:    ("%si4" % byteorders[sys.byteorder]),
                gdalconst.GDT_UInt32:   ("%su4" % byteorders[sys.byteorder]),
                gdalconst.GDT_Float32:  ("%sf4" % byteorders[sys.byteorder]),
                gdalconst.GDT_Float64:  ("%sf8" % byteorders[sys.byteorder]),
                gdalconst.GDT_CFloat32: ("%sf4" % byteorders[sys.byteorder]),
                gdalconst.GDT_CFloat64: ("%sf8" % byteorders[sys.byteorder]),
                gdalconst.GDT_Byte:     ("%st8" % byteorders[sys.byteorder]),
}

def RGBFile2PCTFile( src_filename, dst_filename ):
  src_ds = Open(src_filename)
  if src_ds is None or src_ds == 'NULL':
      return 1

  ct = ColorTable()
  err = ComputeMedianCutPCT(src_ds.GetRasterBand(1),
                            src_ds.GetRasterBand(2),
                            src_ds.GetRasterBand(3),
                            256, ct)
  if err != 0:
      return err

  gtiff_driver = GetDriverByName('GTiff')
  if gtiff_driver is None:
      return 1

  dst_ds = gtiff_driver.Create(dst_filename,
                               src_ds.RasterXSize, src_ds.RasterYSize)
  dst_ds.GetRasterBand(1).SetRasterColorTable(ct)

  err = DitherRGB2PCT(src_ds.GetRasterBand(1),
                      src_ds.GetRasterBand(2),
                      src_ds.GetRasterBand(3),
                      dst_ds.GetRasterBand(1),
                      ct)
  dst_ds = None
  src_ds = None

  return 0

def listdir(path, recursionLevel = -1, options = []):
  """ Iterate over a directory.

      recursionLevel = -1 means unlimited level of recursion.
  """
  dir = OpenDir(path, recursionLevel, options)
  if not dir:
      raise OSError(path + ' does not exist')
  try:
      while True:
          entry = GetNextDirEntry(dir)
          if not entry:
              break
          yield entry
  finally:
      CloseDir(dir)


def GetUseExceptions(*args):
    r"""GetUseExceptions() -> int"""
    return _gdal.GetUseExceptions(*args)

def _GetExceptionsLocal(*args):
    r"""_GetExceptionsLocal() -> int"""
    return _gdal._GetExceptionsLocal(*args)

def _SetExceptionsLocal(*args):
    r"""_SetExceptionsLocal(int bVal)"""
    return _gdal._SetExceptionsLocal(*args)

def _UseExceptions(*args):
    r"""_UseExceptions()"""
    return _gdal._UseExceptions(*args)

def _DontUseExceptions(*args):
    r"""_DontUseExceptions()"""
    return _gdal._DontUseExceptions(*args)

def _UserHasSpecifiedIfUsingExceptions(*args):
    r"""_UserHasSpecifiedIfUsingExceptions() -> int"""
    return _gdal._UserHasSpecifiedIfUsingExceptions(*args)

class ExceptionMgr(object):
    """
    Context manager to manage Python Exception state
    for GDAL/OGR/OSR/GNM.

    Separate exception state is maintained for each
    module (gdal, ogr, etc), and this class appears independently
    in all of them. This is built in top of calls to the older
    UseExceptions()/DontUseExceptions() functions.

    Example::

        >>> print(gdal.GetUseExceptions())
        0
        >>> with gdal.ExceptionMgr():
        ...     # Exceptions are now in use
        ...     print(gdal.GetUseExceptions())
        1
        >>>
        >>> # Exception state has now been restored
        >>> print(gdal.GetUseExceptions())
        0

    """
    def __init__(self, useExceptions=True):
        """
        Save whether or not this context will be using exceptions
        """
        self.requestedUseExceptions = useExceptions

    def __enter__(self):
        """
        On context entry, save the current GDAL exception state, and
        set it to the state requested for the context

        """
        self.currentUseExceptions = _GetExceptionsLocal()
        _SetExceptionsLocal(self.requestedUseExceptions)
        if ExceptionMgr.__module__ == "osgeo.gdal":
            try:
                from . import gdal_array
            except ImportError:
                gdal_array = None
            if gdal_array:
                gdal_array._SetExceptionsLocal(self.requestedUseExceptions)

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        On exit, restore the GDAL/OGR/OSR/GNM exception state which was
        current on entry to the context
        """
        _SetExceptionsLocal(self.currentUseExceptions)
        if ExceptionMgr.__module__ == "osgeo.gdal":
            try:
                from . import gdal_array
            except ImportError:
                gdal_array = None
            if gdal_array:
                gdal_array._SetExceptionsLocal(self.currentUseExceptions)




def UseExceptions():
    """ Enable exceptions in all GDAL related modules (osgeo.gdal, osgeo.ogr, osgeo.osr, osgeo.gnm).
        Note: prior to GDAL 3.7, this only affected the calling module"""

    try:
        from . import gdal
        gdal._UseExceptions()
    except ImportError:
        pass
    try:
        from . import gdal_array
        gdal_array._UseExceptions()
    except ImportError:
        pass
    try:
        from . import ogr
        ogr._UseExceptions()
    except ImportError:
        pass
    try:
        from . import osr
        osr._UseExceptions()
    except ImportError:
        pass
    try:
        from . import gnm
        gnm._UseExceptions()
    except ImportError:
        pass

def DontUseExceptions():
    """ Disable exceptions in all GDAL related modules (osgeo.gdal, osgeo.ogr, osgeo.osr, osgeo.gnm).
        Note: prior to GDAL 3.7, this only affected the calling module"""

    try:
        from . import gdal
        gdal._DontUseExceptions()
    except ImportError:
        pass
    try:
        from . import gdal_array
        gdal_array._DontUseExceptions()
    except ImportError:
        pass
    try:
        from . import ogr
        ogr._DontUseExceptions()
    except ImportError:
        pass
    try:
        from . import osr
        osr._DontUseExceptions()
    except ImportError:
        pass
    try:
        from . import gnm
        gnm._DontUseExceptions()
    except ImportError:
        pass



def VSIFReadL(*args):
    r"""VSIFReadL(unsigned int nMembSize, unsigned int nMembCount, VSILFILE fp) -> unsigned int"""
    return _gdal.VSIFReadL(*args)

def VSIGetMemFileBuffer_unsafe(*args):
    r"""VSIGetMemFileBuffer_unsafe(char const * utf8_path)"""
    return _gdal.VSIGetMemFileBuffer_unsafe(*args)


def _WarnIfUserHasNotSpecifiedIfUsingExceptions():
    from . import gdal
    if not hasattr(gdal, "hasWarnedAboutUserHasNotSpecifiedIfUsingExceptions") and not _UserHasSpecifiedIfUsingExceptions():
        gdal.hasWarnedAboutUserHasNotSpecifiedIfUsingExceptions = True
        import warnings
        warnings.warn(
            "Neither gdal.UseExceptions() nor gdal.DontUseExceptions() has been explicitly called. " +
            "In GDAL 4.0, exceptions will be enabled by default.", FutureWarning)

def _WarnIfUserHasNotSpecifiedIfUsingOgrExceptions():
    from . import ogr
    ogr._WarnIfUserHasNotSpecifiedIfUsingExceptions()



def InfoOptions(options=None, format='text', deserialize=True,
         computeMinMax=False, reportHistograms=False, reportProj4=False,
         stats=False, approxStats=False, computeChecksum=False,
         showGCPs=True, showMetadata=True, showRAT=True, showColorTable=True,
         listMDD=False, showFileList=True, allMetadata=False,
         extraMDDomains=None, wktFormat=None):
    """ Create a InfoOptions() object that can be passed to gdal.Info()
        options can be be an array of strings, a string or let empty and filled from other keywords."""

    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
        format = 'text'
        if '-json' in new_options:
            format = 'json'
    else:
        new_options = options
        if format == 'json':
            new_options += ['-json']
        elif format != "text":
            raise Exception("Invalid value for format")
        if '-json' in new_options:
            format = 'json'
        if computeMinMax:
            new_options += ['-mm']
        if reportHistograms:
            new_options += ['-hist']
        if reportProj4:
            new_options += ['-proj4']
        if stats:
            new_options += ['-stats']
        if approxStats:
            new_options += ['-approx_stats']
        if computeChecksum:
            new_options += ['-checksum']
        if not showGCPs:
            new_options += ['-nogcp']
        if not showMetadata:
            new_options += ['-nomd']
        if not showRAT:
            new_options += ['-norat']
        if not showColorTable:
            new_options += ['-noct']
        if listMDD:
            new_options += ['-listmdd']
        if not showFileList:
            new_options += ['-nofl']
        if allMetadata:
            new_options += ['-mdd', 'all']
        if wktFormat:
            new_options += ['-wkt_format', wktFormat]
        if extraMDDomains is not None:
            for mdd in extraMDDomains:
                new_options += ['-mdd', mdd]

    return (GDALInfoOptions(new_options), format, deserialize)

def Info(ds, **kwargs):
    """Return information on a raster dataset.

    Parameters
    ----------
    ds:
        a Dataset object or a filename
    kwargs:
        options: return of gdal.InfoOptions(), string or array of strings
        other keywords arguments of gdal.InfoOptions().
        If options is provided as a gdal.InfoOptions() object, other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, format, deserialize) = InfoOptions(**kwargs)
    else:
        (opts, format, deserialize) = kwargs['options']

    import os

    if isinstance(ds, (str, os.PathLike)):
        ds = Open(ds)
    ret = InfoInternal(ds, opts)
    if format == 'json' and deserialize:
        import json
        ret = json.loads(ret)
    return ret


def VectorInfoOptions(options=None,
                      format='text',
                      deserialize=True,
                      layers=None,
                      dumpFeatures=False,
                      featureCount=True,
                      extent=True,
                      SQLStatement=None,
                      SQLDialect=None,
                      where=None,
                      wktFormat=None):
    """ Create a VectorInfoOptions() object that can be passed to gdal.VectorInfo()
        options can be be an array of strings, a string or let empty and filled from other keywords.

        Parameters
        ----------
        options:
            can be be an array of strings, a string or let empty and filled from other keywords.
        format:
            "text" or "json"
        deserialize:
            if JSON output should be returned as a Python dictionary. Otherwise as a serialized representation.
        SQLStatement:
            SQL statement to apply to the source dataset
        SQLDialect:
            SQL dialect ('OGRSQL', 'SQLITE', ...)
        where:
            WHERE clause to apply to source layer(s)
        layers:
            list of layers of interest
        featureCount:
            whether to compute and display the feature count
        extent:
            whether to compute and display the layer extent
        dumpFeatures:
            set to True to get the dump of all features
    """

    options = [] if options is None else options
    deserialize=True

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
        format = 'text'
        if '-json' in new_options:
            format = 'json'
    else:
        new_options = options
        if format == 'json':
            new_options += ['-json']
        elif format != "text":
            raise Exception("Invalid value for format")
        if '-json' in new_options:
            format = 'json'
        if SQLStatement:
            new_options += ['-sql', SQLStatement]
        if SQLDialect:
            new_options += ['-dialect', SQLDialect]
        if where:
            new_options += ['-where', where]
        if wktFormat:
            new_options += ['-wkt_format', wktFormat]
        if not featureCount:
            new_options += ['-nocount']
        if not extent:
            new_options += ['-noextent']
        if layers:
            new_options += ["dummy_dataset_name"]
            for layer in layers:
                new_options += [layer]
        else:
            new_options += ["-al"]
        if format == 'json':
            if dumpFeatures:
                new_options += ["-features"]
        else:
            if not dumpFeatures:
                new_options += ["-so"]

    return (GDALVectorInfoOptions(new_options), format, deserialize)


def VectorInfo(ds, **kwargs):
    """Return information on a vector dataset.

    Parameters
    ----------
    ds:
        a Dataset object or a filename
    kwargs:
        options: return of gdal.VectorInfoOptions(), string or array of strings
        other keywords arguments of gdal.VectorInfoOptions().
        If options is provided as a gdal.VectorInfoOptions() object, other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, format, deserialize) = VectorInfoOptions(**kwargs)
    else:
        (opts, format, deserialize) = kwargs['options']

    import os

    if isinstance(ds, (str, os.PathLike)):
        ds = OpenEx(ds, OF_VERBOSE_ERROR | OF_VECTOR)
    ret = VectorInfoInternal(ds, opts)
    if format == 'json' and deserialize:
        import json
        ret = json.loads(ret)
    return ret


def MultiDimInfoOptions(options=None, detailed=False, array=None, arrayoptions=None, limit=None, as_text=False):
    """ Create a MultiDimInfoOptions() object that can be passed to gdal.MultiDimInfo()
        options can be be an array of strings, a string or let empty and filled from other keywords."""

    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if detailed:
            new_options += ['-detailed']
        if array:
            new_options += ['-array', array]
        if limit:
            new_options += ['-limit', str(limit)]
        if arrayoptions:
            for option in arrayoptions:
                new_options += ['-arrayoption', option]

    return GDALMultiDimInfoOptions(new_options), as_text

def MultiDimInfo(ds, **kwargs):
    """Return information on a dataset.

    Parameters
    ----------
    ds:
        a Dataset object or a filename
    kwargs:
        options: return of gdal.MultiDimInfoOptions(), string or array of strings
        other keywords arguments of gdal.MultiDimInfoOptions().
        If options is provided as a gdal.MultiDimInfoOptions() object, other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        opts, as_text = MultiDimInfoOptions(**kwargs)
    else:
        opts = kwargs['options']
        as_text = True

    import os

    if isinstance(ds, (str, os.PathLike)):
        ds = OpenEx(ds, OF_VERBOSE_ERROR | OF_MULTIDIM_RASTER)
    ret = MultiDimInfoInternal(ds, opts)
    if not as_text:
        import json
        ret = json.loads(ret)
    return ret


def _strHighPrec(x):
    return ('%.18g' % x) if isinstance(x, float) else str(x)

mapGRIORAMethodToString = {
    gdalconst.GRIORA_NearestNeighbour: 'near',
    gdalconst.GRIORA_Bilinear: 'bilinear',
    gdalconst.GRIORA_Cubic: 'cubic',
    gdalconst.GRIORA_CubicSpline: 'cubicspline',
    gdalconst.GRIORA_Lanczos: 'lanczos',
    gdalconst.GRIORA_Average: 'average',
    gdalconst.GRIORA_RMS: 'rms',
    gdalconst.GRIORA_Mode: 'mode',
    gdalconst.GRIORA_Gauss: 'gauss',
}

def TranslateOptions(options=None, format=None,
              outputType = gdalconst.GDT_Unknown, bandList=None, maskBand=None,
              width = 0, height = 0, widthPct = 0.0, heightPct = 0.0,
              xRes = 0.0, yRes = 0.0,
              creationOptions=None, srcWin=None, projWin=None, projWinSRS=None, strict = False,
              unscale = False, scaleParams=None, exponents=None,
              outputBounds=None, outputGeotransform=None, metadataOptions=None,
              outputSRS=None, nogcp=False, GCPs=None,
              noData=None, rgbExpand=None,
              stats = False, rat = True, xmp = True, resampleAlg=None,
              overviewLevel = 'AUTO',
              callback=None, callback_data=None):
    """Create a TranslateOptions() object that can be passed to gdal.Translate()

    Parameters
    ----------
    options:
        can be be an array of strings, a string or let empty and filled from other keywords.
    format:
        output format ("GTiff", etc...)
    outputType:
        output type (gdalconst.GDT_Byte, etc...)
    bandList:
        array of band numbers (index start at 1)
    maskBand:
        mask band to generate or not ("none", "auto", "mask", 1, ...)
    width:
        width of the output raster in pixel
    height:
        height of the output raster in pixel
    widthPct:
        width of the output raster in percentage (100 = original width)
    heightPct:
        height of the output raster in percentage (100 = original height)
    xRes:
        output horizontal resolution
    yRes:
        output vertical resolution
    creationOptions:
        list or dict of creation options
    srcWin:
        subwindow in pixels to extract: [left_x, top_y, width, height]
    projWin:
        subwindow in projected coordinates to extract: [ulx, uly, lrx, lry]
    projWinSRS:
        SRS in which projWin is expressed
    strict:
        strict mode
    unscale:
        unscale values with scale and offset metadata
    scaleParams:
        list of scale parameters, each of the form [src_min,src_max] or [src_min,src_max,dst_min,dst_max]
    exponents:
        list of exponentiation parameters
    outputBounds:
        assigned output bounds: [ulx, uly, lrx, lry]
    outputGeotransform:
        assigned geotransform matrix (array of 6 values) (mutually exclusive with outputBounds)
    metadataOptions:
        list or dict of metadata options
    outputSRS:
        assigned output SRS
    nogcp:
        ignore GCP in the raster
    GCPs:
        list of GCPs
    noData:
        nodata value (or "none" to unset it)
    rgbExpand:
        Color palette expansion mode: "gray", "rgb", "rgba"
    stats:
        whether to calculate statistics
    rat:
        whether to write source RAT
    xmp:
        whether to copy XMP metadata
    resampleAlg:
        resampling mode
    overviewLevel:
        To specify which overview level of source files must be used
    callback:
        callback method
    callback_data:
        user data for callback
    """

# Only used for tests
    return_option_list = options == '__RETURN_OPTION_LIST__'

    if return_option_list:
        options = []
    else:
        options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if outputType != gdalconst.GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType)]
        if maskBand != None:
            new_options += ['-mask', str(maskBand)]
        if bandList != None:
            for b in bandList:
                new_options += ['-b', str(b)]
        if width != 0 or height != 0:
            new_options += ['-outsize', str(width), str(height)]
        elif widthPct != 0 and heightPct != 0:
            new_options += ['-outsize', str(widthPct) + '%%', str(heightPct) + '%%']
        if creationOptions is not None:
            if isinstance(creationOptions, str):
                new_options += ['-co', creationOptions]
            elif isinstance(creationOptions, dict):
                for k, v in creationOptions.items():
                    new_options += ['-co', f'{k}={v}']
            else:
                for opt in creationOptions:
                    new_options += ['-co', opt]
        if srcWin is not None:
            new_options += ['-srcwin', _strHighPrec(srcWin[0]), _strHighPrec(srcWin[1]), _strHighPrec(srcWin[2]), _strHighPrec(srcWin[3])]
        if strict:
            new_options += ['-strict']
        if unscale:
            new_options += ['-unscale']
        if scaleParams:
            for scaleParam in scaleParams:
                new_options += ['-scale']
                for v in scaleParam:
                    new_options += [str(v)]
        if exponents:
            for exponent in exponents:
                new_options += ['-exponent', _strHighPrec(exponent)]
        if outputBounds is not None:
            new_options += ['-a_ullr', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3])]
        if outputGeotransform:
            if outputBounds:
                raise Exception("outputBounds and outputGeotransform are mutually exclusive")
            assert len(outputGeotransform) == 6
            new_options += ['-a_gt']
            for val in outputGeotransform:
                new_options += [_strHighPrec(val)]
        if metadataOptions is not None:
            if isinstance(metadataOptions, str):
                new_options += ['-mo', metadataOptions]
            elif isinstance(metadataOptions, dict):
                for k, v in metadataOptions.items():
                    new_options += ['-mo', f'{k}={v}']
            else:
                for opt in metadataOptions:
                    new_options += ['-mo', opt]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS)]
        if nogcp:
            new_options += ['-nogcp']
        if GCPs is not None:
            for gcp in GCPs:
                new_options += ['-gcp', _strHighPrec(gcp.GCPPixel), _strHighPrec(gcp.GCPLine), _strHighPrec(gcp.GCPX), str(gcp.GCPY), _strHighPrec(gcp.GCPZ)]
        if projWin is not None:
            new_options += ['-projwin', _strHighPrec(projWin[0]), _strHighPrec(projWin[1]), _strHighPrec(projWin[2]), _strHighPrec(projWin[3])]
        if projWinSRS is not None:
            new_options += ['-projwin_srs', str(projWinSRS)]
        if noData is not None:
            new_options += ['-a_nodata', _strHighPrec(noData)]
        if rgbExpand is not None:
            new_options += ['-expand', str(rgbExpand)]
        if stats:
            new_options += ['-stats']
        if not rat:
            new_options += ['-norat']
        if not xmp:
            new_options += ['-noxmp']
        if resampleAlg is not None:
            if resampleAlg in mapGRIORAMethodToString:
                new_options += ['-r', mapGRIORAMethodToString[resampleAlg]]
            else:
                new_options += ['-r', str(resampleAlg)]
        if xRes != 0 and yRes != 0:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes)]

        if overviewLevel is None or isinstance(overviewLevel, str):
            pass
        elif isinstance(overviewLevel, int):
            if overviewLevel < 0:
                overviewLevel = 'AUTO' + str(overviewLevel)
            else:
                overviewLevel = str(overviewLevel)
        else:
            overviewLevel = None

        if overviewLevel is not None and overviewLevel != 'AUTO':
            new_options += ['-ovr', overviewLevel]

    if return_option_list:
        return new_options

    return (GDALTranslateOptions(new_options), callback, callback_data)

def Translate(destName, srcDS, **kwargs):
    """Convert a dataset.

    Parameters
    ----------
    destName:
        Output dataset name
    srcDS:
        a Dataset object or a filename
    kwargs:
        options: return of gdal.TranslateOptions(), string or array of strings
        other keywords arguments of gdal.TranslateOptions().
        If options is provided as a gdal.TranslateOptions() object, other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = TranslateOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']

    import os

    if isinstance(srcDS, (str, os.PathLike)):
        srcDS = Open(srcDS)

    return TranslateInternal(destName, srcDS, opts, callback, callback_data)

def WarpOptions(options=None, format=None,
         srcBands=None,
         dstBands=None,
         outputBounds=None,
         outputBoundsSRS=None,
         xRes=None, yRes=None, targetAlignedPixels = False,
         width = 0, height = 0,
         srcSRS=None, dstSRS=None,
         coordinateOperation=None,
         srcAlpha = None, dstAlpha = False,
         warpOptions=None, errorThreshold=None,
         warpMemoryLimit=None, creationOptions=None, outputType = gdalconst.GDT_Unknown,
         workingType = gdalconst.GDT_Unknown, resampleAlg=None,
         srcNodata=None, dstNodata=None, multithread = False,
         tps = False, rpc = False, geoloc = False, polynomialOrder=None,
         transformerOptions=None, cutlineDSName=None,
         cutlineLayer=None, cutlineWhere=None, cutlineSQL=None, cutlineBlend=None, cropToCutline = False,
         copyMetadata = True, metadataConflictValue=None,
         setColorInterpretation = False,
         overviewLevel = 'AUTO',
         callback=None, callback_data=None):
    """Create a WarpOptions() object that can be passed to gdal.Warp()

    Parameters
    ----------
    options:
        can be be an array of strings, a string or let empty and filled from other keywords.
    format:
        output format ("GTiff", etc...)
    srcBands:
        list of source band numbers (between 1 and the number of input bands)
    dstBands:
        list of output band numbers
    outputBounds:
        output bounds as (minX, minY, maxX, maxY) in target SRS
    outputBoundsSRS:
        SRS in which output bounds are expressed, in the case they are not expressed in dstSRS
    xRes:
        output resolution in target SRS
    yRes:
        output resolution in target SRS
    targetAlignedPixels:
        whether to force output bounds to be multiple of output resolution
    width:
        width of the output raster in pixel
    height:
        height of the output raster in pixel
    srcSRS:
        source SRS
    dstSRS:
        output SRS
    coordinateOperation:
        coordinate operation as a PROJ string or WKT string
    srcAlpha:
        whether to force the last band of the input dataset to be considered as an alpha band.
        If set to False, source alpha warping will be disabled.
    dstAlpha:
        whether to force the creation of an output alpha band
    outputType:
        output type (gdalconst.GDT_Byte, etc...)
    workingType:
        working type (gdalconst.GDT_Byte, etc...)
    warpOptions:
        list or dict of warping options
    errorThreshold:
        error threshold for approximation transformer (in pixels)
    warpMemoryLimit:
        size of working buffer in MB
    resampleAlg:
        resampling mode
    creationOptions:
        list or dict of creation options
    srcNodata:
        source nodata value(s)
    dstNodata:
        output nodata value(s)
    multithread:
        whether to multithread computation and I/O operations
    tps:
        whether to use Thin Plate Spline GCP transformer
    rpc:
        whether to use RPC transformer
    geoloc:
        whether to use GeoLocation array transformer
    polynomialOrder:
        order of polynomial GCP interpolation
    transformerOptions:
        list or dict of transformer options
    cutlineDSName:
        cutline dataset name
    cutlineLayer:
        cutline layer name
    cutlineWhere:
        cutline WHERE clause
    cutlineSQL:
        cutline SQL statement
    cutlineBlend:
        cutline blend distance in pixels
    cropToCutline:
        whether to use cutline extent for output bounds
    copyMetadata:
        whether to copy source metadata
    metadataConflictValue:
        metadata data conflict value
    setColorInterpretation:
        whether to force color interpretation of input bands to output bands
    overviewLevel:
        To specify which overview level of source files must be used
    callback:
        callback method
    callback_data:
        user data for callback
    """

# Only used for tests
    return_option_list = options == '__RETURN_OPTION_LIST__'
    if return_option_list:
        options = []
    else:
        options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if srcBands:
            for b in srcBands:
                new_options += ['-srcband', str(b)]
        if dstBands:
            for b in dstBands:
                new_options += ['-dstband', str(b)]
        if format is not None:
            new_options += ['-of', format]
        if outputType != gdalconst.GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType)]
        if workingType != gdalconst.GDT_Unknown:
            new_options += ['-wt', GetDataTypeName(workingType)]
        if outputBounds is not None:
            new_options += ['-te', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3])]
        if outputBoundsSRS is not None:
            new_options += ['-te_srs', str(outputBoundsSRS)]
        if xRes is not None and yRes is not None:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes)]
        if width != 0 or height != 0:
            new_options += ['-ts', str(width), str(height)]
        if srcSRS is not None:
            new_options += ['-s_srs', str(srcSRS)]
        if dstSRS is not None:
            new_options += ['-t_srs', str(dstSRS)]
        if coordinateOperation is not None:
            new_options += ['-ct', coordinateOperation]
        if targetAlignedPixels:
            new_options += ['-tap']
        if srcAlpha:
            new_options += ['-srcalpha']
        elif srcAlpha is not None:
            new_options += ['-nosrcalpha']
        if dstAlpha:
            new_options += ['-dstalpha']
        if warpOptions is not None:
            if isinstance(warpOptions, dict):
                for k, v in warpOptions.items():
                    new_options += ['-wo', f'{k}={v}']
            else:
                for opt in warpOptions:
                    new_options += ['-wo', str(opt)]
        if errorThreshold is not None:
            new_options += ['-et', _strHighPrec(errorThreshold)]
        if resampleAlg is not None:

            mapMethodToString = {
                gdalconst.GRA_NearestNeighbour: 'near',
                gdalconst.GRA_Bilinear: 'bilinear',
                gdalconst.GRA_Cubic: 'cubic',
                gdalconst.GRA_CubicSpline: 'cubicspline',
                gdalconst.GRA_Lanczos: 'lanczos',
                gdalconst.GRA_Average: 'average',
                gdalconst.GRA_RMS: 'rms',
                gdalconst.GRA_Mode: 'mode',
                gdalconst.GRA_Max: 'max',
                gdalconst.GRA_Min: 'min',
                gdalconst.GRA_Med: 'med',
                gdalconst.GRA_Q1: 'q1',
                gdalconst.GRA_Q3: 'q3',
                gdalconst.GRA_Sum: 'sum',
            }

            if resampleAlg in mapMethodToString:
                new_options += ['-r', mapMethodToString[resampleAlg]]
            else:
                new_options += ['-r', str(resampleAlg)]
        if warpMemoryLimit is not None:
            new_options += ['-wm', str(warpMemoryLimit)]
        if creationOptions is not None:
            if isinstance(creationOptions, dict):
                for k, v in creationOptions.items():
                    new_options += ['-co', f'{k}={v}']
            else:
                for opt in creationOptions:
                    new_options += ['-co', opt]
        if srcNodata is not None:
            new_options += ['-srcnodata', str(srcNodata)]
        if dstNodata is not None:
            new_options += ['-dstnodata', str(dstNodata)]
        if multithread:
            new_options += ['-multi']
        if tps:
            new_options += ['-tps']
        if rpc:
            new_options += ['-rpc']
        if geoloc:
            new_options += ['-geoloc']
        if polynomialOrder is not None:
            new_options += ['-order', str(polynomialOrder)]
        if transformerOptions is not None:
            if isinstance(transformerOptions, dict):
                for k, v in transformerOptions.items():
                    new_options += ['-to', opt]
            else:
                for opt in transformerOptions:
                    new_options += ['-to', opt]
        if cutlineDSName is not None:
            new_options += ['-cutline', str(cutlineDSName)]
        if cutlineLayer is not None:
            new_options += ['-cl', str(cutlineLayer)]
        if cutlineWhere is not None:
            new_options += ['-cwhere', str(cutlineWhere)]
        if cutlineSQL is not None:
            new_options += ['-csql', str(cutlineSQL)]
        if cutlineBlend is not None:
            new_options += ['-cblend', str(cutlineBlend)]
        if cropToCutline:
            new_options += ['-crop_to_cutline']
        if not copyMetadata:
            new_options += ['-nomd']
        if metadataConflictValue:
            new_options += ['-cvmd', str(metadataConflictValue)]
        if setColorInterpretation:
            new_options += ['-setci']

        if overviewLevel is None or isinstance(overviewLevel, str):
            pass
        elif isinstance(overviewLevel, int):
            if overviewLevel < 0:
                overviewLevel = 'AUTO' + str(overviewLevel)
            else:
                overviewLevel = str(overviewLevel)
        else:
            overviewLevel = None

        if overviewLevel is not None and overviewLevel != 'AUTO':
            new_options += ['-ovr', overviewLevel]

    if return_option_list:
        return new_options

    return (GDALWarpAppOptions(new_options), callback, callback_data)

def Warp(destNameOrDestDS, srcDSOrSrcDSTab, **kwargs):
    """Warp one or several datasets.

    Parameters
    ----------
    destNameOrDestDS:
        Output dataset name or object
    srcDSOrSrcDSTab:
        an array of Dataset objects or filenames, or a Dataset object or a filename
    kwargs:
        options: return of gdal.WarpOptions(), string or array of strings,
        other keywords arguments of gdal.WarpOptions().
        If options is provided as a gdal.WarpOptions() object, other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = WarpOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']

    import os

    if isinstance(srcDSOrSrcDSTab, (str, os.PathLike)):
        srcDSTab = [Open(srcDSOrSrcDSTab)]
    elif isinstance(srcDSOrSrcDSTab, list):
        srcDSTab = []
        for elt in srcDSOrSrcDSTab:
            if isinstance(elt, (str, os.PathLike)):
                srcDSTab.append(Open(elt))
            else:
                srcDSTab.append(elt)
    else:
        srcDSTab = [srcDSOrSrcDSTab]

    if isinstance(destNameOrDestDS, (str, os.PathLike)):
        return wrapper_GDALWarpDestName(destNameOrDestDS, srcDSTab, opts, callback, callback_data)
    else:
        return wrapper_GDALWarpDestDS(destNameOrDestDS, srcDSTab, opts, callback, callback_data)


def VectorTranslateOptions(options=None, format=None,
         accessMode=None,
         srcSRS=None, dstSRS=None, reproject=True,
         coordinateOperation=None,
         SQLStatement=None, SQLDialect=None, where=None, selectFields=None,
         addFields=False,
         forceNullable=False,
         emptyStrAsNull=False,
         spatFilter=None, spatSRS=None,
         datasetCreationOptions=None,
         layerCreationOptions=None,
         layers=None,
         layerName=None,
         geometryType=None,
         dim=None,
         transactionSize=None,
         clipSrc=None,
         clipSrcSQL=None,
         clipSrcLayer=None,
         clipSrcWhere=None,
         clipDst=None,
         clipDstSQL=None,
         clipDstLayer=None,
         clipDstWhere=None,
         preserveFID=False,
         simplifyTolerance=None,
         segmentizeMaxDist=None,
         makeValid=False,
         mapFieldType=None,
         explodeCollections=False,
         zField=None,
         resolveDomains=False,
         skipFailures=False,
         limit=None,
         callback=None, callback_data=None):
    """
    Create a VectorTranslateOptions() object that can be passed to
    gdal.VectorTranslate()

    Parameters
    ----------
    options:
        can be be an array of strings, a string or let empty and filled from other
        keywords.
    format:
        format ("ESRI Shapefile", etc...)
    accessMode:
        None for creation, 'update', 'append', 'upsert', 'overwrite'
    srcSRS:
        source SRS
    dstSRS:
        output SRS (with reprojection if reproject = True)
    coordinateOperation:
        coordinate operation as a PROJ string or WKT string
    reproject:
        whether to do reprojection
    SQLStatement:
        SQL statement to apply to the source dataset
    SQLDialect:
        SQL dialect ('OGRSQL', 'SQLITE', ...)
    where:
        WHERE clause to apply to source layer(s)
    selectFields:
        list of fields to select
    addFields:
        whether to add new fields found in source layers (to be used with
        accessMode == 'append' or 'upsert')
    forceNullable:
        whether to drop NOT NULL constraints on newly created fields
    emptyStrAsNull:
        whether to treat empty string values as NULL
    spatFilter:
        spatial filter as (minX, minY, maxX, maxY) bounding box
    spatSRS:
        SRS in which the spatFilter is expressed. If not specified, it is assumed to be
        the one of the layer(s)
    datasetCreationOptions:
        list or dict of dataset creation options
    layerCreationOptions:
        list or dict of layer creation options
    layers:
        list of layers to convert
    layerName:
        output layer name
    geometryType:
        output layer geometry type ('POINT', ....). May be an array of strings
        when using a special value like 'PROMOTE_TO_MULTI', 'CONVERT_TO_LINEAR',
        'CONVERT_TO_CURVE' combined with another one or a geometry type.
    dim:
        output dimension ('XY', 'XYZ', 'XYM', 'XYZM', 'layer_dim')
    transactionSize:
        number of features to save per transaction (default 100 000). Increase the value
        for better performance when writing into DBMS drivers that have transaction
        support. Set to "unlimited" to load the data into a single transaction.
    clipSrc:
        clip geometries to the specified bounding box (expressed in source SRS),
        WKT geometry (POLYGON or MULTIPOLYGON), from a datasource or to the spatial
        extent of the -spat option if you use the "spat_extent" keyword. When
        specifying a datasource, you will generally want to use it in combination with
        the clipSrcLayer, clipSrcWhere or clipSrcSQL options.
    clipSrcSQL:
        select desired geometries using an SQL query instead.
    clipSrcLayer:
        select the named layer from the source clip datasource.
    clipSrcWhere:
        restrict desired geometries based on attribute query.
    clipDst:
        clip geometries after reprojection to the specified bounding box (expressed in
        dest SRS), WKT geometry (POLYGON or MULTIPOLYGON) or from a datasource. When
        specifying a datasource, you will generally want to use it in combination of
        the clipDstLayer, clipDstWhere or clipDstSQL options.
    clipDstSQL:
        select desired geometries using an SQL query instead.
    clipDstLayer:
        select the named layer from the destination clip datasource.
    clipDstWhere:
        restrict desired geometries based on attribute query.
    simplifyTolerance:
        distance tolerance for simplification. The algorithm used preserves topology per
        feature, in particular for polygon geometries, but not for a whole layer.
    segmentizeMaxDist:
        maximum distance between consecutive nodes of a line geometry
    makeValid:
        run MakeValid() on geometries
    mapFieldType:
        converts any field of the specified type to another type. Valid types are:
        Integer, Integer64, Real, String, Date, Time, DateTime, Binary, IntegerList,
        Integer64List, RealList, StringList. Types can also include subtype between
        parenthesis, such as Integer(Boolean), Real(Float32),... Special value All can
        be used to convert all fields to another type. This is an alternate way to using
        the CAST operator of OGR SQL, that may avoid typing a long SQL query.
        Note that this does not influence the field types used by the source driver,
        and is only an afterwards conversion.
    explodeCollections:
        produce one feature for each geometry in any kind of geometry collection in the
        source file, applied after any -sql option. This option is not compatible with
        preserveFID but a SQLStatement (e.g. SELECT fid AS original_fid, * FROM ...)
        can be used to store the original FID if needed.
    preserveFID:
        Use the FID of the source features instead of letting the output driver automatically
        assign a new one (for formats that require a FID). If not in append mode, this behavior
        is the default if the output driver has a FID  layer  creation  option,  in which case
        the name of the source FID column will be used and source feature IDs will be attempted
        to be preserved. This behavior can be disabled by setting -unsetFid.
        This option is not compatible with explodeCollections
    zField:
        name of field to use to set the Z component of geometries
    resolveDomains:
        whether to create an additional field for each field associated with a coded
        field domain.
    skipFailures:
        whether to skip failures
    limit:
        maximum number of features to read per layer
    callback:
        callback method
    callback_data:
        user data for callback
    """

# Only used for tests
    return_option_list = options == '__RETURN_OPTION_LIST__'
    if return_option_list:
        options = []
    else:
        options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-f', format]
        if srcSRS is not None:
            new_options += ['-s_srs', str(srcSRS)]
        if dstSRS is not None:
            if reproject:
                new_options += ['-t_srs', str(dstSRS)]
            else:
                new_options += ['-a_srs', str(dstSRS)]
        if coordinateOperation is not None:
            new_options += ['-ct', coordinateOperation]
        if SQLStatement is not None:
            new_options += ['-sql', str(SQLStatement)]
        if SQLDialect is not None:
            new_options += ['-dialect', str(SQLDialect)]
        if where is not None:
            new_options += ['-where', str(where)]
        if accessMode is not None:
            if accessMode == 'update':
                new_options += ['-update']
            elif accessMode == 'append':
                new_options += ['-append']
            elif accessMode == 'overwrite':
                new_options += ['-overwrite']
            elif accessMode == 'upsert':
                new_options += ['-upsert']
            else:
                raise Exception('unhandled accessMode')
        if addFields:
            new_options += ['-addfields']
        if forceNullable:
            new_options += ['-forceNullable']
        if emptyStrAsNull:
            new_options += ['-emptyStrAsNull']
        if selectFields is not None:
            val = ''
            for item in selectFields:
                if val:
                    val += ','
                val += item
            new_options += ['-select', val]

        if datasetCreationOptions is not None:
            if isinstance(datasetCreationOptions, dict):
                for k, v in datasetCreationOptions.items():
                    new_options += ['-dsco', f'{k}={v}']
            else:
                for opt in datasetCreationOptions:
                    new_options += ['-dsco', opt]

        if layerCreationOptions is not None:
            if isinstance(layerCreationOptions, dict):
                for k, v in layerCreationOptions.items():
                    new_options += ['-lco', f'{k}={v}']
            else:
                for opt in layerCreationOptions:
                    new_options += ['-lco', opt]

        if layers is not None:
            if isinstance(layers, str):
                new_options += [layers]
            else:
                for lyr in layers:
                    new_options += [lyr]

        if transactionSize is not None:
            new_options += ['-gt', str(transactionSize)]

        if clipSrc is not None:
            import os

            new_options += ['-clipsrc']
            if isinstance(clipSrc, str):
                new_options += [clipSrc]
            elif isinstance(clipSrc, os.PathLike):
                new_options += [str(clipSrc)]
            else:
                try:
                    new_options += [
                        str(clipSrc[0]),
                        str(clipSrc[1]),
                        str(clipSrc[2]),
                        str(clipSrc[3])
                    ]
                except Exception as ex:
                    raise ValueError(f"invalid value for clipSrc: {clipSrc}") from ex
        if clipSrcSQL is not None:
            new_options += ['-clipsrcsql', str(clipSrcSQL)]
        if clipSrcLayer is not None:
            new_options += ['-clipsrclayer', str(clipSrcLayer)]
        if clipSrcWhere is not None:
            new_options += ['-clipsrcwhere', str(clipSrcWhere)]

        if clipDst is not None:
            import os

            new_options += ['-clipdst']
            if isinstance(clipDst, str):
                new_options += [clipDst]
            elif isinstance(clipDst, os.PathLike):
                new_options += [str(clipDst)]
            else:
                try:
                    new_options += [
                        str(clipDst[0]),
                        str(clipDst[1]),
                        str(clipDst[2]),
                        str(clipDst[3])
                    ]
                except Exception as ex:
                    raise ValueError(f"invalid value for clipDst: {clipDst}") from ex
        if clipDstSQL is not None:
            new_options += ['-clipdstsql', str(clipDstSQL)]
        if clipDstLayer is not None:
            new_options += ['-clipdstlayer', str(clipDstLayer)]
        if clipDstWhere is not None:
            new_options += ['-clipdstwhere', str(clipDstWhere)]

        if simplifyTolerance is not None:
            new_options += ['-simplify', str(simplifyTolerance)]
        if segmentizeMaxDist is not None:
            new_options += ['-segmentize', str(segmentizeMaxDist)]
        if makeValid:
            new_options += ['-makevalid']
        if mapFieldType is not None:
            new_options += ['-mapFieldType']
            if isinstance(mapFieldType, str):
                new_options += [mapFieldType]
            else:
                new_options += [",".join(mapFieldType)]
        if explodeCollections:
            new_options += ['-explodecollections']
        if preserveFID:
            new_options += ['-preserve_fid']
        if spatFilter is not None:
            new_options += [
                '-spat',
                str(spatFilter[0]),
                str(spatFilter[1]),
                str(spatFilter[2]),
                str(spatFilter[3])
            ]
        if spatSRS is not None:
            new_options += ['-spat_srs', str(spatSRS)]
        if layerName is not None:
            new_options += ['-nln', layerName]
        if geometryType is not None:
            if isinstance(geometryType, str):
                new_options += ['-nlt', geometryType]
            else:
                for opt in geometryType:
                    new_options += ['-nlt', opt]
        if dim is not None:
            new_options += ['-dim', dim]
        if zField is not None:
            new_options += ['-zfield', zField]
        if resolveDomains:
            new_options += ['-resolveDomains']
        if skipFailures:
            new_options += ['-skip']
        if limit is not None:
            new_options += ['-limit', str(limit)]
    if callback is not None:
        new_options += ['-progress']

    if return_option_list:
        return new_options

    return (GDALVectorTranslateOptions(new_options), callback, callback_data)


def VectorTranslate(destNameOrDestDS, srcDS, **kwargs):
    """Convert one vector dataset

    Parameters
    ----------
    destNameOrDestDS:
        Output dataset name or object
    srcDS:
        a Dataset object or a filename
    kwargs:
        options: return of gdal.VectorTranslateOptions(), string or array of strings,
        other keywords arguments of gdal.VectorTranslateOptions().
        If options is provided as a gdal.VectorTranslateOptions() object,
        other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = VectorTranslateOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']

    import os

    if isinstance(srcDS, (str, os.PathLike)):
        srcDS = OpenEx(srcDS, gdalconst.OF_VECTOR)

    if isinstance(destNameOrDestDS, (str, os.PathLike)):
        return wrapper_GDALVectorTranslateDestName(destNameOrDestDS, srcDS, opts, callback, callback_data)
    else:
        return wrapper_GDALVectorTranslateDestDS(destNameOrDestDS, srcDS, opts, callback, callback_data)

def DEMProcessingOptions(options=None, colorFilename=None, format=None,
              creationOptions=None, computeEdges=False, alg=None, band=1,
              zFactor=None, scale=None, azimuth=None, altitude=None,
              combined=False, multiDirectional=False, igor=False,
              slopeFormat=None, trigonometric=False, zeroForFlat=False,
              addAlpha=None, colorSelection=None,
              callback=None, callback_data=None):
    """Create a DEMProcessingOptions() object that can be passed to gdal.DEMProcessing()

    Parameters
    ----------
    options:
        can be be an array of strings, a string or let empty and filled from other keywords.
    colorFilename:
        (mandatory for "color-relief") name of file that contains palette definition for the "color-relief" processing.
    format:
        output format ("GTiff", etc...)
    creationOptions:
        list or dict of creation options
    computeEdges:
        whether to compute values at raster edges.
    alg:
        'Horn' (default) or 'ZevenbergenThorne' for hillshade, slope or aspect. 'Wilson' (default) or 'Riley' for TRI
    band:
        source band number to use
    zFactor:
        (hillshade only) vertical exaggeration used to pre-multiply the elevations.
    scale:
        ratio of vertical units to horizontal.
    azimuth:
        (hillshade only) azimuth of the light, in degrees. 0 if it comes from the top of the raster, 90 from the east, ... The default value, 315, should rarely be changed as it is the value generally used to generate shaded maps.
    altitude:
        (hillshade only) altitude of the light, in degrees. 90 if the light comes from above the DEM, 0 if it is raking light.
    combined:
        (hillshade only) whether to compute combined shading, a combination of slope and oblique shading. Only one of combined, multiDirectional and igor can be specified.
    multiDirectional:
        (hillshade only) whether to compute multi-directional shading. Only one of combined, multiDirectional and igor can be specified.
    igor:
        (hillshade only) whether to use Igor's hillshading from Maperitive.  Only one of combined, multiDirectional and igor can be specified.
    slopeFormat:
        (slope only) "degree" or "percent".
    trigonometric:
        (aspect only) whether to return trigonometric angle instead of azimuth. Thus 0deg means East, 90deg North, 180deg West, 270deg South.
    zeroForFlat:
        (aspect only) whether to return 0 for flat areas with slope=0, instead of -9999.
    addAlpha:
        adds an alpha band to the output file (only for processing = 'color-relief')
    colorSelection:
        (color-relief only) Determines how color entries are selected from an input value. Can be "nearest_color_entry", "exact_color_entry" or "linear_interpolation". Defaults to "linear_interpolation"
    callback:
        callback method
    callback_data:
        user data for callback
    """
# Only used for tests
    return_option_list = options == '__RETURN_OPTION_LIST__'
    if return_option_list:
        options = []
    else:
        options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if creationOptions is not None:
            if isinstance(creationOptions, dict):
                for k, v in creationOptions.items():
                    new_options += ['-co', f'{k}={v}']
            else:
                for opt in creationOptions:
                    new_options += ['-co', opt]
        if computeEdges:
            new_options += ['-compute_edges']
        if alg:
            new_options += ['-alg', alg]
        new_options += ['-b', str(band)]
        if zFactor is not None:
            new_options += ['-z', str(zFactor)]
        if scale is not None:
            new_options += ['-s', str(scale)]
        if azimuth is not None:
            new_options += ['-az', str(azimuth)]
        if altitude is not None:
            new_options += ['-alt', str(altitude)]
        if combined:
            new_options += ['-combined']
        if multiDirectional:
            new_options += ['-multidirectional']
        if igor:
            new_options += ['-igor']
        if slopeFormat == 'percent':
            new_options += ['-p']
        if trigonometric:
            new_options += ['-trigonometric']
        if zeroForFlat:
            new_options += ['-zero_for_flat']
        if colorSelection is not None:
            if colorSelection == 'nearest_color_entry':
                new_options += ['-nearest_color_entry']
            elif colorSelection == 'exact_color_entry':
                new_options += ['-exact_color_entry']
            elif colorSelection == 'linear_interpolation':
                pass
            else:
                raise ValueError("Unsupported value for colorSelection")
        if addAlpha:
            new_options += ['-alpha']

    if return_option_list:
        return new_options

    return (GDALDEMProcessingOptions(new_options), colorFilename, callback, callback_data)

def DEMProcessing(destName, srcDS, processing, **kwargs):
    """Apply a DEM processing.

    Parameters
    ----------
    destName:
        Output dataset name
    srcDS:
        a Dataset object or a filename
    processing:
        one of "hillshade", "slope", "aspect", "color-relief", "TRI", "TPI", "Roughness"
    kwargs:
        options: return of gdal.DEMProcessingOptions(), string or array of strings,
        other keywords arguments of gdal.DEMProcessingOptions().
        If options is provided as a gdal.DEMProcessingOptions() object,
        other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, colorFilename, callback, callback_data) = DEMProcessingOptions(**kwargs)
    else:
        (opts, colorFilename, callback, callback_data) = kwargs['options']

    import os

    if isinstance(srcDS, (str, os.PathLike)):
        srcDS = Open(srcDS)

    if isinstance(colorFilename, os.PathLike):
        colorFilename = str(colorFilename)

    return DEMProcessingInternal(destName, srcDS, processing, colorFilename, opts, callback, callback_data)


def NearblackOptions(options=None, format=None,
         creationOptions=None, white = False, colors=None,
         maxNonBlack=None, nearDist=None, setAlpha = False, setMask = False,
         alg=None,
         callback=None, callback_data=None):
    """Create a NearblackOptions() object that can be passed to gdal.Nearblack()

    Parameters
    ----------
    options:
        can be be an array of strings, a string or let empty and filled from other keywords.
    format:
        output format ("GTiff", etc...)
    creationOptions:
        list or dict of creation options
    white:
        whether to search for nearly white (255) pixels instead of nearly black pixels.
    colors:
        list of colors  to search for, e.g. ((0,0,0),(255,255,255)). The pixels that are considered as the collar are set to 0
    maxNonBlack:
        number of non-black (or other searched colors specified with white / colors) pixels that can be encountered before the giving up search inwards. Defaults to 2.
    nearDist:
        select how far from black, white or custom colors the pixel values can be and still considered near black, white or custom color.  Defaults to 15.
    setAlpha:
        adds an alpha band to the output file.
    setMask:
        adds a mask band to the output file.
    alg:
        "twopasses" (default), or "floodfill"
    callback:
        callback method
    callback_data:
        user data for callback
    """
# Only used for tests
    return_option_list = options == '__RETURN_OPTION_LIST__'
    if return_option_list:
        options = []
    else:
        options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if creationOptions is not None:
            if isinstance(creationOptions, dict):
                for k, v in creationOptions.items():
                    new_options += ['-co', f'{k}={v}']
            else:
                for opt in creationOptions:
                    new_options += ['-co', opt]
        if white:
            new_options += ['-white']
        if colors is not None:
            for color in colors:
                color_str = ''
                for cpt in color:
                    if color_str != '':
                        color_str += ','
                    color_str += str(cpt)
                new_options += ['-color', color_str]
        if maxNonBlack is not None:
            new_options += ['-nb', str(maxNonBlack)]
        if nearDist is not None:
            new_options += ['-near', str(nearDist)]
        if setAlpha:
            new_options += ['-setalpha']
        if setMask:
            new_options += ['-setmask']
        if alg:
            new_options += ['-alg', alg]

    if return_option_list:
        return new_options

    return (GDALNearblackOptions(new_options), callback, callback_data)

def Nearblack(destNameOrDestDS, srcDS, **kwargs):
    """Convert nearly black/white borders to exact value.

    Parameters
    ----------
    destNameOrDestDS:
        Output dataset name or object
    srcDS:
        a Dataset object or a filename
    kwargs:
        options: return of gdal.NearblackOptions(), string or array of strings,
        other keywords arguments of gdal.NearblackOptions().
        If options is provided as a gdal.NearblackOptions() object, other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = NearblackOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']

    import os

    if isinstance(srcDS, (str, os.PathLike)):
        srcDS = OpenEx(srcDS)

    if isinstance(destNameOrDestDS, (str, os.PathLike)):
        return wrapper_GDALNearblackDestName(destNameOrDestDS, srcDS, opts, callback, callback_data)
    else:
        return wrapper_GDALNearblackDestDS(destNameOrDestDS, srcDS, opts, callback, callback_data)


def GridOptions(options=None, format=None,
              outputType=gdalconst.GDT_Unknown,
              width=0, height=0,
              creationOptions=None,
              outputBounds=None,
              outputSRS=None,
              noData=None,
              algorithm=None,
              layers=None,
              SQLStatement=None,
              where=None,
              spatFilter=None,
              zfield=None,
              z_increase=None,
              z_multiply=None,
              callback=None, callback_data=None):
    """ Create a GridOptions() object that can be passed to gdal.Grid()

    Parameters
    ----------
    options:
        can be be an array of strings, a string or let empty and filled from other keywords.
    format:
        output format ("GTiff", etc...)
    outputType:
        output type (gdalconst.GDT_Byte, etc...)
    width:
        width of the output raster in pixel
    height:
        height of the output raster in pixel
    creationOptions:
        list or dict of creation options
    outputBounds:
        assigned output bounds:
        [ulx, uly, lrx, lry]
    outputSRS:
        assigned output SRS
    noData:
        nodata value
    algorithm:
        e.g "invdist:power=2.0:smoothing=0.0:radius1=0.0:radius2=0.0:angle=0.0:max_points=0:min_points=0:nodata=0.0"
    layers:
        list of layers to convert
    SQLStatement:
        SQL statement to apply to the source dataset
    where:
        WHERE clause to apply to source layer(s)
    spatFilter:
        spatial filter as (minX, minY, maxX, maxY) bounding box
    zfield:
        Identifies an attribute field on the features to be used to get a Z value from.
        This value overrides Z value read from feature geometry record.
    z_increase:
        Addition to the attribute field on the features to be used to get a Z value from.
        The addition should be the same unit as Z value. The result value will be
        Z value + Z increase value. The default value is 0.
    z_multiply:
        Multiplication ratio for Z field. This can be used for shift from e.g. foot to meters
        or from  elevation to deep. The result value will be
        (Z value + Z increase value) * Z multiply value. The default value is 1.
    callback:
        callback method
    callback_data:
        user data for callback
    """
# Only used for tests
    return_option_list = options == '__RETURN_OPTION_LIST__'

    if return_option_list:
        options = []
    else:
        options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if outputType != gdalconst.GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType)]
        if width != 0 or height != 0:
            new_options += ['-outsize', str(width), str(height)]
        if creationOptions is not None:
            if isinstance(creationOptions, dict):
                for k, v in creationOptions.items():
                    new_options += ['-co', f'{k}={v}']
            else:
                for opt in creationOptions:
                    new_options += ['-co', opt]
        if outputBounds is not None:
            new_options += ['-txe', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[2]), '-tye', _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[3])]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS)]
        if algorithm is not None:
            new_options += ['-a', algorithm]
        if layers is not None:
            if isinstance(layers, (tuple, list)):
                for layer in layers:
                    new_options += ['-l', layer]
            else:
                new_options += ['-l', layers]
        if SQLStatement is not None:
            new_options += ['-sql', str(SQLStatement)]
        if where is not None:
            new_options += ['-where', str(where)]
        if zfield is not None:
            new_options += ['-zfield', zfield]
        if z_increase is not None:
            new_options += ['-z_increase', str(z_increase)]
        if z_multiply is not None:
            new_options += ['-z_multiply', str(z_multiply)]
        if spatFilter is not None:
            new_options += ['-spat', str(spatFilter[0]), str(spatFilter[1]), str(spatFilter[2]), str(spatFilter[3])]

    if return_option_list:
        return new_options

    return (GDALGridOptions(new_options), callback, callback_data)

def Grid(destName, srcDS, **kwargs):
    """ Create raster from the scattered data.

    Parameters
    ----------
    destName:
        Output dataset name
    srcDS:
        a Dataset object or a filename
    kwargs:
        options: return of gdal.GridOptions(), string or array of strings,
        other keywords arguments of gdal.GridOptions()
        If options is provided as a gdal.GridOptions() object, other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = GridOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']

    import os

    if isinstance(srcDS, (str, os.PathLike)):
        srcDS = OpenEx(srcDS, gdalconst.OF_VECTOR)

    return GridInternal(destName, srcDS, opts, callback, callback_data)

def RasterizeOptions(options=None, format=None,
         outputType=gdalconst.GDT_Unknown,
         creationOptions=None, noData=None, initValues=None,
         outputBounds=None, outputSRS=None,
         transformerOptions=None,
         width=None, height=None,
         xRes=None, yRes=None, targetAlignedPixels=False,
         bands=None, inverse=False, allTouched=False,
         burnValues=None, attribute=None, useZ=False, layers=None,
         SQLStatement=None, SQLDialect=None, where=None, optim=None,
         add=None,
         callback=None, callback_data=None):
    """Create a RasterizeOptions() object that can be passed to gdal.Rasterize()

    Parameters
    ----------
    options:
        can be be an array of strings, a string or let empty and filled from other keywords.
    format:
        output format ("GTiff", etc...)
    outputType:
        output type (gdalconst.GDT_Byte, etc...)
    creationOptions:
        list or dict of creation options
    outputBounds:
        assigned output bounds:
        [minx, miny, maxx, maxy]
    outputSRS:
        assigned output SRS
    transformerOptions:
        list or dict of transformer options
    width:
        width of the output raster in pixel
    height:
        height of the output raster in pixel
    xRes, yRes:
        output resolution in target SRS
    targetAlignedPixels:
        whether to force output bounds to be multiple of output resolution
    noData:
        nodata value
    initValues:
        Value or list of values to pre-initialize the output image bands with.
         However, it is not marked as the nodata value in the output file.
          If only one value is given, the same value is used in all the bands.
    bands:
        list of output bands to burn values into
    inverse:
        whether to invert rasterization, i.e. burn the fixed burn value, or the
        burn value associated with the first feature into all parts of the image
        not inside the provided a polygon.
    allTouched:
        whether to enable the ALL_TOUCHED rasterization option so that all pixels
        touched by lines or polygons will be updated, not just those on the line
        render path, or whose center point is within the polygon.
    burnValues:
        list of fixed values to burn into each band for all objects.
        Excusive with attribute.
    attribute:
        identifies an attribute field on the features to be used for a burn-in value.
        The value will be burned into all output bands. Excusive with burnValues.
    useZ:
        whether to indicate that a burn value should be extracted from the "Z" values
        of the feature. These values are added to the burn value given by burnValues
        or attribute if provided. As of now, only points and lines are drawn in 3D.
    layers:
        list of layers from the datasource that will be used for input features.
    SQLStatement:
        SQL statement to apply to the source dataset
    SQLDialect:
        SQL dialect ('OGRSQL', 'SQLITE', ...)
    where:
        WHERE clause to apply to source layer(s)
    optim:
        optimization mode ('RASTER', 'VECTOR')
    add:
        set to True to use additive mode instead of replace when burning values
    callback:
        callback method
    callback_data:
        user data for callback
    """

# Only used for tests
    return_option_list = options == '__RETURN_OPTION_LIST__'

    if return_option_list:
        options = []
    else:
        options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if outputType != gdalconst.GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType)]
        if creationOptions is not None:
            if isinstance(creationOptions, dict):
                for k, v in creationOptions.items():
                    new_options += ['-co', f'{k}={v}']
            else:
                for opt in creationOptions:
                    new_options += ['-co', opt]
        if bands is not None:
            for b in bands:
                new_options += ['-b', str(b)]
        if noData is not None:
            new_options += ['-a_nodata', str(noData)]
        if initValues is not None:
            if isinstance(initValues, (tuple, list)):
                for val in initValues:
                    new_options += ['-init', str(val)]
            else:
                new_options += ['-init', str(initValues)]
        if outputBounds is not None:
            new_options += ['-te', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3])]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS)]
        if transformerOptions is not None:
            if isinstance(transformerOptions, dict):
                for k, v in transformerOptions.items():
                    new_options += ['-to', f'{k}={v}']
            else:
                for opt in transformerOptions:
                    new_options += ['-to', opt]
        if width is not None and height is not None:
            new_options += ['-ts', str(width), str(height)]
        if xRes is not None and yRes is not None:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes)]
        if targetAlignedPixels:
            new_options += ['-tap']
        if inverse:
            new_options += ['-i']
        if allTouched:
            new_options += ['-at']
        if burnValues is not None:
            if attribute is not None:
                raise Exception('burnValues and attribute option are exclusive.')
            if isinstance(burnValues, (tuple, list)):
                for val in burnValues:
                    new_options += ['-burn', str(val)]
            else:
                new_options += ['-burn', str(burnValues)]
        if attribute is not None:
            new_options += ['-a', attribute]
        if useZ:
            new_options += ['-3d']
        if layers is not None:
            if isinstance(layers, ((tuple, list))):
                for layer in layers:
                    new_options += ['-l', layer]
            else:
                new_options += ['-l', layers]
        if SQLStatement is not None:
            new_options += ['-sql', str(SQLStatement)]
        if SQLDialect is not None:
            new_options += ['-dialect', str(SQLDialect)]
        if where is not None:
            new_options += ['-where', str(where)]
        if optim is not None:
            new_options += ['-optim', str(optim)]
        if add:
            new_options += ['-add']

    if return_option_list:
        return new_options

    return (GDALRasterizeOptions(new_options), callback, callback_data)

def Rasterize(destNameOrDestDS, srcDS, **kwargs):
    """Burns vector geometries into a raster

    Parameters
    ----------
    destNameOrDestDS:
        Output dataset name or object
    srcDS:
        a Dataset object or a filename
    kwargs:
        options: return of gdal.RasterizeOptions(), string or array of strings,
        other keywords arguments of gdal.RasterizeOptions()
        If options is provided as a gdal.RasterizeOptions() object, other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    import os

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = RasterizeOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if isinstance(srcDS, (str, os.PathLike)):
        srcDS = OpenEx(srcDS, gdalconst.OF_VECTOR)

    if isinstance(destNameOrDestDS, (str, os.PathLike)):
        return wrapper_GDALRasterizeDestName(destNameOrDestDS, srcDS, opts, callback, callback_data)
    else:
        return wrapper_GDALRasterizeDestDS(destNameOrDestDS, srcDS, opts, callback, callback_data)


def FootprintOptions(options=None,
                     format=None,
                     bands=None,
                     combineBands=None,
                     srcNodata=None,
                     ovr=None,
                     targetCoordinateSystem=None,
                     dstSRS=None,
                     splitPolys=None,
                     convexHull=None,
                     densify=None,
                     simplify=None,
                     maxPoints=None,
                     minRingArea=None,
                     layerName=None,
                     layerCreationOptions=None,
                     datasetCreationOptions=None,
                     callback=None, callback_data=None):
    """Create a FootprintOptions() object that can be passed to gdal.Footprint()

    Parameters
    ----------
    options:
        can be be an array of strings, a string or let empty and filled from other keywords.
    format:
        output format ("GeoJSON", etc...)
    bands:
        list of output bands to burn values into
    combineBands:
        how to combine bands: "union" (default) or "intersection"
    srcNodata:
        source nodata value(s).
    ovr:
        overview index.
    targetCoordinateSystem:
        "pixel" or "georef"
    dstSRS:
        output SRS
    datasetCreationOptions:
        list or dict of dataset creation options
    layerCreationOptions:
        list or dict of layer creation options
    splitPolys:
        whether to split multipolygons as several polygons
    convexHull:
        whether to compute the convex hull of polygons/multipolygons
    densify:
        tolerance value for polygon densification
    simplify:
        tolerance value for polygon simplification
    maxPoints:
        maximum number of points (100 by default, "unlimited" for unlimited)
    minRingArea:
        Minimum value for the area of a ring The unit of the area is in square pixels if targetCoordinateSystem equals "pixel", or otherwise in georeferenced units of the target vector dataset. This option is applied after the reprojection implied by dstSRS
    layerName:
        output layer name
    callback:
        callback method
    callback_data:
        user data for callback
    """

# Only used for tests
    return_option_list = options == '__RETURN_OPTION_LIST__'

    if return_option_list:
        options = []
    else:
        options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if bands is not None:
            for b in bands:
                new_options += ['-b', str(b)]
        if combineBands:
            new_options += ["-combine_bands", combineBands]
        if targetCoordinateSystem:
            new_options += ["-t_cs", targetCoordinateSystem]
        if dstSRS:
            new_options += ["-t_srs", dstSRS]
        if srcNodata is not None:
            new_options += ['-srcnodata', str(srcNodata)]
        if ovr is not None:
            new_options += ['-ovr', str(ovr)]
        if splitPolys:
            new_options += ["-split_polys"]
        if convexHull:
            new_options += ["-convex_hull"]
        if densify is not None:
            new_options += ['-densify', str(densify)]
        if simplify is not None:
            new_options += ['-simplify', str(simplify)]
        if maxPoints is not None:
            new_options += ['-max_points', str(maxPoints)]
        if minRingArea is not None:
            new_options += ['-min_ring_area', str(minRingArea)]
        if layerName is not None:
            new_options += ['-lyr_name', layerName]
        if datasetCreationOptions is not None:
            if isinstance(datasetCreationOptions, dict):
                for k, v in datasetCreationOptions.items():
                    new_options += ['-dsco', f'{k}={v}']
            else:
                for opt in datasetCreationOptions:
                    new_options += ['-dsco', opt]
        if layerCreationOptions is not None:
            if isinstance(layerCreationOptions, dict):
                for k, v in layerCreationOptions.items():
                    new_options += ['-lco', f'{k}={v}']
            else:
                for opt in layerCreationOptions:
                    new_options += ['-lco', opt]

    if return_option_list:
        return new_options

    return (GDALFootprintOptions(new_options), callback, callback_data)

def Footprint(destNameOrDestDS, srcDS, **kwargs):
    """Compute the footprint of a raster

    Parameters
    ----------
    destNameOrDestDS:
        Output dataset name or object
    srcDS:
        a Dataset object or a filename
    kwargs:
        options: return of gdal.FootprintOptions(), string or array of strings,
        other keywords arguments of gdal.FootprintOptions()
        If options is provided as a gdal.FootprintOptions() object, other keywords are ignored.

    Examples
    --------

    1. Special mode to get deserialized GeoJSON (in EPSG:4326 if dstSRS not specified):

    >>> deserialized_geojson = gdal.FootPrint(None, src_ds, format="GeoJSON")

    2. Special mode to get WKT:

    >>> wkt = gdal.FootPrint(None, src_ds, format="WKT")

    3. Get result in a GeoPackage

    >>> gdal.FootPrintf("out.gpkg", src_ds, format="GPKG")

    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    inline_geojson_requested = (destNameOrDestDS is None or destNameOrDestDS == "") and \
        "format" in kwargs and kwargs["format"] == "GeoJSON"
    if inline_geojson_requested and "dstSRS" not in kwargs:
        import copy
        kwargs = copy.copy(kwargs)
        kwargs["dstSRS"] = "EPSG:4326"

    wkt_requested = (destNameOrDestDS is None or destNameOrDestDS == "") and \
        "format" in kwargs and kwargs["format"] == "WKT"
    if wkt_requested:
        import copy
        kwargs = copy.copy(kwargs)
        kwargs["format"] = "GeoJSON"

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = FootprintOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']

    import os

    if isinstance(srcDS, (str, os.PathLike)):
        srcDS = OpenEx(srcDS, gdalconst.OF_RASTER)

    if inline_geojson_requested or wkt_requested:
        import uuid
        temp_filename = "/vsimem/" + str(uuid.uuid4())
        try:
            if not wrapper_GDALFootprintDestName(temp_filename, srcDS, opts, callback, callback_data):
                return None
            if inline_geojson_requested:
                f = VSIFOpenL(temp_filename, "rb")
                assert f
                VSIFSeekL(f, 0, 2) # SEEK_END
                size = VSIFTellL(f)
                VSIFSeekL(f, 0, 0) # SEEK_SET
                data = VSIFReadL(1, size, f)
                VSIFCloseL(f)
                import json
                return json.loads(data)
            else:
                assert wkt_requested
                ds = OpenEx(temp_filename)
                lyr = ds.GetLayer(0)
                wkts = []
                for f in lyr:
                    wkts.append(f.GetGeometryRef().ExportToWkt())
                if len(wkts) == 1:
                    return wkts[0]
                else:
                    return wkts
        finally:
            if VSIStatL(temp_filename):
                Unlink(temp_filename)

    import os

    if isinstance(destNameOrDestDS, (str, os.PathLike)):
        return wrapper_GDALFootprintDestName(destNameOrDestDS, srcDS, opts, callback, callback_data)
    else:
        return wrapper_GDALFootprintDestDS(destNameOrDestDS, srcDS, opts, callback, callback_data)


def BuildVRTOptions(options=None,
                    resolution=None,
                    outputBounds=None,
                    xRes=None,
                    yRes=None,
                    targetAlignedPixels=None,
                    separate=None,
                    bandList=None,
                    addAlpha=None,
                    resampleAlg=None,
                    outputSRS=None,
                    allowProjectionDifference=None,
                    srcNodata=None,
                    VRTNodata=None,
                    hideNodata=None,
                    strict=False,
                    callback=None, callback_data=None):
    """Create a BuildVRTOptions() object that can be passed to gdal.BuildVRT()

    Parameters
    ----------
    options:l
        can be be an array of strings, a string or let empty and filled from other keywords.
    resolution:
        'highest', 'lowest', 'average', 'user'.
    outputBounds:l
        output bounds as (minX, minY, maxX, maxY) in target SRS.
    xRes:
        output resolution in target SRS.
    yRes:
        output resolution in target SRS.
    targetAlignedPixels:
        whether to force output bounds to be multiple of output resolution.
    separate:
        whether each source file goes into a separate stacked band in the VRT band.
    bandList:
        array of band numbers (index start at 1).
    addAlpha:
        whether to add an alpha mask band to the VRT when the source raster have none.
    resampleAlg:
        resampling mode.
    outputSRS:
        assigned output SRS.
    allowProjectionDifference:
        whether to accept input datasets have not the same projection.
        Note: they will *not* be reprojected.
    srcNodata:
        source nodata value(s).
    VRTNodata:
        nodata values at the VRT band level.
    hideNodata:
        whether to make the VRT band not report the NoData value.
    strict:
        set to True if warnings should be failures
    callback:
        callback method.
    callback_data:
        user data for callback.
    """

# Only used for tests
    return_option_list = options == '__RETURN_OPTION_LIST__'
    if return_option_list:
        options = []
    else:
        options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if resolution is not None:
            new_options += ['-resolution', str(resolution)]
        if outputBounds is not None:
            new_options += ['-te', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3])]
        if xRes is not None and yRes is not None:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes)]
        if targetAlignedPixels:
            new_options += ['-tap']
        if separate:
            new_options += ['-separate']
        if bandList != None:
            for b in bandList:
                new_options += ['-b', str(b)]
        if addAlpha:
            new_options += ['-addalpha']
        if resampleAlg is not None:
            if resampleAlg in mapGRIORAMethodToString:
                new_options += ['-r', mapGRIORAMethodToString[resampleAlg]]
            else:
                new_options += ['-r', str(resampleAlg)]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS)]
        if allowProjectionDifference:
            new_options += ['-allow_projection_difference']
        if srcNodata is not None:
            new_options += ['-srcnodata', str(srcNodata)]
        if VRTNodata is not None:
            new_options += ['-vrtnodata', str(VRTNodata)]
        if hideNodata:
            new_options += ['-hidenodata']
        if strict:
            new_options += ['-strict']

    if return_option_list:
        return new_options

    return (GDALBuildVRTOptions(new_options), callback, callback_data)

def BuildVRT(destName, srcDSOrSrcDSTab, **kwargs):
    """Build a VRT from a list of datasets.

    Parameters
    ----------
    destName:
        Output dataset name.
    srcDSOrSrcDSTab:
        An array of Dataset objects or filenames, or a Dataset object or a filename.
    kwargs:
        options: return of gdal.BuildVRTOptions(), string or array of strings,
        other keywords arguments of gdal.BuildVRTOptions().
        If options is provided as a gdal.BuildVRTOptions() object,
        other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = BuildVRTOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']

    srcDSTab = []
    srcDSNamesTab = []

    import os

    if isinstance(srcDSOrSrcDSTab, (str, os.PathLike)):
        srcDSNamesTab = [str(srcDSOrSrcDSTab)]
    elif isinstance(srcDSOrSrcDSTab, list):
        for elt in srcDSOrSrcDSTab:
            if isinstance(elt, (str, os.PathLike)):
                srcDSNamesTab.append(str(elt))
            else:
                srcDSTab.append(elt)
        if srcDSTab and srcDSNamesTab:
            raise Exception('Mix of names and dataset objects not supported')
    else:
        srcDSTab = [srcDSOrSrcDSTab]

    if srcDSTab:
        return BuildVRTInternalObjects(destName, srcDSTab, opts, callback, callback_data)
    else:
        return BuildVRTInternalNames(destName, srcDSNamesTab, opts, callback, callback_data)


def MultiDimTranslateOptions(options=None, format=None, creationOptions=None,
         arraySpecs=None, groupSpecs=None, subsetSpecs=None, scaleAxesSpecs=None,
         callback=None, callback_data=None):
    """Create a MultiDimTranslateOptions() object that can be passed to gdal.MultiDimTranslate()

    Parameters
    ----------
    options:
        can be be an array of strings, a string or let empty and filled from other keywords.
    format:
        output format ("GTiff", etc...)
    creationOptions:
        list or dict of creation options
    arraySpecs:
        list of array specifications, each of them being an array name or
        "name={src_array_name},dstname={dst_name},transpose=[1,0],view=[:,::-1]"
    groupSpecs:
        list of group specifications, each of them being a group name or
        "name={src_array_name},dstname={dst_name},recursive=no"
    subsetSpecs:
        list of subset specifications, each of them being like
        "{dim_name}({min_val},{max_val})" or "{dim_name}({slice_va})"
    scaleAxesSpecs:
        list of dimension scaling specifications, each of them being like
        "{dim_name}({scale_factor})"
    callback:
        callback method
    callback_data:
        user data for callback
    """

# Only used for tests
    return_option_list = options == '__RETURN_OPTION_LIST__'

    if return_option_list:
        options = []
    else:
        options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if creationOptions is not None:
            if isinstance(creationOptions, dict):
                for k, v in creationOptions.items():
                    new_options += ['-co', f'{k}={v}']
            else:
                for opt in creationOptions:
                    new_options += ['-co', opt]
        if arraySpecs is not None:
            for s in arraySpecs:
                new_options += ['-array', s]
        if groupSpecs is not None:
            for s in groupSpecs:
                new_options += ['-group', s]
        if subsetSpecs is not None:
            for s in subsetSpecs:
                new_options += ['-subset', s]
        if scaleAxesSpecs is not None:
            for s in scaleAxesSpecs:
                new_options += ['-scaleaxes', s]

    if return_option_list:
        return new_options

    return (GDALMultiDimTranslateOptions(new_options), callback, callback_data)

def MultiDimTranslate(destName, srcDSOrSrcDSTab, **kwargs):
    """MultiDimTranslate one or several datasets.

    Parameters
    ----------
    destName:
        Output dataset name
    srcDSOrSrcDSTab:
        an array of Dataset objects or filenames, or a Dataset object or a filename
    kwargs:
        options: return of gdal.MultiDimTranslateOptions(), string or array of strings
        other keywords arguments of gdal.MultiDimTranslateOptions().
        If options is provided as a gdal.MultiDimTranslateOptions() object,
        other keywords are ignored.
    """

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = MultiDimTranslateOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']

    import os

    if isinstance(srcDSOrSrcDSTab, (str, os.PathLike)):
        srcDSTab = [OpenEx(srcDSOrSrcDSTab, OF_VERBOSE_ERROR | OF_RASTER | OF_MULTIDIM_RASTER)]
    elif isinstance(srcDSOrSrcDSTab, list):
        srcDSTab = []
        for elt in srcDSOrSrcDSTab:
            if isinstance(elt, str):
                srcDSTab.append(OpenEx(elt, OF_VERBOSE_ERROR | OF_RASTER | OF_MULTIDIM_RASTER))
            else:
                srcDSTab.append(elt)
    else:
        srcDSTab = [srcDSOrSrcDSTab]

    return wrapper_GDALMultiDimTranslateDestName(destName, srcDSTab, opts, callback, callback_data)

# Logging Helpers
def _pylog_handler(err_level, err_no, err_msg):
    if err_no != gdalconst.CPLE_None:
        typ = _pylog_handler.errcode_map.get(err_no, str(err_no))
        message = "%s: %s" % (typ, err_msg)
    else:
        message = err_msg

    level = _pylog_handler.level_map.get(err_level, 20)  # default level is INFO
    _pylog_handler.logger.log(level, message)

def ConfigurePythonLogging(logger_name='gdal', enable_debug=False):
    """ Configure GDAL to use Python's logging framework """
    import logging

    _pylog_handler.logger = logging.getLogger(logger_name)

# map CPLE_* constants to names
    _pylog_handler.errcode_map = {_num: _name[5:] for _name, _num in gdalconst.__dict__.items() if _name.startswith('CPLE_')}

# Map GDAL log levels to Python's
    _pylog_handler.level_map = {
        CE_None: logging.INFO,
        CE_Debug: logging.DEBUG,
        CE_Warning: logging.WARN,
        CE_Failure: logging.ERROR,
        CE_Fatal: logging.CRITICAL,
    }

# Set CPL_DEBUG so debug messages are passed through the logger
    if enable_debug:
        SetConfigOption("CPL_DEBUG", "ON")

# Install as the default GDAL log handler
    SetErrorHandler(_pylog_handler)


def EscapeString(*args, **kwargs):
    """EscapeString(string_or_bytes, scheme = gdal.CPLES_SQL)"""
    if isinstance(args[0], bytes):
        return _gdal.EscapeBinary(*args, **kwargs)
    else:
        return _gdal.wrapper_EscapeString(*args, **kwargs)


def ApplyVerticalShiftGrid(*args, **kwargs):
    """ApplyVerticalShiftGrid(Dataset src_ds, Dataset grid_ds, bool inverse=False, double srcUnitToMeter=1.0, double dstUnitToMeter=1.0, char ** options=None) -> Dataset"""

    from warnings import warn
    warn('ApplyVerticalShiftGrid() will be removed in GDAL 4.0', DeprecationWarning)
    return _ApplyVerticalShiftGrid(*args, **kwargs)


import contextlib
@contextlib.contextmanager
def config_options(options, thread_local=True):
    """Temporarily define a set of configuration options.

       Parameters
       ----------
       options: dict
            Dictionary of configuration options passed as key, value
       thread_local: bool
            Whether the configuration options should be only set on the current
            thread. The default is True.

       Returns
       -------
            A context manager

       Example
       -------

           with gdal.config_options({"GDAL_NUM_THREADS": "ALL_CPUS"}):
               gdal.Warp("out.tif", "in.tif", dstSRS="EPSG:4326")
    """
    get_config_option = GetThreadLocalConfigOption if thread_local else GetGlobalConfigOption
    set_config_option = SetThreadLocalConfigOption if thread_local else SetConfigOption

    oldvals = {key: get_config_option(key) for key in options}

    for key in options:
        set_config_option(key, options[key])
    try:
        yield
    finally:
        for key in options:
            set_config_option(key, oldvals[key])


def config_option(key, value, thread_local=True):
    """Temporarily define a configuration option.

       Parameters
       ----------
       key: str
            Name of the configuration option
       value: str
            Value of the configuration option
       thread_local: bool
            Whether the configuration option should be only set on the current
            thread. The default is True.

       Returns
       -------
            A context manager

       Example
       -------

           with gdal.config_option("GDAL_NUM_THREADS", "ALL_CPUS"):
               gdal.Warp("out.tif", "in.tif", dstSRS="EPSG:4326")
    """
    return config_options({key: value}, thread_local=thread_local)


@contextlib.contextmanager
def quiet_errors():
    """Temporarily install an error handler that silents all warnings and errors.

       Returns
       -------
            A context manager

       Example
       -------

           with gdal.ExceptionMgr(useExceptions=False), gdal.quiet_errors():
               gdal.Error(gdal.CE_Failure, gdal.CPLE_AppDefined, "you will never see me")
    """
    PushErrorHandler("CPLQuietErrorHandler")
    try:
        yield
    finally:
        PopErrorHandler()


def Debug(*args):
    r"""Debug(char const * msg_class, char const * message)"""
    return _gdal.Debug(*args)

def SetErrorHandler(*args):
    r"""SetErrorHandler(CPLErrorHandler pfnErrorHandler=0) -> CPLErr"""
    return _gdal.SetErrorHandler(*args)

def SetCurrentErrorHandlerCatchDebug(*args):
    r"""SetCurrentErrorHandlerCatchDebug(int bCatchDebug)"""
    return _gdal.SetCurrentErrorHandlerCatchDebug(*args)

def PushErrorHandler(*args):
    r"""PushErrorHandler(CPLErrorHandler pfnErrorHandler=0) -> CPLErr"""
    return _gdal.PushErrorHandler(*args)

def PopErrorHandler(*args):
    r"""PopErrorHandler()"""
    return _gdal.PopErrorHandler(*args)

def Error(*args):
    r"""Error(CPLErr msg_class=CE_Failure, int err_code=0, char const * msg="error")"""
    return _gdal.Error(*args)

def GOA2GetAuthorizationURL(*args):
    r"""GOA2GetAuthorizationURL(char const * pszScope) -> retStringAndCPLFree *"""
    return _gdal.GOA2GetAuthorizationURL(*args)

def GOA2GetRefreshToken(*args):
    r"""GOA2GetRefreshToken(char const * pszAuthToken, char const * pszScope) -> retStringAndCPLFree *"""
    return _gdal.GOA2GetRefreshToken(*args)

def GOA2GetAccessToken(*args):
    r"""GOA2GetAccessToken(char const * pszRefreshToken, char const * pszScope) -> retStringAndCPLFree *"""
    return _gdal.GOA2GetAccessToken(*args)

def ErrorReset(*args):
    r"""ErrorReset()"""
    return _gdal.ErrorReset(*args)

def wrapper_EscapeString(*args, **kwargs):
    r"""wrapper_EscapeString(int len, int scheme=CPLES_SQL) -> retStringAndCPLFree *"""
    return _gdal.wrapper_EscapeString(*args, **kwargs)

def EscapeBinary(*args, **kwargs):
    r"""EscapeBinary(int len, int scheme=CPLES_SQL)"""
    return _gdal.EscapeBinary(*args, **kwargs)

def GetLastErrorNo(*args):
    r"""GetLastErrorNo() -> int"""
    return _gdal.GetLastErrorNo(*args)

def GetLastErrorType(*args):
    r"""GetLastErrorType() -> int"""
    return _gdal.GetLastErrorType(*args)

def GetLastErrorMsg(*args):
    r"""GetLastErrorMsg() -> char const *"""
    return _gdal.GetLastErrorMsg(*args)

def GetErrorCounter(*args):
    r"""GetErrorCounter() -> unsigned int"""
    return _gdal.GetErrorCounter(*args)

def VSIGetLastErrorNo(*args):
    r"""VSIGetLastErrorNo() -> int"""
    return _gdal.VSIGetLastErrorNo(*args)

def VSIGetLastErrorMsg(*args):
    r"""VSIGetLastErrorMsg() -> char const *"""
    return _gdal.VSIGetLastErrorMsg(*args)

def VSIErrorReset(*args):
    r"""VSIErrorReset()"""
    return _gdal.VSIErrorReset(*args)

def PushFinderLocation(*args):
    r"""PushFinderLocation(char const * utf8_path)"""
    return _gdal.PushFinderLocation(*args)

def PopFinderLocation(*args):
    r"""PopFinderLocation()"""
    return _gdal.PopFinderLocation(*args)

def FinderClean(*args):
    r"""FinderClean()"""
    return _gdal.FinderClean(*args)

def FindFile(*args):
    r"""FindFile(char const * pszClass, char const * utf8_path) -> char const *"""
    return _gdal.FindFile(*args)

def ReadDir(*args):
    r"""ReadDir(char const * utf8_path, int nMaxFiles=0) -> char **"""
    return _gdal.ReadDir(*args)

def ReadDirRecursive(*args):
    r"""ReadDirRecursive(char const * utf8_path) -> char **"""
    return _gdal.ReadDirRecursive(*args)

def OpenDir(*args):
    r"""OpenDir(char const * utf8_path, int nRecurseDepth=-1, char ** options=None) -> VSIDIR *"""
    return _gdal.OpenDir(*args)
class DirEntry(object):
    r"""Proxy of C++ DirEntry class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_gdal.DirEntry_name_get, doc=r"""name : p.char""")
    mode = property(_gdal.DirEntry_mode_get, doc=r"""mode : int""")
    size = property(_gdal.DirEntry_size_get, doc=r"""size : GIntBig""")
    mtime = property(_gdal.DirEntry_mtime_get, doc=r"""mtime : GIntBig""")
    modeKnown = property(_gdal.DirEntry_modeKnown_get, doc=r"""modeKnown : bool""")
    sizeKnown = property(_gdal.DirEntry_sizeKnown_get, doc=r"""sizeKnown : bool""")
    mtimeKnown = property(_gdal.DirEntry_mtimeKnown_get, doc=r"""mtimeKnown : bool""")
    extra = property(_gdal.DirEntry_extra_get, doc=r"""extra : p.p.char""")

    def __init__(self, *args):
        r"""__init__(DirEntry self, DirEntry entryIn) -> DirEntry"""
        _gdal.DirEntry_swiginit(self, _gdal.new_DirEntry(*args))
    __swig_destroy__ = _gdal.delete_DirEntry

    def IsDirectory(self, *args):
        r"""IsDirectory(DirEntry self) -> bool"""
        return _gdal.DirEntry_IsDirectory(self, *args)

# Register DirEntry in _gdal:
_gdal.DirEntry_swigregister(DirEntry)

def GetNextDirEntry(*args):
    r"""GetNextDirEntry(VSIDIR * dir) -> DirEntry"""
    return _gdal.GetNextDirEntry(*args)

def CloseDir(*args):
    r"""CloseDir(VSIDIR * dir)"""
    return _gdal.CloseDir(*args)

def SetConfigOption(*args):
    r"""SetConfigOption(char const * pszKey, char const * pszValue)"""
    return _gdal.SetConfigOption(*args)

def SetThreadLocalConfigOption(*args):
    r"""SetThreadLocalConfigOption(char const * pszKey, char const * pszValue)"""
    return _gdal.SetThreadLocalConfigOption(*args)

def GetConfigOption(*args):
    r"""GetConfigOption(char const * pszKey, char const * pszDefault=None) -> char const *"""
    return _gdal.GetConfigOption(*args)

def GetGlobalConfigOption(*args):
    r"""GetGlobalConfigOption(char const * pszKey, char const * pszDefault=None) -> char const *"""
    return _gdal.GetGlobalConfigOption(*args)

def GetThreadLocalConfigOption(*args):
    r"""GetThreadLocalConfigOption(char const * pszKey, char const * pszDefault=None) -> char const *"""
    return _gdal.GetThreadLocalConfigOption(*args)

def GetConfigOptions(*args):
    r"""GetConfigOptions() -> char **"""
    return _gdal.GetConfigOptions(*args)

def SetPathSpecificOption(*args):
    r"""SetPathSpecificOption(char const * pszPathPrefix, char const * pszKey, char const * pszValue)"""
    return _gdal.SetPathSpecificOption(*args)

def SetCredential(*args):
    r"""SetCredential(char const * pszPathPrefix, char const * pszKey, char const * pszValue)"""
    return _gdal.SetCredential(*args)

def GetCredential(*args):
    r"""GetCredential(char const * pszPathPrefix, char const * pszKey, char const * pszDefault=None) -> char const *"""
    return _gdal.GetCredential(*args)

def GetPathSpecificOption(*args):
    r"""GetPathSpecificOption(char const * pszPathPrefix, char const * pszKey, char const * pszDefault=None) -> char const *"""
    return _gdal.GetPathSpecificOption(*args)

def ClearCredentials(*args):
    r"""ClearCredentials(char const * pszPathPrefix=None)"""
    return _gdal.ClearCredentials(*args)

def ClearPathSpecificOptions(*args):
    r"""ClearPathSpecificOptions(char const * pszPathPrefix=None)"""
    return _gdal.ClearPathSpecificOptions(*args)

def CPLBinaryToHex(*args):
    r"""CPLBinaryToHex(int nBytes) -> retStringAndCPLFree *"""
    return _gdal.CPLBinaryToHex(*args)

def CPLHexToBinary(*args):
    r"""CPLHexToBinary(char const * pszHex, int * pnBytes) -> GByte *"""
    return _gdal.CPLHexToBinary(*args)

def FileFromMemBuffer(*args):
    r"""FileFromMemBuffer(char const * utf8_path, GIntBig nBytes) -> VSI_RETVAL"""
    return _gdal.FileFromMemBuffer(*args)

def Unlink(*args):
    r"""Unlink(char const * utf8_path) -> VSI_RETVAL"""
    return _gdal.Unlink(*args)

def UnlinkBatch(*args):
    r"""UnlinkBatch(char ** files) -> bool"""
    return _gdal.UnlinkBatch(*args)

def HasThreadSupport(*args):
    r"""HasThreadSupport() -> int"""
    return _gdal.HasThreadSupport(*args)

def Mkdir(*args):
    r"""Mkdir(char const * utf8_path, int mode) -> VSI_RETVAL"""
    return _gdal.Mkdir(*args)

def Rmdir(*args):
    r"""Rmdir(char const * utf8_path) -> VSI_RETVAL"""
    return _gdal.Rmdir(*args)

def MkdirRecursive(*args):
    r"""MkdirRecursive(char const * utf8_path, int mode) -> VSI_RETVAL"""
    return _gdal.MkdirRecursive(*args)

def RmdirRecursive(*args):
    r"""RmdirRecursive(char const * utf8_path) -> VSI_RETVAL"""
    return _gdal.RmdirRecursive(*args)

def Rename(*args):
    r"""Rename(char const * pszOld, char const * pszNew) -> VSI_RETVAL"""
    return _gdal.Rename(*args)

def Sync(*args, **kwargs):
    r"""Sync(char const * pszSource, char const * pszTarget, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> bool"""
    return _gdal.Sync(*args, **kwargs)

def AbortPendingUploads(*args):
    r"""AbortPendingUploads(char const * utf8_path) -> bool"""
    return _gdal.AbortPendingUploads(*args)

def CopyFile(*args, **kwargs):
    r"""CopyFile(char const * pszSource, char const * pszTarget, VSILFILE fpSource=None, GIntBig nSourceSize=-1, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.CopyFile(*args, **kwargs)

def GetActualURL(*args):
    r"""GetActualURL(char const * utf8_path) -> char const *"""
    return _gdal.GetActualURL(*args)

def GetSignedURL(*args):
    r"""GetSignedURL(char const * utf8_path, char ** options=None) -> retStringAndCPLFree *"""
    return _gdal.GetSignedURL(*args)

def GetFileSystemsPrefixes(*args):
    r"""GetFileSystemsPrefixes() -> char **"""
    return _gdal.GetFileSystemsPrefixes(*args)

def GetFileSystemOptions(*args):
    r"""GetFileSystemOptions(char const * utf8_path) -> char const *"""
    return _gdal.GetFileSystemOptions(*args)
class VSILFILE(object):
    r"""Proxy of C++ VSILFILE class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

# Register VSILFILE in _gdal:
_gdal.VSILFILE_swigregister(VSILFILE)
VSI_STAT_EXISTS_FLAG = _gdal.VSI_STAT_EXISTS_FLAG

VSI_STAT_NATURE_FLAG = _gdal.VSI_STAT_NATURE_FLAG

VSI_STAT_SIZE_FLAG = _gdal.VSI_STAT_SIZE_FLAG

VSI_STAT_SET_ERROR_FLAG = _gdal.VSI_STAT_SET_ERROR_FLAG

VSI_STAT_CACHE_ONLY = _gdal.VSI_STAT_CACHE_ONLY

class StatBuf(object):
    r"""Proxy of C++ StatBuf class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    mode = property(_gdal.StatBuf_mode_get, doc=r"""mode : int""")
    size = property(_gdal.StatBuf_size_get, doc=r"""size : GIntBig""")
    mtime = property(_gdal.StatBuf_mtime_get, doc=r"""mtime : GIntBig""")

    def __init__(self, *args):
        r"""__init__(StatBuf self, StatBuf psStatBuf) -> StatBuf"""
        _gdal.StatBuf_swiginit(self, _gdal.new_StatBuf(*args))
    __swig_destroy__ = _gdal.delete_StatBuf

    def IsDirectory(self, *args):
        r"""IsDirectory(StatBuf self) -> int"""
        return _gdal.StatBuf_IsDirectory(self, *args)

# Register StatBuf in _gdal:
_gdal.StatBuf_swigregister(StatBuf)

def VSIStatL(*args):
    r"""VSIStatL(char const * utf8_path, int nFlags=0) -> int"""
    return _gdal.VSIStatL(*args)

def GetFileMetadata(*args):
    r"""GetFileMetadata(char const * utf8_path, char const * domain, char ** options=None) -> char **"""
    return _gdal.GetFileMetadata(*args)

def SetFileMetadata(*args):
    r"""SetFileMetadata(char const * utf8_path, char ** metadata, char const * domain, char ** options=None) -> bool"""
    return _gdal.SetFileMetadata(*args)

def VSIFOpenL(*args):
    r"""VSIFOpenL(char const * utf8_path, char const * pszMode) -> VSILFILE"""
    return _gdal.VSIFOpenL(*args)

def VSIFOpenExL(*args):
    r"""VSIFOpenExL(char const * utf8_path, char const * pszMode, int bSetError=FALSE, char ** options=None) -> VSILFILE"""
    return _gdal.VSIFOpenExL(*args)

def VSIFEofL(*args):
    r"""VSIFEofL(VSILFILE fp) -> int"""
    return _gdal.VSIFEofL(*args)

def VSIFFlushL(*args):
    r"""VSIFFlushL(VSILFILE fp) -> int"""
    return _gdal.VSIFFlushL(*args)

def VSIFCloseL(*args):
    r"""VSIFCloseL(VSILFILE fp) -> VSI_RETVAL"""
    return _gdal.VSIFCloseL(*args)

def VSIFSeekL(*args):
    r"""VSIFSeekL(VSILFILE fp, GIntBig offset, int whence) -> int"""
    return _gdal.VSIFSeekL(*args)

def VSIFTellL(*args):
    r"""VSIFTellL(VSILFILE fp) -> GIntBig"""
    return _gdal.VSIFTellL(*args)

def VSIFTruncateL(*args):
    r"""VSIFTruncateL(VSILFILE fp, GIntBig length) -> int"""
    return _gdal.VSIFTruncateL(*args)

def VSISupportsSparseFiles(*args):
    r"""VSISupportsSparseFiles(char const * utf8_path) -> int"""
    return _gdal.VSISupportsSparseFiles(*args)
VSI_RANGE_STATUS_UNKNOWN = _gdal.VSI_RANGE_STATUS_UNKNOWN

VSI_RANGE_STATUS_DATA = _gdal.VSI_RANGE_STATUS_DATA

VSI_RANGE_STATUS_HOLE = _gdal.VSI_RANGE_STATUS_HOLE


def VSIFGetRangeStatusL(*args):
    r"""VSIFGetRangeStatusL(VSILFILE fp, GIntBig offset, GIntBig length) -> int"""
    return _gdal.VSIFGetRangeStatusL(*args)

def VSIFWriteL(*args):
    r"""VSIFWriteL(int nLen, int size, int memb, VSILFILE fp) -> int"""
    return _gdal.VSIFWriteL(*args)

def VSICurlClearCache(*args):
    r"""VSICurlClearCache()"""
    return _gdal.VSICurlClearCache(*args)

def VSICurlPartialClearCache(*args):
    r"""VSICurlPartialClearCache(char const * utf8_path)"""
    return _gdal.VSICurlPartialClearCache(*args)

def NetworkStatsReset(*args):
    r"""NetworkStatsReset()"""
    return _gdal.NetworkStatsReset(*args)

def NetworkStatsGetAsSerializedJSON(*args):
    r"""NetworkStatsGetAsSerializedJSON(char ** options=None) -> retStringAndCPLFree *"""
    return _gdal.NetworkStatsGetAsSerializedJSON(*args)

def ParseCommandLine(*args):
    r"""ParseCommandLine(char const * utf8_path) -> char **"""
    return _gdal.ParseCommandLine(*args)

def GetNumCPUs(*args):
    r"""GetNumCPUs() -> int"""
    return _gdal.GetNumCPUs(*args)

def GetUsablePhysicalRAM(*args):
    r"""GetUsablePhysicalRAM() -> GIntBig"""
    return _gdal.GetUsablePhysicalRAM(*args)
class MajorObject(object):
    r"""Proxy of C++ GDALMajorObjectShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetDescription(self, *args):
        r"""GetDescription(MajorObject self) -> char const *"""
        return _gdal.MajorObject_GetDescription(self, *args)

    def SetDescription(self, *args):
        r"""SetDescription(MajorObject self, char const * pszNewDesc)"""
        return _gdal.MajorObject_SetDescription(self, *args)

    def GetMetadataDomainList(self, *args):
        r"""GetMetadataDomainList(MajorObject self) -> char **"""
        return _gdal.MajorObject_GetMetadataDomainList(self, *args)

    def GetMetadata_Dict(self, *args):
        r"""GetMetadata_Dict(MajorObject self, char const * pszDomain="") -> char **"""
        return _gdal.MajorObject_GetMetadata_Dict(self, *args)

    def GetMetadata_List(self, *args):
        r"""GetMetadata_List(MajorObject self, char const * pszDomain="") -> char **"""
        return _gdal.MajorObject_GetMetadata_List(self, *args)

    def SetMetadata(self, *args):
        r"""
        SetMetadata(MajorObject self, char ** papszMetadata, char const * pszDomain="") -> CPLErr
        SetMetadata(MajorObject self, char * pszMetadataString, char const * pszDomain="") -> CPLErr
        """
        return _gdal.MajorObject_SetMetadata(self, *args)

    def GetMetadataItem(self, *args):
        r"""GetMetadataItem(MajorObject self, char const * pszName, char const * pszDomain="") -> char const *"""
        return _gdal.MajorObject_GetMetadataItem(self, *args)

    def SetMetadataItem(self, *args):
        r"""SetMetadataItem(MajorObject self, char const * pszName, char const * pszValue, char const * pszDomain="") -> CPLErr"""
        return _gdal.MajorObject_SetMetadataItem(self, *args)

    def GetMetadata(self, domain=''):
      if domain and domain[:4] == 'xml:':
        return self.GetMetadata_List(domain)
      return self.GetMetadata_Dict(domain)


# Register MajorObject in _gdal:
_gdal.MajorObject_swigregister(MajorObject)
class Driver(MajorObject):
    r"""Proxy of C++ GDALDriverShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    ShortName = property(_gdal.Driver_ShortName_get, doc=r"""ShortName : p.q(const).char""")
    LongName = property(_gdal.Driver_LongName_get, doc=r"""LongName : p.q(const).char""")
    HelpTopic = property(_gdal.Driver_HelpTopic_get, doc=r"""HelpTopic : p.q(const).char""")

    def Create(self, *args, **kwargs):
        r"""Create(Driver self, char const * utf8_path, int xsize, int ysize, int bands=1, GDALDataType eType=GDT_Byte, char ** options=None) -> Dataset"""

        _WarnIfUserHasNotSpecifiedIfUsingExceptions()


        return _gdal.Driver_Create(self, *args, **kwargs)


    def CreateMultiDimensional(self, *args, **kwargs):
        r"""CreateMultiDimensional(Driver self, char const * utf8_path, char ** root_group_options=None, char ** options=None) -> Dataset"""

        _WarnIfUserHasNotSpecifiedIfUsingExceptions()


        return _gdal.Driver_CreateMultiDimensional(self, *args, **kwargs)


    def CreateCopy(self, *args, **kwargs):
        r"""CreateCopy(Driver self, char const * utf8_path, Dataset src, int strict=1, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""

        _WarnIfUserHasNotSpecifiedIfUsingExceptions()


        return _gdal.Driver_CreateCopy(self, *args, **kwargs)


    def Delete(self, *args):
        r"""Delete(Driver self, char const * utf8_path) -> CPLErr"""

        _WarnIfUserHasNotSpecifiedIfUsingExceptions()


        return _gdal.Driver_Delete(self, *args)


    def Rename(self, *args):
        r"""Rename(Driver self, char const * newName, char const * oldName) -> CPLErr"""
        return _gdal.Driver_Rename(self, *args)

    def CopyFiles(self, *args):
        r"""CopyFiles(Driver self, char const * newName, char const * oldName) -> CPLErr"""
        return _gdal.Driver_CopyFiles(self, *args)

    def Register(self, *args):
        r"""Register(Driver self) -> int"""
        return _gdal.Driver_Register(self, *args)

    def Deregister(self, *args):
        r"""Deregister(Driver self)"""
        return _gdal.Driver_Deregister(self, *args)

# Register Driver in _gdal:
_gdal.Driver_swigregister(Driver)
from . import ogr
from . import osr
class ColorEntry(object):
    r"""Proxy of C++ GDALColorEntry class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    c1 = property(_gdal.ColorEntry_c1_get, _gdal.ColorEntry_c1_set, doc=r"""c1 : short""")
    c2 = property(_gdal.ColorEntry_c2_get, _gdal.ColorEntry_c2_set, doc=r"""c2 : short""")
    c3 = property(_gdal.ColorEntry_c3_get, _gdal.ColorEntry_c3_set, doc=r"""c3 : short""")
    c4 = property(_gdal.ColorEntry_c4_get, _gdal.ColorEntry_c4_set, doc=r"""c4 : short""")

# Register ColorEntry in _gdal:
_gdal.ColorEntry_swigregister(ColorEntry)
class GCP(object):
    r"""Proxy of C++ GDAL_GCP class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    GCPX = property(_gdal.GCP_GCPX_get, _gdal.GCP_GCPX_set, doc=r"""GCPX : double""")
    GCPY = property(_gdal.GCP_GCPY_get, _gdal.GCP_GCPY_set, doc=r"""GCPY : double""")
    GCPZ = property(_gdal.GCP_GCPZ_get, _gdal.GCP_GCPZ_set, doc=r"""GCPZ : double""")
    GCPPixel = property(_gdal.GCP_GCPPixel_get, _gdal.GCP_GCPPixel_set, doc=r"""GCPPixel : double""")
    GCPLine = property(_gdal.GCP_GCPLine_get, _gdal.GCP_GCPLine_set, doc=r"""GCPLine : double""")
    Info = property(_gdal.GCP_Info_get, _gdal.GCP_Info_set, doc=r"""Info : p.char""")
    Id = property(_gdal.GCP_Id_get, _gdal.GCP_Id_set, doc=r"""Id : p.char""")

    def __init__(self, *args):
        r"""__init__(GCP self, double x=0.0, double y=0.0, double z=0.0, double pixel=0.0, double line=0.0, char const * info="", char const * id="") -> GCP"""
        _gdal.GCP_swiginit(self, _gdal.new_GCP(*args))
    __swig_destroy__ = _gdal.delete_GCP

    def __str__(self):
      str = '%s (%.2fP,%.2fL) -> (%.7fE,%.7fN,%.2f) %s '\
            % (self.Id, self.GCPPixel, self.GCPLine,
               self.GCPX, self.GCPY, self.GCPZ, self.Info )
      return str

    def serialize(self, with_Z=0):
      base = [gdalconst.CXT_Element, 'GCP']
      base.append([gdalconst.CXT_Attribute, 'Id', [gdalconst.CXT_Text, self.Id]])
      pixval = '%0.15E' % self.GCPPixel
      lineval = '%0.15E' % self.GCPLine
      xval = '%0.15E' % self.GCPX
      yval = '%0.15E' % self.GCPY
      zval = '%0.15E' % self.GCPZ
      base.append([gdalconst.CXT_Attribute, 'Pixel', [gdalconst.CXT_Text, pixval]])
      base.append([gdalconst.CXT_Attribute, 'Line', [gdalconst.CXT_Text, lineval]])
      base.append([gdalconst.CXT_Attribute, 'X', [gdalconst.CXT_Text, xval]])
      base.append([gdalconst.CXT_Attribute, 'Y', [gdalconst.CXT_Text, yval]])
      if with_Z:
          base.append([gdalconst.CXT_Attribute, 'Z', [gdalconst.CXT_Text, zval]])
      return base



# Register GCP in _gdal:
_gdal.GCP_swigregister(GCP)

def GDAL_GCP_GCPX_get(*args):
    r"""GDAL_GCP_GCPX_get(GCP gcp) -> double"""
    return _gdal.GDAL_GCP_GCPX_get(*args)

def GDAL_GCP_GCPX_set(*args):
    r"""GDAL_GCP_GCPX_set(GCP gcp, double dfGCPX)"""
    return _gdal.GDAL_GCP_GCPX_set(*args)

def GDAL_GCP_GCPY_get(*args):
    r"""GDAL_GCP_GCPY_get(GCP gcp) -> double"""
    return _gdal.GDAL_GCP_GCPY_get(*args)

def GDAL_GCP_GCPY_set(*args):
    r"""GDAL_GCP_GCPY_set(GCP gcp, double dfGCPY)"""
    return _gdal.GDAL_GCP_GCPY_set(*args)

def GDAL_GCP_GCPZ_get(*args):
    r"""GDAL_GCP_GCPZ_get(GCP gcp) -> double"""
    return _gdal.GDAL_GCP_GCPZ_get(*args)

def GDAL_GCP_GCPZ_set(*args):
    r"""GDAL_GCP_GCPZ_set(GCP gcp, double dfGCPZ)"""
    return _gdal.GDAL_GCP_GCPZ_set(*args)

def GDAL_GCP_GCPPixel_get(*args):
    r"""GDAL_GCP_GCPPixel_get(GCP gcp) -> double"""
    return _gdal.GDAL_GCP_GCPPixel_get(*args)

def GDAL_GCP_GCPPixel_set(*args):
    r"""GDAL_GCP_GCPPixel_set(GCP gcp, double dfGCPPixel)"""
    return _gdal.GDAL_GCP_GCPPixel_set(*args)

def GDAL_GCP_GCPLine_get(*args):
    r"""GDAL_GCP_GCPLine_get(GCP gcp) -> double"""
    return _gdal.GDAL_GCP_GCPLine_get(*args)

def GDAL_GCP_GCPLine_set(*args):
    r"""GDAL_GCP_GCPLine_set(GCP gcp, double dfGCPLine)"""
    return _gdal.GDAL_GCP_GCPLine_set(*args)

def GDAL_GCP_Info_get(*args):
    r"""GDAL_GCP_Info_get(GCP gcp) -> char const *"""
    return _gdal.GDAL_GCP_Info_get(*args)

def GDAL_GCP_Info_set(*args):
    r"""GDAL_GCP_Info_set(GCP gcp, char const * pszInfo)"""
    return _gdal.GDAL_GCP_Info_set(*args)

def GDAL_GCP_Id_get(*args):
    r"""GDAL_GCP_Id_get(GCP gcp) -> char const *"""
    return _gdal.GDAL_GCP_Id_get(*args)

def GDAL_GCP_Id_set(*args):
    r"""GDAL_GCP_Id_set(GCP gcp, char const * pszId)"""
    return _gdal.GDAL_GCP_Id_set(*args)

def GCPsToGeoTransform(*args):
    r"""GCPsToGeoTransform(int nGCPs, int bApproxOK=1) -> RETURN_NONE"""
    return _gdal.GCPsToGeoTransform(*args)
class VirtualMem(object):
    r"""Proxy of C++ CPLVirtualMemShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_VirtualMem

    def GetAddr(self, *args):
        r"""GetAddr(VirtualMem self)"""
        return _gdal.VirtualMem_GetAddr(self, *args)

    def Pin(self, *args):
        r"""Pin(VirtualMem self, size_t start_offset=0, size_t nsize=0, int bWriteOp=0)"""
        return _gdal.VirtualMem_Pin(self, *args)

# Register VirtualMem in _gdal:
_gdal.VirtualMem_swigregister(VirtualMem)
class AsyncReader(object):
    r"""Proxy of C++ GDALAsyncReaderShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_AsyncReader

    def GetNextUpdatedRegion(self, *args):
        r"""GetNextUpdatedRegion(AsyncReader self, double timeout) -> GDALAsyncStatusType"""
        return _gdal.AsyncReader_GetNextUpdatedRegion(self, *args)

    def GetBuffer(self, *args):
        r"""GetBuffer(AsyncReader self)"""
        return _gdal.AsyncReader_GetBuffer(self, *args)

    def LockBuffer(self, *args):
        r"""LockBuffer(AsyncReader self, double timeout) -> int"""
        return _gdal.AsyncReader_LockBuffer(self, *args)

    def UnlockBuffer(self, *args):
        r"""UnlockBuffer(AsyncReader self)"""
        return _gdal.AsyncReader_UnlockBuffer(self, *args)

# Register AsyncReader in _gdal:
_gdal.AsyncReader_swigregister(AsyncReader)
class Dataset(MajorObject):
    r"""

    Python proxy of a raster :cpp:class:`GDALDataset`.

    Since GDAL 3.8, a Dataset can be used as a context manager.
    When exiting the context, the Dataset will be closed and
    data will be written to disk.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    RasterXSize = property(_gdal.Dataset_RasterXSize_get, doc=r"""RasterXSize : int""")
    RasterYSize = property(_gdal.Dataset_RasterYSize_get, doc=r"""RasterYSize : int""")
    RasterCount = property(_gdal.Dataset_RasterCount_get, doc=r"""RasterCount : int""")
    __swig_destroy__ = _gdal.delete_Dataset

    def Close(self, *args):
        r"""
        Close(Dataset self) -> CPLErr

        Closes opened dataset and releases allocated resources.

        This method can be used to force the dataset to close
        when one more references to the dataset are still
        reachable. If Close is never called, the dataset will
        be closed automatically during garbage collection.

        """
        val = _gdal.Dataset_Close(self, *args)

        self.thisown = 0
        self.this = None
        self._invalidate_bands()
        return val


        return val


    def GetDriver(self, *args):
        r"""GetDriver(Dataset self) -> Driver"""
        return _gdal.Dataset_GetDriver(self, *args)

    def GetRasterBand(self, *args):
        r"""GetRasterBand(Dataset self, int nBand) -> Band"""
        val = _gdal.Dataset_GetRasterBand(self, *args)

        self._add_band_ref(val)


        return val


    def GetRootGroup(self, *args):
        r"""GetRootGroup(Dataset self) -> Group"""
        return _gdal.Dataset_GetRootGroup(self, *args)

    def GetProjection(self, *args):
        r"""GetProjection(Dataset self) -> char const *"""
        return _gdal.Dataset_GetProjection(self, *args)

    def GetProjectionRef(self, *args):
        r"""GetProjectionRef(Dataset self) -> char const *"""
        return _gdal.Dataset_GetProjectionRef(self, *args)

    def GetSpatialRef(self, *args):
        r"""GetSpatialRef(Dataset self) -> SpatialReference"""
        return _gdal.Dataset_GetSpatialRef(self, *args)

    def SetProjection(self, *args):
        r"""SetProjection(Dataset self, char const * prj) -> CPLErr"""
        return _gdal.Dataset_SetProjection(self, *args)

    def SetSpatialRef(self, *args):
        r"""SetSpatialRef(Dataset self, SpatialReference srs) -> CPLErr"""
        return _gdal.Dataset_SetSpatialRef(self, *args)

    def GetGeoTransform(self, *args, **kwargs):
        r"""GetGeoTransform(Dataset self, int * can_return_null=None)"""
        return _gdal.Dataset_GetGeoTransform(self, *args, **kwargs)

    def SetGeoTransform(self, *args):
        r"""SetGeoTransform(Dataset self, double [6] argin) -> CPLErr"""
        return _gdal.Dataset_SetGeoTransform(self, *args)

    def BuildOverviews(self, *args, **kwargs):
        r"""BuildOverviews(Dataset self, char const * resampling="NEAREST", int overviewlist=0, GDALProgressFunc callback=0, void * callback_data=None, char ** options=None) -> int"""
        return _gdal.Dataset_BuildOverviews(self, *args, **kwargs)

    def GetGCPCount(self, *args):
        r"""GetGCPCount(Dataset self) -> int"""
        return _gdal.Dataset_GetGCPCount(self, *args)

    def GetGCPProjection(self, *args):
        r"""GetGCPProjection(Dataset self) -> char const *"""
        return _gdal.Dataset_GetGCPProjection(self, *args)

    def GetGCPSpatialRef(self, *args):
        r"""GetGCPSpatialRef(Dataset self) -> SpatialReference"""
        return _gdal.Dataset_GetGCPSpatialRef(self, *args)

    def GetGCPs(self, *args):
        r"""GetGCPs(Dataset self)"""
        return _gdal.Dataset_GetGCPs(self, *args)

    def _SetGCPs(self, *args):
        r"""_SetGCPs(Dataset self, int nGCPs, char const * pszGCPProjection) -> CPLErr"""
        return _gdal.Dataset__SetGCPs(self, *args)

    def _SetGCPs2(self, *args):
        r"""_SetGCPs2(Dataset self, int nGCPs, SpatialReference hSRS) -> CPLErr"""
        return _gdal.Dataset__SetGCPs2(self, *args)

    def FlushCache(self, *args):
        r"""FlushCache(Dataset self) -> CPLErr"""
        return _gdal.Dataset_FlushCache(self, *args)

    def AddBand(self, *args, **kwargs):
        r"""AddBand(Dataset self, GDALDataType datatype=GDT_Byte, char ** options=None) -> CPLErr"""
        return _gdal.Dataset_AddBand(self, *args, **kwargs)

    def CreateMaskBand(self, *args):
        r"""CreateMaskBand(Dataset self, int nFlags) -> CPLErr"""
        return _gdal.Dataset_CreateMaskBand(self, *args)

    def GetFileList(self, *args):
        r"""GetFileList(Dataset self) -> char **"""
        return _gdal.Dataset_GetFileList(self, *args)

    def WriteRaster(self, *args, **kwargs):
        r"""WriteRaster(Dataset self, int xoff, int yoff, int xsize, int ysize, GIntBig buf_len, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, int band_list=0, GIntBig * buf_pixel_space=None, GIntBig * buf_line_space=None, GIntBig * buf_band_space=None) -> CPLErr"""
        return _gdal.Dataset_WriteRaster(self, *args, **kwargs)

    def AdviseRead(self, *args):
        r"""AdviseRead(Dataset self, int xoff, int yoff, int xsize, int ysize, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, int band_list=0, char ** options=None) -> CPLErr"""
        return _gdal.Dataset_AdviseRead(self, *args)

    def BeginAsyncReader(self, *args, **kwargs):
        r"""BeginAsyncReader(Dataset self, int xOff, int yOff, int xSize, int ySize, size_t buf_len, int buf_xsize, int buf_ysize, GDALDataType bufType=(GDALDataType) 0, int band_list=0, int nPixelSpace=0, int nLineSpace=0, int nBandSpace=0, char ** options=None) -> AsyncReader"""
        return _gdal.Dataset_BeginAsyncReader(self, *args, **kwargs)

    def EndAsyncReader(self, *args):
        r"""EndAsyncReader(Dataset self, AsyncReader ario)"""
        return _gdal.Dataset_EndAsyncReader(self, *args)

    def GetVirtualMem(self, *args, **kwargs):
        r"""GetVirtualMem(Dataset self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, int nYSize, int nBufXSize, int nBufYSize, GDALDataType eBufType, int band_list, int bIsBandSequential, size_t nCacheSize, size_t nPageSizeHint, char ** options=None) -> VirtualMem"""
        return _gdal.Dataset_GetVirtualMem(self, *args, **kwargs)

    def GetTiledVirtualMem(self, *args, **kwargs):
        r"""GetTiledVirtualMem(Dataset self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, int nYSize, int nTileXSize, int nTileYSize, GDALDataType eBufType, int band_list, GDALTileOrganization eTileOrganization, size_t nCacheSize, char ** options=None) -> VirtualMem"""
        return _gdal.Dataset_GetTiledVirtualMem(self, *args, **kwargs)

    def CreateLayer(self, *args, **kwargs):
        r"""CreateLayer(Dataset self, char const * name, SpatialReference srs=None, OGRwkbGeometryType geom_type=wkbUnknown, char ** options=None) -> Layer"""
        return _gdal.Dataset_CreateLayer(self, *args, **kwargs)

    def CopyLayer(self, *args, **kwargs):
        r"""CopyLayer(Dataset self, Layer src_layer, char const * new_name, char ** options=None) -> Layer"""
        return _gdal.Dataset_CopyLayer(self, *args, **kwargs)

    def DeleteLayer(self, *args):
        r"""DeleteLayer(Dataset self, int index) -> OGRErr"""
        return _gdal.Dataset_DeleteLayer(self, *args)

    def GetLayerCount(self, *args):
        r"""GetLayerCount(Dataset self) -> int"""
        return _gdal.Dataset_GetLayerCount(self, *args)

    def IsLayerPrivate(self, *args):
        r"""IsLayerPrivate(Dataset self, int index) -> bool"""
        return _gdal.Dataset_IsLayerPrivate(self, *args)

    def GetLayerByIndex(self, *args):
        r"""GetLayerByIndex(Dataset self, int index=0) -> Layer"""
        return _gdal.Dataset_GetLayerByIndex(self, *args)

    def GetLayerByName(self, *args):
        r"""GetLayerByName(Dataset self, char const * layer_name) -> Layer"""

        _WarnIfUserHasNotSpecifiedIfUsingOgrExceptions()


        return _gdal.Dataset_GetLayerByName(self, *args)


    def ResetReading(self, *args):
        r"""ResetReading(Dataset self)"""
        return _gdal.Dataset_ResetReading(self, *args)

    def GetNextFeature(self, *args, **kwargs):
        r"""GetNextFeature(Dataset self, bool include_layer=True, bool include_pct=False, GDALProgressFunc callback=0, void * callback_data=None) -> Feature"""
        return _gdal.Dataset_GetNextFeature(self, *args, **kwargs)

    def TestCapability(self, *args):
        r"""TestCapability(Dataset self, char const * cap) -> bool"""
        return _gdal.Dataset_TestCapability(self, *args)

    def ExecuteSQL(self, statement, spatialFilter=None, dialect="", keep_ref_on_ds=False):
        """ExecuteSQL(self, statement, spatialFilter: ogr.Geometry = None, dialect: Optional[str] = "", keep_ref_on_ds=False) -> ogr.Layer

        Execute a SQL statement against the dataset

        The result of a SQL query is:
          - None (or an exception if exceptions are enabled) for statements
            that are in error
          - or None for statements that have no results set,
          - or a ogr.Layer handle representing a results set from the query.

        Note that this ogr.Layer is in addition to the layers in the data store
        and must be released with ReleaseResultSet() before the data source is closed
        (destroyed).

        Starting with GDAL 3.7, this method can also be used as a context manager,
        as a convenient way of automatically releasing the returned result layer.

        For more information on the SQL dialect supported internally by OGR
        review the OGR SQL document (:ref:`ogr_sql_sqlite_dialect`)
        Some drivers (i.e. Oracle and PostGIS) pass the SQL directly through to the
        underlying RDBMS.

        The SQLITE dialect can also be used (:ref:`sql_sqlite_dialect`)

        Parameters
        ----------
        statement:
            the SQL statement to execute (e.g "SELECT * FROM layer")
        spatialFilter:
            a geometry which represents a spatial filter. Can be None
        dialect:
            allows control of the statement dialect. If set to None or empty string,
            the OGR SQL engine will be used, except for RDBMS drivers that will
            use their dedicated SQL engine, unless OGRSQL is explicitly passed as
            the dialect. The SQLITE dialect can also be used.
        keep_ref_on_ds:
            whether the returned layer should keep a (strong) reference on
            the current dataset. Cf example 2 for a use case.

        Returns
        -------
        ogr.Layer:
            a ogr.Layer containing the results of the query, that will be
            automatically released when the context manager goes out of scope.

        Examples
        --------
        1. Use as a context manager:

        >>> with ds.ExecuteSQL("SELECT * FROM layer") as lyr:
        ...     print(lyr.GetFeatureCount())

        2. Use keep_ref_on_ds=True to return an object that keeps a reference to its dataset:

        >>> def get_sql_lyr():
        ...     return gdal.OpenEx("test.shp").ExecuteSQL("SELECT * FROM test", keep_ref_on_ds=True)
        ...
        ... with get_sql_lyr() as lyr:
        ...     print(lyr.GetFeatureCount())
        """

        sql_lyr = _gdal.Dataset_ExecuteSQL(self, statement, spatialFilter, dialect)
        if sql_lyr:
            import weakref
            sql_lyr._to_release = True
            sql_lyr._dataset_weak_ref = weakref.ref(self)
            if keep_ref_on_ds:
                sql_lyr._dataset_strong_ref = self
        return sql_lyr



    def ReleaseResultSet(self, sql_lyr):
        """ReleaseResultSet(self, sql_lyr: ogr.Layer)

        Release ogr.Layer returned by ExecuteSQL() (when not called as an execution manager)

        The sql_lyr object is invalidated after this call.

        Parameters
        ----------
        sql_lyr:
            ogr.Layer got with ExecuteSQL()
        """

        if sql_lyr and not hasattr(sql_lyr, "_to_release"):
            raise Exception("This layer was not returned by ExecuteSQL() and should not be released with ReleaseResultSet()")
        _gdal.Dataset_ReleaseResultSet(self, sql_lyr)
    # Invalidates the layer
        if sql_lyr:
            sql_lyr.thisown = None
            sql_lyr.this = None



    def GetStyleTable(self, *args):
        r"""GetStyleTable(Dataset self) -> StyleTable"""
        return _gdal.Dataset_GetStyleTable(self, *args)

    def SetStyleTable(self, *args):
        r"""SetStyleTable(Dataset self, StyleTable table)"""
        return _gdal.Dataset_SetStyleTable(self, *args)

    def AbortSQL(self, *args):
        r"""AbortSQL(Dataset self) -> OGRErr"""
        return _gdal.Dataset_AbortSQL(self, *args)

    def StartTransaction(self, *args, **kwargs):
        r"""StartTransaction(Dataset self, int force=FALSE) -> OGRErr"""
        return _gdal.Dataset_StartTransaction(self, *args, **kwargs)

    def CommitTransaction(self, *args):
        r"""CommitTransaction(Dataset self) -> OGRErr"""
        return _gdal.Dataset_CommitTransaction(self, *args)

    def RollbackTransaction(self, *args):
        r"""RollbackTransaction(Dataset self) -> OGRErr"""
        return _gdal.Dataset_RollbackTransaction(self, *args)

    def ClearStatistics(self, *args):
        r"""ClearStatistics(Dataset self)"""
        return _gdal.Dataset_ClearStatistics(self, *args)

    def GetFieldDomainNames(self, *args):
        r"""GetFieldDomainNames(Dataset self, char ** options=None) -> char **"""
        return _gdal.Dataset_GetFieldDomainNames(self, *args)

    def GetFieldDomain(self, *args):
        r"""GetFieldDomain(Dataset self, char const * name) -> FieldDomain"""
        return _gdal.Dataset_GetFieldDomain(self, *args)

    def AddFieldDomain(self, *args):
        r"""AddFieldDomain(Dataset self, FieldDomain fieldDomain) -> bool"""
        return _gdal.Dataset_AddFieldDomain(self, *args)

    def DeleteFieldDomain(self, *args):
        r"""DeleteFieldDomain(Dataset self, char const * name) -> bool"""
        return _gdal.Dataset_DeleteFieldDomain(self, *args)

    def UpdateFieldDomain(self, *args):
        r"""UpdateFieldDomain(Dataset self, FieldDomain fieldDomain) -> bool"""
        return _gdal.Dataset_UpdateFieldDomain(self, *args)

    def GetRelationshipNames(self, *args):
        r"""GetRelationshipNames(Dataset self, char ** options=None) -> char **"""
        return _gdal.Dataset_GetRelationshipNames(self, *args)

    def GetRelationship(self, *args):
        r"""GetRelationship(Dataset self, char const * name) -> Relationship"""
        return _gdal.Dataset_GetRelationship(self, *args)

    def AddRelationship(self, *args):
        r"""AddRelationship(Dataset self, Relationship relationship) -> bool"""
        return _gdal.Dataset_AddRelationship(self, *args)

    def DeleteRelationship(self, *args):
        r"""DeleteRelationship(Dataset self, char const * name) -> bool"""
        return _gdal.Dataset_DeleteRelationship(self, *args)

    def UpdateRelationship(self, *args):
        r"""UpdateRelationship(Dataset self, Relationship relationship) -> bool"""
        return _gdal.Dataset_UpdateRelationship(self, *args)

    def ReadRaster1(self, *args, **kwargs):
        r"""ReadRaster1(Dataset self, double xoff, double yoff, double xsize, double ysize, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, int band_list=0, GIntBig * buf_pixel_space=None, GIntBig * buf_line_space=None, GIntBig * buf_band_space=None, GDALRIOResampleAlg resample_alg=GRIORA_NearestNeighbour, GDALProgressFunc callback=0, void * callback_data=None, void * inputOutputBuf=None) -> CPLErr"""
        return _gdal.Dataset_ReadRaster1(self, *args, **kwargs)


    def ReadAsArray(self, xoff=0, yoff=0, xsize=None, ysize=None, buf_obj=None,
                    buf_xsize=None, buf_ysize=None, buf_type=None,
                    resample_alg=gdalconst.GRIORA_NearestNeighbour,
                    callback=None,
                    callback_data=None,
                    interleave='band',
                    band_list=None):
        """ Reading a chunk of a GDAL band into a numpy array. The optional (buf_xsize,buf_ysize,buf_type)
        parameters should generally not be specified if buf_obj is specified. The array is returned"""

        from osgeo import gdal_array
        return gdal_array.DatasetReadAsArray(self, xoff, yoff, xsize, ysize, buf_obj,
                                              buf_xsize, buf_ysize, buf_type,
                                              resample_alg=resample_alg,
                                              callback=callback,
                                              callback_data=callback_data,
                                              interleave=interleave,
                                              band_list=band_list)

    def WriteArray(self, array, xoff=0, yoff=0,
                   band_list=None,
                   interleave='band',
                   resample_alg=gdalconst.GRIORA_NearestNeighbour,
                   callback=None,
                   callback_data=None):
        from osgeo import gdal_array

        return gdal_array.DatasetWriteArray(self, array, xoff, yoff,
                                            band_list=band_list,
                                            interleave=interleave,
                                            resample_alg=resample_alg,
                                            callback=callback,
                                            callback_data=callback_data)

    def WriteRaster(self, xoff, yoff, xsize, ysize,
                    buf_string,
                    buf_xsize=None, buf_ysize=None, buf_type=None,
                    band_list=None,
                    buf_pixel_space=None, buf_line_space=None, buf_band_space=None ):

        if buf_xsize is None:
            buf_xsize = xsize
        if buf_ysize is None:
            buf_ysize = ysize
        if band_list is None:
            band_list = list(range(1, self.RasterCount + 1))

    # Redirect to numpy-friendly WriteArray() if buf_string is a numpy array
    # and other arguments are compatible
        if type(buf_string).__name__ == 'ndarray' and \
           buf_xsize == xsize and buf_ysize == ysize and buf_type is None and \
           buf_pixel_space is None and buf_line_space is None and buf_band_space is None:
            return self.WriteArray(buf_string, xoff=xoff, yoff=yoff,
                                   band_list=band_list)
        if buf_type is None:
            buf_type = self.GetRasterBand(1).DataType

        return _gdal.Dataset_WriteRaster(self,
                 xoff, yoff, xsize, ysize,
                buf_string, buf_xsize, buf_ysize, buf_type, band_list,
                buf_pixel_space, buf_line_space, buf_band_space )

    def ReadRaster(self, xoff=0, yoff=0, xsize=None, ysize=None,
                   buf_xsize=None, buf_ysize=None, buf_type=None,
                   band_list=None,
                   buf_pixel_space=None, buf_line_space=None, buf_band_space=None,
                   resample_alg=gdalconst.GRIORA_NearestNeighbour,
                   callback=None,
                   callback_data=None,
                   buf_obj=None):

        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if band_list is None:
            band_list = list(range(1, self.RasterCount + 1))
        if buf_xsize is None:
            buf_xsize = xsize
        if buf_ysize is None:
            buf_ysize = ysize

        if buf_type is None:
            buf_type = self.GetRasterBand(1).DataType;

        return _gdal.Dataset_ReadRaster1(self, xoff, yoff, xsize, ysize,
                                            buf_xsize, buf_ysize, buf_type,
                                            band_list, buf_pixel_space, buf_line_space, buf_band_space,
                                          resample_alg, callback, callback_data, buf_obj )

    def GetVirtualMemArray(self, eAccess=gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, bufxsize=None, bufysize=None,
                           datatype=None, band_list=None, band_sequential = True,
                           cache_size = 10 * 1024 * 1024, page_size_hint = 0,
                           options=None):
        """Return a NumPy array for the dataset, seen as a virtual memory mapping.
           If there are several bands and band_sequential = True, an element is
           accessed with array[band][y][x].
           If there are several bands and band_sequential = False, an element is
           accessed with array[y][x][band].
           If there is only one band, an element is accessed with array[y][x].
           Any reference to the array must be dropped before the last reference to the
           related dataset is also dropped.
        """
        from osgeo import gdal_array
        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if bufxsize is None:
            bufxsize = self.RasterXSize
        if bufysize is None:
            bufysize = self.RasterYSize
        if datatype is None:
            datatype = self.GetRasterBand(1).DataType
        if band_list is None:
            band_list = list(range(1, self.RasterCount + 1))
        if options is None:
            virtualmem = self.GetVirtualMem(eAccess, xoff, yoff, xsize, ysize, bufxsize, bufysize, datatype, band_list, band_sequential, cache_size, page_size_hint)
        else:
            virtualmem = self.GetVirtualMem(eAccess, xoff, yoff, xsize, ysize, bufxsize, bufysize, datatype, band_list, band_sequential, cache_size, page_size_hint,  options)
        return gdal_array.VirtualMemGetArray( virtualmem )

    def GetTiledVirtualMemArray(self, eAccess=gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, tilexsize=256, tileysize=256,
                           datatype=None, band_list=None, tile_organization=gdalconst.GTO_BSQ,
                           cache_size = 10 * 1024 * 1024, options=None):
        """Return a NumPy array for the dataset, seen as a virtual memory mapping with
           a tile organization.
           If there are several bands and tile_organization = gdal.GTO_TIP, an element is
           accessed with array[tiley][tilex][y][x][band].
           If there are several bands and tile_organization = gdal.GTO_BIT, an element is
           accessed with array[tiley][tilex][band][y][x].
           If there are several bands and tile_organization = gdal.GTO_BSQ, an element is
           accessed with array[band][tiley][tilex][y][x].
           If there is only one band, an element is accessed with array[tiley][tilex][y][x].
           Any reference to the array must be dropped before the last reference to the
           related dataset is also dropped.
        """
        from osgeo import gdal_array
        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if datatype is None:
            datatype = self.GetRasterBand(1).DataType
        if band_list is None:
            band_list = list(range(1, self.RasterCount + 1))
        if options is None:
            virtualmem = self.GetTiledVirtualMem(eAccess, xoff, yoff, xsize, ysize, tilexsize, tileysize, datatype, band_list, tile_organization, cache_size)
        else:
            virtualmem = self.GetTiledVirtualMem(eAccess, xoff, yoff, xsize, ysize, tilexsize, tileysize, datatype, band_list, tile_organization, cache_size, options)
        return gdal_array.VirtualMemGetArray( virtualmem )

    def GetSubDatasets(self):
        sd_list = []

        sd = self.GetMetadata('SUBDATASETS')
        if sd is None:
            return sd_list

        i = 1
        while 'SUBDATASET_'+str(i)+'_NAME' in sd:
            sd_list.append((sd['SUBDATASET_'+str(i)+'_NAME'],
                            sd['SUBDATASET_'+str(i)+'_DESC']))
            i = i + 1
        return sd_list

    def BeginAsyncReader(self, xoff, yoff, xsize, ysize, buf_obj=None, buf_xsize=None, buf_ysize=None, buf_type=None, band_list=None, options=None):
        if band_list is None:
            band_list = list(range(1, self.RasterCount + 1))
        if buf_xsize is None:
            buf_xsize = 0;
        if buf_ysize is None:
            buf_ysize = 0;
        if buf_type is None:
            buf_type = gdalconst.GDT_Byte

        if buf_xsize <= 0:
            buf_xsize = xsize
        if buf_ysize <= 0:
            buf_ysize = ysize
        options = [] if options is None else options

        if buf_obj is None:
            from sys import version_info
            nRequiredSize = int(buf_xsize * buf_ysize * len(band_list) * (_gdal.GetDataTypeSize(buf_type) / 8))
            if version_info >= (3, 0, 0):
                buf_obj_ar = [None]
                exec("buf_obj_ar[0] = b' ' * nRequiredSize")
                buf_obj = buf_obj_ar[0]
            else:
                buf_obj = ' ' * nRequiredSize
        return _gdal.Dataset_BeginAsyncReader(self, xoff, yoff, xsize, ysize, buf_obj, buf_xsize, buf_ysize, buf_type, band_list,  0, 0, 0, options)

    def GetLayer(self, iLayer=0):
        """Return the layer given an index or a name"""

        _WarnIfUserHasNotSpecifiedIfUsingOgrExceptions()

        if isinstance(iLayer, str):
            return self.GetLayerByName(str(iLayer))
        elif isinstance(iLayer, int):
            return self.GetLayerByIndex(iLayer)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(iLayer))

    def DeleteLayer(self, value):
        """Deletes the layer given an index or layer name"""
        if isinstance(value, str):
            for i in range(self.GetLayerCount()):
                name = self.GetLayer(i).GetName()
                if name == value:
                    return _gdal.Dataset_DeleteLayer(self, i)
            raise ValueError("Layer %s not found to delete" % value)
        elif isinstance(value, int):
            return _gdal.Dataset_DeleteLayer(self, value)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(value))

    def SetGCPs(self, gcps, wkt_or_spatial_ref):
        if isinstance(wkt_or_spatial_ref, str):
            return self._SetGCPs(gcps, wkt_or_spatial_ref)
        else:
            return self._SetGCPs2(gcps, wkt_or_spatial_ref)

    def _add_band_ref(self, band):
        if band is None:
            return

        import weakref

        if not hasattr(self, '_band_references'):
            self._band_references = weakref.WeakSet()

        self._band_references.add(band)
        band._parent_ds = weakref.ref(self)

    def _invalidate_bands(self):
        if hasattr(self, '_band_references'):
            for band in self._band_references:
                band.this = None

    def __del__(self):
        self._invalidate_bands()

    def __enter__(self):
        return self

    def __exit__(self, *args):
        self.Close()


# Register Dataset in _gdal:
_gdal.Dataset_swigregister(Dataset)
GEDTST_NONE = _gdal.GEDTST_NONE

GEDTST_JSON = _gdal.GEDTST_JSON

class Group(object):
    r"""Proxy of C++ GDALGroupHS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_Group

    def GetName(self, *args):
        r"""GetName(Group self) -> char const *"""
        return _gdal.Group_GetName(self, *args)

    def GetFullName(self, *args):
        r"""GetFullName(Group self) -> char const *"""
        return _gdal.Group_GetFullName(self, *args)

    def GetMDArrayNames(self, options = []) -> "list[str]":
        ret = _gdal.Group_GetMDArrayNames(self, options)
        if ret is None:
            ret = []
        return ret



    def OpenMDArray(self, *args):
        r"""OpenMDArray(Group self, char const * name, char ** options=None) -> MDArray"""
        return _gdal.Group_OpenMDArray(self, *args)

    def OpenMDArrayFromFullname(self, *args):
        r"""OpenMDArrayFromFullname(Group self, char const * name, char ** options=None) -> MDArray"""
        return _gdal.Group_OpenMDArrayFromFullname(self, *args)

    def ResolveMDArray(self, *args):
        r"""ResolveMDArray(Group self, char const * name, char const * starting_point, char ** options=None) -> MDArray"""
        return _gdal.Group_ResolveMDArray(self, *args)

    def GetGroupNames(self, options = []) -> "list[str]":
        ret = _gdal.Group_GetGroupNames(self, options)
        if ret is None:
            ret = []
        return ret



    def OpenGroup(self, *args):
        r"""OpenGroup(Group self, char const * name, char ** options=None) -> Group"""
        return _gdal.Group_OpenGroup(self, *args)

    def OpenGroupFromFullname(self, *args):
        r"""OpenGroupFromFullname(Group self, char const * name, char ** options=None) -> Group"""
        return _gdal.Group_OpenGroupFromFullname(self, *args)

    def GetVectorLayerNames(self, *args):
        r"""GetVectorLayerNames(Group self, char ** options=None) -> char **"""
        return _gdal.Group_GetVectorLayerNames(self, *args)

    def OpenVectorLayer(self, *args):
        r"""OpenVectorLayer(Group self, char const * name, char ** options=None) -> Layer"""
        return _gdal.Group_OpenVectorLayer(self, *args)

    def GetDimensions(self, *args):
        r"""GetDimensions(Group self, char ** options=None)"""
        return _gdal.Group_GetDimensions(self, *args)

    def GetAttribute(self, *args):
        r"""GetAttribute(Group self, char const * name) -> Attribute"""
        return _gdal.Group_GetAttribute(self, *args)

    def GetAttributes(self, *args):
        r"""GetAttributes(Group self, char ** options=None)"""
        return _gdal.Group_GetAttributes(self, *args)

    def GetStructuralInfo(self, *args):
        r"""GetStructuralInfo(Group self) -> char **"""
        return _gdal.Group_GetStructuralInfo(self, *args)

    def CreateGroup(self, *args):
        r"""CreateGroup(Group self, char const * name, char ** options=None) -> Group"""
        return _gdal.Group_CreateGroup(self, *args)

    def DeleteGroup(self, *args):
        r"""DeleteGroup(Group self, char const * name, char ** options=None) -> CPLErr"""
        return _gdal.Group_DeleteGroup(self, *args)

    def CreateDimension(self, *args):
        r"""CreateDimension(Group self, char const * name, char const * type, char const * direction, GUIntBig size, char ** options=None) -> Dimension"""
        return _gdal.Group_CreateDimension(self, *args)

    def CreateMDArray(self, *args):
        r"""CreateMDArray(Group self, char const * name, int dimensions, ExtendedDataType data_type, char ** options=None) -> MDArray"""
        return _gdal.Group_CreateMDArray(self, *args)

    def DeleteMDArray(self, *args):
        r"""DeleteMDArray(Group self, char const * name, char ** options=None) -> CPLErr"""
        return _gdal.Group_DeleteMDArray(self, *args)

    def CreateAttribute(self, *args):
        r"""CreateAttribute(Group self, char const * name, int dimensions, ExtendedDataType data_type, char ** options=None) -> Attribute"""
        return _gdal.Group_CreateAttribute(self, *args)

    def DeleteAttribute(self, *args):
        r"""DeleteAttribute(Group self, char const * name, char ** options=None) -> CPLErr"""
        return _gdal.Group_DeleteAttribute(self, *args)

    def Rename(self, *args):
        r"""Rename(Group self, char const * newName) -> CPLErr"""
        return _gdal.Group_Rename(self, *args)

    def SubsetDimensionFromSelection(self, *args):
        r"""SubsetDimensionFromSelection(Group self, char const * selection, char ** options=None) -> Group"""
        return _gdal.Group_SubsetDimensionFromSelection(self, *args)

# Register Group in _gdal:
_gdal.Group_swigregister(Group)
class Statistics(object):
    r"""Proxy of C++ Statistics class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    min = property(_gdal.Statistics_min_get, doc=r"""min : double""")
    max = property(_gdal.Statistics_max_get, doc=r"""max : double""")
    mean = property(_gdal.Statistics_mean_get, doc=r"""mean : double""")
    std_dev = property(_gdal.Statistics_std_dev_get, doc=r"""std_dev : double""")
    valid_count = property(_gdal.Statistics_valid_count_get, doc=r"""valid_count : GIntBig""")
    __swig_destroy__ = _gdal.delete_Statistics

    def __init__(self, *args):
        r"""__init__(Statistics self) -> Statistics"""
        _gdal.Statistics_swiginit(self, _gdal.new_Statistics(*args))

# Register Statistics in _gdal:
_gdal.Statistics_swigregister(Statistics)
class MDArray(object):
    r"""Proxy of C++ GDALMDArrayHS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_MDArray

    def GetName(self, *args):
        r"""GetName(MDArray self) -> char const *"""
        return _gdal.MDArray_GetName(self, *args)

    def GetFullName(self, *args):
        r"""GetFullName(MDArray self) -> char const *"""
        return _gdal.MDArray_GetFullName(self, *args)

    def GetTotalElementsCount(self, *args):
        r"""GetTotalElementsCount(MDArray self) -> GUIntBig"""
        return _gdal.MDArray_GetTotalElementsCount(self, *args)

    def GetDimensionCount(self, *args):
        r"""GetDimensionCount(MDArray self) -> size_t"""
        return _gdal.MDArray_GetDimensionCount(self, *args)

    def GetDimensions(self, *args):
        r"""GetDimensions(MDArray self)"""
        return _gdal.MDArray_GetDimensions(self, *args)

    def GetCoordinateVariables(self, *args):
        r"""GetCoordinateVariables(MDArray self)"""
        return _gdal.MDArray_GetCoordinateVariables(self, *args)

    def GetBlockSize(self, *args):
        r"""GetBlockSize(MDArray self)"""
        return _gdal.MDArray_GetBlockSize(self, *args)

    def GetProcessingChunkSize(self, *args):
        r"""GetProcessingChunkSize(MDArray self, size_t nMaxChunkMemory)"""
        return _gdal.MDArray_GetProcessingChunkSize(self, *args)

    def GetDataType(self, *args):
        r"""GetDataType(MDArray self) -> ExtendedDataType"""
        return _gdal.MDArray_GetDataType(self, *args)

    def GetStructuralInfo(self, *args):
        r"""GetStructuralInfo(MDArray self) -> char **"""
        return _gdal.MDArray_GetStructuralInfo(self, *args)

    def Resize(self, *args):
        r"""Resize(MDArray self, int newDimensions, char ** options=None) -> CPLErr"""
        return _gdal.MDArray_Resize(self, *args)

    def Read(self, *args):
        r"""Read(MDArray self, int nDims1, int nDims2, int nDims3, int nDims4, ExtendedDataType buffer_datatype) -> CPLErr"""
        return _gdal.MDArray_Read(self, *args)

    def WriteStringArray(self, *args):
        r"""WriteStringArray(MDArray self, int nDims1, int nDims2, int nDims3, ExtendedDataType buffer_datatype, char ** options) -> CPLErr"""
        return _gdal.MDArray_WriteStringArray(self, *args)

    def Write(self, *args):
        r"""Write(MDArray self, int nDims1, int nDims2, int nDims3, int nDims4, ExtendedDataType buffer_datatype, GIntBig buf_len) -> CPLErr"""
        return _gdal.MDArray_Write(self, *args)

    def AdviseRead(self, *args):
        r"""AdviseRead(MDArray self, int nDims1, int nDims2, char ** options=None) -> CPLErr"""
        return _gdal.MDArray_AdviseRead(self, *args)

    def GetAttribute(self, *args):
        r"""GetAttribute(MDArray self, char const * name) -> Attribute"""
        return _gdal.MDArray_GetAttribute(self, *args)

    def GetAttributes(self, *args):
        r"""GetAttributes(MDArray self, char ** options=None)"""
        return _gdal.MDArray_GetAttributes(self, *args)

    def CreateAttribute(self, *args):
        r"""CreateAttribute(MDArray self, char const * name, int dimensions, ExtendedDataType data_type, char ** options=None) -> Attribute"""
        return _gdal.MDArray_CreateAttribute(self, *args)

    def DeleteAttribute(self, *args):
        r"""DeleteAttribute(MDArray self, char const * name, char ** options=None) -> CPLErr"""
        return _gdal.MDArray_DeleteAttribute(self, *args)

    def GetNoDataValueAsRaw(self, *args):
        r"""GetNoDataValueAsRaw(MDArray self) -> CPLErr"""
        return _gdal.MDArray_GetNoDataValueAsRaw(self, *args)

    def GetNoDataValueAsDouble(self, *args):
        r"""GetNoDataValueAsDouble(MDArray self)"""
        return _gdal.MDArray_GetNoDataValueAsDouble(self, *args)

    def GetNoDataValueAsInt64(self, *args):
        r"""GetNoDataValueAsInt64(MDArray self)"""
        return _gdal.MDArray_GetNoDataValueAsInt64(self, *args)

    def GetNoDataValueAsUInt64(self, *args):
        r"""GetNoDataValueAsUInt64(MDArray self)"""
        return _gdal.MDArray_GetNoDataValueAsUInt64(self, *args)

    def GetNoDataValueAsString(self, *args):
        r"""GetNoDataValueAsString(MDArray self) -> retStringAndCPLFree *"""
        return _gdal.MDArray_GetNoDataValueAsString(self, *args)

    def SetNoDataValueDouble(self, *args):
        r"""SetNoDataValueDouble(MDArray self, double d) -> CPLErr"""
        return _gdal.MDArray_SetNoDataValueDouble(self, *args)

    def SetNoDataValueInt64(self, *args):
        r"""SetNoDataValueInt64(MDArray self, GIntBig v) -> CPLErr"""
        return _gdal.MDArray_SetNoDataValueInt64(self, *args)

    def SetNoDataValueUInt64(self, *args):
        r"""SetNoDataValueUInt64(MDArray self, GUIntBig v) -> CPLErr"""
        return _gdal.MDArray_SetNoDataValueUInt64(self, *args)

    def SetNoDataValueString(self, *args):
        r"""SetNoDataValueString(MDArray self, char const * nodata) -> CPLErr"""
        return _gdal.MDArray_SetNoDataValueString(self, *args)

    def SetNoDataValueRaw(self, *args):
        r"""SetNoDataValueRaw(MDArray self, GIntBig nLen) -> CPLErr"""
        return _gdal.MDArray_SetNoDataValueRaw(self, *args)

    def DeleteNoDataValue(self, *args):
        r"""DeleteNoDataValue(MDArray self) -> CPLErr"""
        return _gdal.MDArray_DeleteNoDataValue(self, *args)

    def GetOffset(self, *args):
        r"""GetOffset(MDArray self)"""
        return _gdal.MDArray_GetOffset(self, *args)

    def GetOffsetStorageType(self, *args):
        r"""GetOffsetStorageType(MDArray self) -> GDALDataType"""
        return _gdal.MDArray_GetOffsetStorageType(self, *args)

    def GetScale(self, *args):
        r"""GetScale(MDArray self)"""
        return _gdal.MDArray_GetScale(self, *args)

    def GetScaleStorageType(self, *args):
        r"""GetScaleStorageType(MDArray self) -> GDALDataType"""
        return _gdal.MDArray_GetScaleStorageType(self, *args)

    def SetOffset(self, *args, **kwargs):
        r"""SetOffset(MDArray self, double val, GDALDataType storageType=GDT_Unknown) -> CPLErr"""
        return _gdal.MDArray_SetOffset(self, *args, **kwargs)

    def SetScale(self, *args, **kwargs):
        r"""SetScale(MDArray self, double val, GDALDataType storageType=GDT_Unknown) -> CPLErr"""
        return _gdal.MDArray_SetScale(self, *args, **kwargs)

    def SetUnit(self, *args):
        r"""SetUnit(MDArray self, char const * unit) -> CPLErr"""
        return _gdal.MDArray_SetUnit(self, *args)

    def GetUnit(self, *args):
        r"""GetUnit(MDArray self) -> char const *"""
        return _gdal.MDArray_GetUnit(self, *args)

    def SetSpatialRef(self, *args):
        r"""SetSpatialRef(MDArray self, SpatialReference srs) -> OGRErr"""
        return _gdal.MDArray_SetSpatialRef(self, *args)

    def GetSpatialRef(self, *args):
        r"""GetSpatialRef(MDArray self) -> SpatialReference"""
        return _gdal.MDArray_GetSpatialRef(self, *args)

    def GetView(self, *args):
        r"""GetView(MDArray self, char const * viewExpr) -> MDArray"""
        return _gdal.MDArray_GetView(self, *args)

    def Transpose(self, *args):
        r"""Transpose(MDArray self, int axisMap) -> MDArray"""
        return _gdal.MDArray_Transpose(self, *args)

    def GetUnscaled(self, *args):
        r"""GetUnscaled(MDArray self) -> MDArray"""
        return _gdal.MDArray_GetUnscaled(self, *args)

    def GetMask(self, *args):
        r"""GetMask(MDArray self, char ** options=None) -> MDArray"""
        return _gdal.MDArray_GetMask(self, *args)

    def GetGridded(self, *args, **kwargs):
        r"""GetGridded(MDArray self, char const * pszGridOptions, MDArray xArray=None, MDArray yArray=None, char ** options=None) -> MDArray"""
        return _gdal.MDArray_GetGridded(self, *args, **kwargs)

    def AsClassicDataset(self, *args):
        r"""AsClassicDataset(MDArray self, size_t iXDim, size_t iYDim, Group hRootGroup=None, char ** options=None) -> Dataset"""
        return _gdal.MDArray_AsClassicDataset(self, *args)

    def GetStatistics(self, *args, **kwargs):
        r"""GetStatistics(MDArray self, bool approx_ok=FALSE, bool force=TRUE, GDALProgressFunc callback=0, void * callback_data=None) -> Statistics"""
        return _gdal.MDArray_GetStatistics(self, *args, **kwargs)

    def ComputeStatistics(self, *args, **kwargs):
        r"""ComputeStatistics(MDArray self, bool approx_ok=FALSE, GDALProgressFunc callback=0, void * callback_data=None, char ** options=None) -> Statistics"""
        return _gdal.MDArray_ComputeStatistics(self, *args, **kwargs)

    def GetResampled(self, *args):
        r"""GetResampled(MDArray self, int nDimensions, GDALRIOResampleAlg resample_alg, OSRSpatialReferenceShadow ** srs, char ** options=None) -> MDArray"""
        return _gdal.MDArray_GetResampled(self, *args)

    def Cache(self, *args):
        r"""Cache(MDArray self, char ** options=None) -> bool"""
        return _gdal.MDArray_Cache(self, *args)

    def Rename(self, *args):
        r"""Rename(MDArray self, char const * newName) -> CPLErr"""
        return _gdal.MDArray_Rename(self, *args)

    def Read(self,
             array_start_idx = None,
             count = None,
             array_step = None,
             buffer_stride = None,
             buffer_datatype = None):
        if not array_start_idx:
          array_start_idx = [0] * self.GetDimensionCount()
        if not count:
          count = [ dim.GetSize() for dim in self.GetDimensions() ]
        if not array_step:
          array_step = [1] * self.GetDimensionCount()
        if not buffer_stride:
          stride = 1
          buffer_stride = []
    # To compute strides we must proceed from the fastest varying dimension
    # (the last one), and then reverse the result
          for cnt in reversed(count):
              buffer_stride.append(stride)
              stride *= cnt
          buffer_stride.reverse()
        if not buffer_datatype:
          buffer_datatype = self.GetDataType()
        return _gdal.MDArray_Read(self, array_start_idx, count, array_step, buffer_stride, buffer_datatype)

    def ReadAsArray(self,
                    array_start_idx = None,
                    count = None,
                    array_step = None,
                    buffer_datatype = None,
                    buf_obj = None):

        from osgeo import gdal_array
        return gdal_array.MDArrayReadAsArray(self, array_start_idx, count, array_step, buffer_datatype, buf_obj)

    def AdviseRead(self, array_start_idx = None, count = None, options = []):
        if not array_start_idx:
          array_start_idx = [0] * self.GetDimensionCount()
        if not count:
          count = [ (self.GetDimensions()[i].GetSize() - array_start_idx[i]) for i in range (self.GetDimensionCount()) ]
        return _gdal.MDArray_AdviseRead(self, array_start_idx, count, options)

    def __getitem__(self, item):

          def stringify(v):
              if v == Ellipsis:
                  return '...'
              if isinstance(v, slice):
                  return ':'.join([str(x) if x is not None else '' for x in (v.start, v.stop, v.step)])
              if isinstance(v, str):
                  return v
              if isinstance(v, (int, type(12345678901234))):
                  return str(v)
              try:
                  import numpy as np
                  if v == np.newaxis:
                      return 'newaxis'
              except:
                  pass

              return str(v)

          if isinstance(item, str):
              return self.GetView('["' + item.replace('\\', '\\\\').replace('"', '\\"') + '"]')
          elif isinstance(item, slice):
              return self.GetView('[' + stringify(item) + ']')
          elif isinstance(item, tuple):
              return self.GetView('[' + ','.join([stringify(x) for x in item]) + ']')
          else:
              return self.GetView('[' + stringify(item) + ']')

    def Write(self,
             buffer,
             array_start_idx = None,
             count = None,
             array_step = None,
             buffer_stride = None,
             buffer_datatype = None):

        dimCount = self.GetDimensionCount()

    # Redirect to numpy-friendly WriteArray() if buffer is a numpy array
    # and other arguments are compatible
        if type(buffer).__name__ == 'ndarray' and \
           count is None and buffer_stride is None and buffer_datatype is None:
            return self.WriteArray(buffer, array_start_idx=array_start_idx, array_step=array_step)

    # Special case for buffer of type array and 1D arrays
        if dimCount == 1 and type(buffer).__name__ == 'array' and \
           count is None and buffer_stride is None and buffer_datatype is None:
            map_typecode_itemsize_to_gdal = {
               ('B', 1): GDT_Byte,
               ('b', 1): GDT_Int8,
               ('h', 2): GDT_Int16,
               ('H', 2): GDT_UInt16,
               ('i', 4): GDT_Int32,
               ('I', 4): GDT_UInt32,
               ('l', 4): GDT_Int32,
               ('q', 8): GDT_Int64,
               ('Q', 8): GDT_UInt64,
               ('f', 4): GDT_Float32,
               ('d', 8): GDT_Float64
            }
            key = (buffer.typecode, buffer.itemsize)
            if key not in map_typecode_itemsize_to_gdal:
                raise Exception("unhandled type for buffer of type array")
            buffer_datatype = ExtendedDataType.Create(map_typecode_itemsize_to_gdal[key])

    # Special case for a list of numeric values and 1D arrays
        elif dimCount == 1 and type(buffer) == type([]) and len(buffer) != 0 \
             and self.GetDataType().GetClass() != GEDTC_STRING:
            buffer_datatype = GDT_Int32
            for v in buffer:
                if isinstance(v, int):
                    if v >= (1 << 31) or v < -(1 << 31):
                        buffer_datatype = GDT_Float64
                elif isinstance(v, float):
                    buffer_datatype = GDT_Float64
                else:
                    raise ValueError('Only lists with integer or float elements are supported')
            import array
            buffer = array.array('d' if buffer_datatype == GDT_Float64 else 'i', buffer)
            buffer_datatype = ExtendedDataType.Create(buffer_datatype)

        if not buffer_datatype:
          buffer_datatype = self.GetDataType()

        is_1d_string = self.GetDataType().GetClass() == GEDTC_STRING and buffer_datatype.GetClass() == GEDTC_STRING and dimCount == 1

        if not array_start_idx:
          array_start_idx = [0] * dimCount

        if not count:
          if is_1d_string:
              assert type(buffer) == type([])
              count = [ len(buffer) ]
          else:
              count = [ dim.GetSize() for dim in self.GetDimensions() ]

        if not array_step:
          array_step = [1] * dimCount

        if not buffer_stride:
          stride = 1
          buffer_stride = []
    # To compute strides we must proceed from the fastest varying dimension
    # (the last one), and then reverse the result
          for cnt in reversed(count):
              buffer_stride.append(stride)
              stride *= cnt
          buffer_stride.reverse()

        if is_1d_string:
            return _gdal.MDArray_WriteStringArray(self, array_start_idx, count, array_step, buffer_datatype, buffer)

        return _gdal.MDArray_Write(self, array_start_idx, count, array_step, buffer_stride, buffer_datatype, buffer)

    def WriteArray(self, array,
                    array_start_idx = None,
                    array_step = None):

        from osgeo import gdal_array
        return gdal_array.MDArrayWriteArray(self, array, array_start_idx, array_step)

    def ReadAsMaskedArray(self,
                    array_start_idx = None,
                    count = None,
                    array_step = None):
        """ Return a numpy masked array of ReadAsArray() with GetMask() """
        import numpy
        mask = self.GetMask()
        if mask is not None:
            array = self.ReadAsArray(array_start_idx, count, array_step)
            mask_array = mask.ReadAsArray(array_start_idx, count, array_step)
            bool_array = ~mask_array.astype(bool)
            return numpy.ma.array(array, mask=bool_array)
        else:
            return numpy.ma.array(self.ReadAsArray(array_start_idx, count, array_step), mask=None)

    def GetShape(self):
      """ Return the shape of the array """
      if not self.GetDimensionCount():
        return None
      shp = ()
      for dim in self.GetDimensions():
        shp += (dim.GetSize(),)
      return shp

    shape = property(fget=GetShape, doc='Returns the shape of the array.')


    def GetNoDataValue(self):
      """GetNoDataValue(MDArray self) -> value """

      dt = self.GetDataType()
      if dt.GetClass() == GEDTC_NUMERIC and dt.GetNumericDataType() == gdalconst.GDT_Int64:
          return _gdal.MDArray_GetNoDataValueAsInt64(self)

      if dt.GetClass() == GEDTC_NUMERIC and dt.GetNumericDataType() == gdalconst.GDT_UInt64:
          return _gdal.MDArray_GetNoDataValueAsUInt64(self)

      return _gdal.MDArray_GetNoDataValueAsDouble(self)


    def SetNoDataValue(self, value):
      """SetNoDataValue(MDArray self, value) -> CPLErr"""

      dt = self.GetDataType()
      if dt.GetClass() == GEDTC_NUMERIC and dt.GetNumericDataType() == gdalconst.GDT_Int64:
          return _gdal.MDArray_SetNoDataValueInt64(self, value)

      if dt.GetClass() == GEDTC_NUMERIC and dt.GetNumericDataType() == gdalconst.GDT_UInt64:
          return _gdal.MDArray_SetNoDataValueUInt64(self, value)

      return _gdal.MDArray_SetNoDataValueDouble(self, value)


# Register MDArray in _gdal:
_gdal.MDArray_swigregister(MDArray)
class Attribute(object):
    r"""Proxy of C++ GDALAttributeHS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_Attribute

    def GetName(self, *args):
        r"""GetName(Attribute self) -> char const *"""
        return _gdal.Attribute_GetName(self, *args)

    def GetFullName(self, *args):
        r"""GetFullName(Attribute self) -> char const *"""
        return _gdal.Attribute_GetFullName(self, *args)

    def GetTotalElementsCount(self, *args):
        r"""GetTotalElementsCount(Attribute self) -> GUIntBig"""
        return _gdal.Attribute_GetTotalElementsCount(self, *args)

    def GetDimensionCount(self, *args):
        r"""GetDimensionCount(Attribute self) -> size_t"""
        return _gdal.Attribute_GetDimensionCount(self, *args)

    def GetDimensionsSize(self, *args):
        r"""GetDimensionsSize(Attribute self)"""
        return _gdal.Attribute_GetDimensionsSize(self, *args)

    def GetDataType(self, *args):
        r"""GetDataType(Attribute self) -> ExtendedDataType"""
        return _gdal.Attribute_GetDataType(self, *args)

    def ReadAsRaw(self, *args):
        r"""ReadAsRaw(Attribute self) -> CPLErr"""
        return _gdal.Attribute_ReadAsRaw(self, *args)

    def ReadAsString(self, *args):
        r"""ReadAsString(Attribute self) -> char const *"""
        return _gdal.Attribute_ReadAsString(self, *args)

    def ReadAsInt(self, *args):
        r"""ReadAsInt(Attribute self) -> int"""
        return _gdal.Attribute_ReadAsInt(self, *args)

    def ReadAsDouble(self, *args):
        r"""ReadAsDouble(Attribute self) -> double"""
        return _gdal.Attribute_ReadAsDouble(self, *args)

    def ReadAsStringArray(self, *args):
        r"""ReadAsStringArray(Attribute self) -> char **"""
        return _gdal.Attribute_ReadAsStringArray(self, *args)

    def ReadAsIntArray(self, *args):
        r"""ReadAsIntArray(Attribute self)"""
        return _gdal.Attribute_ReadAsIntArray(self, *args)

    def ReadAsDoubleArray(self, *args):
        r"""ReadAsDoubleArray(Attribute self)"""
        return _gdal.Attribute_ReadAsDoubleArray(self, *args)

    def WriteRaw(self, *args):
        r"""WriteRaw(Attribute self, GIntBig nLen) -> CPLErr"""
        return _gdal.Attribute_WriteRaw(self, *args)

    def WriteString(self, *args):
        r"""WriteString(Attribute self, char const * val) -> CPLErr"""
        return _gdal.Attribute_WriteString(self, *args)

    def WriteStringArray(self, *args):
        r"""WriteStringArray(Attribute self, char ** vals) -> CPLErr"""
        return _gdal.Attribute_WriteStringArray(self, *args)

    def WriteInt(self, *args):
        r"""WriteInt(Attribute self, int val) -> CPLErr"""
        return _gdal.Attribute_WriteInt(self, *args)

    def WriteDouble(self, *args):
        r"""WriteDouble(Attribute self, double val) -> CPLErr"""
        return _gdal.Attribute_WriteDouble(self, *args)

    def WriteDoubleArray(self, *args):
        r"""WriteDoubleArray(Attribute self, int nList) -> CPLErr"""
        return _gdal.Attribute_WriteDoubleArray(self, *args)

    def Rename(self, *args):
        r"""Rename(Attribute self, char const * newName) -> CPLErr"""
        return _gdal.Attribute_Rename(self, *args)


    def Read(self):
      """ Read an attribute and return it with the most appropriate type """
      dt = self.GetDataType()
      dt_class = dt.GetClass()
      if dt_class == GEDTC_STRING:
          if self.GetTotalElementsCount() == 1:
              s = self.ReadAsString()
              if dt.GetSubType() == GEDTST_JSON:
                  try:
                      import json
                      return json.loads(s)
                  except:
                      pass
              return s
          return self.ReadAsStringArray()
      if dt_class == GEDTC_NUMERIC:
          if dt.GetNumericDataType() in (GDT_Byte, GDT_Int8, GDT_Int16, GDT_UInt16, GDT_Int32):
              if self.GetTotalElementsCount() == 1:
                  return self.ReadAsInt()
              else:
                  return self.ReadAsIntArray()
          else:
              if self.GetTotalElementsCount() == 1:
                  return self.ReadAsDouble()
              else:
                  return self.ReadAsDoubleArray()
      return self.ReadAsRaw()

    def Write(self, val):
      if isinstance(val, (int, type(12345678901234))):
          if val >= -0x80000000 and val <= 0x7FFFFFFF:
              return self.WriteInt(val)
          else:
              return self.WriteDouble(val)
      if isinstance(val, float):
        return self.WriteDouble(val)
      if isinstance(val, str) and self.GetDataType().GetClass() != GEDTC_COMPOUND:
        return self.WriteString(val)
      if isinstance(val, list):
        if len(val) == 0:
          if self.GetDataType().GetClass() == GEDTC_STRING:
              return self.WriteStringArray(val)
          else:
              return self.WriteDoubleArray(val)
        if isinstance(val[0], (int, type(12345678901234), float)):
          return self.WriteDoubleArray(val)
        if isinstance(val[0], str):
          return self.WriteStringArray(val)
      if isinstance(val, dict) and self.GetDataType().GetSubType() == GEDTST_JSON:
          import json
          return self.WriteString(json.dumps(val))
      return self.WriteRaw(val)



# Register Attribute in _gdal:
_gdal.Attribute_swigregister(Attribute)
class Dimension(object):
    r"""Proxy of C++ GDALDimensionHS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_Dimension

    def GetName(self, *args):
        r"""GetName(Dimension self) -> char const *"""
        return _gdal.Dimension_GetName(self, *args)

    def GetFullName(self, *args):
        r"""GetFullName(Dimension self) -> char const *"""
        return _gdal.Dimension_GetFullName(self, *args)

    def GetType(self, *args):
        r"""GetType(Dimension self) -> char const *"""
        return _gdal.Dimension_GetType(self, *args)

    def GetDirection(self, *args):
        r"""GetDirection(Dimension self) -> char const *"""
        return _gdal.Dimension_GetDirection(self, *args)

    def GetSize(self, *args):
        r"""GetSize(Dimension self) -> GUIntBig"""
        return _gdal.Dimension_GetSize(self, *args)

    def GetIndexingVariable(self, *args):
        r"""GetIndexingVariable(Dimension self) -> MDArray"""
        return _gdal.Dimension_GetIndexingVariable(self, *args)

    def SetIndexingVariable(self, *args):
        r"""SetIndexingVariable(Dimension self, MDArray array) -> bool"""
        return _gdal.Dimension_SetIndexingVariable(self, *args)

    def Rename(self, *args):
        r"""Rename(Dimension self, char const * newName) -> CPLErr"""
        return _gdal.Dimension_Rename(self, *args)

# Register Dimension in _gdal:
_gdal.Dimension_swigregister(Dimension)
GEDTC_NUMERIC = _gdal.GEDTC_NUMERIC

GEDTC_STRING = _gdal.GEDTC_STRING

GEDTC_COMPOUND = _gdal.GEDTC_COMPOUND

class ExtendedDataType(object):
    r"""Proxy of C++ GDALExtendedDataTypeHS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_ExtendedDataType

    @staticmethod
    def Create(*args):
        r"""Create(GDALDataType dt) -> ExtendedDataType"""
        return _gdal.ExtendedDataType_Create(*args)

    @staticmethod
    def CreateString(*args):
        r"""CreateString(size_t nMaxStringLength=0, GDALExtendedDataTypeSubType eSubType=GEDTST_NONE) -> ExtendedDataType"""
        return _gdal.ExtendedDataType_CreateString(*args)

    @staticmethod
    def CreateCompound(*args):
        r"""CreateCompound(char const * name, size_t nTotalSize, int nComps) -> ExtendedDataType"""
        return _gdal.ExtendedDataType_CreateCompound(*args)

    def GetName(self, *args):
        r"""GetName(ExtendedDataType self) -> char const *"""
        return _gdal.ExtendedDataType_GetName(self, *args)

    def GetClass(self, *args):
        r"""GetClass(ExtendedDataType self) -> GDALExtendedDataTypeClass"""
        return _gdal.ExtendedDataType_GetClass(self, *args)

    def GetNumericDataType(self, *args):
        r"""GetNumericDataType(ExtendedDataType self) -> GDALDataType"""
        return _gdal.ExtendedDataType_GetNumericDataType(self, *args)

    def GetSize(self, *args):
        r"""GetSize(ExtendedDataType self) -> size_t"""
        return _gdal.ExtendedDataType_GetSize(self, *args)

    def GetMaxStringLength(self, *args):
        r"""GetMaxStringLength(ExtendedDataType self) -> size_t"""
        return _gdal.ExtendedDataType_GetMaxStringLength(self, *args)

    def GetSubType(self, *args):
        r"""GetSubType(ExtendedDataType self) -> GDALExtendedDataTypeSubType"""
        return _gdal.ExtendedDataType_GetSubType(self, *args)

    def GetComponents(self, *args):
        r"""GetComponents(ExtendedDataType self)"""
        return _gdal.ExtendedDataType_GetComponents(self, *args)

    def CanConvertTo(self, *args):
        r"""CanConvertTo(ExtendedDataType self, ExtendedDataType other) -> bool"""
        return _gdal.ExtendedDataType_CanConvertTo(self, *args)

    def Equals(self, *args):
        r"""Equals(ExtendedDataType self, ExtendedDataType other) -> bool"""
        return _gdal.ExtendedDataType_Equals(self, *args)


    def __eq__(self, other):
      return self.Equals(other)

    def __ne__(self, other):
      return not self.__eq__(other)


# Register ExtendedDataType in _gdal:
_gdal.ExtendedDataType_swigregister(ExtendedDataType)
class EDTComponent(object):
    r"""Proxy of C++ GDALEDTComponentHS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_EDTComponent

    @staticmethod
    def Create(*args):
        r"""Create(char const * name, size_t offset, ExtendedDataType type) -> EDTComponent"""
        return _gdal.EDTComponent_Create(*args)

    def GetName(self, *args):
        r"""GetName(EDTComponent self) -> char const *"""
        return _gdal.EDTComponent_GetName(self, *args)

    def GetOffset(self, *args):
        r"""GetOffset(EDTComponent self) -> size_t"""
        return _gdal.EDTComponent_GetOffset(self, *args)

    def GetType(self, *args):
        r"""GetType(EDTComponent self) -> ExtendedDataType"""
        return _gdal.EDTComponent_GetType(self, *args)

# Register EDTComponent in _gdal:
_gdal.EDTComponent_swigregister(EDTComponent)
class Band(MajorObject):
    r"""Proxy of C++ GDALRasterBandShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    XSize = property(_gdal.Band_XSize_get, doc=r"""XSize : int""")
    YSize = property(_gdal.Band_YSize_get, doc=r"""YSize : int""")
    DataType = property(_gdal.Band_DataType_get, doc=r"""DataType : GDALDataType""")

    def GetDataset(self, *args):
        r"""GetDataset(Band self) -> Dataset"""
        return _gdal.Band_GetDataset(self, *args)

    def GetBand(self, *args):
        r"""GetBand(Band self) -> int"""
        return _gdal.Band_GetBand(self, *args)

    def GetBlockSize(self, *args):
        r"""GetBlockSize(Band self)"""
        return _gdal.Band_GetBlockSize(self, *args)

    def GetActualBlockSize(self, *args):
        r"""GetActualBlockSize(Band self, int nXBlockOff, int nYBlockOff)"""
        return _gdal.Band_GetActualBlockSize(self, *args)

    def GetColorInterpretation(self, *args):
        r"""GetColorInterpretation(Band self) -> GDALColorInterp"""
        return _gdal.Band_GetColorInterpretation(self, *args)

    def GetRasterColorInterpretation(self, *args):
        r"""GetRasterColorInterpretation(Band self) -> GDALColorInterp"""
        return _gdal.Band_GetRasterColorInterpretation(self, *args)

    def SetColorInterpretation(self, *args):
        r"""SetColorInterpretation(Band self, GDALColorInterp val) -> CPLErr"""
        return _gdal.Band_SetColorInterpretation(self, *args)

    def SetRasterColorInterpretation(self, *args):
        r"""SetRasterColorInterpretation(Band self, GDALColorInterp val) -> CPLErr"""
        return _gdal.Band_SetRasterColorInterpretation(self, *args)

    def GetNoDataValue(self):
        """GetNoDataValue(Band self) -> value """

        if self.DataType == gdalconst.GDT_Int64:
            return _gdal.Band_GetNoDataValueAsInt64(self)

        if self.DataType == gdalconst.GDT_UInt64:
            return _gdal.Band_GetNoDataValueAsUInt64(self)

        return _gdal.Band_GetNoDataValue(self)



    def GetNoDataValueAsInt64(self, *args):
        r"""GetNoDataValueAsInt64(Band self)"""
        return _gdal.Band_GetNoDataValueAsInt64(self, *args)

    def GetNoDataValueAsUInt64(self, *args):
        r"""GetNoDataValueAsUInt64(Band self)"""
        return _gdal.Band_GetNoDataValueAsUInt64(self, *args)

    def SetNoDataValue(self, value) -> "CPLErr":
        """SetNoDataValue(Band self, value) -> CPLErr"""

        if self.DataType == gdalconst.GDT_Int64:
            return _gdal.Band_SetNoDataValueAsInt64(self, value)

        if self.DataType == gdalconst.GDT_UInt64:
            return _gdal.Band_SetNoDataValueAsUInt64(self, value)

        return _gdal.Band_SetNoDataValue(self, value)



    def SetNoDataValueAsInt64(self, *args):
        r"""SetNoDataValueAsInt64(Band self, GIntBig v) -> CPLErr"""
        return _gdal.Band_SetNoDataValueAsInt64(self, *args)

    def SetNoDataValueAsUInt64(self, *args):
        r"""SetNoDataValueAsUInt64(Band self, GUIntBig v) -> CPLErr"""
        return _gdal.Band_SetNoDataValueAsUInt64(self, *args)

    def DeleteNoDataValue(self, *args):
        r"""DeleteNoDataValue(Band self) -> CPLErr"""
        return _gdal.Band_DeleteNoDataValue(self, *args)

    def GetUnitType(self, *args):
        r"""GetUnitType(Band self) -> char const *"""
        return _gdal.Band_GetUnitType(self, *args)

    def SetUnitType(self, *args):
        r"""SetUnitType(Band self, char const * val) -> CPLErr"""
        return _gdal.Band_SetUnitType(self, *args)

    def GetRasterCategoryNames(self, *args):
        r"""GetRasterCategoryNames(Band self) -> char **"""
        return _gdal.Band_GetRasterCategoryNames(self, *args)

    def SetRasterCategoryNames(self, *args):
        r"""SetRasterCategoryNames(Band self, char ** names) -> CPLErr"""
        return _gdal.Band_SetRasterCategoryNames(self, *args)

    def GetMinimum(self, *args):
        r"""GetMinimum(Band self)"""
        return _gdal.Band_GetMinimum(self, *args)

    def GetMaximum(self, *args):
        r"""GetMaximum(Band self)"""
        return _gdal.Band_GetMaximum(self, *args)

    def GetOffset(self, *args):
        r"""GetOffset(Band self)"""
        return _gdal.Band_GetOffset(self, *args)

    def GetScale(self, *args):
        r"""GetScale(Band self)"""
        return _gdal.Band_GetScale(self, *args)

    def SetOffset(self, *args):
        r"""SetOffset(Band self, double val) -> CPLErr"""
        return _gdal.Band_SetOffset(self, *args)

    def SetScale(self, *args):
        r"""SetScale(Band self, double val) -> CPLErr"""
        return _gdal.Band_SetScale(self, *args)

    def GetStatistics(self, *args):
        r"""GetStatistics(Band self, int approx_ok, int force) -> CPLErr"""
        return _gdal.Band_GetStatistics(self, *args)

    def ComputeStatistics(self, *args, **kwargs) -> "CPLErr":
        """ComputeStatistics(Band self, bool approx_ok, callback=None, callback_data=None) -> CPLErr"""

        if len(args) == 1:
            kwargs["approx_ok"] = args[0]
            args = ()

        if "approx_ok" in kwargs:
    # Compatibility with older signature that used int for approx_ok
            if kwargs["approx_ok"] == 0:
                kwargs["approx_ok"] = False
            elif kwargs["approx_ok"] == 1:
                kwargs["approx_ok"] = True
            elif isinstance(kwargs["approx_ok"], int):
                raise Exception("approx_ok value should be 0/1/False/True")

        return _gdal.Band_ComputeStatistics(self, *args, **kwargs)



    def SetStatistics(self, *args):
        r"""SetStatistics(Band self, double min, double max, double mean, double stddev) -> CPLErr"""
        return _gdal.Band_SetStatistics(self, *args)

    def GetOverviewCount(self, *args):
        r"""GetOverviewCount(Band self) -> int"""
        return _gdal.Band_GetOverviewCount(self, *args)

    def GetOverview(self, *args):
        r"""GetOverview(Band self, int i) -> Band"""
        val = _gdal.Band_GetOverview(self, *args)

        if hasattr(self, '_parent_ds') and self._parent_ds():
            self._parent_ds()._add_band_ref(val)


        return val


    def Checksum(self, *args, **kwargs):
        r"""Checksum(Band self, int xoff=0, int yoff=0, int * xsize=None, int * ysize=None) -> int"""
        return _gdal.Band_Checksum(self, *args, **kwargs)

    def ComputeRasterMinMax(self, *args, **kwargs):
        """ComputeRasterMinMax(Band self, bool approx_ok=False, bool can_return_none=False) -> (min, max) or None"""

        if len(args) == 1:
            kwargs["approx_ok"] = args[0]
            args = ()

        if "approx_ok" in kwargs:
    # Compatibility with older signature that used int for approx_ok
            if kwargs["approx_ok"] == 0:
                kwargs["approx_ok"] = False
            elif kwargs["approx_ok"] == 1:
                kwargs["approx_ok"] = True
            elif isinstance(kwargs["approx_ok"], int):
                raise Exception("approx_ok value should be 0/1/False/True")

    # can_return_null is used in other methods
        if "can_return_null" in kwargs:
            kwargs["can_return_none"] = kwargs["can_return_null"];
            del kwargs["can_return_null"]

        return _gdal.Band_ComputeRasterMinMax(self, *args, **kwargs)



    def ComputeBandStats(self, *args):
        r"""ComputeBandStats(Band self, int samplestep=1)"""
        return _gdal.Band_ComputeBandStats(self, *args)

    def Fill(self, *args):
        r"""Fill(Band self, double real_fill, double imag_fill=0.0) -> CPLErr"""
        return _gdal.Band_Fill(self, *args)

    def WriteRaster(self, *args, **kwargs):
        r"""WriteRaster(Band self, int xoff, int yoff, int xsize, int ysize, GIntBig buf_len, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, GIntBig * buf_pixel_space=None, GIntBig * buf_line_space=None) -> CPLErr"""
        return _gdal.Band_WriteRaster(self, *args, **kwargs)

    def FlushCache(self, *args):
        r"""FlushCache(Band self)"""
        return _gdal.Band_FlushCache(self, *args)

    def GetRasterColorTable(self, *args):
        r"""GetRasterColorTable(Band self) -> ColorTable"""
        return _gdal.Band_GetRasterColorTable(self, *args)

    def GetColorTable(self, *args):
        r"""GetColorTable(Band self) -> ColorTable"""
        return _gdal.Band_GetColorTable(self, *args)

    def SetRasterColorTable(self, *args):
        r"""SetRasterColorTable(Band self, ColorTable arg) -> int"""
        return _gdal.Band_SetRasterColorTable(self, *args)

    def SetColorTable(self, *args):
        r"""SetColorTable(Band self, ColorTable arg) -> int"""
        return _gdal.Band_SetColorTable(self, *args)

    def GetDefaultRAT(self, *args):
        r"""GetDefaultRAT(Band self) -> RasterAttributeTable"""
        return _gdal.Band_GetDefaultRAT(self, *args)

    def SetDefaultRAT(self, *args):
        r"""SetDefaultRAT(Band self, RasterAttributeTable table) -> int"""
        return _gdal.Band_SetDefaultRAT(self, *args)

    def GetMaskBand(self, *args):
        r"""GetMaskBand(Band self) -> Band"""
        val = _gdal.Band_GetMaskBand(self, *args)

        if hasattr(self, '_parent_ds') and self._parent_ds():
            self._parent_ds()._add_band_ref(val)


        return val


    def GetMaskFlags(self, *args):
        r"""GetMaskFlags(Band self) -> int"""
        return _gdal.Band_GetMaskFlags(self, *args)

    def CreateMaskBand(self, *args):
        r"""CreateMaskBand(Band self, int nFlags) -> CPLErr"""
        return _gdal.Band_CreateMaskBand(self, *args)

    def IsMaskBand(self, *args):
        r"""IsMaskBand(Band self) -> bool"""
        return _gdal.Band_IsMaskBand(self, *args)

    def GetHistogram(self, *args, **kwargs):
        r"""GetHistogram(Band self, double min=-0.5, double max=255.5, int buckets=256, int include_out_of_range=0, int approx_ok=1, GDALProgressFunc callback=0, void * callback_data=None) -> CPLErr"""
        return _gdal.Band_GetHistogram(self, *args, **kwargs)

    def GetDefaultHistogram(self, *args, **kwargs):
        r"""GetDefaultHistogram(Band self, double * min_ret=None, double * max_ret=None, int * buckets_ret=None, GUIntBig ** ppanHistogram=None, int force=1, GDALProgressFunc callback=0, void * callback_data=None) -> CPLErr"""
        return _gdal.Band_GetDefaultHistogram(self, *args, **kwargs)

    def SetDefaultHistogram(self, *args):
        r"""SetDefaultHistogram(Band self, double min, double max, int buckets_in) -> CPLErr"""
        return _gdal.Band_SetDefaultHistogram(self, *args)

    def HasArbitraryOverviews(self, *args):
        r"""HasArbitraryOverviews(Band self) -> bool"""
        return _gdal.Band_HasArbitraryOverviews(self, *args)

    def GetCategoryNames(self, *args):
        r"""GetCategoryNames(Band self) -> char **"""
        return _gdal.Band_GetCategoryNames(self, *args)

    def SetCategoryNames(self, *args):
        r"""SetCategoryNames(Band self, char ** papszCategoryNames) -> CPLErr"""
        return _gdal.Band_SetCategoryNames(self, *args)

    def GetVirtualMem(self, *args, **kwargs):
        r"""GetVirtualMem(Band self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, int nYSize, int nBufXSize, int nBufYSize, GDALDataType eBufType, size_t nCacheSize, size_t nPageSizeHint, char ** options=None) -> VirtualMem"""
        return _gdal.Band_GetVirtualMem(self, *args, **kwargs)

    def GetVirtualMemAuto(self, *args, **kwargs):
        r"""GetVirtualMemAuto(Band self, GDALRWFlag eRWFlag, char ** options=None) -> VirtualMem"""
        return _gdal.Band_GetVirtualMemAuto(self, *args, **kwargs)

    def GetTiledVirtualMem(self, *args, **kwargs):
        r"""GetTiledVirtualMem(Band self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, int nYSize, int nTileXSize, int nTileYSize, GDALDataType eBufType, size_t nCacheSize, char ** options=None) -> VirtualMem"""
        return _gdal.Band_GetTiledVirtualMem(self, *args, **kwargs)

    def GetDataCoverageStatus(self, *args):
        r"""GetDataCoverageStatus(Band self, int nXOff, int nYOff, int nXSize, int nYSize, int nMaskFlagStop=0) -> int"""
        return _gdal.Band_GetDataCoverageStatus(self, *args)

    def AdviseRead(self, *args):
        r"""AdviseRead(Band self, int xoff, int yoff, int xsize, int ysize, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, char ** options=None) -> CPLErr"""
        return _gdal.Band_AdviseRead(self, *args)

    def AsMDArray(self, *args):
        r"""AsMDArray(Band self) -> MDArray"""
        return _gdal.Band_AsMDArray(self, *args)

    def _EnablePixelTypeSignedByteWarning(self, *args):
        r"""_EnablePixelTypeSignedByteWarning(Band self, bool b)"""
        return _gdal.Band__EnablePixelTypeSignedByteWarning(self, *args)

    def ReadRaster1(self, *args, **kwargs):
        r"""ReadRaster1(Band self, double xoff, double yoff, double xsize, double ysize, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, GIntBig * buf_pixel_space=None, GIntBig * buf_line_space=None, GDALRIOResampleAlg resample_alg=GRIORA_NearestNeighbour, GDALProgressFunc callback=0, void * callback_data=None, void * inputOutputBuf=None) -> CPLErr"""
        return _gdal.Band_ReadRaster1(self, *args, **kwargs)

    def ReadBlock(self, *args, **kwargs):
        r"""ReadBlock(Band self, int xoff, int yoff, void * buf_obj=None) -> CPLErr"""
        return _gdal.Band_ReadBlock(self, *args, **kwargs)


    def ReadRaster(self, xoff=0, yoff=0, xsize=None, ysize=None,
                   buf_xsize=None, buf_ysize=None, buf_type=None,
                   buf_pixel_space=None, buf_line_space=None,
                   resample_alg=gdalconst.GRIORA_NearestNeighbour,
                   callback=None,
                   callback_data=None,
                   buf_obj=None):

        if xsize is None:
            xsize = self.XSize
        if ysize is None:
            ysize = self.YSize

        return _gdal.Band_ReadRaster1(self, xoff, yoff, xsize, ysize,
                                      buf_xsize, buf_ysize, buf_type,
                                      buf_pixel_space, buf_line_space,
                                      resample_alg, callback, callback_data,
                                      buf_obj)

    def WriteRaster(self, xoff, yoff, xsize, ysize,
                    buf_string,
                    buf_xsize=None, buf_ysize=None, buf_type=None,
                    buf_pixel_space=None, buf_line_space=None ):

        if buf_xsize is None:
            buf_xsize = xsize
        if buf_ysize is None:
            buf_ysize = ysize

    # Redirect to numpy-friendly WriteArray() if buf_string is a numpy array
    # and other arguments are compatible
        if type(buf_string).__name__ == 'ndarray' and \
           buf_xsize == xsize and buf_ysize == ysize and buf_type is None and \
           buf_pixel_space is None and buf_line_space is None:
            return self.WriteArray(buf_string, xoff=xoff, yoff=yoff)

        if buf_type is None:
            buf_type = self.DataType

        return _gdal.Band_WriteRaster(self,
                 xoff, yoff, xsize, ysize,
                buf_string, buf_xsize, buf_ysize, buf_type,
                buf_pixel_space, buf_line_space )

    def ReadAsArray(self, xoff=0, yoff=0, win_xsize=None, win_ysize=None,
                    buf_xsize=None, buf_ysize=None, buf_type=None, buf_obj=None,
                    resample_alg=gdalconst.GRIORA_NearestNeighbour,
                    callback=None,
                    callback_data=None):
        """ Reading a chunk of a GDAL band into a numpy array. The optional (buf_xsize,buf_ysize,buf_type)
        parameters should generally not be specified if buf_obj is specified. The array is returned"""

        from osgeo import gdal_array

        return gdal_array.BandReadAsArray(self, xoff, yoff,
                                           win_xsize, win_ysize,
                                           buf_xsize, buf_ysize, buf_type, buf_obj,
                                           resample_alg=resample_alg,
                                           callback=callback,
                                           callback_data=callback_data)

    def WriteArray(self, array, xoff=0, yoff=0,
                   resample_alg=gdalconst.GRIORA_NearestNeighbour,
                   callback=None,
                   callback_data=None):
        from osgeo import gdal_array

        return gdal_array.BandWriteArray(self, array, xoff, yoff,
                                          resample_alg=resample_alg,
                                          callback=callback,
                                          callback_data=callback_data)

    def GetVirtualMemArray(self, eAccess=gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, bufxsize=None, bufysize=None,
                           datatype=None,
                           cache_size = 10 * 1024 * 1024, page_size_hint = 0,
                           options=None):
          """Return a NumPy array for the band, seen as a virtual memory mapping.
             An element is accessed with array[y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          from osgeo import gdal_array
          if xsize is None:
              xsize = self.XSize
          if ysize is None:
              ysize = self.YSize
          if bufxsize is None:
              bufxsize = self.XSize
          if bufysize is None:
              bufysize = self.YSize
          if datatype is None:
              datatype = self.DataType
          if options is None:
              virtualmem = self.GetVirtualMem(eAccess, xoff, yoff, xsize, ysize, bufxsize, bufysize, datatype, cache_size, page_size_hint)
          else:
              virtualmem = self.GetVirtualMem(eAccess, xoff, yoff, xsize, ysize, bufxsize, bufysize, datatype, cache_size, page_size_hint, options)
          return gdal_array.VirtualMemGetArray(virtualmem)

    def GetVirtualMemAutoArray(self, eAccess=gdalconst.GF_Read, options=None):
          """Return a NumPy array for the band, seen as a virtual memory mapping.
             An element is accessed with array[y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          from osgeo import gdal_array
          if options is None:
              virtualmem = self.GetVirtualMemAuto(eAccess)
          else:
              virtualmem = self.GetVirtualMemAuto(eAccess, options)
          return gdal_array.VirtualMemGetArray( virtualmem )

    def GetTiledVirtualMemArray(self, eAccess=gdalconst.GF_Read, xoff=0, yoff=0,
                             xsize=None, ysize=None, tilexsize=256, tileysize=256,
                             datatype=None,
                             cache_size = 10 * 1024 * 1024, options=None):
          """Return a NumPy array for the band, seen as a virtual memory mapping with
             a tile organization.
             An element is accessed with array[tiley][tilex][y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          from osgeo import gdal_array
          if xsize is None:
              xsize = self.XSize
          if ysize is None:
              ysize = self.YSize
          if datatype is None:
              datatype = self.DataType
          if options is None:
              virtualmem = self.GetTiledVirtualMem(eAccess, xoff, yoff, xsize, ysize, tilexsize, tileysize, datatype, cache_size)
          else:
              virtualmem = self.GetTiledVirtualMem(eAccess, xoff, yoff, xsize, ysize, tilexsize, tileysize, datatype, cache_size, options)
          return gdal_array.VirtualMemGetArray( virtualmem )



# Register Band in _gdal:
_gdal.Band_swigregister(Band)
class ColorTable(object):
    r"""Proxy of C++ GDALColorTableShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args, **kwargs):
        r"""__init__(ColorTable self, GDALPaletteInterp palette=GPI_RGB) -> ColorTable"""
        _gdal.ColorTable_swiginit(self, _gdal.new_ColorTable(*args, **kwargs))
    __swig_destroy__ = _gdal.delete_ColorTable

    def Clone(self, *args):
        r"""Clone(ColorTable self) -> ColorTable"""
        return _gdal.ColorTable_Clone(self, *args)

    def GetPaletteInterpretation(self, *args):
        r"""GetPaletteInterpretation(ColorTable self) -> GDALPaletteInterp"""
        return _gdal.ColorTable_GetPaletteInterpretation(self, *args)

    def GetCount(self, *args):
        r"""GetCount(ColorTable self) -> int"""
        return _gdal.ColorTable_GetCount(self, *args)

    def GetColorEntry(self, *args):
        r"""GetColorEntry(ColorTable self, int entry) -> ColorEntry"""
        return _gdal.ColorTable_GetColorEntry(self, *args)

    def GetColorEntryAsRGB(self, *args):
        r"""GetColorEntryAsRGB(ColorTable self, int entry, ColorEntry centry) -> int"""
        return _gdal.ColorTable_GetColorEntryAsRGB(self, *args)

    def SetColorEntry(self, *args):
        r"""SetColorEntry(ColorTable self, int entry, ColorEntry centry)"""
        return _gdal.ColorTable_SetColorEntry(self, *args)

    def CreateColorRamp(self, *args):
        r"""CreateColorRamp(ColorTable self, int nStartIndex, ColorEntry startcolor, int nEndIndex, ColorEntry endcolor)"""
        return _gdal.ColorTable_CreateColorRamp(self, *args)

# Register ColorTable in _gdal:
_gdal.ColorTable_swigregister(ColorTable)
class RasterAttributeTable(object):
    r"""Proxy of C++ GDALRasterAttributeTableShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(RasterAttributeTable self) -> RasterAttributeTable"""
        _gdal.RasterAttributeTable_swiginit(self, _gdal.new_RasterAttributeTable(*args))
    __swig_destroy__ = _gdal.delete_RasterAttributeTable

    def Clone(self, *args):
        r"""Clone(RasterAttributeTable self) -> RasterAttributeTable"""
        return _gdal.RasterAttributeTable_Clone(self, *args)

    def GetColumnCount(self, *args):
        r"""GetColumnCount(RasterAttributeTable self) -> int"""
        return _gdal.RasterAttributeTable_GetColumnCount(self, *args)

    def GetNameOfCol(self, *args):
        r"""GetNameOfCol(RasterAttributeTable self, int iCol) -> char const *"""
        return _gdal.RasterAttributeTable_GetNameOfCol(self, *args)

    def GetUsageOfCol(self, *args):
        r"""GetUsageOfCol(RasterAttributeTable self, int iCol) -> GDALRATFieldUsage"""
        return _gdal.RasterAttributeTable_GetUsageOfCol(self, *args)

    def GetTypeOfCol(self, *args):
        r"""GetTypeOfCol(RasterAttributeTable self, int iCol) -> GDALRATFieldType"""
        return _gdal.RasterAttributeTable_GetTypeOfCol(self, *args)

    def GetColOfUsage(self, *args):
        r"""GetColOfUsage(RasterAttributeTable self, GDALRATFieldUsage eUsage) -> int"""
        return _gdal.RasterAttributeTable_GetColOfUsage(self, *args)

    def GetRowCount(self, *args):
        r"""GetRowCount(RasterAttributeTable self) -> int"""
        return _gdal.RasterAttributeTable_GetRowCount(self, *args)

    def GetValueAsString(self, *args):
        r"""GetValueAsString(RasterAttributeTable self, int iRow, int iCol) -> char const *"""
        return _gdal.RasterAttributeTable_GetValueAsString(self, *args)

    def GetValueAsInt(self, *args):
        r"""GetValueAsInt(RasterAttributeTable self, int iRow, int iCol) -> int"""
        return _gdal.RasterAttributeTable_GetValueAsInt(self, *args)

    def GetValueAsDouble(self, *args):
        r"""GetValueAsDouble(RasterAttributeTable self, int iRow, int iCol) -> double"""
        return _gdal.RasterAttributeTable_GetValueAsDouble(self, *args)

    def SetValueAsString(self, *args):
        r"""SetValueAsString(RasterAttributeTable self, int iRow, int iCol, char const * pszValue)"""
        return _gdal.RasterAttributeTable_SetValueAsString(self, *args)

    def SetValueAsInt(self, *args):
        r"""SetValueAsInt(RasterAttributeTable self, int iRow, int iCol, int nValue)"""
        return _gdal.RasterAttributeTable_SetValueAsInt(self, *args)

    def SetValueAsDouble(self, *args):
        r"""SetValueAsDouble(RasterAttributeTable self, int iRow, int iCol, double dfValue)"""
        return _gdal.RasterAttributeTable_SetValueAsDouble(self, *args)

    def SetRowCount(self, *args):
        r"""SetRowCount(RasterAttributeTable self, int nCount)"""
        return _gdal.RasterAttributeTable_SetRowCount(self, *args)

    def CreateColumn(self, *args):
        r"""CreateColumn(RasterAttributeTable self, char const * pszName, GDALRATFieldType eType, GDALRATFieldUsage eUsage) -> int"""
        return _gdal.RasterAttributeTable_CreateColumn(self, *args)

    def GetLinearBinning(self, *args):
        r"""GetLinearBinning(RasterAttributeTable self) -> bool"""
        return _gdal.RasterAttributeTable_GetLinearBinning(self, *args)

    def SetLinearBinning(self, *args):
        r"""SetLinearBinning(RasterAttributeTable self, double dfRow0Min, double dfBinSize) -> int"""
        return _gdal.RasterAttributeTable_SetLinearBinning(self, *args)

    def GetRowOfValue(self, *args):
        r"""GetRowOfValue(RasterAttributeTable self, double dfValue) -> int"""
        return _gdal.RasterAttributeTable_GetRowOfValue(self, *args)

    def ChangesAreWrittenToFile(self, *args):
        r"""ChangesAreWrittenToFile(RasterAttributeTable self) -> int"""
        return _gdal.RasterAttributeTable_ChangesAreWrittenToFile(self, *args)

    def DumpReadable(self, *args):
        r"""DumpReadable(RasterAttributeTable self)"""
        return _gdal.RasterAttributeTable_DumpReadable(self, *args)

    def SetTableType(self, *args):
        r"""SetTableType(RasterAttributeTable self, GDALRATTableType eTableType)"""
        return _gdal.RasterAttributeTable_SetTableType(self, *args)

    def GetTableType(self, *args):
        r"""GetTableType(RasterAttributeTable self) -> GDALRATTableType"""
        return _gdal.RasterAttributeTable_GetTableType(self, *args)

    def WriteArray(self, array, field, start=0):
        from osgeo import gdal_array

        return gdal_array.RATWriteArray(self, array, field, start)

    def ReadAsArray(self, field, start=0, length=None):
        from osgeo import gdal_array

        return gdal_array.RATReadArray(self, field, start, length)


# Register RasterAttributeTable in _gdal:
_gdal.RasterAttributeTable_swigregister(RasterAttributeTable)
class SubdatasetInfo(object):
    r"""Proxy of C++ GDALSubdatasetInfoShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_SubdatasetInfo

    def GetPathComponent(self, *args):
        r"""GetPathComponent(SubdatasetInfo self) -> retStringAndCPLFree *"""
        return _gdal.SubdatasetInfo_GetPathComponent(self, *args)

    def GetSubdatasetComponent(self, *args):
        r"""GetSubdatasetComponent(SubdatasetInfo self) -> retStringAndCPLFree *"""
        return _gdal.SubdatasetInfo_GetSubdatasetComponent(self, *args)

    def ModifyPathComponent(self, *args):
        r"""ModifyPathComponent(SubdatasetInfo self, char const * pszNewFileName) -> retStringAndCPLFree *"""
        return _gdal.SubdatasetInfo_ModifyPathComponent(self, *args)

# Register SubdatasetInfo in _gdal:
_gdal.SubdatasetInfo_swigregister(SubdatasetInfo)

def GetSubdatasetInfo(*args):
    r"""GetSubdatasetInfo(char const * pszFileName) -> GDALSubdatasetInfoShadow *"""
    return _gdal.GetSubdatasetInfo(*args)
class Relationship(object):
    r"""Proxy of C++ GDALRelationshipShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Relationship self, char const * name, char const * leftTableName, char const * rightTableName, GDALRelationshipCardinality cardinality) -> Relationship"""
        _gdal.Relationship_swiginit(self, _gdal.new_Relationship(*args))
    __swig_destroy__ = _gdal.delete_Relationship

    def GetName(self, *args):
        r"""GetName(Relationship self) -> char const *"""
        return _gdal.Relationship_GetName(self, *args)

    def GetCardinality(self, *args):
        r"""GetCardinality(Relationship self) -> GDALRelationshipCardinality"""
        return _gdal.Relationship_GetCardinality(self, *args)

    def GetLeftTableName(self, *args):
        r"""GetLeftTableName(Relationship self) -> char const *"""
        return _gdal.Relationship_GetLeftTableName(self, *args)

    def GetRightTableName(self, *args):
        r"""GetRightTableName(Relationship self) -> char const *"""
        return _gdal.Relationship_GetRightTableName(self, *args)

    def GetMappingTableName(self, *args):
        r"""GetMappingTableName(Relationship self) -> char const *"""
        return _gdal.Relationship_GetMappingTableName(self, *args)

    def SetMappingTableName(self, *args):
        r"""SetMappingTableName(Relationship self, char const * pszName)"""
        return _gdal.Relationship_SetMappingTableName(self, *args)

    def GetLeftTableFields(self, *args):
        r"""GetLeftTableFields(Relationship self) -> char **"""
        return _gdal.Relationship_GetLeftTableFields(self, *args)

    def GetRightTableFields(self, *args):
        r"""GetRightTableFields(Relationship self) -> char **"""
        return _gdal.Relationship_GetRightTableFields(self, *args)

    def SetLeftTableFields(self, *args):
        r"""SetLeftTableFields(Relationship self, char ** pFields)"""
        return _gdal.Relationship_SetLeftTableFields(self, *args)

    def SetRightTableFields(self, *args):
        r"""SetRightTableFields(Relationship self, char ** pFields)"""
        return _gdal.Relationship_SetRightTableFields(self, *args)

    def GetLeftMappingTableFields(self, *args):
        r"""GetLeftMappingTableFields(Relationship self) -> char **"""
        return _gdal.Relationship_GetLeftMappingTableFields(self, *args)

    def GetRightMappingTableFields(self, *args):
        r"""GetRightMappingTableFields(Relationship self) -> char **"""
        return _gdal.Relationship_GetRightMappingTableFields(self, *args)

    def SetLeftMappingTableFields(self, *args):
        r"""SetLeftMappingTableFields(Relationship self, char ** pFields)"""
        return _gdal.Relationship_SetLeftMappingTableFields(self, *args)

    def SetRightMappingTableFields(self, *args):
        r"""SetRightMappingTableFields(Relationship self, char ** pFields)"""
        return _gdal.Relationship_SetRightMappingTableFields(self, *args)

    def GetType(self, *args):
        r"""GetType(Relationship self) -> GDALRelationshipType"""
        return _gdal.Relationship_GetType(self, *args)

    def SetType(self, *args):
        r"""SetType(Relationship self, GDALRelationshipType type)"""
        return _gdal.Relationship_SetType(self, *args)

    def GetForwardPathLabel(self, *args):
        r"""GetForwardPathLabel(Relationship self) -> char const *"""
        return _gdal.Relationship_GetForwardPathLabel(self, *args)

    def SetForwardPathLabel(self, *args):
        r"""SetForwardPathLabel(Relationship self, char const * pszLabel)"""
        return _gdal.Relationship_SetForwardPathLabel(self, *args)

    def GetBackwardPathLabel(self, *args):
        r"""GetBackwardPathLabel(Relationship self) -> char const *"""
        return _gdal.Relationship_GetBackwardPathLabel(self, *args)

    def SetBackwardPathLabel(self, *args):
        r"""SetBackwardPathLabel(Relationship self, char const * pszLabel)"""
        return _gdal.Relationship_SetBackwardPathLabel(self, *args)

    def GetRelatedTableType(self, *args):
        r"""GetRelatedTableType(Relationship self) -> char const *"""
        return _gdal.Relationship_GetRelatedTableType(self, *args)

    def SetRelatedTableType(self, *args):
        r"""SetRelatedTableType(Relationship self, char const * pszType)"""
        return _gdal.Relationship_SetRelatedTableType(self, *args)

# Register Relationship in _gdal:
_gdal.Relationship_swigregister(Relationship)

def TermProgress_nocb(*args, **kwargs):
    r"""TermProgress_nocb(double dfProgress, char const * pszMessage=None, void * pData=None) -> int"""
    return _gdal.TermProgress_nocb(*args, **kwargs)
TermProgress = _gdal.TermProgress


def ComputeMedianCutPCT(*args, **kwargs):
    r"""ComputeMedianCutPCT(Band red, Band green, Band blue, int num_colors, ColorTable colors, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.ComputeMedianCutPCT(*args, **kwargs)

def DitherRGB2PCT(*args, **kwargs):
    r"""DitherRGB2PCT(Band red, Band green, Band blue, Band target, ColorTable colors, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.DitherRGB2PCT(*args, **kwargs)

def ReprojectImage(*args, **kwargs):
    r"""ReprojectImage(Dataset src_ds, Dataset dst_ds, char const * src_wkt=None, char const * dst_wkt=None, GDALResampleAlg eResampleAlg=GRA_NearestNeighbour, double WarpMemoryLimit=0.0, double maxerror=0.0, GDALProgressFunc callback=0, void * callback_data=None, char ** options=None) -> CPLErr"""
    return _gdal.ReprojectImage(*args, **kwargs)

def ComputeProximity(*args, **kwargs):
    r"""ComputeProximity(Band srcBand, Band proximityBand, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.ComputeProximity(*args, **kwargs)

def RasterizeLayer(*args, **kwargs):
    r"""RasterizeLayer(Dataset dataset, int bands, Layer layer, void * pfnTransformer=None, void * pTransformArg=None, int burn_values=0, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.RasterizeLayer(*args, **kwargs)

def Polygonize(*args, **kwargs):
    r"""Polygonize(Band srcBand, Band maskBand, Layer outLayer, int iPixValField, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.Polygonize(*args, **kwargs)

def FPolygonize(*args, **kwargs):
    r"""FPolygonize(Band srcBand, Band maskBand, Layer outLayer, int iPixValField, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.FPolygonize(*args, **kwargs)

def FillNodata(*args, **kwargs):
    r"""FillNodata(Band targetBand, Band maskBand, double maxSearchDist, int smoothingIterations, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.FillNodata(*args, **kwargs)

def SieveFilter(*args, **kwargs):
    r"""SieveFilter(Band srcBand, Band maskBand, Band dstBand, int threshold, int connectedness=4, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.SieveFilter(*args, **kwargs)

def RegenerateOverviews(*args, **kwargs):
    r"""RegenerateOverviews(Band srcBand, int overviewBandCount, char const * resampling="average", GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.RegenerateOverviews(*args, **kwargs)

def RegenerateOverview(*args, **kwargs):
    r"""RegenerateOverview(Band srcBand, Band overviewBand, char const * resampling="average", GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.RegenerateOverview(*args, **kwargs)

def ContourGenerate(*args, **kwargs):
    r"""ContourGenerate(Band srcBand, double contourInterval, double contourBase, int fixedLevelCount, int useNoData, double noDataValue, Layer dstLayer, int idField, int elevField, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.ContourGenerate(*args, **kwargs)

def ContourGenerateEx(*args, **kwargs):
    r"""ContourGenerateEx(Band srcBand, Layer dstLayer, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.ContourGenerateEx(*args, **kwargs)
GVM_Diagonal = _gdal.GVM_Diagonal

GVM_Edge = _gdal.GVM_Edge

GVM_Max = _gdal.GVM_Max

GVM_Min = _gdal.GVM_Min

GVOT_NORMAL = _gdal.GVOT_NORMAL

GVOT_MIN_TARGET_HEIGHT_FROM_DEM = _gdal.GVOT_MIN_TARGET_HEIGHT_FROM_DEM

GVOT_MIN_TARGET_HEIGHT_FROM_GROUND = _gdal.GVOT_MIN_TARGET_HEIGHT_FROM_GROUND


def ViewshedGenerate(*args, **kwargs):
    r"""ViewshedGenerate(Band srcBand, char const * driverName, char const * targetRasterName, char ** creationOptions, double observerX, double observerY, double observerHeight, double targetHeight, double visibleVal, double invisibleVal, double outOfRangeVal, double noDataVal, double dfCurvCoeff, GDALViewshedMode mode, double maxDistance, GDALProgressFunc callback=0, void * callback_data=None, GDALViewshedOutputType heightMode=GVOT_NORMAL, char ** options=None) -> Dataset"""
    return _gdal.ViewshedGenerate(*args, **kwargs)

def AutoCreateWarpedVRT(*args):
    r"""AutoCreateWarpedVRT(Dataset src_ds, char const * src_wkt=None, char const * dst_wkt=None, GDALResampleAlg eResampleAlg=GRA_NearestNeighbour, double maxerror=0.0) -> Dataset"""
    return _gdal.AutoCreateWarpedVRT(*args)

def CreatePansharpenedVRT(*args):
    r"""CreatePansharpenedVRT(char const * pszXML, Band panchroBand, int nInputSpectralBands) -> Dataset"""
    return _gdal.CreatePansharpenedVRT(*args)
class GDALTransformerInfoShadow(object):
    r"""Proxy of C++ GDALTransformerInfoShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_GDALTransformerInfoShadow

    def TransformPoint(self, *args):
        r"""
        TransformPoint(GDALTransformerInfoShadow self, int bDstToSrc, double [3] inout) -> int
        TransformPoint(GDALTransformerInfoShadow self, int bDstToSrc, double x, double y, double z=0.0) -> int
        """
        return _gdal.GDALTransformerInfoShadow_TransformPoint(self, *args)

    def TransformPoints(self, *args):
        r"""TransformPoints(GDALTransformerInfoShadow self, int bDstToSrc, int nCount) -> int"""
        return _gdal.GDALTransformerInfoShadow_TransformPoints(self, *args)

    def TransformGeolocations(self, *args, **kwargs):
        r"""TransformGeolocations(GDALTransformerInfoShadow self, Band xBand, Band yBand, Band zBand, GDALProgressFunc callback=0, void * callback_data=None, char ** options=None) -> int"""
        return _gdal.GDALTransformerInfoShadow_TransformGeolocations(self, *args, **kwargs)

# Register GDALTransformerInfoShadow in _gdal:
_gdal.GDALTransformerInfoShadow_swigregister(GDALTransformerInfoShadow)

def Transformer(*args):
    r"""Transformer(Dataset src, Dataset dst, char ** options) -> GDALTransformerInfoShadow"""
    return _gdal.Transformer(*args)
class SuggestedWarpOutputRes(object):
    r"""Proxy of C++ SuggestedWarpOutputRes class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    width = property(_gdal.SuggestedWarpOutputRes_width_get, doc=r"""width : int""")
    height = property(_gdal.SuggestedWarpOutputRes_height_get, doc=r"""height : int""")
    xmin = property(_gdal.SuggestedWarpOutputRes_xmin_get, doc=r"""xmin : double""")
    ymin = property(_gdal.SuggestedWarpOutputRes_ymin_get, doc=r"""ymin : double""")
    xmax = property(_gdal.SuggestedWarpOutputRes_xmax_get, doc=r"""xmax : double""")
    ymax = property(_gdal.SuggestedWarpOutputRes_ymax_get, doc=r"""ymax : double""")
    __swig_destroy__ = _gdal.delete_SuggestedWarpOutputRes

    def GetGeotransform(self, *args):
        r"""GetGeotransform(SuggestedWarpOutputRes self)"""
        return _gdal.SuggestedWarpOutputRes_GetGeotransform(self, *args)

    geotransform = property(_gdal.SuggestedWarpOutputRes_GetGeotransform, doc=r"""geotransform : double[6]""")


# Register SuggestedWarpOutputRes in _gdal:
_gdal.SuggestedWarpOutputRes_swigregister(SuggestedWarpOutputRes)

def SuggestedWarpOutputFromTransformer(*args):
    r"""SuggestedWarpOutputFromTransformer(Dataset src, GDALTransformerInfoShadow transformer) -> SuggestedWarpOutputRes"""
    return _gdal.SuggestedWarpOutputFromTransformer(*args)

def SuggestedWarpOutputFromOptions(*args):
    r"""SuggestedWarpOutputFromOptions(Dataset src, char ** options) -> SuggestedWarpOutputRes"""
    return _gdal.SuggestedWarpOutputFromOptions(*args)


def SuggestedWarpOutput(*args):
    """
    Suggest output dataset size and extent.

    SuggestedWarpOutput(src: Dataset, transformer: Transformer) -> SuggestedWarpOutputRes
    SuggestedWarpOutput(src: Dataset, options: list[str]) -> SuggestedWarpOutputRes

    This function is used to suggest the size, and georeferenced extents
    appropriate given the indicated transformation and input file.  It walks
    the edges of the input file (approximately 20 sample points along each
    edge) transforming into output coordinates in order to get an extents box.

    Then a resolution is computed with the intent that the length of the
    distance from the top left corner of the output imagery to the bottom right
    corner would represent the same number of pixels as in the source image.
    Note that if the image is somewhat rotated the diagonal taken isn't of the
    whole output bounding rectangle, but instead of the locations where the
    top/left and bottom/right corners transform.  The output pixel size is
    always square.  This is intended to approximately preserve the resolution
    of the input data in the output file.

    There are 2 forms of this method:

    - one that takes the output of gdal.Transformer(src, dst, options) as the second argument.
      The src argument of the gdal.Transformer() call should nominally be the src
      argument passed to this function.
      The dst argument of the gdal.Transformer() call should nominally be None
      The third argument of the gdal.Transformer() call should be a list of strings,
      that are transforming options accepted by
      :cpp:func:`GDALCreateGenImgProjTransformer2` (e.g ``DST_SRS``)

    - one that takes a list of strings as the second argument. Those strings
      are the transforming options accepted by
      :cpp:func:`GDALCreateGenImgProjTransformer2` (e.g ``DST_SRS``)

    Parameters
    ----------

    src: Dataset
        Source dataset
    transformer: Transformer
        The return value of gdal.Transformer(src, None, options)
        (exclusive with below options parameter)
    options: list[str]
        List of strings that are the transforming options accepted by
        :cpp:func:`GDALCreateGenImgProjTransformer2` (e.g ``DST_SRS``)
        (exclusive with above transformer parameter)

    Returns
    -------

    A SuggestedWarpOutputRes class instance with the following members:
    - width: number of pixels in width of the output dataset
    - height: number of pixels in height of the output dataset
    - xmin: minimum value of the georeferenced X coordinates
    - ymin: maximum value of the georeferenced Y coordinates
    - xmax: minimum value of the georeferenced X coordinates
    - ymax: maximum value of the georeferenced Y coordinates
    - geotransform: affine geotransformation matrix (6 values)

    Example
    -------

    >>> ds = gdal.Open("my.tif")
    ... res = gdal.SuggestedWarpOutput(ds, ["DST_SRS=EPSG:4326"])
    ... print(res.width, res.height, res.xmin, res.ymin, res.xmax, res.ymax, res.geotransform)

    """
    if isinstance(args[1], GDALTransformerInfoShadow):
        return _gdal.SuggestedWarpOutputFromTransformer(*args)
    else:
        return _gdal.SuggestedWarpOutputFromOptions(*args)


def _ApplyVerticalShiftGrid(*args, **kwargs):
    r"""_ApplyVerticalShiftGrid(Dataset src_ds, Dataset grid_ds, bool inverse=False, double srcUnitToMeter=1.0, double dstUnitToMeter=1.0, char ** options=None) -> Dataset"""
    return _gdal._ApplyVerticalShiftGrid(*args, **kwargs)

def ApplyGeoTransform(*args):
    r"""ApplyGeoTransform(double [6] padfGeoTransform, double dfPixel, double dfLine)"""
    return _gdal.ApplyGeoTransform(*args)

def InvGeoTransform(*args):
    r"""InvGeoTransform(double [6] gt_in) -> RETURN_NONE"""
    return _gdal.InvGeoTransform(*args)

def VersionInfo(*args):
    r"""VersionInfo(char const * request="VERSION_NUM") -> char const *"""
    return _gdal.VersionInfo(*args)

def AllRegister(*args):
    r"""AllRegister()"""
    return _gdal.AllRegister(*args)

def GDALDestroyDriverManager(*args):
    r"""GDALDestroyDriverManager()"""
    return _gdal.GDALDestroyDriverManager(*args)

def GetCacheMax(*args):
    r"""GetCacheMax() -> GIntBig"""
    return _gdal.GetCacheMax(*args)

def GetCacheUsed(*args):
    r"""GetCacheUsed() -> GIntBig"""
    return _gdal.GetCacheUsed(*args)

def SetCacheMax(*args):
    r"""SetCacheMax(GIntBig nBytes)"""
    return _gdal.SetCacheMax(*args)

def GetDataTypeSize(*args):
    r"""GetDataTypeSize(GDALDataType eDataType) -> int"""
    return _gdal.GetDataTypeSize(*args)

def DataTypeIsComplex(*args):
    r"""DataTypeIsComplex(GDALDataType eDataType) -> int"""
    return _gdal.DataTypeIsComplex(*args)

def GetDataTypeName(*args):
    r"""GetDataTypeName(GDALDataType eDataType) -> char const *"""
    return _gdal.GetDataTypeName(*args)

def GetDataTypeByName(*args):
    r"""GetDataTypeByName(char const * pszDataTypeName) -> GDALDataType"""
    return _gdal.GetDataTypeByName(*args)

def DataTypeUnion(*args):
    r"""DataTypeUnion(GDALDataType a, GDALDataType b) -> GDALDataType"""
    return _gdal.DataTypeUnion(*args)

def GetColorInterpretationName(*args):
    r"""GetColorInterpretationName(GDALColorInterp eColorInterp) -> char const *"""
    return _gdal.GetColorInterpretationName(*args)

def GetPaletteInterpretationName(*args):
    r"""GetPaletteInterpretationName(GDALPaletteInterp ePaletteInterp) -> char const *"""
    return _gdal.GetPaletteInterpretationName(*args)

def DecToDMS(*args):
    r"""DecToDMS(double arg1, char const * arg2, int arg3=2) -> char const *"""
    return _gdal.DecToDMS(*args)

def PackedDMSToDec(*args):
    r"""PackedDMSToDec(double dfPacked) -> double"""
    return _gdal.PackedDMSToDec(*args)

def DecToPackedDMS(*args):
    r"""DecToPackedDMS(double dfDec) -> double"""
    return _gdal.DecToPackedDMS(*args)

def ParseXMLString(*args):
    r"""ParseXMLString(char * pszXMLString) -> CPLXMLNode *"""
    return _gdal.ParseXMLString(*args)

def SerializeXMLTree(*args):
    r"""SerializeXMLTree(CPLXMLNode * xmlnode) -> retStringAndCPLFree *"""
    return _gdal.SerializeXMLTree(*args)

def GetJPEG2000Structure(*args):
    r"""GetJPEG2000Structure(char const * pszFilename, char ** options=None) -> CPLXMLNode *"""
    return _gdal.GetJPEG2000Structure(*args)

def GetJPEG2000StructureAsString(*args):
    r"""GetJPEG2000StructureAsString(char const * pszFilename, char ** options=None) -> retStringAndCPLFree *"""
    return _gdal.GetJPEG2000StructureAsString(*args)

def HasTriangulation(*args):
    r"""HasTriangulation() -> int"""
    return _gdal.HasTriangulation(*args)

def GetDriverCount(*args):
    r"""GetDriverCount() -> int"""
    return _gdal.GetDriverCount(*args)

def GetDriverByName(*args):
    r"""GetDriverByName(char const * name) -> Driver"""
    return _gdal.GetDriverByName(*args)

def GetDriver(*args):
    r"""GetDriver(int i) -> Driver"""
    return _gdal.GetDriver(*args)

def Open(*args):
    r"""Open(char const * utf8_path, GDALAccess eAccess=GA_ReadOnly) -> Dataset"""

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()


    return _gdal.Open(*args)

def OpenEx(*args, **kwargs):
    r"""OpenEx(char const * utf8_path, unsigned int nOpenFlags=0, char ** allowed_drivers=None, char ** open_options=None, char ** sibling_files=None) -> Dataset"""

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()


    return _gdal.OpenEx(*args, **kwargs)

def OpenShared(*args):
    r"""OpenShared(char const * utf8_path, GDALAccess eAccess=GA_ReadOnly) -> Dataset"""

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()


    return _gdal.OpenShared(*args)

def IdentifyDriver(*args):
    r"""IdentifyDriver(char const * utf8_path, char ** papszSiblings=None) -> Driver"""
    return _gdal.IdentifyDriver(*args)

def IdentifyDriverEx(*args, **kwargs):
    r"""IdentifyDriverEx(char const * utf8_path, unsigned int nIdentifyFlags=0, char ** allowed_drivers=None, char ** sibling_files=None) -> Driver"""
    return _gdal.IdentifyDriverEx(*args, **kwargs)

def GeneralCmdLineProcessor(*args):
    r"""GeneralCmdLineProcessor(char ** papszArgv, int nOptions=0) -> char **"""
    return _gdal.GeneralCmdLineProcessor(*args)

__version__ = _gdal.VersionInfo("RELEASE_NAME")

class GDALInfoOptions(object):
    r"""Proxy of C++ GDALInfoOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALInfoOptions self, char ** options) -> GDALInfoOptions"""
        _gdal.GDALInfoOptions_swiginit(self, _gdal.new_GDALInfoOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALInfoOptions

# Register GDALInfoOptions in _gdal:
_gdal.GDALInfoOptions_swigregister(GDALInfoOptions)

def InfoInternal(*args):
    r"""InfoInternal(Dataset hDataset, GDALInfoOptions infoOptions) -> retStringAndCPLFree *"""
    return _gdal.InfoInternal(*args)
class GDALVectorInfoOptions(object):
    r"""Proxy of C++ GDALVectorInfoOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALVectorInfoOptions self, char ** options) -> GDALVectorInfoOptions"""
        _gdal.GDALVectorInfoOptions_swiginit(self, _gdal.new_GDALVectorInfoOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALVectorInfoOptions

# Register GDALVectorInfoOptions in _gdal:
_gdal.GDALVectorInfoOptions_swigregister(GDALVectorInfoOptions)

def VectorInfoInternal(*args):
    r"""VectorInfoInternal(Dataset hDataset, GDALVectorInfoOptions infoOptions) -> retStringAndCPLFree *"""
    return _gdal.VectorInfoInternal(*args)
class GDALMultiDimInfoOptions(object):
    r"""Proxy of C++ GDALMultiDimInfoOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALMultiDimInfoOptions self, char ** options) -> GDALMultiDimInfoOptions"""
        _gdal.GDALMultiDimInfoOptions_swiginit(self, _gdal.new_GDALMultiDimInfoOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALMultiDimInfoOptions

# Register GDALMultiDimInfoOptions in _gdal:
_gdal.GDALMultiDimInfoOptions_swigregister(GDALMultiDimInfoOptions)

def MultiDimInfoInternal(*args):
    r"""MultiDimInfoInternal(Dataset hDataset, GDALMultiDimInfoOptions infoOptions) -> retStringAndCPLFree *"""
    return _gdal.MultiDimInfoInternal(*args)
class GDALTranslateOptions(object):
    r"""Proxy of C++ GDALTranslateOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALTranslateOptions self, char ** options) -> GDALTranslateOptions"""
        _gdal.GDALTranslateOptions_swiginit(self, _gdal.new_GDALTranslateOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALTranslateOptions

# Register GDALTranslateOptions in _gdal:
_gdal.GDALTranslateOptions_swigregister(GDALTranslateOptions)

def TranslateInternal(*args):
    r"""TranslateInternal(char const * dest, Dataset dataset, GDALTranslateOptions translateOptions, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.TranslateInternal(*args)
class GDALWarpAppOptions(object):
    r"""Proxy of C++ GDALWarpAppOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALWarpAppOptions self, char ** options) -> GDALWarpAppOptions"""
        _gdal.GDALWarpAppOptions_swiginit(self, _gdal.new_GDALWarpAppOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALWarpAppOptions

# Register GDALWarpAppOptions in _gdal:
_gdal.GDALWarpAppOptions_swigregister(GDALWarpAppOptions)

def wrapper_GDALWarpDestDS(*args):
    r"""wrapper_GDALWarpDestDS(Dataset dstDS, int object_list_count, GDALWarpAppOptions warpAppOptions, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.wrapper_GDALWarpDestDS(*args)

def wrapper_GDALWarpDestName(*args):
    r"""wrapper_GDALWarpDestName(char const * dest, int object_list_count, GDALWarpAppOptions warpAppOptions, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.wrapper_GDALWarpDestName(*args)
class GDALVectorTranslateOptions(object):
    r"""Proxy of C++ GDALVectorTranslateOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALVectorTranslateOptions self, char ** options) -> GDALVectorTranslateOptions"""
        _gdal.GDALVectorTranslateOptions_swiginit(self, _gdal.new_GDALVectorTranslateOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALVectorTranslateOptions

# Register GDALVectorTranslateOptions in _gdal:
_gdal.GDALVectorTranslateOptions_swigregister(GDALVectorTranslateOptions)

def wrapper_GDALVectorTranslateDestDS(*args):
    r"""wrapper_GDALVectorTranslateDestDS(Dataset dstDS, Dataset srcDS, GDALVectorTranslateOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.wrapper_GDALVectorTranslateDestDS(*args)

def wrapper_GDALVectorTranslateDestName(*args):
    r"""wrapper_GDALVectorTranslateDestName(char const * dest, Dataset srcDS, GDALVectorTranslateOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.wrapper_GDALVectorTranslateDestName(*args)
class GDALDEMProcessingOptions(object):
    r"""Proxy of C++ GDALDEMProcessingOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALDEMProcessingOptions self, char ** options) -> GDALDEMProcessingOptions"""
        _gdal.GDALDEMProcessingOptions_swiginit(self, _gdal.new_GDALDEMProcessingOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALDEMProcessingOptions

# Register GDALDEMProcessingOptions in _gdal:
_gdal.GDALDEMProcessingOptions_swigregister(GDALDEMProcessingOptions)

def DEMProcessingInternal(*args):
    r"""DEMProcessingInternal(char const * dest, Dataset dataset, char const * pszProcessing, char const * pszColorFilename, GDALDEMProcessingOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.DEMProcessingInternal(*args)
class GDALNearblackOptions(object):
    r"""Proxy of C++ GDALNearblackOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALNearblackOptions self, char ** options) -> GDALNearblackOptions"""
        _gdal.GDALNearblackOptions_swiginit(self, _gdal.new_GDALNearblackOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALNearblackOptions

# Register GDALNearblackOptions in _gdal:
_gdal.GDALNearblackOptions_swigregister(GDALNearblackOptions)

def wrapper_GDALNearblackDestDS(*args):
    r"""wrapper_GDALNearblackDestDS(Dataset dstDS, Dataset srcDS, GDALNearblackOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.wrapper_GDALNearblackDestDS(*args)

def wrapper_GDALNearblackDestName(*args):
    r"""wrapper_GDALNearblackDestName(char const * dest, Dataset srcDS, GDALNearblackOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.wrapper_GDALNearblackDestName(*args)
class GDALGridOptions(object):
    r"""Proxy of C++ GDALGridOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALGridOptions self, char ** options) -> GDALGridOptions"""
        _gdal.GDALGridOptions_swiginit(self, _gdal.new_GDALGridOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALGridOptions

# Register GDALGridOptions in _gdal:
_gdal.GDALGridOptions_swigregister(GDALGridOptions)

def GridInternal(*args):
    r"""GridInternal(char const * dest, Dataset dataset, GDALGridOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.GridInternal(*args)
class GDALRasterizeOptions(object):
    r"""Proxy of C++ GDALRasterizeOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALRasterizeOptions self, char ** options) -> GDALRasterizeOptions"""
        _gdal.GDALRasterizeOptions_swiginit(self, _gdal.new_GDALRasterizeOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALRasterizeOptions

# Register GDALRasterizeOptions in _gdal:
_gdal.GDALRasterizeOptions_swigregister(GDALRasterizeOptions)

def wrapper_GDALRasterizeDestDS(*args):
    r"""wrapper_GDALRasterizeDestDS(Dataset dstDS, Dataset srcDS, GDALRasterizeOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.wrapper_GDALRasterizeDestDS(*args)

def wrapper_GDALRasterizeDestName(*args):
    r"""wrapper_GDALRasterizeDestName(char const * dest, Dataset srcDS, GDALRasterizeOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.wrapper_GDALRasterizeDestName(*args)
class GDALFootprintOptions(object):
    r"""Proxy of C++ GDALFootprintOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALFootprintOptions self, char ** options) -> GDALFootprintOptions"""
        _gdal.GDALFootprintOptions_swiginit(self, _gdal.new_GDALFootprintOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALFootprintOptions

# Register GDALFootprintOptions in _gdal:
_gdal.GDALFootprintOptions_swigregister(GDALFootprintOptions)

def wrapper_GDALFootprintDestDS(*args):
    r"""wrapper_GDALFootprintDestDS(Dataset dstDS, Dataset srcDS, GDALFootprintOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.wrapper_GDALFootprintDestDS(*args)

def wrapper_GDALFootprintDestName(*args):
    r"""wrapper_GDALFootprintDestName(char const * dest, Dataset srcDS, GDALFootprintOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.wrapper_GDALFootprintDestName(*args)
class GDALBuildVRTOptions(object):
    r"""Proxy of C++ GDALBuildVRTOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALBuildVRTOptions self, char ** options) -> GDALBuildVRTOptions"""
        _gdal.GDALBuildVRTOptions_swiginit(self, _gdal.new_GDALBuildVRTOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALBuildVRTOptions

# Register GDALBuildVRTOptions in _gdal:
_gdal.GDALBuildVRTOptions_swigregister(GDALBuildVRTOptions)

def BuildVRTInternalObjects(*args):
    r"""BuildVRTInternalObjects(char const * dest, int object_list_count, GDALBuildVRTOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.BuildVRTInternalObjects(*args)

def BuildVRTInternalNames(*args):
    r"""BuildVRTInternalNames(char const * dest, char ** source_filenames, GDALBuildVRTOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.BuildVRTInternalNames(*args)
class GDALMultiDimTranslateOptions(object):
    r"""Proxy of C++ GDALMultiDimTranslateOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GDALMultiDimTranslateOptions self, char ** options) -> GDALMultiDimTranslateOptions"""
        _gdal.GDALMultiDimTranslateOptions_swiginit(self, _gdal.new_GDALMultiDimTranslateOptions(*args))
    __swig_destroy__ = _gdal.delete_GDALMultiDimTranslateOptions

# Register GDALMultiDimTranslateOptions in _gdal:
_gdal.GDALMultiDimTranslateOptions_swigregister(GDALMultiDimTranslateOptions)

def wrapper_GDALMultiDimTranslateDestName(*args):
    r"""wrapper_GDALMultiDimTranslateDestName(char const * dest, int object_list_count, GDALMultiDimTranslateOptions multiDimTranslateOptions, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.wrapper_GDALMultiDimTranslateDestName(*args)

