/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class CBToolBarButton
extends JButton {
    static Logger logger = Logger.getLogger(CBToolBarButton.class.getPackage().getName());
    private boolean alwaysPaintBorder = true;
    private int width = 75;
    private int height = 40;

    public CBToolBarButton(String label, String tooltip) {
        this.init(label, tooltip);
    }

    public CBToolBarButton(String label, String iconFileName, String tooltip) {
        this(label, iconFileName, tooltip, 0, 3);
    }

    public CBToolBarButton(String label, String iconFileName, String tooltip, int horizPos, int vertPos) {
        this.init(label, tooltip);
        ImageIcon buttonIcon = new ImageIcon(iconFileName);
        this.setIcon(buttonIcon);
        this.setHorizontalTextPosition(horizPos);
        this.setVerticalTextPosition(vertPos);
    }

    public Insets getInsets() {
        return new Insets(1, 1, 1, 1);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void init(String label, String tooltip) {
        this.setForeground(Color.black);
        if (!this.alwaysPaintBorder) {
            this.setBorderPainted(false);
        }
        this.setText(label);
        this.setToolTipText(tooltip);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                CBToolBarButton.this.setForeground(Color.blue);
                if (!CBToolBarButton.this.alwaysPaintBorder && CBToolBarButton.this.isEnabled()) {
                    CBToolBarButton.this.setBorderPainted(true);
                }
            }

            public void mouseExited(MouseEvent e) {
                CBToolBarButton.this.setForeground(Color.black);
                if (!CBToolBarButton.this.alwaysPaintBorder && CBToolBarButton.this.isEnabled()) {
                    CBToolBarButton.this.setBorderPainted(false);
                }
            }
        });
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    public void setText(String label) {
        if (label != null) {
            int pos = label.indexOf(38);
            if (pos >= 0 && pos <= label.length() - 2) {
                super.setText(label.substring(0, pos) + label.substring(pos + 1));
                this.setMnemonic(this.getText().charAt(pos));
            } else {
                super.setText(label);
            }
        }
    }

    public void setAlwaysPaintBorder(boolean alwaysPaintBorder) {
        this.alwaysPaintBorder = alwaysPaintBorder;
        if (alwaysPaintBorder) {
            this.setBorderPainted(true);
        } else {
            this.setBorderPainted(false);
        }
    }

    public void setWidthHeight(int width, int height) {
        this.width = width;
        this.height = height;
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }
}

