/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001:\u0002GHB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0017J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0014H$JH\u0010*\u001a\u00020&2\u0006\u0010)\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010\u00142\b\u0010,\u001a\u0004\u0018\u00010\u00142\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u000204H$J\"\u00105\u001a\u00020&2\u0006\u0010)\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010\u00142\u0006\u0010-\u001a\u00020.H$J\u0018\u00106\u001a\u00020&2\u0006\u0010)\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u001fH$J\u000e\u00108\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0014J \u00109\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0014H&\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b:\u0010;J\u0012\u0010<\u001a\u00020=2\b\b\u0002\u0010)\u001a\u00020\u0014H&J\u0016\u0010>\u001a\u00020&2\u0006\u0010)\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u001fJF\u0010?\u001a\u00020&2\u0006\u0010)\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010\u00142\b\u0010,\u001a\u0004\u0018\u00010\u00142\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u000204J \u0010@\u001a\u00020&2\u0006\u0010)\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010\u00142\u0006\u0010-\u001a\u00020.J\u000e\u0010A\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0017J%\u0010B\u001a\u00020&2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\nH\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bD\u0010EJ\b\u0010F\u001a\u00020&H&R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\u00020\nX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u00020\nX\u00a6\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0018\u001a\u00020\nX\u00a6\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u0012R!\u0010\u001b\u001a\u00020\nX\u00a6\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u0010\"\u0004\b\u001d\u0010\u0012R\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\n  *\u0004\u0018\u00010\"0\"X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006I"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;", "", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "(Lorg/jitsi/utils/logging/DiagnosticContext;)V", "algorithmName", "", "getAlgorithmName", "()Ljava/lang/String;", "curBandwidth", "Lorg/jitsi/nlj/util/Bandwidth;", "D", "getDiagnosticContext", "()Lorg/jitsi/utils/logging/DiagnosticContext;", "initBw", "getInitBw-rlWvAKk", "()D", "setInitBw-_2icLw0", "(D)V", "lastBweLogTime", "Ljava/time/Instant;", "listeners", "Ljava/util/LinkedList;", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$Listener;", "maxBw", "getMaxBw-rlWvAKk", "setMaxBw-_2icLw0", "minBw", "getMinBw-rlWvAKk", "setMinBw-_2icLw0", "minBweLogInterval", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "getTimeSeriesLogger", "()Lorg/jitsi/utils/logging/TimeSeriesLogger;", "addListener", "", "listener", "doFeedbackComplete", "now", "doProcessPacketArrival", "sendTime", "recvTime", "seq", "", "size", "Lorg/jitsi/nlj/util/DataSize;", "ecn", "", "previouslyReportedLost", "", "doProcessPacketLoss", "doRttUpdate", "newRtt", "feedbackComplete", "getCurrentBw", "getCurrentBw-WElJv5I", "(Ljava/time/Instant;)D", "getStats", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot;", "onRttUpdate", "processPacketArrival", "processPacketLoss", "removeListener", "reportBandwidthEstimate", "newValue", "reportBandwidthEstimate-ERFH51c", "(Ljava/time/Instant;D)V", "reset", "Listener", "StatisticsSnapshot", "jitsi-media-transform"})
public abstract class BandwidthEstimator {
    @NotNull
    private final DiagnosticContext diagnosticContext;
    private final TimeSeriesLogger timeSeriesLogger;
    @NotNull
    private final LinkedList<Listener> listeners;
    private double curBandwidth;
    @NotNull
    private Instant lastBweLogTime;
    private final Duration minBweLogInterval;

    public BandwidthEstimator(@NotNull DiagnosticContext diagnosticContext) {
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        this.diagnosticContext = diagnosticContext;
        this.timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(this.getClass());
        this.listeners = new LinkedList();
        this.curBandwidth = BandwidthKt.getBps(-1);
        this.lastBweLogTime = ClockUtils.NEVER;
        this.minBweLogInterval = Duration.ofMillis(500L);
    }

    @NotNull
    protected final DiagnosticContext getDiagnosticContext() {
        return this.diagnosticContext;
    }

    protected final TimeSeriesLogger getTimeSeriesLogger() {
        return this.timeSeriesLogger;
    }

    @NotNull
    public abstract String getAlgorithmName();

    public abstract double getInitBw-rlWvAKk();

    public abstract void setInitBw-_2icLw0(double var1);

    public abstract double getMinBw-rlWvAKk();

    public abstract void setMinBw-_2icLw0(double var1);

    public abstract double getMaxBw-rlWvAKk();

    public abstract void setMaxBw-_2icLw0(double var1);

    public final void processPacketArrival(@NotNull Instant now, @Nullable Instant sendTime, @Nullable Instant recvTime, int seq, @NotNull DataSize size, byte ecn, boolean previouslyReportedLost) {
        Intrinsics.checkNotNullParameter(now, "now");
        Intrinsics.checkNotNullParameter(size, "size");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_packet_arrival", now);
            if (sendTime != null) {
                point.addField("sendTime", ClockUtils.formatMilli(sendTime));
            }
            if (recvTime != null) {
                point.addField("recvTime", ClockUtils.formatMilli(recvTime));
            }
            point.addField("seq", seq);
            point.addField("size", size.getBytes());
            if (ecn != 0) {
                point.addField("ecn", ecn);
            }
            point.addField("previouslyReportedLost", previouslyReportedLost);
            this.timeSeriesLogger.trace(point);
        }
        this.doProcessPacketArrival(now, sendTime, recvTime, seq, size, ecn, previouslyReportedLost);
    }

    public static /* synthetic */ void processPacketArrival$default(BandwidthEstimator bandwidthEstimator, Instant instant, Instant instant2, Instant instant3, int n, DataSize dataSize, byte by, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processPacketArrival");
        }
        if ((n2 & 0x20) != 0) {
            by = 0;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        bandwidthEstimator.processPacketArrival(instant, instant2, instant3, n, dataSize, by, bl);
    }

    protected abstract void doProcessPacketArrival(@NotNull Instant var1, @Nullable Instant var2, @Nullable Instant var3, int var4, @NotNull DataSize var5, byte var6, boolean var7);

    public static /* synthetic */ void doProcessPacketArrival$default(BandwidthEstimator bandwidthEstimator, Instant instant, Instant instant2, Instant instant3, int n, DataSize dataSize, byte by, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doProcessPacketArrival");
        }
        if ((n2 & 0x20) != 0) {
            by = 0;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        bandwidthEstimator.doProcessPacketArrival(instant, instant2, instant3, n, dataSize, by, bl);
    }

    public final void processPacketLoss(@NotNull Instant now, @Nullable Instant sendTime, int seq) {
        Intrinsics.checkNotNullParameter(now, "now");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_packet_loss", now);
            if (sendTime != null) {
                point.addField("sendTime", ClockUtils.formatMilli(sendTime));
            }
            point.addField("seq", seq);
            this.timeSeriesLogger.trace(point);
        }
        this.doProcessPacketLoss(now, sendTime, seq);
    }

    protected abstract void doProcessPacketLoss(@NotNull Instant var1, @Nullable Instant var2, int var3);

    public final void feedbackComplete(@NotNull Instant now) {
        Intrinsics.checkNotNullParameter(now, "now");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_feedback_complete", now);
            this.timeSeriesLogger.trace(point);
        }
        this.doFeedbackComplete(now);
    }

    protected abstract void doFeedbackComplete(@NotNull Instant var1);

    public final void onRttUpdate(@NotNull Instant now, @NotNull Duration newRtt) {
        Intrinsics.checkNotNullParameter(now, "now");
        Intrinsics.checkNotNullParameter(newRtt, "newRtt");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_rtt", now);
            point.addField("rtt", ClockUtils.formatMilli(newRtt));
            this.timeSeriesLogger.trace(point);
        }
        this.doRttUpdate(now, newRtt);
    }

    protected abstract void doRttUpdate(@NotNull Instant var1, @NotNull Duration var2);

    public abstract double getCurrentBw-WElJv5I(@NotNull Instant var1);

    @NotNull
    public abstract StatisticsSnapshot getStats(@NotNull Instant var1);

    public static /* synthetic */ StatisticsSnapshot getStats$default(BandwidthEstimator bandwidthEstimator, Instant instant, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getStats");
        }
        if ((n & 1) != 0) {
            Instant instant2 = Clock.systemUTC().instant();
            Intrinsics.checkNotNullExpressionValue(instant2, "systemUTC().instant()");
            instant = instant2;
        }
        return bandwidthEstimator.getStats(instant);
    }

    public abstract void reset();

    protected final synchronized void reportBandwidthEstimate-ERFH51c(@NotNull Instant now, double newValue) {
        Intrinsics.checkNotNullParameter(now, "now");
        if (this.timeSeriesLogger.isTraceEnabled() && (!Bandwidth.equals-impl0(newValue, this.curBandwidth) || Intrinsics.areEqual(this.lastBweLogTime, ClockUtils.NEVER) || Duration.between(this.lastBweLogTime, now).compareTo(this.minBweLogInterval) >= 0)) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_estimate", now);
            point.addField("bw", newValue);
            this.timeSeriesLogger.trace(point);
            this.lastBweLogTime = now;
        }
        if (Bandwidth.equals-impl0(newValue, this.curBandwidth)) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.bandwidthEstimationChanged-_2icLw0(newValue);
        }
        this.curBandwidth = newValue;
    }

    public final synchronized void addListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.listeners.add(listener);
    }

    public final synchronized void removeListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.listeners.remove(listener);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u001d\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\b"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$Listener;", "", "bandwidthEstimationChanged", "", "newValue", "Lorg/jitsi/nlj/util/Bandwidth;", "bandwidthEstimationChanged-_2icLw0", "(D)V", "jitsi-media-transform"})
    public static interface Listener {
        public void bandwidthEstimationChanged-_2icLw0(double var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0018\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J#\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0005\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0003J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0006\u0010#\u001a\u00020\u001eH\u0002J\u0006\u0010$\u001a\u00020%R+\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006&"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot;", "", "algorithmName", "", "currentEstimate", "Lorg/jitsi/nlj/util/Bandwidth;", "(Ljava/lang/String;DLkotlin/jvm/internal/DefaultConstructorMarker;)V", "<set-?>", "getAlgorithmName", "()Ljava/lang/String;", "setAlgorithmName", "(Ljava/lang/String;)V", "algorithmName$delegate", "Ljava/util/Map;", "getCurrentEstimate-rlWvAKk", "()D", "setCurrentEstimate-_2icLw0", "(D)V", "currentEstimate$delegate", "stats", "", "addBandwidth", "", "name", "value", "addBandwidth-ERFH51c", "(Ljava/lang/String;D)V", "addBoolean", "", "addNumber", "", "addString", "getNumber", "getValue", "promote", "n", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-media-transform"})
    public static final class StatisticsSnapshot {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final Map<String, Object> stats = new LinkedHashMap();
        @NotNull
        private final Map algorithmName$delegate = this.stats;
        @NotNull
        private final Map currentEstimate$delegate = this.stats;

        private StatisticsSnapshot(String algorithmName, double currentEstimate) {
            this.addString("algorithmName", algorithmName);
            this.addBandwidth-ERFH51c("currentEstimate", currentEstimate);
        }

        @NotNull
        public final String getAlgorithmName() {
            Map map = this.algorithmName$delegate;
            return (String)MapsKt.getOrImplicitDefaultNullable(map, $$delegatedProperties[0].getName());
        }

        public final void setAlgorithmName(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            Map map = this.algorithmName$delegate;
            map.put($$delegatedProperties[0].getName(), string);
        }

        public final double getCurrentEstimate-rlWvAKk() {
            Map map = this.currentEstimate$delegate;
            return ((Bandwidth)MapsKt.getOrImplicitDefaultNullable(map, $$delegatedProperties[1].getName())).unbox-impl();
        }

        public final void setCurrentEstimate-_2icLw0(double d) {
            Map map = this.currentEstimate$delegate;
            KProperty<Object> kProperty = $$delegatedProperties[1];
            Bandwidth bandwidth = Bandwidth.box-impl(d);
            map.put(kProperty.getName(), bandwidth);
        }

        @Nullable
        public final Object getValue(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return this.stats.get(name);
        }

        @Nullable
        public final Number getNumber(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            Object object = this.stats.get(name);
            return object instanceof Number ? (Number)((Number)object) : (Number)null;
        }

        private final Number promote(Number n) {
            Number number = n;
            return (((number instanceof Byte ? true : number instanceof Short) ? true : number instanceof Integer) ? true : number instanceof Long) ? (Number)n.longValue() : (Number)((number instanceof Float ? true : number instanceof Double) ? (Number)n.doubleValue() : null);
        }

        public final void addNumber(@NotNull String name, @NotNull Number value2) {
            block0: {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(value2, "value");
                Number number = this.promote(value2);
                if (number == null) break block0;
                Number it = number;
                boolean bl = false;
                this.stats.put(name, it);
            }
        }

        public final void addString(@NotNull String name, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value2, "value");
            this.stats.put(name, value2);
        }

        public final void addBoolean(@NotNull String name, boolean value2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Boolean bl = value2;
            this.stats.put(name, bl);
        }

        public final void addBandwidth-ERFH51c(@NotNull String name, double value2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Bandwidth bandwidth = Bandwidth.box-impl(value2);
            this.stats.put(name, bandwidth);
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u2d2 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            Map<String, Object> $this$forEach$iv = this.stats;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator2.next();
                boolean bl2 = false;
                String name = entry.getKey();
                Object value2 = entry.getValue();
                if (value2 instanceof Bandwidth) {
                    $this$toJson_u24lambda_u2d2.put(name, (Object)((Bandwidth)value2).unbox-impl());
                    continue;
                }
                $this$toJson_u24lambda_u2d2.put(name, value2);
            }
            return orderedJsonObject;
        }

        public /* synthetic */ StatisticsSnapshot(String algorithmName, double currentEstimate, DefaultConstructorMarker $constructor_marker) {
            this(algorithmName, currentEstimate);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(StatisticsSnapshot.class, "algorithmName", "getAlgorithmName()Ljava/lang/String;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(StatisticsSnapshot.class, "currentEstimate", "getCurrentEstimate-rlWvAKk()D", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

