/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp.jingle;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.util.WeakValueMap;
import org.jitsi.jicofo.xmpp.AbstractIqHandler;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.IqRequest;
import org.jitsi.jicofo.xmpp.jingle.JingleSession;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/jicofo/xmpp/jingle/JingleIqRequestHandler;", "Lorg/jitsi/jicofo/xmpp/AbstractIqHandler;", "Lorg/jitsi/xmpp/extensions/jingle/JingleIQ;", "connections", "", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "(Ljava/util/Set;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "sessions", "Lorg/jitsi/jicofo/util/WeakValueMap;", "", "Lorg/jitsi/jicofo/xmpp/jingle/JingleSession;", "handleRequest", "Lorg/jitsi/jicofo/xmpp/IqProcessingResult;", "request", "Lorg/jitsi/jicofo/xmpp/IqRequest;", "registerSession", "", "session", "removeSession", "jicofo-common"})
public final class JingleIqRequestHandler
extends AbstractIqHandler<JingleIQ> {
    @NotNull
    private final Logger logger;
    @NotNull
    private final WeakValueMap<String, JingleSession> sessions;

    public JingleIqRequestHandler(@NotNull Set<? extends AbstractXMPPConnection> connections) {
        Intrinsics.checkNotNullParameter(connections, "connections");
        super(connections, "jingle", "urn:xmpp:jingle:1", SetsKt.setOf(IQ.Type.set), null, 16, null);
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.sessions = new WeakValueMap(0, 1, null);
    }

    @Override
    @NotNull
    public IqProcessingResult handleRequest(@NotNull IqRequest<JingleIQ> request) {
        IqProcessingResult iqProcessingResult;
        Intrinsics.checkNotNullParameter(request, "request");
        String string = request.getIq().getSID();
        Intrinsics.checkNotNullExpressionValue(string, "request.iq.sid");
        JingleSession session = this.sessions.get(string);
        if (session == null) {
            this.logger.warn("No session found for SID " + request.getIq().getSID());
            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)request.getIq(), StanzaError.getBuilder(StanzaError.Condition.bad_request).build());
            Intrinsics.checkNotNullExpressionValue(errorIQ, "createErrorResponse(\n   \u2026build()\n                )");
            return new IqProcessingResult.RejectedWithError(errorIQ);
        }
        StanzaError error = session.processIq(request.getIq());
        if (error == null) {
            IQ iQ = IQ.createResultIQ(request.getIq());
            Intrinsics.checkNotNullExpressionValue(iQ, "createResultIQ(request.iq)");
            iqProcessingResult = new IqProcessingResult.AcceptedWithResponse(iQ);
        } else {
            this.logger.info("Returning error: request=" + request.getIq().toXML() + ", error=" + error.toXML() + " ");
            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)request.getIq(), error);
            Intrinsics.checkNotNullExpressionValue(errorIQ, "createErrorResponse(request.iq, error)");
            iqProcessingResult = new IqProcessingResult.RejectedWithError(errorIQ);
        }
        return iqProcessingResult;
    }

    public final void registerSession(@NotNull JingleSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        JingleSession existingSession = this.sessions.get(session.getSid());
        if (existingSession != null) {
            this.logger.warn("Replacing existing session with SID " + session.getSid());
        }
        this.sessions.put(session.getSid(), session);
    }

    public final void removeSession(@NotNull JingleSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.sessions.remove(session.getSid());
    }
}

