/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate;

import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.SequenceResolver;
import com.thaiopensource.resolver.xml.sax.SAX;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.resolver.xml.transform.Transform;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import javax.xml.transform.URIResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ResolverFactory {
    public static SAXResolver createResolver(PropertyMap propertyMap) {
        Resolver[] resolverArray = new Resolver[4];
        int n = 0;
        resolverArray[0] = propertyMap.get(ValidateProperty.RESOLVER);
        if (resolverArray[0] != null) {
            ++n;
        }
        EntityResolver entityResolver = propertyMap.get(ValidateProperty.ENTITY_RESOLVER);
        URIResolver uRIResolver = propertyMap.get(ValidateProperty.URI_RESOLVER);
        if (entityResolver != null) {
            resolverArray[n++] = SAX.createResolver(entityResolver, uRIResolver == null);
        }
        if (uRIResolver != null) {
            resolverArray[n++] = Transform.createResolver(uRIResolver);
        }
        while (--n > 0) {
            resolverArray[n - 1] = new SequenceResolver(resolverArray[n - 1], resolverArray[n]);
        }
        XMLReaderCreator xMLReaderCreator = propertyMap.get(ValidateProperty.XML_READER_CREATOR);
        if (xMLReaderCreator != null) {
            return new CustomSAXResolver(resolverArray[0], xMLReaderCreator);
        }
        return new SAXResolver(resolverArray[0]);
    }

    private static class CustomSAXResolver
    extends SAXResolver {
        private final XMLReaderCreator xrc;

        private CustomSAXResolver(Resolver resolver, XMLReaderCreator xMLReaderCreator) {
            super(resolver);
            this.xrc = xMLReaderCreator;
        }

        @Override
        protected XMLReader createXMLReaderWithoutResolver() throws SAXException {
            return this.xrc.createXMLReader();
        }
    }
}

