/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.plexus.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Configurable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.xfire.plexus.PlexusXFireComponent;
import org.codehaus.xfire.plexus.config.ConfigurationService;
import org.codehaus.xfire.plexus.config.Configurator;
import org.codehaus.xfire.service.Service;

public class DefaultConfigurationService
extends PlexusXFireComponent
implements Initializable,
ConfigurationService,
Configurable {
    private Configurator configurator;
    private PlexusConfiguration services;

    public void initialize() throws InitializationException {
        try {
            this.createServices(this.services);
            Reader reader = this.findConfigurationReader();
            if (reader == null) {
                return;
            }
            XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(Xpp3DomBuilder.build((Reader)reader));
            this.createServices(configuration.getChild("services"));
        }
        catch (Exception e) {
            this.getLogger().error("Could not start the configuration service.", (Throwable)e);
            throw new InitializationException("Could not start configuration service.", (Throwable)e);
        }
    }

    private void createServices(PlexusConfiguration child) throws Exception {
        PlexusConfiguration[] service = child.getChildren("service");
        for (int i = 0; i < service.length; ++i) {
            this.createService(service[i]);
        }
    }

    private void createService(PlexusConfiguration c) throws Exception {
        Service endpoint = this.configurator.createService(c);
    }

    protected Reader findConfigurationReader() throws FileNotFoundException {
        File file;
        String configFileName = System.getProperty("xfire.config");
        InputStreamReader reader = null;
        if (configFileName == null) {
            this.getLogger().info("No configuration file specified. Looking for xfire.xml in the current directory.");
            configFileName = "xfire.xml";
        }
        if ((file = new File(configFileName)).exists()) {
            this.getLogger().info("Found configuration file " + file.getAbsolutePath());
            reader = new FileReader(file);
        } else {
            this.getLogger().info("Could not find configuration file " + file.getAbsolutePath() + ". Looking in the classpath.");
            InputStream is = this.getClass().getResourceAsStream(configFileName);
            if (is == null) {
                this.getLogger().info("Could not find configuration file " + configFileName + " on classpath. Looking for META-INF/xfire/xfire.xml " + "on the classpath");
                is = this.getClass().getResourceAsStream("META-INF/xfire/xfire.xml");
                if (is == null) {
                    this.getLogger().info("No configuration found.");
                    return null;
                }
            }
            reader = new InputStreamReader(is);
        }
        return reader;
    }

    public void configure(PlexusConfiguration config) throws PlexusConfigurationException {
        this.services = config.getChild("services");
    }
}

