/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.email;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.email.EmailAddress;
import org.apache.tools.ant.taskdefs.email.Header;
import org.apache.tools.ant.taskdefs.email.Mailer;

public class JakartaMimeMailer
extends Mailer {
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private static final String GENERIC_ERROR = "Problem while sending mime mail:";
    private static final String DEFAULT_CHARSET = System.getProperty("file.encoding");

    public void send() {
        try {
            Properties props = new Properties();
            props.put("mail.smtp.host", this.host);
            props.put("mail.smtp.port", String.valueOf(this.port));
            SimpleAuthenticator auth = null;
            if (this.SSL) {
                try {
                    Provider p = Class.forName("com.sun.net.ssl.internal.ssl.Provider").asSubclass(Provider.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Security.addProvider(p);
                }
                catch (Exception e) {
                    throw new BuildException("could not instantiate ssl security provider, check that you have JSSE in your classpath");
                }
                props.put("mail.smtp.socketFactory.class", SSL_FACTORY);
                props.put("mail.smtp.socketFactory.fallback", "false");
                props.put("mail.smtps.host", this.host);
                if (this.isPortExplicitlySpecified()) {
                    props.put("mail.smtps.port", String.valueOf(this.port));
                    props.put("mail.smtp.socketFactory.port", String.valueOf(this.port));
                }
            }
            if (this.user != null || this.password != null) {
                props.put("mail.smtp.auth", "true");
                auth = new SimpleAuthenticator(this.user, this.password);
            }
            if (this.isStartTLSEnabled()) {
                props.put("mail.smtp.starttls.enable", "true");
            }
            Session sesh = Session.getInstance((Properties)props, auth);
            MimeMessage msg = new MimeMessage(sesh);
            MimeMultipart attachments = new MimeMultipart();
            if (this.from.getName() == null) {
                msg.setFrom((Address)new InternetAddress(this.from.getAddress()));
            } else {
                msg.setFrom((Address)new InternetAddress(this.from.getAddress(), this.from.getName()));
            }
            msg.setReplyTo((Address[])JakartaMimeMailer.internetAddresses(this.replyToList));
            msg.setRecipients(Message.RecipientType.TO, (Address[])JakartaMimeMailer.internetAddresses(this.toList));
            msg.setRecipients(Message.RecipientType.CC, (Address[])JakartaMimeMailer.internetAddresses(this.ccList));
            msg.setRecipients(Message.RecipientType.BCC, (Address[])JakartaMimeMailer.internetAddresses(this.bccList));
            String charset = this.parseCharSetFromMimeType(this.message.getMimeType());
            if (charset != null) {
                this.message.setCharset(charset);
            } else {
                charset = this.message.getCharset();
                if (charset == null) {
                    charset = DEFAULT_CHARSET;
                    this.message.setCharset(charset);
                }
            }
            StringDataSource sds = new StringDataSource();
            sds.setContentType(this.message.getMimeType());
            sds.setCharset(charset);
            if (this.subject != null) {
                msg.setSubject(this.subject, charset);
            }
            msg.addHeader("Date", this.getDate());
            if (this.headers != null) {
                for (Header h : this.headers) {
                    msg.addHeader(h.getName(), h.getValue());
                }
            }
            PrintStream out = new PrintStream(sds.getOutputStream());
            this.message.print(out);
            out.close();
            MimeBodyPart textbody = new MimeBodyPart();
            textbody.setDataHandler(new DataHandler((DataSource)sds));
            attachments.addBodyPart((BodyPart)textbody);
            for (File file : this.files) {
                Address[] body = new MimeBodyPart();
                if (!file.exists() || !file.canRead()) {
                    throw new BuildException("File \"%s\" does not exist or is not readable.", new Object[]{file.getAbsolutePath()});
                }
                FileDataSource fileData = new FileDataSource(file);
                DataHandler fileDataHandler = new DataHandler((DataSource)fileData);
                body.setDataHandler(fileDataHandler);
                body.setFileName(file.getName());
                attachments.addBodyPart((BodyPart)body);
            }
            msg.setContent((Multipart)attachments);
            try {
                Transport transport = sesh.getTransport(this.SSL ? "smtps" : "smtp");
                transport.connect(this.host, this.user, this.password);
                transport.sendMessage((Message)msg, msg.getAllRecipients());
            }
            catch (SendFailedException sfe) {
                if (!this.shouldIgnoreInvalidRecipients()) {
                    throw new BuildException(GENERIC_ERROR, (Throwable)sfe);
                }
                if (sfe.getValidSentAddresses() == null || sfe.getValidSentAddresses().length == 0) {
                    throw new BuildException("Couldn't reach any recipient", (Throwable)sfe);
                }
                Address[] invalid = sfe.getInvalidAddresses();
                if (invalid == null) {
                    invalid = new Address[]{};
                }
                for (Address address : invalid) {
                    this.didntReach(address, "invalid", (MessagingException)((Object)sfe));
                }
                Address[] validUnsent = sfe.getValidUnsentAddresses();
                if (validUnsent == null) {
                    validUnsent = new Address[]{};
                }
                for (Address address : validUnsent) {
                    this.didntReach(address, "valid", (MessagingException)((Object)sfe));
                }
            }
        }
        catch (MessagingException | IOException e) {
            throw new BuildException(GENERIC_ERROR, e);
        }
    }

    private static InternetAddress[] internetAddresses(Vector<EmailAddress> list) throws AddressException, UnsupportedEncodingException {
        ArrayList<InternetAddress> addrs = new ArrayList<InternetAddress>();
        for (EmailAddress addr : list) {
            String name = addr.getName();
            addrs.add(name == null ? new InternetAddress(addr.getAddress()) : new InternetAddress(addr.getAddress(), name));
        }
        return addrs.toArray(new InternetAddress[addrs.size()]);
    }

    private String parseCharSetFromMimeType(String type) {
        if (type == null) {
            return null;
        }
        int pos = type.indexOf("charset");
        if (pos < 0) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(type.substring(pos), "=; ");
        token.nextToken();
        return token.nextToken();
    }

    private void didntReach(Address addr, String category, MessagingException ex) {
        String msg = "Failed to send mail to " + category + " address " + addr + " because of " + ex.getMessage();
        if (this.task != null) {
            this.task.log(msg, 1);
        } else {
            System.err.println(msg);
        }
    }

    static class SimpleAuthenticator
    extends Authenticator {
        private String user = null;
        private String password = null;

        public SimpleAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }

    class StringDataSource
    implements DataSource {
        private String data = null;
        private String type = null;
        private String charset = null;
        private ByteArrayOutputStream out;

        StringDataSource() {
        }

        public InputStream getInputStream() throws IOException {
            if (this.data == null && this.out == null) {
                throw new IOException("No data");
            }
            if (this.out != null) {
                String encodedOut = this.out.toString(this.charset);
                this.data = this.data != null ? this.data.concat(encodedOut) : encodedOut;
                this.out = null;
            }
            return new ByteArrayInputStream(this.data.getBytes(this.charset));
        }

        public OutputStream getOutputStream() throws IOException {
            this.out = this.out == null ? new ByteArrayOutputStream() : this.out;
            return this.out;
        }

        public void setContentType(String type) {
            this.type = type.toLowerCase(Locale.ENGLISH);
        }

        public String getContentType() {
            if (this.type != null && this.type.indexOf("charset") > 0 && this.type.startsWith("text/")) {
                return this.type;
            }
            return (this.type != null ? this.type : "text/plain") + "; charset=" + this.charset;
        }

        public String getName() {
            return "StringDataSource";
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

