"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DOMTextBBoxCalculator = void 0;
var DOMTextBBoxCalculator = (function () {
    function DOMTextBBoxCalculator(rootElement) {
        this.offscreenCanvas = document.createElement('span');
        this.offscreenCanvas.style.position = 'absolute';
        this.offscreenCanvas.style.top = '-9999px';
        this.offscreenCanvas.style.left = '-9999px';
        this.attachedRoot = rootElement || document.documentElement;
        this.attachedRoot.appendChild(this.offscreenCanvas);
    }
    DOMTextBBoxCalculator.prototype.compute = function (text, padding, fontSize, fontFamily, lineHeight, fontWeight) {
        if (fontSize === void 0) { fontSize = 16; }
        if (fontFamily === void 0) { fontFamily = 'Arial'; }
        if (lineHeight === void 0) { lineHeight = 1; }
        if (fontWeight === void 0) { fontWeight = 400; }
        this.offscreenCanvas.style.fontSize = fontSize + "px";
        this.offscreenCanvas.style.fontFamily = fontFamily;
        this.offscreenCanvas.style.fontWeight = "" + fontWeight;
        this.offscreenCanvas.style.lineHeight = lineHeight + "px";
        this.offscreenCanvas.innerHTML = text;
        return {
            width: Math.ceil(this.offscreenCanvas.clientWidth + padding),
            height: Math.ceil(this.offscreenCanvas.clientHeight),
        };
    };
    DOMTextBBoxCalculator.prototype.destroy = function () {
        this.attachedRoot.removeChild(this.offscreenCanvas);
    };
    return DOMTextBBoxCalculator;
}());
exports.DOMTextBBoxCalculator = DOMTextBBoxCalculator;
//# sourceMappingURL=dom_text_bbox_calculator.js.map