"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildBarStyles = void 0;
var color_library_wrappers_1 = require("../../../../../common/color_library_wrappers");
var common_1 = require("../../../../../utils/common");
var texture_1 = require("../../../utils/texture");
function buildBarStyles(ctx, imgCanvas, baseColor, themeRectStyle, themeRectBorderStyle, geometryStateStyle) {
    var fillOpacity = function (opacity, seriesOpacity) {
        if (seriesOpacity === void 0) { seriesOpacity = themeRectStyle.opacity; }
        return opacity * seriesOpacity * geometryStateStyle.opacity;
    };
    var texture = texture_1.getTextureStyles(ctx, imgCanvas, baseColor, fillOpacity, themeRectStyle.texture);
    var fillColor = color_library_wrappers_1.stringToRGB(common_1.getColorFromVariant(baseColor, themeRectStyle.fill), fillOpacity);
    var fill = {
        color: fillColor,
        texture: texture,
    };
    var defaultStrokeOpacity = themeRectBorderStyle.strokeOpacity === undefined ? themeRectStyle.opacity : themeRectBorderStyle.strokeOpacity;
    var borderStrokeOpacity = defaultStrokeOpacity * geometryStateStyle.opacity;
    var strokeOpacity = function (opacity) { return opacity * borderStrokeOpacity; };
    var strokeColor = color_library_wrappers_1.stringToRGB(common_1.getColorFromVariant(baseColor, themeRectBorderStyle.stroke), strokeOpacity);
    var stroke = {
        color: strokeColor,
        width: themeRectBorderStyle.visible ? themeRectBorderStyle.strokeWidth : 0,
    };
    return { fill: fill, stroke: stroke };
}
exports.buildBarStyles = buildBarStyles;
//# sourceMappingURL=bar.js.map