/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.proxies;

import java.awt.Dialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.proxies.ExtensionProxies;
import org.zaproxy.zap.extension.proxies.OptionsLocalProxyPanel;
import org.zaproxy.zap.extension.proxies.ProxiesParamProxy;
import org.zaproxy.zap.view.AbstractFormDialog;

class DialogAddProxy
extends AbstractFormDialog {
    private static final long serialVersionUID = 4460797449668634319L;
    private static final String DIALOG_TITLE = Constant.messages.getString("options.proxy.dialog.proxy.add.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("options.proxy.dialog.proxy.add.button.confirm");
    protected OptionsLocalProxyPanel proxyPanel;
    protected ProxiesParamProxy proxy;
    private ExtensionProxies extension;

    public DialogAddProxy(Dialog owner, ExtensionProxies extension) {
        super(owner, DIALOG_TITLE);
        this.extension = extension;
        this.setConfirmButtonEnabled(true);
    }

    protected DialogAddProxy(Dialog owner, String title, ExtensionProxies extension) {
        super(owner, title);
        this.extension = extension;
    }

    @Override
    protected JPanel getFieldsPanel() {
        if (this.proxyPanel == null) {
            this.proxyPanel = new OptionsLocalProxyPanel();
        }
        return this.proxyPanel;
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }

    @Override
    protected void init() {
        this.proxy = null;
        this.getFieldsPanel();
        ProxiesParamProxy paramProxy = new ProxiesParamProxy(true);
        this.proxyPanel.setProxy(paramProxy);
    }

    @Override
    protected boolean validateFields() {
        ProxiesParamProxy testProxy = this.proxyPanel.getProxy();
        if (this.extension.getAdditionalProxy(testProxy.getAddress(), testProxy.getPort()) != null) {
            JOptionPane.showMessageDialog(this, Constant.messages.getString("options.proxy.dialog.proxy.warning.dup.message"), Constant.messages.getString("options.proxy.dialog.proxy.warning.dup.title"), 0);
            return false;
        }
        if (!(this.proxy != null && this.proxy.getAddress().equals(testProxy.getAddress()) && this.proxy.getPort() == testProxy.getPort() || this.extension.canListenOn(testProxy.getAddress(), testProxy.getPort()))) {
            JOptionPane.showMessageDialog(this, Constant.messages.getString("options.proxy.dialog.proxy.warning.fail.message", testProxy.getAddress(), Integer.toString(testProxy.getPort())), Constant.messages.getString("options.proxy.dialog.proxy.warning.fail.title"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void performAction() {
        this.proxy = this.proxyPanel.getProxy();
    }

    @Override
    protected void clearFields() {
    }

    public ProxiesParamProxy getProxy() {
        return this.proxy;
    }

    public void clear() {
        this.proxy = null;
    }
}

