/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import au.com.thinkingrock.tr.resource.Icons;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import tr.model.IDGenerator;
import tr.model.Item.Doable;
import tr.model.Item.Item;
import tr.model.Item.ItemList;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.model.context.Context;
import tr.model.context.ContextChangeCookie;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.project.ProjectSingleActions;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.util.DateNoTime;
import tr.util.DateUtils;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Utils;

public class Action
extends ObservableImpl
implements Doable,
Item,
ContextChangeCookie,
TopicChangeCookie {
    private final Integer id;
    private Date created;
    private Thought thought;
    private Project parent;
    private String description;
    private Topic topic;
    private Context context;
    private ActionState state;
    private String notes;
    private boolean done;
    private Date doneDate;
    private Value time;
    private Value energy;
    private Value priority;
    private String success;
    private Date startDate;
    private Date dueDate;
    private Date modified;
    public static final String PROP_DONE = "Done";
    public static final String PROP_DESCR = "Descr";
    public static final String PROP_CONTEXT = "Context";
    public static final String PROP_TOPIC = "Topic";
    public static final String PROP_STATE = "State";
    public static final String PROP_TIME = "Time";
    public static final String PROP_ENERGY = "Energy";
    public static final String PROP_PRIORITY = "Priority";
    public static final String PROP_NOTES = "Notes";
    private transient PropertyChangeSupport propertyChangeSupport;

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    public void addPropertyChangeListenter(String property, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListenter(String property, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(property, listener);
    }

    public Action(IDGenerator idGenerator) {
        this.id = idGenerator.getNextID();
        this.setCreated();
        this.setModified();
        this.setParent(null);
        this.setThought(null);
        this.setDescription("");
        this.setTopic(Topic.getDefault());
        this.setContext(Context.getDefault());
        this.setState(new ActionStateASAP());
        this.setNotes("");
        this.setDone(false);
        this.doneDate = null;
        this.setTime(null);
        this.setEnergy(null);
        this.setPriority(null);
    }

    private void setCreated() {
        this.created = Calendar.getInstance().getTime();
    }

    public void setCreated(Date created) {
        if (created == null) {
            return;
        }
        if (Utils.equal((Object)this.created, (Object)created)) {
            return;
        }
        this.created = created;
        this.setModified();
        this.notifyObservers(this);
    }

    public Date getCreated() {
        return this.created;
    }

    private void setModified() {
        this.modified = Calendar.getInstance().getTime();
    }

    public Thought getThought() {
        return this.thought;
    }

    public void setThought(Thought thought) {
        if (Utils.equal((Object)this.thought, (Object)thought)) {
            return;
        }
        this.thought = thought;
        this.setModified();
        this.notifyObservers(this);
    }

    public boolean isSingleAction() {
        return this.parent == null || this.parent instanceof ProjectSingleActions;
    }

    public boolean isActive() {
        return !this.done && !this.isStateInactive();
    }

    public Date getDoneDate() {
        return this.doneDate;
    }

    public ActionState getState() {
        return this.state;
    }

    public void setDoneDate(Date doneDate) {
        if (Utils.equal((Object)this.doneDate, (Object)doneDate)) {
            return;
        }
        this.doneDate = doneDate;
        this.setDone(doneDate != null);
        this.setModified();
        this.notifyObservers(this);
    }

    public Date getActionDate() {
        if (this.isDone()) {
            return null;
        }
        Date due = this.getDueDate();
        switch (this.state.getType()) {
            case DELEGATED: {
                Date followup = ((ActionStateDelegated)this.getState()).getDate();
                if (followup == null || due != null && !followup.before(due)) break;
                return new DateNoTime(followup);
            }
            case SCHEDULED: {
                Date scheduled = ((ActionStateScheduled)this.getState()).getDate();
                return scheduled;
            }
            case INACTIVE: {
                if (this.startDate == null || due != null && !this.startDate.before(due)) break;
                return new DateNoTime(this.startDate);
            }
        }
        return due == null ? null : new DateNoTime(due);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        if (date != null) {
            date = DateUtils.clearTime((Date)date);
        }
        if (!Utils.equal((Object)this.startDate, (Object)date)) {
            this.startDate = date;
            this.setModified();
            this.notifyObservers(this);
        }
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date date) {
        if (date != null) {
            date = DateUtils.clearTime((Date)date);
        }
        if (!Utils.equal((Object)this.dueDate, (Object)date)) {
            this.dueDate = date;
            this.setModified();
            this.notifyObservers(this);
        }
    }

    public void setState(ActionState state) {
        if (state == null) {
            return;
        }
        if (state.equals((Object)this.state)) {
            return;
        }
        ActionState oldValue = this.state;
        if (this.state != null) {
            this.state.removeObserver(this);
        }
        this.state = state;
        this.state.addObserver(this);
        this.state.resetObservers();
        this.setModified();
        this.notifyObservers(this);
        this.getPropertyChangeSupport().firePropertyChange(PROP_STATE, (Object)oldValue, (Object)state);
    }

    public boolean isStateASAP() {
        return this.state.getType() == ActionState.Type.DOASAP;
    }

    public boolean isStateScheduled() {
        return this.state.getType() == ActionState.Type.SCHEDULED;
    }

    public boolean isStateDelegated() {
        return this.state.getType() == ActionState.Type.DELEGATED;
    }

    public boolean isStateInactive() {
        return this.state.getType() == ActionState.Type.INACTIVE;
    }

    public Recurrence getRecurrence() {
        if (this.isStateScheduled()) {
            return ((ActionStateScheduled)this.state).getRecurrence();
        }
        return null;
    }

    public void setRecurrence(Recurrence recurrence) {
        if (!this.isStateScheduled()) {
            throw new IllegalStateException("Can only set recurrence on scheduled actions.");
        }
        ((ActionStateScheduled)this.state).setRecurrence(recurrence);
    }

    public Topic getTopic() {
        if (this.topic == null) {
            return Topic.getDefault();
        }
        if (this.topic.getName().equals(Topic.getDefault().getName())) {
            return Topic.getDefault();
        }
        return this.topic;
    }

    public void setTopic(Topic topic) {
        if (Utils.equal((Object)this.topic, (Object)topic)) {
            return;
        }
        if (this.topic != null) {
            this.topic.removeObserver(this);
        }
        Topic oldValue = this.topic;
        this.topic = topic;
        if (this.topic != null) {
            this.topic.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
        this.getPropertyChangeSupport().firePropertyChange(PROP_TOPIC, oldValue, topic);
    }

    public Context getContext() {
        if (this.context == null) {
            return Context.getDefault();
        }
        if (this.context.getName().equals(Context.getDefault().getName())) {
            return Context.getDefault();
        }
        return this.context;
    }

    public void setContext(Context context) {
        if (Utils.equal((Object)this.context, (Object)context)) {
            return;
        }
        if (this.context != null) {
            this.context.removeObserver(this);
        }
        Context oldValue = this.context;
        this.context = context;
        if (this.context != null) {
            this.context.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
        this.getPropertyChangeSupport().firePropertyChange(PROP_CONTEXT, oldValue, context);
    }

    public Value getTime() {
        return this.time;
    }

    public void setTime(Value time) {
        if (Utils.equal((Object)this.time, (Object)time)) {
            return;
        }
        if (this.time != null) {
            this.time.removeObserver(this);
        }
        Value oldValue = this.time;
        this.time = time;
        if (this.time != null) {
            this.time.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
        this.getPropertyChangeSupport().firePropertyChange(PROP_TIME, oldValue, time);
    }

    public Value getEnergy() {
        return this.energy;
    }

    public void setEnergy(Value energy) {
        if (Utils.equal((Object)this.energy, (Object)energy)) {
            return;
        }
        if (this.energy != null) {
            this.energy.removeObserver(this);
        }
        Value oldValue = this.energy;
        this.energy = energy;
        if (this.energy != null) {
            this.energy.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
        this.getPropertyChangeSupport().firePropertyChange(PROP_ENERGY, oldValue, energy);
    }

    public Value getPriority() {
        return this.priority;
    }

    public void setPriority(Value priority) {
        if (Utils.equal((Object)this.priority, (Object)priority)) {
            return;
        }
        if (this.priority != null) {
            this.priority.removeObserver(this);
        }
        Value oldValue = this.priority;
        this.priority = priority;
        if (this.priority != null) {
            this.priority.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
        this.getPropertyChangeSupport().firePropertyChange(PROP_PRIORITY, oldValue, priority);
    }

    public String getNotes() {
        return this.notes == null ? "" : this.notes;
    }

    public void setNotes(String notes) {
        if (Utils.equal((Object)this.notes, (Object)notes)) {
            return;
        }
        this.notes = notes;
        this.setModified();
        this.notifyObservers(this, (Object)FIELD.Notes);
    }

    public boolean equals(Object object) {
        if (object instanceof Action) {
            return this.getID() == ((Action)object).getID();
        }
        return false;
    }

    public String toString() {
        return this.getDescription();
    }

    public void update(Observable observable, Object argument) {
        if (observable instanceof ActionState) {
            this.getPropertyChangeSupport().firePropertyChange(PROP_STATE, null, (Object)this.state);
        }
        this.notifyObservers(this, argument);
    }

    public void resetObservers() {
        if (this.state != null) {
            this.state.addObserver(this);
            this.state.resetObservers();
        }
        if (this.topic != null) {
            this.topic.addObserver(this);
            this.topic.resetObservers();
        }
        if (this.context != null) {
            this.context.addObserver(this);
            this.context.resetObservers();
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean canSetDone(boolean b) {
        return true;
    }

    public void setDone(boolean done) {
        if (this.done == done) {
            return;
        }
        boolean oldValue = this.done;
        this.done = done;
        if (done) {
            ActionStateScheduled s;
            Recurrence r;
            if (this.doneDate == null) {
                this.doneDate = Calendar.getInstance().getTime();
            }
            if (this.parent != null && !this.parent.isRoot()) {
                Thread sequencingThread = new Thread("Action Sequencing"){

                    public void run() {
                        Action.this.parent.sequence();
                    }
                };
                sequencingThread.start();
            }
            if (this.isStateScheduled() && (r = (s = (ActionStateScheduled)this.getState()).getRecurrence()) != null && r.getBasis() == Recurrence.Basis.DONE_DATE) {
                r.generateSubsequent(this);
            }
        } else {
            this.doneDate = null;
            if (this.parent != null && !this.parent.isRoot()) {
                this.parent.setDone(false);
            }
        }
        this.setModified();
        this.notifyObservers(this);
        this.getPropertyChangeSupport().firePropertyChange(PROP_DONE, oldValue, done);
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            return;
        }
        if (Utils.equal((Object)this.description, (Object)description)) {
            return;
        }
        String oldValue = this.description;
        this.description = description;
        this.setModified();
        this.notifyObservers(this);
        this.getPropertyChangeSupport().firePropertyChange(PROP_DESCR, oldValue, description);
    }

    public String getSuccess() {
        return this.success == null ? "" : this.success;
    }

    public void setSuccess(String success) {
        if (Utils.equal((Object)this.success, (Object)success)) {
            return;
        }
        this.success = success;
        this.setModified();
        this.notifyObservers(this);
    }

    public ImageIcon getIcon(boolean expanded) {
        if (this.isStateASAP()) {
            return Icons.ActionDoASAP;
        }
        if (this.isStateDelegated()) {
            return Icons.ActionDelegated;
        }
        if (this.isStateScheduled()) {
            ActionStateScheduled s = (ActionStateScheduled)this.getState();
            Recurrence r = s.getRecurrence();
            if (r == null) {
                return Icons.ActionScheduled;
            }
            if (r.getBasis() == Recurrence.Basis.START_DATE) {
                return Icons.ActionScheduledReg;
            }
            return Icons.ActionScheduledSub;
        }
        if (this.isStateInactive()) {
            return Icons.ActionInactive;
        }
        return Icons.ActionDoASAP;
    }

    public ItemList getParent() {
        return this.parent;
    }

    public void setParent(ItemList parent) {
        if (Utils.equal((Object)this.parent, (Object)parent)) {
            return;
        }
        if (parent instanceof Project) {
            this.parent = (Project)parent;
            this.setModified();
            this.notifyObservers(this);
        }
    }

    public Item copy(IDGenerator idGenerator) {
        Action copy = new Action(idGenerator);
        copy.setCreated();
        copy.setModified();
        copy.thought = this.thought;
        copy.parent = this.parent;
        copy.description = this.description;
        copy.success = this.success;
        copy.topic = this.topic;
        copy.context = this.context;
        copy.time = this.time;
        copy.energy = this.energy;
        copy.priority = this.priority;
        copy.state = this.state.copy();
        copy.notes = this.notes;
        copy.startDate = this.startDate;
        copy.dueDate = this.dueDate;
        copy.done = this.done;
        copy.doneDate = this.doneDate;
        return copy;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public boolean isWithin(ItemList list) {
        if (list == null || this.parent == null) {
            return false;
        }
        if (list == this.parent) {
            return true;
        }
        return this.parent.isWithin(list);
    }

    public boolean isEditable() {
        return true;
    }

    public int compareTo(Item item) {
        if (item instanceof Action) {
            return this.getDescription().compareToIgnoreCase(((Action)item).getDescription());
        }
        throw new ClassCastException(item.getClass().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FIELD {
        Notes;

    }
}

