/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;

public class HardcodedLDAPAttributeMapper
extends AbstractLDAPStorageMapper {
    private static final Logger logger = Logger.getLogger(HardcodedLDAPAttributeMapper.class);
    public static final String LDAP_ATTRIBUTE_NAME = "ldap.attribute.name";
    public static final String LDAP_ATTRIBUTE_VALUE = "ldap.attribute.value";
    private static final String RANDOM = "RANDOM";
    public static final String RANDOM_ATTRIBUTE_VALUE = "${RANDOM}";
    public static Pattern substitution = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVW1234567890";

    public HardcodedLDAPAttributeMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
        String ldapAttrName = this.mapperModel.get(LDAP_ATTRIBUTE_NAME);
        String ldapAttrValue = this.mapperModel.get(LDAP_ATTRIBUTE_VALUE);
        String computedValue = this.computeAttributeValue(ldapAttrName, ldapAttrValue, ldapUser, localUser, realm);
        ldapUser.setAttribute(ldapAttrName, Collections.singleton(computedValue));
    }

    protected String computeAttributeValue(String ldapAttrName, String ldapAttrValue, LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
        Matcher m = substitution.matcher(ldapAttrValue);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String token = m.group(1);
            if (token.equals(RANDOM)) {
                String randomVal = this.getRandomValue();
                m.appendReplacement(sb, randomVal);
                continue;
            }
            m.appendReplacement(sb, token);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected String getRandomValue() {
        SecureRandom r = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 30; ++i) {
            char c = CHARS.charAt(r.nextInt(CHARS.length()));
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        String ldapAttrName = this.mapperModel.get(LDAP_ATTRIBUTE_NAME);
        ldapUser.addReadOnlyAttributeName(ldapAttrName);
        return delegate;
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
    }
}

