/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.wildfly.common.Assert;
import org.wildfly.security.authz.AddPrefixRoles;
import org.wildfly.security.authz.AddSuffixRoles;
import org.wildfly.security.authz.DifferenceRoles;
import org.wildfly.security.authz.DisjunctionRoles;
import org.wildfly.security.authz.IntersectionRoles;
import org.wildfly.security.authz.OneRole;
import org.wildfly.security.authz.UnionRoles;

public interface Roles
extends Iterable<String> {
    public static final Roles NONE = new Roles(){

        @Override
        public boolean contains(String roleName) {
            return false;
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public Spliterator<String> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        public Roles and(Roles other) {
            return this;
        }

        @Override
        public Roles or(Roles other) {
            return other;
        }

        @Override
        public Roles xor(Roles other) {
            return other;
        }

        @Override
        public Roles minus(Roles other) {
            return this;
        }

        @Override
        public Roles addSuffix(String suffix) {
            return this;
        }

        @Override
        public Roles addPrefix(String prefix) {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public String toString() {
            return "NONE";
        }
    };

    public boolean contains(String var1);

    default public boolean containsAny(Set<String> desiredRoles) {
        Assert.checkNotNullParam((String)"desiredRoles", desiredRoles);
        for (String current : desiredRoles) {
            if (!this.contains(current)) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(Set<String> desiredRoles) {
        Assert.checkNotNullParam((String)"desiredRoles", desiredRoles);
        Assert.checkNotEmptyParam((String)"desiredRoles", desiredRoles);
        for (String current : desiredRoles) {
            if (this.contains(current)) continue;
            return false;
        }
        return true;
    }

    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    default public Spliterator<String> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 257);
    }

    public static Roles fromSet(final Set<String> set) {
        Assert.checkNotNullParam((String)"set", set);
        if (set instanceof Roles) {
            return (Roles)((Object)set);
        }
        return new Roles(){

            @Override
            public boolean contains(String roleName) {
                return set.contains(roleName);
            }

            @Override
            public Iterator<String> iterator() {
                return set.iterator();
            }

            @Override
            public Spliterator<String> spliterator() {
                return set.spliterator();
            }

            @Override
            public void forEach(Consumer<? super String> action) {
                set.forEach(action);
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty();
            }
        };
    }

    public static Set<String> toSet(Roles roles) {
        Assert.checkNotNullParam((String)"roles", (Object)roles);
        Iterator iterator = roles.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptySet();
        }
        String role = (String)iterator.next();
        if (!iterator.hasNext()) {
            return Collections.singleton(role);
        }
        TreeSet<String> result = new TreeSet<String>();
        result.add(role);
        while (iterator.hasNext()) {
            result.add((String)iterator.next());
        }
        return Collections.unmodifiableSet(result);
    }

    public static Roles of(String role) {
        Assert.checkNotNullParam((String)"role", (Object)role);
        return new OneRole(role);
    }

    default public Roles and(Roles other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        return this.isEmpty() || other.isEmpty() ? NONE : new IntersectionRoles(this, other);
    }

    default public Roles or(Roles other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        return this.isEmpty() ? other : (other.isEmpty() ? this : new UnionRoles(this, other));
    }

    default public Roles xor(Roles other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        return this.isEmpty() ? other : (other.isEmpty() ? this : new DisjunctionRoles(this, other));
    }

    default public Roles minus(Roles other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        return this.isEmpty() ? NONE : (other.isEmpty() ? this : new DifferenceRoles(this, other));
    }

    default public Roles addSuffix(String suffix) {
        Assert.checkNotNullParam((String)"suffix", (Object)suffix);
        return suffix.isEmpty() ? this : (this.isEmpty() ? NONE : new AddSuffixRoles(this, suffix));
    }

    default public Roles addPrefix(String prefix) {
        Assert.checkNotNullParam((String)"prefix", (Object)prefix);
        return prefix.isEmpty() ? this : (this.isEmpty() ? NONE : new AddPrefixRoles(this, prefix));
    }
}

