/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.lock;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.locking.GlobalLockProvider;
import org.keycloak.models.locking.GlobalLockProviderFactory;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.lock.MapGlobalLockProvider;
import org.keycloak.models.map.lock.MapLockEntity;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class MapGlobalLockProviderFactory
extends AbstractMapProviderFactory<GlobalLockProvider, MapLockEntity, MapLockEntity>
implements GlobalLockProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String DEFAULT_TIMEOUT_MILLISECONDS = "defaultTimeoutMilliseconds";
    public static final long DEFAULT_VALUE = 5000L;
    private long defaultTimeoutMilliseconds;

    public MapGlobalLockProviderFactory() {
        super(MapLockEntity.class, GlobalLockProvider.class);
    }

    @Override
    public MapGlobalLockProvider createNew(KeycloakSession session) {
        return new MapGlobalLockProvider(session, this.defaultTimeoutMilliseconds, () -> this.getMapStorage(session));
    }

    @Override
    public void init(Config.Scope config) {
        super.init(config);
        this.defaultTimeoutMilliseconds = config.getLong(DEFAULT_TIMEOUT_MILLISECONDS, Long.valueOf(5000L));
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    @Override
    public String getId() {
        return "map";
    }

    @Override
    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public String getHelpText() {
        return "Lock provider";
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(DEFAULT_TIMEOUT_MILLISECONDS).type("int").helpText("Default timeout when waiting for a lock").defaultValue((Object)5000L).add().build();
    }
}

