/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.io.Serializable;
import org.keycloak.storage.jpa.KeyUtils;

@NamedQueries(value={@NamedQuery(name="getFederatedUserRequiredActionsByUser", query="select action from FederatedUserRequiredActionEntity action where action.userId = :userId and action.realmId=:realmId"), @NamedQuery(name="deleteFederatedUserRequiredActionsByUser", query="delete from FederatedUserRequiredActionEntity action where action.realmId=:realmId and action.userId = :userId"), @NamedQuery(name="deleteFederatedUserRequiredActionsByRealm", query="delete from FederatedUserRequiredActionEntity action where action.realmId=:realmId"), @NamedQuery(name="deleteFederatedUserRequiredActionsByStorageProvider", query="delete from FederatedUserRequiredActionEntity e where e.storageProviderId=:storageProviderId"), @NamedQuery(name="deleteFederatedUserRequiredActionsByRealmAndLink", query="delete from FederatedUserRequiredActionEntity action where action.userId IN (select u.id from UserEntity u where u.realmId=:realmId and u.federationLink=:link)")})
@Entity
@Table(name="FED_USER_REQUIRED_ACTION")
@IdClass(value=Key.class)
public class FederatedUserRequiredActionEntity {
    @Id
    @Column(name="USER_ID")
    protected String userId;
    @Id
    @Column(name="REQUIRED_ACTION")
    protected String action;
    @Column(name="REALM_ID")
    protected String realmId;
    @Column(name="STORAGE_PROVIDER_ID")
    protected String storageProviderId;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        KeyUtils.assertValidKey(userId);
        this.userId = userId;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getStorageProviderId() {
        return this.storageProviderId;
    }

    public void setStorageProviderId(String storageProviderId) {
        this.storageProviderId = storageProviderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FederatedUserRequiredActionEntity)) {
            return false;
        }
        FederatedUserRequiredActionEntity key = (FederatedUserRequiredActionEntity)o;
        if (this.action != key.action) {
            return false;
        }
        return !(this.userId != null ? !this.userId.equals(key.userId != null ? key.userId : null) : key.userId != null);
    }

    public int hashCode() {
        int result = this.userId != null ? this.userId.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        return result;
    }

    public static class Key
    implements Serializable {
        protected String userId;
        protected String action;

        public Key() {
        }

        public Key(String user, String action) {
            this.userId = user;
            this.action = action;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getAction() {
            return this.action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.action != key.action) {
                return false;
            }
            return !(this.userId != null ? !this.userId.equals(key.userId != null ? key.userId : null) : key.userId != null);
        }

        public int hashCode() {
            int result = this.userId != null ? this.userId.hashCode() : 0;
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            return result;
        }
    }
}

