/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Either<L, R> {
    default public boolean isLeft() {
        return this.fold(left -> true, right -> false);
    }

    default public boolean isRight() {
        return this.fold(left -> false, right -> true);
    }

    public <V> V fold(Function<? super L, ? extends V> var1, Function<? super R, ? extends V> var2);

    default public void forEach(Consumer<? super L> leftConsumer, Consumer<? super R> rightConsumer) {
        this.fold(left -> {
            leftConsumer.accept((Object)left);
            return null;
        }, right -> {
            rightConsumer.accept((Object)right);
            return null;
        });
    }

    default public <A, B> Either<A, B> map(Function<? super L, ? extends A> leftFn, Function<? super R, ? extends B> rightFn) {
        return this.fold(left -> Either.left(leftFn.apply((Object)left)), right -> Either.right(rightFn.apply((Object)right)));
    }

    default public <V> Either<L, V> map(Function<? super R, ? extends V> fn) {
        return this.fold(Either::left, r -> Either.right(fn.apply((Object)r)));
    }

    default public <V> Either<L, V> flatMap(Function<? super R, ? extends Either<L, V>> f) {
        return this.fold(Either::left, f);
    }

    default public Optional<L> left() {
        return this.fold(Optional::of, r -> Optional.empty());
    }

    default public Optional<R> right() {
        return this.fold(l -> Optional.empty(), Optional::of);
    }

    public static <A, B> Either<A, B> left(final A a) {
        return new Either<A, B>(){

            @Override
            public <V> V fold(Function<? super A, ? extends V> leftFn, Function<? super B, ? extends V> rightFn) {
                return leftFn.apply(a);
            }

            public String toString() {
                if (a == null) {
                    return "Left (null type): null";
                }
                return String.format("Left (%s): %s", a.getClass(), a);
            }
        };
    }

    public static <A, B> Either<A, B> right(final B b) {
        return new Either<A, B>(){

            @Override
            public <V> V fold(Function<? super A, ? extends V> leftFn, Function<? super B, ? extends V> rightFn) {
                return rightFn.apply(b);
            }

            public String toString() {
                if (b == null) {
                    return "Right (null type): null";
                }
                return String.format("Right (%s): %s", b.getClass(), b);
            }
        };
    }
}

