/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.hibernate.internal.SessionImpl;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.common.Profile;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.events.Event;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SingleUseObjectValueModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.locking.GlobalLockProvider;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntityImpl;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.SessionAttributesUtils;
import org.keycloak.models.map.lock.MapLockEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntityImpl;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntityImpl;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntityImpl;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntityImpl;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntityImpl;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntityImpl;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntity;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntityImpl;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntity;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntityImpl;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntity;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntityImpl;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntity;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntityImpl;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProvider;
import org.keycloak.models.map.storage.jpa.JpaMapUtils;
import org.keycloak.models.map.storage.jpa.PersistenceExceptionConverter;
import org.keycloak.models.map.storage.jpa.authSession.JpaRootAuthenticationSessionMapStorage;
import org.keycloak.models.map.storage.jpa.authSession.entity.JpaAuthenticationSessionEntity;
import org.keycloak.models.map.storage.jpa.authSession.entity.JpaRootAuthenticationSessionEntity;
import org.keycloak.models.map.storage.jpa.authorization.permission.JpaPermissionMapStorage;
import org.keycloak.models.map.storage.jpa.authorization.permission.entity.JpaPermissionEntity;
import org.keycloak.models.map.storage.jpa.authorization.policy.JpaPolicyMapStorage;
import org.keycloak.models.map.storage.jpa.authorization.policy.entity.JpaPolicyEntity;
import org.keycloak.models.map.storage.jpa.authorization.resource.JpaResourceMapStorage;
import org.keycloak.models.map.storage.jpa.authorization.resource.entity.JpaResourceEntity;
import org.keycloak.models.map.storage.jpa.authorization.resourceServer.JpaResourceServerMapStorage;
import org.keycloak.models.map.storage.jpa.authorization.resourceServer.entity.JpaResourceServerEntity;
import org.keycloak.models.map.storage.jpa.authorization.scope.JpaScopeMapStorage;
import org.keycloak.models.map.storage.jpa.authorization.scope.entity.JpaScopeEntity;
import org.keycloak.models.map.storage.jpa.client.JpaClientMapStorage;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientEntity;
import org.keycloak.models.map.storage.jpa.clientScope.JpaClientScopeMapStorage;
import org.keycloak.models.map.storage.jpa.clientScope.entity.JpaClientScopeEntity;
import org.keycloak.models.map.storage.jpa.event.admin.JpaAdminEventMapStorage;
import org.keycloak.models.map.storage.jpa.event.admin.entity.JpaAdminEventEntity;
import org.keycloak.models.map.storage.jpa.event.auth.JpaAuthEventMapStorage;
import org.keycloak.models.map.storage.jpa.event.auth.entity.JpaAuthEventEntity;
import org.keycloak.models.map.storage.jpa.group.JpaGroupMapStorage;
import org.keycloak.models.map.storage.jpa.group.entity.JpaGroupEntity;
import org.keycloak.models.map.storage.jpa.lock.JpaLockMapStorage;
import org.keycloak.models.map.storage.jpa.lock.entity.JpaLockEntity;
import org.keycloak.models.map.storage.jpa.loginFailure.JpaUserLoginFailureMapStorage;
import org.keycloak.models.map.storage.jpa.loginFailure.entity.JpaUserLoginFailureEntity;
import org.keycloak.models.map.storage.jpa.realm.JpaRealmMapStorage;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaComponentEntity;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaRealmEntity;
import org.keycloak.models.map.storage.jpa.role.JpaRoleMapStorage;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleEntity;
import org.keycloak.models.map.storage.jpa.singleUseObject.JpaSingleUseObjectMapStorage;
import org.keycloak.models.map.storage.jpa.singleUseObject.entity.JpaSingleUseObjectEntity;
import org.keycloak.models.map.storage.jpa.updater.MapJpaUpdaterProvider;
import org.keycloak.models.map.storage.jpa.user.JpaUserMapStorage;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserConsentEntity;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserEntity;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserFederatedIdentityEntity;
import org.keycloak.models.map.storage.jpa.userSession.JpaUserSessionMapStorage;
import org.keycloak.models.map.storage.jpa.userSession.entity.JpaClientSessionEntity;
import org.keycloak.models.map.storage.jpa.userSession.entity.JpaUserSessionEntity;
import org.keycloak.models.map.user.MapUserCredentialEntity;
import org.keycloak.models.map.user.MapUserCredentialEntityImpl;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.transaction.JtaTransactionManagerLookup;

public class JpaMapStorageProviderFactory
implements AmphibianProviderFactory<MapStorageProvider>,
MapStorageProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "jpa";
    private static final Logger logger = Logger.getLogger(JpaMapStorageProviderFactory.class);
    public static final String HIBERNATE_DEFAULT_SCHEMA = "hibernate.default_schema";
    private static final long DEFAULT_LOCK_TIMEOUT = 10000L;
    private volatile EntityManagerFactory emf;
    private final Set<Class<?>> validatedModels = ConcurrentHashMap.newKeySet();
    private Config.Scope config;
    private final int factoryId = SessionAttributesUtils.grabNewFactoryIdentifier();
    private String databaseShortName;
    private final ConcurrentHashMap<Class<?>, Object> SYNC_MODELS = new ConcurrentHashMap();
    public static final DeepCloner CLONER = new DeepCloner.Builder().constructor(JpaRootAuthenticationSessionEntity.class, JpaRootAuthenticationSessionEntity::new).constructor(JpaAuthenticationSessionEntity.class, JpaAuthenticationSessionEntity::new).constructor(JpaResourceServerEntity.class, JpaResourceServerEntity::new).constructor(JpaResourceEntity.class, JpaResourceEntity::new).constructor(JpaScopeEntity.class, JpaScopeEntity::new).constructor(JpaPermissionEntity.class, JpaPermissionEntity::new).constructor(JpaPolicyEntity.class, JpaPolicyEntity::new).constructor(JpaClientEntity.class, JpaClientEntity::new).constructor(MapProtocolMapperEntity.class, MapProtocolMapperEntityImpl::new).constructor(JpaClientScopeEntity.class, JpaClientScopeEntity::new).constructor(JpaAdminEventEntity.class, JpaAdminEventEntity::new).constructor(JpaAuthEventEntity.class, JpaAuthEventEntity::new).constructor(JpaGroupEntity.class, JpaGroupEntity::new).constructor(JpaRealmEntity.class, JpaRealmEntity::new).constructor(JpaComponentEntity.class, JpaComponentEntity::new).constructor(MapAuthenticationExecutionEntity.class, MapAuthenticationExecutionEntityImpl::new).constructor(MapAuthenticationFlowEntity.class, MapAuthenticationFlowEntityImpl::new).constructor(MapAuthenticatorConfigEntity.class, MapAuthenticatorConfigEntityImpl::new).constructor(MapClientInitialAccessEntity.class, MapClientInitialAccessEntityImpl::new).constructor(MapIdentityProviderEntity.class, MapIdentityProviderEntityImpl::new).constructor(MapIdentityProviderMapperEntity.class, MapIdentityProviderMapperEntityImpl::new).constructor(MapOTPPolicyEntity.class, MapOTPPolicyEntityImpl::new).constructor(MapRequiredActionProviderEntity.class, MapRequiredActionProviderEntityImpl::new).constructor(MapRequiredCredentialEntity.class, MapRequiredCredentialEntityImpl::new).constructor(MapWebAuthnPolicyEntity.class, MapWebAuthnPolicyEntityImpl::new).constructor(JpaRoleEntity.class, JpaRoleEntity::new).constructor(JpaSingleUseObjectEntity.class, JpaSingleUseObjectEntity::new).constructor(JpaUserLoginFailureEntity.class, JpaUserLoginFailureEntity::new).constructor(JpaUserEntity.class, JpaUserEntity::new).constructor(JpaUserConsentEntity.class, JpaUserConsentEntity::new).constructor(JpaUserFederatedIdentityEntity.class, JpaUserFederatedIdentityEntity::new).constructor(MapUserCredentialEntity.class, MapUserCredentialEntityImpl::new).constructor(JpaClientSessionEntity.class, JpaClientSessionEntity::new).constructor(JpaUserSessionEntity.class, JpaUserSessionEntity::new).constructor(JpaLockEntity.class, JpaLockEntity::new).build();
    private static final Map<Class<?>, BiFunction<KeycloakSession, EntityManager, MapStorage>> MODEL_TO_STORE = new HashMap();
    private boolean jtaEnabled;
    private JtaTransactionManagerLookup jtaLookup;
    volatile boolean initialized;

    public MapStorage createMapStorage(KeycloakSession session, Class<?> modelType, EntityManager em) {
        return MODEL_TO_STORE.get(modelType).apply(session, em);
    }

    public MapStorageProvider create(KeycloakSession session) {
        this.lazyInit();
        return (MapStorageProvider)SessionAttributesUtils.createProviderIfAbsent((KeycloakSession)session, (int)this.factoryId, JpaMapStorageProvider.class, session1 -> new JpaMapStorageProvider(this, session, PersistenceExceptionConverter.create(session, this.getEntityManager()), this.jtaEnabled, this.factoryId));
    }

    protected EntityManager getEntityManager() {
        Long lockTimeout;
        EntityManager em = this.emf.createEntityManager();
        if (("postgresql".equals(this.databaseShortName) || "cockroachdb".equals(this.databaseShortName)) && (lockTimeout = this.config.getLong("lockTimeout", Long.valueOf(10000L))) >= 0L) {
            ((SessionImpl)em.unwrap(SessionImpl.class)).doWork(connection -> {
                try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT set_config('lock_timeout', ?, true)");){
                    preparedStatement.setString(1, String.valueOf(lockTimeout));
                    ResultSet resultSet = preparedStatement.executeQuery();
                    resultSet.close();
                }
            });
        }
        return em;
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.jtaLookup = (JtaTransactionManagerLookup)factory.getProviderFactory(JtaTransactionManagerLookup.class);
        this.jtaEnabled = this.jtaLookup != null && this.jtaLookup.getTransactionManager() != null;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "JPA Map Storage";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public void close() {
        if (this.emf != null) {
            this.emf.close();
        }
        this.validatedModels.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (!this.initialized) {
            JpaMapStorageProviderFactory jpaMapStorageProviderFactory = this;
            synchronized (jpaMapStorageProviderFactory) {
                if (this.emf == null) {
                    this.emf = this.createEntityManagerFactory();
                }
                if (!this.initialized) {
                    JpaMapUtils.addSpecificNamedQueries(this.emf);
                    if (this.jtaEnabled && !this.emf.getProperties().get("jakarta.persistence.transactionType").equals(PersistenceUnitTransactionType.JTA.name())) {
                        throw new ModelException("Consistency check failed: If Keycloak is run with JTA, the Entity Manager for JPA map storage should be run with JTA as well.");
                    }
                    try (EntityManager em = this.getEntityManager();){
                        ((SessionImpl)em.unwrap(SessionImpl.class)).doWork(connection -> {
                            if (connection.getAutoCommit()) {
                                throw new ModelException("The database connection must not use auto-commit. For Quarkus, auto-commit was off once JTA was enabled for the EntityManager.");
                            }
                        });
                    }
                    this.initialized = true;
                }
            }
        }
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        logger.debugf("Initializing JPA connections %s", StackUtil.getShortStackTrace());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String dataSource = this.config.get("dataSource");
        if (dataSource != null) {
            properties.put("jakarta.persistence.nonJtaDataSource", dataSource);
        } else {
            String password;
            properties.put("jakarta.persistence.jdbc.url", this.config.get("url"));
            properties.put("jakarta.persistence.jdbc.driver", this.config.get("driver"));
            String user = this.config.get("user");
            if (user != null) {
                properties.put("jakarta.persistence.jdbc.user", user);
            }
            if ((password = this.config.get("password")) != null) {
                properties.put("jakarta.persistence.jdbc.password", password);
            }
        }
        String schema = this.config.get("schema");
        if (schema != null) {
            properties.put(HIBERNATE_DEFAULT_SCHEMA, schema);
        }
        properties.put("hibernate.show_sql", this.config.getBoolean("showSql", Boolean.valueOf(false)));
        properties.put("hibernate.format_sql", this.config.getBoolean("formatSql", Boolean.valueOf(true)));
        properties.put("hibernate.dialect", this.config.get("driverDialect"));
        properties.put("hibernate.metadata_builder_contributor", "org.keycloak.models.map.storage.jpa.hibernate.contributor.JsonbMetadataBuilderContributor");
        properties.put("jakarta.persistence.validation.mode", ValidationMode.NONE.name());
        Long lockTimeout = this.config.getLong("lockTimeout", Long.valueOf(10000L));
        if (lockTimeout >= 0L) {
            properties.put("jakarta.persistence.lock.timeout", String.valueOf(lockTimeout));
        } else {
            logger.warnf("Database %s used without lockTimeout option configured. This can result in deadlock where one connection waits for a pessimistic write lock forever.", (Object)this.databaseShortName);
        }
        logger.trace((Object)"Creating EntityManagerFactory");
        ParsedPersistenceXmlDescriptor descriptor = PersistenceXmlParser.locateIndividualPersistenceUnit((URL)JpaMapStorageProviderFactory.class.getClassLoader().getResource("default-map-jpa-persistence.xml"));
        EntityManagerFactory emf = Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)descriptor, properties).build();
        logger.trace((Object)"EntityManagerFactory created");
        return emf;
    }

    protected EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAndUpdateSchema(KeycloakSession session, Class<?> modelType) {
        if (!this.validatedModels.contains(modelType)) {
            Object object = this.SYNC_MODELS.computeIfAbsent(modelType, mc -> new Object());
            synchronized (object) {
                if (!this.validatedModels.contains(modelType)) {
                    Transaction suspended = null;
                    try {
                        if (this.jtaEnabled) {
                            suspended = this.jtaLookup.getTransactionManager().suspend();
                            this.jtaLookup.getTransactionManager().begin();
                        }
                        Connection connection = this.getConnection();
                        try {
                            if (logger.isDebugEnabled()) {
                                this.printOperationalInfo(connection);
                            }
                            MapJpaUpdaterProvider updater = (MapJpaUpdaterProvider)session.getProvider(MapJpaUpdaterProvider.class);
                            MapJpaUpdaterProvider.Status status = updater.validate(modelType, connection, this.config.get("schema"));
                            this.databaseShortName = updater.getDatabaseShortName();
                            if (!status.equals((Object)MapJpaUpdaterProvider.Status.VALID)) {
                                this.update(modelType, connection, session);
                            }
                        }
                        finally {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (SQLException e) {
                                    logger.warn((Object)"Can't close connection", (Throwable)e);
                                }
                            }
                        }
                        if (this.jtaEnabled) {
                            this.jtaLookup.getTransactionManager().commit();
                        }
                    }
                    catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e) {
                        if (this.jtaEnabled) {
                            try {
                                this.jtaLookup.getTransactionManager().rollback();
                            }
                            catch (SystemException ex) {
                                logger.error((Object)"Unable to roll back JTA transaction, e");
                            }
                        }
                        throw new RuntimeException(e);
                    }
                    finally {
                        if (suspended != null) {
                            try {
                                this.jtaLookup.getTransactionManager().resume(suspended);
                            }
                            catch (InvalidTransactionException | SystemException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    this.validatedModels.add(modelType);
                }
            }
        }
    }

    protected Connection getConnection() {
        try {
            String dataSourceLookup = this.config.get("dataSource");
            if (dataSourceLookup != null) {
                DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceLookup);
                return dataSource.getConnection();
            }
            Class.forName(this.config.get("driver"));
            return DriverManager.getConnection(StringPropertyReplacer.replaceProperties((String)this.config.get("url"), (Properties)System.getProperties()), this.config.get("user"), this.config.get("password"));
        }
        catch (ClassNotFoundException | SQLException | NamingException e) {
            throw new RuntimeException("Failed to connect to database", e);
        }
    }

    private void printOperationalInfo(Connection connection) {
        try {
            LinkedHashMap<String, String> operationalInfo = new LinkedHashMap<String, String>();
            DatabaseMetaData md = connection.getMetaData();
            operationalInfo.put("databaseUrl", md.getURL());
            operationalInfo.put("databaseUser", md.getUserName());
            operationalInfo.put("databaseProduct", md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            operationalInfo.put("databaseDriver", md.getDriverName() + " " + md.getDriverVersion());
            logger.debugf("Database info: %s", (Object)operationalInfo.toString());
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to prepare operational info due database exception: " + e.getMessage()));
        }
    }

    private void update(Class<?> modelType, Connection connection, KeycloakSession session) {
        if (modelType == MapLockEntity.class) {
            ((MapJpaUpdaterProvider)session.getProvider(MapJpaUpdaterProvider.class)).update(modelType, connection, this.config.get("schema"));
        } else {
            ((GlobalLockProvider)session.getProvider(GlobalLockProvider.class)).withLock(modelType.getName(), lockedSession -> {
                ((MapJpaUpdaterProvider)lockedSession.getProvider(MapJpaUpdaterProvider.class)).update(modelType, connection, this.config.get("schema"));
                return null;
            });
        }
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("lockTimeout").type("long").defaultValue((Object)10000L).helpText("The maximum time to wait in milliseconds when waiting for acquiring a pessimistic read lock. If set to negative there is no timeout configured.").add().build();
    }

    static {
        MODEL_TO_STORE.put(RootAuthenticationSessionModel.class, JpaRootAuthenticationSessionMapStorage::new);
        MODEL_TO_STORE.put(ResourceServer.class, JpaResourceServerMapStorage::new);
        MODEL_TO_STORE.put(Resource.class, JpaResourceMapStorage::new);
        MODEL_TO_STORE.put(Scope.class, JpaScopeMapStorage::new);
        MODEL_TO_STORE.put(PermissionTicket.class, JpaPermissionMapStorage::new);
        MODEL_TO_STORE.put(Policy.class, JpaPolicyMapStorage::new);
        MODEL_TO_STORE.put(ClientModel.class, JpaClientMapStorage::new);
        MODEL_TO_STORE.put(ClientScopeModel.class, JpaClientScopeMapStorage::new);
        MODEL_TO_STORE.put(AdminEvent.class, JpaAdminEventMapStorage::new);
        MODEL_TO_STORE.put(Event.class, JpaAuthEventMapStorage::new);
        MODEL_TO_STORE.put(GroupModel.class, JpaGroupMapStorage::new);
        MODEL_TO_STORE.put(RealmModel.class, JpaRealmMapStorage::new);
        MODEL_TO_STORE.put(RoleModel.class, JpaRoleMapStorage::new);
        MODEL_TO_STORE.put(SingleUseObjectValueModel.class, JpaSingleUseObjectMapStorage::new);
        MODEL_TO_STORE.put(UserLoginFailureModel.class, JpaUserLoginFailureMapStorage::new);
        MODEL_TO_STORE.put(UserModel.class, JpaUserMapStorage::new);
        MODEL_TO_STORE.put(UserSessionModel.class, JpaUserSessionMapStorage::new);
        MODEL_TO_STORE.put(MapLockEntity.class, JpaLockMapStorage::new);
    }
}

