/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataFhss
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = 132223820938643993L;
    private static final int LENGTH = 2;
    private final byte hopSet;
    private final byte hopPattern;

    public static RadiotapDataFhss newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataFhss(rawData, offset, length);
    }

    private RadiotapDataFhss(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapFhss (").append(2).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.hopSet = ByteArrays.getByte(rawData, offset);
        this.hopPattern = ByteArrays.getByte(rawData, offset + 1);
    }

    private RadiotapDataFhss(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder is null.");
        }
        this.hopSet = builder2.hopSet;
        this.hopPattern = builder2.hopPattern;
    }

    public byte getHopSet() {
        return this.hopSet;
    }

    public int getHopSetAsInt() {
        return this.hopSet & 0xFF;
    }

    public byte getHopPattern() {
        return this.hopPattern;
    }

    public int getHopPatternAsInt() {
        return this.hopPattern & 0xFF;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] data2 = new byte[]{this.hopSet, this.hopPattern};
        return data2;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("FHSS: ").append(ls).append(indent).append("  Hop set: ").append(this.getHopSetAsInt()).append(ls).append(indent).append("  Hop pattern: ").append(this.getHopPatternAsInt()).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.hopPattern;
        result2 = 31 * result2 + this.hopSet;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RadiotapDataFhss other = (RadiotapDataFhss)obj;
        if (this.hopPattern != other.hopPattern) {
            return false;
        }
        return this.hopSet == other.hopSet;
    }

    public static final class Builder {
        private byte hopSet;
        private byte hopPattern;

        public Builder() {
        }

        private Builder(RadiotapDataFhss obj) {
            this.hopSet = obj.hopSet;
            this.hopPattern = obj.hopPattern;
        }

        public Builder hopSet(byte hopSet) {
            this.hopSet = hopSet;
            return this;
        }

        public Builder hopPattern(byte hopPattern) {
            this.hopPattern = hopPattern;
            return this;
        }

        public RadiotapDataFhss build() {
            return new RadiotapDataFhss(this);
        }
    }
}

