/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.core.Host;
import gov.nist.javax.sdp.fields.SDPField;
import javax.sdp.Origin;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;

public class OriginField
extends SDPField
implements Origin {
    protected String username;
    protected String nettype;
    protected String addrtype;
    protected Host address;
    private String sessIdString;
    private String sessVersionString;

    public OriginField() {
        super("o=");
    }

    @Override
    public String getUsername() throws SdpParseException {
        return this.username;
    }

    public long getSessId() {
        return Long.valueOf(this.sessIdString);
    }

    public String getSessIdAsString() {
        return this.sessIdString;
    }

    public long getSessVersion() {
        return Long.valueOf(this.sessVersionString);
    }

    public String getSessVersionAsString() {
        return this.sessVersionString;
    }

    public String getNettype() {
        return this.nettype;
    }

    public String getAddrtype() {
        return this.addrtype;
    }

    public Host getHost() {
        return this.address;
    }

    public void setSessId(long s2) {
        this.sessIdString = Long.toString(s2);
    }

    public void setSessionId(String sessId) {
        this.sessIdString = sessId;
    }

    public void setSessVersion(long s2) {
        this.sessVersionString = Long.toString(s2);
    }

    public void setSessVersion(String s2) {
        this.sessVersionString = s2;
    }

    public void setNettype(String n) {
        this.nettype = n;
    }

    public void setAddrtype(String a) {
        this.addrtype = a;
    }

    public void setAddress(Host a) {
        this.address = a;
    }

    @Override
    public void setUsername(String user) throws SdpException {
        if (user == null) {
            throw new SdpException("The user parameter is null");
        }
        this.username = user;
    }

    @Override
    public long getSessionId() throws SdpParseException {
        return this.getSessId();
    }

    @Override
    public void setSessionId(long id) throws SdpException {
        if (id < 0L) {
            throw new SdpException("The is parameter is <0");
        }
        this.setSessId(id);
    }

    @Override
    public long getSessionVersion() throws SdpParseException {
        return this.getSessVersion();
    }

    @Override
    public void setSessionVersion(long version2) throws SdpException {
        if (version2 < 0L) {
            throw new SdpException("The version parameter is <0");
        }
        this.setSessVersion(version2);
    }

    @Override
    public String getAddress() throws SdpParseException {
        Host addr = this.getHost();
        if (addr == null) {
            return null;
        }
        return addr.getAddress();
    }

    @Override
    public String getAddressType() throws SdpParseException {
        return this.getAddrtype();
    }

    @Override
    public String getNetworkType() throws SdpParseException {
        return this.getNettype();
    }

    @Override
    public void setAddress(String addr) throws SdpException {
        if (addr == null) {
            throw new SdpException("The addr parameter is null");
        }
        Host host = this.getHost();
        if (host == null) {
            host = new Host();
        }
        host.setAddress(addr);
        this.setAddress(host);
    }

    @Override
    public void setAddressType(String type2) throws SdpException {
        if (type2 == null) {
            throw new SdpException("The type parameter is <0");
        }
        this.setAddrtype(type2);
    }

    @Override
    public void setNetworkType(String type2) throws SdpException {
        if (type2 == null) {
            throw new SdpException("The type parameter is <0");
        }
        this.setNettype(type2);
    }

    @Override
    public String encode() {
        String addressStr = null;
        if (this.address != null && Host.isIPv6Reference(addressStr = this.address.encode())) {
            addressStr = addressStr.substring(1, addressStr.length() - 1);
        }
        return "o=" + this.username + " " + this.sessIdString + " " + this.sessVersionString + " " + this.nettype + " " + this.addrtype + " " + addressStr + "\r\n";
    }

    @Override
    public Object clone() {
        OriginField retval = (OriginField)super.clone();
        if (this.address != null) {
            retval.address = (Host)this.address.clone();
        }
        return retval;
    }
}

