/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser;

import java.util.ArrayList;
import java.util.List;
import org.jboss.galleon.util.formatparser.DefaultContentHandlerFactory;
import org.jboss.galleon.util.formatparser.ExtendedContentHandlerFactory;
import org.jboss.galleon.util.formatparser.FormatContentHandler;
import org.jboss.galleon.util.formatparser.FormatContentHandlerFactory;
import org.jboss.galleon.util.formatparser.FormatErrors;
import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingContext;
import org.jboss.galleon.util.formatparser.ParsingFormat;
import org.jboss.galleon.util.formatparser.formats.WildcardParsingFormat;
import org.jboss.galleon.util.formatparser.formats.expr.FormatExprContentHandler;
import org.jboss.galleon.util.formatparser.formats.expr.FormatExprParsingFormat;
import org.jboss.galleon.util.formatparser.formats.expr.FormatExprTypeParamContentHandler;

public class FormatParser
implements ParsingContext {
    private final ParsingFormat rootFormat;
    private final FormatContentHandlerFactory cbFactory;
    private List<FormatContentHandler> cbStack = new ArrayList<FormatContentHandler>();
    private String str;
    private int chI;
    private int handlerIndex;
    private boolean breakHandling;
    private boolean bounced;

    public static ParsingFormat resolveFormat(String expr) throws FormatParsingException {
        return (ParsingFormat)FormatParser.parse(ExtendedContentHandlerFactory.getInstance().addContentHandler("FormatExpr", FormatExprContentHandler.class).addContentHandler("TypeParam", FormatExprTypeParamContentHandler.class).addContentHandler("ListTypeExpr", FormatExprParsingFormat.ListTypeContentHandler.class).addContentHandler("CompTypeExpr", FormatExprParsingFormat.CompositeTypeContentHandler.class), FormatExprParsingFormat.getInstance(), expr);
    }

    public static Object parse(String str) throws FormatParsingException {
        return FormatParser.parse(DefaultContentHandlerFactory.getInstance(), WildcardParsingFormat.getInstance(), str);
    }

    public static Object parse(ParsingFormat format, String str) throws FormatParsingException {
        return FormatParser.parse(DefaultContentHandlerFactory.getInstance(), format, str);
    }

    public static Object parse(FormatContentHandlerFactory cbFactory, ParsingFormat format, String str) throws FormatParsingException {
        return new FormatParser(cbFactory, format, str).parse();
    }

    public FormatParser(FormatContentHandlerFactory cbFactory, ParsingFormat rootFormat, String str) {
        this.rootFormat = rootFormat;
        this.cbFactory = cbFactory;
        this.str = str;
    }

    public Object parse() throws FormatParsingException {
        if (this.str == null) {
            return null;
        }
        this.chI = 0;
        FormatContentHandler rootCb = this.cbFactory.forFormat(this.rootFormat, this.chI);
        if (!this.str.isEmpty()) {
            this.cbStack.add(rootCb);
            try {
                this.doParse();
            }
            catch (FormatParsingException e) {
                int formatStart;
                ParsingFormat format;
                if (this.handlerIndex < 0) {
                    format = this.rootFormat;
                    formatStart = 0;
                } else {
                    FormatContentHandler ch = this.cbStack.get(this.handlerIndex);
                    format = ch.format;
                    formatStart = ch.strIndex;
                }
                throw new FormatParsingException(FormatErrors.parsingFailed(this.str, this.chI, format, formatStart), e);
            }
        }
        return rootCb.getContent();
    }

    private void doParse() throws FormatParsingException {
        this.rootFormat.pushed(this);
        while (++this.chI < this.str.length()) {
            this.handlerIndex = this.cbStack.size();
            this.breakHandling = false;
            this.bounced = false;
            while (this.handlerIndex > 0 && !this.breakHandling) {
                FormatContentHandler cb = this.cbStack.get(--this.handlerIndex);
                cb.getFormat().react(this);
            }
            if (!this.bounced && this.breakHandling) continue;
            this.handlerIndex = this.cbStack.size() - 1;
            if (this.handlerIndex < 0) {
                throw new FormatParsingException("EOL");
            }
            this.cbStack.get(this.handlerIndex).getFormat().deal(this);
        }
        if (this.handlerIndex >= 0) {
            FormatContentHandler ended = this.cbStack.get(this.handlerIndex--);
            ended.getFormat().eol(this);
            while (this.handlerIndex >= 0) {
                this.cbStack.get(this.handlerIndex).addChild(ended);
                ended = this.cbStack.get(this.handlerIndex--);
                ended.getFormat().eol(this);
            }
        }
    }

    @Override
    public void pushFormat(ParsingFormat format) throws FormatParsingException {
        if (this.handlerIndex != this.cbStack.size() - 1) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.cbStack.get(0).getFormat());
            if (this.handlerIndex == 0) {
                buf.append('!');
            }
            for (int i = 1; i < this.cbStack.size(); ++i) {
                buf.append(", ").append(this.cbStack.get(i).getFormat());
                if (this.handlerIndex != i) continue;
                buf.append('!');
            }
            throw new FormatParsingException("Child formats need to be popped: " + buf);
        }
        this.breakHandling = true;
        this.cbStack.add(this.cbFactory.forFormat(format, this.chI));
        ++this.handlerIndex;
        format.pushed(this);
    }

    @Override
    public void popFormats() throws FormatParsingException {
        this.breakHandling = true;
        if (this.handlerIndex == this.cbStack.size() - 1) {
            return;
        }
        for (int i = this.cbStack.size() - 1; i > this.handlerIndex; --i) {
            FormatContentHandler ended = this.cbStack.remove(i);
            if (this.cbStack.isEmpty()) continue;
            this.cbStack.get(i - 1).addChild(ended);
        }
    }

    @Override
    public void end() throws FormatParsingException {
        this.breakHandling = true;
        --this.handlerIndex;
        for (int i = this.cbStack.size() - 1; i >= this.handlerIndex + 1; --i) {
            FormatContentHandler ended = this.cbStack.remove(i);
            if (this.cbStack.isEmpty()) continue;
            this.cbStack.get(i - 1).addChild(ended);
        }
        if (!this.cbStack.isEmpty() && this.cbStack.get((int)this.handlerIndex).format.isWrapper()) {
            while (this.handlerIndex > 0) {
                FormatContentHandler ended = this.cbStack.get(this.handlerIndex);
                if (!ended.format.isWrapper()) break;
                this.cbStack.remove(this.handlerIndex--);
                this.cbStack.get(this.handlerIndex).addChild(ended);
            }
        }
        if (this.cbStack.isEmpty() && this.chI < this.str.length() - 1) {
            throw new FormatParsingException(FormatErrors.formatEndedPrematurely(this.rootFormat));
        }
    }

    @Override
    public void bounce() {
        this.breakHandling = true;
        this.bounced = true;
    }

    @Override
    public char charNow() {
        return this.str.charAt(this.chI);
    }

    @Override
    public boolean startsNow(String str) {
        return this.str.startsWith(str, this.chI);
    }

    @Override
    public void content() throws FormatParsingException {
        this.cbStack.get(this.cbStack.size() - 1).character(this.charNow());
    }
}

