/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) ^ 0u) => uvec3(36u, 32u, 88u)
 * (uvec3(36u, 32u, 88u) ^ 6u) => uvec3(34u, 38u, 94u)
 * (uvec3(36u, 32u, 88u) ^ 12u) => uvec3(40u, 44u, 84u)
 * (uvec3(36u, 32u, 88u) ^ 32u) => uvec3(4u, 0u, 120u)
 * (uvec3(36u, 32u, 88u) ^ 74u) => uvec3(110u, 106u, 18u)
 * (uvec3(59u, 77u, 68u) ^ 0u) => uvec3(59u, 77u, 68u)
 * (uvec3(59u, 77u, 68u) ^ 6u) => uvec3(61u, 75u, 66u)
 * (uvec3(59u, 77u, 68u) ^ 12u) => uvec3(55u, 65u, 72u)
 * (uvec3(59u, 77u, 68u) ^ 32u) => uvec3(27u, 109u, 100u)
 * (uvec3(59u, 77u, 68u) ^ 74u) => uvec3(113u, 7u, 14u)
 */
#version 130

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) ^ 0u), uvec3(36u, 32u, 88u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) ^ 6u), uvec3(34u, 38u, 94u))) ? 1 : -1] array1;
  float[all(equal((uvec3(36u, 32u, 88u) ^ 12u), uvec3(40u, 44u, 84u))) ? 1 : -1] array2;
  float[all(equal((uvec3(36u, 32u, 88u) ^ 32u), uvec3(4u, 0u, 120u))) ? 1 : -1] array3;
  float[all(equal((uvec3(36u, 32u, 88u) ^ 74u), uvec3(110u, 106u, 18u))) ? 1 : -1] array4;
  float[all(equal((uvec3(59u, 77u, 68u) ^ 0u), uvec3(59u, 77u, 68u))) ? 1 : -1] array5;
  float[all(equal((uvec3(59u, 77u, 68u) ^ 6u), uvec3(61u, 75u, 66u))) ? 1 : -1] array6;
  float[all(equal((uvec3(59u, 77u, 68u) ^ 12u), uvec3(55u, 65u, 72u))) ? 1 : -1] array7;
  float[all(equal((uvec3(59u, 77u, 68u) ^ 32u), uvec3(27u, 109u, 100u))) ? 1 : -1] array8;
  float[all(equal((uvec3(59u, 77u, 68u) ^ 74u), uvec3(113u, 7u, 14u))) ? 1 : -1] array9;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
