/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * equal(vec3(-1.5, -1.5, -1.5), vec3(-1.5, -0.5, 0.5)) => bvec3(true, false, false)
 * equal(vec3(-1.5, -0.5, -0.5), vec3(1.5, -1.5, -0.5)) => bvec3(false, false, true)
 * equal(vec3(-0.5, -0.5, 0.5), vec3(0.5, 1.5, -1.5)) => bvec3(false, false, false)
 * equal(vec3(0.5, 0.5, 0.5), vec3(-0.5, 0.5, 1.5)) => bvec3(false, true, false)
 * equal(vec3(1.5, 1.5, 1.5), vec3(-1.5, -0.5, 0.5)) => bvec3(false, false, false)
 * equal(vec3(1.5, -1.5, -1.5), vec3(1.5, -1.5, -0.5)) => bvec3(true, true, false)
 */
#version 120

void main()
{
  float[equal(vec3(-1.5, -1.5, -1.5), vec3(-1.5, -0.5, 0.5))[0] == true && equal(vec3(-1.5, -1.5, -1.5), vec3(-1.5, -0.5, 0.5))[1] == false && equal(vec3(-1.5, -1.5, -1.5), vec3(-1.5, -0.5, 0.5))[2] == false ? 1 : -1] array0;
  float[equal(vec3(-1.5, -0.5, -0.5), vec3(1.5, -1.5, -0.5))[0] == false && equal(vec3(-1.5, -0.5, -0.5), vec3(1.5, -1.5, -0.5))[1] == false && equal(vec3(-1.5, -0.5, -0.5), vec3(1.5, -1.5, -0.5))[2] == true ? 1 : -1] array1;
  float[equal(vec3(-0.5, -0.5, 0.5), vec3(0.5, 1.5, -1.5))[0] == false && equal(vec3(-0.5, -0.5, 0.5), vec3(0.5, 1.5, -1.5))[1] == false && equal(vec3(-0.5, -0.5, 0.5), vec3(0.5, 1.5, -1.5))[2] == false ? 1 : -1] array2;
  float[equal(vec3(0.5, 0.5, 0.5), vec3(-0.5, 0.5, 1.5))[0] == false && equal(vec3(0.5, 0.5, 0.5), vec3(-0.5, 0.5, 1.5))[1] == true && equal(vec3(0.5, 0.5, 0.5), vec3(-0.5, 0.5, 1.5))[2] == false ? 1 : -1] array3;
  float[equal(vec3(1.5, 1.5, 1.5), vec3(-1.5, -0.5, 0.5))[0] == false && equal(vec3(1.5, 1.5, 1.5), vec3(-1.5, -0.5, 0.5))[1] == false && equal(vec3(1.5, 1.5, 1.5), vec3(-1.5, -0.5, 0.5))[2] == false ? 1 : -1] array4;
  float[equal(vec3(1.5, -1.5, -1.5), vec3(1.5, -1.5, -0.5))[0] == true && equal(vec3(1.5, -1.5, -1.5), vec3(1.5, -1.5, -0.5))[1] == true && equal(vec3(1.5, -1.5, -1.5), vec3(1.5, -1.5, -0.5))[2] == false ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
