"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class AlertService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getAlerts", async (_context, request, response) => {
      try {
        const {
          detectorType,
          detector_id,
          sortOrder,
          size
        } = request.query;
        const defaultParams = {
          sortOrder,
          size
        };
        let params;

        if (detector_id) {
          params = { ...defaultParams,
            detector_id
          };
        } else if (detectorType) {
          params = { ...defaultParams,
            detectorType
          };
        } else {
          throw Error(`Invalid request params: detectorId or detectorType must be specified`);
        }

        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const getAlertsResponse = await callWithRequest(_constants.CLIENT_ALERTS_METHODS.GET_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - getAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "acknowledgeAlerts", async (_context, request, response) => {
      try {
        const {
          detector_id
        } = request.params;
        const {
          alerts
        } = request.body;
        const body = {
          alerts: alerts
        };
        const params = {
          body,
          detector_id
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const acknowledgeAlertsResponse = await callWithRequest(_constants.CLIENT_ALERTS_METHODS.ACKNOWLEDGE_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: acknowledgeAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - acknowledgeAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Calls backend GET Alerts API.
   */


}

exports.default = AlertService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkFsZXJ0U2VydmljZS50cyJdLCJuYW1lcyI6WyJBbGVydFNlcnZpY2UiLCJjb25zdHJ1Y3RvciIsIm9zRHJpdmVyIiwiX2NvbnRleHQiLCJyZXF1ZXN0IiwicmVzcG9uc2UiLCJkZXRlY3RvclR5cGUiLCJkZXRlY3Rvcl9pZCIsInNvcnRPcmRlciIsInNpemUiLCJxdWVyeSIsImRlZmF1bHRQYXJhbXMiLCJwYXJhbXMiLCJFcnJvciIsImNhbGxBc0N1cnJlbnRVc2VyIiwiY2FsbFdpdGhSZXF1ZXN0IiwiYXNTY29wZWQiLCJnZXRBbGVydHNSZXNwb25zZSIsIkNMSUVOVF9BTEVSVFNfTUVUSE9EUyIsIkdFVF9BTEVSVFMiLCJjdXN0b20iLCJzdGF0dXNDb2RlIiwiYm9keSIsIm9rIiwiZXJyb3IiLCJjb25zb2xlIiwibWVzc2FnZSIsImFsZXJ0cyIsImFja25vd2xlZGdlQWxlcnRzUmVzcG9uc2UiLCJBQ0tOT1dMRURHRV9BTEVSVFMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFvQkE7Ozs7QUFFZSxNQUFNQSxZQUFOLENBQW1CO0FBR2hDQyxFQUFBQSxXQUFXLENBQUNDLFFBQUQsRUFBdUM7QUFBQTs7QUFBQSx1Q0FPdEMsT0FDVkMsUUFEVSxFQUVWQyxPQUZVLEVBR1ZDLFFBSFUsS0FJb0Y7QUFDOUYsVUFBSTtBQUNGLGNBQU07QUFBRUMsVUFBQUEsWUFBRjtBQUFnQkMsVUFBQUEsV0FBaEI7QUFBNkJDLFVBQUFBLFNBQTdCO0FBQXdDQyxVQUFBQTtBQUF4QyxZQUFpREwsT0FBTyxDQUFDTSxLQUEvRDtBQUNBLGNBQU1DLGFBQWEsR0FBRztBQUNwQkgsVUFBQUEsU0FEb0I7QUFFcEJDLFVBQUFBO0FBRm9CLFNBQXRCO0FBSUEsWUFBSUcsTUFBSjs7QUFFQSxZQUFJTCxXQUFKLEVBQWlCO0FBQ2ZLLFVBQUFBLE1BQU0sR0FBRyxFQUNQLEdBQUdELGFBREk7QUFFUEosWUFBQUE7QUFGTyxXQUFUO0FBSUQsU0FMRCxNQUtPLElBQUlELFlBQUosRUFBa0I7QUFDdkJNLFVBQUFBLE1BQU0sR0FBRyxFQUNQLEdBQUdELGFBREk7QUFFUEwsWUFBQUE7QUFGTyxXQUFUO0FBSUQsU0FMTSxNQUtBO0FBQ0wsZ0JBQU1PLEtBQUssQ0FBRSxzRUFBRixDQUFYO0FBQ0Q7O0FBRUQsY0FBTTtBQUFFQyxVQUFBQSxpQkFBaUIsRUFBRUM7QUFBckIsWUFBeUMsS0FBS2IsUUFBTCxDQUFjYyxRQUFkLENBQXVCWixPQUF2QixDQUEvQztBQUNBLGNBQU1hLGlCQUFvQyxHQUFHLE1BQU1GLGVBQWUsQ0FDaEVHLGlDQUFzQkMsVUFEMEMsRUFFaEVQLE1BRmdFLENBQWxFO0FBSUEsZUFBT1AsUUFBUSxDQUFDZSxNQUFULENBQWdCO0FBQ3JCQyxVQUFBQSxVQUFVLEVBQUUsR0FEUztBQUVyQkMsVUFBQUEsSUFBSSxFQUFFO0FBQ0pDLFlBQUFBLEVBQUUsRUFBRSxJQURBO0FBRUpsQixZQUFBQSxRQUFRLEVBQUVZO0FBRk47QUFGZSxTQUFoQixDQUFQO0FBT0QsT0FsQ0QsQ0FrQ0UsT0FBT08sS0FBUCxFQUFtQjtBQUNuQkMsUUFBQUEsT0FBTyxDQUFDRCxLQUFSLENBQWMsZ0RBQWQsRUFBZ0VBLEtBQWhFO0FBQ0EsZUFBT25CLFFBQVEsQ0FBQ2UsTUFBVCxDQUFnQjtBQUNyQkMsVUFBQUEsVUFBVSxFQUFFLEdBRFM7QUFFckJDLFVBQUFBLElBQUksRUFBRTtBQUNKQyxZQUFBQSxFQUFFLEVBQUUsS0FEQTtBQUVKQyxZQUFBQSxLQUFLLEVBQUVBLEtBQUssQ0FBQ0U7QUFGVDtBQUZlLFNBQWhCLENBQVA7QUFPRDtBQUNGLEtBeERpRDs7QUFBQSwrQ0E2RDlCLE9BQ2xCdkIsUUFEa0IsRUFFbEJDLE9BRmtCLEVBR2xCQyxRQUhrQixLQU1mO0FBQ0gsVUFBSTtBQUNGLGNBQU07QUFBRUUsVUFBQUE7QUFBRixZQUFrQkgsT0FBTyxDQUFDUSxNQUFoQztBQUNBLGNBQU07QUFBRWUsVUFBQUE7QUFBRixZQUFhdkIsT0FBTyxDQUFDa0IsSUFBM0I7QUFDQSxjQUFNQSxJQUFJLEdBQUc7QUFBRUssVUFBQUEsTUFBTSxFQUFFQTtBQUFWLFNBQWI7QUFDQSxjQUFNZixNQUErQixHQUFHO0FBQ3RDVSxVQUFBQSxJQURzQztBQUV0Q2YsVUFBQUE7QUFGc0MsU0FBeEM7QUFLQSxjQUFNO0FBQUVPLFVBQUFBLGlCQUFpQixFQUFFQztBQUFyQixZQUF5QyxLQUFLYixRQUFMLENBQWNjLFFBQWQsQ0FBdUJaLE9BQXZCLENBQS9DO0FBQ0EsY0FBTXdCLHlCQUFvRCxHQUFHLE1BQU1iLGVBQWUsQ0FDaEZHLGlDQUFzQlcsa0JBRDBELEVBRWhGakIsTUFGZ0YsQ0FBbEY7QUFJQSxlQUFPUCxRQUFRLENBQUNlLE1BQVQsQ0FBZ0I7QUFDckJDLFVBQUFBLFVBQVUsRUFBRSxHQURTO0FBRXJCQyxVQUFBQSxJQUFJLEVBQUU7QUFDSkMsWUFBQUEsRUFBRSxFQUFFLElBREE7QUFFSmxCLFlBQUFBLFFBQVEsRUFBRXVCO0FBRk47QUFGZSxTQUFoQixDQUFQO0FBT0QsT0FyQkQsQ0FxQkUsT0FBT0osS0FBUCxFQUFtQjtBQUNuQkMsUUFBQUEsT0FBTyxDQUFDRCxLQUFSLENBQWMsd0RBQWQsRUFBd0VBLEtBQXhFO0FBQ0EsZUFBT25CLFFBQVEsQ0FBQ2UsTUFBVCxDQUFnQjtBQUNyQkMsVUFBQUEsVUFBVSxFQUFFLEdBRFM7QUFFckJDLFVBQUFBLElBQUksRUFBRTtBQUNKQyxZQUFBQSxFQUFFLEVBQUUsS0FEQTtBQUVKQyxZQUFBQSxLQUFLLEVBQUVBLEtBQUssQ0FBQ0U7QUFGVDtBQUZlLFNBQWhCLENBQVA7QUFPRDtBQUNGLEtBbkdpRDs7QUFDaEQsU0FBS3hCLFFBQUwsR0FBZ0JBLFFBQWhCO0FBQ0Q7QUFFRDtBQUNGO0FBQ0E7OztBQVRrQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHtcbiAgSUxlZ2FjeUN1c3RvbUNsdXN0ZXJDbGllbnQsXG4gIE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnksXG4gIElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlLFxuICBSZXNwb25zZUVycm9yLFxuICBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG59IGZyb20gJ29wZW5zZWFyY2gtZGFzaGJvYXJkcy9zZXJ2ZXInO1xuaW1wb3J0IHtcbiAgQWNrbm93bGVkZ2VBbGVydHNQYXJhbXMsXG4gIEFja25vd2xlZGdlQWxlcnRzUmVzcG9uc2UsXG4gIEdldEFsZXJ0c1BhcmFtcyxcbiAgR2V0QWxlcnRzUmVzcG9uc2UsXG59IGZyb20gJy4uL21vZGVscy9pbnRlcmZhY2VzJztcbmltcG9ydCB7IFNlcnZlclJlc3BvbnNlIH0gZnJvbSAnLi4vbW9kZWxzL3R5cGVzJztcbmltcG9ydCB7IENMSUVOVF9BTEVSVFNfTUVUSE9EUyB9IGZyb20gJy4uL3V0aWxzL2NvbnN0YW50cyc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEFsZXJ0U2VydmljZSB7XG4gIG9zRHJpdmVyOiBJTGVnYWN5Q3VzdG9tQ2x1c3RlckNsaWVudDtcblxuICBjb25zdHJ1Y3Rvcihvc0RyaXZlcjogSUxlZ2FjeUN1c3RvbUNsdXN0ZXJDbGllbnQpIHtcbiAgICB0aGlzLm9zRHJpdmVyID0gb3NEcml2ZXI7XG4gIH1cblxuICAvKipcbiAgICogQ2FsbHMgYmFja2VuZCBHRVQgQWxlcnRzIEFQSS5cbiAgICovXG4gIGdldEFsZXJ0cyA9IGFzeW5jIChcbiAgICBfY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxuICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdDx7fSwgR2V0QWxlcnRzUGFyYW1zPixcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcbiAgKTogUHJvbWlzZTxJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxTZXJ2ZXJSZXNwb25zZTxHZXRBbGVydHNSZXNwb25zZT4gfCBSZXNwb25zZUVycm9yPj4gPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCB7IGRldGVjdG9yVHlwZSwgZGV0ZWN0b3JfaWQsIHNvcnRPcmRlciwgc2l6ZSB9ID0gcmVxdWVzdC5xdWVyeTtcbiAgICAgIGNvbnN0IGRlZmF1bHRQYXJhbXMgPSB7XG4gICAgICAgIHNvcnRPcmRlcixcbiAgICAgICAgc2l6ZSxcbiAgICAgIH07XG4gICAgICBsZXQgcGFyYW1zOiBHZXRBbGVydHNQYXJhbXM7XG5cbiAgICAgIGlmIChkZXRlY3Rvcl9pZCkge1xuICAgICAgICBwYXJhbXMgPSB7XG4gICAgICAgICAgLi4uZGVmYXVsdFBhcmFtcyxcbiAgICAgICAgICBkZXRlY3Rvcl9pZCxcbiAgICAgICAgfTtcbiAgICAgIH0gZWxzZSBpZiAoZGV0ZWN0b3JUeXBlKSB7XG4gICAgICAgIHBhcmFtcyA9IHtcbiAgICAgICAgICAuLi5kZWZhdWx0UGFyYW1zLFxuICAgICAgICAgIGRldGVjdG9yVHlwZSxcbiAgICAgICAgfTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHRocm93IEVycm9yKGBJbnZhbGlkIHJlcXVlc3QgcGFyYW1zOiBkZXRlY3RvcklkIG9yIGRldGVjdG9yVHlwZSBtdXN0IGJlIHNwZWNpZmllZGApO1xuICAgICAgfVxuXG4gICAgICBjb25zdCB7IGNhbGxBc0N1cnJlbnRVc2VyOiBjYWxsV2l0aFJlcXVlc3QgfSA9IHRoaXMub3NEcml2ZXIuYXNTY29wZWQocmVxdWVzdCk7XG4gICAgICBjb25zdCBnZXRBbGVydHNSZXNwb25zZTogR2V0QWxlcnRzUmVzcG9uc2UgPSBhd2FpdCBjYWxsV2l0aFJlcXVlc3QoXG4gICAgICAgIENMSUVOVF9BTEVSVFNfTUVUSE9EUy5HRVRfQUxFUlRTLFxuICAgICAgICBwYXJhbXNcbiAgICAgICk7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IHRydWUsXG4gICAgICAgICAgcmVzcG9uc2U6IGdldEFsZXJ0c1Jlc3BvbnNlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfSBjYXRjaCAoZXJyb3I6IGFueSkge1xuICAgICAgY29uc29sZS5lcnJvcignU2VjdXJpdHkgQW5hbHl0aWNzIC0gQWxlcnRTZXJ2aWNlIC0gZ2V0QWxlcnRzOicsIGVycm9yKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogZmFsc2UsXG4gICAgICAgICAgZXJyb3I6IGVycm9yLm1lc3NhZ2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH07XG5cbiAgLyoqXG4gICAqIENhbGxzIGJhY2tlbmQgUE9TVCBBY2tub3dsZWRnZSBBbGVydHMgQVBJLlxuICAgKi9cbiAgYWNrbm93bGVkZ2VBbGVydHMgPSBhc3luYyAoXG4gICAgX2NvbnRleHQ6IFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcbiAgICByZXF1ZXN0OiBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3Q8e30sIEFja25vd2xlZGdlQWxlcnRzUGFyYW1zPixcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcbiAgKTogUHJvbWlzZTxcbiAgICBJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxTZXJ2ZXJSZXNwb25zZTxBY2tub3dsZWRnZUFsZXJ0c1Jlc3BvbnNlPiB8IFJlc3BvbnNlRXJyb3I+XG4gID4gPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCB7IGRldGVjdG9yX2lkIH0gPSByZXF1ZXN0LnBhcmFtcyBhcyB7IGRldGVjdG9yX2lkOiBzdHJpbmcgfTtcbiAgICAgIGNvbnN0IHsgYWxlcnRzIH0gPSByZXF1ZXN0LmJvZHkgYXMgeyBhbGVydHM6IHN0cmluZ1tdIH07XG4gICAgICBjb25zdCBib2R5ID0geyBhbGVydHM6IGFsZXJ0cyB9O1xuICAgICAgY29uc3QgcGFyYW1zOiBBY2tub3dsZWRnZUFsZXJ0c1BhcmFtcyA9IHtcbiAgICAgICAgYm9keSxcbiAgICAgICAgZGV0ZWN0b3JfaWQsXG4gICAgICB9O1xuXG4gICAgICBjb25zdCB7IGNhbGxBc0N1cnJlbnRVc2VyOiBjYWxsV2l0aFJlcXVlc3QgfSA9IHRoaXMub3NEcml2ZXIuYXNTY29wZWQocmVxdWVzdCk7XG4gICAgICBjb25zdCBhY2tub3dsZWRnZUFsZXJ0c1Jlc3BvbnNlOiBBY2tub3dsZWRnZUFsZXJ0c1Jlc3BvbnNlID0gYXdhaXQgY2FsbFdpdGhSZXF1ZXN0KFxuICAgICAgICBDTElFTlRfQUxFUlRTX01FVEhPRFMuQUNLTk9XTEVER0VfQUxFUlRTLFxuICAgICAgICBwYXJhbXNcbiAgICAgICk7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IHRydWUsXG4gICAgICAgICAgcmVzcG9uc2U6IGFja25vd2xlZGdlQWxlcnRzUmVzcG9uc2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9IGNhdGNoIChlcnJvcjogYW55KSB7XG4gICAgICBjb25zb2xlLmVycm9yKCdTZWN1cml0eSBBbmFseXRpY3MgLSBBbGVydFNlcnZpY2UgLSBhY2tub3dsZWRnZUFsZXJ0czonLCBlcnJvcik7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IGZhbHNlLFxuICAgICAgICAgIGVycm9yOiBlcnJvci5tZXNzYWdlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfVxuICB9O1xufVxuIl19