/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.vectorhighlight.BaseFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.BreakIteratorBoundaryScanner;
import org.apache.lucene.search.vectorhighlight.CustomFieldQuery;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleBoundaryScanner;
import org.apache.lucene.search.vectorhighlight.SimpleFieldFragList;
import org.apache.lucene.search.vectorhighlight.SimpleFragListBuilder;
import org.apache.lucene.search.vectorhighlight.SingleFragListBuilder;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.text.Text;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.subphase.highlight.FieldHighlightContext;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.search.fetch.subphase.highlight.HighlightField;
import org.opensearch.search.fetch.subphase.highlight.HighlightUtils;
import org.opensearch.search.fetch.subphase.highlight.Highlighter;
import org.opensearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.opensearch.search.fetch.subphase.highlight.SimpleFragmentsBuilder;
import org.opensearch.search.fetch.subphase.highlight.SourceScoreOrderFragmentsBuilder;
import org.opensearch.search.fetch.subphase.highlight.SourceSimpleFragmentsBuilder;
import org.opensearch.search.lookup.SourceLookup;

public class FastVectorHighlighter
implements Highlighter {
    private static final BoundaryScanner DEFAULT_SIMPLE_BOUNDARY_SCANNER = new SimpleBoundaryScanner();
    private static final BoundaryScanner DEFAULT_SENTENCE_BOUNDARY_SCANNER = new BreakIteratorBoundaryScanner(BreakIterator.getSentenceInstance(Locale.ROOT));
    private static final BoundaryScanner DEFAULT_WORD_BOUNDARY_SCANNER = new BreakIteratorBoundaryScanner(BreakIterator.getWordInstance(Locale.ROOT));
    public static final Setting<Boolean> SETTING_TV_HIGHLIGHT_MULTI_VALUE = Setting.boolSetting("search.highlight.term_vector_multi_value", true, Setting.Property.NodeScope);
    private static final String CACHE_KEY = "highlight-fsv";
    private final Boolean termVectorMultiValue;

    public FastVectorHighlighter(Settings settings) {
        this.termVectorMultiValue = SETTING_TV_HIGHLIGHT_MULTI_VALUE.get(settings);
    }

    @Override
    public HighlightField highlight(FieldHighlightContext fieldContext) throws IOException {
        Encoder encoder;
        SearchHighlightContext.Field field = fieldContext.field;
        FetchSubPhase.HitContext hitContext = fieldContext.hitContext;
        MappedFieldType fieldType = fieldContext.fieldType;
        boolean forceSource = fieldContext.forceSource;
        if (!this.canHighlight(fieldType)) {
            throw new IllegalArgumentException("the field [" + fieldContext.fieldName + "] should be indexed with term vector with position offsets to be used with fast vector highlighter");
        }
        Encoder encoder2 = encoder = field.fieldOptions().encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
        if (!fieldContext.cache.containsKey(CACHE_KEY)) {
            fieldContext.cache.put(CACHE_KEY, new HighlighterEntry());
        }
        HighlighterEntry cache = (HighlighterEntry)fieldContext.cache.get(CACHE_KEY);
        FieldHighlightEntry entry = cache.fields.get(fieldType);
        if (entry == null) {
            Object fragListBuilder = field.fieldOptions().numberOfFragments() == 0 ? new SingleFragListBuilder() : (field.fieldOptions().fragmentOffset() == -1 ? new SimpleFragListBuilder() : new SimpleFragListBuilder(field.fieldOptions().fragmentOffset()));
            Function<SourceLookup, FragmentsBuilder> fragmentsBuilderSupplier = this.fragmentsBuilderSupplier(field, fieldType, forceSource);
            entry = new FieldHighlightEntry();
            if (field.fieldOptions().requireFieldMatch().booleanValue()) {
                entry.fieldMatchFieldQuery = new CustomFieldQuery(fieldContext.query, hitContext.topLevelReader(), true, field.fieldOptions().requireFieldMatch());
            } else {
                entry.noFieldMatchFieldQuery = new CustomFieldQuery(fieldContext.query, hitContext.topLevelReader(), true, field.fieldOptions().requireFieldMatch());
            }
            entry.fragListBuilder = fragListBuilder;
            entry.fragmentsBuilderSupplier = fragmentsBuilderSupplier;
            if (cache.fvh == null) {
                cache.fvh = new org.apache.lucene.search.vectorhighlight.FastVectorHighlighter();
            }
            CustomFieldQuery.highlightFilters.set(field.fieldOptions().highlightFilter());
            cache.fields.put(fieldType, entry);
        }
        FieldQuery fieldQuery = field.fieldOptions().requireFieldMatch() != false ? entry.fieldMatchFieldQuery : entry.noFieldMatchFieldQuery;
        cache.fvh.setPhraseLimit(field.fieldOptions().phraseLimit());
        FragmentsBuilder fragmentsBuilder = entry.fragmentsBuilderSupplier.apply(hitContext.sourceLookup());
        int numberOfFragments = field.fieldOptions().numberOfFragments() == 0 ? Integer.MAX_VALUE : field.fieldOptions().numberOfFragments();
        int fragmentCharSize = field.fieldOptions().numberOfFragments() == 0 ? Integer.MAX_VALUE : field.fieldOptions().fragmentCharSize();
        Object[] fragments = field.fieldOptions().matchedFields() != null && !field.fieldOptions().matchedFields().isEmpty() ? cache.fvh.getBestFragments(fieldQuery, (IndexReader)hitContext.reader(), hitContext.docId(), fieldType.name(), field.fieldOptions().matchedFields(), fragmentCharSize, numberOfFragments, entry.fragListBuilder, fragmentsBuilder, field.fieldOptions().preTags(), field.fieldOptions().postTags(), encoder) : cache.fvh.getBestFragments(fieldQuery, (IndexReader)hitContext.reader(), hitContext.docId(), fieldType.name(), fragmentCharSize, numberOfFragments, entry.fragListBuilder, fragmentsBuilder, field.fieldOptions().preTags(), field.fieldOptions().postTags(), encoder);
        if (!CollectionUtils.isEmpty((Object[])fragments)) {
            return new HighlightField(fieldContext.fieldName, Text.convertFromStringArray((String[])fragments));
        }
        int noMatchSize = fieldContext.field.fieldOptions().noMatchSize();
        if (noMatchSize > 0) {
            SimpleFieldFragList fieldFragList = new SimpleFieldFragList(-1);
            fieldFragList.add(0, noMatchSize, Collections.emptyList());
            fragments = fragmentsBuilder.createFragments((IndexReader)hitContext.reader(), hitContext.docId(), fieldType.name(), (FieldFragList)fieldFragList, 1, field.fieldOptions().preTags(), field.fieldOptions().postTags(), encoder);
            if (!CollectionUtils.isEmpty((Object[])fragments)) {
                return new HighlightField(fieldContext.fieldName, Text.convertFromStringArray((String[])fragments));
            }
        }
        return null;
    }

    private Function<SourceLookup, FragmentsBuilder> fragmentsBuilderSupplier(SearchHighlightContext.Field field, MappedFieldType fieldType, boolean forceSource) {
        BoundaryScanner boundaryScanner = FastVectorHighlighter.getBoundaryScanner(field);
        SearchHighlightContext.FieldOptions options = field.fieldOptions();
        Function<SourceLookup, BaseFragmentsBuilder> supplier = !forceSource && fieldType.isStored() ? (options.numberOfFragments() != 0 && options.scoreOrdered().booleanValue() ? ignored -> new ScoreOrderFragmentsBuilder(options.preTags(), options.postTags(), boundaryScanner) : ignored -> new SimpleFragmentsBuilder(fieldType, options.preTags(), options.postTags(), boundaryScanner)) : (options.numberOfFragments() != 0 && options.scoreOrdered() != false ? lookup -> new SourceScoreOrderFragmentsBuilder(fieldType, (SourceLookup)lookup, options.preTags(), options.postTags(), boundaryScanner) : lookup -> new SourceSimpleFragmentsBuilder(fieldType, (SourceLookup)lookup, options.preTags(), options.postTags(), boundaryScanner));
        return lookup -> {
            BaseFragmentsBuilder builder = (BaseFragmentsBuilder)supplier.apply((SourceLookup)lookup);
            builder.setDiscreteMultiValueHighlighting(this.termVectorMultiValue.booleanValue());
            return builder;
        };
    }

    @Override
    public boolean canHighlight(MappedFieldType ft) {
        return ft.getTextSearchInfo().termVectors() == TextSearchInfo.TermVector.OFFSETS;
    }

    private static BoundaryScanner getBoundaryScanner(SearchHighlightContext.Field field) {
        SearchHighlightContext.FieldOptions fieldOptions = field.fieldOptions();
        Locale boundaryScannerLocale = fieldOptions.boundaryScannerLocale() != null ? fieldOptions.boundaryScannerLocale() : Locale.ROOT;
        HighlightBuilder.BoundaryScannerType type = fieldOptions.boundaryScannerType() != null ? fieldOptions.boundaryScannerType() : HighlightBuilder.BoundaryScannerType.CHARS;
        switch (type) {
            case SENTENCE: {
                if (boundaryScannerLocale != null) {
                    return new BreakIteratorBoundaryScanner(BreakIterator.getSentenceInstance(boundaryScannerLocale));
                }
                return DEFAULT_SENTENCE_BOUNDARY_SCANNER;
            }
            case WORD: {
                if (boundaryScannerLocale != null) {
                    return new BreakIteratorBoundaryScanner(BreakIterator.getWordInstance(boundaryScannerLocale));
                }
                return DEFAULT_WORD_BOUNDARY_SCANNER;
            }
            case CHARS: {
                if (fieldOptions.boundaryMaxScan() != 20 || fieldOptions.boundaryChars() != SimpleBoundaryScanner.DEFAULT_BOUNDARY_CHARS) {
                    return new SimpleBoundaryScanner(fieldOptions.boundaryMaxScan(), fieldOptions.boundaryChars());
                }
                return DEFAULT_SIMPLE_BOUNDARY_SCANNER;
            }
        }
        throw new IllegalArgumentException("Invalid boundary scanner type: " + type.toString());
    }

    private static class HighlighterEntry {
        public org.apache.lucene.search.vectorhighlight.FastVectorHighlighter fvh;
        public Map<MappedFieldType, FieldHighlightEntry> fields = new HashMap<MappedFieldType, FieldHighlightEntry>();

        private HighlighterEntry() {
        }
    }

    private static class FieldHighlightEntry {
        public FragListBuilder fragListBuilder;
        public Function<SourceLookup, FragmentsBuilder> fragmentsBuilderSupplier;
        public FieldQuery noFieldMatchFieldQuery;
        public FieldQuery fieldMatchFieldQuery;

        private FieldHighlightEntry() {
        }
    }
}

