/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.repositories.RepositoryStatsSnapshot;

public final class RepositoriesStatsArchive {
    private static final Logger logger = LogManager.getLogger(RepositoriesStatsArchive.class);
    private final TimeValue retentionPeriod;
    private final int maxCapacity;
    private final LongSupplier relativeTimeSupplier;
    private final Deque<ArchiveEntry> archive = new ArrayDeque<ArchiveEntry>();

    public RepositoriesStatsArchive(TimeValue retentionPeriod, int maxCapacity, LongSupplier relativeTimeSupplier) {
        this.retentionPeriod = retentionPeriod;
        this.maxCapacity = maxCapacity;
        this.relativeTimeSupplier = relativeTimeSupplier;
    }

    synchronized boolean archive(RepositoryStatsSnapshot repositoryStats) {
        assert (!this.containsRepositoryStats(repositoryStats)) : "A repository with ephemeral id " + repositoryStats.getRepositoryInfo().ephemeralId + " is already archived";
        assert (repositoryStats.isArchived());
        this.evict();
        if (this.archive.size() >= this.maxCapacity) {
            return false;
        }
        return this.archive.add(new ArchiveEntry(repositoryStats, this.relativeTimeSupplier.getAsLong()));
    }

    synchronized List<RepositoryStatsSnapshot> getArchivedStats() {
        this.evict();
        return this.archive.stream().map(e -> e.repositoryStatsSnapshot).collect(Collectors.toList());
    }

    synchronized List<RepositoryStatsSnapshot> clear(long maxVersionToClear) {
        ArrayList<RepositoryStatsSnapshot> clearedStats = new ArrayList<RepositoryStatsSnapshot>();
        Iterator<ArchiveEntry> iterator = this.archive.iterator();
        while (iterator.hasNext()) {
            RepositoryStatsSnapshot statsSnapshot = iterator.next().repositoryStatsSnapshot;
            if (statsSnapshot.getClusterVersion() > maxVersionToClear) continue;
            clearedStats.add(statsSnapshot);
            iterator.remove();
        }
        logger.debug("RepositoriesStatsArchive have been cleared. Removed stats: [{}]", clearedStats);
        return clearedStats;
    }

    private void evict() {
        ArchiveEntry entry;
        while ((entry = this.archive.peek()) != null && entry.ageInMillis(this.relativeTimeSupplier) >= this.retentionPeriod.getMillis()) {
            ArchiveEntry removedEntry = this.archive.poll();
            logger.debug("Evicting repository stats [{}]", (Object)removedEntry.repositoryStatsSnapshot);
        }
    }

    private boolean containsRepositoryStats(RepositoryStatsSnapshot repositoryStats) {
        return this.archive.stream().anyMatch(entry -> entry.repositoryStatsSnapshot.getRepositoryInfo().ephemeralId.equals(repositoryStats.getRepositoryInfo().ephemeralId));
    }

    private static class ArchiveEntry {
        private final RepositoryStatsSnapshot repositoryStatsSnapshot;
        private final long createdAtMillis;

        private ArchiveEntry(RepositoryStatsSnapshot repositoryStatsSnapshot, long createdAtMillis) {
            this.repositoryStatsSnapshot = repositoryStatsSnapshot;
            this.createdAtMillis = createdAtMillis;
        }

        private long ageInMillis(LongSupplier relativeTimeInMillis) {
            return Math.max(0L, relativeTimeInMillis.getAsLong() - this.createdAtMillis);
        }
    }
}

