/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.health;

import org.opensearch.action.admin.cluster.health.ClusterHealthAction;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeReadOperationRequestBuilder;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.common.Priority;
import org.opensearch.common.unit.TimeValue;

public class ClusterHealthRequestBuilder
extends ClusterManagerNodeReadOperationRequestBuilder<ClusterHealthRequest, ClusterHealthResponse, ClusterHealthRequestBuilder> {
    public ClusterHealthRequestBuilder(OpenSearchClient client, ClusterHealthAction action) {
        super(client, action, new ClusterHealthRequest());
    }

    public ClusterHealthRequestBuilder setIndices(String ... indices) {
        ((ClusterHealthRequest)this.request).indices(indices);
        return this;
    }

    public ClusterHealthRequestBuilder setIndicesOptions(IndicesOptions indicesOptions) {
        ((ClusterHealthRequest)this.request).indicesOptions(indicesOptions);
        return this;
    }

    public ClusterHealthRequestBuilder setTimeout(TimeValue timeout) {
        ((ClusterHealthRequest)this.request).timeout(timeout);
        return this;
    }

    public ClusterHealthRequestBuilder setTimeout(String timeout) {
        ((ClusterHealthRequest)this.request).timeout(timeout);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForStatus(ClusterHealthStatus waitForStatus) {
        ((ClusterHealthRequest)this.request).waitForStatus(waitForStatus);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForGreenStatus() {
        ((ClusterHealthRequest)this.request).waitForGreenStatus();
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForYellowStatus() {
        ((ClusterHealthRequest)this.request).waitForYellowStatus();
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForNoRelocatingShards(boolean waitForRelocatingShards) {
        ((ClusterHealthRequest)this.request).waitForNoRelocatingShards(waitForRelocatingShards);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForNoInitializingShards(boolean waitForNoInitializingShards) {
        ((ClusterHealthRequest)this.request).waitForNoInitializingShards(waitForNoInitializingShards);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        if (waitForActiveShards.equals(ActiveShardCount.DEFAULT)) {
            ((ClusterHealthRequest)this.request).waitForActiveShards(ActiveShardCount.NONE);
        } else {
            ((ClusterHealthRequest)this.request).waitForActiveShards(waitForActiveShards);
        }
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        ((ClusterHealthRequest)this.request).waitForActiveShards(waitForActiveShards);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForNodes(String waitForNodes) {
        ((ClusterHealthRequest)this.request).waitForNodes(waitForNodes);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForEvents(Priority waitForEvents) {
        ((ClusterHealthRequest)this.request).waitForEvents(waitForEvents);
        return this;
    }

    public ClusterHealthRequestBuilder setAwarenessAttribute(String awarenessAttribute) {
        ((ClusterHealthRequest)this.request).setAwarenessAttribute(awarenessAttribute);
        return this;
    }

    public ClusterHealthRequestBuilder setLevel(String level) {
        ((ClusterHealthRequest)this.request).setLevel(level);
        return this;
    }

    public final ClusterHealthRequestBuilder setEnsureNodeWeighedIn(boolean ensureNodeCommissioned) {
        ((ClusterHealthRequest)this.request).ensureNodeWeighedIn(ensureNodeCommissioned);
        return this;
    }
}

