/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import java.util.Collection;
import java.util.Set;
import org.opensearch.ad.Name;

public enum DetectorProfileName implements Name
{
    STATE("state"),
    ERROR("error"),
    COORDINATING_NODE("coordinating_node"),
    SHINGLE_SIZE("shingle_size"),
    TOTAL_SIZE_IN_BYTES("total_size_in_bytes"),
    MODELS("models"),
    INIT_PROGRESS("init_progress"),
    TOTAL_ENTITIES("total_entities"),
    ACTIVE_ENTITIES("active_entities"),
    AD_TASK("ad_task");

    private String name;

    private DetectorProfileName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static DetectorProfileName getName(String name) {
        switch (name) {
            case "state": {
                return STATE;
            }
            case "error": {
                return ERROR;
            }
            case "coordinating_node": {
                return COORDINATING_NODE;
            }
            case "shingle_size": {
                return SHINGLE_SIZE;
            }
            case "total_size_in_bytes": {
                return TOTAL_SIZE_IN_BYTES;
            }
            case "models": {
                return MODELS;
            }
            case "init_progress": {
                return INIT_PROGRESS;
            }
            case "total_entities": {
                return TOTAL_ENTITIES;
            }
            case "active_entities": {
                return ACTIVE_ENTITIES;
            }
            case "ad_task": {
                return AD_TASK;
            }
        }
        throw new IllegalArgumentException("Unsupported profile types");
    }

    public static Set<DetectorProfileName> getNames(Collection<String> names) {
        return Name.getNameFromCollection(names, DetectorProfileName::getName);
    }
}

