/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.opensearch.ad.ExpiringState;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyDetectorJob;

public class NodeState
implements ExpiringState {
    private String detectorId;
    private AnomalyDetector detectorDef;
    private int partitonNumber;
    private Instant lastAccessTime;
    private Optional<String> lastDetectionError;
    private Optional<Exception> exception;
    private boolean checkPointExists;
    private final Clock clock;
    private boolean coldStartRunning;
    private AnomalyDetectorJob detectorJob;

    public NodeState(String detectorId, Clock clock) {
        this.detectorId = detectorId;
        this.detectorDef = null;
        this.partitonNumber = -1;
        this.lastAccessTime = clock.instant();
        this.lastDetectionError = Optional.empty();
        this.exception = Optional.empty();
        this.checkPointExists = false;
        this.clock = clock;
        this.coldStartRunning = false;
        this.detectorJob = null;
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public AnomalyDetector getDetectorDef() {
        this.refreshLastUpdateTime();
        return this.detectorDef;
    }

    public void setDetectorDef(AnomalyDetector detectorDef) {
        this.detectorDef = detectorDef;
        this.refreshLastUpdateTime();
    }

    public int getPartitonNumber() {
        this.refreshLastUpdateTime();
        return this.partitonNumber;
    }

    public void setPartitonNumber(int partitonNumber) {
        this.partitonNumber = partitonNumber;
        this.refreshLastUpdateTime();
    }

    public boolean doesCheckpointExists() {
        this.refreshLastUpdateTime();
        return this.checkPointExists;
    }

    public void setCheckpointExists(boolean checkpointExists) {
        this.refreshLastUpdateTime();
        this.checkPointExists = checkpointExists;
    }

    public Optional<String> getLastDetectionError() {
        this.refreshLastUpdateTime();
        return this.lastDetectionError;
    }

    public void setLastDetectionError(String lastError) {
        this.lastDetectionError = Optional.ofNullable(lastError);
        this.refreshLastUpdateTime();
    }

    public Optional<Exception> getException() {
        this.refreshLastUpdateTime();
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = Optional.ofNullable(exception);
        this.refreshLastUpdateTime();
    }

    public boolean isColdStartRunning() {
        this.refreshLastUpdateTime();
        return this.coldStartRunning;
    }

    public void setColdStartRunning(boolean coldStartRunning) {
        this.coldStartRunning = coldStartRunning;
        this.refreshLastUpdateTime();
    }

    public AnomalyDetectorJob getDetectorJob() {
        this.refreshLastUpdateTime();
        return this.detectorJob;
    }

    public void setDetectorJob(AnomalyDetectorJob detectorJob) {
        this.detectorJob = detectorJob;
        this.refreshLastUpdateTime();
    }

    private void refreshLastUpdateTime() {
        this.lastAccessTime = this.clock.instant();
    }

    @Override
    public boolean expired(Duration stateTtl) {
        return this.expired(this.lastAccessTime, stateTtl, this.clock.instant());
    }
}

