/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.stats;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.stats.ActionName;
import org.opensearch.ml.stats.MLActionLevelStat;
import org.opensearch.ml.stats.MLClusterLevelStat;
import org.opensearch.ml.stats.MLNodeLevelStat;
import org.opensearch.ml.stats.MLStatLevel;
import org.opensearch.ml.utils.MLNodeUtils;

public class MLStatsInput
implements ToXContentObject,
Writeable {
    public static final String TARGET_STAT_LEVEL = "target_stat_levels";
    public static final String CLUSTER_LEVEL_STATS = "cluster_level_stats";
    public static final String NODE_LEVEL_STATS = "node_level_stats";
    public static final String ACTION_LEVEL_STATS = "action_level_stats";
    public static final String NODE_IDS = "node_ids";
    public static final String ALGORITHMS = "algorithms";
    public static final String ACTIONS = "actions";
    private EnumSet<MLStatLevel> targetStatLevels;
    private EnumSet<MLClusterLevelStat> clusterLevelStats;
    private EnumSet<MLNodeLevelStat> nodeLevelStats;
    private EnumSet<MLActionLevelStat> actionLevelStats;
    private Set<String> nodeIds;
    private EnumSet<FunctionName> algorithms;
    private EnumSet<ActionName> actions;

    public MLStatsInput(EnumSet<MLStatLevel> targetStatLevels, EnumSet<MLClusterLevelStat> clusterLevelStats, EnumSet<MLNodeLevelStat> nodeLevelStats, EnumSet<MLActionLevelStat> actionLevelStats, Set<String> nodeIds, EnumSet<FunctionName> algorithms, EnumSet<ActionName> actions) {
        this.targetStatLevels = targetStatLevels;
        this.clusterLevelStats = clusterLevelStats;
        this.nodeLevelStats = nodeLevelStats;
        this.actionLevelStats = actionLevelStats;
        this.nodeIds = nodeIds;
        this.algorithms = algorithms;
        this.actions = actions;
    }

    public MLStatsInput() {
        this.targetStatLevels = EnumSet.noneOf(MLStatLevel.class);
        this.clusterLevelStats = EnumSet.noneOf(MLClusterLevelStat.class);
        this.nodeLevelStats = EnumSet.noneOf(MLNodeLevelStat.class);
        this.actionLevelStats = EnumSet.noneOf(MLActionLevelStat.class);
        this.nodeIds = new HashSet<String>();
        this.algorithms = EnumSet.noneOf(FunctionName.class);
        this.actions = EnumSet.noneOf(ActionName.class);
    }

    public MLStatsInput(StreamInput input) throws IOException {
        this.targetStatLevels = input.readBoolean() ? input.readEnumSet(MLStatLevel.class) : EnumSet.noneOf(MLStatLevel.class);
        this.clusterLevelStats = input.readBoolean() ? input.readEnumSet(MLClusterLevelStat.class) : EnumSet.noneOf(MLClusterLevelStat.class);
        this.nodeLevelStats = input.readBoolean() ? input.readEnumSet(MLNodeLevelStat.class) : EnumSet.noneOf(MLNodeLevelStat.class);
        this.actionLevelStats = input.readBoolean() ? input.readEnumSet(MLActionLevelStat.class) : EnumSet.noneOf(MLActionLevelStat.class);
        this.nodeIds = input.readBoolean() ? new HashSet(input.readStringList()) : new HashSet();
        this.algorithms = input.readBoolean() ? input.readEnumSet(FunctionName.class) : EnumSet.noneOf(FunctionName.class);
        this.actions = input.readBoolean() ? input.readEnumSet(ActionName.class) : EnumSet.noneOf(ActionName.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.writeEnumSet(out, this.targetStatLevels);
        this.writeEnumSet(out, this.clusterLevelStats);
        this.writeEnumSet(out, this.nodeLevelStats);
        this.writeEnumSet(out, this.actionLevelStats);
        out.writeOptionalStringCollection(this.nodeIds);
        this.writeEnumSet(out, this.algorithms);
        this.writeEnumSet(out, this.actions);
    }

    private void writeEnumSet(StreamOutput out, EnumSet<?> set) throws IOException {
        if (set != null && set.size() > 0) {
            out.writeBoolean(true);
            out.writeEnumSet(set);
        } else {
            out.writeBoolean(false);
        }
    }

    public static MLStatsInput parse(XContentParser parser) throws IOException {
        EnumSet<MLStatLevel> targetStatLevels = EnumSet.noneOf(MLStatLevel.class);
        EnumSet<MLClusterLevelStat> clusterLevelStats = EnumSet.noneOf(MLClusterLevelStat.class);
        EnumSet<MLNodeLevelStat> nodeLevelStats = EnumSet.noneOf(MLNodeLevelStat.class);
        EnumSet<MLActionLevelStat> actionLevelStats = EnumSet.noneOf(MLActionLevelStat.class);
        HashSet<String> nodeIds = new HashSet<String>();
        EnumSet<FunctionName> algorithms = EnumSet.noneOf(FunctionName.class);
        EnumSet<ActionName> actions = EnumSet.noneOf(ActionName.class);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "target_stat_levels": {
                    MLNodeUtils.parseField(parser, targetStatLevels, input -> MLStatLevel.from(input.toUpperCase(Locale.ROOT)), MLStatLevel.class);
                    continue block18;
                }
                case "cluster_level_stats": {
                    MLNodeUtils.parseField(parser, clusterLevelStats, input -> MLClusterLevelStat.from(input.toUpperCase(Locale.ROOT)), MLClusterLevelStat.class);
                    continue block18;
                }
                case "node_level_stats": {
                    MLNodeUtils.parseField(parser, nodeLevelStats, input -> MLNodeLevelStat.from(input.toUpperCase(Locale.ROOT)), MLNodeLevelStat.class);
                    continue block18;
                }
                case "action_level_stats": {
                    MLNodeUtils.parseField(parser, actionLevelStats, input -> MLActionLevelStat.from(input.toUpperCase(Locale.ROOT)), MLActionLevelStat.class);
                    continue block18;
                }
                case "node_ids": {
                    MLNodeUtils.parseArrayField(parser, nodeIds);
                    continue block18;
                }
                case "algorithms": {
                    MLNodeUtils.parseField(parser, algorithms, input -> FunctionName.from((String)input.toUpperCase(Locale.ROOT)), FunctionName.class);
                    continue block18;
                }
                case "actions": {
                    MLNodeUtils.parseField(parser, actions, input -> ActionName.from(input.toUpperCase(Locale.ROOT)), ActionName.class);
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return MLStatsInput.builder().targetStatLevels(targetStatLevels).clusterLevelStats(clusterLevelStats).nodeLevelStats(nodeLevelStats).actionLevelStats(actionLevelStats).nodeIds(nodeIds).algorithms(algorithms).actions(actions).build();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.targetStatLevels != null) {
            builder.field(TARGET_STAT_LEVEL, this.targetStatLevels);
        }
        if (this.clusterLevelStats != null) {
            builder.field(CLUSTER_LEVEL_STATS, this.clusterLevelStats);
        }
        if (this.nodeLevelStats != null) {
            builder.field(NODE_LEVEL_STATS, this.nodeLevelStats);
        }
        if (this.actionLevelStats != null) {
            builder.field(ACTION_LEVEL_STATS, this.actionLevelStats);
        }
        if (this.nodeIds != null) {
            builder.field(NODE_IDS, this.nodeIds);
        }
        if (this.algorithms != null) {
            builder.field(ALGORITHMS, this.algorithms);
        }
        if (this.actions != null) {
            builder.field(ACTIONS, this.actions);
        }
        builder.endObject();
        return builder;
    }

    public boolean retrieveAllClusterLevelStats() {
        return this.clusterLevelStats == null || this.clusterLevelStats.size() == 0;
    }

    public boolean retrieveAllNodeLevelStats() {
        return this.nodeLevelStats == null || this.nodeLevelStats.size() == 0;
    }

    public boolean retrieveAllActionLevelStats() {
        return this.actionLevelStats == null || this.actionLevelStats.size() == 0;
    }

    public boolean retrieveStatsOnAllNodes() {
        return this.nodeIds == null || this.nodeIds.size() == 0;
    }

    public boolean retrieveStatsForAllAlgos() {
        return this.algorithms == null || this.algorithms.size() == 0;
    }

    public boolean retrieveStatsForAlgo(FunctionName algoName) {
        return this.retrieveStatsForAllAlgos() || this.algorithms.contains(algoName);
    }

    public boolean retrieveStatsForAction(ActionName actionName) {
        return this.retrieveStatsForAllActions() || this.actions.contains((Object)actionName);
    }

    public boolean retrieveStatsForAllActions() {
        return this.actions == null || this.actions.size() == 0;
    }

    public boolean retrieveStat(Enum<?> key) {
        if (key instanceof MLClusterLevelStat) {
            return this.retrieveAllClusterLevelStats() || this.clusterLevelStats.contains(key);
        }
        if (key instanceof MLNodeLevelStat) {
            return this.retrieveAllNodeLevelStats() || this.nodeLevelStats.contains(key);
        }
        if (key instanceof MLActionLevelStat) {
            return this.retrieveAllActionLevelStats() || this.actionLevelStats.contains(key);
        }
        return false;
    }

    public boolean onlyRetrieveClusterLevelStats() {
        if (this.targetStatLevels == null || this.targetStatLevels.size() == 0) {
            return false;
        }
        return !this.targetStatLevels.contains((Object)MLStatLevel.NODE) && !this.targetStatLevels.contains((Object)MLStatLevel.ALGORITHM) && !this.targetStatLevels.contains((Object)MLStatLevel.ACTION);
    }

    public boolean includeAlgoStats() {
        return this.targetStatLevels.contains((Object)MLStatLevel.ALGORITHM) || this.targetStatLevels.contains((Object)MLStatLevel.ACTION);
    }

    @Generated
    public static MLStatsInputBuilder builder() {
        return new MLStatsInputBuilder();
    }

    @Generated
    public EnumSet<MLStatLevel> getTargetStatLevels() {
        return this.targetStatLevels;
    }

    @Generated
    public EnumSet<MLClusterLevelStat> getClusterLevelStats() {
        return this.clusterLevelStats;
    }

    @Generated
    public EnumSet<MLNodeLevelStat> getNodeLevelStats() {
        return this.nodeLevelStats;
    }

    @Generated
    public EnumSet<MLActionLevelStat> getActionLevelStats() {
        return this.actionLevelStats;
    }

    @Generated
    public Set<String> getNodeIds() {
        return this.nodeIds;
    }

    @Generated
    public EnumSet<FunctionName> getAlgorithms() {
        return this.algorithms;
    }

    @Generated
    public EnumSet<ActionName> getActions() {
        return this.actions;
    }

    @Generated
    public static class MLStatsInputBuilder {
        @Generated
        private EnumSet<MLStatLevel> targetStatLevels;
        @Generated
        private EnumSet<MLClusterLevelStat> clusterLevelStats;
        @Generated
        private EnumSet<MLNodeLevelStat> nodeLevelStats;
        @Generated
        private EnumSet<MLActionLevelStat> actionLevelStats;
        @Generated
        private Set<String> nodeIds;
        @Generated
        private EnumSet<FunctionName> algorithms;
        @Generated
        private EnumSet<ActionName> actions;

        @Generated
        MLStatsInputBuilder() {
        }

        @Generated
        public MLStatsInputBuilder targetStatLevels(EnumSet<MLStatLevel> targetStatLevels) {
            this.targetStatLevels = targetStatLevels;
            return this;
        }

        @Generated
        public MLStatsInputBuilder clusterLevelStats(EnumSet<MLClusterLevelStat> clusterLevelStats) {
            this.clusterLevelStats = clusterLevelStats;
            return this;
        }

        @Generated
        public MLStatsInputBuilder nodeLevelStats(EnumSet<MLNodeLevelStat> nodeLevelStats) {
            this.nodeLevelStats = nodeLevelStats;
            return this;
        }

        @Generated
        public MLStatsInputBuilder actionLevelStats(EnumSet<MLActionLevelStat> actionLevelStats) {
            this.actionLevelStats = actionLevelStats;
            return this;
        }

        @Generated
        public MLStatsInputBuilder nodeIds(Set<String> nodeIds) {
            this.nodeIds = nodeIds;
            return this;
        }

        @Generated
        public MLStatsInputBuilder algorithms(EnumSet<FunctionName> algorithms) {
            this.algorithms = algorithms;
            return this;
        }

        @Generated
        public MLStatsInputBuilder actions(EnumSet<ActionName> actions) {
            this.actions = actions;
            return this;
        }

        @Generated
        public MLStatsInput build() {
            return new MLStatsInput(this.targetStatLevels, this.clusterLevelStats, this.nodeLevelStats, this.actionLevelStats, this.nodeIds, this.algorithms, this.actions);
        }

        @Generated
        public String toString() {
            return "MLStatsInput.MLStatsInputBuilder(targetStatLevels=" + this.targetStatLevels + ", clusterLevelStats=" + this.clusterLevelStats + ", nodeLevelStats=" + this.nodeLevelStats + ", actionLevelStats=" + this.actionLevelStats + ", nodeIds=" + this.nodeIds + ", algorithms=" + this.algorithms + ", actions=" + this.actions + ")";
        }
    }
}

