/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opensearch.performanceanalyzer.collections.TimeExpiringSet;
import org.opensearch.performanceanalyzer.decisionmaker.actions.Action;
import org.opensearch.performanceanalyzer.decisionmaker.actions.FlipFlopDetector;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ImpactVector;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class TimedFlipFlopDetector
implements FlipFlopDetector {
    private Map<NodeKey, TimeExpiringSet<ImpactVector>> flipFlopMap = new HashMap<NodeKey, TimeExpiringSet<ImpactVector>>();
    private long expiryDuration;
    private TimeUnit expiryUnit;

    public TimedFlipFlopDetector(long duration, TimeUnit unit) {
        this.expiryDuration = duration;
        this.expiryUnit = unit;
    }

    protected boolean isFlipFlopImpact(ImpactVector.Impact prev, ImpactVector.Impact curr) {
        return prev.equals((Object)ImpactVector.Impact.DECREASES_PRESSURE) && curr.equals((Object)ImpactVector.Impact.INCREASES_PRESSURE);
    }

    protected boolean isFlipFlopVector(ImpactVector prev, ImpactVector curr) {
        Map<ImpactVector.Dimension, ImpactVector.Impact> currentImpact = curr.getImpact();
        for (Map.Entry<ImpactVector.Dimension, ImpactVector.Impact> impactEntry : prev.getImpact().entrySet()) {
            ImpactVector.Dimension dim = impactEntry.getKey();
            ImpactVector.Impact vImpact = currentImpact.get((Object)dim);
            if (!this.isFlipFlopImpact(impactEntry.getValue(), vImpact)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void recordAction(Action action) {
        for (Map.Entry<NodeKey, ImpactVector> entry : action.impact().entrySet()) {
            this.flipFlopMap.compute(entry.getKey(), (k, v) -> {
                if (v == null) {
                    v = new TimeExpiringSet<ImpactVector>(this.expiryDuration, this.expiryUnit);
                }
                v.add((ImpactVector)entry.getValue());
                return v;
            });
        }
    }

    @Override
    public boolean isFlipFlop(Action action) {
        for (Map.Entry<NodeKey, ImpactVector> entry : action.impact().entrySet()) {
            TimeExpiringSet<ImpactVector> previousImpacts = this.flipFlopMap.get(entry.getKey());
            if (previousImpacts == null) continue;
            for (ImpactVector impactVector : previousImpacts) {
                if (!this.isFlipFlopVector(impactVector, entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

