/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.FillMaskBatchTranslator;
import ai.djl.modality.Classifications;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class FillMaskTranslator
implements Translator<String, Classifications> {
    private HuggingFaceTokenizer tokenizer;
    private String maskToken;
    private long maskTokenId;
    private int topK;
    private Batchifier batchifier;

    FillMaskTranslator(HuggingFaceTokenizer tokenizer, String maskToken, int topK, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.maskToken = maskToken;
        this.topK = topK;
        this.batchifier = batchifier;
        Encoding encoding = tokenizer.encode(maskToken, false);
        this.maskTokenId = encoding.getIds()[0];
    }

    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    public NDList processInput(TranslatorContext ctx, String input) throws TranslateException {
        Encoding encoding = this.tokenizer.encode(input);
        long[] indices = encoding.getIds();
        int maskIndex = FillMaskTranslator.getMaskIndex(indices, this.maskToken, this.maskTokenId);
        ctx.setAttachment("maskIndex", (Object)maskIndex);
        return encoding.toNDList(ctx.getNDManager(), false);
    }

    public Classifications processOutput(TranslatorContext ctx, NDList list) {
        int maskIndex = (Integer)ctx.getAttachment("maskIndex");
        return FillMaskTranslator.toClassifications(this.tokenizer, list, maskIndex, this.topK);
    }

    public FillMaskBatchTranslator toBatchTranslator(Batchifier batchifier) {
        this.tokenizer.enableBatch();
        return new FillMaskBatchTranslator(this.tokenizer, this.maskToken, this.topK, batchifier);
    }

    static int getMaskIndex(long[] indices, String maskToken, long maskTokenId) throws TranslateException {
        int maskIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] != maskTokenId) continue;
            if (maskIndex != -1) {
                throw new TranslateException("Only one mask supported.");
            }
            maskIndex = i;
        }
        if (maskIndex == -1) {
            throw new TranslateException("Mask token " + maskToken + " not found.");
        }
        return maskIndex;
    }

    static Classifications toClassifications(HuggingFaceTokenizer tokenizer, NDList output, int maskIndex, int topK) {
        NDArray prob = ((NDArray)output.get(0)).get(new long[]{maskIndex}).softmax(0);
        NDArray array = prob.argSort(0, false);
        long[] classIds = new long[topK];
        ArrayList<Double> probabilities = new ArrayList<Double>(topK);
        for (int i = 0; i < topK; ++i) {
            classIds[i] = array.getLong(new long[]{i});
            probabilities.add(Double.valueOf(prob.getFloat(new long[]{classIds[i]})));
        }
        String[] classes = tokenizer.decode(classIds).trim().split(" ");
        return new Classifications(Arrays.asList(classes), probabilities);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = FillMaskTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private String maskedToken = "[MASK]";
        private int topK = 5;
        private Batchifier batchifier = Batchifier.STACK;

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optMaskToken(String maskedToken) {
            this.maskedToken = maskedToken;
            return this;
        }

        public Builder optTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            this.optMaskToken(ArgumentsUtil.stringValue(arguments, (String)"maskToken", (String)"[MASK]"));
            this.optTopK(ArgumentsUtil.intValue(arguments, (String)"topK", (int)5));
            String batchifierStr = ArgumentsUtil.stringValue(arguments, (String)"batchifier", (String)"stack");
            this.optBatchifier(Batchifier.fromString((String)batchifierStr));
        }

        public FillMaskTranslator build() throws IOException {
            return new FillMaskTranslator(this.tokenizer, this.maskedToken, this.topK, this.batchifier);
        }
    }
}

