/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.securityanalytics.rules.condition.ConditionAND;
import org.opensearch.securityanalytics.rules.condition.ConditionFieldEqualsValueExpression;
import org.opensearch.securityanalytics.rules.condition.ConditionItem;
import org.opensearch.securityanalytics.rules.condition.ConditionOR;
import org.opensearch.securityanalytics.rules.condition.ConditionValueExpression;
import org.opensearch.securityanalytics.rules.exceptions.SigmaConditionError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaDetectionError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaModifierError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaRegularExpressionError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaValueError;
import org.opensearch.securityanalytics.rules.objects.SigmaDetectionItem;
import org.opensearch.securityanalytics.rules.objects.SigmaDetections;
import org.opensearch.securityanalytics.rules.utils.AnyOneOf;
import org.opensearch.securityanalytics.rules.utils.Either;

public class SigmaDetection {
    private List<Either<SigmaDetectionItem, SigmaDetection>> detectionItems;
    private Either<Class<ConditionAND>, Class<ConditionOR>> itemLinking;
    private Either<ConditionItem, SigmaDetection> parent;

    public SigmaDetection(List<Either<SigmaDetectionItem, SigmaDetection>> detectionItems, Either<Class<ConditionAND>, Class<ConditionOR>> itemLinking) throws SigmaDetectionError {
        this.detectionItems = detectionItems;
        Either<Class<ConditionAND>, Class<ConditionOR>> either = this.itemLinking = itemLinking == null ? Either.left(ConditionAND.class) : itemLinking;
        if (this.detectionItems.size() == 0) {
            throw new SigmaDetectionError("Detection is empty");
        }
        ArrayList<Class> typeSet = new ArrayList<Class>();
        for (Either<SigmaDetectionItem, SigmaDetection> detectionItem : detectionItems) {
            if (detectionItem.isLeft()) {
                typeSet.add(SigmaDetectionItem.class);
            }
            if (!detectionItem.isRight()) continue;
            typeSet.add(SigmaDetection.class);
        }
        this.itemLinking = typeSet.contains(SigmaDetectionItem.class) ? Either.left(ConditionAND.class) : Either.right(ConditionOR.class);
    }

    protected static SigmaDetection fromDefinition(Object definition) throws SigmaModifierError, SigmaDetectionError, SigmaValueError, SigmaRegularExpressionError {
        ArrayList<Either<SigmaDetectionItem, SigmaDetection>> detectionItems = new ArrayList<Either<SigmaDetectionItem, SigmaDetection>>();
        if (definition instanceof Map) {
            for (Map.Entry defEntry : ((Map)definition).entrySet()) {
                Object val = defEntry.getValue();
                if (val == null) {
                    detectionItems.add(Either.left(SigmaDetectionItem.fromMapping((String)defEntry.getKey(), Either.left(null))));
                    continue;
                }
                if (val instanceof Integer) {
                    detectionItems.add(Either.left(SigmaDetectionItem.fromMapping((String)defEntry.getKey(), Either.left((Integer)val))));
                    continue;
                }
                if (val instanceof Float) {
                    detectionItems.add(Either.left(SigmaDetectionItem.fromMapping((String)defEntry.getKey(), Either.left((Float)val))));
                    continue;
                }
                if (val instanceof String) {
                    detectionItems.add(Either.left(SigmaDetectionItem.fromMapping((String)defEntry.getKey(), Either.left(val.toString()))));
                    continue;
                }
                if (val instanceof Boolean) {
                    detectionItems.add(Either.left(SigmaDetectionItem.fromMapping((String)defEntry.getKey(), Either.left((Boolean)val))));
                    continue;
                }
                if (!(val instanceof List)) continue;
                SigmaDetectionItem item = SigmaDetectionItem.fromMapping((String)defEntry.getKey(), Either.right((List)val));
                detectionItems.add(Either.left(item));
            }
            return new SigmaDetection(detectionItems, null);
        }
        if (definition instanceof String || definition instanceof Integer) {
            detectionItems.add(Either.left(SigmaDetectionItem.fromValue(Either.left(definition))));
            return new SigmaDetection(detectionItems, null);
        }
        if (definition instanceof ArrayList) {
            List definitionList = (List)definition;
            boolean isItem = true;
            for (Object definitionElem : definitionList) {
                if (definitionElem instanceof String || definitionElem instanceof Integer) continue;
                detectionItems.add(Either.right(SigmaDetection.fromDefinition(definitionElem)));
                isItem = false;
            }
            if (isItem) {
                detectionItems.add(Either.left(SigmaDetectionItem.fromValue(Either.right(definitionList))));
                return new SigmaDetection(detectionItems, null);
            }
            return new SigmaDetection(detectionItems, null);
        }
        throw new SigmaValueError("Unexpected Values");
    }

    public AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression> postProcess(SigmaDetections detections, Object parent) throws SigmaConditionError {
        this.parent = parent instanceof ConditionItem ? Either.left((ConditionItem)parent) : Either.right((SigmaDetection)parent);
        ArrayList<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>> valueExpressions = new ArrayList<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>>();
        for (Either<SigmaDetectionItem, SigmaDetection> detectionItem : this.detectionItems) {
            Either<Either<ConditionAND, ConditionOR>, Either<ConditionFieldEqualsValueExpression, ConditionValueExpression>> item;
            if (detectionItem.isLeft()) {
                item = detectionItem.getLeft().postProcess(detections, this);
                if (item.isLeft() && item.getLeft().isLeft()) {
                    valueExpressions.add(Either.left(AnyOneOf.leftVal((ConditionItem)item.getLeft().getLeft())));
                    continue;
                }
                if (item.isLeft() && item.getLeft().isRight()) {
                    valueExpressions.add(Either.left(AnyOneOf.leftVal((ConditionItem)item.getLeft().get())));
                    continue;
                }
                if (item.isRight() && item.get().isLeft()) {
                    valueExpressions.add(Either.left(AnyOneOf.middleVal(item.get().getLeft())));
                    continue;
                }
                if (!item.isRight() || !item.get().isRight()) continue;
                valueExpressions.add(Either.left(AnyOneOf.rightVal(item.get().get())));
                continue;
            }
            if (!detectionItem.isRight()) continue;
            item = detectionItem.get().postProcess(detections, this);
            valueExpressions.add(Either.left(item));
        }
        if (valueExpressions.size() == 1) {
            return (AnyOneOf)((Either)valueExpressions.get(0)).getLeft();
        }
        if (this.itemLinking.isLeft()) {
            return AnyOneOf.leftVal(new ConditionAND(false, valueExpressions));
        }
        if (this.itemLinking.isRight()) {
            return AnyOneOf.leftVal(new ConditionOR(false, valueExpressions));
        }
        return null;
    }

    public List<Either<SigmaDetectionItem, SigmaDetection>> getDetectionItems() {
        return this.detectionItems;
    }

    public Either<Class<ConditionAND>, Class<ConditionOR>> getItemLinking() {
        return this.itemLinking;
    }
}

