/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateTaskConfig;
import org.opensearch.cluster.ClusterStateTaskExecutor;
import org.opensearch.cluster.ClusterStateTaskListener;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.knn.indices.ModelGraveyard;
import org.opensearch.knn.plugin.transport.UpdateModelGraveyardRequest;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class UpdateModelGraveyardTransportAction
extends TransportClusterManagerNodeAction<UpdateModelGraveyardRequest, AcknowledgedResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateModelGraveyardTransportAction.class);
    private UpdateModelGraveyardExecutor updateModelGraveyardExecutor = new UpdateModelGraveyardExecutor();

    @Inject
    public UpdateModelGraveyardTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/knn_update_model_graveyard_action", transportService, clusterService, threadPool, actionFilters, UpdateModelGraveyardRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput streamInput) throws IOException {
        return new AcknowledgedResponse(streamInput);
    }

    protected void clusterManagerOperation(UpdateModelGraveyardRequest request, ClusterState clusterState, final ActionListener<AcknowledgedResponse> actionListener) {
        this.clusterService.submitStateUpdateTask("knn", (Object)new UpdateModelGraveyardTask(request.getModelId(), request.isRemoveRequest()), ClusterStateTaskConfig.build((Priority)Priority.NORMAL), (ClusterStateTaskExecutor)this.updateModelGraveyardExecutor, new ClusterStateTaskListener(){

            public void onFailure(String s, Exception e) {
                actionListener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                actionListener.onResponse((Object)new AcknowledgedResponse(true));
            }
        });
    }

    protected ClusterBlockException checkBlock(UpdateModelGraveyardRequest request, ClusterState clusterState) {
        return null;
    }

    private static class UpdateModelGraveyardExecutor
    implements ClusterStateTaskExecutor<UpdateModelGraveyardTask> {
        private UpdateModelGraveyardExecutor() {
        }

        public ClusterStateTaskExecutor.ClusterTasksResult<UpdateModelGraveyardTask> execute(ClusterState clusterState, List<UpdateModelGraveyardTask> taskList) {
            ModelGraveyard modelGraveyard;
            Objects.requireNonNull(clusterState, "Cluster state must not be null");
            Objects.requireNonNull(clusterState.metadata(), "Cluster metadata must not be null");
            ModelGraveyard immutableModelGraveyard = (ModelGraveyard)clusterState.metadata().custom("opensearch-knn-blocked-models");
            if (immutableModelGraveyard == null) {
                modelGraveyard = new ModelGraveyard();
            } else {
                HashSet<String> copySet = new HashSet<String>(immutableModelGraveyard.getModelIds());
                modelGraveyard = new ModelGraveyard(copySet);
            }
            for (UpdateModelGraveyardTask task : taskList) {
                if (task.isRemoveRequest()) {
                    modelGraveyard.remove(task.getModelId());
                    continue;
                }
                modelGraveyard.add(task.getModelId());
            }
            Metadata.Builder metaDataBuilder = Metadata.builder((Metadata)clusterState.metadata());
            metaDataBuilder.putCustom("opensearch-knn-blocked-models", (Metadata.Custom)modelGraveyard);
            ClusterState updatedClusterState = ClusterState.builder((ClusterState)clusterState).metadata(metaDataBuilder).build();
            return new ClusterStateTaskExecutor.ClusterTasksResult.Builder().successes(taskList).build(updatedClusterState);
        }
    }

    private static final class UpdateModelGraveyardTask {
        private final String modelId;
        private final boolean isRemoveRequest;

        @Generated
        public UpdateModelGraveyardTask(String modelId, boolean isRemoveRequest) {
            this.modelId = modelId;
            this.isRemoveRequest = isRemoveRequest;
        }

        @Generated
        public String getModelId() {
            return this.modelId;
        }

        @Generated
        public boolean isRemoveRequest() {
            return this.isRemoveRequest;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateModelGraveyardTask)) {
                return false;
            }
            UpdateModelGraveyardTask other = (UpdateModelGraveyardTask)o;
            if (this.isRemoveRequest() != other.isRemoveRequest()) {
                return false;
            }
            String this$modelId = this.getModelId();
            String other$modelId = other.getModelId();
            return !(this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRemoveRequest() ? 79 : 97);
            String $modelId = this.getModelId();
            result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UpdateModelGraveyardTransportAction.UpdateModelGraveyardTask(modelId=" + this.getModelId() + ", isRemoveRequest=" + this.isRemoveRequest() + ")";
        }
    }
}

