/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene92;

import java.util.Objects;
import org.apache.lucene.backward_codecs.lucene90.Lucene90FieldInfosFormat;
import org.apache.lucene.backward_codecs.lucene92.Lucene92HnswVectorsFormat;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90CompoundFormat;
import org.apache.lucene.codecs.lucene90.Lucene90DocValuesFormat;
import org.apache.lucene.codecs.lucene90.Lucene90LiveDocsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90NormsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90PointsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90PostingsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90SegmentInfoFormat;
import org.apache.lucene.codecs.lucene90.Lucene90StoredFieldsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90TermVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;

public class Lucene92Codec
extends Codec {
    private final TermVectorsFormat vectorsFormat = new Lucene90TermVectorsFormat();
    private final FieldInfosFormat fieldInfosFormat = new Lucene90FieldInfosFormat();
    private final SegmentInfoFormat segmentInfosFormat = new Lucene90SegmentInfoFormat();
    private final LiveDocsFormat liveDocsFormat = new Lucene90LiveDocsFormat();
    private final CompoundFormat compoundFormat = new Lucene90CompoundFormat();
    private final NormsFormat normsFormat = new Lucene90NormsFormat();
    private final PostingsFormat defaultPostingsFormat;
    private final PostingsFormat postingsFormat = new PerFieldPostingsFormat(){

        public PostingsFormat getPostingsFormatForField(String field) {
            return Lucene92Codec.this.getPostingsFormatForField(field);
        }
    };
    private final DocValuesFormat defaultDVFormat;
    private final DocValuesFormat docValuesFormat = new PerFieldDocValuesFormat(){

        public DocValuesFormat getDocValuesFormatForField(String field) {
            return Lucene92Codec.this.getDocValuesFormatForField(field);
        }
    };
    private final KnnVectorsFormat defaultKnnVectorsFormat;
    private final KnnVectorsFormat knnVectorsFormat = new PerFieldKnnVectorsFormat(){

        public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
            return Lucene92Codec.this.getKnnVectorsFormatForField(field);
        }
    };
    private final StoredFieldsFormat storedFieldsFormat;

    public Lucene92Codec() {
        this(Mode.BEST_SPEED);
    }

    public Lucene92Codec(Mode mode) {
        super("Lucene92");
        this.storedFieldsFormat = new Lucene90StoredFieldsFormat(Objects.requireNonNull(mode).storedMode);
        this.defaultPostingsFormat = new Lucene90PostingsFormat();
        this.defaultDVFormat = new Lucene90DocValuesFormat();
        this.defaultKnnVectorsFormat = new Lucene92HnswVectorsFormat();
    }

    public final StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public final TermVectorsFormat termVectorsFormat() {
        return this.vectorsFormat;
    }

    public final PostingsFormat postingsFormat() {
        return this.postingsFormat;
    }

    public final FieldInfosFormat fieldInfosFormat() {
        return this.fieldInfosFormat;
    }

    public final SegmentInfoFormat segmentInfoFormat() {
        return this.segmentInfosFormat;
    }

    public final LiveDocsFormat liveDocsFormat() {
        return this.liveDocsFormat;
    }

    public final CompoundFormat compoundFormat() {
        return this.compoundFormat;
    }

    public final PointsFormat pointsFormat() {
        return new Lucene90PointsFormat();
    }

    public KnnVectorsFormat knnVectorsFormat() {
        return this.knnVectorsFormat;
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        return this.defaultPostingsFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.defaultDVFormat;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        return this.defaultKnnVectorsFormat;
    }

    public final DocValuesFormat docValuesFormat() {
        return this.docValuesFormat;
    }

    public final NormsFormat normsFormat() {
        return this.normsFormat;
    }

    public static enum Mode {
        BEST_SPEED(Lucene90StoredFieldsFormat.Mode.BEST_SPEED),
        BEST_COMPRESSION(Lucene90StoredFieldsFormat.Mode.BEST_COMPRESSION);

        private final Lucene90StoredFieldsFormat.Mode storedMode;

        private Mode(Lucene90StoredFieldsFormat.Mode storedMode) {
            this.storedMode = Objects.requireNonNull(storedMode);
        }
    }
}

