/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r}s!B)S\u0011\u00039f!B-S\u0011\u0003Q\u0006\"B1\u0002\t\u0003\u0011\u0007\u0002C2\u0002\u0005\u0004%\tA\u00153\t\r5\f\u0001\u0015!\u0003f\u0011\u0015q\u0017\u0001\"\u0001p\u0011\u001d\t)!\u0001C\u0005\u0003\u000fAq!!\u0007\u0002\t\u0013\tY\u0002\u0003\u0005\u0002 \u0005!\tAUA\u0011\u0011!\ty'\u0001C\u0001%\u0006EdACAe\u0003A\u0005\u0019\u0013\u0001+\u0002L\"9\u0011q\u001a\u0006\u0007\u0002\u0005EgA\u0002B\u000b\u0003\u0011\u00119\u0002\u0003\u0006\u0003&1\u0011\t\u0011)A\u0005\u0005OA!Ba\r\r\u0005\u0003\u0005\u000b\u0011\u0002B\u001b\u0011\u0019\tG\u0002\"\u0001\u00038!9\u0011q\u001a\u0007\u0005B\t}\u0002b\u0002B%\u0003\u0011%!1\n\u0005\b\u0005o\nA\u0011\u0002B=\r\u0019\t\t)\u0001\u0001\u0002\u0004\"1\u0011m\u0005C\u0001\u0003\u000bC\u0011\"a\"\u0014\u0005\u0004%\t!!#\t\u0011\u0005M5\u0003)A\u0005\u0003\u0017C\u0011\"!&\u0014\u0005\u0004%\t!!#\t\u0011\u0005]5\u0003)A\u0005\u0003\u0017C\u0011\"!'\u0014\u0005\u0004%\t!!#\t\u0011\u0005m5\u0003)A\u0005\u0003\u0017Cq!!(\u0014\t\u0003\ty\nC\u0004\u0002,N!\t!!,\t\u000f\u0005]6\u0003\"\u0001\u0002:\"9\u0011QY\n\u0005\u0002\u0005\u001dgA\u0002BI\u0003\u0011\u0011\u0019\n\u0003\u0004b?\u0011\u0005!q\u0013\u0005\b\u0003\u001f|B\u0011\tBN\r\u0019\u0011\u0019+\u0001\u0003\u0003&\"1\u0011M\tC\u0001\u0005OCq!a4#\t\u0003\u0012YK\u0002\u0004\u00030\u0006!!\u0011\u0017\u0005\u0007C\u0016\"\tAa-\t\u0013\t]VE1A\u0005\u0002\te\u0006\u0002\u0003BdK\u0001\u0006IAa/\t\u000f\u0005=W\u0005\"\u0011\u0003J\u001a1!QZ\u0001\u0005\u0005\u001fD!\u0002\u001e\u0016\u0003\u0002\u0003\u0006I!\u001eBo\u0011\u0019\t'\u0006\"\u0001\u0003`\"I!Q\u001d\u0016C\u0002\u0013\u0005!q\u001d\u0005\t\u0005kT\u0003\u0015!\u0003\u0003j\"I!q\u001f\u0016C\u0002\u0013\u0005!q\u001d\u0005\t\u0005sT\u0003\u0015!\u0003\u0003j\"I!1 \u0016C\u0002\u0013\u0005!q\u001d\u0005\t\u0005{T\u0003\u0015!\u0003\u0003j\"I!q \u0016C\u0002\u0013\u00051\u0011\u0001\u0005\t\u0007\u0013Q\u0003\u0015!\u0003\u0004\u0004!I11\u0002\u0016C\u0002\u0013\u00051Q\u0002\u0005\t\u0007/Q\u0003\u0015!\u0003\u0004\u0010!I1\u0011\u0004\u0016C\u0002\u0013\u00051Q\u0002\u0005\t\u00077Q\u0003\u0015!\u0003\u0004\u0010!I1Q\u0004\u0016C\u0002\u0013\u0005!q\u001d\u0005\t\u0007?Q\u0003\u0015!\u0003\u0003j\"I1\u0011\u0005\u0016C\u0002\u0013\u000511\u0005\u0005\t\u0007OQ\u0003\u0015!\u0003\u0004&!I1\u0011\u0006\u0016C\u0002\u0013\u000511\u0005\u0005\t\u0007WQ\u0003\u0015!\u0003\u0004&!I1Q\u0006\u0016C\u0002\u0013\u0005!q\u001d\u0005\t\u0007_Q\u0003\u0015!\u0003\u0003j\"I1\u0011\u0007\u0016C\u0002\u0013\u0005!q\u001d\u0005\t\u0007gQ\u0003\u0015!\u0003\u0003j\"I1Q\u0007\u0016C\u0002\u0013\u0005!q\u001d\u0005\t\u0007oQ\u0003\u0015!\u0003\u0003j\"I1\u0011\b\u0016C\u0002\u0013\u0005!q\u001d\u0005\t\u0007wQ\u0003\u0015!\u0003\u0003j\"91Q\b\u0016\u0005\u0002\r}\u0002BCB)U!\u0015\r\u0011\"\u0001\u0004T!Q!\u0011\u000f\u0016\t\u0006\u0004%\taa\u0015\t\u0015\te#\u0006#b\u0001\n\u0003\u0019\u0019\u0006\u0003\u0006\u00022)B)\u0019!C\u0001\u0007'B!\"a\n+\u0011\u000b\u0007I\u0011AB*\u0011)\u0019)F\u000bEC\u0002\u0013\u00051q\u000b\u0005\u000b\u0003OR\u0003R1A\u0005\u0002\rm\u0003B\u0003B;U!\u0015\r\u0011\"\u0001\u0004\\!91Q\f\u0016\u0005\u0002\u0005\u001d\u0017a\u0004#v[BdunZ*fO6,g\u000e^:\u000b\u0005M#\u0016!\u0002;p_2\u001c(\"A+\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001,A\u0007\u0002%\nyA)^7q\u0019><7+Z4nK:$8o\u0005\u0002\u00027B\u0011AlX\u0007\u0002;*\ta,A\u0003tG\u0006d\u0017-\u0003\u0002a;\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A,\u0002\u0019I+7m\u001c:e\u0013:$WM\u001c;\u0016\u0003\u0015\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\t1\fgn\u001a\u0006\u0002U\u0006!!.\u0019<b\u0013\tawM\u0001\u0004TiJLgnZ\u0001\u000e%\u0016\u001cwN\u001d3J]\u0012,g\u000e\u001e\u0011\u0002\t5\f\u0017N\u001c\u000b\u0003aN\u0004\"\u0001X9\n\u0005Il&\u0001B+oSRDQ\u0001^\u0003A\u0002U\fA!\u0019:hgB\u0019AL\u001e=\n\u0005]l&!B!se\u0006L\bcA=\u0002\u00029\u0011!P \t\u0003wvk\u0011\u0001 \u0006\u0003{Z\u000ba\u0001\u0010:p_Rt\u0014BA@^\u0003\u0019\u0001&/\u001a3fM&\u0019A.a\u0001\u000b\u0005}l\u0016\u0001\u00043v[B$\u0006P\\%oI\u0016DHc\u00019\u0002\n!9\u00111\u0002\u0004A\u0002\u00055\u0011\u0001\u00024jY\u0016\u0004B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'I\u0017AA5p\u0013\u0011\t9\"!\u0005\u0003\t\u0019KG.Z\u0001\u0017IVl\u0007\u000f\u0015:pIV\u001cWM]%e':\f\u0007o\u001d5piR\u0019\u0001/!\b\t\u000f\u0005-q\u00011\u0001\u0002\u000e\u0005IA-^7q\u0013:$W\r\u001f\u000b\fa\u0006\r\u0012QEA\u0018\u0003g\t)\u0007C\u0004\u0002\f!\u0001\r!!\u0004\t\u000f\u0005\u001d\u0002\u00021\u0001\u0002*\u0005y\u0011N\u001c3fqN\u000bg.\u001b;z\u001f:d\u0017\u0010E\u0002]\u0003WI1!!\f^\u0005\u001d\u0011un\u001c7fC:Dq!!\r\t\u0001\u0004\tI#\u0001\u0006wKJLg-_(oYfDq!!\u000e\t\u0001\u0004\t9$\u0001\u000enSNl\u0015\r^2iKN4uN]%oI\u0016Dh)\u001b7fg6\u000b\u0007\u000fE\u0004\u0002:\u0005\r\u00030a\u0012\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\tq!\\;uC\ndWMC\u0002\u0002Bu\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)%a\u000f\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0002J\u0005M\u0013\u0011\f\b\u0005\u0003\u0017\nyED\u0002|\u0003\u001bJ\u0011AX\u0005\u0004\u0003#j\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003+\n9F\u0001\u0003MSN$(bAA);B9A,a\u0017\u0002`\u0005}\u0013bAA/;\n1A+\u001e9mKJ\u00022\u0001XA1\u0013\r\t\u0019'\u0018\u0002\u0005\u0019>tw\rC\u0004\u0002h!\u0001\r!!\u001b\u0002\u001d5\f\u00070T3tg\u0006<WmU5{KB\u0019A,a\u001b\n\u0007\u00055TLA\u0002J]R\fQ\u0002Z;naRKW.Z%oI\u0016DH#\u00039\u0002t\u0005U\u0014qOA=\u0011\u001d\tY!\u0003a\u0001\u0003\u001bAq!a\n\n\u0001\u0004\tI\u0003C\u0004\u00022%\u0001\r!!\u000b\t\u000f\u0005m\u0014\u00021\u0001\u0002~\u0005\u0019B/[7f\u0013:$W\r\u001f#v[B,%O]8sgB\u0019\u0011qP\n\u000e\u0003\u0005\u00111\u0003V5nK&sG-\u001a=Ek6\u0004XI\u001d:peN\u001c\"aE.\u0015\u0005\u0005u\u0014AH7jg6\u000bGo\u00195fg\u001a{'\u000fV5nK&sG-\u001a=GS2,7/T1q+\t\tY\tE\u0004\u0002:\u0005\r\u00030!$\u0011\r\u0005e\u0012qRA-\u0013\u0011\t\t*a\u000f\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM]\u0001 [&\u001cX*\u0019;dQ\u0016\u001chi\u001c:US6,\u0017J\u001c3fq\u001aKG.Z:NCB\u0004\u0013aE8vi>3wJ\u001d3feRKW.Z:uC6\u0004\u0018\u0001F8vi>3wJ\u001d3feRKW.Z:uC6\u0004\b%A\u000btQ\u0006dGn\\<PM\u001a\u001cX\r\u001e(pi\u001a{WO\u001c3\u0002-MD\u0017\r\u001c7po>3gm]3u\u001d>$hi\\;oI\u0002\nqC]3d_J$W*[:nCR\u001c\u0007\u000eV5nK&sG-\u001a=\u0015\u000fA\f\t+a)\u0002(\"9\u00111B\u000eA\u0002\u00055\u0001bBAS7\u0001\u0007\u0011qL\u0001\u000fS:$W\r\u001f+j[\u0016\u001cH/Y7q\u0011\u001d\tIk\u0007a\u0001\u0003?\nA\u0002\\8h)&lWm\u001d;b[B\faD]3d_J$w*\u001e;PM>\u0013H-\u001a:J]\u0012,\u0007\u0010V5nKN$\u0018-\u001c9\u0015\u000fA\fy+!-\u00024\"9\u00111\u0002\u000fA\u0002\u00055\u0001bBAS9\u0001\u0007\u0011q\f\u0005\b\u0003kc\u0002\u0019AA0\u0003I\u0001(/\u001a<J]\u0012,\u0007\u0010V5nKN$\u0018-\u001c9\u00027I,7m\u001c:e'\"\fG\u000e\\8x\u001f\u001a47/\u001a;O_R4u.\u001e8e)\u001d\u0001\u00181XA_\u0003\u0003Dq!a\u0003\u001e\u0001\u0004\ti\u0001C\u0004\u0002@v\u0001\r!a\u0018\u0002\u0017%tG-\u001a=PM\u001a\u001cX\r\u001e\u0005\b\u0003\u0007l\u0002\u0019AA0\u0003%awnZ(gMN,G/A\u0006qe&tG/\u0012:s_J\u001cH#\u00019\u0003\u001b5+7o]1hKB\u000b'o]3s+\u0019\ti-a8\u0002vN\u0011!bW\u0001\u0006a\u0006\u00148/\u001a\u000b\u0005\u0003'\fI\u0010E\u0004]\u00037\n).!=\u0011\u000bq\u000b9.a7\n\u0007\u0005eWL\u0001\u0004PaRLwN\u001c\t\u0005\u0003;\fy\u000e\u0004\u0001\u0005\u000f\u0005\u0005(B1\u0001\u0002d\n\t1*\u0005\u0003\u0002f\u0006-\bc\u0001/\u0002h&\u0019\u0011\u0011^/\u0003\u000f9{G\u000f[5oOB\u0019A,!<\n\u0007\u0005=XLA\u0002B]f\u0004R\u0001XAl\u0003g\u0004B!!8\u0002v\u00129\u0011q\u001f\u0006C\u0002\u0005\r(!\u0001,\t\u000f\u0005m8\u00021\u0001\u0002~\u00061!/Z2pe\u0012\u0004B!a@\u0003\u00125\u0011!\u0011\u0001\u0006\u0005\u0003w\u0014\u0019A\u0003\u0003\u0003\u0006\t\u001d\u0011AB2p[6|gNC\u0002V\u0005\u0013QAAa\u0003\u0003\u000e\u00051\u0011\r]1dQ\u0016T!Aa\u0004\u0002\u0007=\u0014x-\u0003\u0003\u0003\u0014\t\u0005!A\u0002*fG>\u0014HM\u0001\u000bEK\u000e|G-\u001a:NKN\u001c\u0018mZ3QCJ\u001cXM]\u000b\u0007\u00053\u0011yBa\t\u0014\t1Y&1\u0004\t\b\u0003\u007fR!Q\u0004B\u0011!\u0011\tiNa\b\u0005\u000f\u0005\u0005HB1\u0001\u0002dB!\u0011Q\u001cB\u0012\t\u001d\t9\u0010\u0004b\u0001\u0003G\f!b[3z\t\u0016\u001cw\u000eZ3s!\u0019\u0011ICa\f\u0003\u001e5\u0011!1\u0006\u0006\u0004\u0005[!\u0016AC:fe&\fG.\u001b>fe&!!\u0011\u0007B\u0016\u0005\u001d!UmY8eKJ\fAB^1mk\u0016$UmY8eKJ\u0004bA!\u000b\u00030\t\u0005BC\u0002B\u001d\u0005w\u0011i\u0004E\u0004\u0002\u00001\u0011iB!\t\t\u000f\t\u0015r\u00021\u0001\u0003(!9!1G\bA\u0002\tUB\u0003\u0002B!\u0005\u000f\u0002r\u0001XA.\u0005\u0007\u0012)\u0005E\u0003]\u0003/\u0014i\u0002E\u0003]\u0003/\u0014\t\u0003C\u0004\u0002|B\u0001\r!!@\u0002\u000f\u0011,X\u000e\u001d'pORy\u0001O!\u0014\u0003P\tM#q\u000bB.\u0005_\u0012\u0019\bC\u0004\u0002\fE\u0001\r!!\u0004\t\u000f\tE\u0013\u00031\u0001\u0002*\u0005i\u0001O]5oi\u000e{g\u000e^3oiNDqA!\u0016\u0012\u0001\u0004\t9$A\u0011o_:\u001cuN\\:fGV$\u0018N^3QC&\u00148OR8s\u0019><g)\u001b7fg6\u000b\u0007\u000fC\u0004\u0003ZE\u0001\r!!\u000b\u0002\u001f%\u001cH)Z3q\u0013R,'/\u0019;j_:DqA!\u0018\u0012\u0001\u0004\u0011y&\u0001\u0004qCJ\u001cXM\u001d\u0019\u0007\u0005C\u0012)Ga\u001b\u0011\u000f\u0005}$Ba\u0019\u0003jA!\u0011Q\u001cB3\t1\u00119Ga\u0017\u0002\u0002\u0003\u0005)\u0011AAr\u0005\ryF%\r\t\u0005\u0003;\u0014Y\u0007\u0002\u0007\u0003n\tm\u0013\u0011!A\u0001\u0006\u0003\t\u0019OA\u0002`IIBqA!\u001d\u0012\u0001\u0004\tI#\u0001\ntW&\u0004(+Z2pe\u0012lU\r^1eCR\f\u0007b\u0002B;#\u0001\u0007\u0011\u0011N\u0001\t[\u0006D()\u001f;fg\u0006y\u0001O]5oi\n\u000bGo\u00195MKZ,G\u000eF\u0003q\u0005w\u0012i\tC\u0004\u0003~I\u0001\rAa \u0002\u000b\t\fGo\u00195\u0011\t\t\u0005%q\u0011\b\u0005\u0003\u007f\u0014\u0019)\u0003\u0003\u0003\u0006\n\u0005\u0011A\u0005$jY\u0016dunZ%oaV$8\u000b\u001e:fC6LAA!#\u0003\f\n1b)\u001b7f\u0007\"\fgN\\3m%\u0016\u001cwN\u001d3CCR\u001c\u0007N\u0003\u0003\u0003\u0006\n\u0005\u0001b\u0002BH%\u0001\u0007\u0011qL\u0001\u0012C\u000e\u001cW/\\;mCRLg/\u001a\"zi\u0016\u001c(\u0001F(gMN,Go]'fgN\fw-\u001a)beN,'o\u0005\u0003 7\nU\u0005#BA@\u0015aDHC\u0001BM!\r\tyh\b\u000b\u0005\u0005;\u0013\t\u000bE\u0004]\u00037\u0012yJa(\u0011\tq\u000b9\u000e\u001f\u0005\b\u0003w\f\u0003\u0019AA\u007f\u0005m!&/\u00198tC\u000e$\u0018n\u001c8M_\u001elUm]:bO\u0016\u0004\u0016M]:feN!!e\u0017BK)\t\u0011I\u000bE\u0002\u0002\u0000\t\"BA!(\u0003.\"9\u00111 \u0013A\u0002\u0005u(aH\"mkN$XM]'fi\u0006$\u0017\r^1M_\u001elUm]:bO\u0016\u0004\u0016M]:feN!Qe\u0017BK)\t\u0011)\fE\u0002\u0002\u0000\u0015\n1#\\3uC\u0012\fG/\u0019*fG>\u0014HmU3sI\u0016,\"Aa/\u0011\t\tu&1Y\u0007\u0003\u0005\u007fSAA!1\u0003\b\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0003F\n}&aE'fi\u0006$\u0017\r^1SK\u000e|'\u000fZ*fe\u0012,\u0017\u0001F7fi\u0006$\u0017\r^1SK\u000e|'\u000fZ*fe\u0012,\u0007\u0005\u0006\u0003\u0003\u001e\n-\u0007bBA~S\u0001\u0007\u0011Q \u0002\u0017\tVl\u0007\u000fT8h'\u0016<W.\u001a8ug>\u0003H/[8ogN\u0019!F!5\u0011\t\tM'\u0011\\\u0007\u0003\u0005+T1Aa6U\u0003\u0015)H/\u001b7t\u0013\u0011\u0011YN!6\u0003+\r{W.\\1oI\u0012+g-Y;mi>\u0003H/[8og&\u0019AO!7\u0015\t\t\u0005(1\u001d\t\u0004\u0003\u007fR\u0003\"\u0002;-\u0001\u0004)\u0018\u0001\u00039sS:$x\n\u001d;\u0016\u0005\t%\b\u0003\u0002Bv\u0005cl!A!<\u000b\u0005\t=\u0018A\u00036paR\u001c\u0018.\u001c9mK&!!1\u001fBw\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM]\u0001\naJLg\u000e^(qi\u0002\n\u0011B^3sS\u001aLx\n\u001d;\u0002\u0015Y,'/\u001b4z\u001fB$\b%\u0001\bj]\u0012,\u0007pU1oSRLx\n\u001d;\u0002\u001f%tG-\u001a=TC:LG/_(qi\u0002\n\u0001BZ5mKN|\u0005\u000f^\u000b\u0003\u0007\u0007\u0001RAa;\u0004\u0006aLAaa\u0002\u0003n\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000e\f\u0011BZ5mKN|\u0005\u000f\u001e\u0011\u0002#5\f\u00070T3tg\u0006<WmU5{K>\u0003H/\u0006\u0002\u0004\u0010A1!1^B\u0003\u0007#\u00012AZB\n\u0013\r\u0019)b\u001a\u0002\b\u0013:$XmZ3s\u0003Ii\u0017\r_'fgN\fw-Z*ju\u0016|\u0005\u000f\u001e\u0011\u0002\u00175\f\u0007PQ=uKN|\u0005\u000f^\u0001\r[\u0006D()\u001f;fg>\u0003H\u000fI\u0001\u0011I\u0016,\u0007/\u0013;fe\u0006$\u0018n\u001c8PaR\f\u0011\u0003Z3fa&#XM]1uS>tw\n\u001d;!\u0003=1\u0018\r\\;f\t\u0016\u001cw\u000eZ3s\u001fB$XCAB\u0013!\u0015\u0011Yo!\u0002f\u0003A1\u0018\r\\;f\t\u0016\u001cw\u000eZ3s\u001fB$\b%A\u0007lKf$UmY8eKJ|\u0005\u000f^\u0001\u000fW\u0016LH)Z2pI\u0016\u0014x\n\u001d;!\u0003)ygMZ:fiN|\u0005\u000f^\u0001\f_\u001a47/\u001a;t\u001fB$\b%A\tue\u0006t7/Y2uS>tGj\\4PaR\f!\u0003\u001e:b]N\f7\r^5p]2{wm\u00149uA\u0005\u00112\r\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00149u\u0003M\u0019G.^:uKJlU\r^1eCR\fw\n\u001d;!\u0003U\u00198.\u001b9SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1PaR\fac]6jaJ+7m\u001c:e\u001b\u0016$\u0018\rZ1uC>\u0003H\u000fI\u0001\u000e[\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0016\u0005\r\u0005\u0003GBB\"\u0007\u000f\u001ai\u0005E\u0004\u0002\u0000)\u0019)ea\u0013\u0011\t\u0005u7q\t\u0003\f\u0007\u0013:\u0015\u0011!A\u0001\u0006\u0003\t\u0019OA\u0002`IM\u0002B!!8\u0004N\u0011Y1qJ$\u0002\u0002\u0003\u0005)\u0011AAr\u0005\ryF\u0005N\u0001\u0013g\"|W\u000f\u001c3Qe&tG\u000fR1uC2{w-\u0006\u0002\u0002*\u0005)a-\u001b7fgV\u00111\u0011\f\t\u00049Z,WCAA5\u0003%\u0019\u0007.Z2l\u0003J<7\u000f")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    private static class ClusterMetadataLogMessageParser
    implements MessageParser<String, String> {
        private final MetadataRecordSerde metadataRecordSerde = new MetadataRecordSerde();

        public MetadataRecordSerde metadataRecordSerde() {
            return this.metadataRecordSerde;
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            String string;
            try {
                ApiMessageAndVersion messageAndVersion = this.metadataRecordSerde().read((Readable)new ByteBufferAccessor(record.value()), record.valueSize());
                ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
                json.set("type", (JsonNode)new TextNode(MetadataRecordType.fromId((short)messageAndVersion.message().apiKey()).toString()));
                json.set("version", (JsonNode)new IntNode((int)messageAndVersion.version()));
                json.set("data", MetadataJsonConverters.writeJson((ApiMessage)messageAndVersion.message(), (short)messageAndVersion.version()));
                string = json.toString();
            }
            catch (Throwable e) {
                string = new StringBuilder(21).append("Error at ").append(record.offset()).append(", skipping. ").append(e.getMessage()).toString();
            }
            String output = string;
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)output));
        }
    }

    private static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record) {
            None$ key;
            Object object = key = record.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.key()))) : None$.MODULE$;
            if (!record.hasValue()) {
                return new Tuple2((Object)key, (Object)None$.MODULE$);
            }
            Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.value())));
            return new Tuple2((Object)key, (Object)payload);
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    private static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private boolean shouldPrintDataLog;
        private boolean skipRecordMetadata;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private int maxBytes;
        private final OptionSpecBuilder printOpt = this.parser().accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        private final OptionSpecBuilder indexSanityOpt = this.parser().accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        private final ArgumentAcceptingOptionSpec<String> filesOpt = this.parser().accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = this.parser().accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> maxBytesOpt = this.parser().accepts("max-bytes", "Limit the amount of total batches read in bytes avoiding reading the whole .log file(s).").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
        private final OptionSpecBuilder deepIterationOpt = this.parser().accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt = this.parser().accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt = this.parser().accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final OptionSpecBuilder offsetsOpt = this.parser().accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        private final OptionSpecBuilder transactionLogOpt = this.parser().accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
        private final OptionSpecBuilder clusterMetadataOpt = this.parser().accepts("cluster-metadata-decoder", "if set, log data will be parsed as cluster metadata records.");
        private final OptionSpecBuilder skipRecordMetadataOpt = this.parser().accepts("skip-record-metadata", "whether to skip printing metadata for each record.");
        private volatile byte bitmap$0;

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxBytesOpt() {
            return this.maxBytesOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public OptionSpecBuilder clusterMetadataOpt() {
            return this.clusterMetadataOpt;
        }

        public OptionSpecBuilder skipRecordMetadataOpt() {
            return this.skipRecordMetadataOpt;
        }

        public MessageParser<?, ?> messageParser() {
            if (this.options().has((OptionSpec)this.offsetsOpt())) {
                return new OffsetsMessageParser();
            }
            if (this.options().has((OptionSpec)this.transactionLogOpt())) {
                return new TransactionLogMessageParser();
            }
            if (this.options().has((OptionSpec)this.clusterMetadataOpt())) {
                return new ClusterMetadataLogMessageParser();
            }
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.valueDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.keyDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            return new DecoderMessageParser(keyDecoder, valueDecoder);
        }

        private boolean shouldPrintDataLog$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options().has((OptionSpec)this.printOpt()) || this.options().has((OptionSpec)this.offsetsOpt()) || this.options().has((OptionSpec)this.transactionLogOpt()) || this.options().has((OptionSpec)this.clusterMetadataOpt()) || this.options().has(this.valueDecoderOpt()) || this.options().has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.shouldPrintDataLog;
        }

        public boolean shouldPrintDataLog() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.shouldPrintDataLog$lzycompute();
            }
            return this.shouldPrintDataLog;
        }

        private boolean skipRecordMetadata$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.skipRecordMetadata = this.options().has((OptionSpec)this.skipRecordMetadataOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.skipRecordMetadata;
        }

        public boolean skipRecordMetadata() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.skipRecordMetadata$lzycompute();
            }
            return this.skipRecordMetadata;
        }

        private boolean isDeepIteration$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.isDeepIteration = this.options().has((OptionSpec)this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            return this.isDeepIteration;
        }

        public boolean isDeepIteration() {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                return this.isDeepIteration$lzycompute();
            }
            return this.isDeepIteration;
        }

        private boolean verifyOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.verifyOnly = this.options().has((OptionSpec)this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
            }
            return this.verifyOnly;
        }

        public boolean verifyOnly() {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                return this.verifyOnly$lzycompute();
            }
            return this.verifyOnly;
        }

        private boolean indexSanityOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.indexSanityOnly = this.options().has((OptionSpec)this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
            }
            return this.indexSanityOnly;
        }

        public boolean indexSanityOnly() {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                return this.indexSanityOnly$lzycompute();
            }
            return this.indexSanityOnly;
        }

        private String[] files$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.files = ((String)this.options().valueOf(this.filesOpt())).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
            }
            return this.files;
        }

        public String[] files() {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                return this.files$lzycompute();
            }
            return this.files;
        }

        private int maxMessageSize$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x40) == 0) {
                    this.maxMessageSize = (Integer)this.options().valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
                }
            }
            return this.maxMessageSize;
        }

        public int maxMessageSize() {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                return this.maxMessageSize$lzycompute();
            }
            return this.maxMessageSize;
        }

        private int maxBytes$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x80) == 0) {
                    this.maxBytes = (Integer)this.options().valueOf(this.maxBytesOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
                }
            }
            return this.maxBytes;
        }

        public int maxBytes() {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                return this.maxBytes$lzycompute();
            }
            return this.maxBytes;
        }

        public void checkArgs() {
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.filesOpt()}));
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
            this.options_$eq(this.parser().parse(super.args()));
        }
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    private static class OffsetsMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return GroupMetadataManager$.MODULE$.formatRecordKeyAndValue(record);
        }
    }

    public static class TimeIndexDumpErrors {
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (misMatchesSeq.isEmpty()) {
                this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
            }
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (outOfOrderSeq.isEmpty()) {
                this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq);
            }
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (shallowOffsetNotFoundSeq.isEmpty()) {
                this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq);
            }
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$1(x0$1);
                return BoxedUnit.UNIT;
            });
            this.outOfOrderTimestamp().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$3(x0$2);
                return BoxedUnit.UNIT;
            });
            this.shallowOffsetNotFound().values().foreach((Function1 & Serializable & scala.Serializable)listOfShallowOffsetNotFound -> {
                TimeIndexDumpErrors.$anonfun$printErrors$5(listOfShallowOffsetNotFound);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$printErrors$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                String fileName = (String)x0$1._1();
                ArrayBuffer listOfMismatches = (ArrayBuffer)x0$1._2();
                System.err.println(new StringBuilder(29).append("Found timestamp mismatch in :").append(fileName).toString());
                listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$3(Tuple2 x0$2) {
            if (x0$2 != null) {
                String fileName = (String)x0$2._1();
                ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)x0$2._2();
                System.err.println(new StringBuilder(33).append("Found out of order timestamp in :").append(fileName).toString());
                outOfOrderTimestamps.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$6(Tuple2 x0$3) {
            if (x0$3 != null) {
                long indexedOffset = x0$3._1$mcJ$sp();
                long logOffset = x0$3._2$mcJ$sp();
                System.err.println(new StringBuilder(36).append("Indexed offset: ").append(indexedOffset).append(", found log offset: ").append(logOffset).toString());
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$5(ArrayBuffer listOfShallowOffsetNotFound) {
            System.err.println("The following indexed offsets are not found in the log.");
            listOfShallowOffsetNotFound.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$6(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return TransactionLog$.MODULE$.formatRecordKeyAndValue(record);
        }
    }
}

